/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.RestrictToDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationOrigin;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.model.LintModelMavenName;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnknownExpression;
import org.jetbrains.uast.UastEmptyExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0018\u001a\u00020\t*\u00020\u0019H\u0002J0\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0007H\u0002J<\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010#\u001a\u00020\tH\u0002JD\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010#\u001a\u00020\tH\u0002J<\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020)2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableAnnotations", "", "", "inheritAnnotation", "", "annotation", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "isTestContext", "Lorg/jetbrains/uast/UAnnotated;", "checkVisibleForTesting", "node", "member", "Lcom/intellij/psi/PsiMember;", "Lorg/jetbrains/uast/UAnnotation;", "reportVisibilityError", "desc", "checkRestrictTo", "method", "applyClassAnnotationsToMembers", "scope", "", "reportRestriction", "where", "containingClass", "Lcom/intellij/psi/PsiClass;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nRestrictToDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestrictToDetector.kt\ncom/android/tools/lint/checks/RestrictToDetector\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,837:1\n18#2:838\n*S KotlinDebug\n*F\n+ 1 RestrictToDetector.kt\ncom/android/tools/lint/checks/RestrictToDetector\n*L\n122#1:838\n*E\n"})
public final class RestrictToDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RestrictToDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String INTELLIJ_VISIBLE_FOR_TESTING_ANNOTATION = "org.jetbrains.annotations.VisibleForTesting";
    @NotNull
    private static final String VISIBLE_FOR_TESTING_SUFFIX = ".VisibleForTesting";
    @NotNull
    private static final String ATTR_OTHERWISE = "otherwise";
    @NotNull
    private static final String ATTR_PRODUCTION_VISIBILITY = "productionVisibility";
    @NotNull
    private static final String ATTR_VISIBILITY = "visibility";
    @NotNull
    private static final String COMPOSABLE_ANNOTATION = "androidx.compose.runtime.Composable";
    @NotNull
    private static final String COMPOSE_PREVIEW = "androidx.compose.ui.tooling.preview.Preview";
    @NotNull
    private static final String COMPOSE_DESKTOP_PREVIEW = "androidx.compose.desktop.ui.tooling.preview.Preview";
    public static final int VISIBILITY_PRIVATE = 2;
    private static final int VISIBILITY_PACKAGE_PRIVATE = 3;
    public static final int VISIBILITY_PROTECTED = 4;
    private static final int VISIBILITY_NONE = 5;
    private static final int VISIBILITY_PUBLIC = 6;
    private static final int RESTRICT_TO_LIBRARY_GROUP = 1;
    private static final int RESTRICT_TO_LIBRARY = 2;
    private static final int RESTRICT_TO_LIBRARY_GROUP_PREFIX = 4;
    private static final int RESTRICT_TO_TESTS = 8;
    private static final int RESTRICT_TO_SUBCLASSES = 16;
    @JvmField
    @NotNull
    public static final Issue RESTRICTED = Issue.Companion.create("RestrictedApi", "Restricted API", "\n                This API has been flagged with a restriction that has not been met.\n\n                Examples of API restrictions:\n                * Method can only be invoked by a subclass\n                * Method can only be accessed from within the same library (defined by the Gradle library group id)\n                * Method can only be accessed from tests.\n\n                You can add your own API restrictions with the `@RestrictTo` annotation.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue TEST_VISIBILITY = Issue.Companion.create("VisibleForTests", "Visible Only For Tests", "\n                This check looks for accesses from production code (e.g. not tests) where \\\n                the access would not have been allowed with the intended production \\\n                visibility.\n\n                Depending on your development environment, you may be able to use an \\\n                `@VisibleForTesting` annotation to specify the intended visibility if \\\n                the method had not been more widely visible for the tests.\n\n                When using `androidx.annotations.VisibleForTesting`, the production \\\n                visibility is assumed to be private unless specified with the `otherwise=` \\\n                parameter. `com.google.common.annotations.VisibleForTesting` and \\\n                `com.android.internal.annotations.VisibleForTesting` work similarly with \\\n                their own parameters called `productionVisibility` and `visibility`.\n\n                If instead you use `org.jetbrains.annotations.VisibleForTesting`, there \\\n                is no such parameter, and the production visibility is instead assumed to be \\\n                \"one step down\" from the testing visibility. For example, if the testing \\\n                visibility is public, the production visibility is assumed to be package-private.\n                ", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue TEST_VISIBILITY_INTELLIJ = Issue.Companion.create("VisibleForTests", "Visible Only For Tests", "\n                This check looks for accesses from production code (e.g. not tests) where \\\n                the access would not have been allowed if its visibility was not relaxed for \\\n                testing purposes.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.oldName(), AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.newName(), "VisibleForTesting"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return false;
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return type != AnnotationUsageType.ASSIGNMENT_LHS && type != AnnotationUsageType.ASSIGNMENT_RHS && super.isApplicableAnnotationUsage(type);
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        AnnotationUsageType type = usageInfo.getType();
        if (type == AnnotationUsageType.EXTENDS && element instanceof UTypeReferenceExpression) {
            PsiElement psiElement2;
            PsiElement sourcePsi = element.getSourcePsi();
            if (Lint.isKotlin((Language)element.getLang()) && Intrinsics.areEqual((Object)((psiElement2 = sourcePsi) != null && (psiElement2 = psiElement2.getParent()) != null ? psiElement2.toString() : null), (Object)"CONSTRUCTOR_CALLEE")) {
                return;
            }
        }
        PsiMember member = (psiElement = usageInfo.getReferenced()) instanceof PsiMember ? (PsiMember)psiElement : null;
        UAnnotation annotation = annotationInfo.getAnnotation();
        String qualifiedName = annotationInfo.getQualifiedName();
        if (AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.isEquals(qualifiedName)) {
            this.checkRestrictTo(context, element, member, annotation, usageInfo, true);
        } else if (StringsKt.endsWith$default((String)qualifiedName, (String)VISIBLE_FOR_TESTING_SUFFIX, (boolean)false, (int)2, null) && member != null && type != AnnotationUsageType.METHOD_OVERRIDE && type != AnnotationUsageType.METHOD_CALL_PARAMETER) {
            this.checkVisibleForTesting(context, element, member, annotation, usageInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isTestContext(JavaContext context, UElement element) {
        UElement current = element;
        if (context.isTestSource()) {
            return true;
        }
        while (true) {
            UAnnotated owner;
            void $this$getParentOfType$iv;
            UElement uElement = current;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            if ((UAnnotated)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UAnnotated.class, (boolean)strict$iv) == null) break;
            if (this.isTestContext(owner)) {
                return true;
            }
            current = (UElement)owner;
        }
        return false;
    }

    private final boolean isTestContext(UAnnotated $this$isTestContext) {
        String name;
        boolean isCompose = false;
        List annotations = $this$isTestContext.getUAnnotations();
        for (UAnnotation annotation : annotations) {
            if (annotation.getQualifiedName() == null) continue;
            if (AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.isEquals(name)) {
                int restrictionScope = RestrictToDetector.Companion.getRestrictionScope(annotation);
                if ((restrictionScope & 8) == 0) continue;
                return true;
            }
            if (StringsKt.endsWith$default((String)name, (String)VISIBLE_FOR_TESTING_SUFFIX, (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.endsWith$default((String)name, (String)".TestOnly", (boolean)false, (int)2, null)) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)name, (Object)COMPOSABLE_ANNOTATION)) continue;
            isCompose = true;
        }
        if (isCompose) {
            for (UAnnotation annotation : annotations) {
                if (annotation.getQualifiedName() == null) continue;
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)COMPOSE_PREVIEW) || Intrinsics.areEqual((Object)string, (Object)COMPOSE_DESKTOP_PREVIEW)) {
                    return true;
                }
                PsiClass cls = annotation.resolve();
                if (cls == null) continue;
                for (PsiAnnotation nested : cls.getAnnotations()) {
                    String string2;
                    if (nested.getQualifiedName() == null || !Intrinsics.areEqual((Object)string2, (Object)COMPOSE_PREVIEW) && !Intrinsics.areEqual((Object)string2, (Object)COMPOSE_DESKTOP_PREVIEW)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private final void checkVisibleForTesting(JavaContext context, UElement node, PsiMember member, UAnnotation annotation, AnnotationUsageInfo usageInfo) {
        int visibility = Companion.getVisibilityNotForTesting(annotation, Companion.getVisibility(member));
        if (visibility == 5) {
            RestrictToDetector.checkRestrictTo$default(this, context, node, member, annotation, usageInfo, 8, false, 64, null);
        } else {
            PsiClass thisClass;
            boolean bl;
            PsiFile containingFile2;
            UFile uFile = UastUtils.getContainingUFile((UElement)node);
            PsiFile containingFile1 = UastLintUtils.Companion.getPsiFile(uFile);
            if (Intrinsics.areEqual((Object)containingFile1, (Object)(containingFile2 = UastLintUtils.Companion.getContainingFile((PsiElement)member))) || containingFile2 == null) {
                return;
            }
            PsiFile psiFile = containingFile1;
            if (Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getVirtualFile() : null), (Object)containingFile2.getVirtualFile())) {
                return;
            }
            if (visibility == 2) {
                if (!this.isTestContext(context, node)) {
                    this.reportVisibilityError(context, node, annotation, usageInfo, "private");
                }
                return;
            }
            JavaEvaluator evaluator = context.getEvaluator();
            PsiPackage pkg = evaluator.getPackage(node);
            PsiPackage methodPackage = evaluator.getPackage((PsiElement)member);
            PsiPackage psiPackage = pkg;
            PsiPackage psiPackage2 = methodPackage;
            if (Intrinsics.areEqual((Object)(psiPackage != null ? psiPackage.getQualifiedName() : null), (Object)(psiPackage2 != null ? psiPackage2.getQualifiedName() : null))) {
                return;
            }
            if (visibility == 3) {
                if (!this.isTestContext(context, node)) {
                    this.reportVisibilityError(context, node, annotation, usageInfo, "package private");
                }
                return;
            }
            boolean bl2 = bl = visibility == 4;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            PsiClass methodClass = member.getContainingClass();
            UClass uClass = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            Object object = thisClass = uClass != null ? uClass.getJavaPsi() : null;
            if (thisClass == null || methodClass == null) {
                return;
            }
            String qualifiedName = methodClass.getQualifiedName();
            if (qualifiedName == null || evaluator.inheritsFrom(thisClass, qualifiedName, false)) {
                return;
            }
            if (!this.isTestContext(context, node)) {
                this.reportVisibilityError(context, node, annotation, usageInfo, "protected");
            }
        }
    }

    private final void reportVisibilityError(JavaContext context, UElement node, UAnnotation annotation, AnnotationUsageInfo usageInfo, String desc) {
        String string;
        String type;
        String string2 = type = node instanceof UTypeReferenceExpression ? "class" : "method";
        if (WhenMappings.$EnumSwitchMapping$0[usageInfo.getType().ordinal()] == 1) {
            PsiElement psiElement = usageInfo.getReferenced();
            PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
            String typeText = psiClass != null ? psiClass.getName() : null;
            Object object = typeText;
            if (object == null || (object = (String)object + ",") == null) {
                object = "a type";
            }
            string = "This declaration implicitly references " + (String)object + " which should only be accessed from tests or within " + desc + " scope";
        } else {
            string = "This " + type + " should only be accessed from tests or within " + desc + " scope";
        }
        String message2 = string;
        Location location = node instanceof UCallExpression ? context.getCallLocation((UCallExpression)node, false, false) : context.getLocation(node);
        Issue issue = Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)INTELLIJ_VISIBLE_FOR_TESTING_ANNOTATION) ? TEST_VISIBILITY_INTELLIJ : TEST_VISIBILITY;
        this.report(context, issue, node, location, message2);
    }

    private final void checkRestrictTo(JavaContext context, UElement node, PsiMember method, UAnnotation annotation, AnnotationUsageInfo usageInfo, boolean applyClassAnnotationsToMembers) {
        int scope = RestrictToDetector.Companion.getRestrictionScope(annotation);
        if (scope != 0) {
            this.checkRestrictTo(context, node, method, annotation, usageInfo, scope, applyClassAnnotationsToMembers);
        }
    }

    static /* synthetic */ void checkRestrictTo$default(RestrictToDetector restrictToDetector, JavaContext javaContext, UElement uElement, PsiMember psiMember, UAnnotation uAnnotation, AnnotationUsageInfo annotationUsageInfo, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        restrictToDetector.checkRestrictTo(javaContext, uElement, psiMember, uAnnotation, annotationUsageInfo, bl);
    }

    private final void checkRestrictTo(JavaContext context, UElement node, PsiMember member, UAnnotation annotation, AnnotationUsageInfo usageInfo, int scope, boolean applyClassAnnotationsToMembers) {
        String qualifiedName;
        String methodGroup;
        String thisGroup;
        LintModelMavenName methodCoordinates;
        LintModelMavenName thisCoordinates;
        JavaEvaluator evaluator;
        PsiClass containingClass;
        Object object;
        if (node instanceof UTypeReferenceExpression) {
            object = PsiTypesUtil.getPsiClass((PsiType)((UTypeReferenceExpression)node).getType());
        } else {
            PsiMember psiMember = member;
            if (psiMember != null) {
                object = psiMember.getContainingClass();
            } else if (node instanceof UCallExpression) {
                PsiElement psiElement;
                UReferenceExpression uReferenceExpression = ((UCallExpression)node).getClassReference();
                Object object2 = psiElement = uReferenceExpression != null ? uReferenceExpression.resolve() : null;
                object = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
            } else {
                object = node instanceof UClass ? ((UClass)node).getJavaPsi() : null;
            }
        }
        if ((containingClass = object) == null) {
            return;
        }
        List annotations = usageInfo.getAnnotations();
        if (!applyClassAnnotationsToMembers) {
            AnnotationOrigin origin = ((AnnotationInfo)annotations.get(usageInfo.getIndex())).getOrigin();
            if (member instanceof PsiClass ? origin != AnnotationOrigin.CLASS : origin != AnnotationOrigin.METHOD && origin != AnnotationOrigin.FIELD) {
                return;
            }
        }
        if (usageInfo.anyCloser((Function1)checkRestrictTo.1.INSTANCE)) {
            return;
        }
        if ((scope & 1) != 0 && member != null) {
            Object object3;
            evaluator = context.getEvaluator();
            LintModelMavenName lintModelMavenName = evaluator.getLibrary(node);
            if (lintModelMavenName == null) {
                lintModelMavenName = thisCoordinates = context.getProject().getMavenCoordinate();
            }
            if ((object3 = evaluator.getLibrary((PsiElement)member)) == null) {
                RestrictToDetector $this$checkRestrictTo_u24lambda_u240 = this;
                boolean bl = false;
                if (thisCoordinates != null && !(member instanceof PsiCompiledElement)) {
                    Project project = context.getEvaluator().getProject((PsiElement)member);
                    object3 = project != null ? project.getMavenCoordinate() : null;
                } else {
                    object3 = null;
                }
            }
            methodCoordinates = object3;
            LintModelMavenName lintModelMavenName2 = thisCoordinates;
            thisGroup = lintModelMavenName2 != null ? lintModelMavenName2.getGroupId() : null;
            LintModelMavenName lintModelMavenName3 = methodCoordinates;
            String string = methodGroup = lintModelMavenName3 != null ? lintModelMavenName3.getGroupId() : null;
            if (!Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup) && methodGroup != null) {
                String string2 = thisGroup;
                if (string2 == null) {
                    string2 = "<unknown>";
                }
                String thisGroupDisplayText = string2;
                String where = "from within the same library group (referenced groupId=`" + methodGroup + "` from groupId=`" + thisGroupDisplayText + "`)";
                this.reportRestriction(where, containingClass, member, context, node, usageInfo);
            }
        } else if ((scope & 4) != 0 && member != null) {
            Object object4;
            evaluator = context.getEvaluator();
            LintModelMavenName lintModelMavenName = evaluator.getLibrary(node);
            if (lintModelMavenName == null) {
                lintModelMavenName = thisCoordinates = context.getProject().getMavenCoordinate();
            }
            if ((object4 = evaluator.getLibrary((PsiElement)member)) == null) {
                RestrictToDetector $this$checkRestrictTo_u24lambda_u241 = this;
                boolean bl = false;
                if (thisCoordinates != null && !(member instanceof PsiCompiledElement)) {
                    Project project = context.getEvaluator().getProject((PsiElement)member);
                    object4 = project != null ? project.getMavenCoordinate() : null;
                } else {
                    object4 = null;
                }
            }
            methodCoordinates = object4;
            LintModelMavenName lintModelMavenName4 = thisCoordinates;
            thisGroup = lintModelMavenName4 != null ? lintModelMavenName4.getGroupId() : null;
            LintModelMavenName lintModelMavenName5 = methodCoordinates;
            String string = methodGroup = lintModelMavenName5 != null ? lintModelMavenName5.getGroupId() : null;
            if (!(methodGroup == null || thisGroup != null && Companion.sameLibraryGroupPrefix(thisGroup, methodGroup))) {
                String string3;
                int it = StringsKt.lastIndexOf$default((CharSequence)methodGroup, (char)'.', (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                if (it < 0) {
                    string3 = "\"\"";
                } else {
                    String string4 = methodGroup.substring(0, it);
                    string3 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                }
                String expectedPrefix = string3;
                String string5 = thisGroup;
                String where = "from within the same library group prefix (referenced groupId=`" + methodGroup + "` with prefix " + expectedPrefix + (String)(string5 != null ? " from groupId=`" + string5 + "`" : "") + ")";
                this.reportRestriction(where, containingClass, member, context, node, usageInfo);
            }
        } else if ((scope & 2) != 0 && member != null) {
            Project project;
            evaluator = context.getEvaluator();
            LintModelMavenName lintModelMavenName = evaluator.getLibrary(node);
            if (lintModelMavenName == null) {
                lintModelMavenName = context.getProject().getMavenCoordinate();
            }
            thisCoordinates = lintModelMavenName;
            methodCoordinates = evaluator.getLibrary((PsiElement)member);
            LintModelMavenName lintModelMavenName6 = thisCoordinates;
            thisGroup = lintModelMavenName6 != null ? lintModelMavenName6.getGroupId() : null;
            LintModelMavenName lintModelMavenName7 = methodCoordinates;
            String string = methodGroup = lintModelMavenName7 != null ? lintModelMavenName7.getGroupId() : null;
            if (!Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup) && methodGroup != null) {
                String methodArtifact;
                LintModelMavenName lintModelMavenName8 = thisCoordinates;
                String thisArtifact = lintModelMavenName8 != null ? lintModelMavenName8.getArtifactId() : null;
                if (!Intrinsics.areEqual((Object)thisArtifact, (Object)(methodArtifact = methodCoordinates.getArtifactId()))) {
                    String where = "from within the same library (" + methodGroup + ":" + methodArtifact + ")";
                    this.reportRestriction(where, containingClass, member, context, node, usageInfo);
                }
            } else if (!(member instanceof PsiCompiledElement) && (project = context.getEvaluator().getProject((PsiElement)member)) != null && !Intrinsics.areEqual((Object)project, (Object)context.getProject())) {
                LintModelMavenName coordinates = project.getMavenCoordinate();
                String name = coordinates != null ? coordinates.getGroupId() + ":" + coordinates.getArtifactId() : project.getName();
                String where = "from within the same library (" + name + ")";
                this.reportRestriction(where, containingClass, member, context, node, usageInfo);
            }
        }
        if ((scope & 8) != 0 && !this.isTestContext(context, node)) {
            this.reportRestriction("from tests", containingClass, member, context, node, usageInfo);
        }
        if ((scope & 0x10) != 0 && (qualifiedName = containingClass.getQualifiedName()) != null) {
            JavaEvaluator evaluator2 = context.getEvaluator();
            UClass outer = null;
            boolean isSubClass = false;
            UElement prev = node;
            while ((outer = (UClass)UastUtils.getParentOfType((UElement)prev, UClass.class, (boolean)true)) != null) {
                if (evaluator2.inheritsFrom(outer.getJavaPsi(), qualifiedName, false)) {
                    isSubClass = true;
                    break;
                }
                if (evaluator2.isStatic((PsiModifierListOwner)outer)) break;
                prev = (UElement)outer;
            }
            if (!isSubClass) {
                this.reportRestriction("from subclasses", containingClass, member, context, node, usageInfo);
            }
        }
    }

    static /* synthetic */ void checkRestrictTo$default(RestrictToDetector restrictToDetector, JavaContext javaContext, UElement uElement, PsiMember psiMember, UAnnotation uAnnotation, AnnotationUsageInfo annotationUsageInfo, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        restrictToDetector.checkRestrictTo(javaContext, uElement, psiMember, uAnnotation, annotationUsageInfo, n, bl);
    }

    private final void reportRestriction(String where, PsiClass containingClass, PsiMember member, JavaContext context, UElement node, AnnotationUsageInfo usageInfo) {
        Object object;
        Object api2 = null;
        if (member == null || member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) {
            object = (PsiMethod)member;
            if (object == null || (object = object.getName()) == null) {
                object = containingClass.getName() + " constructor";
            }
        } else if (Intrinsics.areEqual((Object)containingClass, (Object)member)) {
            object = member.getName();
            if (object == null) {
                object = "class";
            }
        } else {
            object = containingClass.getName() + "." + member.getName();
        }
        api2 = object;
        UElement locationNode = node;
        if (node instanceof UCallExpression) {
            UIdentifier nameElement = ((UCallExpression)node).getMethodIdentifier();
            if (nameElement != null) {
                locationNode = (UElement)nameElement;
            }
            AnnotationInfo annotation = (AnnotationInfo)usageInfo.getAnnotations().get(usageInfo.getIndex());
            PsiElement annotated = annotation.getAnnotated();
            if (where == null && annotated instanceof PsiClass && !Intrinsics.areEqual((Object)annotated, (Object)usageInfo.getReferenced())) {
                UExpression qualifier = ((UCallExpression)node).getReceiver();
                String className = ((PsiClass)annotated).getName();
                if (qualifier != null && className != null && Intrinsics.areEqual((Object)qualifier.asSourceString(), (Object)className)) {
                    locationNode = (UElement)qualifier;
                    api2 = className;
                }
            }
        }
        Object message2 = null;
        if (where == null) {
            message2 = (String)api2 + " is marked as internal and should not be accessed from apps";
        } else {
            String refType = member instanceof PsiMethod ? "called" : "accessed";
            message2 = (String)api2 + " can only be " + refType + " " + where;
            if (Intrinsics.areEqual((Object)where, (Object)"from within the same library (groupId=com.android.support)")) {
                message2 = "This API is marked as internal to the support library and should not be accessed from apps";
            }
        }
        Location location = locationNode instanceof UCallExpression ? context.getCallLocation((UCallExpression)locationNode, false, false) : context.getLocation(locationNode);
        this.report(context, RESTRICTED, node, location, (String)message2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010!\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020)8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020)8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020)8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INTELLIJ_VISIBLE_FOR_TESTING_ANNOTATION", "", "VISIBLE_FOR_TESTING_SUFFIX", "ATTR_OTHERWISE", "ATTR_PRODUCTION_VISIBILITY", "ATTR_VISIBILITY", "COMPOSABLE_ANNOTATION", "COMPOSE_PREVIEW", "COMPOSE_DESKTOP_PREVIEW", "VISIBILITY_PRIVATE", "", "VISIBILITY_PACKAGE_PRIVATE", "VISIBILITY_PROTECTED", "VISIBILITY_NONE", "VISIBILITY_PUBLIC", "getVisibility", "member", "Lcom/intellij/psi/PsiMember;", "getVisibilityNotForTesting", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "visibility", "RESTRICT_TO_LIBRARY_GROUP", "RESTRICT_TO_LIBRARY", "RESTRICT_TO_LIBRARY_GROUP_PREFIX", "RESTRICT_TO_TESTS", "RESTRICT_TO_SUBCLASSES", "getRestrictionScope", "expression", "Lorg/jetbrains/uast/UExpression;", "sameLibraryGroupPrefix", "", "group1", "group2", "RESTRICTED", "Lcom/android/tools/lint/detector/api/Issue;", "TEST_VISIBILITY", "TEST_VISIBILITY_INTELLIJ", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final int getVisibility(@NotNull PsiMember member) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            Language language = member.getLanguage();
            int defaultForLanguage = language instanceof KotlinLanguage ? 6 : (language instanceof JavaLanguage ? 3 : 5);
            PsiModifierList psiModifierList = member.getModifierList();
            if (psiModifierList == null) {
                return defaultForLanguage;
            }
            PsiModifierList modifierList = psiModifierList;
            return modifierList.hasExplicitModifier("public") ? 6 : (modifierList.hasExplicitModifier("protected") ? 4 : (modifierList.hasExplicitModifier("private") ? 2 : (modifierList.hasExplicitModifier("default") ? defaultForLanguage : defaultForLanguage)));
        }

        public final int getVisibilityNotForTesting(@NotNull UAnnotation annotation, int visibility) {
            block34: {
                PsiElement psi;
                UExpression value;
                block35: {
                    block33: {
                        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                        if (Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)RestrictToDetector.INTELLIJ_VISIBLE_FOR_TESTING_ANNOTATION)) {
                            int n;
                            switch (visibility) {
                                case 6: {
                                    n = 3;
                                    break;
                                }
                                case 4: {
                                    n = 3;
                                    break;
                                }
                                case 3: {
                                    n = 2;
                                    break;
                                }
                                default: {
                                    n = 2;
                                }
                            }
                            return n;
                        }
                        UExpression uExpression = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_OTHERWISE);
                        if (uExpression == null && (uExpression = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_PRODUCTION_VISIBILITY)) == null) {
                            uExpression = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_VISIBILITY);
                        }
                        if (!((value = uExpression) instanceof ULiteralExpression)) break block33;
                        Object v = ((ULiteralExpression)value).getValue();
                        if (v instanceof Integer) {
                            return ((Number)v).intValue();
                        }
                        break block34;
                    }
                    if (!(value instanceof UReferenceExpression)) break block35;
                    String v = ((UReferenceExpression)value).getResolvedName();
                    if (v == null) break block34;
                    int n = -1;
                    switch (v.hashCode()) {
                        case -89079770: {
                            if (v.equals("PACKAGE")) {
                                n = 1;
                            }
                            break;
                        }
                        case 2402104: {
                            if (v.equals("NONE")) {
                                n = 2;
                            }
                            break;
                        }
                        case -2116912242: {
                            if (v.equals("PROTECTED")) {
                                n = 3;
                            }
                            break;
                        }
                        case 403485027: {
                            if (v.equals("PRIVATE")) {
                                n = 4;
                            }
                            break;
                        }
                        case 1152750154: {
                            if (v.equals("PACKAGE_PRIVATE")) {
                                n = 5;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            return 5;
                        }
                        case 4: {
                            return 2;
                        }
                        case 3: {
                            return 4;
                        }
                        case 5: {
                            return 3;
                        }
                        case 1: {
                            return 3;
                        }
                    }
                    break block34;
                }
                if (value instanceof UUnknownExpression) {
                    Object v;
                    PsiElement sourcePsi = ((UUnknownExpression)value).getSourcePsi();
                    if (sourcePsi instanceof PsiLiteralExpression && (v = ((PsiLiteralExpression)sourcePsi).getValue()) instanceof Integer) {
                        return ((Number)v).intValue();
                    }
                } else if (value instanceof UastEmptyExpression && (psi = annotation.getSourcePsi()) instanceof ClsAnnotationImpl) {
                    Object constant;
                    JvmAnnotationAttributeValue v;
                    JvmAnnotationAttribute otherwise;
                    JvmAnnotationAttribute jvmAnnotationAttribute = ((ClsAnnotationImpl)psi).findAttribute(RestrictToDetector.ATTR_OTHERWISE);
                    if (jvmAnnotationAttribute == null && (jvmAnnotationAttribute = ((ClsAnnotationImpl)psi).findAttribute(RestrictToDetector.ATTR_PRODUCTION_VISIBILITY)) == null) {
                        jvmAnnotationAttribute = ((ClsAnnotationImpl)psi).findAttribute(RestrictToDetector.ATTR_VISIBILITY);
                    }
                    JvmAnnotationAttribute jvmAnnotationAttribute2 = otherwise = jvmAnnotationAttribute;
                    Object object = v = jvmAnnotationAttribute2 != null ? jvmAnnotationAttribute2.getAttributeValue() : null;
                    if (v instanceof JvmAnnotationConstantValue && (constant = ((JvmAnnotationConstantValue)v).getConstantValue()) instanceof Number) {
                        return ((Number)constant).intValue();
                    }
                }
            }
            return 2;
        }

        private final int getRestrictionScope(UAnnotation annotation) {
            UExpression value = annotation.findDeclaredAttributeValue("value");
            if (value != null) {
                return this.getRestrictionScope(value, annotation);
            }
            return 0;
        }

        private final int getRestrictionScope(UExpression expression, UAnnotation annotation) {
            int scope = 0;
            if (expression != null) {
                PsiElement psi;
                if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)expression))) {
                    UCallExpression initializerExpression = (UCallExpression)expression;
                    List initializers = initializerExpression.getValueArguments();
                    for (UExpression initializer : initializers) {
                        scope |= this.getRestrictionScope(initializer, annotation);
                    }
                } else if (expression instanceof UReferenceExpression) {
                    PsiElement resolved = ((UReferenceExpression)expression).resolve();
                    if (resolved instanceof PsiField) {
                        String string = ((PsiField)resolved).getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String name = string;
                        if (Intrinsics.areEqual((Object)"GROUP_ID", (Object)name) || Intrinsics.areEqual((Object)"LIBRARY_GROUP", (Object)name)) {
                            scope |= 1;
                        } else if (Intrinsics.areEqual((Object)"SUBCLASSES", (Object)name)) {
                            scope |= 0x10;
                        } else if (Intrinsics.areEqual((Object)"TESTS", (Object)name)) {
                            scope |= 8;
                        } else if (Intrinsics.areEqual((Object)"LIBRARY", (Object)name)) {
                            scope |= 2;
                        } else if (Intrinsics.areEqual((Object)"LIBRARY_GROUP_PREFIX", (Object)name)) {
                            scope |= 4;
                        }
                    }
                } else if (expression instanceof UastEmptyExpression && (psi = annotation.getSourcePsi()) instanceof ClsAnnotationImpl) {
                    Object constant;
                    JvmAnnotationAttributeValue v;
                    JvmAnnotationAttribute otherwise;
                    JvmAnnotationAttribute jvmAnnotationAttribute = otherwise = ((ClsAnnotationImpl)psi).findAttribute("value");
                    Object object = v = jvmAnnotationAttribute != null ? jvmAnnotationAttribute.getAttributeValue() : null;
                    if (v instanceof JvmAnnotationConstantValue && (constant = ((JvmAnnotationConstantValue)v).getConstantValue()) instanceof Number) {
                        scope |= ((Number)constant).intValue();
                    }
                }
            }
            return scope;
        }

        public final boolean sameLibraryGroupPrefix(@NotNull String group1, @NotNull String group2) {
            Intrinsics.checkNotNullParameter((Object)group1, (String)"group1");
            Intrinsics.checkNotNullParameter((Object)group2, (String)"group2");
            if (Intrinsics.areEqual((Object)group1, (Object)group2)) {
                return true;
            }
            int i1 = StringsKt.lastIndexOf$default((CharSequence)group1, (char)'.', (int)0, (boolean)false, (int)6, null);
            int i2 = StringsKt.lastIndexOf$default((CharSequence)group2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (i2 != i1 || i1 == -1) {
                return false;
            }
            return StringsKt.regionMatches$default((String)group1, (int)0, (String)group2, (int)0, (int)i1, (boolean)false, (int)16, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            try {
                nArray[AnnotationUsageType.CLASS_REFERENCE_AS_IMPLICIT_DECLARATION_TYPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

