/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.NetworkCache;
import com.android.io.CancellableFileIo;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.BlockedDependencies;
import com.android.tools.lint.checks.GooglePlaySdkIndex;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GradleDetectorKt;
import com.android.tools.lint.checks.LibraryVersionRange;
import com.android.tools.lint.checks.Lint;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.TargetSdkCheckKt;
import com.android.tools.lint.checks.TargetSdkCheckResult;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintTomlDocument;
import com.android.tools.lint.client.api.LintTomlMapValue;
import com.android.tools.lint.client.api.LintTomlValue;
import com.android.tools.lint.client.api.TomlContext;
import com.android.tools.lint.client.api.TomlScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelArtifactType;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.StringHelper;
import com.google.common.base.Splitter;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.uast.UCallExpression;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\b\b\u0016\u0018\u0000 \u00c3\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\b\u00c0\u0001\u00c1\u0001\u00c2\u0001\u00c3\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J \u0010-\u001a\u00020#2\u0006\u0010$\u001a\u00020.2\u0006\u0010/\u001a\u00020!2\u0006\u00100\u001a\u000201H\u0002JJ\u00102\u001a\u00020#2\u0006\u0010$\u001a\u00020.2\u0006\u00103\u001a\u00020!2\u0006\u0010/\u001a\u00020!2\u0006\u00104\u001a\u00020!2\b\u00105\u001a\u0004\u0018\u00010!2\u0006\u00106\u001a\u0002012\u0006\u00107\u001a\u0002012\u0006\u00108\u001a\u000201H\u0016J\u0010\u00109\u001a\u00020\r2\u0006\u0010/\u001a\u00020!H\u0002J\u001a\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010$\u001a\u00020.2\u0006\u0010/\u001a\u00020!H\u0002J2\u0010<\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\u0006\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020!2\u0006\u00108\u001a\u0002012\b\b\u0002\u0010@\u001a\u00020\rH\u0002J6\u0010A\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\u0006\u0010>\u001a\u00020+2\u0006\u00100\u001a\u0002012\b\b\u0002\u0010@\u001a\u00020\r2\n\b\u0002\u0010B\u001a\u0004\u0018\u000101H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010!2\u0006\u0010D\u001a\u00020!H\u0002J \u0010E\u001a\u00020#2\u0006\u0010$\u001a\u00020.2\u0006\u00107\u001a\u0002012\u0006\u0010/\u001a\u00020!H\u0002J \u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020!2\u0006\u0010$\u001a\u00020.2\u0006\u00106\u001a\u000201H\u0002J(\u0010H\u001a\u00020#2\u0006\u0010G\u001a\u00020!2\u0006\u0010D\u001a\u00020!2\u0006\u0010$\u001a\u00020.2\u0006\u00106\u001a\u000201H\u0002J6\u0010I\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\u0006\u0010>\u001a\u00020+2\u0006\u00107\u001a\u0002012\b\b\u0002\u0010@\u001a\u00020\r2\n\b\u0002\u0010B\u001a\u0004\u0018\u000101H\u0002J(\u0010J\u001a\u00020#2\u0006\u0010$\u001a\u00020.2\u0006\u0010/\u001a\u00020!2\u0006\u00100\u001a\u0002012\u0006\u00107\u001a\u000201H\u0002JV\u0010K\u001a\u00020#2\u0006\u0010$\u001a\u00020.2\u0006\u0010L\u001a\u00020!2\b\u00104\u001a\u0004\u0018\u00010!2\b\u00105\u001a\u0004\u0018\u00010!2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020!0P2\u0006\u00100\u001a\u000201H\u0016J0\u0010Q\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\u0006\u0010D\u001a\u00020R2\u0006\u0010S\u001a\u00020\r2\u0006\u00100\u001a\u0002012\u0006\u00108\u001a\u000201H\u0002J:\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010$\u001a\u00020=2\u0006\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020!2\u0006\u0010>\u001a\u00020U2\u000e\u0010X\u001a\n\u0012\u0004\u0012\u00020U\u0018\u00010YH\u0002J\u0010\u0010Z\u001a\u00020\r2\u0006\u0010$\u001a\u00020=H\u0002J\u0012\u0010[\u001a\u0004\u0018\u00010\b2\u0006\u0010$\u001a\u00020=H\u0002JJ\u0010^\u001a\u00020\r2\u0006\u0010_\u001a\u00020`2\u0006\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020!2\u0006\u0010>\u001a\u00020U2\u0006\u0010a\u001a\u00020!2\b\u0010b\u001a\u0004\u0018\u00010U2\u0006\u0010$\u001a\u00020=2\u0006\u00100\u001a\u000201H\u0002JP\u0010c\u001a\u0004\u0018\u00010)2\u0006\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020!2\u0006\u0010d\u001a\u00020U2\u0006\u0010e\u001a\u00020!2\b\u0010b\u001a\u0004\u0018\u00010U2\u0006\u0010f\u001a\u00020\b2\u0006\u0010_\u001a\u00020`2\n\b\u0002\u0010g\u001a\u0004\u0018\u00010hH\u0002J8\u0010i\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020R0N2\u0012\u0010k\u001a\u000e\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020!0lH\u0002J8\u0010m\u001a\n\u0012\u0004\u0012\u00020U\u0018\u00010Y2\u0006\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020!2\f\u0010n\u001a\b\u0012\u0004\u0012\u00020o0 2\b\u0010_\u001a\u0004\u0018\u00010`H\u0002J\u001e\u0010p\u001a\u00020\r2\u0006\u0010>\u001a\u00020U2\f\u0010n\u001a\b\u0012\u0004\u0012\u00020o0 H\u0002J\b\u0010q\u001a\u00020\bH\u0004J\"\u0010r\u001a\u0004\u0018\u00010U2\u0006\u0010D\u001a\u00020R2\u000e\u0010X\u001a\n\u0012\u0004\u0012\u00020U\u0018\u00010YH\u0002J\f\u0010s\u001a\u00020\r*\u00020UH\u0002J \u0010t\u001a\u00020\r2\u0006\u0010$\u001a\u00020=2\u0006\u0010D\u001a\u00020R2\u0006\u00100\u001a\u000201H\u0002J \u0010u\u001a\u00020\r2\u0006\u0010$\u001a\u00020=2\u0006\u0010D\u001a\u00020R2\u0006\u00100\u001a\u000201H\u0002J0\u0010v\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\u0006\u0010D\u001a\u00020R2\u0006\u0010>\u001a\u00020U2\u0006\u00100\u001a\u0002012\u0006\u00108\u001a\u000201H\u0002J$\u0010w\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\b\u00100\u001a\u0004\u0018\u0001012\b\u00108\u001a\u0004\u0018\u000101H\u0002J\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020y0P2\u0006\u0010z\u001a\u00020\u001cH\u0002J\u0010\u0010{\u001a\u00020#2\u0006\u0010$\u001a\u00020=H\u0016J\u0010\u0010|\u001a\u00020#2\u0006\u0010$\u001a\u00020=H\u0016J\u0010\u0010}\u001a\u00020#2\u0006\u0010$\u001a\u00020=H\u0002J\u001a\u0010~\u001a\u00020#2\u0006\u0010$\u001a\u00020\u007f2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0016J\u0011\u0010\u0082\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=H\u0016J\u0011\u0010\u0083\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=H\u0002J\u0011\u0010\u0084\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=H\u0002J,\u0010\u0085\u0001\u001a\u00020#2\u0006\u0010D\u001a\u00020!2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010;2\u0006\u0010$\u001a\u00020.2\u0006\u00108\u001a\u000201H\u0002J1\u0010\u0087\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\u0006\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020!2\u0006\u0010>\u001a\u00020U2\u0006\u00100\u001a\u000201H\u0002J1\u0010\u0088\u0001\u001a\u00020#2\u0006\u00103\u001a\u00020!2\u0006\u0010D\u001a\u00020!2\u0006\u0010/\u001a\u00020!2\u0006\u0010$\u001a\u00020.2\u0006\u00107\u001a\u000201H\u0002J\u0019\u0010\u0089\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\u0006\u0010z\u001a\u00020\u001cH\u0002Jn\u0010\u008a\u0001\u001a\u00020\r2\u0006\u0010$\u001a\u00020=2\u0006\u00100\u001a\u0002012\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u008d\u0001\u001a\u00020!2\u000b\b\u0002\u0010\u008e\u0001\u001a\u0004\u0018\u00010)2\t\b\u0002\u0010\u008f\u0001\u001a\u00020\r2\f\b\u0002\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u00012\f\b\u0002\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u00012\f\b\u0002\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0095\u0001H\u0002J\"\u0010\u0096\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\u0006\u00100\u001a\u0002012\u0007\u0010\u008d\u0001\u001a\u00020!H\u0002J-\u0010\u0096\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\u0006\u00100\u001a\u0002012\u0007\u0010\u008d\u0001\u001a\u00020!2\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010)H\u0002J$\u0010\u0096\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\b\u0010\u0097\u0001\u001a\u00030\u0098\u00012\u0007\u0010\u008d\u0001\u001a\u00020!H\u0002J\u0019\u0010\u0099\u0001\u001a\u00020+2\u0006\u0010/\u001a\u00020!2\u0006\u00107\u001a\u000201H\u0002J#\u0010\u009a\u0001\u001a\u0004\u0018\u00010R2\u0006\u0010$\u001a\u00020.2\u0006\u00103\u001a\u00020!2\u0006\u0010D\u001a\u00020RH\u0002J\u0011\u0010\u009b\u0001\u001a\u00020\r2\u0006\u0010z\u001a\u00020\u001cH\u0002J\u0011\u0010\u009c\u0001\u001a\u00020\r2\u0006\u0010z\u001a\u00020\u001cH\u0002J;\u0010\u009d\u0001\u001a\u00020)2\u0006\u0010d\u001a\u00020!2\u0007\u0010\u009e\u0001\u001a\u00020!2\u0007\u0010\u009f\u0001\u001a\u00020!2\t\b\u0002\u0010\u00a0\u0001\u001a\u00020\r2\u000b\b\u0002\u0010\u00a1\u0001\u001a\u0004\u0018\u00010UH\u0002J\r\u0010\u00a2\u0001\u001a\u00020!*\u00020RH\u0002J\r\u0010\u00a3\u0001\u001a\u00020\r*\u00020RH\u0002J$\u0010\u00a4\u0001\u001a\u00020!2\u0006\u0010D\u001a\u00020R2\u0006\u0010>\u001a\u00020!2\t\u0010\u00a5\u0001\u001a\u0004\u0018\u00010UH\u0002J%\u0010\u00a6\u0001\u001a\u00020\r2\u0006\u0010$\u001a\u00020=2\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u00012\b\u0010\u00a9\u0001\u001a\u00030\u0095\u0001H\u0016J\u0011\u0010\u00aa\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=H\u0016J\u0019\u0010\u00ab\u0001\u001a\u00020!2\u000e\u0010\u00ac\u0001\u001a\t\u0012\u0005\u0012\u00030\u00ad\u00010PH\u0002J-\u0010\u00b1\u0001\u001a\u0005\u0018\u00010\u00b2\u00012\u0006\u0010$\u001a\u00020=2\u0006\u0010D\u001a\u00020R2\u000f\u0010\u00b3\u0001\u001a\n\u0012\u0004\u0012\u00020U\u0018\u00010YH\u0002J3\u0010\u00b4\u0001\u001a\u0004\u0018\u00010U2\u0006\u0010_\u001a\u00020`2\u0006\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020!2\u000e\u0010X\u001a\n\u0012\u0004\u0012\u00020U\u0018\u00010YH\u0002J\u0012\u0010\u00b5\u0001\u001a\u00030\u00af\u00012\b\u0010\u00b6\u0001\u001a\u00030\u00b7\u0001J\u0013\u0010\u00b8\u0001\u001a\u00020`2\b\u0010\u00b6\u0001\u001a\u00030\u00b7\u0001H\u0002J\u0011\u0010\u00b9\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=H\u0016J6\u0010\u00ba\u0001\u001a\u00020#2\u0006\u0010$\u001a\u00020=2\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u00012\u0007\u0010\u00bd\u0001\u001a\u00020+2\u0007\u0010\u00be\u0001\u001a\u00020!2\u0007\u0010\u00bf\u0001\u001a\u00020+H\u0002R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bj\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\\\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010]R\u0012\u0010\u00ae\u0001\u001a\u0005\u0018\u00010\u00af\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u00b0\u0001\u001a\u0004\u0018\u00010`X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00c4\u0001"}, d2={"Lcom/android/tools/lint/checks/GradleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "Lcom/android/tools/lint/client/api/TomlScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "gradleUserHome", "Ljava/io/File;", "getGradleUserHome", "()Ljava/io/File;", "artifactCacheHome", "mCheckedWearableLibs", "", "mAppliedKotlinAndroidPlugin", "mAppliedKotlinKaptPlugin", "mAppliedKspPlugin", "mAppliedJavaPlugin", "mJavaPluginInfo", "Lcom/android/tools/lint/checks/GradleDetector$JavaPluginInfo;", "mDeclaredSourceCompatibility", "mDeclaredTargetCompatibility", "mDeclaredGoogleMavenRepository", "mDeclaredBuildscriptRepository", "agpVersionCheckInfo", "Lcom/android/tools/lint/checks/GradleDetector$AgpVersionCheckInfo;", "blockedDependencies", "Ljava/util/HashMap;", "Lcom/android/tools/lint/detector/api/Project;", "Lcom/android/tools/lint/checks/BlockedDependencies;", "Lkotlin/collections/HashMap;", "getApplicableAttributes", "", "", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "targetSdkLintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "current", "", "target", "checkOctal", "Lcom/android/tools/lint/detector/api/GradleContext;", "value", "cookie", "", "checkDslPropertyAssignment", "property", "parent", "parentParent", "propertyCookie", "valueCookie", "statementCookie", "isTomlVersionKey", "findCorrespondingTomlKey", "Lcom/android/tools/lint/client/api/LintTomlValue;", "checkTargetSdkVersion", "Lcom/android/tools/lint/detector/api/Context;", "version", "versionString", "includeFix", "checkCompileSdkVersionLatest", "fixCookie", "getVersionVariable", "dependency", "checkForChromeOSAbiSplits", "checkDeprecatedConfigurations", "configuration", "checkAnnotationProcessorOnCompilePath", "checkMinSdkVersion", "checkIntegerAsString", "checkMethodCall", "statement", "namedArguments", "", "unnamedArguments", "", "checkDependency", "Lcom/android/ide/common/gradle/Dependency;", "isResolved", "getMavenVersion", "Lcom/android/ide/common/gradle/Version;", "groupId", "artifactId", "filter", "Ljava/util/function/Predicate;", "isUsingJitpackRepository", "findSettingsFile", "usingJitpackRepository", "Ljava/lang/Boolean;", "generateAndReportSdkIndexIssues", "sdkIndex", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex;", "richVersionIdentifier", "newerVersion", "generateSdkIndexFixes", "currentVersion", "currentVersionIdentifier", "buildFile", "vulnerabilityMessage", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$Companion$VulnerabilityDescription;", "checkDuplication", "dependencies", "extractor", "Lkotlin/Function1;", "getGooglePlaySdkIndexFilter", "recommendedVersions", "Lcom/android/tools/lint/checks/LibraryVersionRange;", "isRecommendedVersion", "getArtifactCacheHome", "findCachedNewerVersion", "isOldApacheCommonsVersion", "checkCoreLibraryDesugaringCompatibility", "checkGradlePluginDependency", "checkPlayServices", "checkConsistentWearableLibraries", "getAllLibraries", "Lcom/android/tools/lint/model/LintModelLibrary;", "project", "beforeCheckRootProject", "afterCheckRootProject", "checkLibraryConsistency", "visitTomlDocument", "Lcom/android/tools/lint/client/api/TomlContext;", "document", "Lcom/android/tools/lint/client/api/LintTomlDocument;", "afterCheckFile", "maybeReportJavaTargetCompatibilityIssue", "maybeReportAgpVersionIssue", "checkKaptUsage", "libTomlValue", "checkForKtxExtension", "checkForBomUsageWithoutPlatform", "checkBlockedDependencies", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "message", "fix", "partial", "overrideSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "constraint", "Lcom/android/tools/lint/detector/api/Constraint;", "clientProperties", "Lcom/android/tools/lint/detector/api/LintMap;", "reportFatalCompatibilityIssue", "location", "Lcom/android/tools/lint/detector/api/Location;", "getSdkVersion", "resolveCoordinate", "isPrivacySandboxSdk", "usesLegacyHttpLibrary", "getUpdateDependencyFix", "suggestedVersion", "group", "suggestedVersionIsSafe", "safeReplacement", "id", "isGradlePlugin", "getNewerVersionAvailableMessage", "stable", "filterIncident", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "checkMergedProject", "getBlockedDependencyMessage", "path", "Lcom/android/tools/lint/model/LintModelDependency;", "googleMavenRepository", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "googlePlaySdkIndex", "getGoogleMavenRepoVersion", "Lcom/android/tools/lint/checks/GradleDetector$Companion$AvailableVersions;", "predicate", "getSdkIndexVersion", "getGoogleMavenRepository", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getGooglePlaySdkIndex", "run", "checkGradleWrapperDistribution", "contents", "", "offset", "line", "valueStart", "JavaPluginInfo", "AgpVersionCheckInfo", "DeprecatedConfiguration", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nGradleDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDetector.kt\ncom/android/tools/lint/checks/GradleDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,4836:1\n1#2:4837\n1761#3,3:4838\n1491#3:4843\n1516#3,3:4844\n1519#3,3:4854\n1869#3,2:4865\n808#3,11:4868\n1761#3,3:4879\n1374#3:4882\n1460#3,5:4883\n1069#4,2:4841\n382#5,7:4847\n536#5:4857\n521#5,6:4858\n216#6:4864\n217#6:4867\n*S KotlinDebug\n*F\n+ 1 GradleDetector.kt\ncom/android/tools/lint/checks/GradleDetector\n*L\n497#1:4838,3\n1592#1:4843\n1592#1:4844,3\n1592#1:4854,3\n1595#1:4865,2\n1861#1:4868,11\n2267#1:4879,3\n3705#1:4882\n3705#1:4883,5\n828#1:4841,2\n1592#1:4847,7\n1593#1:4857\n1593#1:4858,6\n1594#1:4864\n1594#1:4867\n*E\n"})
public class GradleDetector
extends Detector
implements GradleScanner,
TomlScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private File artifactCacheHome;
    private boolean mCheckedWearableLibs;
    private boolean mAppliedKotlinAndroidPlugin;
    private boolean mAppliedKotlinKaptPlugin;
    private boolean mAppliedKspPlugin;
    private boolean mAppliedJavaPlugin;
    @Nullable
    private JavaPluginInfo mJavaPluginInfo;
    private boolean mDeclaredSourceCompatibility;
    private boolean mDeclaredTargetCompatibility;
    private boolean mDeclaredGoogleMavenRepository;
    private boolean mDeclaredBuildscriptRepository;
    @Nullable
    private AgpVersionCheckInfo agpVersionCheckInfo;
    @NotNull
    private final HashMap<Project, BlockedDependencies> blockedDependencies = new HashMap();
    @Nullable
    private Boolean usingJitpackRepository;
    @Nullable
    private GoogleMavenRepository googleMavenRepository;
    @Nullable
    private GooglePlaySdkIndex googlePlaySdkIndex;
    private static int lastTargetSdkVersion;
    @Nullable
    private static File lastTargetSdkVersionFile;
    @Nullable
    private static Calendar calendar;
    public static final int HIGHEST_KNOWN_STABLE_ANDROID_API = 36;
    @NotNull
    public static final String GRADLE_PLUGIN_ARTIFACT_SUFFIX = ".gradle.plugin";
    @NotNull
    public static final String KEY_COORDINATE = "coordinate";
    @NotNull
    public static final String KEY_REVISION = "revision";
    @NotNull
    public static final String KEY_IDE_AGP_VERSION = "ideAgpVersion";
    @NotNull
    private static final String VC_LIBRARY_PREFIX = "libs.";
    @NotNull
    private static final String VC_PLUGIN_PREFIX = "libs.plugins.";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @NotNull
    private static final Implementation IMPLEMENTATION_WITH_TOML;
    @NotNull
    private static final Implementation IMPLEMENTATION_WITH_TOML_AND_PROPERTIES;
    @NotNull
    private static final Implementation IMPLEMENTATION_WITH_TOML_AND_MANIFEST;
    @JvmField
    @NotNull
    public static final Issue DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue MULTIPLE_VERSIONS_DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue SWITCH_TO_TOML;
    @JvmField
    @NotNull
    public static final Issue CORE_LIB_DESUGARING_V2;
    @JvmField
    @NotNull
    public static final Issue AGP_DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_CONFIGURATION;
    @JvmField
    @NotNull
    public static final Issue GRADLE_PLUGIN_COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue PATH;
    @JvmField
    @NotNull
    public static final Issue IDE_SUPPORT;
    @JvmField
    @NotNull
    public static final Issue PLUS;
    @JvmField
    @NotNull
    public static final Issue GRADLE_GETTER;
    @JvmField
    @NotNull
    public static final Issue COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue STRING_INTEGER;
    @JvmField
    @NotNull
    public static final Issue NOT_INTERPOLATED;
    @JvmField
    @NotNull
    public static final Issue REMOTE_VERSION;
    @JvmField
    @NotNull
    public static final Issue MIN_SDK_TOO_LOW;
    @JvmField
    @NotNull
    public static final Issue ACCIDENTAL_OCTAL;
    @JvmField
    @NotNull
    public static final Issue BUNDLED_GMS;
    @JvmField
    @NotNull
    public static final Issue HIGH_APP_VERSION_CODE;
    @JvmField
    @NotNull
    public static final Issue DEV_MODE_OBSOLETE;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_CLASSES;
    @Nullable
    private static Map<String, Set<String>> reservedQuickfixNames;
    @NotNull
    private static final Object reservedQuickfixNamesLock;
    @NotNull
    private static final String INSTANT_DEPRECATION_MESSAGE;
    @JvmField
    @NotNull
    public static final Issue EXPIRING_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue EXPIRED_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue TARGET_NEWER;
    @JvmField
    @NotNull
    public static final Issue EDITED_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue INSTANT_APP_DEPRECATION;
    @JvmField
    @NotNull
    public static final Issue DATA_BINDING_WITHOUT_KAPT;
    @JvmField
    @NotNull
    public static final Issue LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8;
    @JvmField
    @NotNull
    public static final Issue RISKY_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue ANNOTATION_PROCESSOR_ON_COMPILE_PATH;
    @JvmField
    @NotNull
    public static final Issue KTX_EXTENSION_AVAILABLE;
    @JvmField
    @NotNull
    public static final Issue KAPT_USAGE_INSTEAD_OF_KSP;
    @JvmField
    @NotNull
    public static final Issue BOM_WITHOUT_PLATFORM;
    @JvmField
    @NotNull
    public static final Issue JAVA_PLUGIN_LANGUAGE_LEVEL;
    @JvmField
    @NotNull
    public static final Issue JCENTER_REPOSITORY_OBSOLETE;
    @JvmField
    @NotNull
    public static final Issue PLAY_SDK_INDEX_NON_COMPLIANT;
    @JvmField
    @NotNull
    public static final Issue PLAY_SDK_INDEX_VULNERABILITY;
    @JvmField
    @NotNull
    public static final Issue PLAY_SDK_INDEX_GENERIC_ISSUES;
    @JvmField
    @NotNull
    public static final Issue PLAY_SDK_INDEX_DEPRECATED;
    @JvmField
    @NotNull
    public static final Issue CHROMEOS_ABI_SUPPORT;
    @NotNull
    private static final List<String> JAVA_PLUGIN_IDS;
    @NotNull
    public static final String APP_PLUGIN_ID = "com.android.application";
    @NotNull
    public static final String LIB_PLUGIN_ID = "com.android.library";
    @NotNull
    public static final String OLD_APP_PLUGIN_ID = "android";
    @NotNull
    public static final String OLD_LIB_PLUGIN_ID = "android-library";
    @NotNull
    private static final Set<String> ALL_PLUGIN_IDS;
    @NotNull
    public static final String GMS_GROUP_ID = "com.google.android.gms";
    @NotNull
    public static final String FIREBASE_GROUP_ID = "com.google.firebase";
    @NotNull
    public static final String GOOGLE_SUPPORT_GROUP_ID = "com.google.android.support";
    @NotNull
    public static final String ANDROID_WEAR_GROUP_ID = "com.google.android.wearable";
    @NotNull
    private static final String WEARABLE_ARTIFACT_ID = "wearable";
    @NotNull
    private static final Component PLAY_SERVICES_V650;
    private static final int VERSION_CODE_HIGH_THRESHOLD = 2000000000;
    @NotNull
    private static final Set<String> commonAnnotationProcessors;
    @NotNull
    private static final Map<String, String> annotationProcessorsWithKspReplacements;
    @NotNull
    private static final Set<String> commonBoms;
    @NotNull
    private static Function2<? super Path, ? super LintClient, ? extends GooglePlaySdkIndex> playSdkIndexFactory;

    @NotNull
    protected File getGradleUserHome() {
        Object gradleUserHome = System.getProperty("gradle.user.home");
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = System.getProperty("user.home") + File.separator + ".gradle";
        }
        return new File((String)gradleUserHome);
    }

    @Nullable
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"targetSdkVersion");
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (!Intrinsics.areEqual((Object)attribute.getNamespaceURI(), (Object)"http://schemas.android.com/apk/res/android")) {
            return;
        }
        Element element = attribute.getOwnerElement();
        String target2 = attribute.getValue();
        try {
            Intrinsics.checkNotNull((Object)target2);
            int targetSdkVersion = Integer.parseInt(target2);
            Location location = context.getLocation((Node)attribute);
            Context context2 = (Context)context;
            Calendar calendar = ManifestDetector.Companion.getCalendar();
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            Calendar calendar2 = calendar;
            Intrinsics.checkNotNull((Object)calendar2);
            TargetSdkCheckResult tsdk = TargetSdkCheckKt.checkTargetSdk(context2, calendar2, targetSdkVersion);
            if (tsdk instanceof TargetSdkCheckResult.Expired) {
                context.report(EXPIRED_TARGET_SDK_VERSION, (Node)element, location, ((TargetSdkCheckResult.Expired)tsdk).getMessage(), this.targetSdkLintFix(targetSdkVersion, ((TargetSdkCheckResult.Expired)tsdk).getRequiredVersion()));
            } else if (tsdk instanceof TargetSdkCheckResult.Expiring) {
                context.report(EXPIRING_TARGET_SDK_VERSION, (Node)element, location, ((TargetSdkCheckResult.Expiring)tsdk).getMessage(), this.targetSdkLintFix(targetSdkVersion, ((TargetSdkCheckResult.Expiring)tsdk).getRequiredVersion()));
            } else if (tsdk instanceof TargetSdkCheckResult.NotLatest) {
                if (context.isEnabled(TARGET_NEWER)) {
                    context.report(TARGET_NEWER, (Node)element, location, ((TargetSdkCheckResult.NotLatest)tsdk).getMessage(), this.targetSdkLintFix(targetSdkVersion, ((TargetSdkCheckResult.NotLatest)tsdk).getHighestVersion()));
                }
            } else if (!(tsdk instanceof TargetSdkCheckResult.NoIssue)) {
                throw new NoWhenBranchMatchedException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private final LintFix targetSdkLintFix(int current, int target2) {
        LintFix lintFix;
        if (LintClient.Companion.isStudio()) {
            Object[] objectArray = new Object[]{"currentTargetSdkVersion", current};
            lintFix = this.fix().data(objectArray);
        } else {
            lintFix = this.fix().name("Update targetSdkVersion to " + target2).set("http://schemas.android.com/apk/res/android", "targetSdkVersion", String.valueOf(target2)).build();
        }
        return lintFix;
    }

    private final void checkOctal(GradleContext context, String value, Object cookie) {
        if (value.length() >= 2 && value.charAt(0) == '0' && (value.length() > 2 || Intrinsics.compare((int)value.charAt(1), (int)56) >= 0 && GradleContext.Companion.isNonNegativeInteger(value)) && context.isEnabled(ACCIDENTAL_OCTAL)) {
            Object object;
            String string;
            Object message2 = "The leading 0 turns this number into octal which is probably not what was intended";
            String string2 = message2;
            try {
                string = string2;
                Long numericValue = Long.decode(value);
                object = " (interpreted as " + numericValue + ")";
            }
            catch (NumberFormatException numberFormatException) {
                string = string2;
                object = " (and it is not a valid octal number)";
            }
            message2 = string + (String)object;
            GradleDetector.report$default(this, (Context)context, cookie, ACCIDENTAL_OCTAL, (String)message2, null, false, null, null, null, 496, null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void checkDslPropertyAssignment(@NotNull GradleContext context, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object propertyCookie, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        block90: {
            block97: {
                block99: {
                    block100: {
                        block98: {
                            block96: {
                                block95: {
                                    block91: {
                                        block93: {
                                            block94: {
                                                block92: {
                                                    block88: {
                                                        block89: {
                                                            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                                                            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                                                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                                            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                                                            Intrinsics.checkNotNullParameter((Object)propertyCookie, (String)"propertyCookie");
                                                            Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
                                                            Intrinsics.checkNotNullParameter((Object)statementCookie, (String)"statementCookie");
                                                            if (!Intrinsics.areEqual((Object)parent, (Object)"defaultConfig") && (!this.isPrivacySandboxSdk(context.getProject()) || !Intrinsics.areEqual((Object)parent, (Object)"android"))) break block88;
                                                            switch (property.hashCode()) {
                                                                case -1312692432: {
                                                                    if (property.equals("minSdkVersion")) break;
                                                                    ** break;
                                                                }
                                                                case -1074060152: {
                                                                    if (property.equals("minSdk")) break;
                                                                    ** break;
                                                                }
                                                                case -815588119: {
                                                                    if (!property.equals("targetSdk")) {
                                                                        ** break;
                                                                    }
                                                                    ** GOTO lbl22
                                                                }
                                                                case 1346695087: {
                                                                    if (!property.equals("targetSdkVersion")) ** break;
lbl22:
                                                                    // 2 sources

                                                                    if ((version = this.getSdkVersion(value, valueCookie)) == -1 && this.isTomlVersionKey(value)) {
                                                                        tomlValue = this.findCorrespondingTomlKey(context, value);
                                                                        if (tomlValue == null) ** break;
                                                                        v0 = tomlValue.getActualValue();
                                                                        if (v0 != null && (v0 = v0.toString()) != null) {
                                                                            it = v0;
                                                                            $i$a$-let-GradleDetector$checkDslPropertyAssignment$tomlVersion$1 = false;
                                                                            v1 = this.getSdkVersion((String)it, valueCookie);
                                                                        } else {
                                                                            v1 = tomlVersion = -1;
                                                                        }
                                                                        if (tomlVersion == -1) ** break;
                                                                        this.checkTargetSdkVersion((Context)context, tomlVersion, tomlValue.getText(), statementCookie, false);
                                                                        ** break;
                                                                    }
                                                                    if (version < 0) {
                                                                        this.checkIntegerAsString(context, value, statementCookie, valueCookie);
                                                                        ** break;
                                                                    }
                                                                    GradleDetector.checkTargetSdkVersion$default(this, (Context)context, version, value, statementCookie, false, 16, null);
                                                                    ** break;
                                                                }
                                                            }
                                                            if ((version = this.getSdkVersion(value, valueCookie)) != -1 || !this.isTomlVersionKey(value)) break block89;
                                                            tomlValue = this.findCorrespondingTomlKey(context, value);
                                                            if (tomlValue == null) ** break;
                                                            v2 = tomlValue.getActualValue();
                                                            if (v2 != null && (v2 = v2.toString()) != null) {
                                                                it = v2;
                                                                $i$a$-let-GradleDetector$checkDslPropertyAssignment$tomlVersion$2 = false;
                                                                v3 = this.getSdkVersion((String)it, valueCookie);
                                                            } else {
                                                                v3 = tomlVersion = -1;
                                                            }
                                                            if (tomlVersion == -1) ** break;
                                                            if (context.getDriver().isIsolated()) ** GOTO lbl-1000
                                                            v4 = tomlValue.getKey();
                                                            Intrinsics.checkNotNull((Object)v4);
                                                            if (!com.android.tools.lint.checks.GradleDetector$Companion.access$isMinSdkTomlVersionKey(GradleDetector.Companion, v4)) lbl-1000:
                                                            // 2 sources

                                                            {
                                                                v5 = true;
                                                            } else {
                                                                v5 = false;
                                                            }
                                                            includeFix = v5;
                                                            this.checkMinSdkVersion((Context)context, tomlVersion, statementCookie, includeFix, tomlValue);
                                                            ** break;
                                                        }
                                                        if (version > 0) {
                                                            GradleDetector.checkMinSdkVersion$default(this, (Context)context, version, statementCookie, false, null, 24, null);
                                                            ** break;
                                                        }
                                                        this.checkIntegerAsString(context, value, statementCookie, valueCookie);
lbl68:
                                                        // 15 sources

                                                        if (StringsKt.startsWith$default((String)value, (String)"0", (boolean)false, (int)2, null)) {
                                                            this.checkOctal(context, value, valueCookie);
                                                        }
                                                        if (Intrinsics.areEqual((Object)property, (Object)"versionName") || Intrinsics.areEqual((Object)property, (Object)"versionCode") && !GradleContext.Companion.isNonNegativeInteger(value) || !GradleContext.Companion.isStringLiteral(value)) {
                                                            if (Intrinsics.areEqual((Object)value, (Object)"getVersionCode") || Intrinsics.areEqual((Object)value, (Object)"getVersionName")) {
                                                                message = "Bad method name: pick a unique method name which does not conflict with the implicit getters for the defaultConfig properties. For example, try using the prefix compute- instead of get-.";
                                                                GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.GRADLE_GETTER, message, null, false, null, null, null, 496, null);
                                                            }
                                                        } else if (Intrinsics.areEqual((Object)property, (Object)"packageName")) {
                                                            message = "Deprecated: Replace 'packageName' with 'applicationId'";
                                                            fix = this.fix().name("Replace 'packageName' with 'applicationId'", true).replace().text("packageName").with("applicationId").autoFix().build();
                                                            GradleDetector.report$default(this, (Context)context, propertyCookie, GradleDetector.DEPRECATED, message, fix, false, null, null, null, 480, null);
                                                        }
                                                        if (Intrinsics.areEqual((Object)property, (Object)"versionCode") && context.isEnabled(GradleDetector.HIGH_APP_VERSION_CODE) && GradleContext.Companion.isNonNegativeInteger(value) && (version = GradleContext.Companion.getIntLiteralValue(value, -1)) >= 2000000000) {
                                                            message = "The 'versionCode' is very high and close to the max allowed value";
                                                            GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.HIGH_APP_VERSION_CODE, message, null, false, null, null, null, 496, null);
                                                        }
                                                        break block90;
                                                    }
                                                    if (!Intrinsics.areEqual((Object)property, (Object)"compileSdkVersion") && !Intrinsics.areEqual((Object)property, (Object)"compileSdk") || !StringsKt.startsWith$default((String)parent, (String)"android", (boolean)false, (int)2, null) && (!Intrinsics.areEqual((Object)parent, (Object)"this") || !Intrinsics.areEqual((Object)parentParent, (Object)"android"))) break block91;
                                                    version = -1;
                                                    if (!GradleContext.Companion.isStringLiteral(value)) break block92;
                                                    hash = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
                                                    if (hash != null && !com.android.tools.lint.detector.api.Lint.isNumberString((String)hash)) {
                                                        if (Intrinsics.areEqual((Object)property, (Object)"compileSdk")) {
                                                            message = "`compileSdk` does not support strings; did you mean `compileSdkPreview` ?";
                                                            fix = this.fix().replace().text("compileSdk").with("compileSdkPreview").build();
                                                            GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.STRING_INTEGER, message, fix, false, null, null, null, 480, null);
                                                        }
                                                        if ((platformVersion = AndroidTargetHash.getPlatformVersion((String)hash)) != null) {
                                                            version = platformVersion.getFeatureLevel();
                                                        }
                                                    }
                                                    break block93;
                                                }
                                                if (!this.isTomlVersionKey(value)) break block94;
                                                tomlValue = this.findCorrespondingTomlKey(context, value);
                                                if (tomlValue == null) break block93;
                                                v6 = tomlValue.getActualValue();
                                                if (v6 != null && (v6 = v6.toString()) != null) {
                                                    it = v6;
                                                    $i$a$-let-GradleDetector$checkDslPropertyAssignment$level$1 = false;
                                                    v7 = this.getSdkVersion((String)it, valueCookie);
                                                } else {
                                                    v7 = level = -1;
                                                }
                                                if (level == -1) break block93;
                                                if (context.getDriver().isIsolated()) ** GOTO lbl-1000
                                                v8 = tomlValue.getKey();
                                                Intrinsics.checkNotNull((Object)v8);
                                                if (!GradleDetector.Companion.isCompileSdkTomlVersionKey(v8)) lbl-1000:
                                                // 2 sources

                                                {
                                                    v9 = true;
                                                } else {
                                                    v9 = false;
                                                }
                                                includeFix = v9;
                                                this.checkCompileSdkVersionLatest((Context)context, level, statementCookie, includeFix, tomlValue);
                                                break block93;
                                            }
                                            version = GradleContext.Companion.getIntLiteralValue(value, -1);
                                        }
                                        if (version <= 0) {
                                            this.checkIntegerAsString(context, value, statementCookie, valueCookie);
                                        } else {
                                            GradleDetector.checkCompileSdkVersionLatest$default(this, (Context)context, version, statementCookie, false, null, 24, null);
                                        }
                                        break block90;
                                    }
                                    if (!Intrinsics.areEqual((Object)parent, (Object)"plugins")) break block95;
                                    tomlValue = property;
                                    tomlValue = plugin = Intrinsics.areEqual((Object)tomlValue, (Object)"id") ? GradleContext.Companion.getStringLiteralValue(value, valueCookie) : (Intrinsics.areEqual((Object)tomlValue, (Object)"alias") ? ((v10 = com.android.tools.lint.checks.GradleDetector$Companion.access$getPluginFromVersionCatalog(GradleDetector.Companion, value, context)) != null && (v10 = v10.getCoordinates()) != null ? StringsKt.substringBefore$default((String)v10, (char)':', null, (int)2, null) : null) : null);
                                    if (tomlValue != null) {
                                        if (Intrinsics.areEqual((Object)tomlValue, (Object)"kotlin-android") || Intrinsics.areEqual((Object)tomlValue, (Object)"org.jetbrains.kotlin.android")) {
                                            this.mAppliedKotlinAndroidPlugin = true;
                                        } else if (Intrinsics.areEqual((Object)tomlValue, (Object)"kotlin-kapt") || Intrinsics.areEqual((Object)tomlValue, (Object)"org.jetbrains.kotlin.kapt")) {
                                            this.mAppliedKotlinKaptPlugin = true;
                                        } else if (Intrinsics.areEqual((Object)tomlValue, (Object)"com.google.devtools.ksp")) {
                                            this.mAppliedKspPlugin = true;
                                        } else if (GradleDetector.JAVA_PLUGIN_IDS.contains(tomlValue)) {
                                            this.mAppliedJavaPlugin = true;
                                            this.mJavaPluginInfo = new JavaPluginInfo(statementCookie);
                                        } else if (Intrinsics.areEqual((Object)tomlValue, (Object)"android") || Intrinsics.areEqual((Object)tomlValue, (Object)"android-library")) {
                                            isOldAppPlugin = Intrinsics.areEqual((Object)"android", (Object)plugin);
                                            replaceWith = isOldAppPlugin != false ? "com.android.application" : "com.android.library";
                                            message = "'" + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                                            fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                                            GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.DEPRECATED, message, fix, false, null, null, null, 480, null);
                                        }
                                    }
                                    break block90;
                                }
                                if (!Intrinsics.areEqual((Object)parentParent, (Object)"plugins") || !Intrinsics.areEqual((Object)property, (Object)"version")) break block96;
                                version = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
                                if (version != null) {
                                    gradleCoordinate = parent + ":" + parent + ".gradle.plugin:" + version;
                                    dependency = Dependency.Companion.parse(gradleCoordinate);
                                    context.getDriver().runLaterOutsideReadAction(new Runnable(this, context, dependency, valueCookie, statementCookie){
                                        final /* synthetic */ GradleDetector this$0;
                                        final /* synthetic */ GradleContext $context;
                                        final /* synthetic */ Dependency $dependency;
                                        final /* synthetic */ Object $valueCookie;
                                        final /* synthetic */ Object $statementCookie;
                                        {
                                            this.this$0 = $receiver;
                                            this.$context = $context;
                                            this.$dependency = $dependency;
                                            this.$valueCookie = $valueCookie;
                                            this.$statementCookie = $statementCookie;
                                        }

                                        public final void run() {
                                            GradleDetector.access$checkDependency(this.this$0, (Context)this.$context, this.$dependency, false, this.$valueCookie, this.$statementCookie);
                                        }
                                    });
                                }
                                break block90;
                            }
                            if (!Intrinsics.areEqual((Object)parent, (Object)"dependencies") && !Intrinsics.areEqual((Object)parent, (Object)"declarativeDependencies") && (!Intrinsics.areEqual((Object)parentParent, (Object)"dependencies") || !Intrinsics.areEqual((Object)property, (Object)"implementation"))) break block97;
                            if (!StringsKt.startsWith$default((String)value, (String)"files", (boolean)false, (int)2, null) || !new Regex("^files\\(['\"].*[\"']\\)$").matches(version = (CharSequence)value)) break block98;
                            v11 = value.substring(7, value.length() - 2);
                            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"substring(...)");
                            path = v11;
                            if (StringsKt.contains$default((CharSequence)path, (CharSequence)"\\\\", (boolean)false, (int)2, null)) {
                                fix = this.fix().replace().text(path).with(StringsKt.replace$default((String)path, (String)"\\\\", (String)"/", (boolean)false, (int)4, null)).build();
                                message = "Do not use Windows file separators in .gradle files; use / instead";
                                GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.PATH, message, fix, false, null, null, null, 480, null);
                            } else if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || new File(StringsKt.replace$default((String)path, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null)).isAbsolute()) {
                                message = "Avoid using absolute paths in .gradle files";
                                GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.PATH, message, null, false, null, null, null, 496, null);
                            }
                            this.checkDeprecatedConfigurations(property, context, propertyCookie);
                            break block90;
                        }
                        dependencyString = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
                        if (dependencyString == null) {
                            block87: {
                                message = new String[]{"platform", "testFixtures", "enforcedPlatform"};
                                $this$any$iv = CollectionsKt.listOf((Object[])message);
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    v12 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        it = (Object[])element$iv;
                                        $i$a$-any-GradleDetector$checkDslPropertyAssignment$2 = false;
                                        if (!StringsKt.startsWith$default((String)value, (String)((String)it + "("), (boolean)false, (int)2, null)) continue;
                                        v12 = true;
                                        break block87;
                                    }
                                    v12 = false;
                                }
                            }
                            if (v12 && StringsKt.endsWith$default((String)value, (String)")", (boolean)false, (int)2, null)) {
                                v13 = value.substring(StringsKt.indexOf$default((CharSequence)value, (char)'(', (int)0, (boolean)false, (int)6, null) + 1, value.length() - 1);
                                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"substring(...)");
                                argumentString = v13;
                                v14 = dependencyString = valueCookie instanceof UCallExpression != false && ((UCallExpression)valueCookie).getValueArguments().size() == 1 ? GradleContext.Companion.getStringLiteralValue(argumentString, CollectionsKt.first((List)((UCallExpression)valueCookie).getValueArguments())) : GradleContext.Companion.getStringLiteralValue(argumentString, valueCookie);
                            }
                        }
                        if (dependencyString == null) {
                            dependencyString = GradleDetector.Companion.getNamedDependency(value);
                        }
                        if (dependencyString == null) break block99;
                        dependency = new Ref.ObjectRef();
                        dependency.element = Dependency.Companion.parse(dependencyString);
                        isResolved = new Ref.BooleanRef();
                        if (dependency.element == null) ** GOTO lbl-1000
                        v15 /* !! */  = ((Dependency)dependency.element).getVersion();
                        v16 = v15 /* !! */  != null && (v15 /* !! */  = v15 /* !! */ .toIdentifier()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)v15 /* !! */ ), (CharSequence)"$", (boolean)false, (int)2, null) : false;
                        if (v16) {
                            if (StringsKt.startsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && context.isEnabled(GradleDetector.NOT_INTERPOLATED)) {
                                message = "It looks like you are trying to substitute a version variable, but using single quotes ('). For Groovy string interpolation you must use double quotes (\").";
                                v17 = this.fix().name("Replace single quotes with double quotes").replace().text(value);
                                v18 = value.substring(1, value.length() - 1);
                                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"substring(...)");
                                fix = v17.with("\"" + v18 + "\"").build();
                                GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.NOT_INTERPOLATED, (String)message, fix, false, null, null, null, 480, null);
                            }
                            dependency.element = this.resolveCoordinate(context, property, (Dependency)dependency.element);
                            isResolved.element = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            if ((v19 /* !! */  = (Dependency)dependency.element) != null && (v19 /* !! */  = v19 /* !! */ .getVersion()) != null && (v19 /* !! */  = v19 /* !! */ .toIdentifier()) != null) {
                                it /* !! */  = v19 /* !! */ ;
                                $i$a$-let-GradleDetector$checkDslPropertyAssignment$3 = false;
                                v20 = !StringsKt.contains$default((CharSequence)value, (CharSequence)((CharSequence)it /* !! */ ), (boolean)false, (int)2, null);
                                v21 = !v20;
                            } else {
                                v21 = false;
                            }
                            if (!v21) {
                                isResolved.element = true;
                            }
                        }
                        if (dependency.element == null) break block100;
                        v22 /* !! */  = ((Dependency)dependency.element).getVersion();
                        if (v22 /* !! */  == null) ** GOTO lbl-1000
                        $this$checkDslPropertyAssignment_u24lambda_u245 = v22 /* !! */ ;
                        $i$a$-run-GradleDetector$checkDslPropertyAssignment$4 = false;
                        v23 = $this$checkDslPropertyAssignment_u24lambda_u245.getRequire();
                        if (v23 == null) {
                            v23 = $this$checkDslPropertyAssignment_u24lambda_u245.getStrictly();
                        }
                        v22 /* !! */  = v23;
                        if (v23 != null && (v22 /* !! */  = v22 /* !! */ .toIdentifier()) != null) {
                            v24 = StringsKt.endsWith$default((String)v22 /* !! */ , (String)"+", (boolean)false, (int)2, null);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v24 = false;
                        }
                        if (v24) {
                            message = "Avoid using + in version numbers; can lead to unpredictable and unrepeatable builds (" + dependencyString + ")";
                            it = new Object[4];
                            it[0] = "coordinate";
                            it[1] = ((Dependency)dependency.element).toString();
                            it[2] = "revision";
                            v25 = ((Dependency)dependency.element).getVersion();
                            it[3] = v25 != null ? v25.toIdentifier() : null;
                            fix = this.fix().data(it);
                            GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.PLUS, (String)message, fix, false, null, null, null, 480, null);
                        }
                        if ((tomlLibraries = GradleContext.getTomlValue$default((GradleContext)context, (String)"libraries", (boolean)false, (int)2, null)) != null) {
                            v26 = context.file.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"getName(...)");
                            if (!StringsKt.startsWith$default((String)v26, (String)"settings.gradle", (boolean)false, (int)2, null)) {
                                v27 = context.file.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)v27, (String)"getName(...)");
                                if (!(StringsKt.endsWith$default((String)v27, (String)".gradle.dcl", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)dependencyString, (CharSequence)"+", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)dependencyString, (CharSequence)"$", (boolean)false, (int)2, null) && !isResolved.element)) {
                                    v28 = ((Dependency)dependency.element).getGroup();
                                    v29 = v28 != null ? StringsKt.isBlank((CharSequence)v28) == false : false;
                                    if (v29 && (result = Lint.createMoveToTomlFix(context, tomlLibraries, (Dependency)dependency.element, valueCookie, versionVar = this.getVersionVariable(value))) != null) {
                                        v30 = (String)result.getFirst();
                                        if (v30 == null) {
                                            v30 = "Use version catalog instead";
                                        }
                                        message = v30;
                                        fix = (LintFix)result.getSecond();
                                        GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.SWITCH_TO_TOML, message, fix, false, null, null, null, 480, null);
                                    }
                                }
                            }
                        }
                        context.getDriver().runLaterOutsideReadAction(new Runnable(this, context, (Ref.ObjectRef<Dependency>)dependency, isResolved, valueCookie, statementCookie){
                            final /* synthetic */ GradleDetector this$0;
                            final /* synthetic */ GradleContext $context;
                            final /* synthetic */ Ref.ObjectRef<Dependency> $dependency;
                            final /* synthetic */ Ref.BooleanRef $isResolved;
                            final /* synthetic */ Object $valueCookie;
                            final /* synthetic */ Object $statementCookie;
                            {
                                this.this$0 = $receiver;
                                this.$context = $context;
                                this.$dependency = $dependency;
                                this.$isResolved = $isResolved;
                                this.$valueCookie = $valueCookie;
                                this.$statementCookie = $statementCookie;
                            }

                            public final void run() {
                                GradleDetector.access$checkDependency(this.this$0, (Context)this.$context, (Dependency)this.$dependency.element, this.$isResolved.element, this.$valueCookie, this.$statementCookie);
                            }
                        });
                    }
                    if (com.android.tools.lint.checks.GradleDetector$Companion.access$hasLifecycleAnnotationProcessor(GradleDetector.Companion, dependencyString) && com.android.tools.lint.checks.GradleDetector$Companion.access$targetJava8Plus(GradleDetector.Companion, context.getProject())) {
                        GradleDetector.report$default(this, (Context)context, valueCookie, GradleDetector.LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8, "Use the Lifecycle Java 8 API provided by the `lifecycle-common` library instead of Lifecycle annotations for faster incremental build.", null, false, null, null, null, 480, null);
                    }
                    this.checkAnnotationProcessorOnCompilePath(property, dependencyString, context, propertyCookie);
                }
                this.checkDeprecatedConfigurations(property, context, propertyCookie);
                libTomlValue = null;
                if (dependencyString == null && (dependencyFromVc = com.android.tools.lint.checks.GradleDetector$Companion.access$getDependencyFromVersionCatalog(GradleDetector.Companion, value, context)) != null) {
                    dependencyString = dependencyFromVc.getCoordinates();
                    libTomlValue = dependencyFromVc.getTomlValue();
                }
                if (dependencyString != null) {
                    if (Intrinsics.areEqual((Object)property, (Object)"kapt")) {
                        this.checkKaptUsage(dependencyString, libTomlValue, context, statementCookie);
                    }
                    this.checkForBomUsageWithoutPlatform(property, dependencyString, value, context, valueCookie);
                }
                break block90;
            }
            if (Intrinsics.areEqual((Object)property, (Object)"packageNameSuffix")) {
                message = "Deprecated: Replace 'packageNameSuffix' with 'applicationIdSuffix'";
                fix = this.fix().name("Replace 'packageNameSuffix' with 'applicationIdSuffix'", true).replace().text("packageNameSuffix").with("applicationIdSuffix").autoFix().build();
                GradleDetector.report$default(this, (Context)context, propertyCookie, GradleDetector.DEPRECATED, message, fix, false, null, null, null, 480, null);
            } else if (Intrinsics.areEqual((Object)property, (Object)"applicationIdSuffix")) {
                suffix = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
                if (suffix != null && !StringsKt.startsWith$default((String)suffix, (String)".", (boolean)false, (int)2, null)) {
                    message = "Application ID suffix should probably start with a \".\"";
                    GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.PATH, message, null, false, null, null, null, 496, null);
                }
            } else if ((Intrinsics.areEqual((Object)property, (Object)"minSdkVersion") || Intrinsics.areEqual((Object)property, (Object)"minSdk")) && Intrinsics.areEqual((Object)parent, (Object)"dev") && Intrinsics.areEqual((Object)"21", (Object)value) && !Intrinsics.areEqual((Object)"gradle", (Object)LintClient.Companion.getClientName())) {
                GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.DEV_MODE_OBSOLETE, "You no longer need a `dev` mode to enable multi-dexing during development, and this can break API version checks", null, false, null, null, null, 496, null);
            } else if (Intrinsics.areEqual((Object)parent, (Object)"dataBinding") && (Intrinsics.areEqual((Object)property, (Object)"enabled") || Intrinsics.areEqual((Object)property, (Object)"isEnabled")) || Intrinsics.areEqual((Object)parent, (Object)"buildFeatures") && Intrinsics.areEqual((Object)property, (Object)"dataBinding")) {
                if (Intrinsics.areEqual((Object)value, (Object)"true") && this.mAppliedKotlinAndroidPlugin && !this.mAppliedKotlinKaptPlugin) {
                    message = "If you plan to use data binding in a Kotlin project, you should apply the kotlin-kapt plugin.";
                    GradleDetector.report$default(this, (Context)context, statementCookie, GradleDetector.DATA_BINDING_WITHOUT_KAPT, message, null, false, null, null, null, 480, null);
                }
            } else if ((Intrinsics.areEqual((Object)parent, (Object)"") || Intrinsics.areEqual((Object)parent, (Object)"java")) && Intrinsics.areEqual((Object)property, (Object)"sourceCompatibility")) {
                this.mDeclaredSourceCompatibility = true;
            } else if ((Intrinsics.areEqual((Object)parent, (Object)"") || Intrinsics.areEqual((Object)parent, (Object)"java")) && Intrinsics.areEqual((Object)property, (Object)"targetCompatibility")) {
                this.mDeclaredTargetCompatibility = true;
            } else if (Intrinsics.areEqual((Object)property, (Object)"include") && Intrinsics.areEqual((Object)parent, (Object)"abi") || Intrinsics.areEqual((Object)property, (Object)"abiFilters") && Intrinsics.areEqual((Object)parent, (Object)"ndk")) {
                this.checkForChromeOSAbiSplits(context, valueCookie, value);
            } else if (Intrinsics.areEqual((Object)parent, (Object)"toolchain") && Intrinsics.areEqual((Object)property, (Object)"languageVersion")) {
                this.mDeclaredSourceCompatibility = true;
                this.mDeclaredTargetCompatibility = true;
            }
        }
    }

    private final boolean isTomlVersionKey(String value) {
        return StringsKt.startsWith$default((String)value, (String)"libs.versions.", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)".get().toInt()", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LintTomlValue findCorrespondingTomlKey(GradleContext context, String value) {
        Object v1;
        block1: {
            if (!this.isTomlVersionKey(value)) return null;
            String key = StringsKt.removeSurrounding((String)value, (CharSequence)"libs.versions.", (CharSequence)".get().toInt()");
            Object object = GradleContext.getTomlValue$default((GradleContext)context, (String)"versions", (boolean)false, (int)2, null);
            if (!(object instanceof LintTomlMapValue)) return null;
            LintTomlMapValue lintTomlMapValue = (LintTomlMapValue)object;
            LintTomlMapValue lintTomlMapValue2 = lintTomlMapValue;
            if (lintTomlMapValue2 == null) return null;
            object = lintTomlMapValue2.getMappedValues();
            if (object == null) return null;
            Iterable iterable = object.entrySet();
            if (iterable == null) return null;
            Iterable iterable2 = iterable;
            for (Object t2 : iterable2) {
                Map.Entry it = (Map.Entry)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)StringsKt.replace$default((String)((String)it.getKey()), (char)'-', (char)'.', (boolean)false, (int)4, null), (char)'_', (char)'.', (boolean)false, (int)4, null), (Object)key)) continue;
                v1 = t2;
                break block1;
            }
            v1 = null;
        }
        Map.Entry entry = v1;
        if (entry == null) return null;
        LintTomlValue lintTomlValue = (LintTomlValue)entry.getValue();
        return lintTomlValue;
    }

    private final void checkTargetSdkVersion(Context context, int version, String versionString, Object statementCookie, boolean includeFix) {
        if (version > 0 && version < context.getClient().getHighestKnownApiLevel()) {
            Calendar calendar = GradleDetector.calendar;
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            Calendar calendar2 = calendar;
            Intrinsics.checkNotNull((Object)calendar2);
            TargetSdkCheckResult tsdk = TargetSdkCheckKt.checkTargetSdk((Context)context, calendar2, version);
            if (tsdk instanceof TargetSdkCheckResult.Expired) {
                boolean alreadySuppressed;
                Object[] objectArray = context;
                boolean bl = objectArray instanceof GradleContext ? context.containsCommentSuppress() && ((GradleContext)context).isSuppressedWithComment(statementCookie, EXPIRING_TARGET_SDK_VERSION) : (objectArray instanceof TomlContext ? context.containsCommentSuppress() && ((TomlContext)context).isSuppressedWithComment(statementCookie, EXPIRING_TARGET_SDK_VERSION) : (alreadySuppressed = false));
                if (!alreadySuppressed) {
                    objectArray = new Object[]{"currentTargetSdkVersion", version};
                    Object[] objectArray2 = objectArray = this.fix().data(objectArray);
                    String string = ((TargetSdkCheckResult.Expired)tsdk).getMessage();
                    Issue issue = EXPIRED_TARGET_SDK_VERSION;
                    Object object = statementCookie;
                    Object[] objectArray3 = context;
                    GradleDetector gradleDetector = this;
                    boolean bl2 = false;
                    boolean bl3 = LintClient.Companion.isStudio();
                    GradleDetector.report$default(gradleDetector, (Context)objectArray3, object, issue, string, (LintFix)(bl3 ? objectArray : null), false, null, null, null, 480, null);
                }
            } else if (tsdk instanceof TargetSdkCheckResult.Expiring) {
                Object[] alreadySuppressed = new Object[]{"currentTargetSdkVersion", version};
                Object[] objectArray = alreadySuppressed = this.fix().data(alreadySuppressed);
                String string = ((TargetSdkCheckResult.Expiring)tsdk).getMessage();
                Issue issue = EXPIRING_TARGET_SDK_VERSION;
                Object object = statementCookie;
                Object[] objectArray4 = context;
                GradleDetector gradleDetector = this;
                boolean bl = false;
                boolean bl4 = LintClient.Companion.isStudio();
                GradleDetector.report$default(gradleDetector, (Context)objectArray4, object, issue, string, (LintFix)(bl4 ? alreadySuppressed : null), false, null, null, null, 480, null);
            } else if (tsdk instanceof TargetSdkCheckResult.NotLatest) {
                LintFix lintFix;
                int highest = ((TargetSdkCheckResult.NotLatest)tsdk).getHighestVersion();
                String label = "Update targetSdkVersion to " + highest;
                if (LintClient.Companion.isStudio()) {
                    Object[] objectArray = new Object[]{"currentTargetSdkVersion", version};
                    lintFix = this.fix().data(objectArray);
                } else {
                    lintFix = includeFix ? this.fix().name(label).replace().text(versionString).with(String.valueOf(highest)).build() : null;
                }
                LintFix fix2 = lintFix;
                GradleDetector.report$default(this, (Context)context, statementCookie, TARGET_NEWER, ((TargetSdkCheckResult.NotLatest)tsdk).getMessage(), fix2, false, null, null, null, 480, null);
            } else if (!(tsdk instanceof TargetSdkCheckResult.NoIssue)) {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (version > 0 && LintClient.Companion.isStudio()) {
            if (lastTargetSdkVersion == -1 || !Intrinsics.areEqual((Object)lastTargetSdkVersionFile, (Object)context.file)) {
                lastTargetSdkVersion = version;
                lastTargetSdkVersionFile = context.file;
            } else if (version > lastTargetSdkVersion) {
                String message2 = "It looks like you just edited the `targetSdkVersion` from " + lastTargetSdkVersion + " to " + version + " in the editor. Be sure to consult the documentation on the behaviors that change as result of this. The Android SDK Upgrade Assistant can help with safely migrating.";
                Object[] objectArray = new Object[]{"currentTargetSdkVersion", version};
                GradleDetector.report$default(this, (Context)context, statementCookie, EDITED_TARGET_SDK_VERSION, message2, this.fix().data(objectArray), false, null, null, null, 480, null);
            }
        }
    }

    static /* synthetic */ void checkTargetSdkVersion$default(GradleDetector gradleDetector, Context context, int n, String string, Object object, boolean bl, int n2, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkTargetSdkVersion");
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        gradleDetector.checkTargetSdkVersion(context, n, string, object, bl);
    }

    private final void checkCompileSdkVersionLatest(Context context, int version, Object cookie, boolean includeFix, Object fixCookie) {
        if (version < 36) {
            LintFix lintFix;
            String message2 = "A newer version of `compileSdkVersion` than " + version + " is available: 36";
            if (includeFix) {
                LintFix.ReplaceStringBuilder replaceStringBuilder;
                LintFix.ReplaceStringBuilder $this$checkCompileSdkVersionLatest_u24lambda_u249 = replaceStringBuilder = this.fix().name("Set compileSdkVersion to 36").replace().text(String.valueOf(version)).with("36");
                boolean bl = false;
                if (fixCookie instanceof LintTomlValue) {
                    $this$checkCompileSdkVersionLatest_u24lambda_u249.range(((LintTomlValue)fixCookie).getLocation());
                }
                lintFix = replaceStringBuilder.build();
            } else {
                lintFix = null;
            }
            LintFix fix2 = lintFix;
            GradleDetector.report$default(this, context, cookie, DEPENDENCY, message2, fix2, false, null, null, null, 480, null);
        }
    }

    static /* synthetic */ void checkCompileSdkVersionLatest$default(GradleDetector gradleDetector, Context context, int n, Object object, boolean bl, Object object2, int n2, Object object3) {
        if (object3 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkCompileSdkVersionLatest");
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            object2 = null;
        }
        gradleDetector.checkCompileSdkVersionLatest(context, n, object, bl, object2);
    }

    private final String getVersionVariable(String dependency) {
        boolean bl;
        String value;
        block7: {
            if (!StringsKt.contains$default((CharSequence)dependency, (CharSequence)"$", (boolean)false, (int)2, null)) {
                return null;
            }
            value = StringsKt.substringAfterLast$default((String)StringsKt.removeSurrounding((String)StringsKt.removeSurrounding((String)dependency, (CharSequence)"'"), (CharSequence)"\""), (char)':', null, (int)2, null);
            if (StringsKt.startsWith$default((String)value, (String)"$", (boolean)false, (int)2, null)) {
                if (StringsKt.startsWith$default((String)value, (String)"${", (boolean)false, (int)2, null)) {
                    int end = StringsKt.indexOf$default((CharSequence)value, (char)'}', (int)0, (boolean)false, (int)6, null);
                    if (end == -1 || end < value.length() - 1 && value.charAt(end + 1) != '@') {
                        return null;
                    }
                    value = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)value, (CharSequence)"${"), (CharSequence)"}");
                } else {
                    value = StringsKt.removePrefix((String)value, (CharSequence)"$");
                }
            } else {
                return null;
            }
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isLetter(it)) continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        return bl ? value : null;
    }

    private final void checkForChromeOSAbiSplits(GradleContext context, Object valueCookie, String value) {
        block1: {
            String message2;
            char[] cArray = new char[]{','};
            List abis = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean hasX8664 = false;
            int n = ((Collection)abis).size();
            for (int i = 0; i < n; ++i) {
                if (!StringsKt.contains$default((CharSequence)((CharSequence)abis.get(i)), (CharSequence)"\"x86_64\"", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)((CharSequence)abis.get(i)), (CharSequence)"'x86_64'", (boolean)false, (int)2, null)) continue;
                hasX8664 = true;
            }
            String string = message2 = !hasX8664 ? "Missing x86_64 ABI support for ChromeOS" : null;
            if (string == null) break block1;
            String m = string;
            boolean bl = false;
            GradleDetector.report$default(this, (Context)context, valueCookie, CHROMEOS_ABI_SUPPORT, m, null, false, null, null, null, 496, null);
        }
    }

    private final void checkDeprecatedConfigurations(String configuration, GradleContext context, Object propertyCookie) {
        AgpVersion agpVersion = context.getProject().getGradleModelVersion();
        boolean bl = agpVersion != null ? !agpVersion.isAtLeastIncludingPreviews(3, 0, 0) : false;
        if (bl) {
            return;
        }
        for (DeprecatedConfiguration deprecatedConfiguration : DeprecatedConfiguration.getEntries()) {
            boolean bl2;
            if (!deprecatedConfiguration.matches(configuration)) continue;
            if (deprecatedConfiguration == DeprecatedConfiguration.COMPILE && GradleDetector.Companion.suggestApiConfigurationUse(context.getProject(), configuration)) {
                Object implementation = null;
                Object api2 = null;
                if (Intrinsics.areEqual((Object)configuration, (Object)"compile")) {
                    implementation = "implementation";
                    api2 = "api";
                } else {
                    String prefix = StringsKt.removeSuffix((String)configuration, (CharSequence)"Compile");
                    implementation = prefix + "Implementation";
                    api2 = prefix + "Api";
                }
                String message2 = "`" + configuration + "` is deprecated; replace with either `" + (String)api2 + "` to maintain current behavior, or `" + (String)implementation + "` to improve build performance by not sharing this dependency transitively.";
                LintFix apiFix = this.fix().name("Replace '" + configuration + "' with '" + (String)api2 + "'").family("Replace compile with api").replace().text(configuration).with((String)api2).autoFix().build();
                LintFix implementationFix = this.fix().name("Replace '" + configuration + "' with '" + (String)implementation + "'").family("Replace compile with implementation").replace().text(configuration).with((String)implementation).autoFix().build();
                LintFix fixes = this.fix().alternatives().name("Replace '" + configuration + "' with '" + (String)api2 + "' or '" + (String)implementation + "'").add(apiFix).add(implementationFix).build();
                bl2 = GradleDetector.report$default(this, (Context)context, propertyCookie, DEPRECATED_CONFIGURATION, message2, fixes, false, null, null, null, 480, null);
                continue;
            }
            String replacement = deprecatedConfiguration.replacement(configuration);
            String message3 = "`" + configuration + "` is deprecated; replace with `" + replacement + "`";
            LintFix fix2 = this.fix().name("Replace '" + configuration + "' with '" + replacement + "'").family("Replace deprecated configurations").replace().text(configuration).with(replacement).autoFix().build();
            bl2 = GradleDetector.report$default(this, (Context)context, propertyCookie, DEPRECATED_CONFIGURATION, message3, fix2, false, null, null, null, 480, null);
        }
    }

    private final void checkAnnotationProcessorOnCompilePath(String configuration, String dependency, GradleContext context, Object propertyCookie) {
        for (Companion.CompileConfiguration compileConfiguration : Companion.CompileConfiguration.getEntries()) {
            if (!compileConfiguration.matches(configuration) || !GradleDetector.Companion.isCommonAnnotationProcessor(dependency)) continue;
            String replacement = compileConfiguration.replacement(configuration);
            LintFix fix2 = this.fix().name("Replace " + configuration + " with " + replacement).family("Replace compile classpath with annotationProcessor").replace().text(configuration).with(replacement).autoFix().build();
            String message2 = "Add annotation processor to processor path using `" + replacement + "` instead of `" + configuration + "`";
            GradleDetector.report$default(this, (Context)context, propertyCookie, ANNOTATION_PROCESSOR_ON_COMPILE_PATH, message2, fix2, false, null, null, null, 480, null);
        }
    }

    private final void checkMinSdkVersion(Context context, int version, Object valueCookie, boolean includeFix, Object fixCookie) {
        boolean bl = 1 <= version ? version < 16 : false;
        if (bl) {
            LintFix lintFix;
            String message2 = "The value of minSdkVersion (" + version + ") is too low. It can be incremented without noticeably reducing the number of supported devices.";
            String label = "Update minSdkVersion to 16";
            if (includeFix) {
                LintFix.ReplaceStringBuilder replaceStringBuilder;
                LintFix.ReplaceStringBuilder $this$checkMinSdkVersion_u24lambda_u2412 = replaceStringBuilder = this.fix().name(label).replace().text(String.valueOf(version)).with("16");
                boolean bl2 = false;
                if (fixCookie instanceof LintTomlValue) {
                    $this$checkMinSdkVersion_u24lambda_u2412.range(((LintTomlValue)fixCookie).getLocation());
                }
                lintFix = replaceStringBuilder.build();
            } else {
                lintFix = null;
            }
            LintFix fix2 = lintFix;
            GradleDetector.report$default(this, context, valueCookie, MIN_SDK_TOO_LOW, message2, fix2, false, null, null, null, 480, null);
        }
    }

    static /* synthetic */ void checkMinSdkVersion$default(GradleDetector gradleDetector, Context context, int n, Object object, boolean bl, Object object2, int n2, Object object3) {
        if (object3 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkMinSdkVersion");
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            object2 = null;
        }
        gradleDetector.checkMinSdkVersion(context, n, object, bl, object2);
    }

    private final void checkIntegerAsString(GradleContext context, String value, Object cookie, Object valueCookie) {
        String string = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
        if (com.android.tools.lint.detector.api.Lint.isNumberString((String)string)) {
            String message2 = "Use an integer rather than a string here (replace " + value + " with just " + string + ")";
            LintFix fix2 = this.fix().name("Replace with integer", true).replace().text(value).with(string).build();
            GradleDetector.report$default(this, (Context)context, cookie, STRING_INTEGER, message2, fix2, false, null, null, null, 480, null);
        }
    }

    public void checkMethodCall(@NotNull GradleContext context, @NotNull String statement, @Nullable String parent, @Nullable String parentParent, @NotNull Map<String, String> namedArguments, @NotNull List<String> unnamedArguments, @NotNull Object cookie) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter(namedArguments, (String)"namedArguments");
        Intrinsics.checkNotNullParameter(unnamedArguments, (String)"unnamedArguments");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        String plugin = namedArguments.get("plugin");
        if (Intrinsics.areEqual((Object)statement, (Object)"apply") && parent == null) {
            boolean isOldAppPlugin = Intrinsics.areEqual((Object)OLD_APP_PLUGIN_ID, (Object)plugin);
            if (isOldAppPlugin || Intrinsics.areEqual((Object)OLD_LIB_PLUGIN_ID, (Object)plugin)) {
                String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
                String message2 = "'" + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                LintFix fix2 = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                GradleDetector.report$default(this, (Context)context, cookie, DEPRECATED, message2, fix2, false, null, null, null, 480, null);
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-android")) {
                this.mAppliedKotlinAndroidPlugin = true;
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-kapt")) {
                this.mAppliedKotlinKaptPlugin = true;
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"com.google.devtools.ksp")) {
                this.mAppliedKspPlugin = true;
            }
            if (CollectionsKt.contains((Iterable)JAVA_PLUGIN_IDS, (Object)plugin)) {
                this.mAppliedJavaPlugin = true;
                this.mJavaPluginInfo = new JavaPluginInfo(cookie);
            }
        }
        if (Intrinsics.areEqual((Object)parent, (Object)"repositories") && Intrinsics.areEqual((Object)parentParent, (Object)"buildscript")) {
            if (Intrinsics.areEqual((Object)statement, (Object)"google")) {
                this.mDeclaredGoogleMavenRepository = true;
            }
            this.mDeclaredBuildscriptRepository = true;
        }
        if (Intrinsics.areEqual((Object)statement, (Object)"jcenter") && Intrinsics.areEqual((Object)parent, (Object)"repositories")) {
            String message3 = "JCenter Maven repository is no longer receiving updates: newer library versions may be available elsewhere";
            LintFix replaceFix = this.fix().name("Replace with mavenCentral").replace().text("jcenter").with("mavenCentral").build();
            LintFix deleteFix = this.fix().name("Delete this repository declaration").replace().all().with("").build();
            LintFix[] lintFixArray = new LintFix[]{replaceFix, deleteFix};
            GradleDetector.report$default(this, (Context)context, cookie, JCENTER_REPOSITORY_OBSOLETE, message3, this.fix().alternatives(lintFixArray), false, null, null, null, 480, null);
        } else if ((Intrinsics.areEqual((Object)parent, (Object)"dependencies") || Intrinsics.areEqual((Object)parent, (Object)"declarativeDependencies")) && !Intrinsics.areEqual((Object)statement, (Object)"files") && cookie instanceof UCallExpression && ((UCallExpression)cookie).getValueArgumentCount() >= 3) {
            Pair<Dependency, KtElement> pair = Companion.getKtsDependency((UCallExpression)cookie);
            if (pair == null) {
                return;
            }
            Pair<Dependency, KtElement> pair2 = pair;
            Dependency dependency = (Dependency)pair2.component1();
            KtElement versionElement = (KtElement)pair2.component2();
            context.getDriver().runLaterOutsideReadAction(new Runnable(this, context, dependency, versionElement, cookie){
                final /* synthetic */ GradleDetector this$0;
                final /* synthetic */ GradleContext $context;
                final /* synthetic */ Dependency $dependency;
                final /* synthetic */ KtElement $versionElement;
                final /* synthetic */ Object $cookie;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$dependency = $dependency;
                    this.$versionElement = $versionElement;
                    this.$cookie = $cookie;
                }

                public final void run() {
                    GradleDetector.access$checkDependency(this.this$0, (Context)this.$context, this.$dependency, false, this.$versionElement, this.$cookie);
                }
            });
        }
    }

    private final void checkDependency(Context context, Dependency dependency, boolean isResolved, Object cookie, Object statementCookie) {
        Version latest;
        List<LintModelDependency> path;
        RichVersion richVersion = dependency.getVersion();
        if (richVersion == null || (richVersion = richVersion.getLowerBound()) == null) {
            return;
        }
        RichVersion version = richVersion;
        String string = dependency.getGroup();
        if (string == null) {
            return;
        }
        String groupId = string;
        String artifactId = dependency.getName();
        Object object = dependency.getVersion();
        if (object == null || (object = object.toIdentifier()) == null) {
            return;
        }
        Object richVersionIdentifier = object;
        Version safeReplacement = null;
        Object newerVersion = null;
        GooglePlaySdkIndex sdkIndex = this.getGooglePlaySdkIndex(context.getClient());
        Predicate<Version> versionFilter = Companion.getUpgradeVersionFilter(context, groupId, artifactId, (Version)version);
        Collection<LibraryVersionRange> recommendedVersions = sdkIndex.recommendedVersions(groupId, artifactId, version.toString());
        Predicate<Version> sdkIndexFilter = this.getGooglePlaySdkIndexFilter(groupId, artifactId, recommendedVersions, sdkIndex);
        Predicate<Version> filter2 = GradleDetector.checkDependency$and(versionFilter, sdkIndexFilter);
        switch (groupId) {
            case "com.google.android.gms": 
            case "com.google.android.wearable": 
            case "com.google.firebase": 
            case "com.google.android.support": {
                this.checkPlayServices(context, dependency, (Version)version, cookie, statementCookie);
                break;
            }
            case "com.android.application": 
            case "com.android.tools.build": 
            case "com.android.library": 
            case "com.android.dynamic-feature": 
            case "com.android.fused-library": 
            case "com.android.instant-app": 
            case "com.android.ai-pack": 
            case "com.android.test": 
            case "com.android.feature": 
            case "com.android.base": 
            case "com.android.asset-pack": 
            case "com.android.privacy-sandbox-sdk": 
            case "com.android.settings": 
            case "com.android.lint": 
            case "com.android.kotlin.multiplatform.library": 
            case "com.android.asset-pack-bundle": {
                Companion.AvailableVersions gmavenVersions;
                if (!Intrinsics.areEqual((Object)"gradle", (Object)artifactId) && !Intrinsics.areEqual((Object)(groupId + GRADLE_PLUGIN_ARTIFACT_SUFFIX), (Object)artifactId)) break;
                if (this.checkGradlePluginDependency(context, dependency, statementCookie)) {
                    return;
                }
                Companion.AvailableVersions availableVersions = gmavenVersions = this.getGoogleMavenRepoVersion(context, dependency, filter2);
                Object object2 = newerVersion = availableVersions != null ? availableVersions.getSuggested() : null;
                if (!LintClient.Companion.isGradle()) {
                    newerVersion = GradleDetectorKt.access$maxAgpOrNull((Version)newerVersion, this.findCachedNewerVersion(dependency, filter2));
                }
                Companion.AvailableVersions availableVersions2 = gmavenVersions;
                if (!Intrinsics.areEqual((Object)(availableVersions2 != null ? availableVersions2.getLatestPatch() : null), (Object)newerVersion)) {
                    Companion.AvailableVersions availableVersions3 = gmavenVersions;
                    Object object3 = safeReplacement = availableVersions3 != null ? availableVersions3.getLatestPatch() : null;
                }
                if (newerVersion != null && GradleDetectorKt.access$isAgpNewerThan((Version)newerVersion, dependency)) {
                    this.agpVersionCheckInfo = new AgpVersionCheckInfo((Version)newerVersion, Intrinsics.areEqual((Object)newerVersion.getMajor(), (Object)version.getMajor()) && Intrinsics.areEqual((Object)newerVersion.getMinor(), (Object)version.getMinor()), safeReplacement, dependency, isResolved, cookie);
                    this.maybeReportAgpVersionIssue(context);
                }
                return;
            }
            case "com.android.tools": {
                if (!Intrinsics.areEqual((Object)artifactId, (Object)"desugar_jdk_libs") || !this.checkCoreLibraryDesugaringCompatibility(context, dependency, cookie)) break;
                return;
            }
            case "org.jetbrains.kotlin": {
                if (!Intrinsics.areEqual((Object)artifactId, (Object)"kotlin-gradle-plugin")) break;
                return;
            }
        }
        this.checkForKtxExtension(context, groupId, artifactId, (Version)version, cookie);
        BlockedDependencies blockedDependencies = this.blockedDependencies.get(context.getProject());
        if (blockedDependencies != null && (path = blockedDependencies.checkDependency(groupId, artifactId, true)) != null) {
            String message2 = this.getBlockedDependencyMessage(path);
            LintFix fix2 = this.fix().name("Delete dependency").replace().all().build();
            GradleDetector.report$default(this, context, statementCookie, DUPLICATE_CLASSES, message2, fix2, true, null, null, null, 448, null);
        }
        Issue issue = DEPENDENCY;
        if (context.isEnabled(REMOTE_VERSION) && !this.getGoogleMavenRepository(context.getClient()).hasGroupId(groupId) && (latest = this.getMavenVersion(context, groupId, artifactId, (Version)version, filter2)) != null) {
            newerVersion = latest;
            issue = REMOTE_VERSION;
        }
        newerVersion = GradleDetectorKt.access$maxOrNull((Comparable)newerVersion, (Comparable)this.findCachedNewerVersion(dependency, filter2));
        Companion.AvailableVersions availableVersions = this.getGoogleMavenRepoVersion(context, dependency, filter2);
        newerVersion = GradleDetectorKt.access$maxOrNull((Comparable)newerVersion, (Comparable)(availableVersions != null ? availableVersions.getSuggested() : null));
        newerVersion = GradleDetectorKt.access$maxOrNull((Comparable)newerVersion, (Comparable)this.getSdkIndexVersion(sdkIndex, groupId, artifactId, filter2));
        boolean hasSdkIndexIssues = this.generateAndReportSdkIndexIssues(sdkIndex, groupId, artifactId, (Version)version, (String)richVersionIdentifier, (Version)(!isResolved ? newerVersion : null), context, cookie);
        if (newerVersion != null && version.compareTo(Version.Companion.prefixInfimum("0")) > 0 && GradleDetectorKt.access$isNewerThan((Version)newerVersion, dependency)) {
            Object message3;
            String it;
            Object object4;
            String versionString = newerVersion.toString();
            boolean isCustomMessage = false;
            isCustomMessage = true;
            if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"androidx.slidingpanelayout") && Intrinsics.areEqual((Object)dependency.getName(), (Object)"slidingpanelayout")) {
                object4 = "Upgrade `androidx.slidingpanelayout` for keyboard and mouse support";
            } else if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"androidx.compose.foundation") && Intrinsics.areEqual((Object)dependency.getName(), (Object)"foundation")) {
                object4 = "Upgrade `androidx.compose.foundation` for keyboard and mouse support";
            } else {
                String string2;
                it = string2 = this.getNewerVersionAvailableMessage(dependency, versionString, null);
                boolean bl = false;
                isCustomMessage = false;
                object4 = message3 = string2;
            }
            if (Intrinsics.areEqual((Object)dependency.getGroup(), (Object)GMS_GROUP_ID) && Intrinsics.areEqual((Object)dependency.getName(), (Object)"play-services-maps")) {
                it = Version.Companion.parse("18.2.0");
                boolean bl = false;
                boolean bl2 = version.compareTo((Version)it) < 0 && newerVersion.compareTo((Version)it) >= 0;
                if (bl2) {
                    message3 = (String)message3 + ". Upgrading to at least 18.2.0 is highly recommended to take advantage of the new renderer, which supports customization options like map styling, 3D tiles, and is more reliable, with better support going forward.";
                    isCustomMessage = true;
                }
            }
            if (isCustomMessage || !hasSdkIndexIssues) {
                LintFix fix3 = !isResolved && !hasSdkIndexIssues ? GradleDetector.getUpdateDependencyFix$default(this, (String)richVersionIdentifier, versionString, groupId, false, null, 24, null) : null;
                GradleDetector.report$default(this, context, cookie, issue, (String)message3, fix3, false, null, null, null, 480, null);
            }
        }
    }

    private final Version getMavenVersion(Context context, String groupId, String artifactId, Version version, Predicate<Version> filter2) {
        return com.android.tools.lint.checks.GradleDetector$Companion.getMavenVersion$default(Companion, context.getClient(), groupId, artifactId, version, filter2, true, StringsKt.startsWith$default((String)groupId, (String)"com.github.", (boolean)false, (int)2, null) ? this.isUsingJitpackRepository(context) : false, null, 0, 256, null);
    }

    private final boolean isUsingJitpackRepository(Context context) {
        Boolean bl;
        if (this.usingJitpackRepository != null) {
            Boolean bl2 = this.usingJitpackRepository;
            Intrinsics.checkNotNull((Object)bl2);
            return bl2;
        }
        File settings = this.findSettingsFile(context);
        if (settings != null) {
            String text = FilesKt.readText$default((File)settings, null, (int)1, null);
            bl = StringsKt.contains$default((CharSequence)text, (CharSequence)"https://jitpack.io", (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        Boolean bl3 = this.usingJitpackRepository = bl;
        Intrinsics.checkNotNull((Object)bl3);
        return bl3;
    }

    private final File findSettingsFile(Context context) {
        if (context.getProject().isGradleProject()) {
            String first = null;
            String second = null;
            String string = context.file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.endsWith$default((String)string, (String)".kts", (boolean)false, (int)2, null)) {
                first = "settings.gradle.kts";
                second = "settings.gradle";
            } else {
                first = "settings.gradle";
                second = "settings.gradle.kts";
            }
            File file = context.getProject().getDir().getParentFile();
            if (file == null) {
                return null;
            }
            File parent = file;
            File firstFile = new File(parent, first);
            if (firstFile.isFile()) {
                return firstFile;
            }
            File secondFile = new File(parent, second);
            if (secondFile.isFile()) {
                return secondFile;
            }
        }
        return null;
    }

    private final boolean generateAndReportSdkIndexIssues(GooglePlaySdkIndex sdkIndex, String groupId, String artifactId, Version version, String richVersionIdentifier, Version newerVersion, Context context, Object cookie) {
        boolean reported = false;
        if (sdkIndex.isReady()) {
            Object message2;
            LintFix fix2;
            Severity severity;
            String versionString = version.toString();
            File buildFile = context.file;
            boolean isBlocking = sdkIndex.hasLibraryBlockingIssues(groupId, artifactId, versionString);
            Severity severity2 = severity = isBlocking ? Severity.ERROR : Severity.WARNING;
            if (sdkIndex.isLibraryDeprecated(groupId, artifactId, versionString, buildFile)) {
                fix2 = GradleDetector.generateSdkIndexFixes$default(this, groupId, artifactId, version, richVersionIdentifier, null, buildFile, sdkIndex, null, 128, null);
                message2 = sdkIndex.generateDeprecatedMessage(groupId, artifactId);
                reported = GradleDetector.report$default(this, context, cookie, PLAY_SDK_INDEX_DEPRECATED, (String)message2, fix2, false, severity, null, null, 416, null);
            }
            if (sdkIndex.isLibraryNonCompliant(groupId, artifactId, versionString, buildFile)) {
                fix2 = GradleDetector.generateSdkIndexFixes$default(this, groupId, artifactId, version, richVersionIdentifier, newerVersion, buildFile, sdkIndex, null, 128, null);
                message2 = isBlocking ? sdkIndex.generateBlockingPolicyMessage(groupId, artifactId, versionString) : sdkIndex.generatePolicyMessage(groupId, artifactId, versionString);
                boolean bl = reported = GradleDetector.report$default(this, context, cookie, PLAY_SDK_INDEX_NON_COMPLIANT, (String)message2, fix2, false, severity, null, null, 416, null) || reported;
            }
            if (isBlocking && sdkIndex.hasLibraryCriticalIssues(groupId, artifactId, versionString, buildFile)) {
                fix2 = GradleDetector.generateSdkIndexFixes$default(this, groupId, artifactId, version, richVersionIdentifier, newerVersion, buildFile, sdkIndex, null, 128, null);
                message2 = sdkIndex.generateBlockingCriticalMessage(groupId, artifactId, versionString);
                boolean bl = reported = GradleDetector.report$default(this, context, cookie, RISKY_LIBRARY, (String)message2, fix2, false, severity, null, null, 416, null) || reported;
            }
            if (sdkIndex.hasLibraryVulnerabilityIssues(groupId, artifactId, versionString, buildFile)) {
                List<GooglePlaySdkIndex.Companion.VulnerabilityDescription> messages = sdkIndex.generateVulnerabilityMessages(groupId, artifactId, versionString);
                for (GooglePlaySdkIndex.Companion.VulnerabilityDescription message3 : messages) {
                    LintFix fix3 = this.generateSdkIndexFixes(groupId, artifactId, version, richVersionIdentifier, newerVersion, buildFile, sdkIndex, message3);
                    reported = GradleDetector.report$default(this, context, cookie, PLAY_SDK_INDEX_VULNERABILITY, message3.getDescription(), fix3, false, severity, null, null, 416, null) || reported;
                }
            }
            if (sdkIndex.isLibraryOutdated(groupId, artifactId, versionString, buildFile)) {
                fix2 = GradleDetector.generateSdkIndexFixes$default(this, groupId, artifactId, version, richVersionIdentifier, newerVersion, buildFile, sdkIndex, null, 128, null);
                message2 = isBlocking ? sdkIndex.generateBlockingOutdatedMessage(groupId, artifactId, versionString) : sdkIndex.generateOutdatedMessage(groupId, artifactId, versionString);
                reported = GradleDetector.report$default(this, context, cookie, DEPRECATED_LIBRARY, (String)message2, fix2, false, severity, null, null, 416, null) || reported;
            }
        }
        return reported;
    }

    private final LintFix generateSdkIndexFixes(String groupId, String artifactId, Version currentVersion, String currentVersionIdentifier, Version newerVersion, File buildFile, GooglePlaySdkIndex sdkIndex, GooglePlaySdkIndex.Companion.VulnerabilityDescription vulnerabilityMessage) {
        LintFix viewMoreLink;
        LintFix.GroupBuilder fixes = this.fix().group();
        boolean empty = true;
        if (newerVersion != null && newerVersion.compareTo(currentVersion) > 0) {
            fixes.add(GradleDetector.getUpdateDependencyFix$default(this, currentVersionIdentifier, newerVersion.toString(), groupId, false, null, 24, null));
            empty = false;
        }
        GooglePlaySdkIndex.Companion.VulnerabilityDescription vulnerabilityDescription = vulnerabilityMessage;
        String vulnerabilityLink = vulnerabilityDescription != null ? vulnerabilityDescription.getLink() : null;
        CharSequence charSequence = vulnerabilityLink;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            fixes.add((LintFix)new LintFix.ShowUrl("Learn more about " + vulnerabilityMessage.getName() + " vulnerability", null, vulnerabilityLink, null, 8, null));
            empty = false;
        }
        if ((viewMoreLink = sdkIndex.generateSdkLinkLintFix(groupId, artifactId, currentVersion.toString(), buildFile)) != null) {
            fixes.add(viewMoreLink);
            empty = false;
        }
        if (empty) {
            return null;
        }
        return fixes.build();
    }

    static /* synthetic */ LintFix generateSdkIndexFixes$default(GradleDetector gradleDetector, String string, String string2, Version version, String string3, Version version2, File file, GooglePlaySdkIndex googlePlaySdkIndex, GooglePlaySdkIndex.Companion.VulnerabilityDescription vulnerabilityDescription, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateSdkIndexFixes");
        }
        if ((n & 0x80) != 0) {
            vulnerabilityDescription = null;
        }
        return gradleDetector.generateSdkIndexFixes(string, string2, version, string3, version2, file, googlePlaySdkIndex, vulnerabilityDescription);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDuplication(Context context, Map<LintTomlValue, Dependency> dependencies, Function1<? super Dependency, String> extractor) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        boolean bl;
        Map.Entry entry;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Iterable iterable = CollectionsKt.toList((Iterable)dependencies.entrySet());
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t2 : $this$groupByTo$iv$iv) {
            Object object;
            entry = (Map.Entry)t2;
            bl = false;
            String key$iv$iv = (String)extractor.invoke(entry.getValue());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t2);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry2;
            entry = entry2 = (Map.Entry)iterator2.next();
            bl = false;
            if (!(((List)entry.getValue()).size() > 1)) continue;
            destination$iv$iv.put(entry2.getKey(), entry2.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry2 = element$iv = iterator.next();
            boolean bl2 = false;
            Iterable iterable2 = (Iterable)entry2.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : iterable2) {
                Map.Entry tuple = (Map.Entry)element$iv2;
                boolean bl3 = false;
                LintTomlValue tomlValue = (LintTomlValue)tuple.getKey();
                GradleDetector.report$default(this, context, tomlValue, MULTIPLE_VERSIONS_DEPENDENCY, "There are multiple dependencies " + entry2.getKey() + " but with different version", null, false, null, null, null, 496, null);
            }
        }
    }

    private final Predicate<Version> getGooglePlaySdkIndexFilter(String groupId, String artifactId, Collection<LibraryVersionRange> recommendedVersions, GooglePlaySdkIndex sdkIndex) {
        Predicate predicate;
        GooglePlaySdkIndex googlePlaySdkIndex = sdkIndex;
        if (googlePlaySdkIndex != null) {
            GooglePlaySdkIndex it = googlePlaySdkIndex;
            boolean bl = false;
            predicate = new Predicate(it, groupId, artifactId, this, recommendedVersions){
                final /* synthetic */ GooglePlaySdkIndex $it;
                final /* synthetic */ String $groupId;
                final /* synthetic */ String $artifactId;
                final /* synthetic */ GradleDetector this$0;
                final /* synthetic */ Collection<LibraryVersionRange> $recommendedVersions;
                {
                    this.$it = $it;
                    this.$groupId = $groupId;
                    this.$artifactId = $artifactId;
                    this.this$0 = $receiver;
                    this.$recommendedVersions = $recommendedVersions;
                }

                public final boolean test(Version v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return this.$it.isReady() && !this.$it.hasLibraryErrorOrWarning(this.$groupId, this.$artifactId, v.toString()) && GradleDetector.access$isRecommendedVersion(this.this$0, v, this.$recommendedVersions);
                }
            };
        } else {
            predicate = null;
        }
        return predicate;
    }

    private final boolean isRecommendedVersion(Version version, Collection<LibraryVersionRange> recommendedVersions) {
        if (recommendedVersions.isEmpty()) {
            return true;
        }
        for (LibraryVersionRange range : recommendedVersions) {
            String string = range.getLowerBound();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLowerBound(...)");
            Version lowerVersion = Version.Companion.parse(string);
            if (version.compareTo(lowerVersion) < 0) continue;
            CharSequence charSequence = range.getUpperBound();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return true;
            }
            String string2 = range.getUpperBound();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUpperBound(...)");
            Version upperVersion = Version.Companion.parse(string2);
            if (version.compareTo(upperVersion) > 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final File getArtifactCacheHome() {
        File file = this.artifactCacheHome;
        if (file == null) {
            void var3_3;
            File home;
            GradleDetector $this$getArtifactCacheHome_u24lambda_u2420 = this;
            boolean bl = false;
            $this$getArtifactCacheHome_u24lambda_u2420.artifactCacheHome = home = new File($this$getArtifactCacheHome_u24lambda_u2420.getGradleUserHome(), "caches" + File.separator + "modules-2" + File.separator + "files-2.1");
            file = var3_3;
        }
        return file;
    }

    private final Version findCachedNewerVersion(Dependency dependency, Predicate<Version> filter2) {
        Version version;
        Predicate<Version> predicate;
        String string = dependency.getGroup();
        if (string == null) {
            return null;
        }
        String group = string;
        Path versionDir = this.getArtifactCacheHome().toPath().resolve(group + File.separator + dependency.getName());
        String string2 = dependency.getGroup();
        boolean bl = string2 != null ? StringsKt.startsWith$default((String)string2, (String)"commons-", (boolean)false, (int)2, null) : false;
        if (bl && StringsKt.startsWith$default((String)dependency.getName(), (String)"commons-", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)dependency.getName(), (Object)dependency.getGroup())) {
            Predicate<Version> commonsFilter2 = new Predicate(this){
                final /* synthetic */ GradleDetector this$0;
                {
                    this.this$0 = $receiver;
                }

                public final boolean test(Version v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return !GradleDetector.access$isOldApacheCommonsVersion(this.this$0, v);
                }
            };
            predicate = filter2;
            if (predicate == null || (predicate = predicate.and(commonsFilter2)) == null) {
                predicate = commonsFilter2;
            }
        } else {
            predicate = filter2;
        }
        Predicate<Version> f2 = predicate;
        Function1 noSnapshotFilter2 = (Function1)new Function1<Version, Boolean>(f2){
            final /* synthetic */ Predicate<Version> $f;
            {
                this.$f = $f;
                super(1);
            }

            public final Boolean invoke(Version candidate) {
                Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
                return !candidate.isSnapshot() && (this.$f == null || this.$f.test(candidate));
            }
        };
        if (CancellableFileIo.exists((Path)versionDir, (LinkOption[])new LinkOption[0])) {
            String name = dependency.getName();
            RichVersion richVersion = dependency.getVersion();
            boolean allowPreview = richVersion == null ? true : (Intrinsics.areEqual((Object)group, (Object)"com.google.guava") || Intrinsics.areEqual((Object)name, (Object)"kotlinx-coroutines-core") ? true : MavenRepositories.isPreview((Component)new Component(group, name, richVersion.getLowerBound())));
            version = MavenRepositories.getHighestVersion((Path)versionDir, (Predicate)new Predicate(noSnapshotFilter2){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    return (Boolean)this.function.invoke(p0);
                }
            }, (boolean)allowPreview);
        } else {
            version = null;
        }
        return version;
    }

    private final boolean isOldApacheCommonsVersion(Version $this$isOldApacheCommonsVersion) {
        Object object = $this$isOldApacheCommonsVersion.getMajor();
        return object != null && (object = ((Integer)object).toString()) != null ? ((String)object).length() == 8 : false;
    }

    private final boolean checkCoreLibraryDesugaringCompatibility(Context context, Dependency dependency, Object cookie) {
        RichVersion version = dependency.getVersion();
        if (version != null) {
            Integer n = version.getLowerBound().getMajor();
            int n2 = 1;
            if (n != null && n == n2) {
                Object object = context.getProject().getBuildModule();
                if (object == null || (object = object.getCompileTarget()) == null) {
                    return false;
                }
                Object compileTarget = object;
                AndroidVersion androidVersion = AndroidTargetHash.getPlatformVersion((String)compileTarget);
                if (androidVersion == null) {
                    return false;
                }
                AndroidVersion targetVersion = androidVersion;
                if (targetVersion.isAtLeast(35)) {
                    LintFix lintFix;
                    RichVersion minimum = RichVersion.Companion.parse("2.+");
                    String artifact = dependency.getName();
                    String string = dependency.getGroup();
                    Intrinsics.checkNotNull((Object)string);
                    String group = string;
                    Dependency query = new Dependency(group, artifact, minimum, null, null, 24, null);
                    Predicate<Version> filter2 = Companion.getUpgradeVersionFilter(context, group, query.getName(), minimum.getLowerBound());
                    Companion.AvailableVersions availableVersions = this.getGoogleMavenRepoVersion(context, query, filter2);
                    if (availableVersions == null || (availableVersions = availableVersions.getSuggested()) == null) {
                        return false;
                    }
                    Companion.AvailableVersions suggestedVersion = availableVersions;
                    String message2 = "Core library desugaring runtime library version " + version.getLowerBound() + " does not support `compileSdk=35` or later; please upgrade to version " + (Version)suggestedVersion;
                    String string2 = version.toIdentifier();
                    if (string2 != null) {
                        String it = string2;
                        boolean bl = false;
                        lintFix = GradleDetector.getUpdateDependencyFix$default(this, it, suggestedVersion.toString(), group, false, null, 24, null);
                    } else {
                        lintFix = null;
                    }
                    LintFix fix2 = lintFix;
                    GradleDetector.report$default(this, context, cookie, CORE_LIB_DESUGARING_V2, message2, fix2, false, null, null, null, 480, null);
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean checkGradlePluginDependency(Context context, Dependency dependency, Object cookie) {
        block5: {
            Companion.AvailableVersions availableVersions;
            block7: {
                Version recommended;
                block6: {
                    Companion.AvailableVersions availableVersions2;
                    Version minimum = Version.Companion.parse("4.0.0");
                    RichVersion richVersion = dependency.getVersion();
                    if (richVersion == null) {
                        return false;
                    }
                    RichVersion dependencyVersion = richVersion;
                    if (dependencyVersion.getLowerBound().compareTo(minimum) >= 0) {
                        return false;
                    }
                    if (dependencyVersion.contains(minimum)) break block5;
                    Dependency query = new Dependency("com.android.tools.build", "gradle", RichVersion.Companion.require(minimum), null, null, 24, null);
                    String string = SdkConstants.GRADLE_PLUGIN_RECOMMENDED_VERSION;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GRADLE_PLUGIN_RECOMMENDED_VERSION");
                    recommended = Version.Companion.parse(string);
                    boolean bl = false;
                    availableVersions = this.getGoogleMavenRepoVersion(context, query, null);
                    if (availableVersions == null || (availableVersions = availableVersions.getSuggested()) == null) break block6;
                    Companion.AvailableVersions it = availableVersions2 = availableVersions;
                    boolean bl2 = false;
                    availableVersions = it.compareTo(recommended) > 0 ? availableVersions2 : null;
                    if (availableVersions != null) break block7;
                }
                availableVersions = recommended;
            }
            Companion.AvailableVersions recommended = availableVersions;
            String message2 = "You must use a newer version of the Android Gradle plugin. The minimum supported version is 4.0.0 and the recommended version is " + (Version)recommended;
            GradleDetector.report$default(this, context, cookie, GRADLE_PLUGIN_COMPATIBILITY, message2, null, false, null, null, null, 496, null);
            return true;
        }
        return false;
    }

    private final void checkPlayServices(Context context, Dependency dependency, Version version, Object cookie, Object statementCookie) {
        Object message2;
        LintFix fix2;
        String richVersionIdentifier;
        RichVersion richVersion;
        String artifactId;
        String groupId;
        block12: {
            Companion.AvailableVersions availableVersions;
            block14: {
                Version v;
                block13: {
                    Companion.AvailableVersions availableVersions2;
                    String string = dependency.getGroup();
                    if (string == null) {
                        return;
                    }
                    groupId = string;
                    artifactId = dependency.getName();
                    RichVersion richVersion2 = dependency.getVersion();
                    if (richVersion2 == null) {
                        return;
                    }
                    richVersion = richVersion2;
                    String string2 = richVersion.toIdentifier();
                    if (string2 == null) {
                        return;
                    }
                    richVersionIdentifier = string2;
                    if (!Intrinsics.areEqual((Object)Version.Companion.parse("5.2.08"), (Object)version) || !context.isEnabled(COMPATIBILITY)) break block12;
                    v = Version.Companion.parse("10.2.1");
                    boolean bl = false;
                    availableVersions = this.getGoogleMavenRepoVersion(context, dependency, null);
                    if (availableVersions == null || (availableVersions = availableVersions.getSuggested()) == null) break block13;
                    Companion.AvailableVersions it = availableVersions2 = availableVersions;
                    boolean bl2 = false;
                    availableVersions = it.compareTo(v) > 0 ? availableVersions2 : null;
                    if (availableVersions != null) break block14;
                }
                availableVersions = v;
            }
            Companion.AvailableVersions maxVersion = availableVersions;
            fix2 = GradleDetector.getUpdateDependencyFix$default(this, richVersionIdentifier, maxVersion.toString(), groupId, false, null, 24, null);
            String message3 = "Version `5.2.08` should not be used; the app can not be published with this version. Use version `" + (Version)maxVersion + "` instead.";
            this.reportFatalCompatibilityIssue(context, cookie, message3, fix2);
        }
        if (context.isEnabled(BUNDLED_GMS) && Intrinsics.areEqual((Object)PLAY_SERVICES_V650.getGroup(), (Object)dependency.getGroup()) && Intrinsics.areEqual((Object)PLAY_SERVICES_V650.getName(), (Object)dependency.getName()) && (richVersion.getLowerBound().compareTo(PLAY_SERVICES_V650.getVersion()) >= 0 || richVersion.contains(PLAY_SERVICES_V650.getVersion()))) {
            message2 = "Avoid using bundled version of Google Play services SDK.";
            GradleDetector.report$default(this, context, cookie, BUNDLED_GMS, (String)message2, null, false, null, null, null, 496, null);
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)artifactId, (Object)"play-services-instantapps")) {
            GradleDetector.report$default(this, context, statementCookie, INSTANT_APP_DEPRECATION, INSTANT_DEPRECATION_MESSAGE, null, false, null, null, null, 480, null);
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-appindexing", (Object)artifactId)) {
            message2 = "Deprecated: Replace 'com.google.android.gms:play-services-appindexing:" + richVersionIdentifier + "' with 'com.google.firebase:firebase-appindexing:10.0.0' or above. More info: http://firebase.google.com/docs/app-indexing/android/migrate";
            fix2 = this.fix().name("Replace with Firebase").replace().text("com.google.android.gms:play-services-appindexing:" + richVersionIdentifier).with("com.google.firebase:firebase-appindexing:10.2.1").build();
            GradleDetector.report$default(this, context, cookie, DEPRECATED, (String)message2, fix2, false, null, null, null, 480, null);
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-fido", (Object)artifactId)) {
            GradleDetector.report$default(this, context, cookie, DEPENDENCY, "Prefer to migrate to the Credential Manager API (androidx.credentials:credentials)", this.fix().url("https://developer.android.com/identity/sign-in/fido2-migration").build(), false, null, null, null, 480, null);
            return;
        }
        if (!this.mCheckedWearableLibs) {
            this.mCheckedWearableLibs = true;
            if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES) && context.isGlobalAnalysis()) {
                this.checkConsistentWearableLibraries(context, cookie, statementCookie);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentWearableLibraries(Context context, Object cookie, Object statementCookie) {
        void $this$filterIsInstanceTo$iv$iv;
        Project project = context.getMainProject();
        if (!project.isGradleProject()) {
            return;
        }
        HashSet<String> supportVersions = new HashSet<String>();
        HashSet<String> wearableVersions = new HashSet<String>();
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(project);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (LintModelExternalLibrary library : (List)destination$iv$iv) {
            LintModelMavenName coordinates = library.getResolvedCoordinates();
            if (Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) && Intrinsics.areEqual((Object)GOOGLE_SUPPORT_GROUP_ID, (Object)coordinates.getGroupId())) {
                supportVersions.add(coordinates.getVersion());
            }
            if (!Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) || !Intrinsics.areEqual((Object)ANDROID_WEAR_GROUP_ID, (Object)coordinates.getGroupId())) continue;
            if (!library.getProvided()) {
                String message2 = "This dependency should be marked as `compileOnly`, not `compile`";
                if (statementCookie != null) {
                    this.reportFatalCompatibilityIssue(context, statementCookie, message2);
                } else {
                    Location location = Companion.getDependencyLocation(context, coordinates);
                    if (location.getStart() == null) {
                        message2 = "The com.google.android.wearable:wearable dependency should be marked as `compileOnly`, not `compile`";
                    }
                    this.reportFatalCompatibilityIssue(context, location, message2);
                }
            }
            wearableVersions.add(coordinates.getVersion());
        }
        if (!((Collection)supportVersions).isEmpty()) {
            Location location;
            if (wearableVersions.isEmpty()) {
                ArrayList list = new ArrayList(supportVersions);
                String first = (String)Collections.min(list);
                String message3 = "Project depends on com.google.android.support:wearable:" + first + ", so it must also depend (as a provided dependency) on com.google.android.wearable:wearable:" + first;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context, cookie, message3);
                } else {
                    Intrinsics.checkNotNull((Object)first);
                    location = Companion.getDependencyLocation(context, GOOGLE_SUPPORT_GROUP_ID, WEARABLE_ARTIFACT_ID, first);
                    this.reportFatalCompatibilityIssue(context, location, message3);
                }
            } else if (!Intrinsics.areEqual(supportVersions, wearableVersions)) {
                ArrayList sortedSupportVersions = new ArrayList(supportVersions);
                CollectionsKt.sort((List)sortedSupportVersions);
                ArrayList supportedWearableVersions = new ArrayList(wearableVersions);
                CollectionsKt.sort((List)supportedWearableVersions);
                String string = "The wearable libraries for %1$s and %2$s must use **exactly** the same versions; found %3$s and %4$s";
                Object[] objectArray = new Object[]{GOOGLE_SUPPORT_GROUP_ID, ANDROID_WEAR_GROUP_ID, sortedSupportVersions.size() == 1 ? (String)sortedSupportVersions.get(0) : sortedSupportVersions.toString(), supportedWearableVersions.size() == 1 ? (String)supportedWearableVersions.get(0) : supportedWearableVersions.toString()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String message4 = string2;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context, cookie, message4);
                } else {
                    Object e = sortedSupportVersions.get(0);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    String string3 = (String)e;
                    Object e2 = supportedWearableVersions.get(0);
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                    location = com.android.tools.lint.checks.GradleDetector$Companion.getDependencyLocation$default(Companion, context, GOOGLE_SUPPORT_GROUP_ID, WEARABLE_ARTIFACT_ID, string3, ANDROID_WEAR_GROUP_ID, WEARABLE_ARTIFACT_ID, (String)e2, null, 128, null);
                    this.reportFatalCompatibilityIssue(context, location, message4);
                }
            }
        }
    }

    private final List<LintModelLibrary> getAllLibraries(Project project) {
        Object object = project.getBuildVariant();
        if (object == null || (object = object.getArtifact()) == null || (object = object.getDependencies()) == null || (object = object.getAll()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        ((Map)this.blockedDependencies).put(project, new BlockedDependencies(project));
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        this.checkBlockedDependencies(context, project);
        if (!LintClient.Companion.isGradle()) {
            reservedQuickfixNames = null;
        }
    }

    private final void checkLibraryConsistency(Context context) {
        this.checkConsistentWearableLibraries(context, null, null);
    }

    public void visitTomlDocument(@NotNull TomlContext context, @NotNull LintTomlDocument document) {
        LintTomlMapValue plugins;
        Pair<String, LintTomlValue> coordinate;
        Object object;
        LintTomlMapValue libraries;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        LintTomlValue lintTomlValue = document.getValue("versions");
        LintTomlMapValue versions = lintTomlValue instanceof LintTomlMapValue ? (LintTomlMapValue)lintTomlValue : null;
        Set versionNodeDependencySet = new LinkedHashSet();
        LintTomlValue lintTomlValue2 = document.getValue("libraries");
        LintTomlMapValue lintTomlMapValue = libraries = lintTomlValue2 instanceof LintTomlMapValue ? (LintTomlMapValue)lintTomlValue2 : null;
        if (libraries != null) {
            Map dependencyToElement = new LinkedHashMap();
            object = libraries.getMappedValues().entrySet().iterator();
            while (object.hasNext()) {
                Pair<String, LintTomlValue> pair;
                LintTomlValue library = (LintTomlValue)((Map.Entry)object.next()).getValue();
                if (Lint.getLibraryFromTomlEntry(versions, library) == null) continue;
                coordinate = (Pair<String, LintTomlValue>)pair.component1();
                LintTomlValue versionNode = (LintTomlValue)pair.component2();
                Dependency dependency = Dependency.Companion.parse((String)coordinate);
                dependencyToElement.put(library, dependency);
                if (versionNodeDependencySet.contains(TuplesKt.to((Object)versionNode, (Object)dependency))) continue;
                versionNodeDependencySet.add(TuplesKt.to((Object)versionNode, (Object)dependency));
                context.getDriver().runLaterOutsideReadAction(new Runnable(this, context, dependency, versionNode, library){
                    final /* synthetic */ GradleDetector this$0;
                    final /* synthetic */ TomlContext $context;
                    final /* synthetic */ Dependency $dependency;
                    final /* synthetic */ LintTomlValue $versionNode;
                    final /* synthetic */ LintTomlValue $library;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$dependency = $dependency;
                        this.$versionNode = $versionNode;
                        this.$library = $library;
                    }

                    public final void run() {
                        GradleDetector.access$checkDependency(this.this$0, (Context)this.$context, this.$dependency, false, this.$versionNode, this.$library);
                    }
                });
            }
            this.checkDuplication((Context)context, dependencyToElement, (Function1<? super Dependency, String>)((Function1)visitTomlDocument.2.INSTANCE));
        }
        LintTomlMapValue lintTomlMapValue2 = plugins = (object = document.getValue("plugins")) instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
        if (plugins != null) {
            Map dependencyToElement = new LinkedHashMap();
            Iterator object2 = plugins.getMappedValues().entrySet().iterator();
            while (object2.hasNext()) {
                LintTomlValue plugin = (LintTomlValue)object2.next().getValue();
                if (Lint.getPluginFromTomlEntry(versions, plugin) == null) continue;
                String coordinate2 = (String)coordinate.component1();
                LintTomlValue versionNode = (LintTomlValue)coordinate.component2();
                String group = StringsKt.substringBefore$default((String)coordinate2, (char)':', null, (int)2, null);
                String gradleCoordinate = group + ":" + group + ".gradle.plugin:" + StringsKt.substringAfterLast$default((String)coordinate2, (char)':', null, (int)2, null);
                Dependency dependency = Dependency.Companion.parse(gradleCoordinate);
                dependencyToElement.put(plugin, dependency);
                if (versionNodeDependencySet.contains(TuplesKt.to((Object)versionNode, (Object)dependency))) continue;
                versionNodeDependencySet.add(TuplesKt.to((Object)versionNode, (Object)dependency));
                context.getDriver().runLaterOutsideReadAction(new Runnable(this, context, dependency, versionNode, plugin){
                    final /* synthetic */ GradleDetector this$0;
                    final /* synthetic */ TomlContext $context;
                    final /* synthetic */ Dependency $dependency;
                    final /* synthetic */ LintTomlValue $versionNode;
                    final /* synthetic */ LintTomlValue $plugin;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        this.$dependency = $dependency;
                        this.$versionNode = $versionNode;
                        this.$plugin = $plugin;
                    }

                    public final void run() {
                        GradleDetector.access$checkDependency(this.this$0, (Context)this.$context, this.$dependency, false, this.$versionNode, this.$plugin);
                    }
                });
            }
            this.checkDuplication((Context)context, dependencyToElement, (Function1<? super Dependency, String>)((Function1)visitTomlDocument.4.INSTANCE));
        }
        if (versions != null) {
            for (Map.Entry entry : versions.getMappedValues().entrySet()) {
                String key = (String)entry.getKey();
                LintTomlValue value = (LintTomlValue)entry.getValue();
                if (Companion.isCompileSdkTomlVersionKey(key)) {
                    Object object2 = value.getActualValue();
                    if (object2 != null) {
                        Object compileSdkString;
                        int compileSdk;
                        if ((object2 = object2.toString()) == null || (compileSdk = this.getSdkVersion((String)(compileSdkString = object2), value)) < 30) continue;
                        GradleDetector.checkCompileSdkVersionLatest$default(this, (Context)context, compileSdk, value, false, null, 24, null);
                    }
                    continue;
                }
                if (GradleDetector.Companion.isMinSdkTomlVersionKey(key)) {
                    Object object3 = value.getActualValue();
                    if (object3 == null || (object3 = object3.toString()) == null) continue;
                    Object minSdkString = object3;
                    int minSdk = this.getSdkVersion((String)minSdkString, value);
                    GradleDetector.checkMinSdkVersion$default(this, (Context)context, minSdk, value, false, null, 24, null);
                    continue;
                }
                if (!GradleDetector.Companion.isTargetSdkTomlVersionKey(key)) continue;
                Object object4 = value.getActualValue();
                if (object4 != null) {
                    Object targetSdkString;
                    int targetSdk;
                    if ((object4 = object4.toString()) == null || (targetSdk = this.getSdkVersion((String)(targetSdkString = object4), value)) == -1) continue;
                    GradleDetector.checkTargetSdkVersion$default(this, (Context)context, targetSdk, (String)targetSdkString, value, false, 16, null);
                }
            }
        }
    }

    public void afterCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.maybeReportJavaTargetCompatibilityIssue(context);
        this.maybeReportAgpVersionIssue(context);
    }

    private final void maybeReportJavaTargetCompatibilityIssue(Context context) {
        if (!(!this.mAppliedJavaPlugin || this.mDeclaredSourceCompatibility && this.mDeclaredTargetCompatibility)) {
            File file = context.file;
            String contents = ((Object)context.getClient().readFile(file)).toString();
            String message2 = this.mDeclaredTargetCompatibility ? "no Java sourceCompatibility directive" : (this.mDeclaredSourceCompatibility ? "no Java targetCompatibility directive" : "no Java language level directives");
            String fixDisplayName = this.mDeclaredTargetCompatibility ? "Insert sourceCompatibility directive for JDK8" : (this.mDeclaredSourceCompatibility ? "Insert targetCompatibility directive for JDK8" : "Insert JDK8 language level directives");
            String insertion = this.mDeclaredTargetCompatibility ? "\njava.sourceCompatibility = JavaVersion.VERSION_1_8" : (this.mDeclaredSourceCompatibility ? "\njava.targetCompatibility = JavaVersion.VERSION_1_8" : "\njava {\n    sourceCompatibility = JavaVersion.VERSION_1_8\n    targetCompatibility = JavaVersion.VERSION_1_8\n}");
            LintFix fix2 = this.fix().replace().name(fixDisplayName).range(Location.Companion.create(context.file, (CharSequence)contents, 0, contents.length())).end().with(insertion).build();
            JavaPluginInfo javaPluginInfo = this.mJavaPluginInfo;
            Intrinsics.checkNotNull((Object)javaPluginInfo);
            GradleDetector.report$default(this, context, javaPluginInfo.getCookie(), JAVA_PLUGIN_LANGUAGE_LEVEL, message2, fix2, false, null, null, null, 480, null);
        }
    }

    private final void maybeReportAgpVersionIssue(Context context) {
        block1: {
            if (!this.mDeclaredGoogleMavenRepository && this.mDeclaredBuildscriptRepository) break block1;
            AgpVersionCheckInfo agpVersionCheckInfo = this.agpVersionCheckInfo;
            if (agpVersionCheckInfo != null) {
                LintMap lintMap;
                AgpVersionCheckInfo it = agpVersionCheckInfo;
                boolean bl = false;
                String versionString = it.getNewerVersion().toString();
                RichVersion richVersion = it.getDependency().getVersion();
                String currentIdentifier = richVersion != null ? richVersion.toIdentifier() : null;
                String message2 = this.getNewerVersionAvailableMessage(it.getDependency(), versionString, it.getSafeReplacement());
                LintFix fix2 = it.isResolved() ? null : (currentIdentifier == null ? null : this.getUpdateDependencyFix(currentIdentifier, versionString, "com.android.tools.build", it.getNewerVersionIsSafe(), it.getSafeReplacement()));
                LintMap $this$maybeReportAgpVersionIssue_u24lambda_u2427_u24lambda_u2426 = lintMap = new LintMap();
                boolean bl2 = false;
                $this$maybeReportAgpVersionIssue_u24lambda_u2427_u24lambda_u2426.put(KEY_COORDINATE, APP_PLUGIN_ID);
                $this$maybeReportAgpVersionIssue_u24lambda_u2427_u24lambda_u2426.put(KEY_REVISION, versionString);
                LintMap clientProperties = lintMap;
                GradleDetector.report$default(this, context, it.getCookie(), AGP_DEPENDENCY, message2, fix2, false, null, null, clientProperties, 224, null);
            }
        }
    }

    private final void checkKaptUsage(String dependency, LintTomlValue libTomlValue, GradleContext context, Object statementCookie) {
        LintFix lintFix;
        String module = StringsKt.substringBeforeLast$default((String)dependency, (char)':', null, (int)2, null);
        String string = annotationProcessorsWithKspReplacements.get(module);
        if (string == null) {
            return;
        }
        String replacement = string;
        if (!this.mAppliedKspPlugin) {
            lintFix = this.fix().name("Learn about how to enable KSP and use the KSP processor for this dependency instead").url("https://developer.android.com/studio/build/migrate-to-ksp").build();
        } else if (libTomlValue != null) {
            LintFix lintFix2;
            String[] stringArray;
            boolean declaredWithGroupAndName;
            LintTomlMapValue lintTomlMapValue = libTomlValue instanceof LintTomlMapValue ? (LintTomlMapValue)libTomlValue : null;
            boolean bl = declaredWithGroupAndName = (lintTomlMapValue != null ? lintTomlMapValue.get("group") : null) != null;
            if (declaredWithGroupAndName) {
                stringArray = new String[]{":"};
                List list = StringsKt.split$default((CharSequence)module, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String oldGroup = (String)list.get(0);
                String oldName = (String)list.get(1);
                String[] stringArray2 = new String[]{":"};
                List list2 = StringsKt.split$default((CharSequence)replacement, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                String newGroup = (String)list2.get(0);
                String newName = (String)list2.get(1);
                lintFix2 = this.fix().replace().range(((LintTomlMapValue)libTomlValue).getLocation()).pattern("((.*)" + oldGroup + "(.*)" + oldName + "(.*))").with("\\k<2>" + newGroup + "\\k<3>" + newName + "\\k<4>").build();
            } else {
                lintFix2 = this.fix().replace().range(libTomlValue.getLocation()).text(module).with(replacement).build();
            }
            LintFix catalogFix = lintFix2;
            LintFix usageFix = this.fix().replace().text("kapt").with("ksp").build();
            stringArray = new LintFix[]{catalogFix, usageFix};
            lintFix = this.fix().name("Replace usage of kapt with KSP").composite((LintFix[])stringArray);
        } else {
            lintFix = this.fix().name("Replace usage of kapt with KSP").replace().pattern("((.*)kapt(.*)" + module + "(.*))").with("\\k<2>ksp\\k<3>" + replacement + "\\k<4>").build();
        }
        LintFix fix2 = lintFix;
        GradleDetector.report$default(this, (Context)context, statementCookie, KAPT_USAGE_INSTEAD_OF_KSP, "This library supports using KSP instead of kapt, which greatly improves performance. Learn more: https://developer.android.com/studio/build/migrate-to-ksp", fix2, false, null, null, null, 480, null);
    }

    private final void checkForKtxExtension(Context context, String groupId, String artifactId, Version version, Object cookie) {
        if (!this.mAppliedKotlinAndroidPlugin) {
            return;
        }
        if (StringsKt.endsWith$default((String)artifactId, (String)"-ktx", (boolean)false, (int)2, null)) {
            return;
        }
        if (cookie instanceof LintTomlValue) {
            return;
        }
        String mavenName = groupId + ":" + artifactId;
        if (!GradleDetector.Companion.libraryHasKtxExtension(mavenName)) {
            return;
        }
        LintModelVariant lintModelVariant = context.getProject().getBuildVariant();
        if (lintModelVariant == null || (lintModelVariant = lintModelVariant.getArtifact()) == null) {
            return;
        }
        LintModelVariant artifact = lintModelVariant;
        if (artifact.getType() != LintModelArtifactType.MAIN) {
            return;
        }
        if (artifact.findCompileDependency("org.jetbrains.kotlin:kotlin-stdlib") == null) {
            return;
        }
        GoogleMavenRepository repository2 = this.getGoogleMavenRepository(context.getClient());
        if (repository2.findVersion(groupId, artifactId + "-ktx", (Function1)new Function1<Version, Boolean>(version){
            final /* synthetic */ Version $version;
            {
                this.$version = $version;
                super(1);
            }

            public final Boolean invoke(Version it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$version);
            }
        }, true) == null) {
            return;
        }
        String msg = "Add suffix `-ktx` to enable the Kotlin extensions for this library";
        LintFix fix2 = this.fix().name("Replace with KTX dependency").replace().text(mavenName).with(mavenName + "-ktx").build();
        GradleDetector.report$default(this, context, cookie, KTX_EXTENSION_AVAILABLE, msg, fix2, false, null, null, null, 480, null);
    }

    private final void checkForBomUsageWithoutPlatform(String property, String dependency, String value, GradleContext context, Object valueCookie) {
        boolean bl;
        block5: {
            Object[] objectArray = new String[]{"platform", "enforcedPlatform"};
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)value, (String)(it + "("), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (commonBoms.contains(StringsKt.substringBeforeLast$default((String)dependency, (char)':', null, (int)2, null)) && (Companion.CompileConfiguration.IMPLEMENTATION.matches(property) || Companion.CompileConfiguration.API.matches(property))) {
            String message2 = "BOM should be added with a call to platform()";
            LintFix fix2 = this.fix().name("Add platform() to BOM declaration", true).replace().text(value).with("platform(" + value + ")").build();
            GradleDetector.report$default(this, (Context)context, valueCookie, BOM_WITHOUT_PLATFORM, message2, fix2, false, null, null, null, 480, null);
        }
    }

    private final void checkBlockedDependencies(Context context, Project project) {
        BlockedDependencies blockedDependencies = this.blockedDependencies.get(project);
        if (blockedDependencies == null) {
            return;
        }
        BlockedDependencies blockedDependencies2 = blockedDependencies;
        List<List<LintModelDependency>> dependencies = blockedDependencies2.getForbiddenDependencies();
        if (!((Collection)dependencies).isEmpty()) {
            for (List<LintModelDependency> path : dependencies) {
                Location location;
                LintModelMavenName gc;
                LintModelMavenName lintModelMavenName;
                String message2 = this.getBlockedDependencyMessage(path);
                File projectDir = context.getProject().getDir();
                if (path.get(0).findLibrary() != null) {
                    LintModelLibrary it;
                    boolean bl = false;
                    lintModelMavenName = it instanceof LintModelExternalLibrary ? ((LintModelExternalLibrary)it).getResolvedCoordinates() : null;
                } else {
                    lintModelMavenName = gc = null;
                }
                if (gc != null) {
                    location = Companion.getDependencyLocation(context, gc.getGroupId(), gc.getArtifactId(), gc.getVersion());
                } else {
                    String mavenName = path.get(0).getArtifactName();
                    LintClient lintClient = context.getClient();
                    Intrinsics.checkNotNull((Object)projectDir);
                    location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((LintClient)lintClient, (File)projectDir, (String)mavenName);
                }
                Location location2 = location;
                context.report(new Incident(DUPLICATE_CLASSES, location2, message2), this.map());
            }
        }
        this.blockedDependencies.remove(project);
    }

    private final boolean report(Context context, Object cookie, Issue issue, String message2, LintFix fix2, boolean partial, Severity overrideSeverity, Constraint constraint, LintMap clientProperties) {
        if (Intrinsics.areEqual((Object)issue, (Object)REMOTE_VERSION) && !context.isEnabled(DEPENDENCY)) {
            return false;
        }
        Ref.BooleanRef reportCreated = new Ref.BooleanRef();
        context.getClient().runReadAction(new Runnable(context, issue, cookie, message2, fix2, overrideSeverity, clientProperties, constraint, partial, this, reportCreated){
            final /* synthetic */ Context $context;
            final /* synthetic */ Issue $issue;
            final /* synthetic */ Object $cookie;
            final /* synthetic */ String $message;
            final /* synthetic */ LintFix $fix;
            final /* synthetic */ Severity $overrideSeverity;
            final /* synthetic */ LintMap $clientProperties;
            final /* synthetic */ Constraint $constraint;
            final /* synthetic */ boolean $partial;
            final /* synthetic */ GradleDetector this$0;
            final /* synthetic */ Ref.BooleanRef $reportCreated;
            {
                this.$context = $context;
                this.$issue = $issue;
                this.$cookie = $cookie;
                this.$message = $message;
                this.$fix = $fix;
                this.$overrideSeverity = $overrideSeverity;
                this.$clientProperties = $clientProperties;
                this.$constraint = $constraint;
                this.$partial = $partial;
                this.this$0 = $receiver;
                this.$reportCreated = $reportCreated;
            }

            public final void run() {
                boolean enabled = this.$context.isEnabled(this.$issue);
                if (enabled && this.$context instanceof GradleContext) {
                    Location location = ((GradleContext)this.$context).getLocation(this.$cookie);
                    Incident incident = new Incident(this.$issue, this.$cookie, location, this.$message, this.$fix);
                    Severity severity = this.$overrideSeverity;
                    if (severity != null) {
                        Severity it = severity;
                        boolean bl = false;
                        incident.overrideSeverity(it);
                    }
                    incident.setClientProperties(this.$clientProperties);
                    if (this.$constraint != null) {
                        this.$context.report(incident, this.$constraint);
                    } else if (this.$partial) {
                        this.$context.report(incident, GradleDetector.access$map(this.this$0));
                    } else {
                        this.$context.report(incident);
                    }
                    this.$reportCreated.element = true;
                } else if (enabled && this.$context instanceof TomlContext) {
                    Location location = Context.getLocation$default((Context)this.$context, (Object)this.$cookie, null, (int)2, null);
                    Position position = location.getStart();
                    int start = position != null ? position.getOffset() : 0;
                    boolean checkComments = this.$context.containsCommentSuppress();
                    if (checkComments && this.$context.isSuppressedWithComment(start, this.$issue)) {
                        return;
                    }
                    Incident incident = new Incident(this.$issue, location, this.$message, this.$fix);
                    Severity severity = this.$overrideSeverity;
                    if (severity != null) {
                        Severity it = severity;
                        boolean bl = false;
                        incident.overrideSeverity(it);
                    }
                    incident.setClientProperties(this.$clientProperties);
                    if (this.$constraint != null) {
                        this.$context.report(incident, this.$constraint);
                    } else if (this.$partial) {
                        this.$context.report(incident, GradleDetector.access$map(this.this$0));
                    } else {
                        this.$context.report(incident);
                    }
                    this.$reportCreated.element = true;
                }
            }
        });
        return reportCreated.element;
    }

    static /* synthetic */ boolean report$default(GradleDetector gradleDetector, Context context, Object object, Issue issue, String string, LintFix lintFix, boolean bl, Severity severity, Constraint constraint, LintMap lintMap, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            severity = null;
        }
        if ((n & 0x80) != 0) {
            constraint = null;
        }
        if ((n & 0x100) != 0) {
            lintMap = null;
        }
        return gradleDetector.report(context, object, issue, string, lintFix, bl, severity, constraint, lintMap);
    }

    private final void reportFatalCompatibilityIssue(Context context, Object cookie, String message2) {
        GradleDetector.report$default(this, context, cookie, COMPATIBILITY, message2, null, false, null, null, null, 496, null);
    }

    private final void reportFatalCompatibilityIssue(Context context, Object cookie, String message2, LintFix fix2) {
        GradleDetector.report$default(this, context, cookie, COMPATIBILITY, message2, fix2, false, null, null, null, 480, null);
    }

    private final void reportFatalCompatibilityIssue(Context context, Location location, String message2) {
        context.getClient().runReadAction(new Runnable(context, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;
            {
                this.$context = $context;
                this.$location = $location;
                this.$message = $message;
            }

            public final void run() {
                Context.report$default((Context)this.$context, (Issue)GradleDetector.COMPATIBILITY, (Location)this.$location, (String)this.$message, null, (int)8, null);
            }
        });
    }

    private final int getSdkVersion(String value, Object valueCookie) {
        int version = 0;
        if (GradleContext.Companion.isStringLiteral(value)) {
            String codeName = GradleContext.Companion.getStringLiteralValue(value, valueCookie);
            if (codeName != null) {
                if (com.android.tools.lint.detector.api.Lint.isNumberString((String)codeName)) {
                    return -1;
                }
                AndroidVersion androidVersion = SdkVersionInfo.getVersion((String)codeName, null);
                if (androidVersion != null) {
                    version = androidVersion.getFeatureLevel();
                }
            }
        } else {
            version = GradleContext.Companion.getIntLiteralValue(value, -1);
        }
        return version;
    }

    private final Dependency resolveCoordinate(GradleContext context, String property, Dependency dependency) {
        boolean bl;
        Object object = dependency.getVersion();
        boolean bl2 = object != null && (object = object.toIdentifier()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"$", (boolean)false, (int)2, null) : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-GradleDetector$resolveCoordinate$22 = false;
            String $i$a$-assert-GradleDetector$resolveCoordinate$22 = String.valueOf(dependency.getVersion());
            throw new AssertionError((Object)$i$a$-assert-GradleDetector$resolveCoordinate$22);
        }
        Project project = context.getProject();
        LintModelVariant variant = project.getBuildVariant();
        if (variant != null) {
            LintModelArtifact lintModelArtifact = StringsKt.startsWith$default((String)property, (String)"androidTest", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getAndroidTestArtifact() : (StringsKt.startsWith$default((String)property, (String)"testFixtures", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getTestFixturesArtifact() : (StringsKt.startsWith$default((String)property, (String)"test", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getTestArtifact() : variant.getArtifact()));
            if (lintModelArtifact == null) {
                return null;
            }
            LintModelArtifact artifact = lintModelArtifact;
            for (LintModelLibrary library : artifact.getDependencies().getAll()) {
                LintModelMavenName mc;
                if (!(library instanceof LintModelExternalLibrary) || !Intrinsics.areEqual((Object)(mc = ((LintModelExternalLibrary)library).getResolvedCoordinates()).getGroupId(), (Object)dependency.getGroup()) || !Intrinsics.areEqual((Object)mc.getArtifactId(), (Object)dependency.getName())) continue;
                Version version = Version.Companion.parse(mc.getVersion());
                return GradleDetector.resolveCoordinate$toDependency(new Component(mc.getGroupId(), mc.getArtifactId(), version));
            }
        }
        return null;
    }

    private final boolean isPrivacySandboxSdk(Project project) {
        LintModelModule lintModelModule = project.getBuildModule();
        return (lintModelModule != null ? lintModelModule.getType() : null) == LintModelModuleType.PRIVACY_SANDBOX_SDK;
    }

    private final boolean usesLegacyHttpLibrary(Project project) {
        LintModelModule lintModelModule = project.getBuildModule();
        if (lintModelModule == null) {
            return false;
        }
        LintModelModule model2 = lintModelModule;
        for (File file : model2.getBootClassPath()) {
            if (!FilesKt.endsWith((File)file, (String)"org.apache.http.legacy.jar")) continue;
            return true;
        }
        return false;
    }

    private final LintFix getUpdateDependencyFix(String currentVersion, String suggestedVersion, String group, boolean suggestedVersionIsSafe, Version safeReplacement) {
        LintFix lintFix;
        String action = Intrinsics.areEqual((Object)group, (Object)"com.android.tools.build") ? "Replace with" : "Change to";
        String displayName = action + " " + suggestedVersion;
        if (safeReplacement != null && LintClient.Companion.isStudio()) {
            displayName = displayName + " (Risky; prefer Upgrade Assistant)";
        }
        LintFix fix2 = this.fix().name(displayName).sharedName("Update versions").replace().text(currentVersion).with(suggestedVersion).autoFix(suggestedVersionIsSafe, suggestedVersionIsSafe).build();
        if (safeReplacement != null) {
            String stableVersion = safeReplacement.toString();
            LintFix stableFix = this.fix().name(action + " " + stableVersion).sharedName("Update versions").replace().text(currentVersion).with(stableVersion).autoFix().build();
            LintFix[] lintFixArray = new LintFix[]{stableFix, fix2};
            lintFix = this.fix().alternatives(lintFixArray);
        } else {
            lintFix = fix2;
        }
        return lintFix;
    }

    static /* synthetic */ LintFix getUpdateDependencyFix$default(GradleDetector gradleDetector, String string, String string2, String string3, boolean bl, Version version, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUpdateDependencyFix");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            version = null;
        }
        return gradleDetector.getUpdateDependencyFix(string, string2, string3, bl, version);
    }

    private final String id(Dependency $this$id) {
        Object object;
        if (this.isGradlePlugin($this$id)) {
            String string = $this$id.getGroup();
            object = string;
            Intrinsics.checkNotNull((Object)string);
        } else {
            object = $this$id.getGroup() + ":" + $this$id.getName();
        }
        return object;
    }

    private final boolean isGradlePlugin(Dependency $this$isGradlePlugin) {
        return $this$isGradlePlugin.getGroup() != null && StringsKt.endsWith$default((String)$this$isGradlePlugin.getName(), (String)GRADLE_PLUGIN_ARTIFACT_SUFFIX, (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)$this$isGradlePlugin.getName(), (Object)($this$isGradlePlugin.getGroup() + GRADLE_PLUGIN_ARTIFACT_SUFFIX));
    }

    private final String getNewerVersionAvailableMessage(Dependency dependency, String version, Version stable) {
        StringBuilder message2;
        StringBuilder $this$getNewerVersionAvailableMessage_u24lambda_u2431 = message2 = new StringBuilder();
        boolean bl = false;
        $this$getNewerVersionAvailableMessage_u24lambda_u2431.append("A newer version of ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(this.id(dependency));
        $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(" than ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(String.valueOf(dependency.getVersion()));
        $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(" is available: ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(version);
        if (stable != null) {
            $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(". (There is also a newer version of ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(String.valueOf(stable.getMajor()));
            $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(".");
            $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(String.valueOf(stable.getMinor()));
            $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(".\ud835\udc65 available, if upgrading to ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(version);
            $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(" is difficult: ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(stable.toString());
            $this$getNewerVersionAvailableMessage_u24lambda_u2431.append(")");
        }
        String string = message2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Issue issue = incident.getIssue();
        if (issue == DUPLICATE_CLASSES) {
            return context.getMainProject().getMinSdk() < 23 || this.usesLegacyHttpLibrary(context.getMainProject());
        }
        throw new IllegalStateException(issue.getId().toString());
    }

    public void checkMergedProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis() && context.getDriver().isIsolated()) {
            return;
        }
        this.checkLibraryConsistency(context);
    }

    private final String getBlockedDependencyMessage(List<? extends LintModelDependency> path) {
        boolean direct = path.size() == 1;
        String message2 = null;
        String resolution = "Solutions include finding newer versions or alternative libraries that don't have the same problem (for example, for `httpclient` use `HttpUrlConnection` or `okhttp` instead), or repackaging the library using something like `jarjar`.";
        if (direct) {
            message2 = "`" + path.get(0).getArtifactId() + "` defines classes that conflict with classes now provided by Android. " + resolution;
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (LintModelDependency lintModelDependency : path) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" \u2192 ");
                }
                String coordinates = lintModelDependency.getArtifactName();
                sb.append(coordinates);
            }
            sb.append(") ");
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String chain = string;
            message2 = "`" + path.get(0).getArtifactId() + "` depends on a library (" + path.get(path.size() - 1).getArtifactName() + ") which defines classes that conflict with classes now provided by Android. " + resolution + " Dependency chain: " + chain;
        }
        return message2;
    }

    private final Companion.AvailableVersions getGoogleMavenRepoVersion(Context context, Dependency dependency, Predicate<Version> predicate) {
        String string = dependency.getGroup();
        if (string == null) {
            return null;
        }
        String group = string;
        String artifact = dependency.getName();
        GoogleMavenRepository repository2 = this.getGoogleMavenRepository(context.getClient());
        Sequence versions = repository2.getVersions(dependency, predicate);
        RichVersion richVersion = dependency.getVersion();
        Version currentVersion = richVersion != null ? richVersion.getLowerBound() : null;
        return com.android.tools.lint.checks.GradleDetector$Companion.getMavenMetadataVersions$default(Companion, versions, currentVersion, group, artifact, null, 16, null);
    }

    private final Version getSdkIndexVersion(GooglePlaySdkIndex sdkIndex, String groupId, String artifactId, Predicate<Version> filter2) {
        boolean isValid;
        String string = sdkIndex.getLatestVersion(groupId, artifactId);
        if (string == null) {
            return null;
        }
        String latestVersion = string;
        Version parsedVersion = Version.Companion.parse(latestVersion);
        Predicate<Version> predicate = filter2;
        boolean bl = isValid = predicate != null ? predicate.test(parsedVersion) : true;
        if (isValid && !parsedVersion.isPreview()) {
            return parsedVersion;
        }
        return null;
    }

    @NotNull
    public final GoogleMavenRepository getGoogleMavenRepository(@NotNull LintClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        GoogleMavenRepository googleMavenRepository = this.googleMavenRepository;
        if (googleMavenRepository == null) {
            File cacheDir;
            GradleDetector $this$getGoogleMavenRepository_u24lambda_u2432 = this;
            boolean bl = false;
            File file = cacheDir = client.getCacheDir("maven.google", true);
            Path path = file != null ? file.toPath() : null;
            GoogleMavenRepository repository2 = new GoogleMavenRepository(client, path){
                final /* synthetic */ LintClient $client;
                {
                    this.$client = $client;
                    super($super_call_param$1, 0, 0, false, 14, null);
                }

                protected NetworkCache.ReadUrlDataResult readUrlData(String url, int timeout, long lastModified) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    return com.android.tools.lint.detector.api.Lint.readUrlData((LintClient)this.$client, (String)url, (int)timeout, (long)lastModified);
                }

                public void error(Throwable throwable, String message2) {
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    this.$client.log(throwable, message2, new Object[0]);
                }
            };
            $this$getGoogleMavenRepository_u24lambda_u2432.googleMavenRepository = repository2;
            googleMavenRepository = repository2;
        }
        return googleMavenRepository;
    }

    private final GooglePlaySdkIndex getGooglePlaySdkIndex(LintClient client) {
        GooglePlaySdkIndex googlePlaySdkIndex = this.googlePlaySdkIndex;
        if (googlePlaySdkIndex == null) {
            GooglePlaySdkIndex repository2;
            File cacheDir;
            GradleDetector $this$getGooglePlaySdkIndex_u24lambda_u2433 = this;
            boolean bl = false;
            File file = cacheDir = client.getCacheDir("sdk_index", true);
            $this$getGooglePlaySdkIndex_u24lambda_u2433.googlePlaySdkIndex = repository2 = (GooglePlaySdkIndex)((Object)playSdkIndexFactory.invoke((Object)(file != null ? file.toPath() : null), (Object)client));
            googlePlaySdkIndex = repository2;
        }
        return googlePlaySdkIndex;
    }

    public void run(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!StringsKt.endsWith$default((String)string, (String)"gradle-wrapper.properties", (boolean)false, (int)2, null)) {
            return;
        }
        CharSequence charSequence = context.getContents();
        if (charSequence == null) {
            return;
        }
        CharSequence contents = charSequence;
        int offset = 0;
        Iterator iterator = Splitter.on((char)'\n').split(contents).iterator();
        String line = null;
        while (iterator.hasNext()) {
            Object t2 = iterator.next();
            Intrinsics.checkNotNullExpressionValue(t2, (String)"next(...)");
            line = (String)t2;
            if (StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)" ", (boolean)false, (int)2, null)) {
                offset += line.length() + 1;
                continue;
            }
            int valueStart = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)0, (boolean)false, (int)6, null) + 1;
            if (valueStart == 0) {
                offset += line.length() + 1;
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"distributionUrl", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)line, (String)".zip", (boolean)false, (int)2, null)) {
                this.checkGradleWrapperDistribution(context, contents, offset, line, valueStart);
            }
            offset += line.length() + 1;
        }
    }

    private final void checkGradleWrapperDistribution(Context context, CharSequence contents, int offset, String line, int valueStart) {
        Version version;
        String prefix = "/distributions/gradle-";
        int index2 = StringsKt.indexOf$default((CharSequence)line, (String)prefix, (int)0, (boolean)false, (int)6, null);
        if (index2 == -1) {
            return;
        }
        int versionStart = index2 + prefix.length();
        int versionEnd = StringsKt.lastIndexOf$default((CharSequence)line, (char)'-', (int)0, (boolean)false, (int)6, null);
        String string = line.substring(versionStart, versionEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String versionString = string;
        Version currentVersion = Version.Companion.parse(versionString);
        LintModelModule lintModelModule = context.getProject().getBuildModule();
        AgpVersion agpVersion = lintModelModule != null ? lintModelModule.getAgpVersion() : null;
        Predicate filter2 = agpVersion != null && agpVersion.getMajor() >= 7 ? (Predicate)new Predicate(agpVersion){
            final /* synthetic */ AgpVersion $agpVersion;
            {
                this.$agpVersion = $agpVersion;
            }

            public final boolean test(Version version) {
                Integer n = version.getMajor();
                int n2 = this.$agpVersion.getMajor();
                return n != null && n == n2;
            }
        } : null;
        Companion.AvailableVersions availableVersions = com.android.tools.lint.checks.GradleDetector$Companion.getGradleVersion$default(Companion, context.getClient(), currentVersion, filter2, true, 0, 16, null);
        if (availableVersions == null || (version = availableVersions.getSuggested()) == null) {
            return;
        }
        Version newVersion = version;
        Location location = Location.Companion.create(context.file, contents, offset + valueStart, offset + line.length());
        String message2 = "A newer version of Gradle than " + currentVersion + " is available: " + newVersion;
        LintFix fix2 = this.fix().name("Update to " + newVersion).replace().text(currentVersion.toString()).with(newVersion.toString()).build();
        Incident incident = new Incident(AGP_DEPENDENCY, location, message2, fix2);
        context.report(incident);
    }

    private static final Predicate<Version> checkDependency$and(Predicate<Version> $this$checkDependency_u24and, Predicate<Version> other) {
        Predicate<Version> predicate;
        if ($this$checkDependency_u24and != null && other != null) {
            predicate = $this$checkDependency_u24and.and(other);
        } else {
            predicate = $this$checkDependency_u24and;
            if (predicate == null) {
                predicate = other;
            }
        }
        return predicate;
    }

    private static final Dependency resolveCoordinate$toDependency(Component $this$resolveCoordinate_u24toDependency) {
        return new Dependency($this$resolveCoordinate_u24toDependency.getGroup(), $this$resolveCoordinate_u24toDependency.getName(), RichVersion.Companion.require($this$resolveCoordinate_u24toDependency.getVersion()), null, null, 24, null);
    }

    @JvmStatic
    @Nullable
    public static final Version getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull Dependency dependency, @Nullable Predicate<Version> filter2, boolean allowPreview) {
        return Companion.getLatestVersionFromRemoteRepo(client, dependency, filter2, allowPreview);
    }

    @JvmStatic
    @Nullable
    public static final String getNamedDependency(@NotNull String expression) {
        return Companion.getNamedDependency(expression);
    }

    @NotNull
    public static final Function2<Path, LintClient, GooglePlaySdkIndex> getPlaySdkIndexFactory() {
        return Companion.getPlaySdkIndexFactory();
    }

    public static final void setPlaySdkIndexFactory(@NotNull Function2<? super Path, ? super LintClient, ? extends GooglePlaySdkIndex> function2) {
        Companion.setPlaySdkIndexFactory(function2);
    }

    public static final /* synthetic */ void access$checkDependency(GradleDetector $this, Context context, Dependency dependency, boolean isResolved, Object cookie, Object statementCookie) {
        $this.checkDependency(context, dependency, isResolved, cookie, statementCookie);
    }

    public static final /* synthetic */ boolean access$isOldApacheCommonsVersion(GradleDetector $this, Version $receiver) {
        return $this.isOldApacheCommonsVersion($receiver);
    }

    public static final /* synthetic */ LintMap access$map(GradleDetector $this) {
        return $this.map();
    }

    public static final /* synthetic */ boolean access$isRecommendedVersion(GradleDetector $this, Version version, Collection recommendedVersions) {
        return $this.isRecommendedVersion(version, recommendedVersions);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        lastTargetSdkVersion = -1;
        IMPLEMENTATION = new Implementation(GradleDetector.class, Scope.GRADLE_SCOPE);
        Object[] objectArray = new EnumSet[]{Scope.GRADLE_SCOPE, Scope.TOML_SCOPE};
        IMPLEMENTATION_WITH_TOML = new Implementation(GradleDetector.class, Scope.GRADLE_AND_TOML_SCOPE, (EnumSet[])objectArray);
        objectArray = new EnumSet[]{Scope.GRADLE_SCOPE, Scope.TOML_SCOPE, Scope.PROPERTY_SCOPE};
        IMPLEMENTATION_WITH_TOML_AND_PROPERTIES = new Implementation(GradleDetector.class, EnumSet.of((Enum)Scope.GRADLE_FILE, (Enum)Scope.TOML_FILE, (Enum)Scope.PROPERTY_FILE), (EnumSet[])objectArray);
        objectArray = new EnumSet[]{Scope.GRADLE_SCOPE, Scope.MANIFEST_SCOPE, Scope.TOML_SCOPE};
        IMPLEMENTATION_WITH_TOML_AND_MANIFEST = new Implementation(GradleDetector.class, EnumSet.of((Enum)Scope.GRADLE_FILE, (Enum)Scope.MANIFEST, (Enum)Scope.TOML_FILE), (EnumSet[])objectArray);
        DEPENDENCY = Issue.Companion.create("GradleDependency", "Obsolete Gradle Dependency", "\n                This detector looks for usages of libraries where the version you are using \\\n                is not the current stable release. Using older versions is fine, and there \\\n                are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is \\\n                available, and that is what this lint check helps find.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION_WITH_TOML);
        MULTIPLE_VERSIONS_DEPENDENCY = Issue.Companion.create("SimilarGradleDependency", "Multiple Versions Gradle Dependency", "\n                This detector looks for usages of libraries when name and group are the same \\\n                but versions are different. Using multiple versions in big project is fine, \\\n                and there are cases where you deliberately want to stick with such approach. \\\n                However, you may simply not be aware that this situation happens, and that is \\\n                what this lint check helps find.", Category.CORRECTNESS, 4, Severity.INFORMATIONAL, IMPLEMENTATION_WITH_TOML);
        SWITCH_TO_TOML = Issue.Companion.create("UseTomlInstead", "Use TOML Version Catalog Instead", "\n                If your project is using a `libs.versions.toml` file, you should place \\\n                all Gradle dependencies in the TOML file. This lint check looks for \\\n                version declarations outside of the TOML file and suggests moving them \\\n                (and in the IDE, provides a quickfix to performing the operation automatically).\n                ", Category.PRODUCTIVITY, 4, Severity.WARNING, IMPLEMENTATION_WITH_TOML);
        objectArray = Issue.Companion;
        Object object = Category.CORRECTNESS;
        Object object2 = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION_WITH_TOML;
        CORE_LIB_DESUGARING_V2 = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"CoreLibDesugaringV1", (String)"Android 15 requires `desugar_jdk_libs` 2.+", (String)"\n          Core library desugaring with `compileSdk` 35 or later (Android 15) \\\n          requires using version 2.+ of the core library desugaring libraries. \\\n          The code may compile successfully, but can crash at runtime.\n          ", (Implementation)implementation, null, (Category)object, (int)4, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML_AND_PROPERTIES;
        AGP_DEPENDENCY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AndroidGradlePluginVersion", (String)"Obsolete Android Gradle Plugin Version", (String)"\n                This detector looks for usage of the Android Gradle Plugin where the version \\\n                you are using is not the current stable release. Using older versions is fine, \\\n                and there are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is available, \\\n                and that is what this lint check helps find.", (Implementation)implementation, null, (Category)object, (int)4, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEPRECATED = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleDeprecated", (String)"Deprecated Gradle Construct", (String)"\n                This detector looks for deprecated Gradle constructs which currently work \\\n                but will likely stop working in a future update.", (Implementation)implementation, null, (Category)object, (int)6, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEPRECATED_CONFIGURATION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleDeprecatedConfiguration", (String)"Deprecated Gradle Configuration", (String)"\n                Some Gradle configurations have been deprecated since Android Gradle Plugin 3.0.0 \\\n                and will be removed in a future version of the Android Gradle Plugin.\n             ", (Implementation)implementation, (String)"https://d.android.com/r/tools/update-dependency-configurations", (Category)object, (int)6, (Severity)object2, (boolean)false, null, null, null, (int)3840, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.ERROR;
        implementation = IMPLEMENTATION;
        GRADLE_PLUGIN_COMPATIBILITY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradlePluginVersion", (String)"Incompatible Android Gradle Plugin", (String)"\n                Not all versions of the Android Gradle plugin are compatible with all \\\n                versions of the SDK. If you update your tools, or if you are trying to \\\n                open a project that was built with an old version of the tools, you may \\\n                need to update your plugin version number.", (Implementation)implementation, null, (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        PATH = Issue.Companion.create("GradlePath", "Gradle Path Issues", "\n                Gradle build scripts are meant to be cross platform, so file paths use \\\n                Unix-style path separators (a forward slash) rather than Windows path \\\n                separators (a backslash). Similarly, to keep projects portable and \\\n                repeatable, avoid using absolute paths on the system; keep files within \\\n                the project instead. To share code between projects, consider creating \\\n                an android-library and an AAR dependency", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        IDE_SUPPORT = Issue.Companion.create("GradleIdeError", "Gradle IDE Support Issues", "\n                Gradle is highly flexible, and there are things you can do in Gradle \\\n                files which can make it hard or impossible for IDEs to properly handle \\\n                the project. This lint check looks for constructs that potentially \\\n                break IDE support.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
        PLUS = Issue.Companion.create("GradleDynamicVersion", "Gradle Dynamic Version", "\n                Using `+` in dependencies lets you automatically pick up the latest \\\n                available version rather than a specific, named version. However, \\\n                this is not recommended; your builds are not repeatable; you may have \\\n                tested with a slightly different version than what the build server \\\n                used. (Using a dynamic version as the major version number is more \\\n                problematic than using it in the minor version position.)", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.ERROR;
        implementation = IMPLEMENTATION;
        GRADLE_GETTER = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleGetter", (String)"Gradle Implicit Getter Call", (String)"\n                Gradle will let you replace specific constants in your build scripts \\\n                with method calls, so you can for example dynamically compute a version \\\n                string based on your current version control revision number, rather \\\n                than hardcoding a number.\n\n                When computing a version name, it's tempting to for example call the \\\n                method to do that `getVersionName`. However, when you put that method \\\n                call inside the `defaultConfig` block, you will actually be calling the \\\n                Groovy getter for the `versionName` property instead. Therefore, you \\\n                need to name your method something which does not conflict with the \\\n                existing implicit getters. Consider using `compute` as a prefix instead \\\n                of `get`.", (Implementation)implementation, null, (Category)object, (int)6, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.FATAL;
        implementation = IMPLEMENTATION;
        COMPATIBILITY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"GradleCompatible", (String)"Incompatible Gradle Versions", (String)"\n                There are some combinations of libraries, or tools and libraries, that \\\n                are incompatible, or can lead to bugs. One such incompatibility is \\\n                compiling with a version of the Android support libraries that is not \\\n                the latest version (or in particular, a version lower than your \\\n                `targetSdkVersion`).", (Implementation)implementation, null, (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.ERROR;
        implementation = IMPLEMENTATION;
        STRING_INTEGER = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"StringShouldBeInt", (String)"String should be int", (String)"\n                The properties `compileSdkVersion`, `minSdkVersion` and `targetSdkVersion` \\\n                are usually numbers, but can be strings when you are using an add-on (in \\\n                the case of `compileSdkVersion`) or a preview platform (for the other two \\\n                properties).\n\n                However, you can not use a number as a string (e.g. \"19\" instead of 19); \\\n                that will result in a platform not found error message at build/sync \\\n                time.", (Implementation)implementation, null, (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.ERROR;
        implementation = IMPLEMENTATION;
        NOT_INTERPOLATED = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"NotInterpolated", (String)"Incorrect Interpolation", (String)"\n                To insert the value of a variable, you can use `${variable}` inside a \\\n                string literal, but **only** if you are using double quotes!", (Implementation)implementation, (String)"https://www.groovy-lang.org/syntax.html#_string_interpolation", (Category)object, (int)8, (Severity)object2, (boolean)false, null, null, null, (int)3840, null);
        REMOTE_VERSION = Issue.Companion.create("NewerVersionAvailable", "Newer Library Versions Available", "\n          This detector checks with a central repository to see if there are newer \\\n          versions available for the dependencies used by this project. This is \\\n          similar to the `GradleDependency` check, which checks for newer versions \\\n          available in the Android SDK tools and libraries, but this works with any \\\n          MavenCentral dependency, and connects to the library every time, which \\\n          makes it more flexible but also **much** slower.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION_WITH_TOML);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML;
        MIN_SDK_TOO_LOW = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"MinSdkTooLow", (String)"API Version Too Low", (String)"\n                The value of the `minSdkVersion` property is too low and can be \\\n                incremented without noticeably reducing the number of supported \\\n                devices.", (Implementation)implementation, null, (Category)object, (int)4, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3088, null);
        ACCIDENTAL_OCTAL = Issue.Companion.create("AccidentalOctal", "Accidental Octal", "\n                In Groovy, an integer literal that starts with a leading 0 will be \\\n                interpreted as an octal number. That is usually (always?) an accident \\\n                and can lead to subtle bugs, for example when used in the `versionCode` \\\n                of an app.", Category.CORRECTNESS, 2, Severity.ERROR, IMPLEMENTATION);
        objectArray = Issue.Companion;
        object = Category.PERFORMANCE;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION;
        BUNDLED_GMS = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"UseOfBundledGooglePlayServices", (String)"Use of bundled version of Google Play services", (String)"\n                Google Play services SDK's can be selectively included, which enables a \\\n                smaller APK size. Consider declaring dependencies on individual Google \\\n                Play services SDK's. If you are using Firebase API's \\\n                (https://firebase.google.com/docs/android/setup), Android Studio's \\\n                Tools \u2192 Firebase assistant window can automatically add just the \\\n                dependencies needed for each feature.", (Implementation)implementation, (String)"https://developers.google.com/android/guides/setup#split", (Category)object, (int)4, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.ERROR;
        implementation = IMPLEMENTATION;
        HIGH_APP_VERSION_CODE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"HighAppVersionCode", (String)"VersionCode too high", (String)"\n                The declared `versionCode` is an Integer. Ensure that the version number is \\\n                not close to the limit. It is recommended to monotonically increase this \\\n                number each minor or major release of the app. Note that updating an app \\\n                with a versionCode over `Integer.MAX_VALUE` is not possible.", (Implementation)implementation, (String)"https://developer.android.com/studio/publish/versioning.html", (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = Category.PERFORMANCE;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEV_MODE_OBSOLETE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DevModeObsolete", (String)"Dev Mode Obsolete", (String)"\n                In the past, our documentation recommended creating a `dev` product flavor \\\n                with has a minSdkVersion of 21, in order to enable multidexing to speed up \\\n                builds significantly during development.\n\n                That workaround is no longer necessary, and it has some serious downsides, \\\n                such as breaking API access checking (since the true `minSdkVersion` is no \\\n                longer known).\n\n                In recent versions of the IDE and the Gradle plugin, the IDE automatically \\\n                passes the API level of the connected device used for deployment, and if \\\n                that device is at least API 21, then multidexing is automatically turned \\\n                on, meaning that you get the same speed benefits as the `dev` product \\\n                flavor but without the downsides.", (Implementation)implementation, null, (Category)object, (int)2, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.FATAL;
        implementation = IMPLEMENTATION;
        DUPLICATE_CLASSES = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DuplicatePlatformClasses", (String)"Duplicate Platform Classes", (String)"\n                There are a number of libraries that duplicate not just functionality \\\n                of the Android platform but using the exact same class names as the ones \\\n                provided in Android -- for example the apache http classes. This can \\\n                lead to unexpected crashes.\n\n                To solve this, you need to either find a newer version of the library \\\n                which no longer has this problem, or to repackage the library (and all \\\n                of its dependencies) using something like the `jarjar` tool, or finally, \\\n                rewriting the code to use different APIs (for example, for http code, \\\n                consider using `HttpUrlConnection` or a library like `okhttp`).", (Implementation)implementation, null, (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        reservedQuickfixNamesLock = new Object();
        INSTANT_DEPRECATION_MESSAGE = "Instant Apps support will be removed by Google Play in December 2025. Publishing and all Google Play Instant APIs will no longer work. Tooling support will be removed in Android Studio Otter Feature Drop.";
        objectArray = Issue.Companion;
        object = Category.COMPLIANCE;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML_AND_MANIFEST;
        EXPIRING_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"ExpiringTargetSdkVersion", (String)"TargetSdkVersion Soon Expiring", (String)"\n                Configuring your app or sdk to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app or sdk to run on older Android versions (down to the `minSdkVersion`).\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\", \\\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", (Implementation)implementation, null, (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null).addMoreInfo("https://support.google.com/googleplay/android-developer/answer/113469#targetsdk").addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        objectArray = Issue.Companion;
        object = Category.COMPLIANCE;
        object2 = Severity.FATAL;
        implementation = IMPLEMENTATION_WITH_TOML_AND_MANIFEST;
        EXPIRED_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"ExpiredTargetSdkVersion", (String)"TargetSdkVersion No Longer Supported", (String)"\n                Configuring your app or sdk to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\", \\\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", (Implementation)implementation, (String)"https://support.google.com/googleplay/android-developer/answer/113469#targetsdk", (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null).addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        TARGET_NEWER = Issue.Companion.create("OldTargetApi", "Target SDK attribute is not targeting latest version", "\n                When your application or sdk runs on a version of Android that is more recent than your \\\n                `targetSdkVersion` specifies that it has been tested with, various compatibility modes \\\n                kick in. This ensures that your application continues to work, but it may look out of \\\n                place. For example, if the `targetSdkVersion` is less than 14, your app may get an \\\n                option button in the UI.\n\n                To fix this issue, set the `targetSdkVersion` to the highest available value. Then test \\\n                your app to make sure everything works correctly. You may want to consult the \\\n                compatibility notes to see what changes apply to each version you are adding support \\\n                for: https://developer.android.com/reference/android/os/Build.VERSION_CODES.html as well \\\n                as follow this guide:\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION_WITH_TOML_AND_MANIFEST).addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html").addMoreInfo("https://developer.android.com/reference/android/os/Build.VERSION_CODES.html");
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.ERROR;
        implementation = IMPLEMENTATION;
        EDITED_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"EditedTargetSdkVersion", (String)"Manually Edited TargetSdkVersion", (String)"\n        Updating the `targetSdkVersion` of an app is seemingly easy: just increment the \\\n        `targetSdkVersion` number in the manifest file!\n\n        But that's not actually safe. The `targetSdkVersion` controls a wide range of \\\n        behaviors that change from release to release, and to update, you should carefully \\\n        consult the documentation to see what has changed, how your app may need to adjust, \\\n        and then of course, carefully test everything.\n\n        In new versions of Android Studio, there is a special migration assistant, available \\\n        from the tools menu (and as a quickfix from this lint warning) which analyzes your \\\n        specific app and filters the set of applicable migration steps to those needed for \\\n        your app.\n\n        This lint check does something very simple: it just detects whether it looks like \\\n        you've manually edited the targetSdkVersion field in a build.gradle file. Obviously, \\\n        as part of doing the above careful steps, you may end up editing the value, which \\\n        would trigger the check -- and it's safe to ignore it; this lint check *only* runs \\\n        in the IDE, not from the command line; it's sole purpose to bring *awareness* to the \\\n        (many) developers who haven't been aware of this issue and have just bumped the \\\n        targetSdkVersion, recompiled, and uploaded their updated app to the Google Play Store, \\\n        sometimes leading to crashes or other problems on newer devices.\n        ", (Implementation)implementation, null, (Category)object, (int)2, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        object = Category.COMPLIANCE;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML;
        DEPRECATED_LIBRARY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"OutdatedLibrary", (String)"Outdated Library", (String)"\n                Your app is using an outdated version of a library. This may cause violations \\\n                of Google Play policies (see https://play.google.com/about/monetization-ads/ads/) \\\n                and/or may affect your app\u2019s visibility on the Play Store.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n                ", (Implementation)implementation, (String)"https://developer.android.com/distribute/sdk-index", (Category)object, (int)5, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = INSTANT_DEPRECATION_MESSAGE;
        object2 = Category.CORRECTNESS;
        implementation = Severity.WARNING;
        Implementation implementation2 = IMPLEMENTATION_WITH_TOML;
        INSTANT_APP_DEPRECATION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"InstantAppDeprecation", (String)"Instant App Deprecation", (String)object, (Implementation)implementation2, null, (Category)object2, (int)5, (Severity)implementation, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DATA_BINDING_WITHOUT_KAPT = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"DataBindingWithoutKapt", (String)"Data Binding without Annotation Processing", (String)"\n                Apps that use Kotlin and data binding should also apply the kotlin-kapt plugin.\n                ", (Implementation)implementation, (String)"https://kotlinlang.org/docs/reference/kapt.html", (Category)object, (int)1, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = Category.PERFORMANCE;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION;
        LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8 = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"LifecycleAnnotationProcessorWithJava8", (String)"Lifecycle Annotation Processor with Java 8 Compile Option", (String)"\n                For faster incremental build, switch to the Lifecycle Java 8 API with these steps:\n\n                First replace\n                ```gradle\n                annotationProcessor \"androidx.lifecycle:lifecycle-compiler:*version*\"\n                kapt \"androidx.lifecycle:lifecycle-compiler:*version*\"\n                ```\n                with\n                ```gradle\n                implementation \"androidx.lifecycle:lifecycle-common-java8:*version*\"\n                ```\n                Then remove any `OnLifecycleEvent` annotations from `Observer` classes \\\n                and make them implement the `DefaultLifecycleObserver` interface.\n                ", (Implementation)implementation, (String)"https://d.android.com/r/studio-ui/lifecycle-release-notes", (Category)object, (int)6, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = Category.SECURITY;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML;
        RISKY_LIBRARY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"RiskyLibrary", (String)"Libraries with Privacy or Security Risks", (String)"\n                Your app is using a version of a library that has been identified by \\\n                the library developer as a potential source of privacy and/or security risks. \\\n                This may be a violation of Google Play policies (see \\\n                https://play.google.com/about/monetization-ads/ads/) and/or affect your app\u2019s \\\n                visibility on the Play Store.\n\n                When available, the individual error messages from lint will include details \\\n                about the reasons for this advisory.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n            ", (Implementation)implementation, (String)"https://developer.android.com/distribute/sdk-index", (Category)object, (int)4, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null).addMoreInfo("https://goo.gle/RiskyLibrary");
        objectArray = Issue.Companion;
        object = Category.PERFORMANCE;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION;
        ANNOTATION_PROCESSOR_ON_COMPILE_PATH = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AnnotationProcessorOnCompilePath", (String)"Annotation Processor on Compile Classpath", (String)"\n               This dependency is identified as an annotation processor. Consider adding it to the \\\n               processor path using `annotationProcessor` instead of including it to the \\\n               compile path.\n            ", (Implementation)implementation, null, (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        objectArray = Issue.Companion;
        object = Category.PRODUCTIVITY;
        object2 = Severity.INFORMATIONAL;
        implementation = IMPLEMENTATION;
        KTX_EXTENSION_AVAILABLE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"KtxExtensionAvailable", (String)"KTX Extension Available", (String)"\n                Android KTX extensions augment some libraries with support for modern Kotlin \\\n                language features like extension functions, extension properties, lambdas, named \\\n                parameters, coroutines, and more.\n\n                In Kotlin projects, use the KTX version of a library by replacing the \\\n                dependency in your `build.gradle` file. For example, you can replace \\\n                `androidx.fragment:fragment` with `androidx.fragment:fragment-ktx`.\n            ", (Implementation)implementation, (String)"https://developer.android.com/kotlin/ktx", (Category)object, (int)4, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = Category.PERFORMANCE;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION;
        KAPT_USAGE_INSTEAD_OF_KSP = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"KaptUsageInsteadOfKsp", (String)"Kapt usage should be replaced with KSP", (String)"\n                KSP is a more efficient replacement for kapt. For libraries that support both, \\\n                KSP should be used to improve build times.\n            ", (Implementation)implementation, (String)"https://developer.android.com/studio/build/migrate-to-ksp", (Category)object, (int)4, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION_WITH_TOML;
        BOM_WITHOUT_PLATFORM = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"BomWithoutPlatform", (String)"Using a BOM without platform call", (String)"\n          When including a BOM, the dependency's coordinates must be wrapped \\\n          in a call to `platform()` for Gradle to interpret it correctly.\n          ", (Implementation)implementation, (String)"https://developer.android.com/r/tools/gradle-bom-docs", (Category)object, (int)4, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        JAVA_PLUGIN_LANGUAGE_LEVEL = Issue.Companion.create("JavaPluginLanguageLevel", "No Explicit Java Language Level Given", "\n                In modules using plugins deriving from the Gradle `java` plugin (e.g. \\\n                `java-library` or `application`), the java source and target compatibility \\\n                default to the version of the JDK being used to run Gradle, which may cause \\\n                compatibility problems with Android (or other) modules.\n\n                You can specify an explicit sourceCompatibility and targetCompatibility in this \\\n                module to maintain compatibility no matter which JDK is used to run Gradle.\n            ", Category.INTEROPERABILITY, 6, Severity.WARNING, IMPLEMENTATION);
        objectArray = Issue.Companion;
        object = Category.CORRECTNESS;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION;
        JCENTER_REPOSITORY_OBSOLETE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"JcenterRepositoryObsolete", (String)"JCenter Maven repository is read-only", (String)"\n                The JCenter Maven repository is no longer accepting submissions of Maven \\\n                artifacts since 31st March 2021.  Ensure that the project is configured \\\n                to search in repositories with the latest versions of its dependencies.\n            ", (Implementation)implementation, (String)"https://developer.android.com/r/tools/jcenter-end-of-service", (Category)object, (int)8, (Severity)object2, (boolean)false, null, null, null, (int)3840, null);
        objectArray = Issue.Companion;
        object = Category.COMPLIANCE;
        object2 = Severity.ERROR;
        implementation = IMPLEMENTATION_WITH_TOML;
        PLAY_SDK_INDEX_NON_COMPLIANT = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"PlaySdkIndexNonCompliant", (String)"Library has policy issues in SDK Index", (String)"This library version has policy issues that will block publishing in the Google Play Store.", (Implementation)implementation, (String)"https://developer.android.com/distribute/sdk-index", (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = Category.COMPLIANCE;
        object2 = Severity.ERROR;
        implementation = IMPLEMENTATION_WITH_TOML;
        PLAY_SDK_INDEX_VULNERABILITY = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"PlaySdkIndexVulnerability", (String)"Library has vulnerability issues in SDK Index", (String)"This library version has vulnerability issues that could block publishing in the Google Play Store.", (Implementation)implementation, (String)"https://developer.android.com/distribute/sdk-index", (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = Category.COMPLIANCE;
        object2 = Severity.ERROR;
        implementation = IMPLEMENTATION_WITH_TOML;
        PLAY_SDK_INDEX_GENERIC_ISSUES = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"PlaySdkIndexGenericIssues", (String)"Library has issues in SDK Index", (String)"This library version has issues that could block publishing in the Google Play Store.", (Implementation)implementation, (String)"https://developer.android.com/distribute/sdk-index", (Category)object, (int)8, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = Category.SECURITY;
        object2 = Severity.ERROR;
        implementation = IMPLEMENTATION_WITH_TOML;
        PLAY_SDK_INDEX_DEPRECATED = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"PlaySdkIndexDeprecated", (String)"Library is marked as deprecated in SDK Index", (String)"This library has been deprecated, please consider updating to an alternative SDK before publishing a new release.", (Implementation)implementation, (String)"https://developer.android.com/distribute/sdk-index", (Category)object, (int)9, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = Issue.Companion;
        object = Category.CHROME_OS;
        object2 = Severity.WARNING;
        implementation = IMPLEMENTATION;
        CHROMEOS_ABI_SUPPORT = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"ChromeOsAbiSupport", (String)"Missing ABI Support for ChromeOS", (String)"\n                To properly support ChromeOS, your Android application should have an x86 and/or x86_64 binary \\\n                as part of the build configuration. To fix the issue, ensure your files are properly optimized \\\n                for ARM; the binary translator will then ensure compatibility with x86. Alternatively, add an \\\n                `abiSplit` for x86 within your `build.gradle` file and create the required x86 dependencies.\n            ", (Implementation)implementation, (String)"https://developer.android.com/ndk/guides/abis", (Category)object, (int)4, (Severity)object2, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        objectArray = new String[]{"java", "java-library", "application"};
        Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$flatMap = false;
        object2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = new String[]{it, "org.gradle." + it};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        JAVA_PLUGIN_IDS = (List)implementation;
        objectArray = new String[]{APP_PLUGIN_ID, LIB_PLUGIN_ID, "com.android.dynamic-feature", "com.android.asset-pack", "com.android.asset-pack-bundle", "com.android.ai-pack", "com.android.lint", "com.android.test", "com.android.fused-library", "com.android.privacy-sandbox-sdk", "com.android.kotlin.multiplatform.library", "com.android.settings", OLD_APP_PLUGIN_ID, OLD_LIB_PLUGIN_ID, "com.android.feature", "com.android.instant-app"};
        ALL_PLUGIN_IDS = SetsKt.setOf((Object[])objectArray);
        PLAY_SERVICES_V650 = Component.Companion.parse("com.google.android.gms:play-services:6.5.0");
        objectArray = new String[]{"com.jakewharton:butterknife-compiler", "com.github.bumptech.glide:compiler", "androidx.databinding:databinding-compiler", "com.google.dagger:dagger-compiler", "com.google.auto.service:auto-service", "android.arch.persistence.room:compiler", "android.arch.lifecycle:compiler", "io.realm:realm-annotations-processor", "com.google.dagger:dagger-android-processor", "androidx.room:room-compiler", "com.android.databinding:compiler", "androidx.lifecycle:lifecycle-compiler", "org.projectlombok:lombok", "com.google.auto.value:auto-value", "org.parceler:parceler", "com.github.hotchemi:permissionsdispatcher-processor", "com.alibaba:arouter-compiler", "org.androidannotations:androidannotations", "com.github.Raizlabs.DBFlow:dbflow-processor", "frankiesardo:icepick-processor", "org.greenrobot:eventbus-annotation-processor", "com.ryanharter.auto.value:auto-value-gson", "io.objectbox:objectbox-processor", "com.arello-mobile:moxy-compiler", "com.squareup.dagger:dagger-compiler", "io.realm:realm-android", "com.bluelinelabs:logansquare-compiler", "com.tencent.tinker:tinker-android-anno", "com.raizlabs.android:DBFlow-Compiler", "com.google.auto.factory:auto-factory", "com.airbnb:deeplinkdispatch-processor", "com.alipay.android.tools:androidannotations", "org.permissionsdispatcher:permissionsdispatcher-processor", "com.airbnb.android:epoxy-processor", "org.immutables:value", "com.github.stephanenicolas.toothpick:toothpick-compiler", "com.mindorks.android:placeholderview-compiler", "com.github.frankiesardo:auto-parcel-processor", "com.hannesdorfmann.fragmentargs:processor", "com.evernote:android-state-processor", "org.mapstruct:mapstruct-processor", "com.iqiyi.component.router:qyrouter-compiler", "com.iqiyi.component.mm:mm-compiler", "dk.ilios:realmfieldnameshelper", "com.lianjia.common.android.router2:compiler", "com.smile.gifshow.annotation:invoker_processor", "com.f2prateek.dart:dart-processor", "com.sankuai.waimai.router:compiler", "org.qiyi.card:card-action-compiler", "com.iqiyi.video:eventbus-annotation-processor", "ly.img.android.pesdk:build-processor", "org.apache.logging.log4j:log4j-core", "com.github.jokermonn:permissions4m", "com.arialyy.aria:aria-compiler", "com.smile.gifshow.annotation:provide_processor", "com.smile.gifshow.annotation:preference_processor", "com.smile.gifshow.annotation:plugin_processor", "org.inferred:freebuilder", "com.smile.gifshow.annotation:router_processor"};
        commonAnnotationProcessors = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"com.github.bumptech.glide:compiler", (Object)"com.github.bumptech.glide:ksp"), TuplesKt.to((Object)"androidx.room:room-compiler", (Object)"androidx.room:room-compiler"), TuplesKt.to((Object)"com.squareup.moshi:moshi-kotlin-codegen", (Object)"com.squareup.moshi:moshi-kotlin-codegen"), TuplesKt.to((Object)"com.github.liujingxing.rxhttp:rxhttp-compiler", (Object)"com.github.liujingxing.rxhttp:rxhttp-compiler"), TuplesKt.to((Object)"se.ansman.kotshi:compiler", (Object)"se.ansman.kotshi:compiler"), TuplesKt.to((Object)"com.linecorp.lich:savedstate-compiler", (Object)"com.linecorp.lich:savedstate-compiler"), TuplesKt.to((Object)"io.github.amrdeveloper:easyadapter-compiler", (Object)"io.github.amrdeveloper:easyadapter-compiler"), TuplesKt.to((Object)"com.airbnb:deeplinkdispatch-processor", (Object)"com.airbnb:deeplinkdispatch-processor"), TuplesKt.to((Object)"com.airbnb.android:epoxy-processor", (Object)"com.airbnb.android:epoxy-processor"), TuplesKt.to((Object)"com.airbnb.android:paris-processor", (Object)"com.airbnb.android:paris-processor")};
        annotationProcessorsWithKspReplacements = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"androidx.compose:compose-bom", "com.google.firebase:firebase-bom", "org.jetbrains.kotlin:kotlin-bom", "org.jetbrains.kotlinx:kotlinx-coroutines-bom", "io.ktor:ktor-bom", "com.squareup.okio:okio-bom", "com.squareup.okhttp3:okhttp-bom", "com.squareup.wire:wire-bom", "com.fasterxml.jackson:jackson-bom", "io.grpc:grpc-bom", "org.http4k:http4k-bom", "org.http4k:http4k-connect-bom", "org.junit:junit-bom", "io.kotest:kotest-bom", "io.cucumber:cucumber-bom", "io.arrow-kt:arrow-stack", "io.sentry:sentry-bom", "dev.chrisbanes.compose:compose-bom", "org.ow2.asm:asm-bom", "software.amazon.awssdk:bom", "com.walletconnect:android-bom"};
        commonBoms = SetsKt.setOf((Object[])objectArray);
        playSdkIndexFactory = Companion.playSdkIndexFactory.1.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$AgpVersionCheckInfo;", "", "newerVersion", "Lcom/android/ide/common/gradle/Version;", "newerVersionIsSafe", "", "safeReplacement", "dependency", "Lcom/android/ide/common/gradle/Dependency;", "isResolved", "cookie", "<init>", "(Lcom/android/ide/common/gradle/Version;ZLcom/android/ide/common/gradle/Version;Lcom/android/ide/common/gradle/Dependency;ZLjava/lang/Object;)V", "getNewerVersion", "()Lcom/android/ide/common/gradle/Version;", "getNewerVersionIsSafe", "()Z", "getSafeReplacement", "getDependency", "()Lcom/android/ide/common/gradle/Dependency;", "getCookie", "()Ljava/lang/Object;", "lint-checks"})
    private static final class AgpVersionCheckInfo {
        @NotNull
        private final Version newerVersion;
        private final boolean newerVersionIsSafe;
        @Nullable
        private final Version safeReplacement;
        @NotNull
        private final Dependency dependency;
        private final boolean isResolved;
        @NotNull
        private final Object cookie;

        public AgpVersionCheckInfo(@NotNull Version newerVersion, boolean newerVersionIsSafe, @Nullable Version safeReplacement, @NotNull Dependency dependency, boolean isResolved, @NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)newerVersion, (String)"newerVersion");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            this.newerVersion = newerVersion;
            this.newerVersionIsSafe = newerVersionIsSafe;
            this.safeReplacement = safeReplacement;
            this.dependency = dependency;
            this.isResolved = isResolved;
            this.cookie = cookie;
        }

        @NotNull
        public final Version getNewerVersion() {
            return this.newerVersion;
        }

        public final boolean getNewerVersionIsSafe() {
            return this.newerVersionIsSafe;
        }

        @Nullable
        public final Version getSafeReplacement() {
            return this.safeReplacement;
        }

        @NotNull
        public final Dependency getDependency() {
            return this.dependency;
        }

        public final boolean isResolved() {
            return this.isResolved;
        }

        @NotNull
        public final Object getCookie() {
            return this.cookie;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u001f\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0006\u00c4\u0001\u00c5\u0001\u00c6\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020nJ&\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\u00122\u0006\u0010q\u001a\u00020\u0012JJ\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020l2\u0006\u0010r\u001a\u00020\u00122\u0006\u0010s\u001a\u00020\u00122\u0006\u0010t\u001a\u00020\u00122\u0006\u0010u\u001a\u00020\u00122\u0006\u0010v\u001a\u00020\u00122\u0006\u0010w\u001a\u00020\u00122\n\b\u0002\u0010x\u001a\u0004\u0018\u00010\u0012J.\u0010y\u001a\n\u0012\u0004\u0012\u00020{\u0018\u00010z2\u0006\u0010k\u001a\u00020l2\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\u00122\u0006\u0010q\u001a\u00020{J6\u0010|\u001a\u0004\u0018\u00010{2\u0006\u0010}\u001a\u00020~2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u000f\u0010\u0081\u0001\u001a\n\u0012\u0004\u0012\u00020{\u0018\u00010z2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0007JI\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u00012\u0006\u0010}\u001a\u00020~2\u000b\b\u0002\u0010\u0086\u0001\u001a\u0004\u0018\u00010{2\u0011\b\u0002\u0010\u0081\u0001\u001a\n\u0012\u0004\u0012\u00020{\u0018\u00010z2\n\b\u0002\u0010\u0087\u0001\u001a\u00030\u0083\u00012\t\b\u0002\u0010\u0088\u0001\u001a\u00020\u0005J\u001a\u0010\u0089\u0001\u001a\u00020\u00072\u0006\u0010}\u001a\u00020~2\u0007\u0010\u008a\u0001\u001a\u00020\u0012H\u0002JB\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u00012\u0006\u0010}\u001a\u00020~2\b\u0010\u0087\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u008d\u0001\u001a\u00020\u00122\u0007\u0010\u008e\u0001\u001a\u00020\u00122\u0007\u0010\u008f\u0001\u001a\u00020\u00122\u0007\u0010\u0088\u0001\u001a\u00020\u0005H\u0002JF\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0085\u00012\b\u0010\u0091\u0001\u001a\u00030\u008c\u00012\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010{2\u0007\u0010\u0092\u0001\u001a\u00020\u00122\u0007\u0010\u0093\u0001\u001a\u00020\u00122\u0011\b\u0002\u0010\u0081\u0001\u001a\n\u0012\u0004\u0012\u00020{\u0018\u00010zH\u0002J\u0019\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020{0V2\b\u0010\u0091\u0001\u001a\u00030\u008c\u0001H\u0002JJ\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0085\u00012\u000e\u0010\u0094\u0001\u001a\t\u0012\u0004\u0012\u00020{0\u0095\u00012\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010{2\u0007\u0010\u0092\u0001\u001a\u00020\u00122\u0007\u0010\u0093\u0001\u001a\u00020\u00122\u0011\b\u0002\u0010\u0081\u0001\u001a\n\u0012\u0004\u0012\u00020{\u0018\u00010zJ0\u0010\u0096\u0001\u001a\u000b\u0012\u0004\u0012\u00020{\u0018\u00010\u0095\u00012\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\u00122\f\b\u0002\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u0001H\u0002Jn\u0010\u0099\u0001\u001a\u0005\u0018\u00010\u0085\u00012\u0006\u0010}\u001a\u00020~2\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\u00122\b\u0010q\u001a\u0004\u0018\u00010{2\u000f\u0010\u0081\u0001\u001a\n\u0012\u0004\u0012\u00020{\u0018\u00010z2\n\b\u0002\u0010\u0087\u0001\u001a\u00030\u0083\u00012\f\b\u0002\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u00012\n\b\u0002\u0010\u009a\u0001\u001a\u00030\u0083\u00012\t\b\u0002\u0010\u0088\u0001\u001a\u00020\u0005JA\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u00012\u0006\u0010}\u001a\u00020~2\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\u00122\b\u0010\u0087\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0088\u0001\u001a\u00020\u00052\b\u0010\u009a\u0001\u001a\u00030\u0083\u0001H\u0002JX\u0010\u009b\u0001\u001a\n\u0012\u0004\u0012\u00020{\u0018\u00010V2\u0006\u0010}\u001a\u00020~2\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\u00122\n\b\u0002\u0010\u0087\u0001\u001a\u00030\u0083\u00012\f\b\u0002\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u00012\n\b\u0002\u0010\u009a\u0001\u001a\u00030\u0083\u00012\t\b\u0002\u0010\u0088\u0001\u001a\u00020\u0005Jo\u0010\u009c\u0001\u001a\u0004\u0018\u00010{2\u0006\u0010}\u001a\u00020~2\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\u00122\b\u0010q\u001a\u0004\u0018\u00010{2\u0011\b\u0002\u0010\u0081\u0001\u001a\n\u0012\u0004\u0012\u00020{\u0018\u00010z2\n\b\u0002\u0010\u0087\u0001\u001a\u00030\u0083\u00012\n\b\u0002\u0010\u009a\u0001\u001a\u00030\u0083\u00012\f\b\u0002\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u00012\t\b\u0002\u0010\u0088\u0001\u001a\u00020\u0005J\u001e\u0010\u009d\u0001\u001a\u0005\u0018\u00010\u009e\u00012\u0007\u0010\u009f\u0001\u001a\u00020\u00122\u0007\u0010k\u001a\u00030\u00a0\u0001H\u0002J\u001e\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u009e\u00012\u0007\u0010\u009f\u0001\u001a\u00020\u00122\u0007\u0010k\u001a\u00030\u00a0\u0001H\u0002J\u0014\u0010\u00a2\u0001\u001a\u0004\u0018\u00010\u00122\u0007\u0010\u009f\u0001\u001a\u00020\u0012H\u0007J\"\u0010\u00a3\u0001\u001a\u0013\u0012\u0005\u0012\u00030\u0080\u0001\u0012\u0005\u0012\u00030\u00a5\u0001\u0018\u00010\u00a4\u00012\b\u0010\u009f\u0001\u001a\u00030\u00a6\u0001J\u001d\u0010\u00a7\u0001\u001a\u00030\u0083\u00012\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u00012\u0007\u0010\u00aa\u0001\u001a\u00020\u0012H\u0002J\u0014\u0010\u00ab\u0001\u001a\u00030\u0083\u00012\b\u0010\u00a8\u0001\u001a\u00030\u00a9\u0001H\u0002J\u0012\u0010\u00ac\u0001\u001a\u00030\u0083\u00012\u0006\u0010\u007f\u001a\u00020\u0012H\u0002J\u0012\u0010\u00ad\u0001\u001a\u00030\u0083\u00012\u0006\u0010\u007f\u001a\u00020\u0012H\u0002J\u0013\u0010\u00b2\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u00b3\u0001\u001a\u00020\u0012H\u0002J\u0017\u0010\u00bd\u0001\u001a\u00030\u0083\u0001*\u00020\u00122\u0007\u0010\u00be\u0001\u001a\u00020\u0012H\u0002J\u000f\u0010\u00bf\u0001\u001a\u00030\u0083\u0001*\u00030\u00c0\u0001H\u0002J\u0011\u0010\u00c1\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u00be\u0001\u001a\u00020\u0012J\u0013\u0010\u00c2\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u00be\u0001\u001a\u00020\u0012H\u0002J\u0013\u0010\u00c3\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u00be\u0001\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R.\u00104\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001206\u0018\u000105X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0010\u0010A\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010D\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010H\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010K\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010N\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010P\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010R\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010S\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010T\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00120V\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010XR\u000e\u0010Y\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\\\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00120^\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010`R\u000e\u0010a\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010b\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010c\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010d\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010e\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010f\u001a\u00020gX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010h\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u00ae\u0001\u001a\b\u0012\u0004\u0012\u00020\u00120^X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u00af\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00b0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u00b1\u0001\u001a\b\u0012\u0004\u0012\u00020\u00120^X\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010\u00b4\u0001\u001a\u0019\u0012\u0007\u0012\u0005\u0018\u00010\u00b6\u0001\u0012\u0004\u0012\u00020~\u0012\u0005\u0012\u00030\u00b7\u00010\u00b5\u00018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0019\n\u0000\u0012\u0005\b\u00b8\u0001\u0010\u0003\u001a\u0006\b\u00b9\u0001\u0010\u00ba\u0001\"\u0006\b\u00bb\u0001\u0010\u00bc\u0001\u00a8\u0006\u00c7\u0001"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion;", "", "<init>", "()V", "lastTargetSdkVersion", "", "lastTargetSdkVersionFile", "Ljava/io/File;", "stopFlaggingTargetSdkEdits", "", "calendar", "Ljava/util/Calendar;", "getCalendar", "()Ljava/util/Calendar;", "setCalendar", "(Ljava/util/Calendar;)V", "HIGHEST_KNOWN_STABLE_ANDROID_API", "GRADLE_PLUGIN_ARTIFACT_SUFFIX", "", "KEY_COORDINATE", "KEY_REVISION", "KEY_IDE_AGP_VERSION", "VC_LIBRARY_PREFIX", "VC_PLUGIN_PREFIX", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "IMPLEMENTATION_WITH_TOML", "IMPLEMENTATION_WITH_TOML_AND_PROPERTIES", "IMPLEMENTATION_WITH_TOML_AND_MANIFEST", "DEPENDENCY", "Lcom/android/tools/lint/detector/api/Issue;", "MULTIPLE_VERSIONS_DEPENDENCY", "SWITCH_TO_TOML", "CORE_LIB_DESUGARING_V2", "AGP_DEPENDENCY", "DEPRECATED", "DEPRECATED_CONFIGURATION", "GRADLE_PLUGIN_COMPATIBILITY", "PATH", "IDE_SUPPORT", "PLUS", "GRADLE_GETTER", "COMPATIBILITY", "STRING_INTEGER", "NOT_INTERPOLATED", "REMOTE_VERSION", "MIN_SDK_TOO_LOW", "ACCIDENTAL_OCTAL", "BUNDLED_GMS", "HIGH_APP_VERSION_CODE", "DEV_MODE_OBSOLETE", "DUPLICATE_CLASSES", "reservedQuickfixNames", "", "", "getReservedQuickfixNames", "()Ljava/util/Map;", "setReservedQuickfixNames", "(Ljava/util/Map;)V", "reservedQuickfixNamesLock", "getReservedQuickfixNamesLock", "()Ljava/lang/Object;", "INSTANT_DEPRECATION_MESSAGE", "getINSTANT_DEPRECATION_MESSAGE", "()Ljava/lang/String;", "EXPIRING_TARGET_SDK_VERSION", "EXPIRED_TARGET_SDK_VERSION", "TARGET_NEWER", "EDITED_TARGET_SDK_VERSION", "DEPRECATED_LIBRARY", "INSTANT_APP_DEPRECATION", "DATA_BINDING_WITHOUT_KAPT", "LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8", "RISKY_LIBRARY", "ANNOTATION_PROCESSOR_ON_COMPILE_PATH", "KTX_EXTENSION_AVAILABLE", "KAPT_USAGE_INSTEAD_OF_KSP", "BOM_WITHOUT_PLATFORM", "JAVA_PLUGIN_LANGUAGE_LEVEL", "JCENTER_REPOSITORY_OBSOLETE", "PLAY_SDK_INDEX_NON_COMPLIANT", "PLAY_SDK_INDEX_VULNERABILITY", "PLAY_SDK_INDEX_GENERIC_ISSUES", "PLAY_SDK_INDEX_DEPRECATED", "CHROMEOS_ABI_SUPPORT", "JAVA_PLUGIN_IDS", "", "getJAVA_PLUGIN_IDS", "()Ljava/util/List;", "APP_PLUGIN_ID", "LIB_PLUGIN_ID", "OLD_APP_PLUGIN_ID", "OLD_LIB_PLUGIN_ID", "ALL_PLUGIN_IDS", "", "getALL_PLUGIN_IDS", "()Ljava/util/Set;", "GMS_GROUP_ID", "FIREBASE_GROUP_ID", "GOOGLE_SUPPORT_GROUP_ID", "ANDROID_WEAR_GROUP_ID", "WEARABLE_ARTIFACT_ID", "PLAY_SERVICES_V650", "Lcom/android/ide/common/gradle/Component;", "VERSION_CODE_HIGH_THRESHOLD", "getDependencyLocation", "Lcom/android/tools/lint/detector/api/Location;", "context", "Lcom/android/tools/lint/detector/api/Context;", "c", "Lcom/android/tools/lint/model/LintModelMavenName;", "groupId", "artifactId", "version", "groupId1", "artifactId1", "version1", "groupId2", "artifactId2", "version2", "message", "getUpgradeVersionFilter", "Ljava/util/function/Predicate;", "Lcom/android/ide/common/gradle/Version;", "getLatestVersionFromRemoteRepo", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dependency", "Lcom/android/ide/common/gradle/Dependency;", "filter", "allowPreview", "", "getGradleVersion", "Lcom/android/tools/lint/checks/GradleDetector$Companion$AvailableVersions;", "currentVersion", "allowCache", "cacheExpiryHours", "getNetworkCacheDirectory", "repositoryKey", "getMavenMetadata", "Ljava/io/InputStream;", "repositoryCacheKey", "baseUrl", "relative", "getMavenMetadataVersions", "inputStream", "group", "artifact", "versions", "Lkotlin/sequences/Sequence;", "getGmavenVersions", "gmavenRepository", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "getMavenVersions", "includeJitpack", "getAllMavenVersions", "getMavenVersion", "getDependencyFromVersionCatalog", "Lcom/android/tools/lint/checks/GradleDetector$Companion$VersionCatalogDependency;", "expression", "Lcom/android/tools/lint/detector/api/GradleContext;", "getPluginFromVersionCatalog", "getNamedDependency", "getKtsDependency", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/uast/UCallExpression;", "suggestApiConfigurationUse", "project", "Lcom/android/tools/lint/detector/api/Project;", "configuration", "targetJava8Plus", "hasLifecycleAnnotationProcessor", "isCommonAnnotationProcessor", "commonAnnotationProcessors", "annotationProcessorsWithKspReplacements", "", "commonBoms", "libraryHasKtxExtension", "mavenName", "playSdkIndexFactory", "Lkotlin/Function2;", "Ljava/nio/file/Path;", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex;", "getPlaySdkIndexFactory$annotations", "getPlaySdkIndexFactory", "()Lkotlin/jvm/functions/Function2;", "setPlaySdkIndexFactory", "(Lkotlin/jvm/functions/Function2;)V", "tomlKeyMatches", "key", "isTomlSeparator", "", "isCompileSdkTomlVersionKey", "isMinSdkTomlVersionKey", "isTargetSdkTomlVersionKey", "AvailableVersions", "VersionCatalogDependency", "CompileConfiguration", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nGradleDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDetector.kt\ncom/android/tools/lint/checks/GradleDetector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,4836:1\n1#2:4837\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void stopFlaggingTargetSdkEdits() {
            lastTargetSdkVersion = Integer.MAX_VALUE;
            lastTargetSdkVersionFile = null;
        }

        @Nullable
        public final Calendar getCalendar() {
            return calendar;
        }

        public final void setCalendar(@Nullable Calendar calendar) {
            GradleDetector.calendar = calendar;
        }

        @Nullable
        public final Map<String, Set<String>> getReservedQuickfixNames() {
            return reservedQuickfixNames;
        }

        public final void setReservedQuickfixNames(@Nullable Map<String, Set<String>> map) {
            reservedQuickfixNames = map;
        }

        @NotNull
        public final Object getReservedQuickfixNamesLock() {
            return reservedQuickfixNamesLock;
        }

        @NotNull
        public final String getINSTANT_DEPRECATION_MESSAGE() {
            return INSTANT_DEPRECATION_MESSAGE;
        }

        @NotNull
        public final List<String> getJAVA_PLUGIN_IDS() {
            return JAVA_PLUGIN_IDS;
        }

        @NotNull
        public final Set<String> getALL_PLUGIN_IDS() {
            return ALL_PLUGIN_IDS;
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull LintModelMavenName c2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            return this.getDependencyLocation(context, c2.getGroupId(), c2.getArtifactId(), c2.getVersion());
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            LintClient client = context.getClient();
            File projectDir = context.getProject().getDir();
            String withoutQuotes = groupId + ":" + artifactId + ":" + version;
            Intrinsics.checkNotNull((Object)projectDir);
            Location location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)withoutQuotes);
            if (location.getStart() != null) {
                return location;
            }
            location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)(groupId + ":" + artifactId + ":"));
            if (location.getStart() != null) {
                return location;
            }
            location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)artifactId);
            if (location.getStart() != null) {
                return location;
            }
            location = com.android.tools.lint.detector.api.Lint.guessGradleLocation((LintClient)client, (File)projectDir, (String)groupId);
            return location;
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context, @NotNull String groupId1, @NotNull String artifactId1, @NotNull String version1, @NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2, @Nullable String message2) {
            Location location1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)groupId1, (String)"groupId1");
                Intrinsics.checkNotNullParameter((Object)artifactId1, (String)"artifactId1");
                Intrinsics.checkNotNullParameter((Object)version1, (String)"version1");
                Intrinsics.checkNotNullParameter((Object)groupId2, (String)"groupId2");
                Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId2");
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version2");
                location1 = this.getDependencyLocation(context, groupId1, artifactId1, version1);
                Location location2 = this.getDependencyLocation(context, groupId2, artifactId2, version2);
                if (location2.getStart() == null && Intrinsics.areEqual((Object)location1.getFile(), (Object)location2.getFile())) break block1;
                location1.setSecondary(location2);
                String string = message2;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    location2.setMessage(it);
                }
            }
            return location1;
        }

        public static /* synthetic */ Location getDependencyLocation$default(Companion companion, Context context, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, Object object) {
            if ((n & 0x80) != 0) {
                string7 = null;
            }
            return companion.getDependencyLocation(context, string, string2, string3, string4, string5, string6, string7);
        }

        @Nullable
        public final Predicate<Version> getUpgradeVersionFilter(@NotNull Context context, @NotNull String groupId, @NotNull String artifactId, @NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            if ((Intrinsics.areEqual((Object)groupId, (Object)"com.android.tools.build") || this.getALL_PLUGIN_IDS().contains(groupId)) && LintClient.Companion.isStudio()) {
                Object object = context.getClient().getClientProperty(GradleDetector.KEY_IDE_AGP_VERSION);
                String string = object instanceof String ? (String)object : null;
                if (string == null) {
                    return null;
                }
                String agpVersion = string;
                Version ideGradleCompatibleVersion = Version.Companion.parse(agpVersion);
                Integer n = ideGradleCompatibleVersion.getMajor();
                if (n == null) {
                    return null;
                }
                int ideMajor = n;
                Integer n2 = ideGradleCompatibleVersion.getMinor();
                if (n2 == null) {
                    return null;
                }
                int ideMinor = n2;
                return new Predicate(ideGradleCompatibleVersion, ideMajor, ideMinor, version){
                    final /* synthetic */ Version $ideGradleCompatibleVersion;
                    final /* synthetic */ int $ideMajor;
                    final /* synthetic */ int $ideMinor;
                    final /* synthetic */ Version $version;
                    {
                        this.$ideGradleCompatibleVersion = $ideGradleCompatibleVersion;
                        this.$ideMajor = $ideMajor;
                        this.$ideMinor = $ideMinor;
                        this.$version = $version;
                    }

                    public final boolean test(Version v) {
                        int minor;
                        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                        Integer n = v.getMajor();
                        int major = n != null ? n : Integer.MAX_VALUE;
                        Integer n2 = v.getMinor();
                        int n3 = minor = n2 != null ? n2 : Integer.MAX_VALUE;
                        return this.$ideGradleCompatibleVersion.isPreview() && major == this.$ideMajor && minor == this.$ideMinor ? Intrinsics.areEqual((Object)v, (Object)this.$ideGradleCompatibleVersion) : major < this.$ideMajor || major == this.$ideMajor && minor <= this.$ideMinor || Intrinsics.areEqual((Object)v.getMajor(), (Object)this.$version.getMajor()) && Intrinsics.areEqual((Object)v.getMinor(), (Object)this.$version.getMinor());
                    }
                };
            }
            if (Intrinsics.areEqual((Object)groupId, (Object)"com.google.guava")) {
                String suffix = version.toString();
                Predicate jre2 = getUpgradeVersionFilter.jre.1.INSTANCE;
                Predicate android2 = getUpgradeVersionFilter.android.1.INSTANCE;
                Predicate neither2 = getUpgradeVersionFilter.neither.1.INSTANCE;
                return StringsKt.endsWith$default((String)suffix, (String)"-jre", (boolean)false, (int)2, null) ? jre2 : (StringsKt.endsWith$default((String)suffix, (String)"-android", (boolean)false, (int)2, null) ? android2 : neither2);
            }
            if (Intrinsics.areEqual((Object)groupId, (Object)"org.jetbrains.kotlinx") && StringsKt.contains$default((CharSequence)artifactId, (CharSequence)"kotlinx-coroutines", (boolean)false, (int)2, null)) {
                String suffix = version.toString();
                return StringsKt.contains$default((CharSequence)suffix, (CharSequence)"-native-mt-2", (boolean)false, (int)2, null) ? (Predicate)getUpgradeVersionFilter.2.INSTANCE : (StringsKt.contains$default((CharSequence)suffix, (CharSequence)"-native-mt", (boolean)false, (int)2, null) ? (Predicate)getUpgradeVersionFilter.3.INSTANCE : (Predicate)getUpgradeVersionFilter.4.INSTANCE);
            }
            if (version.getMajor() != null) {
                Version infimum = version.getPreviewInfimum();
                Version supremum = version.getPreviewSupremum();
                if (infimum != null && supremum != null) {
                    return new Predicate(infimum, supremum){
                        final /* synthetic */ Version $infimum;
                        final /* synthetic */ Version $supremum;
                        {
                            this.$infimum = $infimum;
                            this.$supremum = $supremum;
                        }

                        public final boolean test(Version v) {
                            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                            return v.isPreview() ? this.$infimum.compareTo(v) < 0 && v.compareTo(this.$supremum) < 0 : true;
                        }
                    };
                }
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final Version getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull Dependency dependency, @Nullable Predicate<Version> filter2, boolean allowPreview) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            String string = dependency.getGroup();
            if (string == null) {
                return null;
            }
            String group = string;
            String name = dependency.getName();
            RichVersion richVersion = dependency.getVersion();
            Version currentVersion = richVersion != null ? richVersion.getLowerBound() : null;
            return com.android.tools.lint.checks.GradleDetector$Companion.getMavenVersion$default(this, client, group, name, currentVersion, filter2, true, false, null, 0, 448, null);
        }

        @Nullable
        public final AvailableVersions getGradleVersion(@NotNull LintClient client, @Nullable Version currentVersion, @Nullable Predicate<Version> filter2, boolean allowCache, int cacheExpiryHours) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            InputStream inputStream2 = this.getMavenMetadata(client, "org.gradle", "gradle-tooling-api", allowCache, cacheExpiryHours, false);
            if (inputStream2 != null) {
                return this.getMavenMetadataVersions(inputStream2, currentVersion, "org.gradle", "gradle-tooling-api", filter2);
            }
            return null;
        }

        public static /* synthetic */ AvailableVersions getGradleVersion$default(Companion companion, LintClient lintClient, Version version, Predicate predicate, boolean bl, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                version = null;
            }
            if ((n2 & 4) != 0) {
                predicate = null;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            if ((n2 & 0x10) != 0) {
                n = -1;
            }
            return companion.getGradleVersion(lintClient, version, predicate, bl, n);
        }

        private final File getNetworkCacheDirectory(LintClient client, String repositoryKey) {
            File root = client.getCacheDir("maven-versions", true);
            File repositoryDir = new File(root, repositoryKey);
            repositoryDir.mkdirs();
            return repositoryDir;
        }

        private final InputStream getMavenMetadata(LintClient client, boolean allowCache, String repositoryCacheKey, String baseUrl, String relative, int cacheExpiryHours) {
            InputStream inputStream2;
            if (allowCache) {
                Path cacheDir = this.getNetworkCacheDirectory(client, repositoryCacheKey).toPath();
                int n = cacheExpiryHours != -1 ? cacheExpiryHours : (int)TimeUnit.DAYS.toHours(7L);
                var cache2 = new NetworkCache(baseUrl, cacheDir, client, relative, n){
                    final /* synthetic */ LintClient $client;
                    final /* synthetic */ String $relative;
                    {
                        this.$client = $client;
                        this.$relative = $relative;
                        super($baseUrl, $cacheDir, 0, $super_call_param$1, false, 20, null);
                    }

                    protected NetworkCache.ReadUrlDataResult readUrlData(String url, int timeout, long lastModified) {
                        NetworkCache.ReadUrlDataResult readUrlDataResult;
                        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                        try {
                            readUrlDataResult = com.android.tools.lint.detector.api.Lint.readUrlData((LintClient)this.$client, (String)url, (int)timeout, (long)lastModified);
                        }
                        catch (IOException iOException) {
                            readUrlDataResult = new NetworkCache.ReadUrlDataResult(new byte[0], true);
                        }
                        return readUrlDataResult;
                    }

                    protected InputStream readDefaultData(String relative) {
                        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
                        return null;
                    }

                    public void error(Throwable throwable, String message2) {
                        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    }

                    public final InputStream getMetadata() {
                        return NetworkCache.findData$default((NetworkCache)this, (String)this.$relative, (boolean)false, (int)2, null);
                    }
                };
                inputStream2 = cache2.getMetadata();
            } else {
                ByteArrayInputStream byteArrayInputStream;
                try {
                    ByteArrayInputStream byteArrayInputStream2;
                    byte[] byArray = com.android.tools.lint.detector.api.Lint.readUrlData((LintClient)client, (String)(baseUrl + relative), (int)10000, (long)0L).getData();
                    if (byArray != null) {
                        byte[] it = byArray;
                        boolean bl = false;
                        byteArrayInputStream2 = new ByteArrayInputStream(it);
                    } else {
                        byteArrayInputStream2 = null;
                    }
                    byteArrayInputStream = byteArrayInputStream2;
                }
                catch (IOException iOException) {
                    byteArrayInputStream = null;
                }
                inputStream2 = byteArrayInputStream;
            }
            InputStream inputStream3 = inputStream2;
            return inputStream3;
        }

        private final AvailableVersions getMavenMetadataVersions(InputStream inputStream2, Version currentVersion, String group, String artifact, Predicate<Version> filter2) {
            Sequence sequence2 = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Version>, Continuation<? super Unit>, Object>(inputStream2, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ InputStream $inputStream;
                {
                    this.$inputStream = $inputStream;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2;
                    KXmlParser parser;
                    SequenceScope $this$sequence;
                    Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            $this$sequence = (SequenceScope)this.L$0;
                            parser = new KXmlParser();
                            parser.setInput(this.$inputStream, StandardCharsets.UTF_8.name());
                            break;
                        }
                        case 1: {
                            void $result;
                            parser = (KXmlParser)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }
                    while (parser.next() != 1) {
                        if (parser.getEventType() != 2 || !Intrinsics.areEqual((Object)parser.getName(), (Object)"version")) continue;
                        String string = parser.nextText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextText(...)");
                        String versionString = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        if (!(((CharSequence)versionString).length() > 0)) continue;
                        this.L$0 = $this$sequence;
                        this.L$1 = parser;
                        this.label = 1;
                        object2 = $this$sequence.yield((Object)Version.Companion.parse(versionString), (Continuation)this);
                        if (object2 != object3) continue;
                        return object3;
                    }
                    return Unit.INSTANCE;
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super Version> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            return this.getMavenMetadataVersions((Sequence<Version>)sequence2, currentVersion, group, artifact, filter2);
        }

        static /* synthetic */ AvailableVersions getMavenMetadataVersions$default(Companion companion, InputStream inputStream2, Version version, String string, String string2, Predicate predicate, int n, Object object) {
            if ((n & 0x10) != 0) {
                predicate = null;
            }
            return companion.getMavenMetadataVersions(inputStream2, version, string, string2, (Predicate<Version>)predicate);
        }

        private final List<Version> getMavenMetadataVersions(InputStream inputStream2) {
            List versions = new ArrayList();
            KXmlParser parser = new KXmlParser();
            parser.setInput(inputStream2, StandardCharsets.UTF_8.name());
            while (parser.next() != 1) {
                if (parser.getEventType() != 2 || !Intrinsics.areEqual((Object)parser.getName(), (Object)"version")) continue;
                String string = parser.nextText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextText(...)");
                String versionString = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (!(((CharSequence)versionString).length() > 0)) continue;
                versions.add(Version.Companion.parse(versionString));
            }
            return CollectionsKt.sorted((Iterable)versions);
        }

        @Nullable
        public final AvailableVersions getMavenMetadataVersions(@NotNull Sequence<Version> versions, @Nullable Version currentVersion, @NotNull String group, @NotNull String artifact, @Nullable Predicate<Version> filter2) {
            Intrinsics.checkNotNullParameter(versions, (String)"versions");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Version stable = null;
            Version preview = null;
            Version patch = null;
            Version suggested = null;
            for (Version version : versions) {
                if (filter2 != null && !filter2.test(version) || version.isSnapshot()) continue;
                boolean isPreview = version.isPreview();
                if (isPreview) {
                    if (preview != null && version.compareTo(preview) <= 0) continue;
                    preview = version;
                    continue;
                }
                if (currentVersion != null && Intrinsics.areEqual((Object)version.getMajor(), (Object)currentVersion.getMajor()) && Intrinsics.areEqual((Object)version.getMinor(), (Object)currentVersion.getMinor()) && version.compareTo(currentVersion) > 0 && (patch == null || version.compareTo(patch) > 0)) {
                    patch = version;
                }
                if (stable == null || version.compareTo(stable) > 0) {
                    stable = version;
                }
                if (preview != null && version.compareTo(preview) <= 0) continue;
                preview = version;
            }
            if (preview != null) {
                if (Intrinsics.areEqual((Object)group, (Object)"com.google.guava") || Intrinsics.areEqual((Object)artifact, (Object)"kotlinx-coroutines-core") && preview.compareTo(Version.Companion.parse("1.6.4")) < 0) {
                    stable = preview;
                }
                if (currentVersion != null) {
                    if (stable != null && currentVersion.compareTo(stable) < 0) {
                        suggested = stable;
                    } else if (currentVersion.isPreview() && currentVersion.compareTo(preview) < 0) {
                        suggested = preview;
                    }
                }
                return new AvailableVersions(patch, stable, preview, suggested);
            }
            return null;
        }

        public static /* synthetic */ AvailableVersions getMavenMetadataVersions$default(Companion companion, Sequence sequence2, Version version, String string, String string2, Predicate predicate, int n, Object object) {
            if ((n & 0x10) != 0) {
                predicate = null;
            }
            return companion.getMavenMetadataVersions((Sequence<Version>)sequence2, version, string, string2, (Predicate<Version>)predicate);
        }

        private final Sequence<Version> getGmavenVersions(String groupId, String artifactId, GoogleMavenRepository gmavenRepository) {
            if (gmavenRepository != null && gmavenRepository.hasGroupId(groupId) && !Intrinsics.areEqual((Object)groupId, (Object)"com.google.devtools.ksp")) {
                return CollectionsKt.asSequence((Iterable)gmavenRepository.getVersions(groupId, artifactId));
            }
            return null;
        }

        static /* synthetic */ Sequence getGmavenVersions$default(Companion companion, String string, String string2, GoogleMavenRepository googleMavenRepository, int n, Object object) {
            if ((n & 4) != 0) {
                googleMavenRepository = null;
            }
            return companion.getGmavenVersions(string, string2, googleMavenRepository);
        }

        @Nullable
        public final AvailableVersions getMavenVersions(@NotNull LintClient client, @NotNull String groupId, @NotNull String artifactId, @Nullable Version version, @Nullable Predicate<Version> filter2, boolean allowCache, @Nullable GoogleMavenRepository gmavenRepository, boolean includeJitpack, int cacheExpiryHours) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Sequence<Version> gmavenVersions = this.getGmavenVersions(groupId, artifactId, gmavenRepository);
            if (gmavenVersions != null) {
                return this.getMavenMetadataVersions(gmavenVersions, version, groupId, artifactId, filter2);
            }
            InputStream mavenMetadata = this.getMavenMetadata(client, groupId, artifactId, allowCache, cacheExpiryHours, includeJitpack);
            if (mavenMetadata != null) {
                return this.getMavenMetadataVersions(mavenMetadata, version, groupId, artifactId, filter2);
            }
            return null;
        }

        public static /* synthetic */ AvailableVersions getMavenVersions$default(Companion companion, LintClient lintClient, String string, String string2, Version version, Predicate predicate, boolean bl, GoogleMavenRepository googleMavenRepository, boolean bl2, int n, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                bl = false;
            }
            if ((n2 & 0x40) != 0) {
                googleMavenRepository = null;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = true;
            }
            if ((n2 & 0x100) != 0) {
                n = -1;
            }
            return companion.getMavenVersions(lintClient, string, string2, version, predicate, bl, googleMavenRepository, bl2, n);
        }

        private final InputStream getMavenMetadata(LintClient client, String groupId, String artifactId, boolean allowCache, int cacheExpiryHours, boolean includeJitpack) {
            InputStream inputStream2;
            if (StringsKt.endsWith$default((String)artifactId, (String)GradleDetector.GRADLE_PLUGIN_ARTIFACT_SUFFIX, (boolean)false, (int)2, null)) {
                String pluginId = StringsKt.removeSuffix((String)artifactId, (CharSequence)GradleDetector.GRADLE_PLUGIN_ARTIFACT_SUFFIX);
                InputStream inputStream3 = this.getMavenMetadata(client, allowCache, "plugins.gradle.org", "https://plugins.gradle.org/m2/", StringsKt.replace$default((String)pluginId, (String)".", (String)"/", (boolean)false, (int)4, null) + "/" + artifactId + "/maven-metadata.xml", cacheExpiryHours);
                if (inputStream3 != null) {
                    InputStream it = inputStream3;
                    boolean bl = false;
                    return it;
                }
            } else if (Intrinsics.areEqual((Object)groupId, (Object)"org.gradle") && Intrinsics.areEqual((Object)artifactId, (Object)"gradle-tooling-api") && (inputStream2 = this.getMavenMetadata(client, allowCache, "repo.gradle.org", "https://repo.gradle.org/artifactory/libs-releases/org/gradle/gradle-tooling-api/", "maven-metadata.xml", cacheExpiryHours)) != null) {
                InputStream it = inputStream2;
                boolean bl = false;
                return it;
            }
            if ((inputStream2 = this.getMavenMetadata(client, allowCache, "repo1.maven.org", "https://repo1.maven.org/maven2/", StringsKt.replace$default((String)groupId, (String)".", (String)"/", (boolean)false, (int)4, null) + "/" + artifactId + "/maven-metadata.xml", cacheExpiryHours)) != null) {
                InputStream it = inputStream2;
                boolean bl = false;
                return it;
            }
            if (StringsKt.startsWith$default((String)groupId, (String)"com.github.", (boolean)false, (int)2, null) && includeJitpack) {
                inputStream2 = this.getMavenMetadata(client, allowCache, "jitpack.io", "https://jitpack.io/", StringsKt.replace$default((String)groupId, (String)".", (String)"/", (boolean)false, (int)4, null) + "/" + artifactId + "/maven-metadata.xml", cacheExpiryHours);
                if (inputStream2 != null) {
                    InputStream it = inputStream2;
                    boolean bl = false;
                    return it;
                }
            } else if (StringsKt.startsWith$default((String)groupId, (String)"io.fabric", (boolean)false, (int)2, null) && (inputStream2 = this.getMavenMetadata(client, allowCache, "io.fabric", "https://maven.fabric.io/public/", StringsKt.replace$default((String)groupId, (String)".", (String)"/", (boolean)false, (int)4, null) + "/" + artifactId + "/maven-metadata.xml", cacheExpiryHours)) != null) {
                InputStream it = inputStream2;
                boolean bl = false;
                return it;
            }
            return null;
        }

        @Nullable
        public final List<Version> getAllMavenVersions(@NotNull LintClient client, @NotNull String groupId, @NotNull String artifactId, boolean allowCache, @Nullable GoogleMavenRepository gmavenRepository, boolean includeJitpack, int cacheExpiryHours) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Sequence<Version> gmavenVersions = this.getGmavenVersions(groupId, artifactId, gmavenRepository);
            if (gmavenVersions != null) {
                return SequencesKt.toList((Sequence)SequencesKt.sorted(gmavenVersions));
            }
            InputStream mavenMetadata = this.getMavenMetadata(client, groupId, artifactId, allowCache, cacheExpiryHours, includeJitpack);
            if (mavenMetadata != null) {
                return this.getMavenMetadataVersions(mavenMetadata);
            }
            return null;
        }

        public static /* synthetic */ List getAllMavenVersions$default(Companion companion, LintClient lintClient, String string, String string2, boolean bl, GoogleMavenRepository googleMavenRepository, boolean bl2, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            if ((n2 & 0x10) != 0) {
                googleMavenRepository = null;
            }
            if ((n2 & 0x20) != 0) {
                bl2 = true;
            }
            if ((n2 & 0x40) != 0) {
                n = -1;
            }
            return companion.getAllMavenVersions(lintClient, string, string2, bl, googleMavenRepository, bl2, n);
        }

        @Nullable
        public final Version getMavenVersion(@NotNull LintClient client, @NotNull String groupId, @NotNull String artifactId, @Nullable Version version, @Nullable Predicate<Version> filter2, boolean allowCache, boolean includeJitpack, @Nullable GoogleMavenRepository gmavenRepository, int cacheExpiryHours) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            AvailableVersions versions = this.getMavenVersions(client, groupId, artifactId, version, filter2, allowCache, gmavenRepository, includeJitpack, cacheExpiryHours);
            if (versions != null) {
                Version version2 = versions.getSuggested();
                if (version2 == null) {
                    if (version == null) {
                        version2 = versions.getLatestStable();
                        if (version2 == null) {
                            version2 = versions.getLatestPreview();
                        }
                    } else {
                        version2 = null;
                    }
                }
                return version2;
            }
            return null;
        }

        public static /* synthetic */ Version getMavenVersion$default(Companion companion, LintClient lintClient, String string, String string2, Version version, Predicate predicate, boolean bl, boolean bl2, GoogleMavenRepository googleMavenRepository, int n, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                predicate = null;
            }
            if ((n2 & 0x20) != 0) {
                bl = false;
            }
            if ((n2 & 0x40) != 0) {
                bl2 = true;
            }
            if ((n2 & 0x80) != 0) {
                googleMavenRepository = null;
            }
            if ((n2 & 0x100) != 0) {
                n = -1;
            }
            return companion.getMavenVersion(lintClient, string, string2, version, predicate, bl, bl2, googleMavenRepository, n);
        }

        private final VersionCatalogDependency getDependencyFromVersionCatalog(String expression, GradleContext context) {
            LintTomlValue lintTomlValue;
            Object object;
            block8: {
                block7: {
                    Object v2;
                    block6: {
                        LintTomlMapValue lintTomlMapValue;
                        if (!StringsKt.startsWith$default((String)expression, (String)GradleDetector.VC_LIBRARY_PREFIX, (boolean)false, (int)2, null)) {
                            return null;
                        }
                        String string = expression.substring(5);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String libName = string;
                        object = GradleContext.getTomlValue$default((GradleContext)context, (String)"libraries", (boolean)false, (int)2, null);
                        LintTomlMapValue lintTomlMapValue2 = lintTomlMapValue = object instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
                        if (lintTomlMapValue == null || (object = lintTomlMapValue.getMappedValues()) == null) break block7;
                        Iterable iterable = object.entrySet();
                        if (iterable == null) break block7;
                        Iterable iterable2 = iterable;
                        for (Object t2 : iterable2) {
                            Map.Entry it = (Map.Entry)t2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)StringsKt.replace$default((String)((String)it.getKey()), (char)'-', (char)'.', (boolean)false, (int)4, null), (char)'_', (char)'.', (boolean)false, (int)4, null), (Object)libName)) continue;
                            v2 = t2;
                            break block6;
                        }
                        v2 = null;
                    }
                    Map.Entry entry = v2;
                    if (entry != null && (lintTomlValue = (LintTomlValue)entry.getValue()) != null) break block8;
                }
                return null;
            }
            LintTomlValue library = lintTomlValue;
            object = GradleContext.getTomlValue$default((GradleContext)context, (String)"versions", (boolean)false, (int)2, null);
            LintTomlMapValue versions = object instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
            Pair<String, LintTomlValue> pair = Lint.getLibraryFromTomlEntry(versions, library);
            if (pair == null) {
                return null;
            }
            String coordinate = (String)pair.component1();
            return new VersionCatalogDependency(coordinate, library);
        }

        private final VersionCatalogDependency getPluginFromVersionCatalog(String expression, GradleContext context) {
            LintTomlValue lintTomlValue;
            Object object;
            block8: {
                block7: {
                    Object v2;
                    block6: {
                        LintTomlMapValue lintTomlMapValue;
                        if (!StringsKt.startsWith$default((String)expression, (String)GradleDetector.VC_PLUGIN_PREFIX, (boolean)false, (int)2, null)) {
                            return null;
                        }
                        String string = expression.substring(13);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String pluginName = string;
                        object = GradleContext.getTomlValue$default((GradleContext)context, (String)"plugins", (boolean)false, (int)2, null);
                        LintTomlMapValue lintTomlMapValue2 = lintTomlMapValue = object instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
                        if (lintTomlMapValue == null || (object = lintTomlMapValue.getMappedValues()) == null) break block7;
                        Iterable iterable = object.entrySet();
                        if (iterable == null) break block7;
                        Iterable iterable2 = iterable;
                        for (Object t2 : iterable2) {
                            Map.Entry it = (Map.Entry)t2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)StringsKt.replace$default((String)StringsKt.replace$default((String)((String)it.getKey()), (char)'-', (char)'.', (boolean)false, (int)4, null), (char)'_', (char)'.', (boolean)false, (int)4, null), (Object)pluginName)) continue;
                            v2 = t2;
                            break block6;
                        }
                        v2 = null;
                    }
                    Map.Entry entry = v2;
                    if (entry != null && (lintTomlValue = (LintTomlValue)entry.getValue()) != null) break block8;
                }
                return null;
            }
            LintTomlValue plugin = lintTomlValue;
            object = GradleContext.getTomlValue$default((GradleContext)context, (String)"versions", (boolean)false, (int)2, null);
            LintTomlMapValue versions = object instanceof LintTomlMapValue ? (LintTomlMapValue)object : null;
            Pair<String, LintTomlValue> pair = Lint.getPluginFromTomlEntry(versions, plugin);
            if (pair == null) {
                return null;
            }
            String coordinate = (String)pair.component1();
            return new VersionCatalogDependency(coordinate, plugin);
        }

        @JvmStatic
        @Nullable
        public final String getNamedDependency(@NotNull String expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (StringsKt.indexOf$default((CharSequence)expression, (char)',', (int)0, (boolean)false, (int)6, null) != -1 && StringsKt.contains$default((CharSequence)expression, (CharSequence)"version:", (boolean)false, (int)2, null)) {
                String artifact = null;
                String group = null;
                String version = null;
                Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
                for (String property : splitter.split((CharSequence)expression)) {
                    String value;
                    int valueEnd;
                    Intrinsics.checkNotNull((Object)property);
                    int colon = StringsKt.indexOf$default((CharSequence)property, (char)':', (int)0, (boolean)false, (int)6, null);
                    if (colon == -1) {
                        return null;
                    }
                    char quote = '\'';
                    int valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    if (valueStart == -1) {
                        quote = '\"';
                        valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    }
                    if (valueStart == -1) continue;
                    if ((valueEnd = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(++valueStart), (boolean)false, (int)4, null)) == -1) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)property.substring(valueStart, valueEnd), (String)"substring(...)");
                    if (StringsKt.startsWith$default((String)property, (String)"group:", (boolean)false, (int)2, null)) {
                        group = value;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)property, (String)"name:", (boolean)false, (int)2, null)) {
                        artifact = value;
                        continue;
                    }
                    if (!StringsKt.startsWith$default((String)property, (String)"version:", (boolean)false, (int)2, null)) continue;
                    version = value;
                }
                if (artifact != null && group != null && version != null) {
                    return group + ":" + artifact + ":" + version;
                }
            }
            return null;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public final Pair<Dependency, KtElement> getKtsDependency(@NotNull UCallExpression expression) {
            block22: {
                block23: {
                    block25: {
                        block24: {
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            sourcePsi = expression.getSourcePsi();
                            if (!(sourcePsi instanceof KtCallExpression)) break block22;
                            v0 = ((KtCallExpression)sourcePsi).getValueArguments();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getValueArguments(...)");
                            arguments = v0;
                            if (arguments.size() != 1) break block23;
                            v1 /* !! */  = ((KtValueArgument)arguments.get(0)).getArgumentExpression();
                            if (v1 /* !! */  == null) break block24;
                            it = v1 /* !! */ ;
                            $i$a$-let-GradleDetector$Companion$getKtsDependency$string$1 = false;
                            v2 = ConstantEvaluator.evaluateString(null, (PsiElement)((PsiElement)it), (boolean)false);
                            v1 /* !! */  = v2;
                            if (v2 != null) break block25;
                        }
                        return null;
                    }
                    string /* !! */  = v1 /* !! */ ;
                    return TuplesKt.to((Object)Dependency.Companion.parse((String)string /* !! */ ), arguments.get(0));
                }
                if (arguments.size() < 3) {
                    return null;
                }
                group /* !! */  = null;
                artifact /* !! */  = null;
                version /* !! */  = null;
                index = 0;
                versionElement = (KtElement)sourcePsi;
                for (KtValueArgument argument : arguments) {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    v3 = argument.getArgumentName();
                                    v4 = name = v3 != null && (v3 = v3.getAsName()) != null ? v3.getIdentifier() : null;
                                    v5 /* !! */  = argument.getArgumentExpression();
                                    if (v5 /* !! */  == null) break block26;
                                    it = v5 /* !! */ ;
                                    $i$a$-let-GradleDetector$Companion$getKtsDependency$value$1 = false;
                                    v6 = ConstantEvaluator.evaluateString(null, (PsiElement)((PsiElement)it), (boolean)false);
                                    v5 /* !! */  = v6;
                                    if (v6 != null) break block27;
                                }
                                v7 = argument.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getText(...)");
                                v5 /* !! */  = StringsKt.removeSurrounding((String)v7, (CharSequence)"\"");
                            }
                            value /* !! */  = v5 /* !! */ ;
                            v8 = var14_17 = name;
                            if (v8 == null) ** GOTO lbl60
                            switch (v8.hashCode()) {
                                case 3373707: {
                                    if (var14_17.equals("name")) break;
                                    ** break;
                                }
                                case 351608024: {
                                    if (!var14_17.equals("version")) {
                                        ** break;
                                    }
                                    break block28;
                                }
                                case 98629247: {
                                    if (!var14_17.equals("group")) {
                                        ** break;
                                    }
                                    ** GOTO lbl62
                                }
lbl60:
                                // 1 sources

                                v9 = index;
                                break block29;
lbl62:
                                // 1 sources

                                v9 = 0;
                                break block29;
                            }
                            v9 = 1;
                            break block29;
                        }
                        v9 = 2;
                        break block29;
lbl69:
                        // 4 sources

                        v9 = index;
                    }
                    target = v9;
                    switch (target) {
                        case 0: {
                            group /* !! */  = value /* !! */ ;
                            break;
                        }
                        case 1: {
                            artifact /* !! */  = value /* !! */ ;
                            break;
                        }
                        case 2: {
                            version /* !! */  = value /* !! */ ;
                            Intrinsics.checkNotNull((Object)argument);
                            versionElement = (KtElement)argument;
                        }
                    }
                    if (++index != 3) continue;
                }
                return group /* !! */  != null && artifact /* !! */  != null && version /* !! */  != null ? TuplesKt.to((Object)Dependency.Companion.parse(group /* !! */  + ":" + artifact /* !! */  + ":" + version /* !! */ ), (Object)versionElement) : null;
            }
            return null;
        }

        private final boolean suggestApiConfigurationUse(Project project, String configuration) {
            boolean bl;
            if (StringsKt.startsWith$default((String)configuration, (String)"test", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)configuration, (String)"androidTest", (boolean)false, (int)2, null)) {
                bl = false;
            } else {
                LintModelModuleType lintModelModuleType = project.getType();
                switch (lintModelModuleType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lintModelModuleType.ordinal()]) {
                    case 1: {
                        bl = project.hasDynamicFeatures();
                        break;
                    }
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 3: {
                        bl = true;
                        break;
                    }
                    case 4: 
                    case 5: {
                        bl = true;
                        break;
                    }
                    case 6: {
                        bl = false;
                        break;
                    }
                    case 7: {
                        bl = false;
                        break;
                    }
                    case 8: {
                        bl = false;
                        break;
                    }
                    case 9: {
                        bl = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return bl;
        }

        private final boolean targetJava8Plus(Project project) {
            return com.android.tools.lint.detector.api.Lint.getLanguageLevel((Project)project, (LanguageLevel)LanguageLevel.JDK_1_7).isAtLeast(LanguageLevel.JDK_1_8);
        }

        private final boolean hasLifecycleAnnotationProcessor(String dependency) {
            return StringsKt.contains$default((CharSequence)dependency, (CharSequence)"android.arch.lifecycle:compiler", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)dependency, (CharSequence)"androidx.lifecycle:lifecycle-compiler", (boolean)false, (int)2, null);
        }

        private final boolean isCommonAnnotationProcessor(String dependency) {
            boolean bl;
            int index2 = StringsKt.lastIndexOf$default((CharSequence)dependency, (String)":", (int)0, (boolean)false, (int)6, null);
            if (index2 == -1) {
                bl = false;
            } else {
                Set set = commonAnnotationProcessors;
                String string = dependency.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                bl = set.contains(string);
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean libraryHasKtxExtension(String mavenName) {
            String string = mavenName;
            switch (string.hashCode()) {
                case -2871177: {
                    if (string.equals("androidx.palette:palette")) return true;
                    return false;
                }
                case 143019008: {
                    if (string.equals("androidx.paging:paging-runtime")) return true;
                    return false;
                }
                case 2126822828: {
                    if (string.equals("androidx.lifecycle:lifecycle-viewmodel")) return true;
                    return false;
                }
                case 268228117: {
                    if (string.equals("androidx.dynamicanimation:dynamicanimation")) return true;
                    return false;
                }
                case -264025202: {
                    if (string.equals("androidx.lifecycle:lifecycle-livedata")) return true;
                    return false;
                }
                case -1586715678: {
                    if (string.equals("androidx.lifecycle:lifecycle-reactivestreams")) return true;
                    return false;
                }
                case -1128017812: {
                    if (string.equals("androidx.navigation:navigation-ui")) return true;
                    return false;
                }
                case 72318654: {
                    if (string.equals("com.google.android.play:core")) return true;
                    return false;
                }
                case -1307799938: {
                    if (string.equals("androidx.lifecycle:lifecycle-livedata-core")) return true;
                    return false;
                }
                case 291543125: {
                    if (string.equals("androidx.activity:activity")) return true;
                    return false;
                }
                case 1493179093: {
                    if (string.equals("androidx.core:core")) return true;
                    return false;
                }
                case 1496698848: {
                    if (string.equals("androidx.lifecycle:lifecycle-runtime")) return true;
                    return false;
                }
                case -378178304: {
                    if (string.equals("androidx.navigation:navigation-runtime")) return true;
                    return false;
                }
                case -568948541: {
                    if (string.equals("androidx.paging:paging-common")) return true;
                    return false;
                }
                case -1453117067: {
                    if (string.equals("androidx.fragment:fragment")) return true;
                    return false;
                }
                case 224658418: {
                    if (string.equals("androidx.paging:paging-rxjava2")) return true;
                    return false;
                }
                case 346279413: {
                    if (string.equals("androidx.sqlite:sqlite")) return true;
                    return false;
                }
                case 1039658464: {
                    if (string.equals("androidx.slice:slice-builders")) return true;
                    return false;
                }
                case -1324096984: {
                    if (string.equals("androidx.navigation:navigation-fragment")) return true;
                    return false;
                }
                case 2032872629: {
                    if (string.equals("androidx.collection:collection")) return true;
                    return false;
                }
                case -1825909611: {
                    if (!string.equals("androidx.preference:preference")) return false;
                    return true;
                }
            }
            return false;
        }

        @NotNull
        public final Function2<Path, LintClient, GooglePlaySdkIndex> getPlaySdkIndexFactory() {
            return playSdkIndexFactory;
        }

        public final void setPlaySdkIndexFactory(@NotNull Function2<? super Path, ? super LintClient, ? extends GooglePlaySdkIndex> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
            playSdkIndexFactory = function2;
        }

        @JvmStatic
        public static /* synthetic */ void getPlaySdkIndexFactory$annotations() {
        }

        private final boolean tomlKeyMatches(String $this$tomlKeyMatches, String key) {
            int ki = key.length() - 1;
            int ti = $this$tomlKeyMatches.length() - 1;
            if (ti < ki || ti == -1 || ki == -1) {
                return false;
            }
            while (ki >= 0) {
                char tc;
                char kc = Character.toLowerCase(key.charAt(ki));
                if (!(kc == (tc = Character.toLowerCase($this$tomlKeyMatches.charAt(ti))) || this.isTomlSeparator(kc) && this.isTomlSeparator(tc))) {
                    return false;
                }
                --ki;
                --ti;
            }
            return ti == -1 || this.isTomlSeparator($this$tomlKeyMatches.charAt(ti));
        }

        private final boolean isTomlSeparator(char $this$isTomlSeparator) {
            return $this$isTomlSeparator == '.' || $this$isTomlSeparator == '_' || $this$isTomlSeparator == '-';
        }

        public final boolean isCompileSdkTomlVersionKey(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.tomlKeyMatches(key, "compileSdk") || this.tomlKeyMatches(key, "compileSdkVersion") || this.tomlKeyMatches(key, "compile_sdk_version");
        }

        private final boolean isMinSdkTomlVersionKey(String key) {
            return this.tomlKeyMatches(key, "minSdk") || this.tomlKeyMatches(key, "minSdkVersion") || this.tomlKeyMatches(key, "min_sdk_version");
        }

        private final boolean isTargetSdkTomlVersionKey(String key) {
            return this.tomlKeyMatches(key, "targetSdk") || this.tomlKeyMatches(key, "targetSdkVersion") || this.tomlKeyMatches(key, "target_sdk_version");
        }

        public static final /* synthetic */ VersionCatalogDependency access$getPluginFromVersionCatalog(Companion $this, String expression, GradleContext context) {
            return $this.getPluginFromVersionCatalog(expression, context);
        }

        public static final /* synthetic */ boolean access$hasLifecycleAnnotationProcessor(Companion $this, String dependency) {
            return $this.hasLifecycleAnnotationProcessor(dependency);
        }

        public static final /* synthetic */ boolean access$targetJava8Plus(Companion $this, Project project) {
            return $this.targetJava8Plus(project);
        }

        public static final /* synthetic */ VersionCatalogDependency access$getDependencyFromVersionCatalog(Companion $this, String expression, GradleContext context) {
            return $this.getDependencyFromVersionCatalog(expression, context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion$AvailableVersions;", "", "latestPatch", "Lcom/android/ide/common/gradle/Version;", "latestStable", "latestPreview", "suggested", "<init>", "(Lcom/android/ide/common/gradle/Version;Lcom/android/ide/common/gradle/Version;Lcom/android/ide/common/gradle/Version;Lcom/android/ide/common/gradle/Version;)V", "getLatestPatch", "()Lcom/android/ide/common/gradle/Version;", "getLatestStable", "getLatestPreview", "getSuggested", "lint-checks"})
        public static final class AvailableVersions {
            @Nullable
            private final Version latestPatch;
            @Nullable
            private final Version latestStable;
            @NotNull
            private final Version latestPreview;
            @Nullable
            private final Version suggested;

            public AvailableVersions(@Nullable Version latestPatch, @Nullable Version latestStable, @NotNull Version latestPreview, @Nullable Version suggested) {
                Intrinsics.checkNotNullParameter((Object)latestPreview, (String)"latestPreview");
                this.latestPatch = latestPatch;
                this.latestStable = latestStable;
                this.latestPreview = latestPreview;
                this.suggested = suggested;
            }

            @Nullable
            public final Version getLatestPatch() {
                return this.latestPatch;
            }

            @Nullable
            public final Version getLatestStable() {
                return this.latestStable;
            }

            @NotNull
            public final Version getLatestPreview() {
                return this.latestPreview;
            }

            @Nullable
            public final Version getSuggested() {
                return this.suggested;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion$CompileConfiguration;", "", "compileConfigName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "API", "COMPILE", "IMPLEMENTATION", "COMPILE_ONLY", "annotationProcessor", "compileConfigSuffix", "matches", "", "configurationName", "replacement", "lint-checks"})
        private static final class CompileConfiguration
        extends Enum<CompileConfiguration> {
            @NotNull
            private final String compileConfigName;
            @NotNull
            private final String annotationProcessor;
            @NotNull
            private final String compileConfigSuffix;
            public static final /* enum */ CompileConfiguration API = new CompileConfiguration("api");
            public static final /* enum */ CompileConfiguration COMPILE = new CompileConfiguration("compile");
            public static final /* enum */ CompileConfiguration IMPLEMENTATION = new CompileConfiguration("implementation");
            public static final /* enum */ CompileConfiguration COMPILE_ONLY = new CompileConfiguration("compileOnly");
            private static final /* synthetic */ CompileConfiguration[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private CompileConfiguration(String compileConfigName) {
                this.compileConfigName = compileConfigName;
                this.annotationProcessor = "annotationProcessor";
                this.compileConfigSuffix = StringHelper.usLocaleCapitalize((String)this.compileConfigName);
            }

            public final boolean matches(@NotNull String configurationName) {
                Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
                return Intrinsics.areEqual((Object)configurationName, (Object)this.compileConfigName) || StringsKt.endsWith$default((String)configurationName, (String)this.compileConfigSuffix, (boolean)false, (int)2, null);
            }

            @NotNull
            public final String replacement(@NotNull String configurationName) {
                Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
                return Intrinsics.areEqual((Object)configurationName, (Object)this.compileConfigName) ? this.annotationProcessor : StringHelper.appendCapitalized((String)StringsKt.removeSuffix((String)configurationName, (CharSequence)this.compileConfigSuffix), (String)this.annotationProcessor);
            }

            public static CompileConfiguration[] values() {
                return (CompileConfiguration[])$VALUES.clone();
            }

            public static CompileConfiguration valueOf(String value) {
                return Enum.valueOf(CompileConfiguration.class, value);
            }

            @NotNull
            public static EnumEntries<CompileConfiguration> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = compileConfigurationArray = new CompileConfiguration[]{CompileConfiguration.API, CompileConfiguration.COMPILE, CompileConfiguration.IMPLEMENTATION, CompileConfiguration.COMPILE_ONLY};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion$VersionCatalogDependency;", "", "coordinates", "", "tomlValue", "Lcom/android/tools/lint/client/api/LintTomlValue;", "<init>", "(Ljava/lang/String;Lcom/android/tools/lint/client/api/LintTomlValue;)V", "getCoordinates", "()Ljava/lang/String;", "getTomlValue", "()Lcom/android/tools/lint/client/api/LintTomlValue;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "lint-checks"})
        private static final class VersionCatalogDependency {
            @NotNull
            private final String coordinates;
            @NotNull
            private final LintTomlValue tomlValue;

            public VersionCatalogDependency(@NotNull String coordinates, @NotNull LintTomlValue tomlValue) {
                Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
                Intrinsics.checkNotNullParameter((Object)tomlValue, (String)"tomlValue");
                this.coordinates = coordinates;
                this.tomlValue = tomlValue;
            }

            @NotNull
            public final String getCoordinates() {
                return this.coordinates;
            }

            @NotNull
            public final LintTomlValue getTomlValue() {
                return this.tomlValue;
            }

            @NotNull
            public final String component1() {
                return this.coordinates;
            }

            @NotNull
            public final LintTomlValue component2() {
                return this.tomlValue;
            }

            @NotNull
            public final VersionCatalogDependency copy(@NotNull String coordinates, @NotNull LintTomlValue tomlValue) {
                Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
                Intrinsics.checkNotNullParameter((Object)tomlValue, (String)"tomlValue");
                return new VersionCatalogDependency(coordinates, tomlValue);
            }

            public static /* synthetic */ VersionCatalogDependency copy$default(VersionCatalogDependency versionCatalogDependency, String string, LintTomlValue lintTomlValue, int n, Object object) {
                if ((n & 1) != 0) {
                    string = versionCatalogDependency.coordinates;
                }
                if ((n & 2) != 0) {
                    lintTomlValue = versionCatalogDependency.tomlValue;
                }
                return versionCatalogDependency.copy(string, lintTomlValue);
            }

            @NotNull
            public String toString() {
                return "VersionCatalogDependency(coordinates=" + this.coordinates + ", tomlValue=" + this.tomlValue + ")";
            }

            public int hashCode() {
                int result = this.coordinates.hashCode();
                result = result * 31 + this.tomlValue.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof VersionCatalogDependency)) {
                    return false;
                }
                VersionCatalogDependency versionCatalogDependency = (VersionCatalogDependency)other;
                if (!Intrinsics.areEqual((Object)this.coordinates, (Object)versionCatalogDependency.coordinates)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tomlValue, (Object)versionCatalogDependency.tomlValue);
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LintModelModuleType.values().length];
                try {
                    nArray[LintModelModuleType.APP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.LIBRARY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.JAVA_LIBRARY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.FEATURE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.DYNAMIC_FEATURE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.TEST.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.INSTANT_APP.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.PRIVACY_SANDBOX_SDK.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LintModelModuleType.FUSED_LIBRARY.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$DeprecatedConfiguration;", "", "deprecatedName", "", "replacementName", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "COMPILE", "PROVIDED", "APK", "deprecatedSuffix", "replacementSuffix", "matches", "", "configurationName", "replacement", "lint-checks"})
    private static final class DeprecatedConfiguration
    extends Enum<DeprecatedConfiguration> {
        @NotNull
        private final String deprecatedName;
        @NotNull
        private final String replacementName;
        @NotNull
        private final String deprecatedSuffix;
        @NotNull
        private final String replacementSuffix;
        public static final /* enum */ DeprecatedConfiguration COMPILE = new DeprecatedConfiguration("compile", "implementation");
        public static final /* enum */ DeprecatedConfiguration PROVIDED = new DeprecatedConfiguration("provided", "compileOnly");
        public static final /* enum */ DeprecatedConfiguration APK = new DeprecatedConfiguration("apk", "runtimeOnly");
        private static final /* synthetic */ DeprecatedConfiguration[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DeprecatedConfiguration(String deprecatedName, String replacementName) {
            this.deprecatedName = deprecatedName;
            this.replacementName = replacementName;
            this.deprecatedSuffix = StringHelper.usLocaleCapitalize((String)this.deprecatedName);
            this.replacementSuffix = StringHelper.usLocaleCapitalize((String)this.replacementName);
        }

        public final boolean matches(@NotNull String configurationName) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) || StringsKt.endsWith$default((String)configurationName, (String)this.deprecatedSuffix, (boolean)false, (int)2, null);
        }

        @NotNull
        public final String replacement(@NotNull String configurationName) {
            Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) ? this.replacementName : StringsKt.removeSuffix((String)configurationName, (CharSequence)this.deprecatedSuffix) + this.replacementSuffix;
        }

        public static DeprecatedConfiguration[] values() {
            return (DeprecatedConfiguration[])$VALUES.clone();
        }

        public static DeprecatedConfiguration valueOf(String value) {
            return Enum.valueOf(DeprecatedConfiguration.class, value);
        }

        @NotNull
        public static EnumEntries<DeprecatedConfiguration> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = deprecatedConfigurationArray = new DeprecatedConfiguration[]{DeprecatedConfiguration.COMPILE, DeprecatedConfiguration.PROVIDED, DeprecatedConfiguration.APK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$JavaPluginInfo;", "", "cookie", "<init>", "(Ljava/lang/Object;)V", "getCookie", "()Ljava/lang/Object;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lint-checks"})
    public static final class JavaPluginInfo {
        @NotNull
        private final Object cookie;

        public JavaPluginInfo(@NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            this.cookie = cookie;
        }

        @NotNull
        public final Object getCookie() {
            return this.cookie;
        }

        @NotNull
        public final Object component1() {
            return this.cookie;
        }

        @NotNull
        public final JavaPluginInfo copy(@NotNull Object cookie) {
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            return new JavaPluginInfo(cookie);
        }

        public static /* synthetic */ JavaPluginInfo copy$default(JavaPluginInfo javaPluginInfo, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = javaPluginInfo.cookie;
            }
            return javaPluginInfo.copy(object);
        }

        @NotNull
        public String toString() {
            return "JavaPluginInfo(cookie=" + this.cookie + ")";
        }

        public int hashCode() {
            return this.cookie.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JavaPluginInfo)) {
                return false;
            }
            JavaPluginInfo javaPluginInfo = (JavaPluginInfo)other;
            return Intrinsics.areEqual((Object)this.cookie, (Object)javaPluginInfo.cookie);
        }
    }
}

