/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.InteroperabilityDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.BooleanOption;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.utils.StringHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.renderer.types.KaTypeRenderer;
import org.jetbrains.kotlin.analysis.api.renderer.types.impl.KaTypeRendererForSource;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaDynamicType;
import org.jetbrains.kotlin.analysis.api.types.KaFlexibleType;
import org.jetbrains.kotlin.analysis.api.types.KaStarTypeProjection;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeProjection;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0003\r\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Issues", "KotlinVisitor", "JavaVisitor", "lint-checks"})
public final class InteroperabilityDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(InteroperabilityDetector.class, Scope.JAVA_FILE_SCOPE);
    private static final boolean IGNORE_DEPRECATED = Intrinsics.areEqual((Object)"true", (Object)System.getenv("ANDROID_LINT_NULLNESS_IGNORE_DEPRECATED")) || Intrinsics.areEqual((Object)"true", (Object)System.getProperty("lint.nullness.ignore-deprecated"));
    @JvmField
    @NotNull
    public static final Issue NO_HARD_KOTLIN_KEYWORDS;
    @JvmField
    @NotNull
    public static final Issue LAMBDA_LAST;
    @NotNull
    private static final BooleanOption CHECK_DEPRECATED;
    @JvmField
    @NotNull
    public static final Issue PLATFORM_NULLNESS;
    @JvmField
    @NotNull
    public static final Issue KOTLIN_PROPERTY;

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        UFile uastFile = context.getUastFile();
        if (uastFile != null && Lint.isKotlin((Language)uastFile.getLang())) {
            boolean checkNullness = context.isEnabled(PLATFORM_NULLNESS);
            if (checkNullness) {
                return new KotlinVisitor(context);
            }
            return null;
        }
        return new JavaVisitor(context);
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UMethod.class, UField.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.INTEROPERABILITY_KOTLIN;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        NO_HARD_KOTLIN_KEYWORDS = Issue.Companion.create$default((Issue.Companion)companion, (String)"NoHardKeywords", (String)"No Hard Kotlin Keywords", (String)"\n            Do not use Kotlin\u2019s hard keywords as the name of methods or fields. \\\n            These require the use of backticks to escape when calling from Kotlin. \\\n            Soft keywords, modifier keywords, and special identifiers are allowed.\n\n            For example, ActionEvent's `getWhen()` method requires backticks when used from Kotlin:\n            ```kotlin\n            val timestamp = event.`when`\n            ```\n            ", (Implementation)implementation, (String)"https://android.github.io/kotlin-guides/interop.html#no-hard-keywords", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3584, null);
        companion = Issue.Companion;
        category = Category.INTEROPERABILITY_KOTLIN;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        LAMBDA_LAST = Issue.Companion.create$default((Issue.Companion)companion, (String)"LambdaLast", (String)"Lambda Parameters Last", (String)"\n            To improve calling this code from Kotlin, \\\n            parameter types eligible for SAM conversion should be last.\n            ", (Implementation)implementation, (String)"https://android.github.io/kotlin-guides/interop.html#lambda-parameters-last", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3584, null);
        CHECK_DEPRECATED = new BooleanOption("ignore-deprecated", "Whether to ignore classes and members that have been annotated with `@Deprecated`", false, "\n                Normally this lint check will flag all unannotated elements, but by \\\n                setting this option to `true` it will skip any deprecated elements.\n                ");
        companion = Issue.Companion;
        category = Category.INTEROPERABILITY_KOTLIN;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        PLATFORM_NULLNESS = Issue.Companion.create$default((Issue.Companion)companion, (String)"UnknownNullness", (String)"Unknown nullness", (String)"\n                To improve referencing this code from Kotlin, consider adding \\\n                explicit nullness information here with either `@NonNull` or `@Nullable`.\n            ", (Implementation)implementation, (String)"https://developer.android.com/kotlin/interop#nullability_annotations", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3584, null).setOptions(CollectionsKt.listOf((Object)CHECK_DEPRECATED));
        companion = Issue.Companion;
        category = Category.INTEROPERABILITY_KOTLIN;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        KOTLIN_PROPERTY = Issue.Companion.create$default((Issue.Companion)companion, (String)"KotlinPropertyAccess", (String)"Kotlin Property Access", (String)"\n            For a method to be represented as a property in Kotlin, strict \u201cbean\u201d-style prefixing must be used.\n\n            Accessor methods require a `get` prefix or for boolean-returning methods an `is` prefix can be used.\n            ", (Implementation)implementation, (String)"https://android.github.io/kotlin-guides/interop.html#property-prefixes", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3584, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0012\u0010\u0017\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0002J\u001e\u0010\u0018\u001a\u00020\u0007*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "IGNORE_DEPRECATED", "", "getIGNORE_DEPRECATED", "()Z", "NO_HARD_KOTLIN_KEYWORDS", "Lcom/android/tools/lint/detector/api/Issue;", "LAMBDA_LAST", "CHECK_DEPRECATED", "Lcom/android/tools/lint/detector/api/BooleanOption;", "PLATFORM_NULLNESS", "KOTLIN_PROPERTY", "isKotlinHardKeyword", "keyword", "", "isNullableAnnotation", "qualifiedName", "isNonNullAnnotation", "isNullnessAnnotation", "hasNullnessAnnotation", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lcom/intellij/psi/PsiModifierListOwner;", "type", "Lcom/intellij/psi/PsiType;", "isApi", "context", "declaration", "Lorg/jetbrains/uast/UDeclaration;", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nInteroperabilityDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteroperabilityDetector.kt\ncom/android/tools/lint/checks/InteroperabilityDetector$Issues\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,955:1\n1761#2,3:956\n12637#3,2:959\n12637#3,2:961\n*S KotlinDebug\n*F\n+ 1 InteroperabilityDetector.kt\ncom/android/tools/lint/checks/InteroperabilityDetector$Issues\n*L\n242#1:956,3\n243#1:959,2\n244#1:961,2\n*E\n"})
    public static final class Issues {
        private Issues() {
        }

        public final boolean getIGNORE_DEPRECATED() {
            return IGNORE_DEPRECATED;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isKotlinHardKeyword(String keyword) {
            String string = keyword;
            switch (string.hashCode()) {
                case 101577: {
                    if (string.equals("for")) return true;
                    return false;
                }
                case 3211: {
                    if (string.equals("do")) return true;
                    return false;
                }
                case 502623545: {
                    if (string.equals("interface")) return true;
                    return false;
                }
                case 113101617: {
                    if (string.equals("while")) return true;
                    return false;
                }
                case 3648314: {
                    if (string.equals("when")) return true;
                    return false;
                }
                case -567202649: {
                    if (string.equals("continue")) return true;
                    return false;
                }
                case 3116345: {
                    if (string.equals("else")) return true;
                    return false;
                }
                case 520977238: {
                    if (string.equals("typealias")) return true;
                    return false;
                }
                case 94742904: {
                    if (string.equals("class")) return true;
                    return false;
                }
                case 3357: {
                    if (string.equals("if")) return true;
                    return false;
                }
                case -858802543: {
                    if (string.equals("typeof")) return true;
                    return false;
                }
                case 116513: {
                    if (string.equals("val")) return true;
                    return false;
                }
                case -807062458: {
                    if (string.equals("package")) return true;
                    return false;
                }
                case 94001407: {
                    if (string.equals("break")) return true;
                    return false;
                }
                case 3365: {
                    if (string.equals("in")) return true;
                    return false;
                }
                case 116519: {
                    if (string.equals("var")) return true;
                    return false;
                }
                case 97196323: {
                    if (string.equals("false")) return true;
                    return false;
                }
                case 3559070: {
                    if (string.equals("this")) return true;
                    return false;
                }
                case 3370: {
                    if (string.equals("is")) return true;
                    return false;
                }
                case 109801339: {
                    if (string.equals("super")) return true;
                    return false;
                }
                case 3122: {
                    if (string.equals("as")) return true;
                    return false;
                }
                case 3392903: {
                    if (string.equals("null")) return true;
                    return false;
                }
                case 110339814: {
                    if (string.equals("throw")) return true;
                    return false;
                }
                case 3569038: {
                    if (string.equals("true")) return true;
                    return false;
                }
                case 115131: {
                    if (string.equals("try")) return true;
                    return false;
                }
                case 101759: {
                    if (string.equals("fun")) return true;
                    return false;
                }
                case -934396624: {
                    if (string.equals("return")) return true;
                    return false;
                }
                case -1023368385: {
                    if (!string.equals("object")) return false;
                    return true;
                }
            }
            return false;
        }

        private final boolean isNullableAnnotation(String qualifiedName) {
            return StringsKt.endsWith$default((String)qualifiedName, (String)"Nullable", (boolean)false, (int)2, null);
        }

        private final boolean isNonNullAnnotation(String qualifiedName) {
            return StringsKt.endsWith$default((String)qualifiedName, (String)"NonNull", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)qualifiedName, (String)"NotNull", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)qualifiedName, (String)"Nonnull", (boolean)false, (int)2, null);
        }

        private final boolean isNullnessAnnotation(String qualifiedName) {
            return qualifiedName != null && (this.isNullableAnnotation(qualifiedName) || this.isNonNullAnnotation(qualifiedName));
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasNullnessAnnotation(JavaContext $this$hasNullnessAnnotation, PsiModifierListOwner node, PsiType type) {
            void var7_12;
            boolean bl;
            Object[] $this$any$iv = (Object[])JavaEvaluator.getAnnotations$default((JavaEvaluator)$this$hasNullnessAnnotation.getEvaluator(), (PsiModifierListOwner)node, (boolean)false, null, (int)4, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object t2 : $this$any$iv) {
                    UAnnotation it = (UAnnotation)t2;
                    boolean bl2 = false;
                    if (!Issues.isNullnessAnnotation(it.getQualifiedName())) continue;
                    return true;
                }
                bl = false;
            }
            if (bl) return true;
            PsiAnnotation[] psiAnnotationArray = node.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
            $this$any$iv = psiAnnotationArray;
            $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiAnnotation it = (PsiAnnotation)element$iv;
                boolean bl3 = false;
                if (!Issues.isNullnessAnnotation(it.getQualifiedName())) continue;
                return true;
            }
            boolean bl4 = false;
            if (bl4) return true;
            PsiAnnotation[] psiAnnotationArray2 = type;
            if (type == null) return false;
            PsiAnnotation[] psiAnnotationArray3 = psiAnnotationArray2.getAnnotations();
            psiAnnotationArray2 = psiAnnotationArray3;
            if (psiAnnotationArray3 == null) return false;
            PsiAnnotation[] $this$any$iv2 = psiAnnotationArray2;
            boolean $i$f$any2 = false;
            boolean bl5 = false;
            int n = $this$any$iv2.length;
            while (var7_12 < n) {
                PsiAnnotation element$iv;
                PsiAnnotation it = element$iv = $this$any$iv2[var7_12];
                boolean bl6 = false;
                if (Issues.isNullnessAnnotation(it.getQualifiedName())) {
                    return true;
                }
                ++var7_12;
            }
            return false;
        }

        private final boolean isApi(JavaContext context, UDeclaration declaration) {
            JavaEvaluator evaluator = context.getEvaluator();
            if (evaluator.isPublic(declaration) || evaluator.isProtected((PsiModifierListOwner)declaration)) {
                UClass uClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)declaration), UClass.class, (boolean)false, (int)2, null);
                if (uClass == null) {
                    return true;
                }
                UClass cls = uClass;
                return evaluator.isPublic((UDeclaration)cls) && !(cls instanceof UAnonymousClass);
            }
            return false;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\"\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u001a\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020%2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010&\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020%H\u0002J\u000e\u0010'\u001a\u0004\u0018\u00010\"*\u00020\u0010H\u0002J\u0010\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\"H\u0002J\u0010\u0010*\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020%H\u0002J\u0010\u0010+\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020%H\u0002J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u00101\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020%H\u0002J \u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020%2\u0006\u00104\u001a\u00020\u0015H\u0002J\u0010\u00105\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0010H\u0002J\u0012\u00106\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$JavaVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "<init>", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "checkForKeywords", "", "checkNullness", "checkLambdaLast", "checkPropertyAccess", "visitMethod", "", "node", "Lorg/jetbrains/uast/UMethod;", "visitField", "Lorg/jetbrains/uast/UField;", "isLikelySetter", "methodName", "", "ensureValidProperty", "setter", "isTypeVariableReference", "type", "Lcom/intellij/psi/PsiType;", "hasSetter", "cls", "Lorg/jetbrains/uast/UClass;", "setterName", "getPropertyLocation", "Lcom/android/tools/lint/detector/api/Location;", "location1", "Lcom/intellij/psi/PsiMethod;", "location2", "ensureNullnessKnown", "Lorg/jetbrains/uast/UDeclaration;", "overridesUnannotatedPlatformMethod", "findRootMethod", "isPlatformMethod", "method", "isEqualsParameter", "isToStringMethod", "getNonNullAnnotation", "getNullableAnnotation", "nonNullAnnotation", "nullableAnnotation", "initializeAnnotationNames", "isInherited", "ensureNonKeyword", "name", "typeLabel", "ensureLambdaLastParameter", "isFunctionalInterface", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nInteroperabilityDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteroperabilityDetector.kt\ncom/android/tools/lint/checks/InteroperabilityDetector$JavaVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,955:1\n1#2:956\n1869#3,2:957\n1563#3:961\n1634#3,3:962\n19652#4,2:959\n11228#4:965\n11563#4,3:966\n*S KotlinDebug\n*F\n+ 1 InteroperabilityDetector.kt\ncom/android/tools/lint/checks/InteroperabilityDetector$JavaVisitor\n*L\n442#1:957,2\n649#1:961\n649#1:962,3\n564#1:959,2\n652#1:965\n652#1:966,3\n*E\n"})
    public static final class JavaVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;
        private final boolean checkForKeywords;
        private final boolean checkNullness;
        private final boolean checkLambdaLast;
        private final boolean checkPropertyAccess;
        @Nullable
        private String nonNullAnnotation;
        @Nullable
        private String nullableAnnotation;

        public JavaVisitor(@NotNull JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.checkForKeywords = this.context.isEnabled(NO_HARD_KOTLIN_KEYWORDS);
            this.checkNullness = this.context.isEnabled(PLATFORM_NULLNESS);
            this.checkLambdaLast = this.context.isEnabled(LAMBDA_LAST);
            this.checkPropertyAccess = this.context.isEnabled(KOTLIN_PROPERTY);
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        public void visitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node)) {
                String methodName = node.getName();
                if (this.checkForKeywords) {
                    this.ensureNonKeyword(methodName, (UDeclaration)node, "method");
                }
                if (this.checkPropertyAccess && this.isLikelySetter(methodName, node)) {
                    this.ensureValidProperty(node, methodName);
                }
                if (this.checkLambdaLast) {
                    this.ensureLambdaLastParameter(node);
                }
                if (this.checkNullness) {
                    PsiType type = node.getReturnType();
                    if (type != null) {
                        this.ensureNullnessKnown((UDeclaration)node, type);
                    }
                    for (UParameter parameter : node.getUastParameters()) {
                        this.ensureNullnessKnown((UDeclaration)parameter, UastLintUtilsKt.getTypeFromPsi((UVariable)((UVariable)parameter)));
                    }
                }
            }
        }

        public void visitField(@NotNull UField node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Issues.isApi(this.context, (UDeclaration)node)) {
                if (this.checkForKeywords) {
                    String string = UastLintUtilsKt.getNameFromSource((UElement)((UElement)node));
                    if (string != null) {
                        String name = string;
                        boolean bl = false;
                        this.ensureNonKeyword(name, (UDeclaration)node, "field");
                    }
                }
                if (this.checkNullness) {
                    this.ensureNullnessKnown((UDeclaration)node, UastLintUtilsKt.getTypeFromPsi((UVariable)((UVariable)node)));
                }
            }
        }

        private final boolean isLikelySetter(String methodName, UMethod node) {
            return StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null) && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && node.getUastParameters().size() == 1 && this.context.getEvaluator().isPublic((UDeclaration)node) && !this.context.getEvaluator().isStatic((PsiModifierListOwner)node);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void ensureValidProperty(UMethod setter, String methodName) {
            Location location;
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)setter));
            if (uClass == null) {
                return;
            }
            UClass cls = uClass;
            String string = methodName.substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String propertySuffix = string;
            String propertyName = StringHelper.usLocaleDecapitalize((String)propertySuffix);
            String getterName1 = "get" + propertySuffix;
            String getterName2 = "is" + propertySuffix;
            String badGetterName = "has" + propertySuffix;
            PsiMethod getter = null;
            UMethod badGetter = null;
            for (UMethod uMethod : cls.getMethods()) {
                if (!uMethod.getUastParameters().isEmpty()) continue;
                String name = uMethod.getName();
                if (Intrinsics.areEqual((Object)name, (Object)getterName1) || Intrinsics.areEqual((Object)name, (Object)getterName2)) {
                    getter = uMethod.getJavaPsi();
                    continue;
                }
                if (!Intrinsics.areEqual((Object)name, (Object)badGetterName) && !Intrinsics.areEqual((Object)name, (Object)propertyName) && !StringsKt.endsWith$default((String)name, (String)propertySuffix, (boolean)false, (int)2, null) || !this.context.getEvaluator().isPublic((UDeclaration)uMethod) || uMethod.isConstructor()) continue;
                UParameter uParameter = (UParameter)CollectionsKt.firstOrNull((List)setter.getUastParameters());
                if (!Intrinsics.areEqual((Object)uMethod.getReturnType(), (Object)(uParameter != null ? UastLintUtilsKt.getTypeFromPsi((UVariable)((UVariable)uParameter)) : null))) continue;
                badGetter = uMethod;
            }
            if (getter == null) {
                Iterable $this$forEach$iv = cls.getUastSuperTypes();
                boolean $i$f$forEach = false;
                block1: for (Object element$iv : $this$forEach$iv) {
                    UTypeReferenceExpression it = (UTypeReferenceExpression)element$iv;
                    boolean bl = false;
                    PsiType psiType = it.getType();
                    PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                    if (psiClassType != null && (psiClassType = psiClassType.resolve()) != null) {
                        PsiClassType superClass = psiClassType;
                        boolean bl2 = false;
                        for (PsiMethod inherited : superClass.findMethodsByName(getterName1, true)) {
                            if (inherited.getParameterList().getParametersCount() != 0) continue;
                            getter = inherited;
                            break;
                        }
                        if (getter != null) continue;
                        for (PsiMethod inherited : superClass.findMethodsByName(getterName2, true)) {
                            if (inherited.getParameterList().getParametersCount() != 0) continue;
                            getter = inherited;
                            continue block1;
                        }
                    }
                }
            }
            if (getter != null && !(getter instanceof PsiCompiledElement)) {
                PsiMethod getter2 = getter;
                if (!this.context.getEvaluator().isPublic((PsiModifierListOwner)getter2)) {
                    String message2 = "This getter should be public such that `" + propertyName + "` can be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    Location location2 = this.context.getNameLocation((PsiElement)getter2);
                    JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)((PsiElement)getter2), (Location)location2, (String)message2, null, (int)16, null);
                    return;
                }
                if (this.context.getEvaluator().isStatic((PsiModifierListOwner)getter2)) {
                    PsiElement staticElement = null;
                    PsiModifierList psiModifierList = getter2.getModifierList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"getModifierList(...)");
                    PsiModifierList modifierList = psiModifierList;
                    if (modifierList.hasExplicitModifier("static")) {
                        for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
                            if (!(child instanceof PsiKeyword) || !Intrinsics.areEqual((Object)"static", (Object)((PsiKeyword)child).getText())) continue;
                            staticElement = child;
                            break;
                        }
                    }
                    location = staticElement != null ? this.context.getLocation(staticElement) : this.context.getNameLocation((PsiElement)getter2);
                    String message3 = "This getter should not be static such that `" + propertyName + "` can be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    Object object = location.getSource();
                    PsiElement psiElement = object instanceof PsiElement ? (PsiElement)object : null;
                    if (psiElement == null) {
                        psiElement = (PsiElement)setter;
                    }
                    JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)psiElement, (Location)location, (String)message3, null, (int)16, null);
                    return;
                }
                PsiType setterParameterType = UastLintUtilsKt.getTypeFromPsi((UVariable)((UVariable)CollectionsKt.first((List)setter.getUastParameters())));
                if (!(Intrinsics.areEqual((Object)setterParameterType, (Object)getter2.getReturnType()) || this.hasSetter(cls, getter2.getReturnType(), setter.getName()) || this.isTypeVariableReference(setterParameterType))) {
                    PsiType psiType = getter2.getReturnType();
                    PsiType psiType2 = setterParameterType;
                    String message4 = "The getter return type (`" + (psiType != null ? psiType.getPresentableText() : null) + "`) and setter parameter type (`" + (psiType2 != null ? psiType2.getPresentableText() : null) + "`) getter and setter methods for property `" + propertyName + "` should have exactly the same type to allow be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                    location = this.getPropertyLocation(getter2, setter.getJavaPsi());
                    Object bl = location.getSource();
                    PsiElement psiElement = bl instanceof PsiElement ? (PsiElement)bl : null;
                    if (psiElement == null) {
                        psiElement = (PsiElement)setter;
                    }
                    JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)psiElement, (Location)location, (String)message4, null, (int)16, null);
                    return;
                }
                PsiMethod[] message4 = getter2.findSuperMethods();
                int location3 = 0;
                int message3 = message4.length;
                while (location3 < message3) {
                    PsiMethod superMethod = message4[location3];
                    PsiClass psiClass = superMethod.getContainingClass();
                    if (!(psiClass != null ? psiClass.isInterface() : false)) {
                        PsiType psiType;
                        if (superMethod.getReturnType() == null) {
                            return;
                        }
                        PsiType getterType = getter2.getReturnType();
                        if (!Intrinsics.areEqual((Object)psiType, (Object)getterType)) {
                            PsiType psiType3 = getterType;
                            String message5 = "The getter return type (`" + (psiType3 != null ? psiType3.getPresentableText() : null) + "`) is not the same as the super return type (`" + psiType.getPresentableText() + "`); they should have exactly the same type to allow `" + StringHelper.usLocaleDecapitalize((String)propertySuffix) + "` be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                            Intrinsics.checkNotNull((Object)superMethod);
                            Location location4 = this.getPropertyLocation(getter2, superMethod);
                            Location location5 = location4.getSecondary();
                            if (location5 != null) {
                                location5.setMessage("Super method here");
                            }
                            Object object = location4.getSource();
                            PsiElement psiElement = object instanceof PsiElement ? (PsiElement)object : null;
                            if (psiElement == null) {
                                psiElement = (PsiElement)setter;
                            }
                            JavaContext.report$default((JavaContext)this.context, (Issue)KOTLIN_PROPERTY, (PsiElement)psiElement, (Location)location4, (String)message5, null, (int)16, null);
                            return;
                        }
                    }
                    ++location3;
                }
                return;
            }
            if (badGetter == null) return;
            PsiMethod[] psiMethodArray = badGetter.getJavaPsi().findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
            if (ArraysKt.any((Object[])psiMethodArray)) return;
            JavaVisitor $this$ensureValidProperty_u24lambda_u244 = this;
            char c2 = '\u0000';
            Object matchingName = "set" + StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)badGetter.getName(), (CharSequence)"is"), (CharSequence)"get"), (CharSequence)"has");
            if (!Intrinsics.areEqual((Object)methodName, (Object)matchingName)) {
                void var17_37;
                UMethod[] $this$none$iv = cls.getMethods();
                boolean $i$f$none = false;
                boolean bl = false;
                int n = $this$none$iv.length;
                while (var17_37 < n) {
                    UMethod element$iv;
                    UMethod it = element$iv = $this$none$iv[var17_37];
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)matchingName)) {
                        return;
                    }
                    ++var17_37;
                }
                boolean bl4 = true;
                if (!bl4) return;
            }
            boolean bl = true;
            if (!bl) return;
            String name1 = badGetter.getName();
            if (StringsKt.startsWith$default((String)name1, (String)"is", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)methodName, (String)"setIs", (boolean)false, (int)2, null) && Character.isUpperCase(name1.charAt(2))) {
                c2 = Character.toLowerCase(name1.charAt(2));
                String string2 = name1.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                matchingName = string2;
                String newProperty = c2 + (String)matchingName;
                String message6 = "This method should be called `set" + StringHelper.usLocaleCapitalize((String)newProperty) + "` such that (along with the `" + name1 + "` getter) Kotlin code can access it as a property (`" + newProperty + "`); see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
                location = this.context.getNameLocation(setter);
                this.context.report(KOTLIN_PROPERTY, setter, location, message6);
                return;
            }
            Location location6 = this.context.getNameLocation(badGetter);
            String message7 = "This method should be called `get" + propertySuffix + "` such that `" + propertyName + "` can be accessed as a property from Kotlin; see https://android.github.io/kotlin-guides/interop.html#property-prefixes";
            this.context.report(KOTLIN_PROPERTY, badGetter, location6, message7);
        }

        private final boolean isTypeVariableReference(PsiType type) {
            if (type instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)type).resolve();
                if (psiClass == null) {
                    return false;
                }
                PsiClass cls = psiClass;
                return cls instanceof PsiTypeParameter;
            }
            return false;
        }

        private final boolean hasSetter(UClass cls, PsiType type, String setterName) {
            for (PsiMethod method : cls.getJavaPsi().findMethodsByName(setterName, true)) {
                PsiParameter[] parameters;
                PsiParameterList parameterList;
                Intrinsics.checkNotNullExpressionValue((Object)method.getParameterList(), (String)"getParameterList(...)");
                Intrinsics.checkNotNullExpressionValue((Object)parameterList.getParameters(), (String)"getParameters(...)");
                if (parameters.length != 1 || !Intrinsics.areEqual((Object)parameters[0].getType(), (Object)type)) continue;
                return true;
            }
            return false;
        }

        private final Location getPropertyLocation(PsiMethod location1, PsiMethod location2) {
            PsiMethod primary = null;
            PsiMethod secondary = null;
            if (location1 instanceof PsiCompiledElement) {
                primary = location2;
                secondary = location1;
            } else {
                primary = location1;
                secondary = location2;
            }
            Location location = this.context.getNameLocation((PsiElement)primary);
            Location location3 = this.context.getNameLocation((PsiElement)secondary);
            String string = secondary.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return Location.withSecondary$default((Location)location, (Location)location3, (String)((StringsKt.startsWith$default((String)string, (String)"set", (boolean)false, (int)2, null) ? "Setter" : "Getter") + " here"), (boolean)false, (int)4, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void ensureNullnessKnown(UDeclaration node, PsiType type) {
            Location location;
            Location location2;
            block30: {
                block32: {
                    block33: {
                        block31: {
                            block29: {
                                Location location3;
                                UClass it;
                                Iterable iterable;
                                Collection collection;
                                PsiAnnotation[] $this$mapTo$iv$iv;
                                if (type instanceof PsiPrimitiveType) {
                                    return;
                                }
                                if (type instanceof PsiClassType && ((PsiClassType)type).resolve() instanceof PsiTypeParameter) {
                                    return;
                                }
                                if (node instanceof UField) {
                                    PsiElement psiElement = node.getJavaPsi();
                                    PsiField psiField = psiElement instanceof PsiField ? (PsiField)psiElement : null;
                                    boolean bl = psiField != null && (psiField = psiField.getModifierList()) != null ? psiField.hasModifierProperty("final") : false;
                                    if (bl) {
                                        return;
                                    }
                                }
                                JavaEvaluator javaEvaluator = this.context.getEvaluator();
                                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.jetbrains.uast.UAnnotated");
                                Iterable $this$map$iv = javaEvaluator.getAllAnnotations((UAnnotated)node, false);
                                boolean $i$f$map32 = false;
                                Iterable iterable2 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo22 = false;
                                for (Object t2 : $this$mapTo$iv$iv) {
                                    void it2;
                                    UAnnotation uAnnotation = (UAnnotation)t2;
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(new Pair((Object)it2.getQualifiedName(), (Object)new Function0<Location>(this, (UAnnotation)it2){
                                        final /* synthetic */ JavaVisitor this$0;
                                        final /* synthetic */ UAnnotation $it;
                                        {
                                            this.this$0 = $receiver;
                                            this.$it = $it;
                                            super(0);
                                        }

                                        public final Location invoke() {
                                            return this.this$0.getContext().getLocation((UElement)this.$it);
                                        }
                                    }));
                                }
                                Collection collection2 = (List)destination$iv$iv;
                                PsiAnnotation[] psiAnnotationArray = type;
                                if (type != null && (psiAnnotationArray = psiAnnotationArray.getAnnotations()) != null) {
                                    void $this$mapTo$iv$iv2;
                                    void $this$map$iv2;
                                    $this$mapTo$iv$iv = psiAnnotationArray;
                                    collection = collection2;
                                    boolean $i$f$map2 = false;
                                    void $i$f$mapTo22 = $this$map$iv2;
                                    Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv2).length);
                                    boolean bl = false;
                                    int n = ((void)$this$mapTo$iv$iv2).length;
                                    for (int it2 = 0; it2 < n; ++it2) {
                                        void it3;
                                        void item$iv$iv;
                                        void var14_31 = item$iv$iv = $this$mapTo$iv$iv2[it2];
                                        Collection collection3 = destination$iv$iv2;
                                        boolean bl2 = false;
                                        collection3.add(new Pair((Object)it3.getQualifiedName(), (Object)new Function0<Location>(this, (PsiAnnotation)it3){
                                            final /* synthetic */ JavaVisitor this$0;
                                            final /* synthetic */ PsiAnnotation $it;
                                            {
                                                this.this$0 = $receiver;
                                                this.$it = $it;
                                                super(0);
                                            }

                                            public final Location invoke() {
                                                JavaContext javaContext = this.this$0.getContext();
                                                PsiAnnotation psiAnnotation = this.$it;
                                                Intrinsics.checkNotNull((Object)psiAnnotation);
                                                return javaContext.getLocation((PsiElement)psiAnnotation);
                                            }
                                        }));
                                    }
                                    collection2 = collection;
                                    iterable = (List)destination$iv$iv2;
                                } else {
                                    iterable = CollectionsKt.emptyList();
                                }
                                List allAnnotations2 = CollectionsKt.plus((Collection)collection2, (Iterable)iterable);
                                for (Pair $i$f$map32 : allAnnotations2) {
                                    String name = (String)$i$f$map32.component1();
                                    Function0 location4 = (Function0)$i$f$map32.component2();
                                    if (name == null) continue;
                                    if (Issues.isNullableAnnotation(name)) {
                                        if (this.isToStringMethod(node)) {
                                            String message2 = "Unexpected `@Nullable`: `toString` should never return null";
                                            JavaContext.report$default((JavaContext)this.context, (Issue)PLATFORM_NULLNESS, (UElement)((UElement)node), (Location)((Location)location4.invoke()), (String)message2, null, (int)16, null);
                                        }
                                        return;
                                    }
                                    if (!Issues.isNonNullAnnotation(name)) continue;
                                    if (this.isEqualsParameter(node)) {
                                        String message3 = "Unexpected @NonNull: The `equals` contract allows the parameter to be null";
                                        JavaContext.report$default((JavaContext)this.context, (Issue)PLATFORM_NULLNESS, (UElement)((UElement)node), (Location)((Location)location4.invoke()), (String)message3, null, (int)16, null);
                                    }
                                    return;
                                }
                                if (this.isEqualsParameter(node) || this.isToStringMethod(node)) {
                                    return;
                                }
                                if (node instanceof UMethod) {
                                    UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                                    if (uClass != null) {
                                        it = uClass;
                                        boolean bl2 = false;
                                        if (it.isAnnotationType()) {
                                            return;
                                        }
                                    }
                                }
                                if (Issues.getIGNORE_DEPRECATED() || CHECK_DEPRECATED.getValue(this.context.getConfiguration()).booleanValue()) {
                                    UElement deprecatedNode;
                                    UElement uElement = deprecatedNode = node instanceof UParameter ? node.getUastParent() : (UElement)node;
                                    it = uElement != null ? uElement.getSourcePsi() : null;
                                    PsiDocCommentOwner psiDocCommentOwner = it instanceof PsiDocCommentOwner ? (PsiDocCommentOwner)it : null;
                                    boolean bl = psiDocCommentOwner != null ? psiDocCommentOwner.isDeprecated() : false;
                                    if (bl) {
                                        return;
                                    }
                                    UElement curr = deprecatedNode;
                                    while (curr != null) {
                                        UClass uClass = UastUtils.getContainingUClass((UElement)curr);
                                        if (uClass == null) {
                                            break;
                                        }
                                        curr = (UElement)uClass;
                                        PsiElement bl2 = ((UClass)curr).getSourcePsi();
                                        PsiDocCommentOwner psiDocCommentOwner2 = bl2 instanceof PsiDocCommentOwner ? (PsiDocCommentOwner)bl2 : null;
                                        boolean bl3 = psiDocCommentOwner2 != null ? psiDocCommentOwner2.isDeprecated() : false;
                                        if (!bl3) continue;
                                        return;
                                    }
                                }
                                if (this.overridesUnannotatedPlatformMethod(node)) {
                                    return;
                                }
                                UDeclaration curr = node;
                                if (curr instanceof UVariable) {
                                    UTypeReferenceExpression uTypeReferenceExpression = ((UVariable)node).getTypeReference();
                                    if (uTypeReferenceExpression == null) {
                                        return;
                                    }
                                    location3 = this.context.getLocation((UElement)uTypeReferenceExpression);
                                } else if (curr instanceof UMethod) {
                                    PsiTypeElement psiTypeElement = ((UMethod)node).getReturnTypeElement();
                                    if (psiTypeElement == null) {
                                        return;
                                    }
                                    location3 = this.context.getLocation((PsiElement)psiTypeElement);
                                } else {
                                    return;
                                }
                                location2 = location3;
                                if (!(node instanceof UParameter)) break block29;
                                location = location2;
                                break block30;
                            }
                            if (!(node instanceof UMethod)) break block31;
                            PsiModifierList psiModifierList = ((UMethod)node).getJavaPsi().getModifierList();
                            Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"getModifierList(...)");
                            location = this.context.getLocation((PsiElement)psiModifierList);
                            break block30;
                        }
                        if (!(node instanceof UField)) break block32;
                        PsiElement bl2 = node.getJavaPsi();
                        location = bl2 instanceof PsiField ? (PsiField)bl2 : null;
                        if (location == null || (location = location.getModifierList()) == null) break block33;
                        Location location4 = location;
                        boolean bl = false;
                        Location location5 = this.context.getLocation((PsiElement)location4);
                        location = location5;
                        if (location5 != null) break block30;
                    }
                    return;
                }
                return;
            }
            Location replaceLocation = location;
            String message4 = "Unknown nullability; explicitly declare as `@Nullable` or `@NonNull` to improve Kotlin interoperability; see https://developer.android.com/kotlin/interop#nullability_annotations";
            LintFix[] lintFixArray = new LintFix[]{LintFix.Companion.create().replace().name("Annotate @NonNull").range(replaceLocation).beginning().shortenNames().reformat(true).with(this.getNonNullAnnotation(this.context) + " ").build(), LintFix.Companion.create().replace().name("Annotate @Nullable").range(replaceLocation).beginning().shortenNames().reformat(true).with(this.getNullableAnnotation(this.context) + " ").build()};
            LintFix fix2 = LintFix.Companion.create().alternatives(lintFixArray);
            this.context.report(PLATFORM_NULLNESS, (UElement)node, location2, message4, fix2);
        }

        private final boolean overridesUnannotatedPlatformMethod(UDeclaration node) {
            if (node instanceof UParameter) {
                UMethod method = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
                if (method != null && !method.isConstructor()) {
                    PsiMethod psiMethod = this.findRootMethod(method);
                    if (psiMethod == null) {
                        return false;
                    }
                    PsiMethod superMethod = psiMethod;
                    PsiParameter[] psiParameterArray = superMethod.getParameterList().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
                    PsiParameter[] superParameters = psiParameterArray;
                    int parameterIndex = method.getUastParameters().indexOf(node);
                    if (parameterIndex >= 0 && parameterIndex < superParameters.length) {
                        PsiParameter superParameter = superParameters[parameterIndex];
                        if (this.isPlatformMethod(superMethod)) {
                            Intrinsics.checkNotNull((Object)superParameter);
                            if (!Issues.hasNullnessAnnotation(this.context, (PsiModifierListOwner)superParameter, superParameter.getType())) {
                                return true;
                            }
                        }
                    }
                    return false;
                }
            } else if (node instanceof UMethod && !((UMethod)node).isConstructor()) {
                PsiMethod psiMethod = this.findRootMethod((UMethod)node);
                if (psiMethod == null) {
                    return false;
                }
                PsiMethod superMethod = psiMethod;
                if (this.isPlatformMethod(superMethod) && !Issues.hasNullnessAnnotation(this.context, (PsiModifierListOwner)superMethod, superMethod.getReturnType())) {
                    return true;
                }
            }
            return false;
        }

        private final PsiMethod findRootMethod(UMethod $this$findRootMethod) {
            PsiMethod[] psiMethodArray = $this$findRootMethod.getJavaPsi().findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
            PsiMethod psiMethod = (PsiMethod)ArraysKt.firstOrNull((Object[])psiMethodArray);
            if (psiMethod == null) {
                return null;
            }
            PsiMethod superMethod = psiMethod;
            while (true) {
                PsiMethod[] psiMethodArray2 = superMethod.findSuperMethods();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray2, (String)"findSuperMethods(...)");
                if ((PsiMethod)ArraysKt.firstOrNull((Object[])psiMethodArray2) != null) continue;
                return superMethod;
            }
        }

        private final boolean isPlatformMethod(PsiMethod method) {
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            PsiClass containingClass = psiClass;
            String string = containingClass.getQualifiedName();
            if (string == null) {
                return false;
            }
            String name = string;
            return StringsKt.startsWith$default((String)name, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"java.", (boolean)false, (int)2, null);
        }

        private final boolean isEqualsParameter(UDeclaration node) {
            if (node instanceof UParameter) {
                UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)node));
                if (uMethod == null) {
                    return false;
                }
                UMethod method = uMethod;
                if (Intrinsics.areEqual((Object)method.getName(), (Object)"equals") && method.getUastParameters().size() == 1) {
                    return true;
                }
            }
            return false;
        }

        private final boolean isToStringMethod(UDeclaration node) {
            UDeclaration method;
            return node instanceof UMethod && Intrinsics.areEqual((Object)((UMethod)(method = node)).getName(), (Object)"toString") && ((UMethod)method).getUastParameters().isEmpty();
        }

        private final String getNonNullAnnotation(JavaContext context) {
            this.initializeAnnotationNames(context);
            String string = this.nonNullAnnotation;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        private final String getNullableAnnotation(JavaContext context) {
            this.initializeAnnotationNames(context);
            String string = this.nullableAnnotation;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        private final void initializeAnnotationNames(JavaContext context) {
            if (this.nonNullAnnotation == null) {
                if (context.getEvaluator().findClass("android.support.annotation.NonNull") != null) {
                    this.nonNullAnnotation = "@android.support.annotation.NonNull";
                    this.nullableAnnotation = "@android.support.annotation.Nullable";
                } else {
                    this.nonNullAnnotation = "@androidx.annotation.NonNull";
                    this.nullableAnnotation = "@androidx.annotation.Nullable";
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isInherited(UDeclaration node) {
            if (!(node instanceof UMethod)) return false;
            PsiMethod[] psiMethodArray = ((UMethod)node).getJavaPsi().findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
            if (((Object[])psiMethodArray).length != 0) return true;
            return false;
        }

        private final void ensureNonKeyword(String name, UDeclaration node, String typeLabel) {
            if (Issues.isKotlinHardKeyword(name) && !this.isInherited(node)) {
                if (node instanceof UMethod && JavaEvaluator.isOverride$default((JavaEvaluator)this.context.getEvaluator(), (UMethod)((UMethod)node), (boolean)false, (int)2, null)) {
                    return;
                }
                String message2 = "Avoid " + typeLabel + " names that are Kotlin hard keywords (\"" + name + "\"); see https://android.github.io/kotlin-guides/interop.html#no-hard-keywords";
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.jetbrains.uast.UElement");
                JavaContext.report$default((JavaContext)this.context, (Issue)NO_HARD_KOTLIN_KEYWORDS, (UElement)((UElement)node), (Location)this.context.getNameLocation((UElement)node), (String)message2, null, (int)16, null);
            }
        }

        private final void ensureLambdaLastParameter(UMethod method) {
            int lastIndex;
            List parameters = method.getUastParameters();
            if (parameters.size() > 1 && !this.isFunctionalInterface(UastLintUtilsKt.getTypeFromPsi((UVariable)((UVariable)parameters.get(lastIndex = parameters.size() - 1))))) {
                for (int i = lastIndex - 1; -1 < i; --i) {
                    UParameter parameter = (UParameter)parameters.get(i);
                    if (!this.isFunctionalInterface(UastLintUtilsKt.getTypeFromPsi((UVariable)((UVariable)parameter)))) continue;
                    PsiType psiType = UastLintUtilsKt.getTypeFromPsi((UVariable)((UVariable)parameter));
                    if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)"java.util.concurrent.Executor")) continue;
                    if (this.isInherited((UDeclaration)method)) {
                        return;
                    }
                    PsiClass psiClass = method.getJavaPsi().getContainingClass();
                    String message2 = "Functional interface parameters (such as parameter " + (i + 1) + ", \"" + UastLintUtilsKt.getNameFromSource((UElement)((UElement)parameter)) + "\", in " + (psiClass != null ? psiClass.getQualifiedName() : null) + "." + method.getName() + ") should be last to improve Kotlin interoperability; see https://kotlinlang.org/docs/reference/java-interop.html#sam-conversions";
                    Object e = parameters.get(lastIndex);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.uast.UElement");
                    UElement last = (UElement)e;
                    JavaContext.report$default((JavaContext)this.context, (Issue)LAMBDA_LAST, (UElement)last, (Location)this.context.getLocation(last), (String)message2, null, (int)16, null);
                    break;
                }
            }
        }

        private final boolean isFunctionalInterface(PsiType type) {
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClass psiClass = ((PsiClassType)type).resolve();
            if (psiClass == null) {
                return false;
            }
            PsiClass cls = psiClass;
            if (!cls.isInterface()) {
                return false;
            }
            int abstractCount = 0;
            for (PsiMethod method : cls.getMethods()) {
                if (!method.getModifierList().hasModifierProperty("abstract")) continue;
                ++abstractCount;
            }
            if (abstractCount != 1) {
                if (abstractCount > 1) {
                    abstractCount = 0;
                    for (PsiMethod method : cls.getMethods()) {
                        if (!method.getModifierList().hasModifierProperty("abstract")) continue;
                        JavaEvaluator javaEvaluator = this.context.getEvaluator();
                        Intrinsics.checkNotNull((Object)method);
                        if (javaEvaluator.isOverride(method, true)) continue;
                        ++abstractCount;
                    }
                }
                if (abstractCount != 1) {
                    return false;
                }
            }
            PsiClass psiClass2 = cls.getSuperClass();
            return !(psiClass2 != null ? psiClass2.isInterface() : false);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/InteroperabilityDetector$KotlinVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "<init>", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "visitMethod", "", "node", "Lorg/jetbrains/uast/UMethod;", "isFlexibleRecursive", "", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "visitField", "Lorg/jetbrains/uast/UField;", "reportMissingExplicitType", "Lorg/jetbrains/uast/UElement;", "typeString", "", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nInteroperabilityDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteroperabilityDetector.kt\ncom/android/tools/lint/checks/InteroperabilityDetector$KotlinVisitor\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,955:1\n30#2,2:956\n35#3,15:958\n1761#4,3:973\n*S KotlinDebug\n*F\n+ 1 InteroperabilityDetector.kt\ncom/android/tools/lint/checks/InteroperabilityDetector$KotlinVisitor\n*L\n316#1:956,2\n316#1:958,15\n345#1:973,3\n*E\n"})
    public static final class KotlinVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public KotlinVisitor(@NotNull JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void visitMethod(@NotNull UMethod node) {
            KaType ktType;
            KaSession $this$visitMethod_u24lambda_u240;
            KaSession analysisSession$iv$iv;
            void this_$iv$iv;
            KtElement useSiteElement$iv$iv;
            block32: {
                block31: {
                    block30: {
                        Object lock$iv$iv;
                        KtExpression ktExpression;
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (!Issues.isApi(this.context, (UDeclaration)node)) return;
                        if (node.getReturnTypeReference() != null) return;
                        PsiType psiType = node.getReturnType();
                        if (psiType == null) {
                            return;
                        }
                        PsiType uastType = psiType;
                        if (uastType instanceof PsiPrimitiveType) {
                            return;
                        }
                        if (Issues.hasNullnessAnnotation(this.context, (PsiModifierListOwner)node.getJavaPsi(), uastType)) {
                            return;
                        }
                        if (this.context.getEvaluator().isSuspend((PsiModifierListOwner)node.getJavaPsi())) {
                            return;
                        }
                        PsiElement psiElement = node.getSourcePsi();
                        if (!(psiElement instanceof KtCallableDeclaration)) return;
                        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement;
                        if (ktCallableDeclaration == null) {
                            return;
                        }
                        KtCallableDeclaration declaration = ktCallableDeclaration;
                        KtCallableDeclaration ktCallableDeclaration2 = declaration;
                        if (ktCallableDeclaration2 instanceof KtFunction) {
                            if (((KtFunction)declaration).isLocal()) return;
                            if (((KtFunction)declaration).hasDeclaredReturnType()) {
                                return;
                            }
                        } else {
                            if (!(ktCallableDeclaration2 instanceof KtProperty)) return;
                            if (((KtProperty)declaration).isLocal()) return;
                            if (((KtProperty)declaration).getTypeReference() != null) {
                                return;
                            }
                        }
                        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
                        if (ktClassOrObject != null) {
                            if (ktClassOrObject.isLocal()) {
                                return;
                            }
                            bl = false;
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            return;
                        }
                        psiElement = declaration;
                        if (psiElement instanceof KtProperty) {
                            ktExpression = ((KtProperty)declaration).getInitializer();
                            if (ktExpression == null && (ktExpression = ((KtProperty)declaration).getDelegateExpression()) == null) {
                                return;
                            }
                        } else {
                            if (!(psiElement instanceof KtFunction)) return;
                            ktExpression = ((KtFunction)declaration).getBodyExpression();
                            if (ktExpression == null) {
                                KtBlockExpression ktBlockExpression = ((KtFunction)declaration).getBodyBlockExpression();
                                if (ktBlockExpression == null) return;
                                ktExpression = (KtExpression)ktBlockExpression;
                            }
                        }
                        KtExpression expression = ktExpression;
                        KtElement useSiteElement$iv = (KtElement)expression;
                        boolean $i$f$analyze = false;
                        Project project = useSiteElement$iv.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                        useSiteElement$iv$iv = useSiteElement$iv;
                        boolean $i$f$analyze2 = false;
                        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                        Object object = lock$iv$iv = new Object();
                        // MONITORENTER : object
                        boolean bl2 = false;
                        $this$visitMethod_u24lambda_u240 = analysisSession$iv$iv;
                        boolean bl3 = false;
                        if ($this$visitMethod_u24lambda_u240.getExpressionType(expression) != null) break block30;
                        // MONITOREXIT : object
                        this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                        return;
                    }
                    try {
                        KaType kaType;
                        ktType = kaType;
                        if (!(ktType instanceof KaDynamicType)) break block31;
                        // MONITOREXIT : object
                    }
                    catch (Throwable throwable$iv$iv) {
                        this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                        throw new KotlinNothingValueException();
                    }
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                    return;
                }
                if (this.isFlexibleRecursive(ktType)) break block32;
                // MONITOREXIT : object
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                return;
            }
            try {
                String string;
                if (ktType instanceof KaFlexibleType) {
                    string = null;
                } else {
                    KaTypeRenderer renderer2 = KaTypeRendererForSource.INSTANCE.getWITH_SHORT_NAMES().with((Function1)visitMethod.1.typeString.renderer.1.INSTANCE);
                    string = $this$visitMethod_u24lambda_u240.render(ktType, renderer2, Variance.INVARIANT);
                }
                String typeString2 = string;
                this.reportMissingExplicitType((UElement)node, typeString2);
                Unit unit = Unit.INSTANCE;
                // MONITOREXIT : object
                Unit unit2 = unit;
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isFlexibleRecursive(KaType $this$isFlexibleRecursive) {
            boolean bl;
            if ($this$isFlexibleRecursive instanceof KaFlexibleType) {
                return true;
            }
            if (!($this$isFlexibleRecursive instanceof KaClassType)) return false;
            KaClassType kaClassType = (KaClassType)$this$isFlexibleRecursive;
            Object object = kaClassType;
            if (kaClassType == null) return false;
            if ((object = object.getTypeArguments()) == null) {
                return false;
            }
            Object object2 = object;
            Iterable $this$any$iv = (Iterable)object2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                KaTypeProjection it = (KaTypeProjection)element$iv;
                boolean bl2 = false;
                if (!(it instanceof KaStarTypeProjection)) {
                    boolean bl3;
                    KaType kaType = it.getType();
                    if (kaType != null) {
                        if (this.isFlexibleRecursive(kaType)) {
                            return true;
                        }
                        bl3 = false;
                    } else {
                        bl3 = false;
                    }
                    if (bl3) {
                        return true;
                    }
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public void visitField(@NotNull UField node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        }

        private final void reportMissingExplicitType(UElement node, String typeString2) {
            String string = typeString2;
            JavaContext.report$default((JavaContext)this.context, (Issue)PLATFORM_NULLNESS, (UElement)node, (Location)this.context.getNameLocation(node), (String)("Should explicitly declare type here since implicit type does not specify nullness" + (String)(string != null ? " (" + string + ")" : "")), null, (int)16, null);
        }

        static /* synthetic */ void reportMissingExplicitType$default(KotlinVisitor kotlinVisitor, UElement uElement, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            kotlinVisitor.reportMissingExplicitType(uElement, string);
        }
    }
}

