/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.plurals.CLDR36Database;
import com.android.tools.lint.checks.plurals.CLDR38Database;
import com.android.tools.lint.checks.plurals.CLDR41Database;
import com.android.tools.lint.checks.plurals.CLDR42Database;
import com.android.tools.lint.detector.api.Lint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b&\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0011J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0011J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0004H$J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0004H$J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0004H$J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0004H\u0004R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/PluralsDatabase;", "", "languageCodes", "", "", "languageFlags", "", "apiLevel", "", "<init>", "([Ljava/lang/String;[II)V", "[Ljava/lang/String;", "getApiLevel$lint_checks", "()I", "plurals", "", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/checks/PluralsDatabase$Quantity;", "getRelevant", "language", "hasMultipleValuesForQuantity", "", "quantity", "findIntegerExamples", "getExampleForQuantityZero", "getExampleForQuantityOne", "getExampleForQuantityTwo", "getFlags", "getLanguageIndex", "Companion", "Quantity", "lint-checks"})
public abstract class PluralsDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] languageCodes;
    @NotNull
    private final int[] languageFlags;
    private final int apiLevel;
    @NotNull
    private final Map<String, EnumSet<Quantity>> plurals;
    private static final EnumSet<Quantity> EMPTY_SET = EnumSet.noneOf(Quantity.class);
    public static final int FLAG_ZERO = 1;
    public static final int FLAG_ONE = 2;
    public static final int FLAG_TWO = 4;
    public static final int FLAG_FEW = 8;
    public static final int FLAG_MANY = 16;
    public static final int FLAG_MULTIPLE_ZERO = 32;
    public static final int FLAG_MULTIPLE_ONE = 64;
    public static final int FLAG_MULTIPLE_TWO = 128;
    @NotNull
    private static final Map<Integer, PluralsDatabase> datasets;

    public PluralsDatabase(@NotNull String[] languageCodes, @NotNull int[] languageFlags, int apiLevel) {
        Intrinsics.checkNotNullParameter((Object)languageCodes, (String)"languageCodes");
        Intrinsics.checkNotNullParameter((Object)languageFlags, (String)"languageFlags");
        this.languageCodes = languageCodes;
        this.languageFlags = languageFlags;
        this.apiLevel = apiLevel;
        this.plurals = new LinkedHashMap();
        if (!(this.languageCodes.length == this.languageFlags.length)) {
            boolean bl = false;
            String string = "Language code list and flag list have different lengths";
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getApiLevel$lint_checks() {
        return this.apiLevel;
    }

    @Nullable
    public final EnumSet<Quantity> getRelevant(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        EnumSet<Quantity> set = this.plurals.get(language);
        if (set == null) {
            int index2 = this.getLanguageIndex(language);
            if (index2 == -1) {
                this.plurals.put(language, EMPTY_SET);
                return null;
            }
            int flag = this.languageFlags[index2];
            set = EnumSet.noneOf(Quantity.class);
            if ((flag & 1) != 0) {
                set.add(Quantity.zero);
            }
            if ((flag & 2) != 0) {
                set.add(Quantity.one);
            }
            if ((flag & 4) != 0) {
                set.add(Quantity.two);
            }
            if ((flag & 8) != 0) {
                set.add(Quantity.few);
            }
            if ((flag & 0x10) != 0) {
                set.add(Quantity.many);
            }
            this.plurals.put(language, set);
        }
        return set == EMPTY_SET ? null : set;
    }

    public final boolean hasMultipleValuesForQuantity(@NotNull String language, @NotNull Quantity quantity) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)((Object)quantity), (String)"quantity");
        switch (WhenMappings.$EnumSwitchMapping$0[quantity.ordinal()]) {
            case 1: {
                if ((this.getFlags(language) & 0x40) != 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if ((this.getFlags(language) & 0x80) != 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = quantity == Quantity.zero && (this.getFlags(language) & 0x20) != 0;
            }
        }
        return bl;
    }

    @Nullable
    public final String findIntegerExamples(@NotNull String language, @NotNull Quantity quantity) {
        String string;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)((Object)quantity), (String)"quantity");
        switch (WhenMappings.$EnumSwitchMapping$0[quantity.ordinal()]) {
            case 1: {
                string = this.getExampleForQuantityOne(language);
                break;
            }
            case 2: {
                string = this.getExampleForQuantityTwo(language);
                break;
            }
            case 3: {
                string = this.getExampleForQuantityZero(language);
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @Nullable
    protected abstract String getExampleForQuantityZero(@NotNull String var1);

    @Nullable
    protected abstract String getExampleForQuantityOne(@NotNull String var1);

    @Nullable
    protected abstract String getExampleForQuantityTwo(@NotNull String var1);

    private final int getFlags(String language) {
        int index2 = this.getLanguageIndex(language);
        return index2 != -1 ? this.languageFlags[index2] : 0;
    }

    protected final int getLanguageIndex(@NotNull String language) {
        int n;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        int index2 = Arrays.binarySearch(this.languageCodes, language);
        if (index2 >= 0) {
            if (!Intrinsics.areEqual((Object)this.languageCodes[index2], (Object)language)) {
                throw new IllegalStateException("Check failed.");
            }
            n = index2;
        } else {
            n = -1;
        }
        return n;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)30, (Object)CLDR36Database.INSTANCE), TuplesKt.to((Object)31, (Object)CLDR38Database.INSTANCE), TuplesKt.to((Object)32, (Object)CLDR38Database.INSTANCE), TuplesKt.to((Object)33, (Object)CLDR41Database.INSTANCE)};
        datasets = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\tH\u0086\u0002R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/PluralsDatabase$Companion;", "", "<init>", "()V", "EMPTY_SET", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/checks/PluralsDatabase$Quantity;", "kotlin.jvm.PlatformType", "FLAG_ZERO", "", "FLAG_ONE", "FLAG_TWO", "FLAG_FEW", "FLAG_MANY", "FLAG_MULTIPLE_ZERO", "FLAG_MULTIPLE_ONE", "FLAG_MULTIPLE_TWO", "datasets", "", "Lcom/android/tools/lint/checks/PluralsDatabase;", "OLDEST", "Lcom/android/tools/lint/checks/plurals/CLDR36Database;", "getOLDEST", "()Lcom/android/tools/lint/checks/plurals/CLDR36Database;", "LATEST", "Lcom/android/tools/lint/checks/plurals/CLDR42Database;", "getLATEST", "()Lcom/android/tools/lint/checks/plurals/CLDR42Database;", "get", "version", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CLDR36Database getOLDEST() {
            return CLDR36Database.INSTANCE;
        }

        @NotNull
        public final CLDR42Database getLATEST() {
            return CLDR42Database.INSTANCE;
        }

        @NotNull
        public final PluralsDatabase get(int version) {
            PluralsDatabase pluralsDatabase = (PluralsDatabase)datasets.get(version);
            if (pluralsDatabase == null) {
                pluralsDatabase = version < this.getOLDEST().getApiLevel$lint_checks() && version != -1 ? (PluralsDatabase)this.getOLDEST() : (PluralsDatabase)this.getLATEST();
            }
            return pluralsDatabase;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/PluralsDatabase$Quantity;", "", "<init>", "(Ljava/lang/String;I)V", "few", "many", "one", "two", "zero", "other", "Companion", "lint-checks"})
    public static final class Quantity
    extends Enum<Quantity> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ Quantity few;
        public static final /* enum */ Quantity many;
        public static final /* enum */ Quantity one;
        public static final /* enum */ Quantity two;
        public static final /* enum */ Quantity zero;
        public static final /* enum */ Quantity other;
        private static final /* synthetic */ Quantity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Quantity[] values() {
            return (Quantity[])$VALUES.clone();
        }

        public static Quantity valueOf(String value) {
            return Enum.valueOf(Quantity.class, value);
        }

        @NotNull
        public static EnumEntries<Quantity> getEntries() {
            return $ENTRIES;
        }

        static {
            few = new Quantity();
            many = new Quantity();
            one = new Quantity();
            two = new Quantity();
            zero = new Quantity();
            other = new Quantity();
            $VALUES = quantityArray = new Quantity[]{Quantity.few, Quantity.many, Quantity.one, Quantity.two, Quantity.zero, Quantity.other};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002J\u0014\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/PluralsDatabase$Quantity$Companion;", "", "<init>", "()V", "get", "Lcom/android/tools/lint/checks/PluralsDatabase$Quantity;", "name", "", "formatSet", "set", "Ljava/util/EnumSet;", "lint-checks"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Quantity get(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                for (Quantity quantity : Quantity.values()) {
                    if (!Intrinsics.areEqual((Object)name, (Object)quantity.name())) continue;
                    return quantity;
                }
                return null;
            }

            @NotNull
            public final String formatSet(@NotNull EnumSet<Quantity> set) {
                Intrinsics.checkNotNullParameter(set, (String)"set");
                List list = new ArrayList(set.size());
                Iterator iterator = set.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Quantity quantity = (Quantity)((Object)iterator2.next());
                    list.add("`" + quantity.name() + "`");
                }
                return Lint.formatList((List)list, (int)Integer.MAX_VALUE);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Quantity.values().length];
            try {
                nArray[Quantity.one.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Quantity.two.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Quantity.zero.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

