/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.BroadcastReceiverUtils;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastLiteralUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/RegisterReceiverFlagDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "filterIncident", "", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nRegisterReceiverFlagDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterReceiverFlagDetector.kt\ncom/android/tools/lint/checks/RegisterReceiverFlagDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
public final class RegisterReceiverFlagDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int RECEIVER_EXPORTED = 2;
    private static final int RECEIVER_NOT_EXPORTED = 4;
    private static final int RECEIVER_EXPORTED_FLAG_PRESENT_MASK = 6;
    @NotNull
    private static final String CLASS_HANDLER = "android.os.Handler";
    @NotNull
    private static final String FLAG_EXPORTED_STR = "androidx.core.content.ContextCompat.RECEIVER_EXPORTED";
    @NotNull
    private static final String FLAG_NOT_EXPORTED_STR = "androidx.core.content.ContextCompat.RECEIVER_NOT_EXPORTED";
    @NotNull
    private static final String METHOD_REGISTER_RECEIVER_ANDROIDX = "androidx.core.content.ContextCompat.registerReceiver";
    @NotNull
    private static final String HAS_UNPROTECTED_KEY = "hasUnprotected";
    @NotNull
    private static final String EXPLANATION = "\n      In Android U, all receivers registering for non-system broadcasts are required \\\n      to include a flag indicating the receiver's exported state. Apps registering for non-system \\\n      broadcasts should use the `ContextCompat#registerReceiver` APIs with flags set to either \\\n      `RECEIVER_EXPORTED` or `RECEIVER_NOT_EXPORTED`.\n\n      If you are not expecting broadcasts from other apps on the device, \\\n      register your receiver with `RECEIVER_NOT_EXPORTED` to protect your receiver on all platform releases.\n      ";
    @JvmField
    @NotNull
    public static final Issue RECEIVER_EXPORTED_FLAG;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return BroadcastReceiverUtils.INSTANCE.getBROADCAST_RECEIVER_METHOD_NAMES();
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)context.getEvaluator(), (PsiMember)((PsiMember)method), (String)"android.content.Context", (boolean)false, (int)4, null)) {
            return;
        }
        if (RegisterReceiverFlagDetector.Companion.isReceiverExportedFlagPresent(node)) {
            return;
        }
        UExpression uExpression = UastLintUtils.Companion.findArgument(node, "android.content.BroadcastReceiver");
        if (uExpression == null) {
            return;
        }
        UExpression receiverArg = uExpression;
        if (UastLiteralUtils.isNullLiteral((UElement)((UElement)receiverArg))) {
            return;
        }
        UExpression uExpression2 = UastLintUtils.Companion.findArgument(node, "android.content.IntentFilter");
        if (uExpression2 == null) {
            return;
        }
        UExpression filterArg = uExpression2;
        Pair<Boolean, List<String>> pair = BroadcastReceiverUtils.checkIsProtectedReceiverAndReturnUnprotectedActions(filterArg, node, context.getEvaluator());
        boolean isProtected2 = (Boolean)pair.component1();
        List unprotectedActionsList2 = (List)pair.component2();
        if (isProtected2) {
            return;
        }
        String actionsList = CollectionsKt.joinToString$default((Iterable)unprotectedActionsList2, (CharSequence)", ", (CharSequence)"", (CharSequence)"", (int)-1, (CharSequence)"", null, (int)32, null);
        CharSequence charSequence2 = actionsList;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "an IntentFilter that cannot be inspected by lint";
        } else {
            charSequence = charSequence2;
        }
        String registeredFor = (String)charSequence;
        Object object = receiverArg.getSourcePsi();
        if (object == null || (object = object.getText()) == null) {
            object = receiverArg.asSourceString();
        }
        String message2 = StringsKt.trimMargin$default((String)("`" + (String)object + "` \\\n              |is missing `RECEIVER_EXPORTED` or `RECEIVER_NOT_EXPORTED` flag for unprotected \\\n              |broadcasts registered for " + registeredFor), null, (int)1, null);
        LintMap lintMap = this.map().put(HAS_UNPROTECTED_KEY, !((Collection)unprotectedActionsList2).isEmpty());
        context.report(new Incident(RECEIVER_EXPORTED_FLAG, (Object)node, context.getLocation((UElement)node), message2, RegisterReceiverFlagDetector.Companion.buildAlternativesFix(context, node)), lintMap);
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (context.getMainProject().getTargetSdk() < 34 || !Intrinsics.areEqual((Object)LintMap.getBoolean$default((LintMap)map, (String)HAS_UNPROTECTED_KEY, null, (int)2, null), (Object)true)) {
            incident.overrideSeverity(Severity.WARNING);
        }
        return true;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(RegisterReceiverFlagDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES));
        RECEIVER_EXPORTED_FLAG = Issue.Companion.create$default((Issue.Companion)companion, (String)"UnspecifiedRegisterReceiverFlag", (String)"Missing `registerReceiver()` exported flag", (String)EXPLANATION, (Implementation)implementation, (String)"https://developer.android.com/reference/androidx/core/content/ContextCompat#registerReceiver(android.content.Context,android.content.BroadcastReceiver,android.content.IntentFilter,int)", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J$\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\b\b\u0002\u0010\u001b\u001a\u00020\u0012H\u0002J\u001f\u0010\u001c\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0015\u0010 \u001a\u00070\t\u00a2\u0006\u0002\b\u001d2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/checks/RegisterReceiverFlagDetector$Companion;", "", "<init>", "()V", "RECEIVER_EXPORTED", "", "RECEIVER_NOT_EXPORTED", "RECEIVER_EXPORTED_FLAG_PRESENT_MASK", "CLASS_HANDLER", "", "FLAG_EXPORTED_STR", "FLAG_NOT_EXPORTED_STR", "METHOD_REGISTER_RECEIVER_ANDROIDX", "HAS_UNPROTECTED_KEY", "EXPLANATION", "RECEIVER_EXPORTED_FLAG", "Lcom/android/tools/lint/detector/api/Issue;", "isReceiverExportedFlagPresent", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "buildAlternativesFix", "Lcom/android/tools/lint/detector/api/LintFix;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "registerReceiverCallNode", "buildFlagFix", "exported", "retrieveArgumentText", "Lcom/intellij/openapi/util/NlsSafe;", "call", "argumentType", "retrieveUElementText", "element", "Lorg/jetbrains/uast/UElement;", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nRegisterReceiverFlagDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegisterReceiverFlagDetector.kt\ncom/android/tools/lint/checks/RegisterReceiverFlagDetector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isReceiverExportedFlagPresent(UCallExpression node) {
            ConstantEvaluator evaluator = new ConstantEvaluator().allowFieldInitializers();
            UExpression uExpression = UastLintUtils.Companion.findArgument(node, "int");
            if (uExpression == null) {
                return false;
            }
            UExpression flagsArg = uExpression;
            Object object = evaluator.evaluate((UElement)flagsArg);
            Integer n = object instanceof Integer ? (Integer)object : null;
            if (n == null) {
                return true;
            }
            int flags = n;
            return (flags & 6) != 0;
        }

        private final LintFix buildAlternativesFix(JavaContext context, UCallExpression registerReceiverCallNode) {
            LintFix[] lintFixArray = new LintFix[]{com.android.tools.lint.checks.RegisterReceiverFlagDetector$Companion.buildFlagFix$default(this, context, registerReceiverCallNode, false, 4, null), this.buildFlagFix(context, registerReceiverCallNode, true)};
            return LintFix.Companion.create().alternatives(lintFixArray);
        }

        private final LintFix buildFlagFix(JavaContext context, UCallExpression registerReceiverCallNode, boolean exported) {
            Object object;
            block7: {
                block6: {
                    UElement uElement = registerReceiverCallNode.getUastParent();
                    object = uElement instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement : null;
                    if (object == null || (object = object.getReceiver()) == null) break block6;
                    UQualifiedReferenceExpression it = object;
                    boolean bl = false;
                    String string = Companion.retrieveUElementText((UElement)it);
                    object = string;
                    if (string != null) break block7;
                }
                return null;
            }
            Object contextArgumentText = object;
            String string = this.retrieveArgumentText(registerReceiverCallNode, "android.content.BroadcastReceiver");
            if (string == null) {
                return null;
            }
            String broadcastReceiverText = string;
            String string2 = this.retrieveArgumentText(registerReceiverCallNode, "android.content.IntentFilter");
            if (string2 == null) {
                return null;
            }
            String intentFilterText = string2;
            String string3 = this.retrieveArgumentText(registerReceiverCallNode, "int");
            if (string3 == null) {
                string3 = "";
            }
            String originalFlagArg = string3;
            String addFlagText = exported ? RegisterReceiverFlagDetector.FLAG_EXPORTED_STR : RegisterReceiverFlagDetector.FLAG_NOT_EXPORTED_STR;
            UFile uFile = context.getUastFile();
            boolean isKotlin = Intrinsics.areEqual((Object)(uFile != null ? uFile.getLang() : null), (Object)KotlinLanguage.INSTANCE);
            String flagsText = Intrinsics.areEqual((Object)originalFlagArg, (Object)"") || Intrinsics.areEqual((Object)originalFlagArg, (Object)"0") ? addFlagText : (isKotlin ? originalFlagArg + " or " + addFlagText : originalFlagArg + " | " + addFlagText);
            String broadcastPermissionText = this.retrieveArgumentText(registerReceiverCallNode, "java.lang.String");
            String schedulerText = this.retrieveArgumentText(registerReceiverCallNode, RegisterReceiverFlagDetector.CLASS_HANDLER);
            String fixText = broadcastPermissionText != null && schedulerText != null ? "androidx.core.content.ContextCompat.registerReceiver(" + (String)contextArgumentText + ", " + broadcastReceiverText + ", " + intentFilterText + ", " + broadcastPermissionText + ", " + schedulerText + ", " + flagsText + ")" : "androidx.core.content.ContextCompat.registerReceiver(" + (String)contextArgumentText + ", " + broadcastReceiverText + ", " + intentFilterText + ", " + flagsText + ")";
            String name = exported ? "Add RECEIVER_EXPORTED" : "Add RECEIVER_NOT_EXPORTED (preferred)";
            LintFix.ReplaceStringBuilder fix2 = LintFix.Companion.create().name(name).replace().reformat(true).shortenNames().range(Context.getLocation$default((Context)((Context)context), (Object)registerReceiverCallNode.getUastParent(), null, (int)2, null)).with(fixText);
            return fix2.build();
        }

        static /* synthetic */ LintFix buildFlagFix$default(Companion companion, JavaContext javaContext, UCallExpression uCallExpression, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.buildFlagFix(javaContext, uCallExpression, bl);
        }

        private final String retrieveArgumentText(UCallExpression call2, String argumentType) {
            String string;
            UExpression uExpression = UastLintUtils.Companion.findArgument(call2, argumentType);
            if (uExpression != null) {
                UExpression it = uExpression;
                boolean bl = false;
                string = Companion.retrieveUElementText((UElement)it);
            } else {
                string = null;
            }
            return string;
        }

        private final String retrieveUElementText(UElement element) {
            Object object = element.getSourcePsi();
            if (object == null || (object = object.getText()) == null) {
                object = element.asSourceString();
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

