/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AccessibilityDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"ContentDescription", (String)"Image without `contentDescription`", (String)"Non-textual widgets like ImageViews and ImageButtons should use the `contentDescription` attribute to specify a textual description of the widget such that screen readers and other accessibility tools can adequately describe the user interface.\n\nNote that elements in application screens that are purely decorative and do not provide any content or enable a user action should not have accessibility content descriptions. In this case, set their descriptions to `@null`. If your app's minSdkVersion is 16 or higher, you can instead set these graphical elements' `android:importantForAccessibility` attributes to `no`.\n\nNote that for text fields, you should not set both the `hint` and the `contentDescription` attributes since the hint will never be shown. Just set the `hint`.", (Category)Category.A11Y, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(AccessibilityDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://developer.android.com/guide/topics/ui/accessibility/apps#special-cases");

    public Collection<String> getApplicableElements() {
        return Arrays.asList("ImageButton", "ImageView", AndroidXConstants.FLOATING_ACTION_BUTTON.oldName(), AndroidXConstants.FLOATING_ACTION_BUTTON.newName());
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("contentDescription");
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        Element element = attribute.getOwnerElement();
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "hint")) {
            Incident incident = new Incident(ISSUE, "Do not set both `contentDescription` and `hint`: the `contentDescription` will mask the `hint`", context.getLocation((Node)attribute));
            context.report(incident);
        }
    }

    public void visitElement(XmlContext context, Element element) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "contentDescription")) {
            String importantForAccessibility = element.getAttributeNS("http://schemas.android.com/apk/res/android", "importantForAccessibility");
            if ("no".equals(importantForAccessibility)) {
                return;
            }
            context.report(ISSUE, (Node)element, context.getNameLocation((Node)element), "Missing `contentDescription` attribute on image", this.createFix(!importantForAccessibility.isEmpty()));
        } else {
            Attr attributeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "contentDescription");
            String attribute = attributeNode.getValue();
            if (attribute.isEmpty() || attribute.equals("TODO")) {
                context.report(ISSUE, (Node)attributeNode, context.getLocation((Node)attributeNode), "Empty `contentDescription` attribute on image", this.createFix(true));
            }
        }
    }

    private LintFix createFix(boolean setContentFixOnly) {
        LintFix setFix = this.fix().set().todo("http://schemas.android.com/apk/res/android", "contentDescription").build();
        if (setContentFixOnly) {
            return setFix;
        }
        LintFix notImportant = this.fix().set("http://schemas.android.com/apk/res/android", "importantForAccessibility", "no").build();
        return this.fix().alternatives(new LintFix[]{setFix, notImportant});
    }
}

