/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WrongCaseDetector
extends LayoutDetector {
    public static final String KEY_REPLACEMENTS = "replacements";
    public static final Issue WRONG_CASE = Issue.create((String)"WrongCase", (String)"Wrong case for view tag", (String)"Most layout tags, such as `<Button>`, refer to actual view classes and are therefore capitalized. However, there are exceptions such as `<fragment>` and `<include>`. This lint check looks for incorrect capitalizations.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.FATAL, (Implementation)new Implementation(WrongCaseDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://developer.android.com/guide/components/fragments.html");

    public Collection<String> getApplicableElements() {
        return Arrays.asList("Fragment", "RequestFocus", "Include", "Merge");
    }

    public void visitElement(XmlContext context, Element element) {
        String tag = element.getTagName();
        String correct = Character.toLowerCase(tag.charAt(0)) + tag.substring(1);
        LintFix fix = this.fix().data(new Object[]{KEY_REPLACEMENTS, Arrays.asList(tag, correct)});
        context.report(WRONG_CASE, (Node)element, context.getNameLocation((Node)element), String.format("Invalid tag `<%1$s>`; should be `<%2$s>`", tag, correct), fix);
    }
}

