/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceUpdateTracerService;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TranslationDetectorKt;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceFolderScanner;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001BB\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J<\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\nH\u0016J$\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010!\u001a\u00020\"2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0018\u0010'\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010(2\u0006\u0010!\u001a\u00020\"H\u0002J(\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020+2\u0006\u0010,\u001a\u00020*H\u0002J\u0010\u0010-\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JD\u0010.\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u0010,\u001a\u00020*2\b\u00100\u001a\u0004\u0018\u0001012\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u00102\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00103\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u00104\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0018\u00105\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u00106\u001a\u00020\nH\u0002J*\u00107\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J.\u00108\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J2\u0010:\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020+2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020*H\u0002J\u0018\u0010>\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020+2\u0006\u0010?\u001a\u00020@H\u0016J<\u0010A\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0002R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/lint/checks/TranslationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/ResourceFolderScanner;", "Lcom/android/tools/lint/detector/api/BinaryResourceScanner;", "()V", "baseNames", "", "Lcom/android/resources/ResourceType;", "", "", "locales", "", "missingMap", "nonBaseNames", "nonTranslatable", "pendingLocales", "translations", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "batchVisitResource", "type", "folderName", "Lcom/android/tools/lint/detector/api/ResourceContext;", "name", "element", "Lorg/w3c/dom/Element;", "defaultLocale", "checkBinaryResource", "checkFolder", "filterLocalesByResConfigs", "project", "Lcom/android/tools/lint/detector/api/Project;", "getLanguageTagFromFolder", "getLanguageTagFromQualifiers", "getLocaleTagFromFolder", "getLocaleTagFromQualifiers", "getResConfigLanguages", "", "handleNonTranslatable", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "isDefaultFolder", "ignoreFile", "incrementalVisitResource", "originalName", "configuration", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "processExtraTranslations", "processMissingTranslations", "recordTranslatable", "recordTranslation", "language", "reportExtraResource", "reportMissingTranslation", "missingFrom", "reportTranslatedUntranslatable", "locationNode", "Lorg/w3c/dom/Node;", "translatableDefinedLocally", "visitDocument", "document", "Lorg/w3c/dom/Document;", "visitResource", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nTranslationDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationDetector.kt\ncom/android/tools/lint/checks/TranslationDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,989:1\n1#2:990\n1#2:1004\n766#3:991\n857#3,2:992\n1603#3,9:994\n1855#3:1003\n1856#3:1005\n1612#3:1006\n766#3:1007\n857#3,2:1008\n*S KotlinDebug\n*F\n+ 1 TranslationDetector.kt\ncom/android/tools/lint/checks/TranslationDetector\n*L\n400#1:1004\n379#1:991\n379#1:992,2\n400#1:994,9\n400#1:1003\n400#1:1005\n400#1:1006\n806#1:1007\n806#1:1008,2\n*E\n"})
public final class TranslationDetector
extends Detector
implements XmlScanner,
ResourceFolderScanner,
BinaryResourceScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ResourceType, Set<String>> baseNames;
    @NotNull
    private final Map<ResourceType, Set<String>> nonBaseNames;
    @Nullable
    private Map<String, Set<String>> missingMap;
    @Nullable
    private Set<String> locales;
    @Nullable
    private Set<String> pendingLocales;
    @Nullable
    private Set<String> nonTranslatable;
    @Nullable
    private Map<String, Set<String>> translations;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING;
    @JvmField
    @NotNull
    public static final Issue EXTRA;
    @JvmField
    @NotNull
    public static final Issue MISSING_BASE;
    @JvmField
    @NotNull
    public static final Issue TRANSLATED_UNTRANSLATABLE;

    public TranslationDetector() {
        EnumMap enumMap = Maps.newEnumMap(ResourceType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enumMap, (String)"newEnumMap(ResourceType::class.java)");
        this.baseNames = enumMap;
        EnumMap enumMap2 = Maps.newEnumMap(ResourceType.class);
        Intrinsics.checkNotNullExpressionValue((Object)enumMap2, (String)"newEnumMap(ResourceType::class.java)");
        this.nonBaseNames = enumMap2;
    }

    private final boolean ignoreFile(Context context) {
        String string = context.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.name");
        return StringsKt.startsWith$default((String)string, (String)"donottranslate", (boolean)false, (int)2, null) || ResourceUsageModel.isAnalyticsFile((File)context.file) || !context.getProject().getReportIssues();
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getPhase() == 2) {
            return;
        }
        this.processMissingTranslations(context);
        this.processExtraTranslations(context);
    }

    private final void processMissingTranslations(Context context) {
        Map<String, Set<String>> nameToLocales;
        Map<String, Set<String>> map = nameToLocales = this.translations;
        boolean bl = map != null ? !map.isEmpty() : false;
        if (bl && context.isEnabled(MISSING) && this.pendingLocales != null) {
            Project project = context.getProject();
            Set<String> set = this.pendingLocales;
            Intrinsics.checkNotNull(set);
            Set<String> allLocales = this.filterLocalesByResConfigs(project, set);
            int localeCount = allLocales.size();
            Set set2 = this.nonTranslatable;
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            Set nonTranslatable = set2;
            for (ResourceType type : this.baseNames.keySet()) {
                Set<String> set3 = this.baseNames.get(type);
                if (set3 == null) {
                    return;
                }
                for (String key : set3) {
                    Set locales;
                    Set set4 = nameToLocales.get(key);
                    if (set4 == null) {
                        set4 = SetsKt.emptySet();
                    }
                    if ((locales = set4).size() >= localeCount || nonTranslatable.contains(key)) continue;
                    Sets.SetView missing = Sets.difference(allLocales, (Set)locales);
                    Map map2 = this.missingMap;
                    if (map2 == null) {
                        TranslationDetector $this$processMissingTranslations_u24lambda_u240 = this;
                        boolean bl2 = false;
                        HashMap map3 = new HashMap();
                        $this$processMissingTranslations_u24lambda_u240.missingMap = map3;
                        map2 = map3;
                    }
                    Map map4 = map2;
                    Intrinsics.checkNotNullExpressionValue((Object)missing, (String)"missing");
                    map4.put((String)key, (Set<String>)missing);
                }
            }
            if (this.missingMap != null) {
                context.getDriver().requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
            }
        }
    }

    private final void processExtraTranslations(Context context) {
        if (!this.nonBaseNames.isEmpty()) {
            for (ResourceType type : this.nonBaseNames.keySet()) {
                Set set = this.baseNames.get(type);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set base = set;
                Set<String> set2 = this.nonBaseNames.get(type);
                Intrinsics.checkNotNull(set2);
                for (String name : set2) {
                    if (base.contains(name)) continue;
                    context.getDriver().requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
                    return;
                }
            }
        }
    }

    public void checkFolder(@NotNull ResourceContext context, @NotNull String folderName) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)folderName, (String)"folderName");
            if (!context.getDriver().getScope().contains(Scope.ALL_RESOURCE_FILES) || context.getDriver().getPhase() != 1 || context.getResourceFolderType() != ResourceFolderType.VALUES || !context.getProject().getReportIssues()) break block3;
            String string = this.getLanguageTagFromFolder(folderName);
            if (string == null) {
                return;
            }
            String language = string;
            if (this.pendingLocales == null) {
                this.pendingLocales = new HashSet();
            }
            Set<String> set = this.pendingLocales;
            if (set != null) {
                set.add(language);
            }
        }
    }

    public void checkBinaryResource(@NotNull ResourceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ResourceFolderType resourceFolderType = context.getResourceFolderType();
        if (resourceFolderType == null) {
            return;
        }
        ResourceFolderType folderType = resourceFolderType;
        File file = context.file;
        if (folderType != ResourceFolderType.VALUES) {
            boolean bl;
            List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
            ResourceType type = (ResourceType)types.get(0);
            boolean bl2 = bl = type != ResourceType.ID;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                ResourceFolderType resourceFolderType2 = folderType;
                throw new AssertionError(resourceFolderType2);
            }
            String name = SdkUtils.fileNameToResourceName((String)file.getName());
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            this.visitResource(context, type, name, name, null, null);
        }
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Attr translatable;
        Element root;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (this.ignoreFile((Context)context)) {
            return;
        }
        ResourceFolderType resourceFolderType = context.getResourceFolderType();
        if (resourceFolderType == null) {
            return;
        }
        ResourceFolderType folderType = resourceFolderType;
        Element element = root = document.getDocumentElement();
        Attr attr = translatable = element != null ? element.getAttributeNode("translatable") : null;
        if (Intrinsics.areEqual((Object)(attr != null ? attr.getValue() : null), (Object)"false")) {
            File file = context.file.getParentFile();
            if (!Intrinsics.areEqual((Object)(file != null ? file.getName() : null), (Object)"values")) {
                String string = context.file.getParentFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.parentFile.name");
                if (Lint.getLocaleAndRegion((String)string) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
                    this.reportTranslatedUntranslatable(context, null, root, translatable, true);
                }
            }
            return;
        }
        File file = context.file;
        if (folderType != ResourceFolderType.VALUES) {
            boolean bl;
            List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
            ResourceType type = (ResourceType)types.get(0);
            boolean bl2 = bl = type != ResourceType.ID;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-TranslationDetector$visitDocument$22 = false;
                ResourceFolderType $i$a$-assert-TranslationDetector$visitDocument$22 = folderType;
                throw new AssertionError($i$a$-assert-TranslationDetector$visitDocument$22);
            }
            String name = SdkUtils.fileNameToResourceName((String)file.getName());
            ResourceContext resourceContext = (ResourceContext)context;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            this.visitResource(resourceContext, type, name, name, root, null);
        } else {
            if (root == null) {
                return;
            }
            if (!Intrinsics.areEqual((Object)root.getTagName(), (Object)"resources")) {
                return;
            }
            TranslationDetector $this$visitDocument_u24lambda_u243 = this;
            boolean bl = false;
            CharSequence attribute = root.getAttributeNS("http://schemas.android.com/tools", "locale");
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"attribute");
            String defaultLocale = !StringsKt.isBlank((CharSequence)attribute) ? attribute : null;
            if (defaultLocale != null && context.getDriver().getPhase() == 1) {
                String defaultLanguage;
                String parentFolderName = context.file.getParentFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)parentFolderName, (String)"parentFolderName");
                String folderLanguage = this.getLanguageTagFromFolder(parentFolderName);
                if (folderLanguage != null && !Intrinsics.areEqual((Object)folderLanguage, (Object)(defaultLanguage = StringsKt.substringBefore$default((String)defaultLocale, (String)"-", null, (int)2, null)))) {
                    Context context2 = (Context)context;
                    Attr attr2 = root.getAttributeNodeNS("http://schemas.android.com/tools", "locale");
                    Intrinsics.checkNotNullExpressionValue((Object)attr2, (String)"root.getAttributeNodeNS(TOOLS_URI, ATTR_LOCALE)");
                    Context.report$default((Context)context2, (Issue)MISSING, (Location)context.getValueLocation(attr2), (String)("Suspicious `tools:locale` declaration of language `" + defaultLanguage + "`; the parent folder `" + parentFolderName + "` implies language " + folderLanguage), null, (int)8, null);
                }
            }
            Element child = XmlUtils.getFirstSubTag((Node)root);
            while (child != null) {
                ResourceType type = ResourceType.fromXmlTag((Node)child);
                if (type != null && type != ResourceType.ID && type != ResourceType.PUBLIC && type != ResourceType.AAPT) {
                    String originalName = child.getAttribute("name");
                    attribute = originalName;
                    if (attribute == null || StringsKt.isBlank((CharSequence)attribute)) {
                        if (!child.hasAttribute("name")) {
                            LintFix fix = LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), null, (String)"name", null, null, (int)12, null).build();
                            context.report(MISSING, (Node)child, context.getLocation((Node)child), "Missing `name` attribute in `<" + child.getTagName() + ">` declaration", fix);
                        }
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)originalName, (String)"originalName");
                        String name = ResourcesUtil.resourceNameToFieldName((String)originalName);
                        this.visitResource((ResourceContext)context, type, name, originalName, child, defaultLocale);
                    }
                }
                child = XmlUtils.getNextTag((Node)child);
            }
        }
    }

    private final void visitResource(ResourceContext context, ResourceType type, String name, String originalName, Element element, String defaultLocale) {
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        String folderName = context.file.getParentFile().getName();
        if (context.getDriver().getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            Intrinsics.checkNotNullExpressionValue((Object)folderName, (String)"folderName");
            this.batchVisitResource(type, folderName, context, name, element, defaultLocale);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)folderName, (String)"folderName");
            this.incrementalVisitResource(context, type, name, originalName, element, folderName, defaultLocale);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void incrementalVisitResource(ResourceContext context, ResourceType type, String name, String originalName, Element element, String folderName, String defaultLocale) {
        block13: {
            block12: {
                client = context.getClient();
                if (!context.isGlobalAnalysis()) {
                    return;
                }
                resources = client.getResources(context.getMainProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                namespace = context.getProject().getResourceNamespace();
                v0 = resources.getResources(namespace, type, originalName);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"resources.getResources(n\u2026pace, type, originalName)");
                items = v0;
                if (items.isEmpty() && !Intrinsics.areEqual((Object)originalName, (Object)name)) {
                    v1 = resources.getResources(namespace, type, name);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"resources.getResources(namespace, type, name)");
                    items = v1;
                }
                if (items.isEmpty()) {
                    v2 = ResourceUpdateTracerService.Companion.getInstance();
                    if (v2 != null) {
                        v2.dumpTrace(null);
                    }
                    client.log(Severity.ERROR, null, "Resource repository is out-of-date: Could not find resource " + originalName + " of type " + type + " in namespace " + namespace, new Object[0]);
                    return;
                }
                $this$filter$iv = items;
                $i$f$filter = false;
                var15_15 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ResourceItem)element$iv$iv;
                    $i$a$-filter-TranslationDetector$incrementalVisitResource$hasDefault$1 = false;
                    if (!this.isDefaultFolder(it.getConfiguration(), null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                hasDefault = CollectionsKt.any((Iterable)((List)destination$iv$iv));
                if (hasDefault) break block12;
                this.reportExtraResource(type, name, context, element);
                break block13;
            }
            if (type != ResourceType.STRING && type != ResourceType.PLURALS || StringsKt.contains$default((CharSequence)folderName, (char)'-', (boolean)false, (int)2, null) || element == null || !(context instanceof XmlContext)) break block13;
            if (this.handleNonTranslatable(name, element, (XmlContext)context, true)) {
                return;
            }
            if (this.locales == null) {
                $this$filter$iv = TranslationDetectorKt.getStringLocales(resources);
                var30_27 = context.getProject();
                var29_28 = this;
                var28_29 = this;
                $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = it.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (LocaleQualifier)element$iv$iv;
                    $i$a$-mapNotNull-TranslationDetector$incrementalVisitResource$1 = false;
                    if ((it.hasLanguage() ? it.getLanguage() : defaultLocale) == null) continue;
                    it$iv$iv = it$iv$iv;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                var31_36 = (List)destination$iv$iv;
                var28_29.locales = var29_28.filterLocalesByResConfigs(var30_27, CollectionsKt.toSet((Iterable)var31_36));
            }
            v3 = this.locales;
            Intrinsics.checkNotNull(v3);
            locales = CollectionsKt.toHashSet((Iterable)v3);
            for (ResourceItem item : items) {
                $this$incrementalVisitResource_u24lambda_u246 = this;
                $i$a$-run-TranslationDetector$incrementalVisitResource$qualifiers$1 = false;
                s = item.getConfiguration().getQualifierString();
                if (defaultLocale == null) ** GOTO lbl-1000
                Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
                if (((CharSequence)s).length() == 0) {
                    v4 = StringsKt.substringBefore$default((String)defaultLocale, (char)'-', null, (int)2, null);
                } else lbl-1000:
                // 2 sources

                {
                    Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
                    v4 = StringsKt.substringBefore$default((String)s, (char)'-', null, (int)2, null);
                }
                qualifiers = v4;
                if (this.getLanguageTagFromQualifiers(qualifiers) == null) continue;
                locales.remove(language);
            }
            if (((Collection)locales).isEmpty() == false) {
                this.reportMissingTranslation(name, (XmlContext)context, element, locales);
            }
        }
    }

    private final void batchVisitResource(ResourceType type, String folderName, ResourceContext context, String name, Element element, String defaultLocale) {
        boolean isDefault = this.isDefaultFolder(context.getFolderConfiguration(), folderName);
        if (isDefault) {
            if (context.getPhase() == 1) {
                Set set = this.baseNames.get(type);
                if (set == null) {
                    TranslationDetector $this$batchVisitResource_u24lambda_u247 = this;
                    boolean bl = false;
                    Set set2 = new LinkedHashSet();
                    $this$batchVisitResource_u24lambda_u247.baseNames.put(type, set2);
                    set = set2;
                }
                Set names = set;
                names.add((String)name);
            } else if (element != null && (type == ResourceType.STRING || type == ResourceType.PLURALS) && context instanceof XmlContext) {
                Set<String> missingFrom;
                Map<String, Set<String>> map = this.missingMap;
                Set<String> set = missingFrom = map != null ? map.get(name) : null;
                if (missingFrom != null) {
                    this.reportMissingTranslation(name, (XmlContext)context, element, missingFrom);
                }
            }
            if ((type == ResourceType.STRING || type == ResourceType.PLURALS) && element != null && context instanceof XmlContext) {
                String language;
                if (defaultLocale != null && (language = this.getLanguageTagFromQualifiers(defaultLocale)) != null) {
                    this.recordTranslation(name, language);
                }
                this.handleNonTranslatable(name, element, (XmlContext)context, true);
            }
        } else if (context.getPhase() == 1) {
            Set set = this.nonBaseNames.get(type);
            if (set == null) {
                TranslationDetector $this$batchVisitResource_u24lambda_u248 = this;
                boolean bl = false;
                Set set3 = new LinkedHashSet();
                $this$batchVisitResource_u24lambda_u248.nonBaseNames.put(type, set3);
                set = set3;
            }
            Set names = set;
            names.add((String)name);
            if ((type == ResourceType.STRING || type == ResourceType.PLURALS) && element != null && context instanceof XmlContext) {
                if (this.handleNonTranslatable(name, element, (XmlContext)context, false)) {
                    return;
                }
                String string = this.getLanguageTagFromFolder(folderName);
                if (string == null && (string = this.getLanguageTagFromQualifiers(defaultLocale)) == null) {
                    string = "";
                }
                String language = string;
                this.recordTranslation(name, language);
            }
        } else {
            Set<String> set = this.baseNames.get(type);
            if (!(set != null ? set.contains(name) : false)) {
                this.reportExtraResource(type, name, context, element);
            }
        }
    }

    private final boolean isDefaultFolder(FolderConfiguration configuration, String folderName) {
        FolderConfiguration config;
        FolderConfiguration folderConfiguration = configuration;
        if (folderConfiguration == null) {
            if (folderName != null) {
                if (!StringsKt.contains$default((CharSequence)folderName, (char)'-', (boolean)false, (int)2, null)) {
                    return true;
                }
                if (!StringsKt.contains$default((CharSequence)folderName, (CharSequence)"dpi", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)folderName, (CharSequence)"-v", (boolean)false, (int)2, null)) {
                    return false;
                }
                folderConfiguration = FolderConfiguration.getConfigForFolder((String)folderName);
                if (folderConfiguration == null) {
                    return false;
                }
            } else {
                if (_Assertions.ENABLED) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                return true;
            }
        }
        return !(config = folderConfiguration).any((Predicate)isDefaultFolder.1.INSTANCE);
    }

    private final void recordTranslation(String name, String language) {
        Map<String, Set<String>> translations;
        Set set;
        Map<String, Set<String>> map = this.translations;
        if (map == null) {
            TranslationDetector $this$recordTranslation_u24lambda_u249 = this;
            boolean bl = false;
            $this$recordTranslation_u24lambda_u249.translations = new HashMap();
            Map<String, Set<String>> map2 = $this$recordTranslation_u24lambda_u249.translations;
            map = map2;
            Intrinsics.checkNotNull(map2);
        }
        if ((set = (translations = map).get(name)) == null) {
            TranslationDetector $this$recordTranslation_u24lambda_u2410 = this;
            boolean bl = false;
            HashSet set2 = new HashSet();
            translations.put(name, set2);
            set = set2;
        }
        Set languages = set;
        languages.add((String)language);
    }

    private final boolean handleNonTranslatable(String name, Element element, XmlContext context, boolean isDefaultFolder2) {
        Attr translatable = element.getAttributeNode("translatable");
        if (translatable != null) {
            String string = translatable.getValue();
            Intrinsics.checkNotNull((Object)string);
            if (!Boolean.parseBoolean(string)) {
                if (!isDefaultFolder2) {
                    String string2 = context.file.getParentFile().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.file.parentFile.name");
                    if (Lint.getLocaleAndRegion((String)string2) != null) {
                        this.reportTranslatedUntranslatable(context, name, element, translatable, true);
                    }
                }
                this.recordTranslatable(context, name);
                return true;
            }
        }
        if (SdkUtils.isServiceKey((String)name) || Intrinsics.areEqual((Object)name, (Object)"google_maps_key") || Intrinsics.areEqual((Object)name, (Object)"google_maps_key_instructions")) {
            this.recordTranslatable(context, name);
            return true;
        }
        if (!isDefaultFolder2) {
            Set<String> set = this.nonTranslatable;
            boolean bl = set != null ? set.contains(name) : false;
            if (bl) {
                String string = context.file.getParentFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.parentFile.name");
                if (Lint.getLocaleAndRegion((String)string) != null) {
                    Attr attr = element.getAttributeNode("name");
                    this.reportTranslatedUntranslatable(context, name, element, attr == null ? (Node)element : (Node)attr, false);
                }
            }
        }
        return false;
    }

    private final void recordTranslatable(XmlContext context, String name) {
        if (context.getDriver().getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            if (this.nonTranslatable == null) {
                this.nonTranslatable = new LinkedHashSet();
            }
            Set<String> set = this.nonTranslatable;
            Intrinsics.checkNotNull(set);
            set.add(name);
        }
    }

    private final void reportTranslatedUntranslatable(XmlContext context, String name, Element element, Node locationNode, boolean translatableDefinedLocally) {
        String string = context.file.getParentFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.file.parentFile.name");
        String string2 = this.getLanguageTagFromFolder(string);
        if (string2 == null) {
            return;
        }
        String language = string2;
        if (context.getDriver().isSuppressed(context, EXTRA, locationNode)) {
            return;
        }
        String languageDescription = Companion.getLanguageDescription(language);
        String message2 = name == null ? "This resource folder is marked as non-translatable yet is in a translated resource folder (" + languageDescription + ")" : (translatableDefinedLocally ? "The resource string \"" + name + "\" is marked as translatable=\"false\", but is translated to " + languageDescription + " here" : "The resource string \"" + name + "\" has been marked as translatable=\"false\" elsewhere (usually in the `values` folder), but is translated to " + languageDescription + " here");
        LintFix fix = this.fix().name("Remove translation").replace().range(context.getLocation((Node)element)).with("").build();
        context.report(TRANSLATED_UNTRANSLATABLE, locationNode, context.getLocation(locationNode), message2, fix);
    }

    private final void reportExtraResource(ResourceType type, String name, ResourceContext context, Element element) {
        String message2;
        String parentFolder = context.file.getParentFile().getName();
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 4: {
                String string = "\"" + name + "\" is translated here but not found in default locale";
                break;
            }
            case 5: {
                String string = "The drawable \"" + name + "\" in " + parentFolder + " has no declaration in the base `drawable` folder or in a `drawable-`*density*`dpi` folder; this can lead to crashes when the drawable is queried in a configuration that does not match this qualifier";
                break;
            }
            default: {
                String typeName = type.getName();
                ResourceFolderType resourceFolderType = context.getResourceFolderType();
                String baseFolder = resourceFolderType != null ? resourceFolderType.getName() : null;
                String string = message2 = "The " + typeName + " \"" + name + "\" in " + parentFolder + " has no declaration in the base `" + baseFolder + "` folder; this can lead to crashes when the resource is queried in a configuration that does not match this qualifier";
            }
        }
        if (element != null && context instanceof XmlContext) {
            LintFix lintFix;
            if (context.getResourceFolderType() == ResourceFolderType.VALUES) {
                String fixLabel = type == ResourceType.STRING || type == ResourceType.PLURALS ? "Remove translation" : "Remove resource override";
                lintFix = this.fix().name(fixLabel).replace().range(((XmlContext)context).getLocation((Node)element)).with("").build();
            } else {
                lintFix = null;
            }
            LintFix fix = lintFix;
            Issue issue = type == ResourceType.STRING || type == ResourceType.ARRAY && Intrinsics.areEqual((Object)element.getTagName(), (Object)"string-array") ? EXTRA : MISSING_BASE;
            Location location = XmlContext.getElementLocation$default((XmlContext)((XmlContext)context), (Element)element, null, null, (String)"name", (int)6, null);
            ((XmlContext)context).report(issue, (Node)element, location, message2, fix);
        } else {
            Location location = Location.Companion.create(context.file);
            Context.report$default((Context)((Context)context), (Issue)MISSING_BASE, (Location)location, (String)message2, null, (int)8, null);
        }
    }

    private final void reportMissingTranslation(String name, XmlContext context, Element element, Set<String> missingFrom) {
        String separator = missingFrom.size() == 2 ? " or " : ", ";
        String localeList2 = CollectionsKt.joinToString$default((Iterable)missingFrom, (CharSequence)separator, null, null, (int)0, null, (Function1)reportMissingTranslation.localeList.1.INSTANCE, (int)30, null);
        String message2 = "\"" + name + "\" is not translated in " + localeList2;
        Attr attr = element.getAttributeNode("name");
        Node locationNode = attr == null ? (Node)element : (Node)attr;
        LintFix fix = this.fix().name("Mark non-translatable").set(null, "translatable", "false").build();
        context.report(MISSING, (Node)element, context.getLocation(locationNode), message2, fix);
    }

    private final String getLanguageTagFromFolder(String name) {
        String string;
        String string2 = this.getLocaleTagFromFolder(name);
        if (string2 == null) {
            return null;
        }
        String locale = string2;
        int index2 = StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (index2 != -1) {
            String string3 = locale.substring(0, index2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = locale;
        }
        return string;
    }

    private final String getLocaleTagFromFolder(String name) {
        LocaleQualifier locale;
        if (Intrinsics.areEqual((Object)name, (Object)"values")) {
            return null;
        }
        FolderConfiguration configuration = FolderConfiguration.getConfigForFolder((String)name);
        if (configuration != null && (locale = configuration.getLocaleQualifier()) != null && !locale.hasFakeValue()) {
            return locale.getTag();
        }
        return null;
    }

    private final String getLanguageTagFromQualifiers(String name) {
        String string;
        if (name == null) {
            return null;
        }
        String string2 = this.getLocaleTagFromQualifiers(name);
        if (string2 == null) {
            return null;
        }
        String locale = string2;
        int index2 = StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (index2 != -1) {
            String string3 = locale.substring(0, index2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = locale;
        }
        return string;
    }

    private final String getLocaleTagFromQualifiers(String name) {
        LocaleQualifier locale;
        boolean bl;
        boolean bl2 = bl = !StringsKt.startsWith$default((String)name, (String)"values", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (((CharSequence)name).length() == 0) {
            return null;
        }
        FolderConfiguration configuration = FolderConfiguration.getConfigForQualifierString((String)name);
        if (configuration != null && (locale = configuration.getLocaleQualifier()) != null && !locale.hasFakeValue()) {
            return locale.getTag();
        }
        return null;
    }

    private final Set<String> filterLocalesByResConfigs(Project project, Set<String> locales) {
        List<String> list = this.getResConfigLanguages(project);
        if (list == null) {
            return locales;
        }
        List<String> configLanguages = list;
        return CollectionsKt.intersect((Iterable)locales, (Iterable)configLanguages);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getResConfigLanguages(Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        LintModelVariant lintModelVariant = project.getBuildVariant();
        if (lintModelVariant == null) {
            return null;
        }
        LintModelVariant variant = lintModelVariant;
        Collection resourceConfigurations = variant.getResourceConfigurations();
        if (resourceConfigurations.isEmpty()) {
            return null;
        }
        Iterable iterable = resourceConfigurations;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String resConfig = (String)element$iv$iv;
            boolean bl = false;
            if (!(resConfig.length() == 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)));
    }

    @JvmStatic
    @NotNull
    public static final String getLanguageDescription(@NotNull String locale) {
        return Companion.getLanguageDescription(locale);
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(TranslationDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.RESOURCE_FILE, (Enum)Scope.RESOURCE_FOLDER, (Enum)Scope.BINARY_RESOURCE_FILE), enumSetArray);
        MISSING = Issue.Companion.create("MissingTranslation", "Incomplete translation", "\n                If an application has more than one locale, then all the strings declared \\\n                in one language should also be translated in all other languages.\n\n                If the string should **not** be translated, you can add the attribute \\\n                `translatable=\"false\"` on the `<string>` element, or you can define all \\\n                your non-translatable strings in a resource file called \\\n                `donottranslate.xml`. Or, you can ignore the issue with a \\\n                `tools:ignore=\"MissingTranslation\"` attribute.\n\n                You can tell lint (and other tools) which language is the default language \\\n                in your `res/values/` folder by specifying `tools:locale=\"languageCode\"` \\\n                for the root `<resources>` element in your resource file. \\\n                (The `tools` prefix refers to the namespace declaration \\\n                `http://schemas.android.com/tools`.)", Category.MESSAGES, 8, Severity.ERROR, IMPLEMENTATION);
        EXTRA = Issue.Companion.create("ExtraTranslation", "Extra translation", "\n                If a string appears in a specific language translation file, but there is \\\n                no corresponding string in the default locale, then this string is probably \\\n                unused. (It's technically possible that your application is only intended \\\n                to run in a specific locale, but it's still a good idea to provide a fallback.)\n\n                Note that these strings can lead to crashes if the string is looked up on \\\n                any locale not providing a translation, so it's important to clean them up.", Category.MESSAGES, 6, Severity.FATAL, IMPLEMENTATION);
        MISSING_BASE = Issue.Companion.create("MissingDefaultResource", "Missing Default", "\n                If a resource is only defined in folders with qualifiers like `-land` or \\\n                `-en`, and there is no default declaration in the base folder (`layout` or \\\n                `values` etc), then the app will crash if that resource is accessed on a \\\n                device where the device is in a configuration missing the given qualifier.\n\n                As a special case, drawables do not have to be specified in the base folder; \\\n                if there is a match in a density folder (such as `drawable-mdpi`) that image \\\n                will be used and scaled. Note however that if you  only specify a drawable in \\\n                a folder like `drawable-en-hdpi`, the app will crash in non-English locales.\n\n                There may be scenarios where you have a resource, such as a `-fr` drawable, \\\n                which is only referenced from some other resource with the same qualifiers \\\n                (such as a `-fr` style), which itself has safe fallbacks. However, this still \\\n                makes it possible for somebody to accidentally reference the drawable and \\\n                crash, so it is safer to create a default fallback in the base folder. \\\n                Alternatively, you can suppress the issue by adding \\\n                `tools:ignore=\"MissingDefaultResource\"` on the element.\n\n                (This scenario frequently happens with string translations, where you might \\\n                delete code and the corresponding resources, but forget to delete a \\\n                translation. There is a dedicated issue id for that scenario, with the id \\\n                `ExtraTranslation`.)", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
        TRANSLATED_UNTRANSLATABLE = Issue.Companion.create("Untranslatable", "Translated Untranslatable", "\n                Strings can be marked with `translatable=false` to indicate that they are not \\\n                intended to be translated, but are present in the resource file for other \\\n                purposes (for example for non-display strings that should vary by some other \\\n                configuration qualifier such as screen size or API level).\n\n                There are cases where translators accidentally translate these strings anyway, \\\n                and lint will flag these occurrences with this lint check.", Category.MESSAGES, 6, Severity.WARNING, IMPLEMENTATION);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/TranslationDetector$Companion;", "", "()V", "EXTRA", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MISSING", "MISSING_BASE", "TRANSLATED_UNTRANSLATABLE", "getLanguageDescription", "", "locale", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getLanguageDescription(@NotNull String locale) {
            Object object;
            Object languageName;
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            int index2 = StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null);
            String regionCode = null;
            String languageCode = locale;
            if (index2 != -1) {
                String string = locale.substring(index2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = string;
                Locale locale2 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
                String string3 = string2.toUpperCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                regionCode = string3;
                String string4 = locale.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                string2 = string4;
                Locale locale3 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"US");
                String string5 = string2.toLowerCase(locale3);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                languageCode = string5;
            }
            if ((languageName = LocaleManager.getLanguageName((String)languageCode)) != null) {
                String regionName;
                if (regionCode != null && (regionName = LocaleManager.getRegionName(regionCode)) != null) {
                    languageName = (String)languageName + ": " + regionName;
                }
                String string = "\"%1$s\" (%2$s)";
                Object[] objectArray = new Object[]{locale, languageName};
                String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                object = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
            } else {
                object = "\"" + locale + "\"";
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            try {
                nArray[ResourceType.MIPMAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.STYLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.STYLEABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.DRAWABLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

