/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/FileEndsWithDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkExtension", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UExpression;", "getApplicableMethodNames", "", "", "getApplicableReferenceNames", "isExtension", "", "s", "isFileExtension", "member", "Lcom/intellij/psi/PsiElement;", "visitMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "visitReference", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Issues", "lint-checks"})
public final class FileEndsWithDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(FileEndsWithDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("FileEndsWithExt", "File endsWith on file extensions", "\n                The Kotlin extension method `File.endsWith(suffix)` checks whole path components, \\\n                not just string suffixes. This means that `File(\"foo.txt\").endsWith(\".txt\")` will return \\\n                false. Instead you might have intended `file.path.endsWith` or `file.extension.equals`.\n                ", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"endsWith");
    }

    @NotNull
    public List<String> getApplicableReferenceNames() {
        return CollectionsKt.listOf((Object)"extension");
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        if (this.isFileExtension(context, referenced)) {
            UElement uElement = reference.getUastParent();
            if (uElement == null) {
                return;
            }
            UElement parent = uElement;
            if (parent instanceof UBinaryExpression && (Intrinsics.areEqual((Object)((UBinaryExpression)parent).getOperator(), (Object)UastBinaryOperator.EQUALS) || !Intrinsics.areEqual((Object)((UBinaryExpression)parent).getOperator(), (Object)UastBinaryOperator.NOT_EQUALS))) {
                this.checkExtension(context, ((UBinaryExpression)parent).getRightOperand());
            } else if (parent instanceof UQualifiedReferenceExpression) {
                UQualifiedReferenceExpression curr = (UQualifiedReferenceExpression)parent;
                while (true) {
                    UQualifiedReferenceExpression p;
                    UElement uElement2;
                    UQualifiedReferenceExpression uQualifiedReferenceExpression = (uElement2 = curr.getUastParent()) instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement2 : null;
                    if (uQualifiedReferenceExpression == null) break;
                    curr = p = uQualifiedReferenceExpression;
                }
                UExpression selector = curr.getSelector();
                if (selector instanceof UCallExpression && Intrinsics.areEqual((Object)((UCallExpression)selector).getMethodName(), (Object)"startsWith") && ((UCallExpression)selector).getValueArgumentCount() > 0) {
                    this.checkExtension(context, (UExpression)CollectionsKt.last((List)((UCallExpression)selector).getValueArguments()));
                }
            }
        }
    }

    private final void checkExtension(JavaContext context, UExpression node) {
        String string = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)node), (boolean)false);
        if (string == null) {
            return;
        }
        String string2 = string;
        if (this.isExtension(string2)) {
            Incident incident = IncidentKt.Incident((Context)((Context)context)).issue(ISSUE).at((Object)node);
            String string3 = string2.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            incident.message("`File.extension` does not include the leading dot; did you mean \"" + string3 + "\" ?").report();
        }
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (this.isFileExtension(context, (PsiElement)method) && evaluator.getParameterCount(method) == 2) {
            String string = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)CollectionsKt.last((List)node.getValueArguments())), (boolean)false);
            if (string == null) {
                return;
            }
            String string2 = string;
            if (this.isExtension(string2)) {
                UExpression uExpression = node.getReceiver();
                Object object = uExpression instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)uExpression : null;
                if (object == null || (object = object.getIdentifier()) == null) {
                    object = "file";
                }
                Object file = object;
                IncidentKt.Incident((Context)((Context)context)).issue(ISSUE).at((Object)node).message("`File.endsWith` compares whole filenames, not just file extensions; did you mean `" + (String)file + ".path.endsWith(\"" + string2 + "\")` ?").report();
            }
        }
    }

    private final boolean isFileExtension(JavaContext context, PsiElement member) {
        return context.getEvaluator().isMemberInClass(member instanceof PsiMember ? (PsiMember)member : null, "kotlin.io.FilesKt__UtilsKt");
    }

    private final boolean isExtension(String s) {
        return s != null && StringsKt.startsWith$default((String)s, (String)".", (boolean)false, (int)2, null) && s.length() <= 10 && !StringsKt.startsWith$default((String)s, (String)"..", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)s, (char)' ', (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/FileEndsWithDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

