/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/InternalInsetResourceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class InternalInsetResourceDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"getIdentifier");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context.getEvaluator().isMemberInClass((PsiMember)method, "android.content.res.Resources")) {
            return;
        }
        if (!Intrinsics.areEqual((Object)method.getName(), (Object)"getIdentifier")) {
            return;
        }
        args = node.getValueArguments();
        if (args.size() != 3) {
            return;
        }
        nameArg = InternalInsetResourceDetector.visitMethodCall$getStringArgumentValue(context, (UExpression)args.get(0));
        defTypeArg = InternalInsetResourceDetector.visitMethodCall$getStringArgumentValue(context, (UExpression)args.get(1));
        defPackageArg = InternalInsetResourceDetector.visitMethodCall$getStringArgumentValue(context, (UExpression)args.get(2));
        var8_8 = nameArg;
        if (var8_8 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var8_8.hashCode()) {
            case -611229376: {
                if (!var8_8.equals("status_bar_height")) break;
                tmp = 1;
                break;
            }
            case 935313020: {
                if (!var8_8.equals("status_bar_height_landscape")) break;
                tmp = 1;
                break;
            }
            case 694738398: {
                if (!var8_8.equals("navigation_bar_height")) break;
                tmp = 1;
                break;
            }
            case 278039962: {
                if (!var8_8.equals("navigation_bar_height_landscape")) break;
                tmp = 1;
                break;
            }
            case 1837493807: {
                if (!var8_8.equals("navigation_bar_width")) break;
                tmp = 1;
                break;
            }
            case -1364921414: {
                if (var8_8.equals("status_bar_height_portrait")) ** GOTO lbl-1000
            }
        }
        block12: while (true) {
            switch (tmp) {
                case 1: lbl-1000:
                // 2 sources

                {
                    tmp = 2;
                    continue block12;
                }
                default: lbl-1000:
                // 2 sources

                {
                    return;
                }
                case 2: 
            }
            break;
        }
        if (Intrinsics.areEqual((Object)defTypeArg, (Object)"dimen") && Intrinsics.areEqual((Object)defPackageArg, (Object)"android")) {
            JavaContext.report$default((JavaContext)context, (Issue)InternalInsetResourceDetector.ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)("Using internal inset dimension resource `" + nameArg + "` is not supported"), null, (int)16, null);
        }
    }

    private static final String visitMethodCall$getStringArgumentValue(JavaContext $context, UExpression argument) {
        return ConstantEvaluator.evaluateString((JavaContext)$context, (UElement)((UElement)argument), (boolean)false);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(InternalInsetResourceDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"InternalInsetResource", (String)"Using internal inset dimension resource", (String)"\n                    The internal inset dimension resources are not a supported way to \\\n                    retrieve the relevant insets for your application. The insets are \\\n                    dynamic values that can change while your app is visible, and your \\\n                    app's window may not intersect with the system UI. \\\n                    To get the relevant value for your app and listen to updates, use \\\n                    `androidx.core.view.WindowInsetsCompat` and related APIs.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/InternalInsetResourceDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

