/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.checks.RangeDetector;
import com.android.tools.lint.checks.SizeConstraint;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/RangeDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkFloatRange", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "checkIntRange", "checkSize", "visitAnnotationUsage", "element", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "Companion", "lint-checks"})
public final class RangeDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RangeDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String AOSP_INT_RANGE_ANNOTATION = "android.annotation.IntRange";
    @JvmField
    @NotNull
    public static final Issue RANGE = Issue.Companion.create("Range", "Outside Range", "\n                Some parameters are required to be in a particular numerical range; this check \\\n                makes sure that arguments passed fall within the range. For arrays, Strings \\\n                and collections this refers to the size or length.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION);

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AnnotationDetectorKt.INT_RANGE_ANNOTATION.oldName(), AnnotationDetectorKt.INT_RANGE_ANNOTATION.newName(), AnnotationDetectorKt.FLOAT_RANGE_ANNOTATION.oldName(), AnnotationDetectorKt.FLOAT_RANGE_ANNOTATION.newName(), AnnotationDetectorKt.SIZE_ANNOTATION.oldName(), AnnotationDetectorKt.SIZE_ANNOTATION.newName(), AndroidXConstants.INT_DEF_ANNOTATION.oldName(), AndroidXConstants.INT_DEF_ANNOTATION.newName(), AndroidXConstants.LONG_DEF_ANNOTATION.oldName(), AndroidXConstants.LONG_DEF_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation annotation = annotationInfo.getAnnotation();
        String string = annotationInfo.getQualifiedName();
        if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.INT_RANGE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.INT_RANGE_ANNOTATION.newName())) {
            this.checkIntRange(context, annotation, element, usageInfo);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.FLOAT_RANGE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.FLOAT_RANGE_ANNOTATION.newName())) {
            this.checkFloatRange(context, annotation, element, usageInfo);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.SIZE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.SIZE_ANNOTATION.newName())) {
            this.checkSize(context, annotation, element, usageInfo);
        } else if (((Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.INT_DEF_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.INT_DEF_ANNOTATION.newName())) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.LONG_DEF_ANNOTATION.oldName())) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.LONG_DEF_ANNOTATION.newName())) {
            // empty if block
        }
    }

    private final void checkIntRange(JavaContext context, UAnnotation annotation, UElement argument, AnnotationUsageInfo usageInfo) {
        if (argument instanceof UIfExpression) {
            UExpression uExpression = ((UIfExpression)argument).getThenExpression();
            if (uExpression != null) {
                UExpression thenExpression = uExpression;
                boolean bl = false;
                this.checkIntRange(context, annotation, (UElement)thenExpression, usageInfo);
            }
            UExpression uExpression2 = ((UIfExpression)argument).getElseExpression();
            if (uExpression2 != null) {
                UExpression elseExpression = uExpression2;
                boolean bl = false;
                this.checkIntRange(context, annotation, (UElement)elseExpression, usageInfo);
            }
            return;
        }
        if (argument instanceof UParenthesizedExpression) {
            this.checkIntRange(context, annotation, (UElement)((UParenthesizedExpression)argument).getExpression(), usageInfo);
            return;
        }
        String message2 = Companion.getIntRangeError(context, annotation, argument, usageInfo);
        if (message2 != null) {
            if (usageInfo.anySameScope((Function1)checkIntRange.3.INSTANCE)) {
                return;
            }
            this.report(context, RANGE, argument, context.getLocation(argument), message2);
        }
    }

    private final void checkFloatRange(JavaContext context, UAnnotation annotation, UElement argument, AnnotationUsageInfo usageInfo) {
        if (argument instanceof UIfExpression) {
            boolean bl;
            UExpression uExpression = ((UIfExpression)argument).getThenExpression();
            if (uExpression != null) {
                UExpression uExpression2 = uExpression;
                bl = false;
                this.checkFloatRange(context, annotation, (UElement)uExpression2, usageInfo);
            }
            UExpression uExpression3 = ((UIfExpression)argument).getElseExpression();
            if (uExpression3 != null) {
                UExpression uExpression4 = uExpression3;
                bl = false;
                this.checkFloatRange(context, annotation, (UElement)uExpression4, usageInfo);
            }
            return;
        }
        if (argument instanceof UParenthesizedExpression) {
            this.checkFloatRange(context, annotation, (UElement)((UParenthesizedExpression)argument).getExpression(), usageInfo);
            return;
        }
        if (UastExpressionUtils.isNewArrayWithDimensions((UElement)argument)) {
            return;
        }
        FloatRangeConstraint constraint = FloatRangeConstraint.Companion.create(annotation);
        Object constant = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
        if (!(constant instanceof Number)) {
            RangeConstraint here;
            String error;
            RangeConstraint rangeConstraint;
            if (constant instanceof float[] || constant instanceof double[] || constant instanceof int[] || constant instanceof long[]) {
                if (constant instanceof float[]) {
                    for (float value : (float[])constant) {
                        if (constraint.isValid(value)) continue;
                        String message2 = constraint.describe(value);
                        this.report(context, RANGE, argument, context.getLocation(argument), message2);
                        return;
                    }
                }
                if (constant instanceof double[]) {
                    for (double value : (double[])constant) {
                        if (constraint.isValid(value)) continue;
                        String message3 = constraint.describe(value);
                        this.report(context, RANGE, argument, context.getLocation(argument), message3);
                        return;
                    }
                }
                if (constant instanceof int[]) {
                    for (int value : (int[])constant) {
                        if (constraint.isValid(value)) continue;
                        String message4 = constraint.describe(value);
                        this.report(context, RANGE, argument, context.getLocation(argument), message4);
                        return;
                    }
                }
                if (constant instanceof long[]) {
                    for (long value : (long[])constant) {
                        if (constraint.isValid(value)) continue;
                        String message5 = constraint.describe(value);
                        this.report(context, RANGE, argument, context.getLocation(argument), message5);
                        return;
                    }
                }
            }
            if (argument instanceof UResolvable && (rangeConstraint = RangeDetector.Companion.getRangeConstraint(context, (UResolvable)argument)) != null && (error = RangeDetector.Companion.getNonOverlapMessage(here = RangeConstraint.Companion.create(annotation), rangeConstraint, argument, usageInfo)) != null) {
                this.report(context, RANGE, argument, context.getLocation(argument), error);
            }
            return;
        }
        double d = ((Number)constant).doubleValue();
        if (!constraint.isValid(d)) {
            String message6 = FloatRangeConstraint.describe$default(constraint, argument instanceof UExpression ? (UExpression)argument : null, d, null, 4, null);
            this.report(context, RANGE, argument, context.getLocation(argument), message6);
        }
    }

    private final void checkSize(JavaContext context, UAnnotation annotation, UElement argument, AnnotationUsageInfo usageInfo) {
        long actual = 0L;
        boolean isString = false;
        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
            Intrinsics.checkNotNull((Object)argument, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            actual = ((UCallExpression)argument).getValueArgumentCount();
        } else {
            if (argument instanceof UIfExpression) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                if (uExpression != null) {
                    UExpression thenExpression = uExpression;
                    boolean bl = false;
                    this.checkSize(context, annotation, (UElement)thenExpression, usageInfo);
                }
                UExpression uExpression2 = ((UIfExpression)argument).getElseExpression();
                if (uExpression2 != null) {
                    UExpression elseExpression = uExpression2;
                    boolean bl = false;
                    this.checkSize(context, annotation, (UElement)elseExpression, usageInfo);
                }
                return;
            }
            if (argument instanceof UParenthesizedExpression) {
                this.checkSize(context, annotation, (UElement)((UParenthesizedExpression)argument).getExpression(), usageInfo);
                return;
            }
            Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (object instanceof String) {
                actual = ((String)object).length();
                isString = true;
            } else {
                actual = ConstantEvaluator.getArraySize((Object)object);
                if (actual == -1L) {
                    RangeConstraint here;
                    String error;
                    RangeConstraint constraint;
                    if (argument instanceof UResolvable && (constraint = RangeDetector.Companion.getRangeConstraint(context, (UResolvable)argument)) != null && (error = RangeDetector.Companion.getNonOverlapMessage(here = RangeConstraint.Companion.create(annotation), constraint, argument, usageInfo)) != null) {
                        this.report(context, RANGE, argument, context.getLocation(argument), error);
                    }
                    return;
                }
            }
        }
        SizeConstraint constraint = SizeConstraint.Companion.create(annotation);
        if (!constraint.isValid(actual)) {
            String unit = isString ? "length" : "size";
            String message2 = SizeConstraint.describe$default(constraint, argument instanceof UExpression ? (UExpression)argument : null, unit, actual, false, 8, null);
            this.report(context, RANGE, argument, context.getLocation(argument), message2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J&\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/checks/RangeDetector$Companion;", "", "()V", "AOSP_INT_RANGE_ANNOTATION", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RANGE", "Lcom/android/tools/lint/detector/api/Issue;", "getIntRangeError", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "getNonOverlapMessage", "allowed", "Lcom/android/tools/lint/checks/RangeConstraint;", "actual", "getRangeConstraint", "resolvable", "Lorg/jetbrains/uast/UResolvable;", "getRangeConstraints", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "condition", "Lorg/jetbrains/uast/UExpression;", "previousConstraint", "isIntRange", "", "qualifiedName", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nRangeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeDetector.kt\ncom/android/tools/lint/checks/RangeDetector$Companion\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,559:1\n18#2:560\n1#3:561\n*S KotlinDebug\n*F\n+ 1 RangeDetector.kt\ncom/android/tools/lint/checks/RangeDetector$Companion\n*L\n388#1:560\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isIntRange(@Nullable String qualifiedName) {
            return AnnotationDetectorKt.INT_RANGE_ANNOTATION.isEquals(qualifiedName) || Intrinsics.areEqual((Object)RangeDetector.AOSP_INT_RANGE_ANNOTATION, (Object)qualifiedName);
        }

        @Nullable
        public final String getIntRangeError(@NotNull JavaContext context, @NotNull UAnnotation annotation, @NotNull UElement argument, @NotNull AnnotationUsageInfo usageInfo) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
                UCallExpression newExpression = (UCallExpression)argument;
                for (UExpression uExpression : newExpression.getValueArguments()) {
                    UExpression expression;
                    String error;
                    if (UastUtils.skipParenthesizedExprDown((UExpression)uExpression) == null || (error = this.getIntRangeError(context, annotation, (UElement)expression, usageInfo)) == null) continue;
                    return error;
                }
            } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)argument)) {
                return null;
            }
            IntRangeConstraint constraint = IntRangeConstraint.Companion.create(annotation);
            Object o = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (!(o instanceof Number)) {
                RangeConstraint here;
                String error;
                RangeConstraint rangeConstraint;
                if (o instanceof int[] || o instanceof long[]) {
                    if (o instanceof int[]) {
                        for (int value : (int[])o) {
                            if (constraint.isValid(value)) continue;
                            return constraint.describe(Long.valueOf(value));
                        }
                    }
                    if (o instanceof long[]) {
                        for (long value : (long[])o) {
                            if (constraint.isValid(value)) continue;
                            return constraint.describe(value);
                        }
                    }
                }
                if (argument instanceof UResolvable && (rangeConstraint = this.getRangeConstraint(context, (UResolvable)argument)) != null && usageInfo.getType() != AnnotationUsageType.ASSIGNMENT_LHS && (error = this.getNonOverlapMessage(here = RangeConstraint.Companion.create(annotation), rangeConstraint, argument, usageInfo)) != null) {
                    return error;
                }
                return null;
            }
            long l = ((Number)o).longValue();
            return !constraint.isValid(l) ? constraint.describe(l) : null;
        }

        /*
         * WARNING - void declaration
         */
        private final RangeConstraint getRangeConstraint(JavaContext context, UResolvable resolvable) {
            UAnnotated constraint;
            UElement uElement;
            block10: {
                Object object;
                UResolvable resolved;
                block9: {
                    UResolvable uResolvable = resolvable;
                    if (uResolvable == null || (uResolvable = uResolvable.resolve()) == null) {
                        return null;
                    }
                    resolved = uResolvable;
                    uElement = UastContextKt.toUElement((PsiElement)resolved);
                    object = uElement instanceof UAnnotated ? (UAnnotated)uElement : null;
                    if (object == null) break block9;
                    UAnnotated it = object;
                    boolean bl = false;
                    RangeConstraint rangeConstraint = RangeConstraint.Companion.create(it, context.getEvaluator());
                    object = rangeConstraint;
                    if (rangeConstraint != null) break block10;
                }
                object = constraint = resolved instanceof PsiModifierListOwner ? RangeConstraint.Companion.create((PsiModifierListOwner)resolved, context.getEvaluator()) : null;
            }
            if (resolvable instanceof USimpleNameReferenceExpression) {
                void $this$getParentOfType$iv;
                uElement = (UElement)resolvable;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                UIfExpression surroundingIf = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UIfExpression.class, (boolean)strict$iv);
                if (surroundingIf != null) {
                    UExpression condition = UastUtils.skipParenthesizedExprDown((UExpression)surroundingIf.getCondition());
                    RangeConstraint rangeConstraint = this.getRangeConstraints((USimpleNameReferenceExpression)resolvable, condition, (RangeConstraint)constraint);
                    if (rangeConstraint == null) {
                        return constraint;
                    }
                    RangeConstraint newConstraint = rangeConstraint;
                    newConstraint.setInferred(true);
                    UExpression elseExpression = surroundingIf.getElseExpression();
                    if (elseExpression != null && UastLintUtilsKt.isBelow$default((UElement)((UElement)resolvable), (UElement)((UElement)elseExpression), (boolean)false, (int)2, null)) {
                        if (constraint != null) {
                            return constraint.remove(newConstraint);
                        }
                        return null;
                    }
                    return constraint != null ? constraint.and(newConstraint) : newConstraint;
                }
            }
            return constraint;
        }

        private final RangeConstraint getRangeConstraints(USimpleNameReferenceExpression resolvable, UExpression condition, RangeConstraint previousConstraint) {
            RangeConstraint rangeConstraint;
            if (!(condition instanceof UBinaryExpression)) {
                return null;
            }
            UastBinaryOperator operator = ((UBinaryExpression)condition).getOperator();
            if (Intrinsics.areEqual((Object)operator, (Object)UastBinaryOperator.LOGICAL_AND)) {
                RangeConstraint rangeConstraint2;
                RangeConstraint left = this.getRangeConstraints(resolvable, UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)condition).getLeftOperand()), previousConstraint);
                RangeConstraint right = this.getRangeConstraints(resolvable, UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)condition).getRightOperand()), previousConstraint);
                if (left == null && right == null) {
                    rangeConstraint2 = null;
                } else if (left != null && right != null) {
                    rangeConstraint2 = right.and(left);
                } else {
                    rangeConstraint2 = left;
                    if (rangeConstraint2 == null) {
                        rangeConstraint2 = right;
                    }
                }
                return rangeConstraint2;
            }
            if (Intrinsics.areEqual((Object)operator, (Object)UastBinaryOperator.LOGICAL_OR)) {
                return null;
            }
            UExpression lhs = ((UBinaryExpression)condition).getLeftOperand();
            if (!Intrinsics.areEqual((Object)UastUtils.tryResolve((UElement)((UElement)lhs)), (Object)resolvable.resolve())) {
                return null;
            }
            Object object = ((UBinaryExpression)condition).getRightOperand().evaluate();
            Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            if (number == null) {
                return null;
            }
            Number value = number;
            if (value instanceof Float || value instanceof Double) {
                RangeConstraint rangeConstraint3;
                double number2 = value.doubleValue();
                if (number2 == Double.POSITIVE_INFINITY || number2 == Double.NEGATIVE_INFINITY) {
                    return null;
                }
                UastBinaryOperator uastBinaryOperator = operator;
                if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER)) {
                    rangeConstraint3 = FloatRangeConstraint.Companion.greaterThan(number2);
                } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUALS)) {
                    rangeConstraint3 = FloatRangeConstraint.Companion.atLeast(number2);
                } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS)) {
                    rangeConstraint3 = FloatRangeConstraint.Companion.lessThan(number2);
                } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS)) {
                    rangeConstraint3 = FloatRangeConstraint.Companion.atMost(number2);
                } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS)) {
                    rangeConstraint3 = FloatRangeConstraint.Companion.range(number2, number2);
                } else {
                    return null;
                }
                return rangeConstraint3;
            }
            long number3 = value.longValue();
            if (number3 == Long.MIN_VALUE || number3 == Long.MAX_VALUE) {
                return null;
            }
            UastBinaryOperator uastBinaryOperator = operator;
            if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER)) {
                rangeConstraint = IntRangeConstraint.Companion.atLeast(number3);
            } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUALS)) {
                rangeConstraint = IntRangeConstraint.Companion.atLeast(number3);
            } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS)) {
                rangeConstraint = IntRangeConstraint.Companion.atMost(number3);
            } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS)) {
                rangeConstraint = IntRangeConstraint.Companion.atMost(number3);
            } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS)) {
                rangeConstraint = IntRangeConstraint.Companion.range(number3, number3);
            } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.NOT_EQUALS) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) {
                rangeConstraint = previousConstraint instanceof IntRangeConstraint ? (((IntRangeConstraint)previousConstraint).getFrom() == number3 ? IntRangeConstraint.Companion.range(((IntRangeConstraint)previousConstraint).getFrom() + 1L, ((IntRangeConstraint)previousConstraint).getTo()) : (((IntRangeConstraint)previousConstraint).getTo() == number3 ? IntRangeConstraint.Companion.range(((IntRangeConstraint)previousConstraint).getFrom(), ((IntRangeConstraint)previousConstraint).getTo() - 1L) : null)) : null;
            } else {
                return null;
            }
            return rangeConstraint;
        }

        private final String getNonOverlapMessage(RangeConstraint allowed, RangeConstraint actual, UElement argument, AnnotationUsageInfo usageInfo) {
            block11: {
                String argumentSource;
                String string;
                String allowedLabel;
                Object actualLabel;
                block13: {
                    block15: {
                        String string2;
                        block14: {
                            UElement selector;
                            block12: {
                                if (allowed == null) {
                                    return null;
                                }
                                Boolean bl = allowed.contains(actual);
                                if (bl == null) {
                                    return null;
                                }
                                boolean contains = bl;
                                if (contains) break block11;
                                if (actual.getInfinite() && actual.getInferred()) {
                                    return null;
                                }
                                actualLabel = "";
                                allowedLabel = "";
                                selector = UastLintUtilsKt.findSelector((UElement)argument);
                                if (!(selector instanceof UCallExpression)) break block12;
                                string = ((UCallExpression)selector).getMethodName();
                                if (string == null) {
                                    string = "";
                                }
                                break block13;
                            }
                            if (!(selector instanceof USimpleNameReferenceExpression)) break block14;
                            string = ((USimpleNameReferenceExpression)selector).getIdentifier();
                            break block13;
                        }
                        string = argument.getSourcePsi();
                        if (string == null || (string = string.getText()) == null) break block15;
                        String it = string2 = string;
                        boolean bl = false;
                        string = it.length() < 40 ? string2 : null;
                        if (string != null) break block13;
                    }
                    string = "";
                }
                if (!StringsKt.isBlank((CharSequence)(argumentSource = string))) {
                    actualLabel = "`" + argumentSource + "`";
                } else if (usageInfo.getType() == AnnotationUsageType.METHOD_CALL_PARAMETER) {
                    allowedLabel = "the parameter ";
                    actualLabel = "the argument ";
                }
                return allowed.describeDelta(actual, (String)actualLabel, allowedLabel);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

