/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.support.AndroidxName;
import com.android.tools.lint.checks.CutPasteDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Issues", "SuperCallVisitor", "lint-checks"})
public final class CallSuperDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    public static final String KEY_METHOD = "method";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CallSuperDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("MissingSuperCall", "Missing Super Call", "\n            Some methods, such as `View#onDetachedFromWindow`, require that you also call the \\\n            super implementation as part of your method.\n            ", Category.CORRECTNESS, 9, Severity.ERROR, IMPLEMENTATION);
    private static final AndroidxName CALL_SUPER_ANNOTATION = AndroidxName.of((AndroidxName)AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"CallSuper");
    @NotNull
    private static final String AOSP_CALL_SUPER_ANNOTATION = "android.annotation.CallSuper";
    @NotNull
    private static final String ON_DETACHED_FROM_WINDOW = "onDetachedFromWindow";
    @NotNull
    private static final String ON_VISIBILITY_CHANGED = "onVisibilityChanged";

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UMethod.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context, this){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ CallSuperDetector this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
            }

            public void visitMethod(@NotNull UMethod node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                JavaEvaluator evaluator = this.$context.getEvaluator();
                PsiMethod psiMethod = CallSuperDetector.Issues.getRequiredSuperMethod(evaluator, (PsiMethod)node);
                if (psiMethod == null) {
                    return;
                }
                PsiMethod superMethod = psiMethod;
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                SuperCallVisitor visitor2 = new SuperCallVisitor(superMethod, (PsiElement)(uClass != null ? uClass.getSourcePsi() : null));
                node.accept((UastVisitor)visitor2);
                int count = visitor2.getCallsSuperCount();
                if (count == 0) {
                    String methodName = node.getName();
                    if (Intrinsics.areEqual((Object)methodName, (Object)"onCreate") && visitor2.getAnySuperCallCount() > 0) {
                        String superMethodClass;
                        PsiClass psiClass = superMethod.getContainingClass();
                        String string = superMethodClass = psiClass != null ? psiClass.getQualifiedName() : null;
                        if (Intrinsics.areEqual((Object)superMethodClass, (Object)"androidx.appcompat.app.AppCompatActivity")) {
                            return;
                        }
                    }
                    String message2 = "Overriding method should call `super." + methodName + "`";
                    Location location = this.$context.getNameLocation(node);
                    Object[] objectArray = new Object[]{"method", superMethod};
                    LintFix fix = CallSuperDetector.access$fix(this.this$0).data(objectArray);
                    this.$context.report(CallSuperDetector.ISSUE, node, location, message2, fix);
                } else if (count > 1 && Intrinsics.areEqual((Object)node.getName(), (Object)"onCreate")) {
                    USuperExpression uSuperExpression = visitor2.findFirstOverlap(node);
                    if (uSuperExpression == null) {
                        return;
                    }
                    USuperExpression overlap = uSuperExpression;
                    String message3 = "Calling `super." + node.getName() + "` more than once can lead to crashes";
                    Location location = this.$context.getNameLocation((UElement)overlap);
                    this.$context.report(CallSuperDetector.ISSUE, node, location, message3);
                }
            }
        };
    }

    public static final /* synthetic */ LintFix.Builder access$fix(CallSuperDetector $this) {
        return $this.fix();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector$Issues;", "", "()V", "AOSP_CALL_SUPER_ANNOTATION", "", "CALL_SUPER_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "getCALL_SUPER_ANNOTATION", "()Lcom/android/support/AndroidxName;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_METHOD", "ON_DETACHED_FROM_WINDOW", "ON_VISIBILITY_CHANGED", "getRequiredSuperMethod", "Lcom/intellij/psi/PsiMethod;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "method", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public final AndroidxName getCALL_SUPER_ANNOTATION() {
            return CALL_SUPER_ANNOTATION;
        }

        @Nullable
        public final PsiMethod getRequiredSuperMethod(@NotNull JavaEvaluator evaluator, @NotNull PsiMethod method) {
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)method, (String)CallSuperDetector.KEY_METHOD);
            if (evaluator.isAbstract((PsiModifierListOwner)method)) {
                return null;
            }
            PsiMethod[] psiMethodArray = method.findSuperMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
            for (PsiMethod directSuper : psiMethodArray) {
                String name;
                if (evaluator.isAbstract((PsiModifierListOwner)directSuper)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)method.getName(), (String)"getName(...)");
                if (Intrinsics.areEqual((Object)CallSuperDetector.ON_DETACHED_FROM_WINDOW, (Object)name) ? evaluator.isMemberInSubClassOf((PsiMember)method, "android.view.View", false) : Intrinsics.areEqual((Object)CallSuperDetector.ON_VISIBILITY_CHANGED, (Object)name) && evaluator.isMemberInSubClassOf((PsiMember)method, "android.support.wearable.watchface.WatchFaceService.Engine", false)) {
                    return directSuper;
                }
                List annotations = JavaEvaluator.getAnnotations$default((JavaEvaluator)evaluator, (PsiModifierListOwner)((PsiModifierListOwner)directSuper), (boolean)true, null, (int)4, null);
                for (UAnnotation annotation : annotations) {
                    String signature = annotation.getQualifiedName();
                    if (!this.getCALL_SUPER_ANNOTATION().isEquals(signature) && !Intrinsics.areEqual((Object)signature, (Object)CallSuperDetector.AOSP_CALL_SUPER_ANNOTATION) && (signature == null || !StringsKt.endsWith$default((String)signature, (String)".OverrideMustInvoke", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)signature, (String)".OverridingMethodsMustInvokeSuper", (boolean)false, (int)2, null))) continue;
                    return directSuper;
                }
            }
            return null;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\f0\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0018\u00010\u0015\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/CallSuperDetector$SuperCallVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "targetMethod", "Lcom/intellij/psi/PsiMethod;", "childClass", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiElement;)V", "anySuperCallCount", "", "getAnySuperCallCount", "()I", "setAnySuperCallCount", "(I)V", "callsSuperCount", "getCallsSuperCount", "superCalls", "", "Lorg/jetbrains/uast/USuperExpression;", "getSuperCalls", "()Ljava/util/List;", "targetMethodName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "targetSuperClassName", "Lorg/jetbrains/annotations/Nullable;", "findFirstOverlap", "method", "Lorg/jetbrains/uast/UMethod;", "visitSuperExpression", "", "node", "lint-checks"})
    private static final class SuperCallVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final PsiMethod targetMethod;
        @Nullable
        private final PsiElement childClass;
        @NotNull
        private final List<USuperExpression> superCalls;
        private int anySuperCallCount;
        @NotNull
        private final String targetMethodName;
        @Nullable
        private final String targetSuperClassName;

        public SuperCallVisitor(@NotNull PsiMethod targetMethod, @Nullable PsiElement childClass) {
            Intrinsics.checkNotNullParameter((Object)targetMethod, (String)"targetMethod");
            this.targetMethod = targetMethod;
            this.childClass = childClass;
            this.superCalls = new ArrayList();
            String string = this.targetMethod.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.targetMethodName = string;
            PsiClass psiClass = this.targetMethod.getContainingClass();
            this.targetSuperClassName = psiClass != null ? psiClass.getQualifiedName() : null;
        }

        @NotNull
        public final List<USuperExpression> getSuperCalls() {
            return this.superCalls;
        }

        public final int getCallsSuperCount() {
            return this.superCalls.size();
        }

        public final int getAnySuperCallCount() {
            return this.anySuperCallCount;
        }

        public final void setAnySuperCallCount(int n) {
            this.anySuperCallCount = n;
        }

        public boolean visitSuperExpression(@NotNull USuperExpression node) {
            block6: {
                block5: {
                    PsiElement containingClass;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
                    Object object = containingClass = uClass != null ? uClass.getSourcePsi() : null;
                    if (this.childClass == null) break block5;
                    PsiElement psiElement = containingClass;
                    if (psiElement != null ? !psiElement.isEquivalentTo(this.childClass) : false) break block6;
                }
                int n = this.anySuperCallCount;
                this.anySuperCallCount = n + 1;
                UElement parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
                if (parent instanceof UReferenceExpression) {
                    String resolvedClassName;
                    PsiMethod resolved;
                    PsiElement psiElement = ((UReferenceExpression)parent).resolve();
                    PsiMethod psiMethod = resolved = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
                    String resolvedMethodName = psiMethod != null ? psiMethod.getName() : null;
                    PsiMethod psiMethod2 = resolved;
                    String string = psiMethod2 != null && (psiMethod2 = psiMethod2.getContainingClass()) != null ? psiMethod2.getQualifiedName() : (resolvedClassName = null);
                    if (resolved == null || resolvedMethodName == null || resolvedClassName == null || Intrinsics.areEqual((Object)resolvedMethodName, (Object)this.targetMethodName) && Intrinsics.areEqual((Object)resolvedClassName, (Object)this.targetSuperClassName)) {
                        this.superCalls.add(node);
                    }
                }
            }
            return super.visitSuperExpression(node);
        }

        @Nullable
        public final USuperExpression findFirstOverlap(@NotNull UMethod method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)CallSuperDetector.KEY_METHOD);
            int n = this.superCalls.size();
            for (int i = 0; i < n; ++i) {
                int n2 = this.superCalls.size();
                for (int j = i + 1; j < n2; ++j) {
                    if (!CutPasteDetector.isReachableFrom(method, (UElement)this.superCalls.get(i), (UElement)this.superCalls.get(j))) continue;
                    return this.superCalls.get(j);
                }
            }
            return null;
        }
    }
}

