/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnalysisApiLintUtilsKt;
import com.android.tools.lint.checks.ControlFlowGraph;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UImplicitCallExpressionKt;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UBreakExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UContinueExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UForExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UJumpExpression;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.ULoopExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastEmptyExpression;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.internal.ImplementationUtilsKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0016\u0018\u0000 1*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0006123456B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J+\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00018\u00002\b\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0011\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00018\u00002\b\u0010\f\u001a\u0004\u0018\u00018\u00002\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0010J3\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0001\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00150\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u001cJ\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u001eJ\u001b\u0010\u001f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00062\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010#\u001a\u00028\u0000H\u0010\u00a2\u0006\u0004\b$\u0010!Jy\u0010%\u001a\u00020\u000e2\n\b\u0002\u0010&\u001a\u0004\u0018\u00018\u00002\n\b\u0002\u0010'\u001a\u0004\u0018\u00018\u00002\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u001a\b\u0002\u0010(\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00020\u000e0)2,\b\u0002\u0010*\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000,\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u000e0+\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020\u000eH\u0016J\f\u00100\u001a\u00020\u000e*\u00020\u000eH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/tools/lint/checks/ControlFlowGraph;", "T", "", "()V", "nodeList", "", "Lcom/android/tools/lint/checks/ControlFlowGraph$Node;", "nodeMap", "Ljava/util/IdentityHashMap;", "addException", "", "from", "to", "exceptionType", "", "addException$lint_checks", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)V", "addSuccessor", "label", "addSuccessor$lint_checks", "dfs", "C", "domain", "Lcom/android/tools/lint/checks/ControlFlowGraph$Domain;", "request", "Lcom/android/tools/lint/checks/ControlFlowGraph$DfsRequest;", "(Lcom/android/tools/lint/checks/ControlFlowGraph$Domain;Lcom/android/tools/lint/checks/ControlFlowGraph$DfsRequest;)Ljava/lang/Object;", "getAllNodes", "", "getEntryPoints", "", "getNode", "element", "(Ljava/lang/Object;)Lcom/android/tools/lint/checks/ControlFlowGraph$Node;", "getOrCreate", "instruction", "getOrCreate$lint_checks", "toDot", "start", "end", "renderNode", "Lkotlin/Function1;", "renderEdge", "Lkotlin/Function3;", "Lcom/android/tools/lint/checks/ControlFlowGraph$Edge;", "", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function3;)Ljava/lang/String;", "toString", "escapeDot", "Companion", "DfsRequest", "Domain", "Edge", "FollowBranch", "Node", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nControlFlowGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowGraph.kt\ncom/android/tools/lint/checks/ControlFlowGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,2157:1\n381#2,3:2158\n384#2,4:2162\n1#3:2161\n1872#4,3:2166\n1863#4,2:2169\n774#4:2171\n865#4,2:2172\n1863#4,2:2174\n1288#5,3:2176\n*S KotlinDebug\n*F\n+ 1 ControlFlowGraph.kt\ncom/android/tools/lint/checks/ControlFlowGraph\n*L\n186#1:2158,3\n186#1:2162,4\n252#1:2166,3\n265#1:2169,2\n291#1:2171\n291#1:2172,2\n296#1:2174,2\n319#1:2176,3\n*E\n"})
public class ControlFlowGraph<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdentityHashMap<T, Node<T>> nodeMap = new IdentityHashMap(40);
    @NotNull
    private final List<Node<T>> nodeList = new ArrayList();
    @NotNull
    public static final String FINALLY_KEY = "finally";
    @NotNull
    private static final String FUNCTIONAL_INTERFACE_CLASS = "java.lang.FunctionalInterface";
    @NotNull
    private static final String KOTLIN_FUNCTION_PREFIX = "kotlin.jvm.functions.Function";
    @NotNull
    private static final String COMPOSABLE_CLASS = "androidx.compose.runtime.Composable";
    @NotNull
    private static final List<String> DEFAULT_EXCEPTIONS_JAVA = CollectionsKt.listOf((Object)"java.lang.RuntimeException");
    @NotNull
    private static final List<String> DEFAULT_EXCEPTIONS_KOTLIN = CollectionsKt.listOf((Object)"java.lang.Exception");
    @NotNull
    private static final List<String> DEFAULT_EXCEPTIONS_STRICT = CollectionsKt.listOf((Object)"java.lang.Throwable");
    @NotNull
    private static final Domain<Boolean> BoolDomain = new Domain<Boolean>(false, Companion.BoolDomain.1.INSTANCE);
    @NotNull
    private static final Domain<Integer> IntBitsDomain = new Domain<Integer>(0, Companion.IntBitsDomain.1.INSTANCE);
    @NotNull
    private static final Domain<Unit> UnitDomain = new Domain<Unit>(Unit.INSTANCE, Companion.UnitDomain.1.INSTANCE);

    private ControlFlowGraph() {
    }

    public final void addSuccessor$lint_checks(@Nullable T from, @Nullable T to, @Nullable String label) {
        if (from == null) {
            return;
        }
        if (to == null) {
            return;
        }
        this.getOrCreate$lint_checks(from).addSuccessor$lint_checks(this.getOrCreate$lint_checks(to), label);
    }

    public static /* synthetic */ void addSuccessor$lint_checks$default(ControlFlowGraph controlFlowGraph, Object object, Object object2, String string, int n, Object object3) {
        if (object3 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSuccessor");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        controlFlowGraph.addSuccessor$lint_checks(object, object2, string);
    }

    public final void addException$lint_checks(@Nullable T from, @Nullable T to, @NotNull String exceptionType) {
        Intrinsics.checkNotNullParameter((Object)exceptionType, (String)"exceptionType");
        if (from == null) {
            return;
        }
        if (to == null) {
            return;
        }
        this.getOrCreate$lint_checks(from).addExceptionPath$lint_checks(this.getOrCreate$lint_checks(to), exceptionType);
    }

    @NotNull
    public Node<T> getOrCreate$lint_checks(@NotNull T instruction) {
        Object object;
        Intrinsics.checkNotNullParameter(instruction, (String)"instruction");
        Map $this$getOrPut$iv = this.nodeMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(instruction);
        if (value$iv == null) {
            boolean bl = false;
            Node<T> node = new Node<T>(instruction);
            List<Node<T>> list = this.nodeList;
            Node<T> p0 = node;
            boolean bl2 = false;
            list.add(p0);
            Node<T> answer$iv = node;
            $this$getOrPut$iv.put(instruction, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Node)object;
    }

    @Nullable
    public final Node<T> getNode(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.nodeMap.get(element);
    }

    @NotNull
    public final Collection<Node<T>> getAllNodes() {
        return this.nodeList;
    }

    @NotNull
    public String toString() {
        return ControlFlowGraph.toDot$default(this, null, null, null, null, null, 31, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toDot(@Nullable T start, @Nullable T end, @Nullable String label, @NotNull Function1<? super Node<T>, String> renderNode, @NotNull Function3<? super Node<T>, ? super Edge<T>, ? super Integer, String> renderEdge) {
        Intrinsics.checkNotNullParameter(renderNode, (String)"renderNode");
        Intrinsics.checkNotNullParameter(renderEdge, (String)"renderEdge");
        Collection<Node<T>> nodes = this.getAllNodes();
        StringBuilder sb = new StringBuilder();
        String string = label;
        sb.append(StringsKt.trimIndent((String)("\n      digraph {\n        labelloc=\"t\"\n        " + (String)(string != null ? "label=\"" + string + "\"\n" : "") + "\n        node [shape=box]\n        subgraph cluster_instructions {\n          penwidth=0;\n      ")));
        sb.append('\n');
        LinkedHashMap keys = new LinkedHashMap();
        int key = 10;
        for (Node<T> node : nodes) {
            boolean bl;
            String id;
            String string2 = "N%03x";
            Object[] objectArray = new Object[]{key++};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string3.toUpperCase(Locale.ROOT), (String)"toUpperCase(...)");
            ((Map)keys).put(node, id);
            sb.append("    ").append(id).append(" [label=\"");
            T instruction = node.getInstruction();
            String describe = this.escapeDot((String)renderNode.invoke(node));
            boolean bl2 = bl = !StringsKt.isBlank((CharSequence)describe);
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            sb.append(describe);
            sb.append("\"");
            if (Intrinsics.areEqual(instruction, end)) {
                sb.append(",shape=ellipse");
            } else if (Intrinsics.areEqual(instruction, start)) {
                sb.append(",shape=ellipse");
            }
            sb.append("]\n");
        }
        sb.append("\n");
        for (Node<T> node : nodes) {
            Iterable $this$forEachIndexed$iv = node.getSuccessors();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void edge;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Edge edge2 = (Edge)item$iv;
                int i = n;
                boolean bl = false;
                Object v = keys.get(node);
                Intrinsics.checkNotNull(v);
                String nodeKey = (String)v;
                Node successor = edge.getTo();
                Object v2 = keys.get(successor);
                Intrinsics.checkNotNull(v2);
                String successorKey = (String)v2;
                sb.append("    ").append(nodeKey).append(" -> ").append(successorKey).append(" [label=\" " + renderEdge.invoke(node, (Object)edge, (Object)i) + " \"]");
                sb.append("\n");
            }
            Iterable $this$forEach$iv = node.getExceptions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Edge edge = (Edge)element$iv;
                boolean bl = false;
                Node exception = edge.getTo();
                String type = edge.getLabel();
                Object v = keys.get(node);
                Intrinsics.checkNotNull(v);
                String nodeKey = (String)v;
                String string5 = (String)keys.get(exception);
                if (string5 == null) {
                    string5 = "exceptionKeyMissing";
                }
                String string6 = string5;
                Intrinsics.checkNotNull((Object)string6);
                String exceptionKey = string6;
                sb.append("    ").append(nodeKey).append(" -> ").append(exceptionKey);
                sb.append(" [label=\" " + (Intrinsics.areEqual((Object)type, (Object)FINALLY_KEY) ? FINALLY_KEY : type) + " \",style=dashed]");
                sb.append("\n");
            }
        }
        sb.append("  }\n}");
        String string7 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
        return string7;
    }

    public static /* synthetic */ String toDot$default(ControlFlowGraph controlFlowGraph, Object object, Object object2, String string, Function1 function1, Function3 function3, int n, Object object3) {
        if (object3 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toDot");
        }
        if ((n & 1) != 0) {
            object = null;
        }
        if ((n & 2) != 0) {
            object2 = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            function1 = toDot.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function3 = toDot.2.INSTANCE;
        }
        return controlFlowGraph.toDot(object, object2, string, function1, function3);
    }

    private final String escapeDot(String $this$escapeDot) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeDot, (String)"\"", (String)"'", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Node<T>> getEntryPoints() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.nodeList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Node it = (Node)element$iv$iv;
            boolean bl = false;
            if (!(it.getReferenceCount() == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final <C> C dfs(@NotNull Domain<C> domain, @NotNull DfsRequest<T, C> request) {
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Collection<Node<T>> collection = this.nodeMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            it.setVisit(0);
        }
        return ControlFlowGraph.dfs$visit(request, domain, request.getStartNode(), domain.getId(), ExtensionsKt.persistentListOf(), false);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T, C> C dfs$visit(DfsRequest<T, C> $request, Domain<C> $domain, Node<T> node, C initial, PersistentList<Edge<T>> path, boolean seenException) {
        void $this$fold$iv;
        Sequence successors;
        if (node.getVisit() != 0) {
            return initial;
        }
        node.setVisit(1);
        C status = $request.visitNode(node, (List)path, initial);
        if ($request.isDone(status)) {
            return status;
        }
        if ($request.prune(node, (List)path, status)) {
            return status;
        }
        Sequence sequence = successors = seenException && $request.getFollowExceptionalFlow() && !((Collection)node.getExceptions()).isEmpty() ? CollectionsKt.asSequence((Iterable)node.getExceptions()) : SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)node.getSuccessors()), (Sequence)CollectionsKt.asSequence((Iterable)node.getExceptions()));
        C initial$iv = $domain.getId();
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void edge;
            Object object;
            Edge edge2 = (Edge)element$iv;
            C result = accumulator$iv;
            boolean bl = false;
            Object it = object = $domain.getJoin().invoke(ControlFlowGraph.dfs$visit($request, $domain, edge.getTo(), status, path.add((Object)edge), !(!seenException && !edge.isException() || $request.getFollowExceptionalFlow() && $request.consumesException((Edge<T>)edge))), result);
            boolean bl2 = false;
            if ($request.isDone(it)) {
                return (C)it;
            }
            accumulator$iv = object;
        }
        return accumulator$iv;
    }

    public /* synthetic */ ControlFlowGraph(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020!J\u001a\u0010\"\u001a\u00020\t2\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190$0\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u000e\u0010\u0013\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/checks/ControlFlowGraph$Companion;", "", "()V", "BoolDomain", "Lcom/android/tools/lint/checks/ControlFlowGraph$Domain;", "", "getBoolDomain", "()Lcom/android/tools/lint/checks/ControlFlowGraph$Domain;", "COMPOSABLE_CLASS", "", "DEFAULT_EXCEPTIONS_JAVA", "", "DEFAULT_EXCEPTIONS_KOTLIN", "DEFAULT_EXCEPTIONS_STRICT", "FINALLY_KEY", "FUNCTIONAL_INTERFACE_CLASS", "IntBitsDomain", "", "getIntBitsDomain", "KOTLIN_FUNCTION_PREFIX", "UnitDomain", "", "getUnitDomain", "create", "Lcom/android/tools/lint/checks/ControlFlowGraph;", "Lorg/jetbrains/uast/UElement;", "method", "Lorg/jetbrains/uast/UMethod;", "builder", "Lcom/android/tools/lint/checks/ControlFlowGraph$Companion$Builder;", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "Lorg/objectweb/asm/tree/MethodNode;", "describePath", "path", "Lcom/android/tools/lint/checks/ControlFlowGraph$Edge;", "Builder", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nControlFlowGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowGraph.kt\ncom/android/tools/lint/checks/ControlFlowGraph$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2157:1\n1#2:2158\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Domain<Boolean> getBoolDomain() {
            return BoolDomain;
        }

        @NotNull
        public final Domain<Integer> getIntBitsDomain() {
            return IntBitsDomain;
        }

        @NotNull
        public final Domain<Unit> getUnitDomain() {
            return UnitDomain;
        }

        @NotNull
        public final ControlFlowGraph<AbstractInsnNode> create(@NotNull ClassNode classNode, @NotNull MethodNode method) throws AnalyzerException {
            Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            ControlFlowGraph<AbstractInsnNode> graph2 = new ControlFlowGraph<AbstractInsnNode>(null);
            InsnList instructions = method.instructions;
            BasicInterpreter interpreter = new BasicInterpreter();
            Analyzer<BasicValue> analyzer2 = new Analyzer<BasicValue>(interpreter, instructions, graph2){
                final /* synthetic */ InsnList $instructions;
                final /* synthetic */ ControlFlowGraph<AbstractInsnNode> $graph;
                {
                    this.$instructions = $instructions;
                    this.$graph = $graph;
                    super((Interpreter)$interpreter);
                }

                protected void newControlFlowEdge(int insn, int successor) {
                    AbstractInsnNode from = this.$instructions.get(insn);
                    AbstractInsnNode to = this.$instructions.get(successor);
                    ControlFlowGraph.addSuccessor$lint_checks$default(this.$graph, from, to, null, 4, null);
                }

                protected boolean newControlFlowExceptionEdge(int insn, TryCatchBlockNode tcb) {
                    Intrinsics.checkNotNullParameter((Object)tcb, (String)"tcb");
                    AbstractInsnNode from = this.$instructions.get(insn);
                    Intrinsics.checkNotNull((Object)from);
                    this.exception(from, tcb);
                    return super.newControlFlowExceptionEdge(insn, tcb);
                }

                private final void exception(AbstractInsnNode from, TryCatchBlockNode tcb) {
                    if (from.getType() == 5 || from.getType() == 0 && from.getOpcode() == 191) {
                        LabelNode labelNode = tcb.handler;
                        String string = tcb.type;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type");
                        this.$graph.addException$lint_checks(from, (AbstractInsnNode)labelNode, string);
                    }
                }
            };
            analyzer2.analyze(classNode.name, method);
            for (Node<AbstractInsnNode> node : graph2.getAllNodes()) {
                AbstractInsnNode instruction = node.getInstruction();
                int opcode = instruction.getOpcode();
                if (opcode == 177 || opcode == 176 || opcode == 173 || opcode == 172 || opcode == 175 || opcode == 174) {
                    node.setExit$lint_checks(true);
                    continue;
                }
                if (!node.isLeaf()) continue;
                node.setExit$lint_checks(true);
            }
            return graph2;
        }

        @NotNull
        public final ControlFlowGraph<UElement> create(@NotNull UMethod method, @NotNull Builder builder) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            var graph2 = new ControlFlowGraph<UElement>(){
                private final Map<KtLambdaExpression, Node<UElement>> lambdas;
                {
                    this.lambdas = new LinkedHashMap<K, V>();
                }

                public Node<UElement> getOrCreate$lint_checks(UElement instruction) {
                    PsiElement sourcePsi;
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    if (instruction instanceof ULambdaExpression && (sourcePsi = instruction.getSourcePsi()) instanceof KtLambdaExpression) {
                        Node<UElement> node = this.lambdas.get(sourcePsi);
                        if (node != null) {
                            Node<UElement> it = node;
                            boolean bl = false;
                            return it;
                        }
                        Node<UElement> node2 = super.getOrCreate$lint_checks(instruction);
                        this.lambdas.put((KtLambdaExpression)sourcePsi, node2);
                        return node2;
                    }
                    return super.getOrCreate$lint_checks(instruction);
                }
            };
            graph2.getOrCreate$lint_checks((UElement)method).setExit$lint_checks(true);
            UMethod exitMarker = method;
            ArrayDeque nextStack = new ArrayDeque();
            nextStack.addLast((Object)exitMarker);
            Ref.ObjectRef pendingType = new Ref.ObjectRef();
            List pending = new ArrayList();
            Map pendingJumps = new LinkedHashMap();
            Map pendingThrows = new LinkedHashMap();
            boolean isKotlin = Lint.isKotlin((Language)method.getLang());
            UExpression uExpression = method.getUastBody();
            if (uExpression != null) {
                UExpression it = uExpression;
                boolean bl = false;
                graph2.getOrCreate$lint_checks((UElement)it);
            }
            UExpression uExpression2 = method.getUastBody();
            if (uExpression2 != null) {
                uExpression2.accept((UastVisitor)new AbstractUastVisitor(pending, method, graph2, (Ref.ObjectRef<String>)pendingType, pendingJumps, pendingThrows, isKotlin, builder, exitMarker){
                    private Map<PsiElement, UElement> functions;
                    private Map<UElement, List<UElement>> lambdaExits;
                    final /* synthetic */ List<UElement> $pending;
                    final /* synthetic */ UMethod $method;
                    final /* synthetic */ create.graph.1 $graph;
                    final /* synthetic */ Ref.ObjectRef<String> $pendingType;
                    final /* synthetic */ Map<UElement, List<UElement>> $pendingJumps;
                    final /* synthetic */ Map<UElement, List<Pair<UElement, List<String>>>> $pendingThrows;
                    final /* synthetic */ boolean $isKotlin;
                    final /* synthetic */ Builder $builder;
                    final /* synthetic */ UMethod $exitMarker;
                    {
                        this.$pending = $pending;
                        this.$method = $method;
                        this.$graph = $graph;
                        this.$pendingType = $pendingType;
                        this.$pendingJumps = $pendingJumps;
                        this.$pendingThrows = $pendingThrows;
                        this.$isKotlin = $isKotlin;
                        this.$builder = $builder;
                        this.$exitMarker = $exitMarker;
                    }

                    public boolean visitElement(UElement node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (node instanceof UIdentifier || node instanceof USimpleNameReferenceExpression) {
                            return true;
                        }
                        return super.visitElement(node);
                    }

                    public void afterVisitElement(UElement node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (node instanceof UIdentifier || node instanceof USimpleNameReferenceExpression) {
                            return;
                        }
                        this.flushPending(node);
                        if (!(node instanceof UReturnExpression) && !(node instanceof UThrowExpression)) {
                            this.$pending.add(node);
                        }
                    }

                    private final void flushPending(UElement node) {
                        for (UElement prev : this.$pending) {
                            if (Intrinsics.areEqual((Object)node, (Object)this.$method.getUastBody())) {
                                this.$graph.addSuccessor$lint_checks(prev, this.$method, (String)this.$pendingType.element);
                                continue;
                            }
                            this.$graph.addSuccessor$lint_checks(prev, node, (String)this.$pendingType.element);
                        }
                        this.$pending.clear();
                        this.$pendingType.element = null;
                    }

                    private final void addJumpTarget(UElement from, UElement jumpTarget) {
                        List list = this.$pendingJumps.get(jumpTarget);
                        if (list == null) {
                            List list2 = new ArrayList<E>();
                            Map<UElement, List<UElement>> map = this.$pendingJumps;
                            List it = list2;
                            boolean bl = false;
                            map.put(jumpTarget, it);
                            list = list2;
                        }
                        List list3 = list;
                        list3.add((UElement)from);
                    }

                    private final void processPendingJumps(UElement node) {
                        block0: {
                            List<UElement> list = this.$pendingJumps.remove(node);
                            if (list == null) break block0;
                            List<UElement> list2 = list;
                            List<UElement> list3 = this.$pending;
                            Collection p0 = list2;
                            boolean $i$f$processPendingJumps$stub_for_inlining = false;
                            boolean bl = false;
                            list3.addAll(p0);
                        }
                    }

                    private final boolean addThrowingCall(UElement node, List<String> types, UElement context) {
                        UElement uElement;
                        UElement curr = null;
                        curr = context;
                        while (!Intrinsics.areEqual((Object)curr, (Object)this.$method) && !(curr instanceof UTryExpression) && (uElement = curr) != null && (uElement = uElement.getUastParent()) != null) {
                            curr = uElement;
                        }
                        if (curr != null) {
                            List list = this.$pendingThrows.get(curr);
                            if (list == null) {
                                List list2 = new ArrayList<E>();
                                Map<UElement, List<Pair<UElement, List<String>>>> map = this.$pendingThrows;
                                List it = list2;
                                boolean bl = false;
                                map.put(curr, it);
                                list = list2;
                            }
                            List list3 = list;
                            list3.add((Pair<UElement, List<String>>)new Pair((Object)node, types));
                        }
                        return curr != null;
                    }

                    public boolean visitBlockExpression(UBlockExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        if (!this.$isKotlin && node.getSourcePsi() instanceof PsiSynchronizedStatement) {
                            Ref.ObjectRef lockExpression = new Ref.ObjectRef();
                            UBlockExpression block = node;
                            List expressions = node.getExpressions();
                            node.accept((UastVisitor)new AbstractUastVisitor(block, expressions, (Ref.ObjectRef<UElement>)lockExpression){
                                final /* synthetic */ UBlockExpression $block;
                                final /* synthetic */ List<UExpression> $expressions;
                                final /* synthetic */ Ref.ObjectRef<UElement> $lockExpression;
                                {
                                    this.$block = $block;
                                    this.$expressions = $expressions;
                                    this.$lockExpression = $lockExpression;
                                }

                                public boolean visitElement(UElement node) {
                                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                                    if (node.getUastParent() == this.$block && !CollectionsKt.contains((Iterable)this.$expressions, (Object)node)) {
                                        this.$lockExpression.element = node;
                                    }
                                    return super.visitElement(node);
                                }
                            });
                            UElement uElement = (UElement)lockExpression.element;
                            if (uElement != null) {
                                uElement.accept((UastVisitor)this);
                            }
                        }
                        for (UExpression element : node.getExpressions()) {
                            element.accept((UastVisitor)this);
                        }
                        return true;
                    }

                    public void afterVisitBlockExpression(UBlockExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitExpressionList(UExpressionList node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        if (this.$isKotlin && Intrinsics.areEqual((Object)node.getKind().getName(), (Object)"elvis")) {
                            for (UExpression element : node.getExpressions()) {
                                if (element instanceof UIfExpression) {
                                    this.visitIfExpression((UIfExpression)element);
                                    continue;
                                }
                                element.accept((UastVisitor)this);
                            }
                            return true;
                        }
                        for (UExpression element : node.getExpressions()) {
                            element.accept((UastVisitor)this);
                        }
                        return true;
                    }

                    public boolean visitClass(UClass node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        return true;
                    }

                    public boolean visitMethod(UMethod node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        return true;
                    }

                    public boolean visitAnnotation(UAnnotation node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        return true;
                    }

                    private final void registerLambdaElement(PsiElement psiElement, UElement element) {
                        if (psiElement == null) {
                            return;
                        }
                        Map map = this.functions;
                        if (map == null) {
                            Map map2;
                            Map it = map2 = (Map)new LinkedHashMap<K, V>();
                            boolean bl = false;
                            this.functions = it;
                            map = map2;
                        }
                        Map functions = map;
                        functions.put((PsiElement)psiElement, (UElement)element);
                    }

                    private final void registerLambdaExits(UElement element, List<? extends UElement> exits) {
                        Map map = this.lambdaExits;
                        if (map == null) {
                            Map map2;
                            Map it = map2 = (Map)new LinkedHashMap<K, V>();
                            boolean bl = false;
                            this.lambdaExits = it;
                            map = map2;
                        }
                        Map lambdaExits = map;
                        lambdaExits.put((UElement)element, exits);
                    }

                    public boolean visitVariable(UVariable node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        UExpression uastInitializer = node.getUastInitializer();
                        if (uastInitializer instanceof ULambdaExpression) {
                            this.registerLambdaElement(uastInitializer.getJavaPsi(), (UElement)node);
                            this.registerLambdaElement(node.getSourcePsi(), (UElement)node);
                            this.registerLambdaElement(node.getJavaPsi(), (UElement)node);
                            this.registerLambdaExits((UElement)node, CollectionsKt.toList((Iterable)this.$pending));
                            List before = CollectionsKt.toList((Iterable)this.$pending);
                            this.$pending.clear();
                            this.handleLambdaExpression((ULambdaExpression)uastInitializer);
                            this.registerLambdaExits((UElement)node, CollectionsKt.toList((Iterable)this.$pending));
                            this.$pending.clear();
                            this.$pending.addAll(before);
                        } else if (uastInitializer instanceof UCallableReferenceExpression) {
                            PsiElement resolved = ((UCallableReferenceExpression)uastInitializer).resolve();
                            if (resolved != null) {
                                UElement function;
                                Map<PsiElement, UElement> map = this.functions;
                                UElement uElement = function = map != null ? map.get(resolved) : null;
                                if (function != null) {
                                    this.registerLambdaElement(node.getJavaPsi(), function);
                                    this.registerLambdaElement(resolved, function);
                                }
                            }
                        } else if (uastInitializer instanceof UObjectLiteralExpression) {
                            this.registerLambdaElement(uastInitializer.getJavaPsi(), (UElement)node);
                            this.registerLambdaElement(node.getSourcePsi(), (UElement)node);
                            this.registerLambdaElement(node.getJavaPsi(), (UElement)node);
                            this.registerLambdaExits((UElement)node, CollectionsKt.toList((Iterable)this.$pending));
                            List before = CollectionsKt.toList((Iterable)this.$pending);
                            this.$pending.clear();
                            this.handleObjectLiteralExpression((UObjectLiteralExpression)uastInitializer);
                            this.registerLambdaExits((UElement)node, CollectionsKt.toList((Iterable)this.$pending));
                            this.$pending.clear();
                            this.$pending.addAll(before);
                        }
                        return super.visitVariable(node);
                    }

                    public boolean visitIfExpression(UIfExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        UExpression condition = node.getCondition();
                        condition.accept((UastVisitor)this);
                        FollowBranch branchAction = UastLiteralUtils.isTrueLiteral((UElement)((UElement)condition)) ? FollowBranch.THEN : (UastLiteralUtils.isFalseLiteral((UElement)((UElement)condition)) ? FollowBranch.ELSE : this.$builder.checkBranchPaths(condition));
                        List before = CollectionsKt.toList((Iterable)this.$pending);
                        List afterThen = CollectionsKt.emptyList();
                        if (branchAction == FollowBranch.BOTH || branchAction == FollowBranch.THEN) {
                            UExpression thenExpression = node.getThenExpression();
                            if (thenExpression != null && !(thenExpression instanceof UastEmptyExpression)) {
                                this.$pendingType.element = "then";
                                thenExpression.accept((UastVisitor)this);
                            }
                            afterThen = CollectionsKt.toList((Iterable)this.$pending);
                            if (branchAction == FollowBranch.BOTH) {
                                this.$pending.clear();
                                this.$pending.addAll(before);
                            }
                        }
                        if (branchAction == FollowBranch.BOTH || branchAction == FollowBranch.ELSE) {
                            UExpression elseExpression = node.getElseExpression();
                            if (elseExpression != null && !(elseExpression instanceof UastEmptyExpression)) {
                                this.$pendingType.element = "else";
                                elseExpression.accept((UastVisitor)this);
                            }
                            this.$pending.addAll(afterThen);
                        }
                        return true;
                    }

                    public void afterVisitIfExpression(UIfExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitTryExpression(UTryExpression node) {
                        List<Pair<UElement, List<String>>> pairs;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        PsiElement psiElement = node.getSourcePsi();
                        if (psiElement == null) {
                            return true;
                        }
                        PsiElement psiElement2 = psiElement;
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        ImplementationUtilsKt.acceptList((List)node.getResourceVariables(), (UastVisitor)((UastVisitor)this));
                        UExpression tryClause = node.getTryClause();
                        tryClause.accept((UastVisitor)this);
                        List normalExits = CollectionsKt.toMutableList((Collection)this.$pending);
                        this.$pending.clear();
                        List catchClauses = node.getCatchClauses();
                        for (UCatchClause catchClause : catchClauses) {
                            this.$pending.add((UElement)catchClause);
                            this.$pendingType.element = "catch";
                            catchClause.getBody().accept((UastVisitor)this);
                            normalExits.addAll((Collection)this.$pending);
                            this.$pending.clear();
                        }
                        this.$pending.addAll(normalExits);
                        UExpression finallyClause = node.getFinallyClause();
                        if (finallyClause != null) {
                            this.$pendingType.element = "finally";
                            finallyClause.accept((UastVisitor)this);
                            this.$pendingType.element = null;
                        }
                        if ((pairs = this.$pendingThrows.remove(node)) != null) {
                            for (Pair<UElement, List<String>> pair : pairs) {
                                UElement from = (UElement)pair.component1();
                                List types = (List)pair.component2();
                                UElement prev = from;
                                UElement curr = from.getUastParent();
                                while (curr != node) {
                                    prev = curr;
                                    UElement uElement = curr;
                                    if (uElement == null || (uElement = uElement.getUastParent()) == null) break;
                                    curr = uElement;
                                }
                                if (prev == tryClause && !((Collection)catchClauses).isEmpty()) {
                                    List unhandled = new ArrayList<E>();
                                    for (String type : types) {
                                        boolean caught = false;
                                        if (Intrinsics.areEqual((Object)type, (Object)"finally")) {
                                            boolean bl;
                                            boolean bl2 = bl = types.size() == 1;
                                            if (!_Assertions.ENABLED || bl) break;
                                            String string = "Assertion failed";
                                            throw new AssertionError((Object)string);
                                        }
                                        PsiClass typeClass = JavaPsiFacade.getInstance((Project)psiElement2.getProject()).findClass(type, psiElement2.getResolveScope());
                                        block4: for (UCatchClause catchClause : catchClauses) {
                                            for (PsiType psiType : catchClause.getTypes()) {
                                                String catchType;
                                                Intrinsics.checkNotNullExpressionValue((Object)psiType.getCanonicalText(), (String)"getCanonicalText(...)");
                                                if (Intrinsics.areEqual((Object)catchType, (Object)type) || InheritanceUtil.isInheritor((PsiClass)typeClass, (String)catchType)) {
                                                    caught = true;
                                                    this.$graph.addException$lint_checks(from, catchClause, type);
                                                    break block4;
                                                }
                                                if (!InheritanceUtil.isInheritor((PsiType)psiType, (String)type)) continue;
                                                this.$graph.addException$lint_checks(from, catchClause, catchType);
                                            }
                                        }
                                        if (caught) continue;
                                        unhandled.add(type);
                                    }
                                    if (!(!((Collection)unhandled).isEmpty())) continue;
                                    if (finallyClause != null) {
                                        this.$graph.addException$lint_checks(from, finallyClause, "finally");
                                        for (UElement finallyExit : this.$pending) {
                                            this.addThrowingCall(finallyExit, unhandled, node.getUastParent());
                                        }
                                        continue;
                                    }
                                    this.addThrowingCall(from, unhandled, node.getUastParent());
                                    continue;
                                }
                                if (Intrinsics.areEqual((Object)prev, (Object)finallyClause)) {
                                    this.addThrowingCall(from, types, node.getUastParent());
                                    continue;
                                }
                                if (finallyClause == null) continue;
                                if (normalExits.contains(from)) {
                                    this.$graph.addSuccessor$lint_checks(from, finallyClause, "finally");
                                }
                                for (String type : types) {
                                    this.$graph.addException$lint_checks(from, finallyClause, type);
                                }
                                for (UElement finallyExit : this.$pending) {
                                    this.addThrowingCall(finallyExit, types, node.getUastParent());
                                }
                            }
                        }
                        return true;
                    }

                    public void afterVisitTryExpression(UTryExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (_Assertions.ENABLED) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                    }

                    private final void addExceptions(UElement node, UCallExpression call, PsiMethod method) {
                        if (method == null) {
                            return;
                        }
                        List<String> types = this.$builder.methodThrows((UElement)call, method);
                        if (types != null) {
                            this.addThrowingCall(node, types, node.getUastParent());
                        }
                    }

                    static /* synthetic */ void addExceptions$default(create.2 var0, UElement uElement, UCallExpression uCallExpression, PsiMethod psiMethod, int n, Object object) {
                        if ((n & 4) != 0) {
                            psiMethod = uCallExpression.resolve();
                        }
                        var0.addExceptions(uElement, uCallExpression, psiMethod);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    private final UElement findInvokedLambda(PsiElement psiElement, UCallExpression node, PsiMethod resolved) {
                        boolean bl;
                        Map<PsiElement, UElement> map;
                        block18: {
                            UElement this_$iv$iv;
                            Map<PsiElement, UElement> map2 = this.functions;
                            if (map2 == null) {
                                return null;
                            }
                            map = map2;
                            UElement uElement = map.get(psiElement);
                            if (uElement != null) {
                                return uElement;
                            }
                            uElement = map.get(LightClassUtilsKt.getUnwrapped((PsiElement)psiElement));
                            if (uElement != null) {
                                return uElement;
                            }
                            PsiElement sourcePsi = node.getSourcePsi();
                            if (sourcePsi instanceof KtElement) {
                                KtElement useSiteElement$iv = (KtElement)sourcePsi;
                                boolean $i$f$analyze = false;
                                Project project = useSiteElement$iv.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                                KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                                boolean $i$f$analyze2 = false;
                                KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv);
                                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv);
                                try {
                                    Unit $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv2;
                                    Object lock$iv$iv;
                                    Object object = lock$iv$iv = new Object();
                                    synchronized (object) {
                                        PsiElement psi;
                                        KaFunctionSymbol symbol;
                                        boolean bl2 = false;
                                        KaSession $this$findInvokedLambda_u24lambda_u247 = analysisSession$iv$iv;
                                        boolean bl3 = false;
                                        KaFunctionSymbol kaFunctionSymbol = symbol = AnalysisApiLintUtilsKt.getFunctionLikeSymbol($this$findInvokedLambda_u24lambda_u247, (KtElement)sourcePsi);
                                        Object object2 = psi = kaFunctionSymbol != null ? kaFunctionSymbol.getPsi() : null;
                                        if (psi != null) {
                                            UElement uElement2 = map.get(psi);
                                            if (uElement2 != null) {
                                                UElement it = uElement2;
                                                boolean bl4 = false;
                                                UElement uElement3 = it;
                                                // MONITOREXIT @DISABLED, blocks:[0, 4, 11, 12, 13] lbl38 : MonitorExitStatement: MONITOREXIT : var12_24
                                                UElement uElement4 = uElement3;
                                                return uElement4;
                                            }
                                        }
                                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv2 = Unit.INSTANCE;
                                    }
                                    lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv2;
                                }
                                finally {
                                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv);
                                }
                            }
                            PsiMethod psiMethod = resolved;
                            PsiClass containingClass = psiMethod != null ? psiMethod.getContainingClass() : null;
                            if (containingClass == null) return null;
                            if (Intrinsics.areEqual((Object)resolved.getName(), (Object)"invoke")) {
                                String string = containingClass.getQualifiedName();
                                boolean bl5 = string != null ? StringsKt.startsWith$default((String)string, (String)"kotlin.jvm.functions.Function", (boolean)false, (int)2, null) : false;
                                if (bl5) {
                                    PsiElement variable;
                                    UExpression uExpression = node.getReceiver();
                                    Object object = variable = uExpression != null ? UastUtils.tryResolve((UElement)((UElement)uExpression)) : null;
                                    if (variable != null && (this_$iv$iv = map.get(variable)) != null) {
                                        return this_$iv$iv;
                                    }
                                }
                            }
                            PsiAnnotation[] psiAnnotationArray = containingClass.getAnnotations();
                            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                            Object[] $this$any$iv = psiAnnotationArray;
                            boolean $i$f$any = false;
                            for (Object element$iv : $this$any$iv) {
                                PsiAnnotation it = (PsiAnnotation)element$iv;
                                boolean bl6 = false;
                                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"java.lang.FunctionalInterface")) continue;
                                bl = true;
                                break block18;
                            }
                            bl = false;
                        }
                        if (!bl) return null;
                        UExpression uExpression = node.getReceiver();
                        PsiElement variable = uExpression != null ? UastUtils.tryResolve((UElement)((UElement)uExpression)) : null;
                        if (variable == null) return null;
                        UElement uElement = map.get(variable);
                        if (uElement == null) return null;
                        return uElement;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    private final void handleLocalOrLambdaInvocations(UCallExpression node, PsiMethod resolved) {
                        PsiElement psiElement;
                        PsiMethod psiMethod = resolved;
                        if (psiMethod != null) {
                            psiElement = (PsiElement)psiMethod;
                        } else {
                            UExpression uExpression = node.getReceiver();
                            UExpression uExpression2 = uExpression;
                            if (uExpression == null) return;
                            PsiElement psiElement2 = UastUtils.tryResolve((UElement)((UElement)uExpression2));
                            uExpression2 = psiElement2;
                            if (psiElement2 == null) return;
                            UExpression uExpression3 = uExpression2;
                            boolean bl = false;
                            Map<PsiElement, UElement> map = this.functions;
                            if (map == null) return;
                            UElement uElement = map.get(uExpression3);
                            uExpression2 = uElement;
                            if (uElement == null) return;
                            PsiElement psiElement3 = uExpression2.getSourcePsi();
                            psiElement = psiElement3;
                            if (psiElement3 == null) {
                                return;
                            }
                        }
                        PsiElement psiElement4 = psiElement;
                        UElement localFunc = this.findInvokedLambda(psiElement4, node, resolved);
                        if (localFunc == null) return;
                        if (!(localFunc instanceof UVariable)) return;
                        if (!(((UVariable)localFunc).getUastInitializer() instanceof ULambdaExpression)) {
                            if (!(((UVariable)localFunc).getUastInitializer() instanceof UObjectLiteralExpression)) return;
                        }
                        ControlFlowGraph.addSuccessor$lint_checks$default(this.$graph, node, ((UVariable)localFunc).getUastInitializer(), null, 4, null);
                        Map<UElement, List<UElement>> map = this.lambdaExits;
                        Object object = map;
                        if (map == null) return;
                        List<UElement> list = object.get(localFunc);
                        object = list;
                        if (list == null) return;
                        Object object2 = object;
                        List<UElement> list2 = this.$pending;
                        Object object3 = object2;
                        boolean bl = false;
                        list2.clear();
                        list2.addAll((Collection)object3);
                    }

                    public boolean visitCallExpression(UCallExpression node) {
                        boolean bl;
                        block14: {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            this.flushPending((UElement)node);
                            PsiMethod resolved = node.resolve();
                            if (resolved != null && UastLintUtilsKt.callNeverReturns((UCallExpression)node)) {
                                this.handleThrow((UElement)node, null);
                                return super.visitCallExpression(node);
                            }
                            this.$pending.add((UElement)node);
                            if (this.functions != null) {
                                this.handleLocalOrLambdaInvocations(node, resolved);
                            }
                            if (this.$builder.getTrackCallThrows()) {
                                this.addExceptions((UElement)node, node, resolved);
                            }
                            if ((node.getValueArguments().size() == 1 || node.getValueArguments().size() == 2) && CollectionsKt.last((List)node.getValueArguments()) instanceof ULambdaExpression && (resolved != null && UastLintUtilsKt.isScopingFunction((PsiMethod)resolved) || resolved == null && UastLintUtilsKt.isScopingFunction((UCallExpression)node))) {
                                for (UExpression argument : node.getValueArguments()) {
                                    if (argument instanceof ULambdaExpression) {
                                        this.handleLambdaExpression((ULambdaExpression)argument);
                                        continue;
                                    }
                                    argument.accept((UastVisitor)this);
                                }
                                return true;
                            }
                            if (CollectionsKt.lastOrNull((List)node.getValueArguments()) instanceof ULambdaExpression && this.isComposeFunction(resolved) && node.getSourcePsi() instanceof KtCallExpression) {
                                PsiElement psiElement = node.getSourcePsi();
                                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                                List list = ((KtCallExpression)psiElement).getValueArguments();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
                                KtValueArgument last = (KtValueArgument)CollectionsKt.lastOrNull((List)list);
                                if (last != null && !last.isNamed()) {
                                    List<E> others = node.getValueArguments().subList(0, node.getValueArguments().size() - 1);
                                    if (!((Collection)others).isEmpty()) {
                                        this.visitCallArguments(node, others);
                                    }
                                    Object object = CollectionsKt.last((List)node.getValueArguments());
                                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.uast.ULambdaExpression");
                                    this.handleLambdaExpression((ULambdaExpression)object);
                                    return true;
                                }
                                create.2.visitCallArguments$default(this, node, null, 2, null);
                                return true;
                            }
                            Iterable $this$any$iv = node.getValueArguments();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    UExpression it = (UExpression)element$iv;
                                    boolean bl2 = false;
                                    if (!(it instanceof ULambdaExpression)) continue;
                                    bl = true;
                                    break block14;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            boolean bl3;
                            boolean bl4 = bl3 = this.$pending.size() == 1 && Intrinsics.areEqual((Object)this.$pending.get(0), (Object)node);
                            if (_Assertions.ENABLED && !bl3) {
                                String string = "Assertion failed";
                                throw new AssertionError((Object)string);
                            }
                            create.2.visitCallArguments$default(this, node, null, 2, null);
                            return true;
                        }
                        return super.visitCallExpression(node);
                    }

                    private final boolean isComposeFunction(PsiMethod method) {
                        boolean bl;
                        block2: {
                            if (method == null) {
                                return false;
                            }
                            PsiAnnotation[] psiAnnotationArray = method.getAnnotations();
                            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                            Object[] $this$any$iv = psiAnnotationArray;
                            boolean $i$f$any = false;
                            for (Object element$iv : $this$any$iv) {
                                PsiAnnotation it = (PsiAnnotation)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"androidx.compose.runtime.Composable")) continue;
                                bl = true;
                                break block2;
                            }
                            bl = false;
                        }
                        return bl;
                    }

                    private final void visitCallArguments(UCallExpression node, List<? extends UExpression> arguments) {
                        if (this.$builder.getCallLambdaParameters()) {
                            for (UExpression uExpression : arguments) {
                                if (!(uExpression instanceof ULambdaExpression)) continue;
                                this.$pending.clear();
                                this.$pending.add((UElement)node);
                                this.handleLambdaExpression((ULambdaExpression)uExpression);
                                for (UElement exit : this.$pending) {
                                    if (Intrinsics.areEqual((Object)exit, (Object)node)) continue;
                                    ControlFlowGraph.addSuccessor$lint_checks$default(this.$graph, exit, node, null, 4, null);
                                }
                            }
                            this.$pending.clear();
                            this.$pending.add((UElement)node);
                        }
                        for (UExpression uExpression : arguments) {
                            uExpression.accept((UastVisitor)this);
                        }
                    }

                    static /* synthetic */ void visitCallArguments$default(create.2 var0, UCallExpression uCallExpression, List list, int n, Object object) {
                        if ((n & 2) != 0) {
                            list = uCallExpression.getValueArguments();
                        }
                        var0.visitCallArguments(uCallExpression, list);
                    }

                    public void afterVisitCallExpression(UCallExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    private final void handleLambdaExpression(ULambdaExpression node) {
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        node.getBody().accept((UastVisitor)this);
                        this.processPendingJumps((UElement)node);
                    }

                    public boolean visitLambdaExpression(ULambdaExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        return true;
                    }

                    public void afterVisitLambdaExpression(ULambdaExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitLabeledExpression(ULabeledExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        node.getExpression().accept((UastVisitor)this);
                        return true;
                    }

                    public void afterVisitLabeledExpression(ULabeledExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitPrefixExpression(UPrefixExpression node) {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (!this.$builder.getTrackCallThrows()) break block1;
                            UCallExpression uCallExpression = UImplicitCallExpressionKt.asCall((UUnaryExpression)((UUnaryExpression)node));
                            if (uCallExpression != null) {
                                UCallExpression it = uCallExpression;
                                boolean bl = false;
                                create.2.addExceptions$default(this, (UElement)node, it, null, 4, null);
                            }
                        }
                        return super.visitPrefixExpression(node);
                    }

                    public boolean visitPostfixExpression(UPostfixExpression node) {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (!this.$builder.getTrackCallThrows()) break block1;
                            UCallExpression uCallExpression = UImplicitCallExpressionKt.asCall((UUnaryExpression)((UUnaryExpression)node));
                            if (uCallExpression != null) {
                                UCallExpression it = uCallExpression;
                                boolean bl = false;
                                create.2.addExceptions$default(this, (UElement)node, it, null, 4, null);
                            }
                        }
                        return super.visitPostfixExpression(node);
                    }

                    public boolean visitUnaryExpression(UUnaryExpression node) {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (!this.$builder.getTrackCallThrows()) break block1;
                            UCallExpression uCallExpression = UImplicitCallExpressionKt.asCall((UUnaryExpression)node);
                            if (uCallExpression != null) {
                                UCallExpression it = uCallExpression;
                                boolean bl = false;
                                create.2.addExceptions$default(this, (UElement)node, it, null, 4, null);
                            }
                        }
                        return super.visitUnaryExpression(node);
                    }

                    public boolean visitBinaryExpression(UBinaryExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (this.$builder.getTrackCallThrows()) {
                            UCallExpression uCallExpression = UImplicitCallExpressionKt.asCall((UBinaryExpression)node);
                            if (uCallExpression != null) {
                                UCallExpression it = uCallExpression;
                                boolean bl = false;
                                create.2.addExceptions$default(this, (UElement)node, it, null, 4, null);
                            }
                        }
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        node.getLeftOperand().accept((UastVisitor)this);
                        boolean shortCircuit = Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.LOGICAL_AND) || Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.LOGICAL_OR);
                        List list = shortCircuit ? CollectionsKt.toList((Iterable)this.$pending) : CollectionsKt.emptyList();
                        node.getRightOperand().accept((UastVisitor)this);
                        this.$pending.addAll(list);
                        return true;
                    }

                    public boolean visitArrayAccessExpression(UArrayAccessExpression node) {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (!this.$builder.getTrackCallThrows()) break block1;
                            UCallExpression uCallExpression = UImplicitCallExpressionKt.asCall((UArrayAccessExpression)node);
                            if (uCallExpression != null) {
                                UCallExpression it = uCallExpression;
                                boolean bl = false;
                                create.2.addExceptions$default(this, (UElement)node, it, null, 4, null);
                            }
                        }
                        return super.visitArrayAccessExpression(node);
                    }

                    public void afterVisitThrowExpression(UThrowExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        PsiType type = node.getThrownExpression().getExpressionType();
                        this.handleThrow((UElement)node, type);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private final void handleThrow(UElement node, PsiType type) {
                        Object object;
                        UElement uElement;
                        create.2 v0;
                        block3: {
                            block2: {
                                void p0;
                                v0 = this;
                                uElement = node;
                                object = type;
                                if (object == null || (object = object.getCanonicalText()) == null) break block2;
                                Object object2 = object;
                                UElement uElement2 = uElement;
                                create.2 var6_5 = v0;
                                boolean $i$f$handleThrow$stub_for_inlining$20 = false;
                                boolean bl = false;
                                List list = CollectionsKt.listOf((Object)p0);
                                v0 = var6_5;
                                uElement = uElement2;
                                List list2 = list;
                                object = list2;
                                if (list2 != null) break block3;
                            }
                            object = this.$builder.getDefaultMethodExceptions(node);
                        }
                        v0.addThrowingCall(uElement, (List<String>)object, node.getUastParent());
                    }

                    private final void afterVisitJumpExpression(UJumpExpression node, boolean isBreak) {
                        this.flushPending((UElement)node);
                        UElement jumpTarget = node.getJumpTarget();
                        if (jumpTarget != null) {
                            UElement uElement = UastLintUtilsKt.findCommonParent((UElement)((UElement)node), (UElement)jumpTarget);
                            Intrinsics.checkNotNull((Object)uElement);
                            UElement common = uElement;
                            UElement curr = (UElement)node;
                            while (curr != common) {
                                UExpression finallyClause;
                                UElement tryExpression = curr;
                                if (tryExpression instanceof UTryExpression && (finallyClause = ((UTryExpression)tryExpression).getFinallyClause()) != null) {
                                    this.addThrowingCall((UElement)node, CollectionsKt.listOf((Object)"finally"), (UElement)finallyClause);
                                    return;
                                }
                                if (curr.getUastParent() == null) break;
                            }
                            if (isBreak) {
                                this.addJumpTarget((UElement)node, jumpTarget);
                            } else {
                                UElement n = (UElement)node;
                                UElement target2 = jumpTarget;
                                while (true) {
                                    if (Intrinsics.areEqual((Object)n, (Object)jumpTarget)) {
                                        target2 = n;
                                        break;
                                    }
                                    if (n.getUastParent() == null) break;
                                }
                                if (target2 instanceof UForExpression && ((UForExpression)target2).getUpdate() != null) {
                                    target2 = (UElement)((UForExpression)target2).getUpdate();
                                } else if (target2 instanceof UDoWhileExpression) {
                                    target2 = (UElement)((UDoWhileExpression)target2).getCondition();
                                }
                                this.$graph.addSuccessor$lint_checks(node, target2, node.getLabel());
                            }
                        } else {
                            this.$graph.addSuccessor$lint_checks(node, this.$exitMarker, node.getLabel());
                        }
                    }

                    static /* synthetic */ void afterVisitJumpExpression$default(create.2 var0, UJumpExpression uJumpExpression, boolean bl, int n, Object object) {
                        if ((n & 2) != 0) {
                            bl = true;
                        }
                        var0.afterVisitJumpExpression(uJumpExpression, bl);
                    }

                    public void afterVisitReturnExpression(UReturnExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        create.2.afterVisitJumpExpression$default(this, (UJumpExpression)node, false, 2, null);
                    }

                    public void afterVisitBreakExpression(UBreakExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        create.2.afterVisitJumpExpression$default(this, (UJumpExpression)node, false, 2, null);
                    }

                    public void afterVisitContinueExpression(UContinueExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.afterVisitJumpExpression((UJumpExpression)node, false);
                    }

                    public void afterVisitYieldExpression(UYieldExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        create.2.afterVisitJumpExpression$default(this, (UJumpExpression)node, false, 2, null);
                        super.afterVisitYieldExpression(node);
                    }

                    public boolean visitForExpression(UForExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        UExpression uExpression = node.getDeclaration();
                        if (uExpression != null) {
                            uExpression.accept((UastVisitor)this);
                        }
                        UExpression uExpression2 = node.getCondition();
                        if (uExpression2 != null) {
                            uExpression2.accept((UastVisitor)this);
                        }
                        List conditionExit = CollectionsKt.toList((Iterable)this.$pending);
                        node.getBody().accept((UastVisitor)this);
                        UExpression uExpression3 = node.getUpdate();
                        if (uExpression3 != null) {
                            uExpression3.accept((UastVisitor)this);
                        }
                        UExpression uExpression4 = node.getUpdate();
                        UExpression uExpression5 = node.getCondition();
                        if (uExpression5 == null) {
                            uExpression5 = (UExpression)node;
                        }
                        this.$graph.addSuccessor$lint_checks(uExpression4, uExpression5, "loop");
                        UExpression uExpression6 = node.getCondition();
                        if (uExpression6 != null) {
                            UExpression uExpression7 = uExpression6;
                            List<UElement> list = this.$pending;
                            UExpression it = uExpression7;
                            boolean bl = false;
                            list.add((UElement)it);
                        }
                        this.$pending.clear();
                        this.processPendingJumps((UElement)node);
                        this.$pending.addAll(conditionExit);
                        return true;
                    }

                    public void afterVisitForExpression(UForExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitForEachExpression(UForEachExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        node.getBody().accept((UastVisitor)this);
                        for (UElement element : this.$pending) {
                            this.$graph.addSuccessor$lint_checks(element, node, "loop");
                        }
                        this.$pending.clear();
                        this.$pending.add((UElement)node);
                        this.processPendingJumps((UElement)node);
                        return true;
                    }

                    public void afterVisitForEachExpression(UForEachExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitWhileExpression(UWhileExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        node.getBody().accept((UastVisitor)this);
                        for (UElement element : this.$pending) {
                            this.$graph.addSuccessor$lint_checks(element, node, "loop");
                        }
                        this.$pending.clear();
                        this.$pending.add((UElement)node);
                        this.processPendingJumps((UElement)node);
                        return true;
                    }

                    public void afterVisitWhileExpression(UWhileExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitDoWhileExpression(UDoWhileExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        node.getBody().accept((UastVisitor)this);
                        node.getCondition().accept((UastVisitor)this);
                        for (UElement element : this.$pending) {
                            this.$graph.addSuccessor$lint_checks(element, node, "loop");
                        }
                        this.processPendingJumps((UElement)node);
                        return true;
                    }

                    public void afterVisitDoWhileExpression(UDoWhileExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitSwitchExpression(USwitchExpression node) {
                        UExpression switchExpression;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        UExpression uExpression = switchExpression = node.getExpression();
                        if (uExpression != null) {
                            uExpression.accept((UastVisitor)this);
                        }
                        boolean fallthrough = Lint.isJava((Language)node.getLang());
                        List exits = new ArrayList<E>();
                        List pendingBefore = CollectionsKt.toMutableList((Collection)this.$pending);
                        List fallthroughNodes = new ArrayList<E>();
                        boolean randomAccess = !this.$isKotlin;
                        List prevCaseExits = pendingBefore;
                        boolean hasDefault = false;
                        for (UExpression expression : node.getBody().getExpressions()) {
                            FollowBranch followBranch;
                            List cases;
                            USwitchClauseExpressionWithBody bodyExpression;
                            block23: {
                                block22: {
                                    boolean bl;
                                    block21: {
                                        Intrinsics.checkNotNull((Object)expression, (String)"null cannot be cast to non-null type org.jetbrains.uast.USwitchClauseExpression");
                                        USwitchClauseExpression clauseExpression = (USwitchClauseExpression)expression;
                                        bodyExpression = clauseExpression instanceof USwitchClauseExpressionWithBody ? (USwitchClauseExpressionWithBody)clauseExpression : null;
                                        cases = clauseExpression.getCaseValues();
                                        if (cases.isEmpty()) break block22;
                                        Iterable $this$any$iv = cases;
                                        boolean $i$f$any = false;
                                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                            bl = false;
                                        } else {
                                            for (T element$iv : $this$any$iv) {
                                                UExpression it = (UExpression)element$iv;
                                                boolean bl2 = false;
                                                if (!Intrinsics.areEqual((Object)it.asRenderString(), (Object)"else")) continue;
                                                bl = true;
                                                break block21;
                                            }
                                            bl = false;
                                        }
                                    }
                                    if (!bl) break block23;
                                }
                                hasDefault = true;
                            }
                            if (switchExpression == null && cases.size() == 1) {
                                FollowBranch branch = this.$builder.checkBranchPaths((UExpression)cases.get(0));
                                if (branch == FollowBranch.ELSE) continue;
                                followBranch = branch;
                            } else {
                                followBranch = FollowBranch.BOTH;
                            }
                            FollowBranch branch = followBranch;
                            this.$pending.clear();
                            if (randomAccess) {
                                this.$pending.addAll(pendingBefore);
                            } else {
                                this.$pending.addAll(prevCaseExits);
                            }
                            for (UExpression uExpression2 : cases) {
                                uExpression2.accept((UastVisitor)this);
                            }
                            if (!randomAccess) {
                                prevCaseExits = CollectionsKt.toList((Iterable)this.$pending);
                            }
                            if (switchExpression == null) {
                                boolean bl;
                                boolean bl3 = bl = !fallthrough;
                                if (_Assertions.ENABLED && !bl) {
                                    String string = "Assertion failed";
                                    throw new AssertionError((Object)string);
                                }
                                pendingBefore.clear();
                                pendingBefore.addAll((Collection)this.$pending);
                            }
                            if (bodyExpression != null) {
                                this.$pending.addAll(fallthroughNodes);
                                fallthroughNodes.clear();
                                bodyExpression.accept((UastVisitor)this);
                            }
                            if (fallthrough) {
                                fallthroughNodes.addAll((Collection)this.$pending);
                            } else {
                                exits.addAll((Collection)this.$pending);
                                this.$pending.clear();
                            }
                            if (branch != FollowBranch.THEN) continue;
                            hasDefault = true;
                            break;
                        }
                        if (!hasDefault) {
                            this.$pending.addAll(pendingBefore);
                        }
                        this.$pending.addAll(fallthroughNodes);
                        this.$pending.addAll(exits);
                        this.afterVisitSwitchExpression(node);
                        return true;
                    }

                    public void afterVisitSwitchExpression(USwitchExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.processPendingJumps((UElement)node);
                    }

                    public boolean visitSwitchClauseExpression(USwitchClauseExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (node instanceof USwitchClauseExpressionWithBody) {
                            ((USwitchClauseExpressionWithBody)node).getBody().accept((UastVisitor)this);
                        }
                        return true;
                    }

                    public void afterVisitSwitchClauseExpression(USwitchClauseExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitObjectLiteralExpression(UObjectLiteralExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        return true;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private final void handleObjectLiteralExpression(UObjectLiteralExpression node) {
                        block5: {
                            void $this$filterTo$iv$iv;
                            void $this$filterTo$iv$iv2;
                            this.flushPending((UElement)node);
                            this.$pending.add((UElement)node);
                            create.2.visitCallArguments$default(this, (UCallExpression)node, null, 2, null);
                            UClass declaration = node.getDeclaration();
                            UMethod[] $this$filter$iv = declaration.getMethods();
                            boolean $i$f$filter = false;
                            UMethod[] uMethodArray = $this$filter$iv;
                            UMethod[] destination$iv$iv = (UMethod[])new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            int n = ((void)$this$filterTo$iv$iv2).length;
                            for (int i = 0; i < n; ++i) {
                                void element$iv$iv;
                                void it = element$iv$iv = $this$filterTo$iv$iv2[i];
                                boolean bl = false;
                                if (!it.isConstructor()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List constructors = (List)destination$iv$iv;
                            if (constructors.size() == 1) {
                                UExpression uExpression = ((UMethod)constructors.get(0)).getUastBody();
                                if (uExpression != null) {
                                    uExpression.accept((UastVisitor)this);
                                }
                            }
                            UMethod[] $this$filter$iv2 = declaration.getMethods();
                            boolean $i$f$filter2 = false;
                            destination$iv$iv = $this$filter$iv2;
                            Collection destination$iv$iv2 = new ArrayList<E>();
                            boolean $i$f$filterTo2 = false;
                            int n2 = ((void)$this$filterTo$iv$iv).length;
                            for (n = 0; n < n2; ++n) {
                                void element$iv$iv;
                                void it = element$iv$iv = $this$filterTo$iv$iv[n];
                                boolean bl = false;
                                if (!(!it.isConstructor())) continue;
                                destination$iv$iv2.add(element$iv$iv);
                            }
                            List methods = (List)destination$iv$iv2;
                            if (methods.size() != 1) break block5;
                            UExpression uExpression = ((UMethod)methods.get(0)).getUastBody();
                            if (uExpression != null) {
                                uExpression.accept((UastVisitor)this);
                            }
                        }
                    }

                    public void afterVisitObjectLiteralExpression(UObjectLiteralExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitParameter(UParameter node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        return true;
                    }

                    public void afterVisitParameter(UParameter node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    private final boolean isSafeExpression(UQualifiedReferenceExpression $this$isSafeExpression) {
                        return this.$isKotlin && $this$isSafeExpression.getSourcePsi() instanceof KtSafeQualifiedExpression;
                    }

                    private final boolean isSafeExpression(UElement $this$isSafeExpression) {
                        return this.$isKotlin && $this$isSafeExpression instanceof UQualifiedReferenceExpression && this.isSafeExpression((UQualifiedReferenceExpression)$this$isSafeExpression);
                    }

                    public boolean visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        this.flushPending((UElement)node);
                        this.$pending.add((UElement)node);
                        if (this.isSafeExpression(node)) {
                            UElement parent;
                            UExpression receiver = node.getReceiver();
                            receiver.accept((UastVisitor)this);
                            UElement outer = (UElement)node;
                            UElement curr = (UElement)node;
                            while (this.isSafeExpression(parent = curr.getUastParent())) {
                                Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.uast.UQualifiedReferenceExpression");
                                outer = (UElement)((UQualifiedReferenceExpression)parent);
                                curr = parent;
                            }
                            for (UElement exit : this.$pending) {
                                this.addJumpTarget(exit, outer);
                            }
                            node.getSelector().accept((UastVisitor)this);
                            this.processPendingJumps((UElement)node);
                            return true;
                        }
                        return super.visitQualifiedReferenceExpression(node);
                    }

                    public void afterVisitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                        List<String> types;
                        PsiElement property;
                        PsiElement resolved;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (this.$isKotlin && (resolved = node.resolve()) instanceof PsiMethod && (property = LightClassUtilsKt.getUnwrapped((PsiElement)resolved)) instanceof KtProperty && (((KtProperty)property).hasDelegate() || PropertyTranslatorKt.hasCustomGetter((KtProperty)((KtProperty)property)) || PropertyTranslatorKt.hasCustomSetter((KtProperty)((KtProperty)property))) && (types = this.$builder.methodThrows((UElement)node, (PsiMethod)resolved)) != null) {
                            this.flushPending((UElement)node);
                            this.$pending.add((UElement)node);
                            this.addThrowingCall((UElement)node, types, node.getUastParent());
                        }
                        return true;
                    }

                    public void afterVisitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public boolean visitLiteralExpression(ULiteralExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        return true;
                    }

                    public void afterVisitLiteralExpression(ULiteralExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    }

                    public void afterVisitPolyadicExpression(UPolyadicExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (node.getOperands().size() == 1 && node.getSourcePsi() instanceof KtStringTemplateExpression) {
                            return;
                        }
                        super.afterVisitPolyadicExpression(node);
                    }
                });
            }
            for (List sources : pendingJumps.values()) {
                for (UElement source : sources) {
                    ControlFlowGraph.addSuccessor$lint_checks$default(graph2, source, exitMarker, null, 4, null);
                }
            }
            for (List sources : pendingThrows.values()) {
                for (Pair pair : sources) {
                    List<String> list;
                    UElement source = (UElement)pair.component1();
                    List types = (List)pair.component2();
                    List<String> list2 = types;
                    if (list2.isEmpty()) {
                        boolean bl = false;
                        list = builder.getDefaultMethodExceptions((UElement)method);
                    } else {
                        list = list2;
                    }
                    for (String type : (List)list) {
                        graph2.addException$lint_checks(source, (UElement)exitMarker, type);
                    }
                }
            }
            for (UElement prev : pending) {
                graph2.addSuccessor$lint_checks(prev, (UElement)method, "exit");
            }
            return graph2;
        }

        @NotNull
        public final String describePath(@NotNull List<Edge<UElement>> path) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            StringBuilder sb = new StringBuilder();
            if (path.isEmpty()) {
                return "";
            }
            Edge first = (Edge)CollectionsKt.first(path);
            String string = com.android.tools.lint.checks.ControlFlowGraph$Companion.describePath$describe(first.getFrom());
            if (string != null) {
                String p0 = string;
                boolean $i$f$describePath$stub_for_inlining = false;
                boolean bl = false;
                sb.append(p0);
            }
            for (Edge<UElement> edge : path) {
                String label = edge.getLabel();
                String next = com.android.tools.lint.checks.ControlFlowGraph$Companion.describePath$describe(edge.getTo());
                if (next == null && label == null) continue;
                if (((CharSequence)sb).length() > 0) {
                    if (!(label == null || Intrinsics.areEqual((Object)label, (Object)next) || Intrinsics.areEqual((Object)label, (Object)"java.lang.Exception") || Intrinsics.areEqual((Object)label, (Object)"java.lang.RuntimeException") || Intrinsics.areEqual((Object)label, (Object)"catch"))) {
                        sb.append(" \u2192 ");
                        sb.append(label);
                        if (next == null) continue;
                        sb.append(' ');
                    } else {
                        if (next == null) continue;
                        sb.append(" \u2192 ");
                    }
                }
                sb.append(next);
            }
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        private static final String describePath$describe(Node<UElement> node) {
            Object object;
            if (node.isExit()) {
                return "exit";
            }
            UElement instruction = node.getInstruction();
            if (instruction instanceof UCallExpression) {
                String string = ((UCallExpression)instruction).getMethodName();
                if (string == null) {
                    UIdentifier uIdentifier = ((UCallExpression)instruction).getMethodIdentifier();
                    string = uIdentifier != null ? uIdentifier.getName() : null;
                }
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    object = it + "()";
                } else {
                    object = null;
                }
            } else if (instruction instanceof UReturnExpression) {
                object = "return";
            } else if (instruction instanceof UThrowExpression) {
                object = "throw";
            } else if (instruction instanceof UIfExpression) {
                object = "if";
            } else if (instruction instanceof UBreakExpression) {
                object = "break";
            } else if (instruction instanceof UContinueExpression) {
                object = "continue";
            } else if (instruction instanceof UTryExpression) {
                object = "try";
            } else if (instruction instanceof UBlockExpression) {
                object = null;
            } else if (instruction instanceof UForExpression ? true : instruction instanceof UForEachExpression) {
                object = "for";
            } else if (instruction instanceof ULoopExpression) {
                object = "loop";
            } else if (instruction instanceof UUnaryExpression) {
                object = ((UUnaryExpression)instruction).getOperator().getText();
            } else if (instruction instanceof UCatchClause) {
                object = "catch";
            } else if (instruction instanceof UPolyadicExpression) {
                object = ((UPolyadicExpression)instruction).getOperator().getText();
            } else if (instruction instanceof USwitchExpression) {
                String identifier = ((USwitchExpression)instruction).getSwitchIdentifier().getName();
                object = !Intrinsics.areEqual((Object)identifier, (Object)"<error>") ? identifier : (Lint.isKotlin((Language)instruction.getLang()) ? "when" : "switch");
            } else {
                object = null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u001b\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0016H\u0002J \u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/ControlFlowGraph$Companion$Builder;", "", "strict", "", "trackCallThrows", "trackUncheckedExceptions", "allowPure", "callLambdaParameters", "(ZZZZZ)V", "getCallLambdaParameters", "()Z", "getStrict", "getTrackCallThrows", "getTrackUncheckedExceptions", "canThrow", "reference", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMethod;", "checkBranchPaths", "Lcom/android/tools/lint/checks/ControlFlowGraph$FollowBranch;", "conditional", "Lorg/jetbrains/uast/UExpression;", "getDefaultMethodExceptions", "", "", "isFinal", "isSafe", "element", "methodThrows", "lint-checks"})
        @SourceDebugExtension(value={"SMAP\nControlFlowGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowGraph.kt\ncom/android/tools/lint/checks/ControlFlowGraph$Companion$Builder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,2157:1\n11165#2:2158\n11500#2,3:2159\n1734#3,3:2162\n1734#3,3:2165\n1734#3,3:2168\n1557#3:2172\n1628#3,3:2173\n1557#3:2176\n1628#3,3:2177\n774#3:2180\n865#3,2:2181\n18#4:2171\n*S KotlinDebug\n*F\n+ 1 ControlFlowGraph.kt\ncom/android/tools/lint/checks/ControlFlowGraph$Companion$Builder\n*L\n754#1:2158\n754#1:2159,3\n811#1:2162,3\n832#1:2165,3\n842#1:2168,3\n887#1:2172\n887#1:2173,3\n889#1:2176\n889#1:2177,3\n890#1:2180\n890#1:2181,2\n885#1:2171\n*E\n"})
        public static class Builder {
            private final boolean strict;
            private final boolean trackCallThrows;
            private final boolean trackUncheckedExceptions;
            private final boolean allowPure;
            private final boolean callLambdaParameters;

            public Builder(boolean strict, boolean trackCallThrows, boolean trackUncheckedExceptions, boolean allowPure, boolean callLambdaParameters) {
                this.strict = strict;
                this.trackCallThrows = trackCallThrows;
                this.trackUncheckedExceptions = trackUncheckedExceptions;
                this.allowPure = allowPure;
                this.callLambdaParameters = callLambdaParameters;
            }

            public /* synthetic */ Builder(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    bl2 = bl;
                }
                if ((n & 4) != 0) {
                    bl3 = bl2;
                }
                if ((n & 8) != 0) {
                    bl4 = true;
                }
                if ((n & 0x10) != 0) {
                    bl5 = !bl;
                }
                this(bl, bl2, bl3, bl4, bl5);
            }

            public final boolean getStrict() {
                return this.strict;
            }

            public final boolean getTrackCallThrows() {
                return this.trackCallThrows;
            }

            public final boolean getTrackUncheckedExceptions() {
                return this.trackUncheckedExceptions;
            }

            public final boolean getCallLambdaParameters() {
                return this.callLambdaParameters;
            }

            @NotNull
            public FollowBranch checkBranchPaths(@NotNull UExpression conditional) {
                Intrinsics.checkNotNullParameter((Object)conditional, (String)"conditional");
                return FollowBranch.BOTH;
            }

            public boolean canThrow(@NotNull UElement reference, @NotNull PsiMethod method) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                if (this.trackCallThrows && this.allowPure && this.isSafe(method)) {
                    return false;
                }
                return this.trackCallThrows;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public List<String> methodThrows(@NotNull UElement reference, @NotNull PsiMethod method) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                if (!this.trackCallThrows) {
                    return null;
                }
                if (!this.canThrow(reference, method)) {
                    return null;
                }
                PsiClassType[] psiClassTypeArray = method.getThrowsList().getReferencedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getReferencedTypes(...)");
                PsiClassType[] explicitThrows = psiClassTypeArray;
                if (!(explicitThrows.length == 0)) {
                    void $this$mapTo$iv$iv;
                    PsiClassType[] $this$map$iv = explicitThrows;
                    boolean $i$f$map = false;
                    PsiClassType[] psiClassTypeArray2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var12_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getCanonicalText());
                    }
                    return (List)destination$iv$iv;
                }
                return this.getDefaultMethodExceptions(reference);
            }

            private final boolean isFinal(PsiMethod method) {
                if (method.getModifierList().hasModifierProperty("final")) {
                    return true;
                }
                PsiClass psiClass = method.getContainingClass();
                if (psiClass == null) {
                    return false;
                }
                PsiClass containingClass = psiClass;
                PsiModifierList modifierList = containingClass.getModifierList();
                return modifierList != null && modifierList.hasModifierProperty("final");
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean isSafe(PsiMethod method) {
                String name;
                if (method == null) {
                    return false;
                }
                if (!this.strict) {
                    PsiClassType[] psiClassTypeArray = method.getThrowsList().getReferencedTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getReferencedTypes(...)");
                    if (((Object[])psiClassTypeArray).length != 0) return false;
                    boolean bl = true;
                    if (!bl) {
                        return false;
                    }
                    boolean bl2 = false;
                    if (bl2) {
                        return false;
                    }
                }
                if (this.strict && !this.isFinal(method)) {
                    return false;
                }
                String string = method.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = name = string;
                switch (string2.hashCode()) {
                    case -1420215413: {
                        if (string2.equals("emptyList")) return true;
                        break;
                    }
                    case -1295482945: {
                        if (string2.equals("equals")) return true;
                        break;
                    }
                    case 2058039875: {
                        if (string2.equals("isEmpty")) return true;
                        break;
                    }
                    case -1102509291: {
                        if (!string2.equals("listOf")) break;
                        return true;
                    }
                }
                if (UastLintUtilsKt.belongsToJvmPrimitiveType((PsiMember)((PsiMember)method))) {
                    return true;
                }
                if (UastLintUtilsKt.isScopingFunction((PsiMethod)method)) {
                    return true;
                }
                UExpression uExpression = UastFacade.INSTANCE.getMethodBody(method);
                if (uExpression == null) {
                    return false;
                }
                UExpression body = uExpression;
                return this.isSafe(body);
            }

            private final boolean isSafe(UExpression element) {
                UExpression uExpression = element;
                if (uExpression == null) {
                    return true;
                }
                if (uExpression instanceof UBlockExpression) {
                    boolean bl;
                    block27: {
                        Iterable $this$all$iv = ((UBlockExpression)element).getExpressions();
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                UExpression p0 = (UExpression)element$iv;
                                boolean $i$f$isSafe$stub_for_inlining = false;
                                boolean bl2 = false;
                                if (this.isSafe(p0)) continue;
                                bl = false;
                                break block27;
                            }
                            bl = true;
                        }
                    }
                    return bl;
                }
                if (uExpression instanceof ULiteralExpression) {
                    return true;
                }
                if (uExpression instanceof UTryExpression) {
                    return !((Collection)((UTryExpression)element).getCatchClauses()).isEmpty();
                }
                if (uExpression instanceof USimpleNameReferenceExpression) {
                    return true;
                }
                if (uExpression instanceof UReturnExpression) {
                    UExpression uExpression2 = ((UReturnExpression)element).getReturnExpression();
                    if (uExpression2 == null) {
                        return true;
                    }
                    UExpression expression = uExpression2;
                    return this.isSafe(expression);
                }
                if (uExpression instanceof UParenthesizedExpression) {
                    return this.isSafe(((UParenthesizedExpression)element).getExpression());
                }
                if (uExpression instanceof UastEmptyExpression) {
                    return true;
                }
                if (uExpression instanceof UPolyadicExpression) {
                    boolean bl;
                    block28: {
                        if (element instanceof UBinaryExpression && UastLintUtilsKt.resolveOperatorUnlessJvmPrimitiveType((UBinaryExpression)((UBinaryExpression)element)) != null) {
                            return false;
                        }
                        Iterable $this$all$iv = ((UPolyadicExpression)element).getOperands();
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                UExpression p0 = (UExpression)element$iv;
                                boolean $i$f$isSafe$stub_for_inlining$1 = false;
                                boolean bl3 = false;
                                if (this.isSafe(p0)) continue;
                                bl = false;
                                break block28;
                            }
                            bl = true;
                        }
                    }
                    return bl;
                }
                if (uExpression instanceof UIfExpression) {
                    return this.isSafe(((UIfExpression)element).getCondition()) && this.isSafe(((UIfExpression)element).getThenExpression()) && this.isSafe(((UIfExpression)element).getElseExpression());
                }
                if (uExpression instanceof UPostfixExpression) {
                    return this.isSafe(((UPostfixExpression)element).getOperand());
                }
                if (uExpression instanceof UPrefixExpression) {
                    return this.isSafe(((UPrefixExpression)element).getOperand());
                }
                if (uExpression instanceof UDeclarationsExpression) {
                    boolean bl;
                    block29: {
                        Iterable $this$all$iv = ((UDeclarationsExpression)element).getDeclarations();
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                UDeclaration it = (UDeclaration)element$iv;
                                boolean bl4 = false;
                                if (it instanceof ULocalVariable && (((ULocalVariable)it).getUastInitializer() == null || this.isSafe(((ULocalVariable)it).getUastInitializer()))) continue;
                                bl = false;
                                break block29;
                            }
                            bl = true;
                        }
                    }
                    return bl;
                }
                if (uExpression instanceof UQualifiedReferenceExpression) {
                    if (Intrinsics.areEqual((Object)((UQualifiedReferenceExpression)element).getAccessType().getName(), (Object)"?.")) {
                        return this.isSafe(((UQualifiedReferenceExpression)element).getReceiver()) && this.isSafe(((UQualifiedReferenceExpression)element).getSelector());
                    }
                    if (((UQualifiedReferenceExpression)element).getReceiver() instanceof UThisExpression || ((UQualifiedReferenceExpression)element).getReceiver() instanceof USuperExpression) {
                        return this.isSafe(((UQualifiedReferenceExpression)element).getSelector());
                    }
                    return false;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @NotNull
            public final List<String> getDefaultMethodExceptions(@NotNull UElement reference) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Collection collection;
                Iterable $this$mapTo$iv$iv2;
                void $this$map$iv2;
                List list;
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                List defaults = this.strict ? DEFAULT_EXCEPTIONS_STRICT : (Lint.isKotlin((Language)reference.getLang()) ? DEFAULT_EXCEPTIONS_KOTLIN : (this.trackUncheckedExceptions ? DEFAULT_EXCEPTIONS_JAVA : CollectionsKt.emptyList()));
                UElement uElement = reference;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType22 = false;
                UTryExpression uTryExpression = (UTryExpression)UastUtils.getParentOfType((UElement)uElement, UTryExpression.class, (boolean)strict$iv);
                if (uTryExpression == null || (list = uTryExpression.getCatchClauses()) == null) return defaults;
                Iterable $i$f$getParentOfType22 = list;
                boolean $i$f$map = false;
                void var9_10 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    Iterator it;
                    UCatchClause uCatchClause = (UCatchClause)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getTypes());
                }
                List list2 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                if (list2 == null) return defaults;
                $this$mapTo$iv$iv2 = list2;
                boolean $i$f$map22 = false;
                void $i$f$mapTo22 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PsiType psiType = (PsiType)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(it.getCanonicalText());
                }
                Iterable $i$f$map22 = (List)destination$iv$iv2;
                boolean $i$f$filter = false;
                destination$iv$iv2 = $this$filter$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(!defaults.contains(it))) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                Collection collection2 = (List)destination$iv$iv3;
                if (collection2.isEmpty()) {
                    return defaults;
                }
                List catches = (List)collection2;
                return CollectionsKt.plus((Collection)defaults, (Iterable)catches);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u0016J\u0015\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012J7\u0010\u0013\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000f0\u00162\u0006\u0010\u0011\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0017J7\u0010\u0018\u001a\u00028\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000f0\u00162\u0006\u0010\u0011\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/ControlFlowGraph$DfsRequest;", "T", "", "C", "startNode", "Lcom/android/tools/lint/checks/ControlFlowGraph$Node;", "(Lcom/android/tools/lint/checks/ControlFlowGraph$Node;)V", "followExceptionalFlow", "", "getFollowExceptionalFlow", "()Z", "getStartNode", "()Lcom/android/tools/lint/checks/ControlFlowGraph$Node;", "consumesException", "edge", "Lcom/android/tools/lint/checks/ControlFlowGraph$Edge;", "isDone", "status", "(Ljava/lang/Object;)Z", "prune", "node", "path", "", "(Lcom/android/tools/lint/checks/ControlFlowGraph$Node;Ljava/util/List;Ljava/lang/Object;)Z", "visitNode", "(Lcom/android/tools/lint/checks/ControlFlowGraph$Node;Ljava/util/List;Ljava/lang/Object;)Ljava/lang/Object;", "lint-checks"})
    public static abstract class DfsRequest<T, C> {
        @NotNull
        private final Node<T> startNode;
        private final boolean followExceptionalFlow;

        public DfsRequest(@NotNull Node<T> startNode) {
            Intrinsics.checkNotNullParameter(startNode, (String)"startNode");
            this.startNode = startNode;
        }

        @NotNull
        public final Node<T> getStartNode() {
            return this.startNode;
        }

        public abstract C visitNode(@NotNull Node<T> var1, @NotNull List<Edge<T>> var2, C var3);

        public boolean isDone(C status) {
            return false;
        }

        public boolean prune(@NotNull Node<T> node, @NotNull List<Edge<T>> path, C status) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter(path, (String)"path");
            return false;
        }

        public boolean getFollowExceptionalFlow() {
            return this.followExceptionalFlow;
        }

        public boolean consumesException(@NotNull Edge<T> edge) {
            Intrinsics.checkNotNullParameter(edge, (String)"edge");
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u0005H\u00c6\u0003J:\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/ControlFlowGraph$Domain;", "C", "", "id", "join", "Lkotlin/Function2;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "getId", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getJoin", "()Lkotlin/jvm/functions/Function2;", "component1", "component2", "copy", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Lcom/android/tools/lint/checks/ControlFlowGraph$Domain;", "equals", "", "other", "hashCode", "", "toString", "", "lint-checks"})
    public static final class Domain<C> {
        private final C id;
        @NotNull
        private final Function2<C, C, C> join;

        public Domain(C id, @NotNull Function2<? super C, ? super C, ? extends C> join) {
            Intrinsics.checkNotNullParameter(join, (String)"join");
            this.id = id;
            this.join = join;
        }

        public final C getId() {
            return this.id;
        }

        @NotNull
        public final Function2<C, C, C> getJoin() {
            return this.join;
        }

        public final C component1() {
            return this.id;
        }

        @NotNull
        public final Function2<C, C, C> component2() {
            return this.join;
        }

        @NotNull
        public final Domain<C> copy(C id, @NotNull Function2<? super C, ? super C, ? extends C> join) {
            Intrinsics.checkNotNullParameter(join, (String)"join");
            return new Domain<C>(id, join);
        }

        public static /* synthetic */ Domain copy$default(Domain domain, Object object, Function2 function2, int n, Object object2) {
            if ((n & 1) != 0) {
                object = domain.id;
            }
            if ((n & 2) != 0) {
                function2 = domain.join;
            }
            return domain.copy(object, function2);
        }

        @NotNull
        public String toString() {
            return "Domain(id=" + this.id + ", join=" + this.join + ")";
        }

        public int hashCode() {
            int result = this.id == null ? 0 : this.id.hashCode();
            result = result * 31 + this.join.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Domain)) {
                return false;
            }
            Domain domain = (Domain)other;
            if (!Intrinsics.areEqual(this.id, domain.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.join, domain.join);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0002B5\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0086\u0002J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0086\u0002J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0086\u0002J\t\u0010\u0014\u001a\u00020\tH\u0086\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/ControlFlowGraph$Edge;", "T", "", "from", "Lcom/android/tools/lint/checks/ControlFlowGraph$Node;", "to", "label", "", "isException", "", "(Lcom/android/tools/lint/checks/ControlFlowGraph$Node;Lcom/android/tools/lint/checks/ControlFlowGraph$Node;Ljava/lang/String;Z)V", "getFrom", "()Lcom/android/tools/lint/checks/ControlFlowGraph$Node;", "()Z", "getLabel", "()Ljava/lang/String;", "getTo", "component1", "component2", "component3", "component4", "toString", "lint-checks"})
    public static final class Edge<T> {
        @NotNull
        private final Node<T> from;
        @NotNull
        private final Node<T> to;
        @Nullable
        private final String label;
        private final boolean isException;

        public Edge(@NotNull Node<T> from, @NotNull Node<T> to, @Nullable String label, boolean isException) {
            Intrinsics.checkNotNullParameter(from, (String)"from");
            Intrinsics.checkNotNullParameter(to, (String)"to");
            this.from = from;
            this.to = to;
            this.label = label;
            this.isException = isException;
        }

        public /* synthetic */ Edge(Node node, Node node2, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string = null;
            }
            this(node, node2, string, bl);
        }

        @NotNull
        public final Node<T> getFrom() {
            return this.from;
        }

        @NotNull
        public final Node<T> getTo() {
            return this.to;
        }

        @Nullable
        public final String getLabel() {
            return this.label;
        }

        public final boolean isException() {
            return this.isException;
        }

        @NotNull
        public final Node<T> component1() {
            return this.from;
        }

        @NotNull
        public final Node<T> component2() {
            return this.to;
        }

        @Nullable
        public final String component3() {
            return this.label;
        }

        public final boolean component4() {
            return this.isException;
        }

        @NotNull
        public String toString() {
            return this.label + ":" + this.to;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/ControlFlowGraph$FollowBranch;", "", "(Ljava/lang/String;I)V", "BOTH", "THEN", "ELSE", "lint-checks"})
    public static final class FollowBranch
    extends Enum<FollowBranch> {
        public static final /* enum */ FollowBranch BOTH = new FollowBranch();
        public static final /* enum */ FollowBranch THEN = new FollowBranch();
        public static final /* enum */ FollowBranch ELSE = new FollowBranch();
        private static final /* synthetic */ FollowBranch[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FollowBranch[] values() {
            return (FollowBranch[])$VALUES.clone();
        }

        public static FollowBranch valueOf(String value) {
            return Enum.valueOf(FollowBranch.class, value);
        }

        @NotNull
        public static EnumEntries<FollowBranch> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = followBranchArray = new FollowBranch[]{FollowBranch.BOTH, FollowBranch.THEN, FollowBranch.ELSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010(\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J#\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J'\u0010(\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\n\b\u0002\u0010)\u001a\u0004\u0018\u00010&H\u0000\u00a2\u0006\u0002\b*J\u0014\u0010+\u001a\u00020\u000f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000J\u0006\u0010-\u001a\u00020\u000fJ\u0006\u0010.\u001a\u00020\u000fJ\u0006\u0010/\u001a\u00020\u000fJ\u0015\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000401H\u0096\u0002J\b\u00102\u001a\u00020&H\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR\u001a\u0010\u001e\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010!\u00a8\u00063"}, d2={"Lcom/android/tools/lint/checks/ControlFlowGraph$Node;", "T", "", "Lkotlin/sequences/Sequence;", "Lcom/android/tools/lint/checks/ControlFlowGraph$Edge;", "instruction", "(Ljava/lang/Object;)V", "_exceptions", "", "_successors", "exceptions", "", "getExceptions", "()Ljava/util/List;", "exit", "", "getExit$lint_checks", "()Z", "setExit$lint_checks", "(Z)V", "getInstruction", "()Ljava/lang/Object;", "Ljava/lang/Object;", "<set-?>", "", "referenceCount", "getReferenceCount", "()I", "successors", "getSuccessors", "visit", "getVisit", "setVisit", "(I)V", "addExceptionPath", "", "node", "exceptionType", "", "addExceptionPath$lint_checks", "addSuccessor", "label", "addSuccessor$lint_checks", "flowsTo", "target", "isExit", "isLeaf", "isLinear", "iterator", "", "toString", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nControlFlowGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowGraph.kt\ncom/android/tools/lint/checks/ControlFlowGraph$Node\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,2157:1\n1#2:2158\n1755#3,3:2159\n1755#3,3:2162\n1251#4,2:2165\n*S KotlinDebug\n*F\n+ 1 ControlFlowGraph.kt\ncom/android/tools/lint/checks/ControlFlowGraph$Node\n*L\n525#1:2159,3\n537#1:2162,3\n560#1:2165,2\n*E\n"})
    public static final class Node<T>
    implements Sequence<Edge<T>> {
        @NotNull
        private final T instruction;
        @Nullable
        private List<Edge<T>> _successors;
        @Nullable
        private List<Edge<T>> _exceptions;
        private int visit;
        private int referenceCount;
        private boolean exit;

        public Node(@NotNull T instruction) {
            Intrinsics.checkNotNullParameter(instruction, (String)"instruction");
            this.instruction = instruction;
        }

        @NotNull
        public final T getInstruction() {
            return this.instruction;
        }

        @NotNull
        public final List<Edge<T>> getSuccessors() {
            List list = this._successors;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @NotNull
        public final List<Edge<T>> getExceptions() {
            List list = this._exceptions;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public final int getVisit() {
            return this.visit;
        }

        public final void setVisit(int n) {
            this.visit = n;
        }

        public final int getReferenceCount() {
            return this.referenceCount;
        }

        public final boolean getExit$lint_checks() {
            return this.exit;
        }

        public final void setExit$lint_checks(boolean bl) {
            this.exit = bl;
        }

        public final boolean isExit() {
            return this.exit;
        }

        public final boolean isLeaf() {
            return this._successors == null && this._exceptions == null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isLinear() {
            if (this._exceptions != null) return false;
            List<Edge<T>> list = this._successors;
            if (list == null) return false;
            if (list.size() != 1) return false;
            return true;
        }

        public final void addSuccessor$lint_checks(@NotNull Node<T> node, @Nullable String label) {
            boolean bl;
            List successors;
            block5: {
                Intrinsics.checkNotNullParameter(node, (String)"node");
                List list = this._successors;
                if (list == null) {
                    List list2;
                    List it = list2 = (List)new ArrayList();
                    boolean bl2 = false;
                    this._successors = it;
                    list = list2;
                }
                successors = list;
                Iterable $this$any$iv = successors;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Edge it = (Edge)element$iv;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual(it.getTo(), node) && Intrinsics.areEqual((Object)it.getLabel(), (Object)label))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            successors.add(new Edge<T>(this, node, label, false));
            int n = node.referenceCount;
            node.referenceCount = n + 1;
        }

        public static /* synthetic */ void addSuccessor$lint_checks$default(Node node, Node node2, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            node.addSuccessor$lint_checks(node2, string);
        }

        public final void addExceptionPath$lint_checks(@NotNull Node<T> node, @NotNull String exceptionType) {
            boolean bl;
            List exceptions;
            block5: {
                Intrinsics.checkNotNullParameter(node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)exceptionType, (String)"exceptionType");
                List list = this._exceptions;
                if (list == null) {
                    List list2;
                    List it = list2 = (List)new ArrayList();
                    boolean bl2 = false;
                    this._exceptions = it;
                    list = list2;
                }
                exceptions = list;
                Iterable $this$any$iv = exceptions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Edge it = (Edge)element$iv;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual(it.getTo(), node) && Intrinsics.areEqual((Object)it.getLabel(), (Object)exceptionType))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            exceptions.add(new Edge<T>(this, node, exceptionType, true));
            int n = node.referenceCount;
            node.referenceCount = n + 1;
        }

        @NotNull
        public Iterator<Edge<T>> iterator() {
            return SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.getSuccessors()), (Sequence)CollectionsKt.asSequence((Iterable)this.getExceptions())).iterator();
        }

        @NotNull
        public String toString() {
            return this.instruction.toString();
        }

        public final boolean flowsTo(@NotNull Node<T> target2) {
            Intrinsics.checkNotNullParameter(target2, (String)"target");
            HashSet<Node<T>> visited = new HashSet<Node<T>>();
            return Node.flowsTo$flowsTo(visited, this, target2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final <T> boolean flowsTo$flowsTo(HashSet<Node<T>> visited, Node<T> source, Node<T> target2) {
            Edge it;
            if (!visited.add(source)) return false;
            if (Intrinsics.areEqual(source, target2)) return true;
            Sequence $this$any$iv = source;
            boolean $i$f$any = false;
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (Edge)element$iv;
                boolean bl = false;
            } while (!Node.flowsTo$flowsTo(visited, it.getTo(), target2));
            return true;
        }
    }
}

