/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnalysisApiLintUtilsKt;
import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.checks.PendingIntentMutableImplicitDetector;
import com.android.tools.lint.checks.PendingIntentUtils;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolLocation;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "filterIncident", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableMethodNames", "", "", "visitMethodCall", "", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class PendingIntentMutableImplicitDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String CLASS_URI = "android.net.Uri";
    @NotNull
    private static final String METHOD_ARRAY_OF = "arrayOf";
    @NotNull
    private static final String METHOD_ARRAY_OF_NULLS = "arrayOfNulls";
    @NotNull
    private static final String METHOD_INTENT_SET_COMPONENT = "setComponent";
    @NotNull
    private static final String METHOD_INTENT_SET_PACKAGE = "setPackage";
    @NotNull
    private static final String METHOD_INTENT_SET_CLASS = "setClass";
    @NotNull
    private static final String METHOD_INTENT_SET_CLASS_NAME = "setClassName";
    @NotNull
    private static final String METHOD_LIST_OF = "listOf";
    @NotNull
    private static final String TYPE_PARAM = "T";
    @NotNull
    private static final List<String[]> INTENT_EXPLICIT_CONSTRUCTOR_ARGS;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return PendingIntentUtils.INSTANCE.getGET_METHOD_NAMES();
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context.getEvaluator().isMemberInClass((PsiMember)method, "android.app.PendingIntent")) {
            return;
        }
        UExpression uExpression = node.getArgumentForParameter(3);
        if (uExpression == null) {
            return;
        }
        UExpression flagsArgument = uExpression;
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)flagsArgument));
        Integer n = object instanceof Integer ? (Integer)object : null;
        if (n == null) {
            return;
        }
        int flags = n;
        if (!PendingIntentMutableImplicitDetector.Companion.isNewMutableNonExemptedPendingIntent(flags)) {
            return;
        }
        UExpression uExpression2 = node.getArgumentForParameter(2);
        if (uExpression2 == null) {
            return;
        }
        UExpression intentArgument = uExpression2;
        if (PendingIntentMutableImplicitDetector.Companion.getIntentTypeForExpression(intentArgument, new Companion.IntentExpressionInfo(context.getEvaluator(), node, intentArgument)).isImplicit()) {
            LintFix[] lintFixArray = new LintFix[]{PendingIntentMutableImplicitDetector.Companion.buildImmutableFixOrNull(context, flagsArgument), PendingIntentMutableImplicitDetector.Companion.buildNoCreateFix(context, flagsArgument)};
            LintFix fixes = this.fix().alternatives(lintFixArray);
            Incident incident = new Incident(ISSUE, (Object)node, context.getLocation((UElement)node), "Mutable implicit `PendingIntent` will throw an exception", fixes);
            context.report(incident, this.map());
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (context.getMainProject().getTargetSdk() < 23) {
            return false;
        }
        if (context.getMainProject().getTargetSdk() < 34) {
            incident.overrideSeverity(Severity.WARNING);
            incident.setMessage(incident.getMessage() + " once this app starts targeting Android 14 or above");
        }
        incident.setMessage(incident.getMessage() + ", follow either of these recommendations: for an existing `PendingIntent` use `FLAG_NO_CREATE` and for a new `PendingIntent` either make it immutable or make the `Intent` within explicit");
        return true;
    }

    static {
        String[][] stringArrayArray = Issue.Companion;
        String[] stringArray = Category.SECURITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(PendingIntentMutableImplicitDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)stringArrayArray, (String)"MutableImplicitPendingIntent", (String)"Mutable Implicit PendingIntent is disallowed", (String)"\n          Apps targeting Android 14 and above are not allowed to create `PendingIntents` with \\\n          `FLAG_MUTABLE` and an implicit intent within for security reasons.\n\n          To retrieve an existing PendingIntent, use `FLAG_NO_CREATE`. To create a new \\\n          `PendingIntent`, either make the intent explicit, or make it immutable with \\\n          `FLAG_IMMUTABLE`.\n          ", (Implementation)implementation, null, (Category)stringArray, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        stringArrayArray = new String[2][];
        stringArray = new String[]{"android.content.Context", "java.lang.Class<?>"};
        stringArrayArray[0] = stringArray;
        stringArray = new String[]{"java.lang.String", CLASS_URI, "android.content.Context", "java.lang.Class<?>"};
        stringArrayArray[1] = stringArray;
        INTENT_EXPLICIT_CONSTRUCTOR_ARGS = CollectionsKt.listOf((Object[])((Object[])stringArrayArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004QRSTB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J \u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010%\u0018\u00010$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0017H\u0002J\u0018\u00100\u001a\u00020*2\u0006\u0010&\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u00101\u001a\u00020*2\u0006\u0010&\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u00172\u0006\u00102\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u00103\u001a\u00020*2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u00104\u001a\u00020*2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u00105\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\u0017H\u0002J&\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u0002092\u0014\b\u0002\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\u00130;H\u0002J\u0010\u0010=\u001a\u00020\u00132\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010>\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010?\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u0004H\u0002J\u0018\u0010A\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010B\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010C\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010D\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010E\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0015H\u0002J\u0010\u0010F\u001a\u00020\u00132\u0006\u0010G\u001a\u00020HH\u0002J\u0018\u0010I\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0017H\u0002J\u0010\u0010J\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010K\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010L\u001a\u00020M2\u0006\u00102\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010?\u001a\u00020\u0013*\u00020N2\u0006\u00108\u001a\u0002092\u0006\u0010@\u001a\u00020\u0004H\u0002J\u000e\u0010O\u001a\u00020\u0013*\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010P\u001a\u00020\u0013*\u00020N2\u0006\u00108\u001a\u000209H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion;", "", "()V", "CLASS_URI", "", "INTENT_EXPLICIT_CONSTRUCTOR_ARGS", "", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "METHOD_ARRAY_OF", "METHOD_ARRAY_OF_NULLS", "METHOD_INTENT_SET_CLASS", "METHOD_INTENT_SET_CLASS_NAME", "METHOD_INTENT_SET_COMPONENT", "METHOD_INTENT_SET_PACKAGE", "METHOD_LIST_OF", "TYPE_PARAM", "areAllLambdaExpressionsIntentMethodCalls", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "lambdaExp", "Lorg/jetbrains/uast/UExpression;", "intentInfo", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "buildImmutableFixOrNull", "Lcom/android/tools/lint/detector/api/LintFix;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "flagsArgument", "buildNoCreateFix", "containsQualifiedIntentMethodCalls", "exp", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "findLastAssignmentAndItsParentUMethod", "Lkotlin/Pair;", "Lorg/jetbrains/uast/UMethod;", "intent", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "findMutableFlagExpression", "getIntentTypeForCall", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "getIntentTypeForExpression", "intentExp", "getIntentTypeForLambda", "intentObject", "intentObjectType", "getIntentTypeForQualified", "getIntentTypeForSelectorScopeCall", "intentType", "getIntentTypeForSimpleName", "getIntentTypeForWithScopeCall", "getLambdaExpressionsOrNull", "getRealExpressionOrNull", "hasSingleTypeParameter", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "typeParameterCheck", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterSymbol;", "hasVarargValueParameterOnly", "isApplyAlsoScopeCall", "isArrayOfOrArrayOfNulls", "arrayOfMethodName", "isEscapeCall", "isIntentMethodCall", "isKotlinCollection", "isLetRunScopeCall", "isNewJavaKotlinArrayWithDimensions", "isNewMutableNonExemptedPendingIntent", "flags", "", "isReferencingContextObject", "isSelectorScopeCall", "isWithScopeCall", "setIntentTypeAfterCallInPlace", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "isFirstArgNull", "isListOf", "IntentDataFlowAnalyzer", "IntentExpressionInfo", "IntentSimpleNameAnalyzer", "IntentType", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nPendingIntentMutableImplicitDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PendingIntentMutableImplicitDetector.kt\ncom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,801:1\n1755#2,3:802\n1755#2,3:805\n1755#2,3:808\n1755#2,3:841\n1755#2,3:844\n1734#2,3:847\n28#3,2:811\n28#3,2:826\n36#4,13:813\n36#4,13:828\n*S KotlinDebug\n*F\n+ 1 PendingIntentMutableImplicitDetector.kt\ncom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion\n*L\n241#1:802,3\n259#1:805,3\n268#1:808,3\n539#1:841,3\n542#1:844,3\n622#1:847,3\n454#1:811,2\n462#1:826,2\n454#1:813,13\n462#1:828,13\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isNewMutableNonExemptedPendingIntent(int flags) {
            boolean isFlagNoCreateSet = (flags & 0x20000000) != 0;
            boolean isFlagMutableSet = (flags & 0x2000000) != 0;
            boolean isFlagAllowUnsafeImplicitIntentSet = (flags & 0x1000000) != 0;
            return isFlagMutableSet && !isFlagNoCreateSet && !isFlagAllowUnsafeImplicitIntentSet;
        }

        private final IntentType getIntentTypeForExpression(UExpression intentExp, IntentExpressionInfo intentInfo) {
            UExpression intent = UastUtils.skipParenthesizedExprDown((UExpression)intentExp);
            return intent instanceof UCallExpression ? this.getIntentTypeForCall((UCallExpression)intent, intentInfo) : (intent instanceof UQualifiedReferenceExpression ? this.getIntentTypeForQualified((UQualifiedReferenceExpression)intent, intentInfo) : (intent instanceof USimpleNameReferenceExpression ? this.getIntentTypeForSimpleName((USimpleNameReferenceExpression)intent, intentInfo) : new IntentType(false)));
        }

        private final IntentType getIntentTypeForCall(UCallExpression intent, IntentExpressionInfo intentInfo) {
            IntentType intentType;
            UastCallKind uastCallKind = intent.getKind();
            if (Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.CONSTRUCTOR_CALL)) {
                boolean bl;
                block20: {
                    Iterable $this$any$iv = INTENT_EXPLICIT_CONSTRUCTOR_ARGS;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String[] constructorArgs = (String[])element$iv;
                            boolean bl2 = false;
                            PsiMethod psiMethod = intent.resolve();
                            if (psiMethod == null) {
                                return new IntentType(false);
                            }
                            if (!intentInfo.getJavaEvaluator().methodMatches(psiMethod, "android.content.Intent", false, Arrays.copyOf(constructorArgs, constructorArgs.length))) continue;
                            bl = true;
                            break block20;
                        }
                        bl = false;
                    }
                }
                intentType = bl ? new IntentType(true, false, false, 4, null) : new IntentType(true);
            } else if (Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.NESTED_ARRAY_INITIALIZER) ? true : Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.NEW_ARRAY_WITH_INITIALIZER)) {
                boolean bl;
                block21: {
                    Iterable $this$any$iv = intent.getValueArguments();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UExpression it = (UExpression)element$iv;
                            boolean bl3 = false;
                            if (!Companion.getIntentTypeForExpression(it, intentInfo).isImplicit()) continue;
                            bl = true;
                            break block21;
                        }
                        bl = false;
                    }
                }
                boolean bl4 = bl;
                intentType = new IntentType(bl4);
            } else if (Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.METHOD_CALL)) {
                if (this.isWithScopeCall(intent)) {
                    intentType = this.getIntentTypeForWithScopeCall(intent, intentInfo);
                } else if (this.isKotlinCollection(intent)) {
                    boolean bl;
                    block22: {
                        Iterable $this$any$iv = intent.getValueArguments();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                UExpression it = (UExpression)element$iv;
                                boolean bl5 = false;
                                if (!Companion.getIntentTypeForExpression(it, intentInfo).isImplicit()) continue;
                                bl = true;
                                break block22;
                            }
                            bl = false;
                        }
                    }
                    boolean bl6 = bl;
                    intentType = new IntentType(bl6);
                } else {
                    intentType = new IntentType(false);
                }
            } else {
                intentType = new IntentType(false);
            }
            return intentType;
        }

        private final IntentType getIntentTypeForQualified(UQualifiedReferenceExpression intent, IntentExpressionInfo intentInfo) {
            List qualifiedChain = UastUtils.getQualifiedChain((UExpression)((UExpression)intent));
            if (qualifiedChain.isEmpty()) {
                return new IntentType(false);
            }
            if (Lint.isKotlin((Language)intent.getLang()) && qualifiedChain.size() >= 3 && Intrinsics.areEqual((Object)((UExpression)qualifiedChain.get(0)).asSourceString(), (Object)"android") && Intrinsics.areEqual((Object)((UExpression)qualifiedChain.get(1)).asSourceString(), (Object)"content")) {
                qualifiedChain = CollectionsKt.drop((Iterable)qualifiedChain, (int)2);
            }
            Pair pair = UtilKt.headTail((List)qualifiedChain);
            UExpression intentObject = (UExpression)pair.component1();
            List calls = (List)pair.component2();
            IntentType intentType = this.getIntentTypeForExpression(intentObject, intentInfo);
            for (UExpression c : calls) {
                if (intentType.isEscaped()) break;
                UCallExpression uCallExpression = c instanceof UCallExpression ? (UCallExpression)c : null;
                if (uCallExpression == null) continue;
                UCallExpression call = uCallExpression;
                if (this.isSelectorScopeCall(call)) {
                    intentType = this.getIntentTypeForSelectorScopeCall(intent, intentObject, intentType, call, intentInfo);
                    continue;
                }
                this.setIntentTypeAfterCallInPlace(intentType, call, intentInfo);
            }
            return intentType;
        }

        private final IntentType getIntentTypeForSimpleName(USimpleNameReferenceExpression intent, IntentExpressionInfo intentInfo) {
            Pair<UExpression, UMethod> pair = this.findLastAssignmentAndItsParentUMethod(intent, intentInfo.getCall());
            if (pair == null) {
                return new IntentType(false);
            }
            Pair<UExpression, UMethod> pair2 = pair;
            UExpression assign = (UExpression)pair2.component1();
            UMethod assignParentUMethod = (UMethod)pair2.component2();
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)intent), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return new IntentType(false);
            }
            UMethod intentParentUMethod = uMethod;
            if (!Intrinsics.areEqual((Object)assignParentUMethod, (Object)intentParentUMethod)) {
                return new IntentType(false);
            }
            int intentArraySize = 0;
            IntentType assignIntentType = new IntentType(false);
            if (assign instanceof UCallExpression && this.isNewJavaKotlinArrayWithDimensions((UCallExpression)assign)) {
                if (((UCallExpression)assign).getValueArguments().size() > 1) {
                    return new IntentType(false);
                }
                Object object = ((UExpression)((UCallExpression)assign).getValueArguments().get(0)).evaluate();
                Integer n = object instanceof Integer ? (Integer)object : null;
                intentArraySize = n != null ? n : 0;
            } else {
                assignIntentType = this.getIntentTypeForExpression(assign, intentInfo);
            }
            if (assignIntentType.isEscaped()) {
                return assignIntentType;
            }
            IntentSimpleNameAnalyzer analyzer2 = new IntentSimpleNameAnalyzer(assign, intent, intentInfo, intentArraySize, assignIntentType);
            intentParentUMethod.accept((UastVisitor)analyzer2);
            return analyzer2.getIntentTypeAfterGivenAssignment();
        }

        private final boolean isNewJavaKotlinArrayWithDimensions(UCallExpression exp) {
            return UastExpressionUtils.isNewArrayWithDimensions((UElement)((UElement)exp)) || UastExpressionUtils.isMethodCall((UElement)((UElement)exp)) && this.isArrayOfOrArrayOfNulls(exp, PendingIntentMutableImplicitDetector.METHOD_ARRAY_OF_NULLS);
        }

        private final Pair<UExpression, UMethod> findLastAssignmentAndItsParentUMethod(USimpleNameReferenceExpression intent, UCallExpression call) {
            UExpression uExpression;
            PsiElement psiElement = intent.resolve();
            PsiVariable psiVariable = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
            if (psiVariable == null) {
                return null;
            }
            UExpression uExpression2 = UastLintUtils.Companion.findLastAssignment(psiVariable, (UElement)call);
            if (uExpression2 == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression2)) == null) {
                return null;
            }
            UExpression assign = uExpression;
            return new Pair((Object)assign, (Object)UastUtils.getParentOfType$default((UElement)((UElement)assign), UMethod.class, (boolean)false, (int)2, null));
        }

        private final void setIntentTypeAfterCallInPlace(IntentType intentType, UCallExpression call, IntentExpressionInfo intentInfo) {
            block16: {
                String string = call.getMethodName();
                if (string == null) break block16;
                int n = -1;
                switch (string.hashCode()) {
                    case -2128364156: {
                        if (string.equals(PendingIntentMutableImplicitDetector.METHOD_INTENT_SET_PACKAGE)) {
                            n = 1;
                        }
                        break;
                    }
                    case 1389455926: {
                        if (string.equals(PendingIntentMutableImplicitDetector.METHOD_INTENT_SET_CLASS)) {
                            n = 2;
                        }
                        break;
                    }
                    case 139480763: {
                        if (string.equals(PendingIntentMutableImplicitDetector.METHOD_INTENT_SET_COMPONENT)) {
                            n = 3;
                        }
                        break;
                    }
                    case 1529499105: {
                        if (string.equals(PendingIntentMutableImplicitDetector.METHOD_INTENT_SET_CLASS_NAME)) {
                            n = 2;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 3: {
                        intentType.setHasComponent(!this.isFirstArgNull(call));
                        break;
                    }
                    case 1: {
                        intentType.setHasPackage(!this.isFirstArgNull(call));
                        break;
                    }
                    case 2: {
                        intentType.setHasComponent(true);
                    }
                }
            }
            if (!intentType.isEscaped()) {
                intentType.setEscaped(this.isEscapeCall(call, intentInfo));
            }
        }

        private final boolean isFirstArgNull(UCallExpression $this$isFirstArgNull) {
            Object object = $this$isFirstArgNull;
            UExpression uExpression = object != null && (object = object.getValueArguments()) != null ? (UExpression)CollectionsKt.getOrNull((List)object, (int)0) : null;
            ULiteralExpression uLiteralExpression = uExpression instanceof ULiteralExpression ? (ULiteralExpression)uExpression : null;
            return uLiteralExpression != null ? uLiteralExpression.isNull() : false;
        }

        private final boolean isIntentMethodCall(UCallExpression call, IntentExpressionInfo intentInfo) {
            UCallExpression uCallExpression = call;
            return intentInfo.getJavaEvaluator().isMemberInClass((PsiMember)(uCallExpression != null ? uCallExpression.resolve() : null), "android.content.Intent");
        }

        private final boolean isEscapeCall(UCallExpression call, IntentExpressionInfo intentInfo) {
            return !this.isIntentMethodCall(call, intentInfo) && !this.isSelectorScopeCall(call) && !this.isWithScopeCall(call);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final boolean isKotlinCollection(UCallExpression call) {
            void this_$iv$iv;
            PsiElement psiElement = call.getSourcePsi();
            KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
            if (ktElement == null) {
                return false;
            }
            KtElement sourcePsi = ktElement;
            boolean $i$f$analyze = false;
            Project project = sourcePsi.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            psiElement = KaSessionProvider.Companion.getInstance(project);
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(sourcePsi);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, sourcePsi);
            try {
                Object lock$iv$iv;
                Object object = lock$iv$iv = new Object();
                synchronized (object) {
                    KaFunctionSymbol kaFunctionSymbol;
                    KaSession $this$isKotlinCollection_u24lambda_u243;
                    block10: {
                        boolean bl = false;
                        $this$isKotlinCollection_u24lambda_u243 = analysisSession$iv$iv;
                        boolean bl2 = false;
                        if (AnalysisApiLintUtilsKt.getFunctionLikeSymbol($this$isKotlinCollection_u24lambda_u243, sourcePsi) != null) break block10;
                        boolean bl3 = false;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl25 : MonitorExitStatement: MONITOREXIT : var8_8
                        boolean bl4 = bl3;
                        return bl4;
                    }
                    KaFunctionSymbol symbol = kaFunctionSymbol;
                    boolean bl = Companion.isListOf($this$isKotlinCollection_u24lambda_u243, symbol) || Companion.isArrayOfOrArrayOfNulls($this$isKotlinCollection_u24lambda_u243, symbol, PendingIntentMutableImplicitDetector.METHOD_ARRAY_OF);
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl31 : MonitorExitStatement: MONITOREXIT : var8_8
                    boolean bl5 = bl;
                    return bl5;
                }
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, sourcePsi);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final boolean isArrayOfOrArrayOfNulls(UCallExpression call, String arrayOfMethodName) {
            void this_$iv$iv;
            PsiElement psiElement = call.getSourcePsi();
            KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
            if (ktElement == null) {
                return false;
            }
            KtElement sourcePsi = ktElement;
            boolean $i$f$analyze = false;
            Project project = sourcePsi.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            psiElement = KaSessionProvider.Companion.getInstance(project);
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(sourcePsi);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, sourcePsi);
            try {
                Object lock$iv$iv;
                Object object = lock$iv$iv = new Object();
                synchronized (object) {
                    KaFunctionSymbol kaFunctionSymbol;
                    KaSession $this$isArrayOfOrArrayOfNulls_u24lambda_u244;
                    block10: {
                        boolean bl = false;
                        $this$isArrayOfOrArrayOfNulls_u24lambda_u244 = analysisSession$iv$iv;
                        boolean bl2 = false;
                        if (AnalysisApiLintUtilsKt.getFunctionLikeSymbol($this$isArrayOfOrArrayOfNulls_u24lambda_u244, sourcePsi) != null) break block10;
                        boolean bl3 = false;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl25 : MonitorExitStatement: MONITOREXIT : var9_9
                        boolean bl4 = bl3;
                        return bl4;
                    }
                    KaFunctionSymbol symbol = kaFunctionSymbol;
                    boolean bl = Companion.isArrayOfOrArrayOfNulls($this$isArrayOfOrArrayOfNulls_u24lambda_u244, symbol, arrayOfMethodName);
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl31 : MonitorExitStatement: MONITOREXIT : var9_9
                    boolean bl5 = bl;
                    return bl5;
                }
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, sourcePsi);
            }
        }

        private final boolean isArrayOfOrArrayOfNulls(KaSession $this$isArrayOfOrArrayOfNulls, KaFunctionSymbol symbol, String arrayOfMethodName) {
            if (!this.hasSingleTypeParameter(symbol, (Function1<? super KaTypeParameterSymbol, Boolean>)((Function1)isArrayOfOrArrayOfNulls.2.INSTANCE))) {
                return false;
            }
            if (Intrinsics.areEqual((Object)arrayOfMethodName, (Object)PendingIntentMutableImplicitDetector.METHOD_ARRAY_OF) && !this.hasVarargValueParameterOnly(symbol)) {
                return false;
            }
            CallableId callableId = symbol.getCallableId();
            if (callableId == null) {
                return false;
            }
            CallableId callableId2 = callableId;
            FqName packageName = callableId2.getPackageName();
            String string = callableId2.getCallableName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String methodName = string;
            KaType returnType = symbol.getReturnType();
            return Intrinsics.areEqual((Object)packageName, (Object)StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) && symbol.getLocation() == KaSymbolLocation.TOP_LEVEL && Intrinsics.areEqual((Object)methodName, (Object)arrayOfMethodName) && $this$isArrayOfOrArrayOfNulls.isArrayOrPrimitiveArray(returnType);
        }

        private final boolean isListOf(KaSession $this$isListOf, KaFunctionSymbol symbol) {
            if (!com.android.tools.lint.checks.PendingIntentMutableImplicitDetector$Companion.hasSingleTypeParameter$default(this, symbol, null, 2, null) || !this.hasVarargValueParameterOnly(symbol)) {
                return false;
            }
            CallableId callableId = symbol.getCallableId();
            if (callableId == null) {
                return false;
            }
            CallableId callableId2 = callableId;
            FqName packageName = callableId2.getPackageName();
            String string = callableId2.getCallableName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String methodName = string;
            KaType returnType = symbol.getReturnType();
            return Intrinsics.areEqual((Object)packageName, (Object)StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE()) && symbol.getLocation() == KaSymbolLocation.TOP_LEVEL && Intrinsics.areEqual((Object)methodName, (Object)PendingIntentMutableImplicitDetector.METHOD_LIST_OF) && $this$isListOf.isClassType(returnType, StandardClassIds.INSTANCE.getList());
        }

        private final boolean hasSingleTypeParameter(KaFunctionSymbol symbol, Function1<? super KaTypeParameterSymbol, Boolean> typeParameterCheck) {
            List typeParameters = KaDeclarationSymbolKt.getTypeParameters((KaDeclarationSymbol)((KaDeclarationSymbol)symbol));
            if (typeParameters.size() != 1) {
                return false;
            }
            KaTypeParameterSymbol typeParam = (KaTypeParameterSymbol)typeParameters.get(0);
            return Intrinsics.areEqual((Object)typeParam.getName().asString(), (Object)PendingIntentMutableImplicitDetector.TYPE_PARAM) && (Boolean)typeParameterCheck.invoke((Object)typeParam) != false;
        }

        static /* synthetic */ boolean hasSingleTypeParameter$default(Companion companion, KaFunctionSymbol kaFunctionSymbol, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = hasSingleTypeParameter.1.INSTANCE;
            }
            return companion.hasSingleTypeParameter(kaFunctionSymbol, (Function1<? super KaTypeParameterSymbol, Boolean>)function1);
        }

        private final boolean hasVarargValueParameterOnly(KaFunctionSymbol symbol) {
            List valueParameters = symbol.getValueParameters();
            if (valueParameters.size() != 1) {
                return false;
            }
            return ((KaValueParameterSymbol)valueParameters.get(0)).isVararg();
        }

        private final boolean isWithScopeCall(UCallExpression call) {
            return Intrinsics.areEqual((Object)call.getMethodName(), (Object)"with") && UastLintUtilsKt.isScopingFunction((UCallExpression)call);
        }

        private final IntentType getIntentTypeForWithScopeCall(UCallExpression intent, IntentExpressionInfo intentInfo) {
            UExpression uExpression = intent.getArgumentForParameter(0);
            if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
                return new IntentType(false);
            }
            UExpression intentObject = uExpression;
            UExpression uExpression2 = intent.getArgumentForParameter(1);
            if (uExpression2 == null) {
                return new IntentType(false);
            }
            UExpression lambdaExp = uExpression2;
            if (!this.areAllLambdaExpressionsIntentMethodCalls(intent, lambdaExp, intentInfo)) {
                return new IntentType(false);
            }
            IntentType intentObjectType = this.getIntentTypeForExpression(intentObject, intentInfo);
            return this.getIntentTypeForLambda(intentObject, intentObjectType, lambdaExp, intentInfo, (UExpression)intent);
        }

        private final boolean isSelectorScopeCall(UCallExpression call) {
            return this.isApplyAlsoScopeCall(call) || this.isLetRunScopeCall(call);
        }

        private final boolean isApplyAlsoScopeCall(UCallExpression call) {
            boolean bl;
            block3: {
                Object[] objectArray = new String[]{"apply", "also"};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)call.getMethodName())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl && UastLintUtilsKt.isScopingFunction((UCallExpression)call);
        }

        private final boolean isLetRunScopeCall(UCallExpression call) {
            boolean bl;
            block3: {
                Object[] objectArray = new String[]{"let", "run"};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)call.getMethodName())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl && UastLintUtilsKt.isScopingFunction((UCallExpression)call);
        }

        private final IntentType getIntentTypeForSelectorScopeCall(UQualifiedReferenceExpression intent, UExpression intentObject, IntentType intentType, UCallExpression call, IntentExpressionInfo intentInfo) {
            UExpression uExpression = (UExpression)CollectionsKt.getOrNull((List)call.getValueArguments(), (int)0);
            if (uExpression == null) {
                return new IntentType(false);
            }
            UExpression lambdaExp = uExpression;
            if (this.isLetRunScopeCall(call) && !this.areAllLambdaExpressionsIntentMethodCalls(call, lambdaExp, intentInfo)) {
                return new IntentType(false);
            }
            return this.getIntentTypeForLambda(intentObject, intentType, lambdaExp, intentInfo, (UExpression)intent);
        }

        private final IntentType getIntentTypeForLambda(UExpression intentObject, IntentType intentObjectType, UExpression lambdaExp, IntentExpressionInfo intentInfo, UExpression intent) {
            IntentDataFlowAnalyzer analyzer2;
            block0: {
                analyzer2 = new IntentDataFlowAnalyzer(intentObject, lambdaExp, intentObjectType, intentInfo);
                UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)intent), UMethod.class, (boolean)false, (int)2, null);
                if (uMethod == null) break block0;
                uMethod.accept((UastVisitor)analyzer2);
            }
            return analyzer2.getIntentTypeAfterGivenAssignment();
        }

        private final boolean areAllLambdaExpressionsIntentMethodCalls(UCallExpression call, UExpression lambdaExp, IntentExpressionInfo intentInfo) {
            List<UExpression> list = this.getLambdaExpressionsOrNull(lambdaExp);
            if (list == null) {
                return false;
            }
            List<UExpression> expressions = list;
            for (UExpression exp : expressions) {
                UExpression realExp;
                if (this.getRealExpressionOrNull(exp) == null) {
                    return false;
                }
                UExpression uExpression = realExp;
                boolean containsOnlyIntentMethodCalls = uExpression instanceof UCallExpression ? this.isIntentMethodCall((UCallExpression)realExp, intentInfo) : (uExpression instanceof UQualifiedReferenceExpression ? this.containsQualifiedIntentMethodCalls(call, (UQualifiedReferenceExpression)realExp, intentInfo) : false);
                if (containsOnlyIntentMethodCalls) continue;
                return false;
            }
            return true;
        }

        private final List<UExpression> getLambdaExpressionsOrNull(UExpression lambdaExp) {
            ULambdaExpression uLambdaExpression = lambdaExp instanceof ULambdaExpression ? (ULambdaExpression)lambdaExp : null;
            UExpression uExpression = uLambdaExpression != null ? uLambdaExpression.getBody() : null;
            UBlockExpression uBlockExpression = uExpression instanceof UBlockExpression ? (UBlockExpression)uExpression : null;
            return uBlockExpression != null ? uBlockExpression.getExpressions() : null;
        }

        private final UExpression getRealExpressionOrNull(UExpression exp) {
            UExpression realExp;
            UExpression uExpression = realExp = exp instanceof UReturnExpression ? ((UReturnExpression)exp).getReturnExpression() : exp;
            return uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isReferencingContextObject(UCallExpression call, UExpression exp) {
            if (UastLintUtilsKt.isScopingIt((UCallExpression)call)) {
                USimpleNameReferenceExpression uSimpleNameReferenceExpression = exp instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)exp : null;
                if (Intrinsics.areEqual((Object)(uSimpleNameReferenceExpression != null ? uSimpleNameReferenceExpression.getIdentifier() : null), (Object)"it")) return true;
            }
            if (!UastLintUtilsKt.isScopingThis((UCallExpression)call)) return false;
            if (!(exp instanceof UThisExpression)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean containsQualifiedIntentMethodCalls(UCallExpression call, UQualifiedReferenceExpression exp, IntentExpressionInfo intentInfo) {
            UExpression it;
            List chain = UastUtils.getQualifiedChain((UExpression)((UExpression)exp));
            if (chain.isEmpty()) {
                return false;
            }
            Pair pair = UtilKt.headTail((List)chain);
            UExpression head = (UExpression)pair.component1();
            List tail = (List)pair.component2();
            if (!this.isReferencingContextObject(call, head)) return false;
            Iterable $this$all$iv = tail;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                it = (UExpression)element$iv;
                boolean bl = false;
            } while (Companion.isIntentMethodCall(it instanceof UCallExpression ? (UCallExpression)it : null, intentInfo));
            return false;
        }

        private final LintFix buildImmutableFixOrNull(JavaContext context, UExpression flagsArgument) {
            UExpression uExpression = this.findMutableFlagExpression(context, flagsArgument);
            if (uExpression == null) {
                return null;
            }
            UExpression mutableFlagExpression = uExpression;
            return LintFix.Companion.create().name("Replace FLAG_MUTABLE with FLAG_IMMUTABLE").replace().reformat(true).shortenNames().range(context.getLocation((UElement)mutableFlagExpression)).with("android.app.PendingIntent.FLAG_IMMUTABLE").build();
        }

        private final LintFix buildNoCreateFix(JavaContext context, UExpression flagsArgument) {
            String orSymbol = Lint.isKotlin((Language)flagsArgument.getLang()) ? "or" : "|";
            String fixText2 = " " + orSymbol + " android.app.PendingIntent.FLAG_NO_CREATE";
            return LintFix.Companion.create().name("Add FLAG_NO_CREATE").replace().end().reformat(true).shortenNames().range(context.getLocation((UElement)flagsArgument)).with(fixText2).build();
        }

        private final UExpression findMutableFlagExpression(JavaContext context, UExpression flagsArgument) {
            Ref.ObjectRef mutableFlagExpression = new Ref.ObjectRef();
            flagsArgument.accept(new UastVisitor(context, (Ref.ObjectRef<UExpression>)mutableFlagExpression){
                final /* synthetic */ JavaContext $context;
                final /* synthetic */ Ref.ObjectRef<UExpression> $mutableFlagExpression;
                {
                    this.$context = $context;
                    this.$mutableFlagExpression = $mutableFlagExpression;
                }

                public boolean visitElement(UElement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return false;
                }

                public boolean visitExpression(UExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)ConstantEvaluator.evaluate((JavaContext)this.$context, (UElement)((UElement)node)), (Object)0x2000000)) {
                        this.$mutableFlagExpression.element = node;
                        return true;
                    }
                    return false;
                }
            });
            return (UExpression)mutableFlagExpression.element;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0012\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0006H\u0016J\u0018\u0010!\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010\"\u001a\u00020\u0013J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentDataFlowAnalyzer;", "Lcom/android/tools/lint/checks/DataFlowAnalyzer;", "startExp", "Lorg/jetbrains/uast/UExpression;", "endExp", "intentType", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "intentInfo", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "(Lorg/jetbrains/uast/UExpression;Lorg/jetbrains/uast/UExpression;Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;)V", "getEndExp", "()Lorg/jetbrains/uast/UExpression;", "getIntentInfo", "()Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "getIntentType", "()Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "setIntentType", "(Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;)V", "isEndReached", "", "()Z", "setEndReached", "(Z)V", "getStartExp", "afterVisitExpression", "", "node", "argument", "call", "Lorg/jetbrains/uast/UCallExpression;", "reference", "Lorg/jetbrains/uast/UElement;", "getIntentTypeAfterGivenAssignment", "isIgnoredArgument", "isIntentAnalyzable", "isPendingIntentGetMethod", "receiver", "lint-checks"})
        private static class IntentDataFlowAnalyzer
        extends DataFlowAnalyzer {
            @NotNull
            private final UExpression startExp;
            @NotNull
            private final UExpression endExp;
            @NotNull
            private IntentType intentType;
            @NotNull
            private final IntentExpressionInfo intentInfo;
            private boolean isEndReached;

            public IntentDataFlowAnalyzer(@NotNull UExpression startExp, @NotNull UExpression endExp, @NotNull IntentType intentType, @NotNull IntentExpressionInfo intentInfo) {
                Intrinsics.checkNotNullParameter((Object)startExp, (String)"startExp");
                Intrinsics.checkNotNullParameter((Object)endExp, (String)"endExp");
                Intrinsics.checkNotNullParameter((Object)intentType, (String)"intentType");
                Intrinsics.checkNotNullParameter((Object)intentInfo, (String)"intentInfo");
                super(SetsKt.setOf((Object)startExp), null, 2, null);
                this.startExp = startExp;
                this.endExp = endExp;
                this.intentType = intentType;
                this.intentInfo = intentInfo;
            }

            @NotNull
            public final UExpression getStartExp() {
                return this.startExp;
            }

            @NotNull
            public final UExpression getEndExp() {
                return this.endExp;
            }

            @NotNull
            public final IntentType getIntentType() {
                return this.intentType;
            }

            public final void setIntentType(@NotNull IntentType intentType) {
                Intrinsics.checkNotNullParameter((Object)intentType, (String)"<set-?>");
                this.intentType = intentType;
            }

            @NotNull
            public final IntentExpressionInfo getIntentInfo() {
                return this.intentInfo;
            }

            public final boolean isEndReached() {
                return this.isEndReached;
            }

            public final void setEndReached(boolean bl) {
                this.isEndReached = bl;
            }

            public void afterVisitExpression(@NotNull UExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node, (Object)this.endExp)) {
                    this.isEndReached = true;
                }
                if (!this.isEndReached) {
                    super.afterVisitExpression(node);
                }
            }

            public final boolean isIntentAnalyzable() {
                return !this.intentType.isEscaped() && !this.isEndReached;
            }

            @Override
            public void receiver(@NotNull UCallExpression call) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                if (!this.isIntentAnalyzable()) {
                    return;
                }
                Companion.setIntentTypeAfterCallInPlace(this.intentType, call, this.intentInfo);
            }

            @Override
            public void argument(@NotNull UCallExpression call, @NotNull UElement reference) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                if (!this.isIntentAnalyzable()) {
                    return;
                }
                if (!this.isIgnoredArgument(call, reference)) {
                    this.intentType.setEscaped(true);
                }
            }

            @NotNull
            public IntentType getIntentTypeAfterGivenAssignment() {
                return this.intentType;
            }

            private final boolean isPendingIntentGetMethod(UCallExpression call) {
                return this.intentInfo.getJavaEvaluator().isMemberInClass((PsiMember)call.resolve(), "android.app.PendingIntent") && CollectionsKt.contains((Iterable)PendingIntentUtils.INSTANCE.getGET_METHOD_NAMES(), (Object)call.getMethodName());
            }

            private final boolean isIgnoredArgument(UCallExpression call, UElement reference) {
                return Intrinsics.areEqual((Object)call, (Object)UastUtils.skipParenthesizedExprDown((UExpression)this.intentInfo.getIntentArgument())) || Intrinsics.areEqual((Object)reference, (Object)this.intentInfo.getIntentArgument()) || UastExpressionUtils.isNewArrayWithInitializer((UElement)((UElement)call)) || UastExpressionUtils.isArrayInitializer((UElement)((UElement)call)) || this.isPendingIntentGetMethod(call) || Companion.isWithScopeCall(call) || Companion.isKotlinCollection(call);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "", "javaEvaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "call", "Lorg/jetbrains/uast/UCallExpression;", "intentArgument", "Lorg/jetbrains/uast/UExpression;", "(Lcom/android/tools/lint/client/api/JavaEvaluator;Lorg/jetbrains/uast/UCallExpression;Lorg/jetbrains/uast/UExpression;)V", "getCall", "()Lorg/jetbrains/uast/UCallExpression;", "getIntentArgument", "()Lorg/jetbrains/uast/UExpression;", "getJavaEvaluator", "()Lcom/android/tools/lint/client/api/JavaEvaluator;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lint-checks"})
        private static final class IntentExpressionInfo {
            @NotNull
            private final JavaEvaluator javaEvaluator;
            @NotNull
            private final UCallExpression call;
            @NotNull
            private final UExpression intentArgument;

            public IntentExpressionInfo(@NotNull JavaEvaluator javaEvaluator, @NotNull UCallExpression call, @NotNull UExpression intentArgument) {
                Intrinsics.checkNotNullParameter((Object)javaEvaluator, (String)"javaEvaluator");
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)intentArgument, (String)"intentArgument");
                this.javaEvaluator = javaEvaluator;
                this.call = call;
                this.intentArgument = intentArgument;
            }

            @NotNull
            public final JavaEvaluator getJavaEvaluator() {
                return this.javaEvaluator;
            }

            @NotNull
            public final UCallExpression getCall() {
                return this.call;
            }

            @NotNull
            public final UExpression getIntentArgument() {
                return this.intentArgument;
            }

            @NotNull
            public final JavaEvaluator component1() {
                return this.javaEvaluator;
            }

            @NotNull
            public final UCallExpression component2() {
                return this.call;
            }

            @NotNull
            public final UExpression component3() {
                return this.intentArgument;
            }

            @NotNull
            public final IntentExpressionInfo copy(@NotNull JavaEvaluator javaEvaluator, @NotNull UCallExpression call, @NotNull UExpression intentArgument) {
                Intrinsics.checkNotNullParameter((Object)javaEvaluator, (String)"javaEvaluator");
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)intentArgument, (String)"intentArgument");
                return new IntentExpressionInfo(javaEvaluator, call, intentArgument);
            }

            public static /* synthetic */ IntentExpressionInfo copy$default(IntentExpressionInfo intentExpressionInfo, JavaEvaluator javaEvaluator, UCallExpression uCallExpression, UExpression uExpression, int n, Object object) {
                if ((n & 1) != 0) {
                    javaEvaluator = intentExpressionInfo.javaEvaluator;
                }
                if ((n & 2) != 0) {
                    uCallExpression = intentExpressionInfo.call;
                }
                if ((n & 4) != 0) {
                    uExpression = intentExpressionInfo.intentArgument;
                }
                return intentExpressionInfo.copy(javaEvaluator, uCallExpression, uExpression);
            }

            @NotNull
            public String toString() {
                return "IntentExpressionInfo(javaEvaluator=" + this.javaEvaluator + ", call=" + this.call + ", intentArgument=" + this.intentArgument + ")";
            }

            public int hashCode() {
                int result = this.javaEvaluator.hashCode();
                result = result * 31 + this.call.hashCode();
                result = result * 31 + this.intentArgument.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IntentExpressionInfo)) {
                    return false;
                }
                IntentExpressionInfo intentExpressionInfo = (IntentExpressionInfo)other;
                if (!Intrinsics.areEqual((Object)this.javaEvaluator, (Object)intentExpressionInfo.javaEvaluator)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.call, (Object)intentExpressionInfo.call)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.intentArgument, (Object)intentExpressionInfo.intentArgument);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0018\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\b\u0010#\u001a\u00020\u000bH\u0016J\t\u0010$\u001a\u00020\tH\u00d6\u0001J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0002J\t\u0010(\u001a\u00020)H\u00d6\u0001J\u0010\u0010*\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentSimpleNameAnalyzer;", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentDataFlowAnalyzer;", "lastAssignment", "Lorg/jetbrains/uast/UExpression;", "intentFinalReference", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "initialIntentInfo", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "intentArraySize", "", "assignIntentType", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "(Lorg/jetbrains/uast/UExpression;Lorg/jetbrains/uast/USimpleNameReferenceExpression;Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;ILcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;)V", "getAssignIntentType", "()Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "getInitialIntentInfo", "()Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "getIntentArraySize", "()I", "intentArrayValuesIsImplicit", "", "getIntentFinalReference", "()Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "getLastAssignment", "()Lorg/jetbrains/uast/UExpression;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "getIntentTypeAfterGivenAssignment", "hashCode", "isMemberOfIntentArray", "node", "Lorg/jetbrains/uast/UArrayAccessExpression;", "toString", "", "visitArrayAccessExpression", "lint-checks"})
        @SourceDebugExtension(value={"SMAP\nPendingIntentMutableImplicitDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PendingIntentMutableImplicitDetector.kt\ncom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentSimpleNameAnalyzer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,801:1\n12644#2,2:802\n*S KotlinDebug\n*F\n+ 1 PendingIntentMutableImplicitDetector.kt\ncom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentSimpleNameAnalyzer\n*L\n674#1:802,2\n*E\n"})
        private static final class IntentSimpleNameAnalyzer
        extends IntentDataFlowAnalyzer {
            @NotNull
            private final UExpression lastAssignment;
            @NotNull
            private final USimpleNameReferenceExpression intentFinalReference;
            @NotNull
            private final IntentExpressionInfo initialIntentInfo;
            private final int intentArraySize;
            @NotNull
            private final IntentType assignIntentType;
            @NotNull
            private final boolean[] intentArrayValuesIsImplicit;

            public IntentSimpleNameAnalyzer(@NotNull UExpression lastAssignment, @NotNull USimpleNameReferenceExpression intentFinalReference, @NotNull IntentExpressionInfo initialIntentInfo, int intentArraySize, @NotNull IntentType assignIntentType) {
                Intrinsics.checkNotNullParameter((Object)lastAssignment, (String)"lastAssignment");
                Intrinsics.checkNotNullParameter((Object)intentFinalReference, (String)"intentFinalReference");
                Intrinsics.checkNotNullParameter((Object)initialIntentInfo, (String)"initialIntentInfo");
                Intrinsics.checkNotNullParameter((Object)assignIntentType, (String)"assignIntentType");
                super(lastAssignment, initialIntentInfo.getIntentArgument(), assignIntentType, initialIntentInfo);
                this.lastAssignment = lastAssignment;
                this.intentFinalReference = intentFinalReference;
                this.initialIntentInfo = initialIntentInfo;
                this.intentArraySize = intentArraySize;
                this.assignIntentType = assignIntentType;
                this.intentArrayValuesIsImplicit = new boolean[this.intentArraySize];
            }

            @NotNull
            public final UExpression getLastAssignment() {
                return this.lastAssignment;
            }

            @NotNull
            public final USimpleNameReferenceExpression getIntentFinalReference() {
                return this.intentFinalReference;
            }

            @NotNull
            public final IntentExpressionInfo getInitialIntentInfo() {
                return this.initialIntentInfo;
            }

            public final int getIntentArraySize() {
                return this.intentArraySize;
            }

            @NotNull
            public final IntentType getAssignIntentType() {
                return this.assignIntentType;
            }

            public boolean visitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
                UElement parent;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (this.isIntentAnalyzable() && this.isMemberOfIntentArray(node) && (parent = node.getUastParent()) instanceof UBinaryExpression && Intrinsics.areEqual((Object)((UBinaryExpression)parent).getOperator(), (Object)UastBinaryOperator.ASSIGN)) {
                    int index2;
                    UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getIndices());
                    Object object = uExpression != null ? uExpression.evaluate() : null;
                    Integer n = object instanceof Integer ? (Integer)object : null;
                    int n2 = index2 = n != null ? n : 0;
                    boolean bl = 0 <= index2 ? index2 < this.intentArraySize : false;
                    if (bl) {
                        this.intentArrayValuesIsImplicit[index2] = Companion.getIntentTypeForExpression(((UBinaryExpression)parent).getRightOperand(), this.getIntentInfo()).isImplicit();
                    }
                }
                return super.visitArrayAccessExpression(node);
            }

            @Override
            @NotNull
            public IntentType getIntentTypeAfterGivenAssignment() {
                boolean bl;
                block2: {
                    if (this.intentArraySize == 0) {
                        return this.getIntentType();
                    }
                    boolean[] $this$any$iv = this.intentArrayValuesIsImplicit;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        boolean element$iv;
                        boolean it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!it) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                boolean bl3 = bl;
                IntentType finalIntentType = new IntentType(bl3);
                finalIntentType.setEscaped(this.getIntentType().isEscaped());
                return finalIntentType;
            }

            private final boolean isMemberOfIntentArray(UArrayAccessExpression node) {
                UExpression uExpression = node.getReceiver();
                USimpleNameReferenceExpression uSimpleNameReferenceExpression = uExpression instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)uExpression : null;
                return Intrinsics.areEqual((Object)(uSimpleNameReferenceExpression != null ? uSimpleNameReferenceExpression.getIdentifier() : null), (Object)this.intentFinalReference.getIdentifier());
            }

            @NotNull
            public final UExpression component1() {
                return this.lastAssignment;
            }

            @NotNull
            public final USimpleNameReferenceExpression component2() {
                return this.intentFinalReference;
            }

            @NotNull
            public final IntentExpressionInfo component3() {
                return this.initialIntentInfo;
            }

            public final int component4() {
                return this.intentArraySize;
            }

            @NotNull
            public final IntentType component5() {
                return this.assignIntentType;
            }

            @NotNull
            public final IntentSimpleNameAnalyzer copy(@NotNull UExpression lastAssignment, @NotNull USimpleNameReferenceExpression intentFinalReference, @NotNull IntentExpressionInfo initialIntentInfo, int intentArraySize, @NotNull IntentType assignIntentType) {
                Intrinsics.checkNotNullParameter((Object)lastAssignment, (String)"lastAssignment");
                Intrinsics.checkNotNullParameter((Object)intentFinalReference, (String)"intentFinalReference");
                Intrinsics.checkNotNullParameter((Object)initialIntentInfo, (String)"initialIntentInfo");
                Intrinsics.checkNotNullParameter((Object)assignIntentType, (String)"assignIntentType");
                return new IntentSimpleNameAnalyzer(lastAssignment, intentFinalReference, initialIntentInfo, intentArraySize, assignIntentType);
            }

            public static /* synthetic */ IntentSimpleNameAnalyzer copy$default(IntentSimpleNameAnalyzer intentSimpleNameAnalyzer, UExpression uExpression, USimpleNameReferenceExpression uSimpleNameReferenceExpression, IntentExpressionInfo intentExpressionInfo, int n, IntentType intentType, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    uExpression = intentSimpleNameAnalyzer.lastAssignment;
                }
                if ((n2 & 2) != 0) {
                    uSimpleNameReferenceExpression = intentSimpleNameAnalyzer.intentFinalReference;
                }
                if ((n2 & 4) != 0) {
                    intentExpressionInfo = intentSimpleNameAnalyzer.initialIntentInfo;
                }
                if ((n2 & 8) != 0) {
                    n = intentSimpleNameAnalyzer.intentArraySize;
                }
                if ((n2 & 0x10) != 0) {
                    intentType = intentSimpleNameAnalyzer.assignIntentType;
                }
                return intentSimpleNameAnalyzer.copy(uExpression, uSimpleNameReferenceExpression, intentExpressionInfo, n, intentType);
            }

            @Override
            @NotNull
            public String toString() {
                return "IntentSimpleNameAnalyzer(lastAssignment=" + this.lastAssignment + ", intentFinalReference=" + this.intentFinalReference + ", initialIntentInfo=" + this.initialIntentInfo + ", intentArraySize=" + this.intentArraySize + ", assignIntentType=" + this.assignIntentType + ")";
            }

            public int hashCode() {
                int result = this.lastAssignment.hashCode();
                result = result * 31 + this.intentFinalReference.hashCode();
                result = result * 31 + this.initialIntentInfo.hashCode();
                result = result * 31 + Integer.hashCode(this.intentArraySize);
                result = result * 31 + this.assignIntentType.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IntentSimpleNameAnalyzer)) {
                    return false;
                }
                IntentSimpleNameAnalyzer intentSimpleNameAnalyzer = (IntentSimpleNameAnalyzer)((Object)other);
                if (!Intrinsics.areEqual((Object)this.lastAssignment, (Object)intentSimpleNameAnalyzer.lastAssignment)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.intentFinalReference, (Object)intentSimpleNameAnalyzer.intentFinalReference)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.initialIntentInfo, (Object)intentSimpleNameAnalyzer.initialIntentInfo)) {
                    return false;
                }
                if (this.intentArraySize != intentSimpleNameAnalyzer.intentArraySize) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.assignIntentType, (Object)intentSimpleNameAnalyzer.assignIntentType);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u0004R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\n\"\u0004\b\u000e\u0010\u0004\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "", "isImplicit", "", "(Z)V", "hasComponent", "hasPackage", "isEscaped", "(ZZZ)V", "getHasComponent", "()Z", "setHasComponent", "getHasPackage", "setHasPackage", "setEscaped", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "lint-checks"})
        private static final class IntentType {
            private boolean hasComponent;
            private boolean hasPackage;
            private boolean isEscaped;

            public IntentType(boolean hasComponent, boolean hasPackage, boolean isEscaped) {
                this.hasComponent = hasComponent;
                this.hasPackage = hasPackage;
                this.isEscaped = isEscaped;
            }

            public /* synthetic */ IntentType(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    bl3 = false;
                }
                this(bl, bl2, bl3);
            }

            public final boolean getHasComponent() {
                return this.hasComponent;
            }

            public final void setHasComponent(boolean bl) {
                this.hasComponent = bl;
            }

            public final boolean getHasPackage() {
                return this.hasPackage;
            }

            public final void setHasPackage(boolean bl) {
                this.hasPackage = bl;
            }

            public final boolean isEscaped() {
                return this.isEscaped;
            }

            public final void setEscaped(boolean bl) {
                this.isEscaped = bl;
            }

            public IntentType(boolean isImplicit) {
                this(!isImplicit, !isImplicit, false, 4, null);
            }

            public final boolean isImplicit() {
                return !this.isEscaped && !this.hasComponent && !this.hasPackage;
            }

            public final boolean component1() {
                return this.hasComponent;
            }

            public final boolean component2() {
                return this.hasPackage;
            }

            public final boolean component3() {
                return this.isEscaped;
            }

            @NotNull
            public final IntentType copy(boolean hasComponent, boolean hasPackage, boolean isEscaped) {
                return new IntentType(hasComponent, hasPackage, isEscaped);
            }

            public static /* synthetic */ IntentType copy$default(IntentType intentType, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = intentType.hasComponent;
                }
                if ((n & 2) != 0) {
                    bl2 = intentType.hasPackage;
                }
                if ((n & 4) != 0) {
                    bl3 = intentType.isEscaped;
                }
                return intentType.copy(bl, bl2, bl3);
            }

            @NotNull
            public String toString() {
                return "IntentType(hasComponent=" + this.hasComponent + ", hasPackage=" + this.hasPackage + ", isEscaped=" + this.isEscaped + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.hasComponent);
                result = result * 31 + Boolean.hashCode(this.hasPackage);
                result = result * 31 + Boolean.hashCode(this.isEscaped);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IntentType)) {
                    return false;
                }
                IntentType intentType = (IntentType)other;
                if (this.hasComponent != intentType.hasComponent) {
                    return false;
                }
                if (this.hasPackage != intentType.hasPackage) {
                    return false;
                }
                return this.isEscaped == intentType.isEscaped;
            }
        }
    }
}

