/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.checks.SystemPermissionsDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/PermissionErrorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "checkMergedProject", "Lcom/android/tools/lint/detector/api/Context;", "walkDocument", "root", "reportPermissionDefinitionIncidents", "attr", "Lorg/w3c/dom/Attr;", "reportPermissionUsageIncidents", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nPermissionErrorDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionErrorDetector.kt\ncom/android/tools/lint/checks/PermissionErrorDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,559:1\n1#2:560\n1755#3,3:561\n*S KotlinDebug\n*F\n+ 1 PermissionErrorDetector.kt\ncom/android/tools/lint/checks/PermissionErrorDetector\n*L\n210#1:561,3\n*E\n"})
public final class PermissionErrorDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(PermissionErrorDetector.class, Scope.MANIFEST_SCOPE);
    @JvmField
    @NotNull
    public static final Issue PERMISSION_NAMING_CONVENTION;
    @NotNull
    private static final Regex PERMISSION_SUFFIX_REGEX;
    @JvmField
    @NotNull
    public static final Issue KNOWN_PERMISSION_ERROR;
    @NotNull
    private static final List<String> KNOWN_PERMISSION_ERROR_VALUES;
    @NotNull
    private static final Issue RESERVED_SYSTEM_PERMISSION;
    @JvmField
    @NotNull
    public static final Issue SYSTEM_PERMISSION_TYPO;
    @JvmField
    @NotNull
    public static final Issue CUSTOM_PERMISSION_TYPO;
    private static final int MAX_EDIT_DISTANCE = 3;
    private static final int EDIT_DISTANCE_ESCAPE = 4;
    @NotNull
    private static final Regex UNEXPECTED_CHAR_REGEX;
    @Nullable
    private static String platformTarget;
    @Nullable
    private static String[] platformPermissions;

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"permission", "uses-permission", "application", "activity", "activity-alias", "receiver", "service", "provider"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        block1: {
            block2: {
                String string;
                block0: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    string = element.getTagName();
                    if (!Intrinsics.areEqual((Object)string, (Object)"permission")) break block0;
                    Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                    if (attr == null) break block1;
                    Attr it = attr;
                    boolean bl = false;
                    this.reportPermissionDefinitionIncidents((Context)context, it);
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"uses-permission")) break block2;
                Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (attr == null) break block1;
                Attr it = attr;
                boolean bl = false;
                this.reportPermissionUsageIncidents((Context)context, it);
                break block1;
            }
            Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "permission");
            if (attr == null) break block1;
            Attr it = attr;
            boolean bl = false;
            this.reportPermissionUsageIncidents((Context)context, it);
        }
    }

    public void checkMergedProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Node node = context.getMainProject().getMergedManifest();
        if (node == null || (node = node.getDocumentElement()) == null) {
            return;
        }
        Node root = node;
        this.walkDocument(context, (Element)root);
    }

    /*
     * Unable to fully structure code
     */
    private final void walkDocument(Context context, Element root) {
        customPermissions = new Ref.ObjectRef();
        customPermissionUsages = new Ref.ObjectRef();
        topLevel = XmlUtils.getFirstSubTag((Node)root);
        while (topLevel != null) {
            block29: {
                block30: {
                    var6_6 = topLevel.getTagName();
                    if (var6_6 == null) break block29;
                    switch (var6_6.hashCode()) {
                        case 599862896: {
                            if (var6_6.equals("uses-permission")) break;
                            break;
                        }
                        case 1554253136: {
                            if (!var6_6.equals("application")) {
                                break;
                            }
                            break block30;
                        }
                        case -517618225: {
                            if (!var6_6.equals("permission")) break;
                            if (topLevel.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name") != null) {
                                $i$f$walkDocument$stub_for_inlining = false;
                                $i$a$-let-PermissionErrorDetector$walkDocument$1 = false;
                                PermissionErrorDetector.walkDocument$addCustomPermission((Ref.ObjectRef<List<String>>)customPermissions, p0);
                            }
                            break;
                        }
                    }
                    if (topLevel.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name") != null) {
                        $i$f$walkDocument$stub_for_inlining$5 = false;
                        $i$a$-let-PermissionErrorDetector$walkDocument$2 = false;
                        PermissionErrorDetector.walkDocument$addCustomPermissionUsage((Ref.ObjectRef<List<Attr>>)customPermissionUsages, p0);
                        ** break;
                    }
                    break block29;
                }
                if (topLevel.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "permission") != null) {
                    $i$f$walkDocument$stub_for_inlining$6 = false;
                    $i$a$-let-PermissionErrorDetector$walkDocument$3 = false;
                    PermissionErrorDetector.walkDocument$addCustomPermissionUsage((Ref.ObjectRef<List<Attr>>)customPermissionUsages, p0);
                }
                componentLevel = XmlUtils.getFirstSubTag((Node)topLevel);
                while (componentLevel != null) {
                    block31: {
                        var8_8 = componentLevel.getTagName();
                        if (var8_8 == null) break block31;
                        switch (var8_8.hashCode()) {
                            case 1554253136: {
                                if (!var8_8.equals("application")) {
                                    break;
                                }
                                ** GOTO lbl61
                            }
                            case -1655966961: {
                                if (!var8_8.equals("activity")) {
                                    break;
                                }
                                ** GOTO lbl61
                            }
                            case -808719889: {
                                if (!var8_8.equals("receiver")) {
                                    break;
                                }
                                ** GOTO lbl61
                            }
                            case -987494927: {
                                if (!var8_8.equals("provider")) {
                                    break;
                                }
                                ** GOTO lbl61
                            }
                            case 1984153269: {
                                if (!var8_8.equals("service")) {
                                    break;
                                }
                                ** GOTO lbl61
                            }
                            case 790287890: {
                                if (!var8_8.equals("activity-alias")) break;
lbl61:
                                // 6 sources

                                if ((var9_9 = componentLevel.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "permission")) == null) break;
                                p0 = var9_9;
                                $i$f$walkDocument$stub_for_inlining$7 = false;
                                $i$a$-let-PermissionErrorDetector$walkDocument$4 = false;
                                PermissionErrorDetector.walkDocument$addCustomPermissionUsage((Ref.ObjectRef<List<Attr>>)customPermissionUsages, p0);
                                break;
                            }
                        }
                    }
                    componentLevel = XmlUtils.getNextTag((Node)componentLevel);
                }
                {
                    break;
                }
            }
            topLevel = XmlUtils.getNextTag((Node)topLevel);
        }
        if (customPermissions.element != null && customPermissionUsages.element != null) {
            v0 = (List)customPermissionUsages.element;
            if (v0 == null) {
                v0 = CollectionsKt.emptyList();
            }
            for (Attr potentialCustomPermissionUsage : v0) {
                permissionName = potentialCustomPermissionUsage.getValue();
                Intrinsics.checkNotNull((Object)permissionName);
                v1 = (List)customPermissions.element;
                if (v1 == null) {
                    v1 = CollectionsKt.emptyList();
                }
                if (PermissionErrorDetector.Companion.findAlmostCustomPermission(permissionName, v1) != null) {
                    $i$a$-let-PermissionErrorDetector$walkDocument$5 = false;
                    v2 = potentialCustomPermissionUsage.getOwnerElement();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getOwnerElement(...)");
                    context.report(new Incident(PermissionErrorDetector.CUSTOM_PERMISSION_TYPO, (Object)v2, context.getLocation((Object)potentialCustomPermissionUsage, LocationType.VALUE), "Did you mean `" + it + "`?", this.fix().replace().text(permissionName).with(it).build()));
                }
            }
        }
    }

    private final void reportPermissionDefinitionIncidents(Context context, Attr attr) {
        Object object;
        Object object2 = context.getProject().getBuildVariant();
        if (object2 == null || (object2 = object2.getPackage()) == null) {
            Element element = attr.getOwnerDocument().getDocumentElement();
            object2 = object = element != null ? element.getAttribute("package") : null;
        }
        if (object2 == null) {
            object = "";
        }
        Object packageName = object;
        String[] platformPermissions = PermissionErrorDetector.Companion.getPlatformPermissions(context.getProject());
        String string = attr.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        if (PermissionErrorDetector.Companion.isStandardPermission(string, platformPermissions)) {
            Element element = attr.getOwnerElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getOwnerElement(...)");
            context.report(new Incident(RESERVED_SYSTEM_PERMISSION, (Object)element, context.getLocation((Object)attr, LocationType.VALUE), "`" + attr.getValue() + "` is a reserved permission"));
        } else {
            String string2 = attr.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            if (StringsKt.startsWith$default((String)string2, (String)"android.", (boolean)false, (int)2, null)) {
                Element element = attr.getOwnerElement();
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getOwnerElement(...)");
                context.report(new Incident(RESERVED_SYSTEM_PERMISSION, (Object)element, context.getLocation((Object)attr, LocationType.VALUE), "`" + attr.getValue() + "` is using the reserved system prefix `android.`"));
            }
        }
        String string3 = attr.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
        if (!Companion.followsCustomPermissionNamingConvention((String)packageName, string3)) {
            Element element = attr.getOwnerElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getOwnerElement(...)");
            context.report(new Incident(PERMISSION_NAMING_CONVENTION, (Object)element, context.getLocation((Object)attr, LocationType.VALUE), "`" + attr.getValue() + " does not follow recommended naming convention`"));
        }
    }

    private final void reportPermissionUsageIncidents(Context context, Attr attr) {
        block5: {
            boolean bl;
            block4: {
                Iterable $this$any$iv = KNOWN_PERMISSION_ERROR_VALUES;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.equals((String)it, (String)attr.getValue(), (boolean)true)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Element element = attr.getOwnerElement();
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getOwnerElement(...)");
                context.report(new Incident(KNOWN_PERMISSION_ERROR, (Object)element, context.getLocation((Object)attr, LocationType.VALUE), "`" + attr.getValue() + "` is not a valid permission value"));
            }
            Project project = context.getProject();
            String string = attr.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            String string2 = Companion.findAlmostPlatformPermission(project, string);
            if (string2 == null) break block5;
            String almost = string2;
            boolean bl3 = false;
            Element element = attr.getOwnerElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getOwnerElement(...)");
            context.report(new Incident(SYSTEM_PERMISSION_TYPO, (Object)element, context.getLocation((Object)attr, LocationType.VALUE), "Did you mean `" + almost + "`?", this.fix().replace().text(attr.getValue()).with(almost).build()));
        }
    }

    private static final void walkDocument$addCustomPermission(Ref.ObjectRef<List<String>> customPermissions, Attr attr) {
        List list = (List)customPermissions.element;
        if (list == null) {
            List list2;
            List it = list2 = (List)new ArrayList();
            boolean bl = false;
            customPermissions.element = it;
            list = list2;
        }
        String string = attr.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        list.add(string);
    }

    private static final void walkDocument$addCustomPermissionUsage(Ref.ObjectRef<List<Attr>> customPermissionUsages, Attr attr) {
        List list = (List)customPermissionUsages.element;
        if (list == null) {
            List list2;
            List it = list2 = (List)new ArrayList();
            boolean bl = false;
            customPermissionUsages.element = it;
            list = list2;
        }
        list.add(attr);
    }

    static {
        String[] stringArray = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        PERMISSION_NAMING_CONVENTION = Issue.Companion.create$default((Issue.Companion)stringArray, (String)"PermissionNamingConvention", (String)"Permission name does not follow recommended convention", (String)"\n                Permissions should be prefixed with an app's package name, using \\\n                reverse-domain-style naming. This prefix should be followed by `.permission.`, \\\n                and then a description of the capability that the permission represents, in \\\n                upper SNAKE_CASE. For example, `com.example.myapp.permission.ENGAGE_HYPERSPACE`.\n\n                Following this recommendation avoids naming collisions, and helps clearly \\\n                identify the owner and intention of a custom permission.\n                ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3088, null);
        PERMISSION_SUFFIX_REGEX = new Regex("[A-Z\\d_]+");
        stringArray = Issue.Companion;
        category = Category.SECURITY;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        KNOWN_PERMISSION_ERROR = Issue.Companion.create$default((Issue.Companion)stringArray, (String)"KnownPermissionError", (String)"Value specified for permission is a known error", (String)"\n                This check looks for values specified in component permissions that are known errors, such as \\\n                `android:permission=\"true\"`.\n\n                 Please double check the permission value you have supplied. The value is expected to be a \\\n                 permission string from the system, another app, or your own, NOT a boolean.\n                ", (Implementation)implementation, (String)"https://goo.gle/KnownPermissionError", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        stringArray = new String[]{"true", "false"};
        KNOWN_PERMISSION_ERROR_VALUES = CollectionsKt.listOf((Object[])stringArray);
        stringArray = Issue.Companion;
        category = Category.SECURITY;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        RESERVED_SYSTEM_PERMISSION = Issue.Companion.create$default((Issue.Companion)stringArray, (String)"ReservedSystemPermission", (String)"Permission name is a reserved Android permission", (String)"\n                This check looks for custom permission declarations whose names are reserved values \\\n                for system or Android SDK permissions, or begin with the reserved string `android.`\n\n                Please double check the permission name you have supplied. Attempting to redeclare a system \\\n                or Android SDK permission will be ignored.  Using the prefix `android.` is a violation of the \\\n                Android Compatibility Definition Document.\n                ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        stringArray = Issue.Companion;
        category = Category.SECURITY;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        SYSTEM_PERMISSION_TYPO = Issue.Companion.create$default((Issue.Companion)stringArray, (String)"SystemPermissionTypo", (String)"Permission appears to be a standard permission with a typo", (String)"\n                This check looks for required permissions that *look* like well-known system permissions \\\n                or permissions from the Android SDK, but aren't, and may be typos.\n\n                Please double check the permission value you have supplied.\n                ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        stringArray = Issue.Companion;
        category = Category.SECURITY;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        CUSTOM_PERMISSION_TYPO = Issue.Companion.create$default((Issue.Companion)stringArray, (String)"CustomPermissionTypo", (String)"Permission appears to be a custom permission with a typo", (String)"\n                This check looks for required permissions that *look* like custom permissions defined in the same \\\n                manifest, but aren't, and may be typos.\n\n                Please double check the permission value you have supplied.\n                ", (Implementation)implementation, (String)"https://goo.gle/CustomPermissionTypo", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        UNEXPECTED_CHAR_REGEX = new Regex("[^a-zA-Z\\d_.]+");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001e\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u0011J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\rJ\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\rH\u0002J#\u0010\"\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$H\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010)\u001a\u00020*H\u0007J\u001b\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0$2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010,J\u001b\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0$2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010,J\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0/2\u0006\u00100\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010(\u00a8\u00061"}, d2={"Lcom/android/tools/lint/checks/PermissionErrorDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "PERMISSION_NAMING_CONVENTION", "Lcom/android/tools/lint/detector/api/Issue;", "PERMISSION_SUFFIX_REGEX", "Lkotlin/text/Regex;", "followsCustomPermissionNamingConvention", "", "packageName", "", "permissionName", "KNOWN_PERMISSION_ERROR", "KNOWN_PERMISSION_ERROR_VALUES", "", "RESERVED_SYSTEM_PERMISSION", "getRESERVED_SYSTEM_PERMISSION", "()Lcom/android/tools/lint/detector/api/Issue;", "SYSTEM_PERMISSION_TYPO", "CUSTOM_PERMISSION_TYPO", "MAX_EDIT_DISTANCE", "", "EDIT_DISTANCE_ESCAPE", "findAlmostCustomPermission", "requiredPermission", "customPermissions", "UNEXPECTED_CHAR_REGEX", "findAlmostPlatformPermission", "project", "Lcom/android/tools/lint/detector/api/Project;", "platformPermissionPackageUnlikely", "isStandardPermission", "platformPermissions", "", "(Ljava/lang/String;[Ljava/lang/String;)Z", "isSystemPermission", "platformTarget", "[Ljava/lang/String;", "clearPlatformPermissions", "", "getPlatformPermissions", "(Lcom/android/tools/lint/detector/api/Project;)[Ljava/lang/String;", "computePlatformPermissions", "permissionToPrefixAndSuffix", "Lkotlin/Pair;", "permission", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nPermissionErrorDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionErrorDetector.kt\ncom/android/tools/lint/checks/PermissionErrorDetector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,559:1\n295#2,2:560\n1069#3,2:562\n1#4:564\n1#4:575\n11476#5,9:565\n13402#5:574\n13403#5:576\n11485#5:577\n37#6:578\n36#6,3:579\n*S KotlinDebug\n*F\n+ 1 PermissionErrorDetector.kt\ncom/android/tools/lint/checks/PermissionErrorDetector$Companion\n*L\n369#1:560,2\n493#1:562,2\n542#1:575\n542#1:565,9\n542#1:574\n542#1:576\n542#1:577\n544#1:578\n544#1:579,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean followsCustomPermissionNamingConvention(@NotNull String packageName, @NotNull String permissionName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)permissionName, (String)"permissionName");
            if (((CharSequence)packageName).length() == 0) {
                return true;
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
            Pair<String, String> pair = this.permissionToPrefixAndSuffix(permissionName);
            String prefix = (String)pair.component1();
            String suffix = (String)pair.component2();
            if (!StringsKt.startsWith$default((String)prefix, (String)packageName, (boolean)false, (int)2, null)) return false;
            if (!StringsKt.endsWith$default((String)prefix, (String)"permission", (boolean)false, (int)2, null)) return false;
            CharSequence charSequence = suffix;
            if (!PERMISSION_SUFFIX_REGEX.matches(charSequence)) return false;
            return true;
        }

        @NotNull
        public final Issue getRESERVED_SYSTEM_PERMISSION() {
            return RESERVED_SYSTEM_PERMISSION;
        }

        @Nullable
        public final String findAlmostCustomPermission(@NotNull String requiredPermission, @NotNull List<String> customPermissions) {
            Object v1;
            block2: {
                Intrinsics.checkNotNullParameter((Object)requiredPermission, (String)"requiredPermission");
                Intrinsics.checkNotNullParameter(customPermissions, (String)"customPermissions");
                if (customPermissions.contains(requiredPermission)) {
                    return null;
                }
                Iterable $this$firstOrNull$iv = customPermissions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    int n = Lint.editDistance((String)requiredPermission, (String)it, (int)4);
                    boolean bl2 = 1 <= n ? n < 4 : false;
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            return v1;
        }

        @Nullable
        public final String findAlmostPlatformPermission(@NotNull Project project, @NotNull String requiredPermission) {
            CharSequence permission2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)requiredPermission, (String)"requiredPermission");
            Object[] platformPermissions = this.getPlatformPermissions(project);
            if (this.isStandardPermission(requiredPermission, (String[])platformPermissions)) {
                return null;
            }
            if (this.platformPermissionPackageUnlikely(requiredPermission)) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)SystemPermissionsDetector.SYSTEM_PERMISSIONS, (String)"SYSTEM_PERMISSIONS");
            Set standardPermissions = ArraysKt.toSet((Object[])ArraysKt.plus((Object[])SystemPermissionsDetector.SYSTEM_PERMISSIONS, (Object[])platformPermissions));
            int requiredNameBegin = StringsKt.lastIndexOf$default((CharSequence)requiredPermission, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            int requiredNameLength = requiredPermission.length() - requiredNameBegin;
            for (CharSequence permission2 : standardPermissions) {
                Intrinsics.checkNotNull((Object)permission2);
                int nameBegin = StringsKt.lastIndexOf$default((CharSequence)permission2, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
                int length = ((String)permission2).length() - nameBegin;
                if (requiredNameLength == length && StringsKt.regionMatches((String)requiredPermission, (int)requiredNameBegin, (String)permission2, (int)nameBegin, (int)length, (boolean)true)) {
                    return permission2;
                }
                if (!StringsKt.equals((String)permission2, (String)requiredPermission, (boolean)true)) continue;
                return permission2;
            }
            permission2 = requiredPermission;
            Regex nameBegin = UNEXPECTED_CHAR_REGEX;
            String string = "";
            String string2 = nameBegin.replace(permission2, string).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String trimmedLowerRequiredPermission = string2;
            String bestMatch = null;
            int bestEditDistance = 4;
            for (String permission3 : standardPermissions) {
                String permissionSuffix;
                String lowerPermission;
                Intrinsics.checkNotNull((Object)permission3);
                Intrinsics.checkNotNullExpressionValue((Object)permission3.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                if (StringsKt.contains$default((CharSequence)trimmedLowerRequiredPermission, (CharSequence)lowerPermission, (boolean)false, (int)2, null)) {
                    return permission3;
                }
                String requiredSuffix = StringsKt.substringAfterLast$default((String)trimmedLowerRequiredPermission, (char)'.', null, (int)2, null);
                int editDistance = Lint.editDistance((String)requiredSuffix, (String)(permissionSuffix = StringsKt.substringAfterLast$default((String)lowerPermission, (char)'.', null, (int)2, null)), (int)bestEditDistance);
                if (editDistance >= bestEditDistance) continue;
                bestEditDistance = editDistance;
                bestMatch = permission3;
            }
            return bestMatch;
        }

        private final boolean platformPermissionPackageUnlikely(String requiredPermission) {
            String string = StringsKt.substringBeforeLast$default((String)requiredPermission, (char)'.', null, (int)2, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String requiredPermissionPackage = string;
            if (!(Intrinsics.areEqual((Object)requiredPermissionPackage, (Object)"android.permission") || Intrinsics.areEqual((Object)requiredPermissionPackage, (Object)"android") || Intrinsics.areEqual((Object)requiredPermissionPackage, (Object)"android.manifest.permission") || StringsKt.startsWith$default((String)requiredPermissionPackage, (String)"com.android.", (boolean)false, (int)2, null))) {
                boolean bl;
                block3: {
                    CharSequence $this$all$iv = requiredPermission;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$all$iv.charAt(i);
                        boolean bl2 = false;
                        if (Character.isJavaIdentifierPart(it) || it == '.') continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (bl) {
                    return Lint.editDistance((String)requiredPermissionPackage, (String)"android.permission", (int)3) >= 3;
                }
            }
            return false;
        }

        private final boolean isStandardPermission(String permissionName, String[] platformPermissions) {
            return this.isSystemPermission(permissionName) || Arrays.binarySearch(platformPermissions, permissionName) >= 0;
        }

        private final boolean isSystemPermission(String permissionName) {
            return Arrays.binarySearch(SystemPermissionsDetector.SYSTEM_PERMISSIONS, permissionName) >= 0;
        }

        @VisibleForTesting
        public final void clearPlatformPermissions() {
            platformPermissions = null;
        }

        private final String[] getPlatformPermissions(Project project) {
            String[] stringArray;
            String target2;
            IAndroidTarget iAndroidTarget = project.getBuildTarget();
            String string = target2 = iAndroidTarget != null ? iAndroidTarget.hashString() : null;
            if (!Intrinsics.areEqual((Object)target2, (Object)platformTarget)) {
                platformPermissions = null;
                platformTarget = target2;
            }
            if ((stringArray = platformPermissions) == null) {
                String[] stringArray2;
                String[] it = stringArray2 = this.computePlatformPermissions(project);
                boolean bl = false;
                platformPermissions = it;
                stringArray = stringArray2;
            }
            return stringArray;
        }

        /*
         * WARNING - void declaration
         */
        private final String[] computePlatformPermissions(Project project) {
            JavaEvaluator evaluator = project.getClient().getUastParser(project).getEvaluator();
            PsiClass manifest = evaluator.findClass("android.Manifest.permission");
            if (manifest != null) {
                void $this$toTypedArray$iv;
                void $this$mapNotNullTo$iv$iv;
                Collection $this$mapNotNull$iv;
                PsiField[] psiFieldArray = manifest.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
                Object[] objectArray = psiFieldArray;
                boolean $i$f$mapNotNull = false;
                void var6_6 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    String it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    PsiField it = (PsiField)element$iv$iv;
                    boolean bl2 = false;
                    Object object = it.computeConstantValue();
                    if ((object instanceof String ? (String)object : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new String[0]);
            }
            return new String[0];
        }

        @NotNull
        public final Pair<String, String> permissionToPrefixAndSuffix(@NotNull String permission) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            int index2 = StringsKt.lastIndexOf$default((CharSequence)permission, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (index2 == -1) {
                pair = new Pair((Object)"", (Object)permission);
            } else {
                String string = permission.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = permission.substring(index2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                pair = new Pair((Object)string, (Object)string2);
            }
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

