/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.annotations;

import com.android.SdkConstants;
import com.android.builder.packaging.TypedefRemover;
import com.android.support.AndroidxName;
import com.android.tools.lint.annotations.ApiDatabase;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.client.api.AnnotationLookup;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.gradle.api.ReflectiveLintRunner;
import com.android.utils.FileUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.xml.XmlEscapers;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocComment;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastEmptyExpression;
import org.jetbrains.uast.UastVisibility;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.java.expressions.JavaUAnnotationCallExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Extractor {
    public static final boolean REMOVE_HIDDEN_TYPEDEFS = false;
    private final boolean sortAnnotations;
    private final boolean includeClassRetentionAnnotations;
    private static final boolean INCLUDE_INFERRED_NULLABLE = false;
    public static final String ANDROIDX_NULLABLE = "androidx.annotation.Nullable";
    public static final String ANDROIDX_NOTNULL = "androidx.annotation.NonNull";
    public static final String ANDROID_ANNOTATIONS_PREFIX = "android.annotation.";
    public static final String ANDROID_NULLABLE = "android.annotation.Nullable";
    public static final String SUPPORT_NULLABLE = "android.support.annotation.Nullable";
    public static final String SUPPORT_KEEP = "android.support.annotation.Keep";
    public static final String RESOURCE_TYPE_ANNOTATIONS_SUFFIX = "Res";
    public static final String ANDROID_NOTNULL = "android.annotation.NonNull";
    public static final String SUPPORT_NOTNULL = "android.support.annotation.NonNull";
    public static final String ANDROID_INT_DEF = "android.annotation.IntDef";
    public static final String ANDROID_LONG_DEF = "android.annotation.LongDef";
    public static final String ANDROID_INT_RANGE = "android.annotation.IntRange";
    public static final String ANDROID_STRING_DEF = "android.annotation.StringDef";
    public static final AndroidxName REQUIRES_PERMISSION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"RequiresPermission");
    public static final AndroidxName SYSTEM_SERVICE = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"SystemService");
    public static final String ANDROID_REQUIRES_PERMISSION = "android.annotation.RequiresPermission";
    public static final String IDEA_NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String IDEA_NOTNULL = "org.jetbrains.annotations.NotNull";
    public static final String IDEA_MAGIC = "org.intellij.lang.annotations.MagicConstant";
    public static final String IDEA_CONTRACT = "org.jetbrains.annotations.Contract";
    public static final String IDEA_NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String ATTR_VAL = "val";
    public static final String ATTR_PURE = "pure";
    private static final ImmutableSet<String> MAGIC_CONSTANT_ANNOTATIONS = ImmutableSet.builder().add((Object)SdkConstants.INT_DEF_ANNOTATION.oldName()).add((Object)SdkConstants.INT_DEF_ANNOTATION.newName()).add((Object)SdkConstants.LONG_DEF_ANNOTATION.oldName()).add((Object)SdkConstants.LONG_DEF_ANNOTATION.newName()).add((Object)SdkConstants.STRING_DEF_ANNOTATION.oldName()).add((Object)SdkConstants.STRING_DEF_ANNOTATION.newName()).add((Object)AnnotationDetector.INT_RANGE_ANNOTATION.oldName()).add((Object)AnnotationDetector.INT_RANGE_ANNOTATION.newName()).add((Object)"android.annotation.IntRange").add((Object)"android.annotation.IntDef").add((Object)"android.annotation.LongDef").add((Object)"android.annotation.StringDef").build();
    private final Map<String, List<AnnotationData>> types = new HashMap<String, List<AnnotationData>>();
    private final Set<String> irrelevantAnnotations = new HashSet<String>();
    private final Collection<File> classDir;
    private final Map<String, Map<String, List<Item>>> itemMap = new HashMap<String, Map<String, List<Item>>>();
    private Map<String, PackageItem> packageMap;
    private final ApiDatabase apiFilter;
    private final boolean displayInfo;
    private final Map<String, Integer> stats = new HashMap<String, Integer>();
    private int filteredCount;
    private int mergedCount;
    private final Set<String> ignoredAnnotations = new HashSet<String>();
    private boolean listIgnored;
    private List<String> typedefsToRemove;
    private Map<String, Boolean> sourceRetention;
    private final List<Item> keepItems = new ArrayList<Item>();
    private PsiClass lastClass;
    private String lastFqn;
    private AnnotationLookup annotationLookup = new AnnotationLookup();

    public static List<? extends PsiFile> createUnitsForFiles(Project project, List<File> specificSources) {
        ArrayList<PsiFile> units = new ArrayList<PsiFile>(specificSources.size());
        VirtualFileSystem fileSystem = StandardFileSystems.local();
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (File source : specificSources) {
            PsiFile psiFile;
            VirtualFile virtualFile = fileSystem.findFileByPath(source.getPath());
            if (virtualFile == null || (psiFile = manager.findFile(virtualFile)) == null) continue;
            units.add(psiFile);
        }
        return units;
    }

    public static List<? extends PsiFile> createUnitsInDirectories(Project project, List<File> sourceDirs) {
        List<File> specificSources = Extractor.gatherSources(sourceDirs);
        return Extractor.createUnitsForFiles(project, specificSources);
    }

    public static void addJavaSources(List<File> list, File file) {
        String path;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    Extractor.addJavaSources(list, child);
                }
            }
        } else if (file.isFile() && ((path = file.getPath()).endsWith(".java") || path.endsWith(".kt"))) {
            list.add(file);
        }
    }

    public static List<File> gatherSources(List<File> sourcePath) {
        ArrayList<File> sources = new ArrayList<File>();
        for (File file : sourcePath) {
            Extractor.addJavaSources(sources, file);
        }
        return sources;
    }

    public Extractor(ApiDatabase apiFilter, Collection<File> classDir, boolean displayInfo, boolean includeClassRetentionAnnotations, boolean sortAnnotations) {
        this.apiFilter = apiFilter;
        this.listIgnored = apiFilter != null;
        this.classDir = classDir;
        this.displayInfo = displayInfo;
        this.includeClassRetentionAnnotations = includeClassRetentionAnnotations;
        this.sortAnnotations = sortAnnotations;
    }

    public void extractFromProjectSource(List<? extends PsiFile> units) {
        if (units.isEmpty()) {
            return;
        }
        Project project = units.get(0).getProject();
        UastContext uastContext = (UastContext)ServiceManager.getService((Project)project, UastContext.class);
        AnnotationVisitor visitor = new AnnotationVisitor(false, true);
        for (PsiFile psiFile : units) {
            UElement uFile = uastContext.convertElementWithParent((PsiElement)psiFile, UFile.class);
            if (uFile == null) {
                System.out.println("Warning: Could not convert " + psiFile.getName() + " with UAST");
                continue;
            }
            uFile.accept((UastVisitor)visitor);
        }
        this.typedefsToRemove = visitor.getPrivateTypedefClasses();
    }

    public void removeTypedefClasses() {
        if (this.classDir != null && !this.classDir.isEmpty() && this.typedefsToRemove != null && !this.typedefsToRemove.isEmpty()) {
            boolean quiet = false;
            boolean verbose = false;
            boolean dryRun = false;
            TypedefRemover remover = new TypedefRemover(quiet, verbose, dryRun);
            remover.remove(this.classDir, this.typedefsToRemove);
        }
    }

    public void writeTypedefFile(File file) throws IOException {
        String desc = "";
        if (this.typedefsToRemove != null) {
            Collections.sort(this.typedefsToRemove);
            StringBuilder sb = new StringBuilder(this.typedefsToRemove.size() * 100);
            for (String cls : this.typedefsToRemove) {
                sb.append("D ");
                sb.append(cls);
                sb.append("\n");
            }
            desc = sb.toString();
        }
        FileUtils.deleteIfExists((File)file);
        Files.createParentDirs((File)file);
        Files.write((CharSequence)desc, (File)file, (Charset)Charsets.UTF_8);
    }

    public static void removeTypedefClasses(Collection<File> classDirs, File typedefFile) {
        boolean quiet = false;
        boolean verbose = false;
        boolean dryRun = false;
        TypedefRemover remover = new TypedefRemover(quiet, verbose, dryRun);
        remover.removeFromTypedefFile(classDirs, typedefFile);
    }

    public void export(File annotationsZip, File proguardCfg) throws IOException {
        if (proguardCfg != null) {
            if (this.keepItems.isEmpty()) {
                if (proguardCfg.exists()) {
                    proguardCfg.delete();
                }
            } else if (this.writeKeepRules(proguardCfg)) {
                this.info("ProGuard keep rules written to " + proguardCfg);
            }
        }
        if (annotationsZip != null) {
            if (this.itemMap.isEmpty() && this.packageMap == null) {
                FileUtils.deleteIfExists((File)annotationsZip);
            } else {
                this.writeExternalAnnotations(annotationsZip);
                this.writeStats();
                this.info("Annotations written to " + annotationsZip);
            }
        }
    }

    public void writeStats() {
        if (!this.displayInfo) {
            return;
        }
        if (!this.stats.isEmpty()) {
            ArrayList<String> annotations = new ArrayList<String>(this.stats.keySet());
            annotations.sort((s1, s2) -> {
                int frequency1 = this.stats.get(s1);
                int frequency2 = this.stats.get(s2);
                int delta = frequency2 - frequency1;
                if (delta != 0) {
                    return delta;
                }
                return s1.compareTo((String)s2);
            });
            HashMap<String, String> fqnToName = new HashMap<String, String>();
            int max = 0;
            int count = 0;
            for (String fqn : annotations) {
                String name = fqn.substring(fqn.lastIndexOf(46) + 1);
                fqnToName.put(fqn, name);
                max = Math.max(max, name.length());
                count += this.stats.get(fqn).intValue();
            }
            StringBuilder sb = new StringBuilder(200);
            sb.append("Extracted ").append(count).append(" Annotations:");
            for (String fqn : annotations) {
                sb.append('\n');
                String name = (String)fqnToName.get(fqn);
                int n = max - name.length() + 1;
                for (int i = 0; i < n; ++i) {
                    sb.append(' ');
                }
                sb.append('@');
                sb.append(name);
                sb.append(':').append(' ');
                sb.append(Integer.toString(this.stats.get(fqn)));
            }
            if (sb.length() > 0) {
                this.info(sb.toString());
            }
        }
        if (this.filteredCount > 0) {
            this.info(this.filteredCount + " of these were filtered out (not in API database file)");
        }
        if (this.mergedCount > 0) {
            this.info(this.mergedCount + " additional annotations were merged in");
        }
    }

    void info(String message) {
        if (this.displayInfo) {
            System.out.println(message);
        }
    }

    static void error(String message) {
        System.err.println("Error: " + message);
    }

    static void warning(String message) {
        System.out.println("Warning: " + message);
    }

    private static String getFqn(UAnnotation annotation) {
        return annotation.getQualifiedName();
    }

    private String getFqn(PsiClass cls) {
        if (cls != null) {
            if (cls.equals(this.lastClass)) {
                return this.lastFqn;
            }
            this.lastClass = cls;
            this.lastFqn = cls.getQualifiedName();
            return this.lastFqn;
        }
        return null;
    }

    private boolean hasSourceRetention(String fqn, UAnnotation annotation) {
        Boolean source;
        if (this.sourceRetention == null) {
            this.sourceRetention = Maps.newHashMapWithExpectedSize((int)20);
            this.sourceRetention.put(SdkConstants.INT_DEF_ANNOTATION.oldName(), true);
            this.sourceRetention.put(SdkConstants.INT_DEF_ANNOTATION.newName(), true);
            this.sourceRetention.put(SdkConstants.STRING_DEF_ANNOTATION.oldName(), true);
            this.sourceRetention.put(SdkConstants.STRING_DEF_ANNOTATION.newName(), true);
            this.sourceRetention.put(SdkConstants.LONG_DEF_ANNOTATION.oldName(), true);
            this.sourceRetention.put(SdkConstants.LONG_DEF_ANNOTATION.newName(), true);
            this.sourceRetention.put(SUPPORT_NOTNULL, false);
            this.sourceRetention.put(SUPPORT_NULLABLE, false);
            this.sourceRetention.put(ANDROID_NOTNULL, false);
            this.sourceRetention.put(ANDROID_NULLABLE, false);
            this.sourceRetention.put(ANDROIDX_NOTNULL, false);
            this.sourceRetention.put(ANDROIDX_NULLABLE, false);
        }
        if ((source = this.sourceRetention.get(fqn)) != null) {
            return source;
        }
        if (annotation == null) {
            return false;
        }
        boolean hasSourceRetention = false;
        PsiClass annotationClass = annotation.resolve();
        if (annotationClass != null) {
            hasSourceRetention = Extractor.hasSourceRetention(annotationClass);
        }
        this.sourceRetention.put(fqn, hasSourceRetention);
        return hasSourceRetention;
    }

    static boolean hasSourceRetention(UAnnotation annotation) {
        String qualifiedName = annotation.getQualifiedName();
        if ("java.lang.annotation.Retention".equals(qualifiedName) || "kotlin.annotation.Retention".equals(qualifiedName)) {
            List attributes = annotation.getAttributeValues();
            if (attributes.size() != 1) {
                Extractor.error("Expected exactly one parameter passed to @Retention");
                return false;
            }
            UExpression value = ((UNamedExpression)attributes.get(0)).getExpression();
            if (value instanceof UReferenceExpression) {
                UReferenceExpression expression = (UReferenceExpression)value;
                try {
                    PsiField field;
                    PsiElement element = expression.resolve();
                    if (element instanceof PsiField && "SOURCE".equals((field = (PsiField)element).getName())) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    String s = expression.asSourceString();
                    return s.contains("SOURCE");
                }
            }
        }
        return false;
    }

    static boolean hasSourceRetention(PsiClass cls) {
        PsiModifierList modifierList = cls.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation psiAnnotation : modifierList.getAnnotations()) {
                UAnnotation annotation = JavaUAnnotation.wrap((PsiAnnotation)psiAnnotation);
                if (!Extractor.hasSourceRetention(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private void addAnnotations(UAnnotated annotated, Item item) {
        if (annotated != null) {
            for (UAnnotation annotation : annotated.getAnnotations()) {
                if (!this.isRelevantAnnotation(annotation)) continue;
                String fqn = Extractor.getFqn(annotation);
                if (SUPPORT_KEEP.equals(fqn)) {
                    this.keepItems.add(item);
                    continue;
                }
                this.addAnnotation(annotation, fqn, item.annotations);
            }
        }
    }

    private void addAnnotation(UAnnotation annotation, String fqn, List<AnnotationData> list) {
        List<AnnotationData> indirect;
        if (fqn == null) {
            return;
        }
        if (fqn.equals(ANDROID_NULLABLE) || fqn.equals(SUPPORT_NULLABLE)) {
            this.recordStats(fqn);
            list.add(new AnnotationData(SUPPORT_NULLABLE));
            return;
        }
        if (fqn.equals(ANDROID_NOTNULL) || fqn.equals(SUPPORT_NOTNULL)) {
            this.recordStats(fqn);
            list.add(new AnnotationData(SUPPORT_NOTNULL));
            return;
        }
        if (SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(fqn) && fqn.endsWith(RESOURCE_TYPE_ANNOTATIONS_SUFFIX)) {
            this.recordStats(fqn);
            list.add(new AnnotationData(fqn));
            return;
        }
        if (fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX)) {
            if (fqn.endsWith(RESOURCE_TYPE_ANNOTATIONS_SUFFIX)) {
                String resAnnotation = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.defaultName() + fqn.substring(ANDROID_ANNOTATIONS_PREFIX.length());
                if (!this.includeClassRetentionAnnotations && !this.hasSourceRetention(resAnnotation, null)) {
                    return;
                }
                this.recordStats(resAnnotation);
                list.add(new AnnotationData(resAnnotation));
                return;
            }
            if (Extractor.isRelevantFrameworkAnnotation(fqn)) {
                String supportAnnotation = SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.defaultName() + fqn.substring(ANDROID_ANNOTATIONS_PREFIX.length());
                if (!this.includeClassRetentionAnnotations && !this.hasSourceRetention(supportAnnotation, null)) {
                    return;
                }
                this.recordStats(supportAnnotation);
                list.add(this.createData(supportAnnotation, annotation));
            }
        }
        if (SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(fqn)) {
            this.recordStats(fqn);
            list.add(this.createData(fqn, annotation));
            return;
        }
        if (this.isMagicConstant(annotation, fqn) && (indirect = this.types.get(fqn)) != null) {
            list.addAll(indirect);
        }
    }

    private void recordStats(String fqn) {
        Integer count = this.stats.get(fqn);
        if (count == null) {
            count = 0;
        }
        this.stats.put(fqn, count + 1);
    }

    private boolean hasRelevantAnnotations(UAnnotated annotated) {
        if (annotated != null) {
            for (UAnnotation annotation : annotated.getAnnotations()) {
                if (!this.isRelevantAnnotation(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRelevantAnnotation(UAnnotation annotation) {
        String fqn = Extractor.getFqn(annotation);
        if (fqn == null || fqn.startsWith("java.lang.")) {
            return false;
        }
        if (SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(fqn)) {
            if (fqn.equals(SUPPORT_KEEP)) {
                return true;
            }
            return this.includeClassRetentionAnnotations || this.hasSourceRetention(fqn, annotation);
        }
        if (fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX)) {
            return Extractor.isRelevantFrameworkAnnotation(fqn);
        }
        if (fqn.equals(ANDROID_NULLABLE) || fqn.equals(ANDROID_NOTNULL) || this.isMagicConstant(annotation, fqn)) {
            return true;
        }
        return fqn.equals(IDEA_CONTRACT);
    }

    private static boolean isRelevantFrameworkAnnotation(String fqn) {
        return fqn.startsWith(ANDROID_ANNOTATIONS_PREFIX) && !fqn.endsWith(".Widget") && !fqn.endsWith(".TargetApi") && !fqn.endsWith(".SystemApi") && !fqn.endsWith(".TestApi") && !fqn.endsWith(".SuppressAutoDoc") && !fqn.endsWith(".SuppressLint") && !fqn.endsWith(".SdkConstant");
    }

    boolean isMagicConstant(UAnnotation annotation, String typeName) {
        PsiModifierList modifierList;
        if (this.irrelevantAnnotations.contains(typeName) || typeName.startsWith("java.lang.")) {
            return false;
        }
        if (this.types.containsKey(typeName)) {
            return true;
        }
        if (MAGIC_CONSTANT_ANNOTATIONS.contains((Object)typeName)) {
            return true;
        }
        PsiClass resolved = annotation.resolve();
        if (resolved != null && (modifierList = resolved.getModifierList()) != null) {
            boolean match = false;
            for (PsiAnnotation pa : modifierList.getAnnotations()) {
                String fqn = pa.getQualifiedName();
                if (!Extractor.isNestedAnnotation(fqn)) continue;
                UAnnotation a = this.annotationLookup.findRealAnnotation(pa, resolved, null);
                List list = this.types.computeIfAbsent(typeName, k -> new ArrayList(2));
                this.addAnnotation(a, fqn, list);
                match = true;
            }
            if (match) {
                return true;
            }
        }
        this.irrelevantAnnotations.add(typeName);
        return false;
    }

    static boolean isNestedAnnotation(String fqn) {
        return fqn != null && (SdkConstants.INT_DEF_ANNOTATION.isEquals(fqn) || SdkConstants.LONG_DEF_ANNOTATION.isEquals(fqn) || SdkConstants.STRING_DEF_ANNOTATION.isEquals(fqn) || REQUIRES_PERMISSION.isEquals(fqn) || fqn.equals(ANDROID_REQUIRES_PERMISSION) || AnnotationDetector.INT_RANGE_ANNOTATION.isEquals(fqn) || fqn.equals(ANDROID_INT_RANGE) || fqn.equals(ANDROID_INT_DEF) || fqn.equals(ANDROID_LONG_DEF) || fqn.equals(ANDROID_STRING_DEF));
    }

    private boolean writeKeepRules(File proguardCfg) {
        if (!this.keepItems.isEmpty()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(proguardCfg));){
                Collections.sort(this.keepItems);
                for (Item item : this.keepItems) {
                    writer.write(item.getKeepRule());
                    ((Writer)writer).write(10);
                }
            }
            catch (IOException ioe) {
                Extractor.error(ioe.toString());
                return true;
            }
            for (Item item : this.keepItems) {
                this.removeItem(item.getQualifiedClassName(), item);
            }
        } else if (proguardCfg.exists()) {
            proguardCfg.delete();
        }
        return false;
    }

    private void writeExternalAnnotations(File annotationsZip) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(annotationsZip);
             JarOutputStream zos = new JarOutputStream(new BufferedOutputStream(fileOutputStream));){
            ArrayList<String> sortedPackages = new ArrayList<String>(this.itemMap.keySet());
            if (this.packageMap != null) {
                for (String pkg : this.packageMap.keySet()) {
                    if (this.itemMap.containsKey(pkg)) continue;
                    sortedPackages.add(pkg);
                }
            }
            Collections.sort(sortedPackages);
            for (String pkg : sortedPackages) {
                String name = pkg.replace('.', '/') + "/annotations.xml";
                JarEntry outEntry = new JarEntry(name);
                outEntry.setTime(0L);
                zos.putNextEntry(outEntry);
                StringPrintWriter writer = StringPrintWriter.create();
                Throwable throwable = null;
                try {
                    Document document;
                    PackageItem item;
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>");
                    Map<String, List<Item>> classMap = this.itemMap.get(pkg);
                    if (classMap == null) {
                        classMap = Collections.emptyMap();
                    }
                    if (this.packageMap != null && (item = this.packageMap.get(pkg)) != null) {
                        item.write(writer);
                    }
                    ArrayList<String> classes = new ArrayList<String>(classMap.keySet());
                    Collections.sort(classes);
                    for (String cls : classes) {
                        List<Item> items = classMap.get(cls);
                        Collections.sort(items);
                        for (Item item2 : items) {
                            item2.write(writer);
                        }
                    }
                    writer.println("</root>\n");
                    writer.close();
                    String xml = writer.getContents();
                    if (Lint.assertionsEnabled() && (document = Extractor.checkDocument(pkg, xml, false)) == null) {
                        Extractor.error("Could not parse XML document back in for entry " + name + ": invalid XML?\n\"\"\"\n" + xml + "\n\"\"\"\n");
                    }
                    byte[] bytes = xml.getBytes(Charsets.UTF_8);
                    zos.write(bytes);
                    zos.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
        }
    }

    private void addPackage(String pkg, PackageItem item) {
        if (this.apiFilter != null && item.isFiltered(this.apiFilter)) {
            if (this.isListIgnored()) {
                this.info("Skipping API because it is not part of the API file: " + item);
            }
            ++this.filteredCount;
            return;
        }
        if (this.packageMap == null) {
            this.packageMap = new HashMap<String, PackageItem>();
        }
        this.packageMap.put(pkg, item);
    }

    private void addItem(String fqn, Item item) {
        if (this.apiFilter != null && item.isFiltered(this.apiFilter)) {
            if (this.isListIgnored()) {
                this.info("Skipping API because it is not part of the API file: " + item);
            }
            ++this.filteredCount;
            return;
        }
        this.addItemUnconditionally(fqn, item);
    }

    private void addItemUnconditionally(String fqn, Item item) {
        ArrayList<Item> items;
        String pkg = Extractor.getPackage(fqn);
        HashMap classMap = this.itemMap.get(pkg);
        if (classMap == null) {
            classMap = Maps.newHashMapWithExpectedSize((int)100);
            this.itemMap.put(pkg, classMap);
        }
        if ((items = (ArrayList<Item>)classMap.get(fqn)) == null) {
            items = new ArrayList<Item>();
            classMap.put(fqn, items);
        }
        items.add(item);
    }

    private void removeItem(String classFqn, Item item) {
        List<Item> items;
        String pkg = Extractor.getPackage(classFqn);
        Map<String, List<Item>> classMap = this.itemMap.get(pkg);
        if (classMap != null && (items = classMap.get(classFqn)) != null) {
            items.remove(item);
            if (items.isEmpty()) {
                classMap.remove(classFqn);
                if (classMap.isEmpty()) {
                    this.itemMap.remove(pkg);
                }
            }
        }
    }

    private Item findItem(String fqn, Item item) {
        String pkg = Extractor.getPackage(fqn);
        Map<String, List<Item>> classMap = this.itemMap.get(pkg);
        if (classMap == null) {
            return null;
        }
        List<Item> items = classMap.get(fqn);
        if (items == null) {
            return null;
        }
        for (Item existing : items) {
            if (!existing.equals(item)) continue;
            return existing;
        }
        return null;
    }

    private static Document checkDocument(String pkg, String xml, boolean namespaceAware) {
        try {
            return XmlUtils.parseDocument((String)xml, (boolean)namespaceAware);
        }
        catch (SAXException sax) {
            Extractor.warning("Failed to parse document for package " + pkg + ": " + sax.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void mergeExisting(File file) {
        block4: {
            block5: {
                block3: {
                    if (!file.isDirectory()) break block3;
                    File[] files = file.listFiles();
                    if (files == null) break block4;
                    for (File child : files) {
                        this.mergeExisting(child);
                    }
                    break block4;
                }
                if (!file.isFile()) break block4;
                if (!file.getPath().endsWith(".jar") && !file.getPath().endsWith(".zip")) break block5;
                this.mergeFromJar(file);
                break block4;
            }
            if (!file.getPath().endsWith(".xml")) break block4;
            try {
                String xml = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
                this.mergeAnnotationsXml(file.getPath(), xml);
            }
            catch (IOException e) {
                Extractor.error("Aborting: I/O problem during transform: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void mergeFromJar(File jar) {
        block12: {
            JarInputStream zis = null;
            FileInputStream fis2333333332 = new FileInputStream(jar);
            zis = new JarInputStream(fis2333333332);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().endsWith(".xml")) {
                    byte[] bytes = ByteStreams.toByteArray((InputStream)zis);
                    String xml = new String(bytes, Charsets.UTF_8);
                    this.mergeAnnotationsXml(jar.getPath() + ": " + entry, xml);
                }
                entry = zis.getNextEntry();
            }
            try {
                Closeables.close((Closeable)zis, (boolean)true);
            }
            catch (IOException fis2333333332) {}
            break block12;
            catch (IOException e) {
                try {
                    Extractor.error("Aborting: I/O problem during transform: " + e.toString());
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(zis, (boolean)true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)zis, (boolean)true);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void mergeAnnotationsXml(String path, String xml) {
        block3: {
            try {
                Document document = XmlUtils.parseDocument((String)xml, (boolean)false);
                this.mergeDocument(document);
            }
            catch (Exception e) {
                String message = "Failed to merge " + path + ": " + e.toString();
                if (e instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)e;
                    message = "Line " + spe.getLineNumber() + ":" + spe.getColumnNumber() + ": " + message;
                }
                Extractor.error(message);
                if (e instanceof IOException) break block3;
                e.printStackTrace();
            }
        }
    }

    private void mergeDocument(Document document) {
        Pattern XML_SIGNATURE = Pattern.compile("(\\S+) (\\S+|((.*)\\s+)?(\\S+)\\((.*)\\)( \\d+)?)");
        Element root = document.getDocumentElement();
        String rootTag = root.getTagName();
        assert (rootTag.equals("root")) : rootTag;
        for (Element item : Extractor.getChildren(root)) {
            String signature = item.getAttribute("name");
            if (signature == null || signature.equals("null") || !this.hasRelevantAnnotations(item) || (signature = Extractor.unescapeXml(signature)).equals("java.util.Calendar int get(int)") || signature.equals("java.util.Calendar void set(int, int, int) 1") || signature.equals("java.util.Calendar void set(int, int, int, int, int) 1") || signature.equals("java.util.Calendar void set(int, int, int, int, int, int) 1")) continue;
            Matcher matcher = XML_SIGNATURE.matcher(signature);
            if (matcher.matches()) {
                String methodName;
                String containingClass = matcher.group(1);
                if (containingClass == null) {
                    Extractor.warning("Could not find class for " + signature);
                }
                if ((methodName = matcher.group(5)) != null) {
                    String type = matcher.group(4);
                    boolean isConstructor = type == null;
                    String parameters = matcher.group(6);
                    this.mergeMethodOrParameter(item, matcher, containingClass, methodName, type, isConstructor, parameters);
                    continue;
                }
                String fieldName = matcher.group(2);
                this.mergeField(item, containingClass, fieldName);
                continue;
            }
            if (signature.indexOf(32) == -1 && signature.indexOf(46) != -1) continue;
            Extractor.warning("No merge match for signature " + signature);
        }
    }

    private static String unescapeXml(String escaped) {
        String workingString = escaped.replace("&quot;", "\"");
        workingString = workingString.replace("&lt;", "<");
        workingString = workingString.replace("&gt;", ">");
        workingString = workingString.replace("&apos;", "'");
        workingString = workingString.replace("&amp;", "&");
        return workingString;
    }

    private static String escapeXml(String unescaped) {
        return XmlEscapers.xmlAttributeEscaper().escape(unescaped);
    }

    private static boolean hasHistoricData(Element item) {
        for (Node curr = item.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            if (curr.getNodeType() != 1 || !"annotation".equals(curr.getNodeName())) continue;
            for (Node inner = curr.getFirstChild(); inner != null; inner = inner.getNextSibling()) {
                if (inner.getNodeType() != 1 || !ATTR_VAL.equals(inner.getNodeName()) || !"apis".equals(((Element)inner).getAttribute("name"))) continue;
                return true;
            }
        }
        return false;
    }

    private void mergeField(Element item, String containingClass, String fieldName) {
        if (this.apiFilter != null && !Extractor.hasHistoricData(item) && !this.apiFilter.hasField(containingClass, fieldName)) {
            if (this.isListIgnored()) {
                this.info("Skipping imported element because it is not part of the API file: " + containingClass + "#" + fieldName);
            }
            ++this.filteredCount;
        } else {
            FieldItem fieldItem = new FieldItem(null, containingClass, fieldName, null);
            Item existing = this.findItem(containingClass, fieldItem);
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItemUnconditionally(containingClass, fieldItem);
                this.mergedCount += this.addAnnotations(item, (Item)fieldItem);
            }
        }
    }

    private void mergeMethodOrParameter(Element item, Matcher matcher, String containingClass, String methodName, String type, boolean constructor, String parameters) {
        parameters = Extractor.fixParameterString(parameters);
        if (this.apiFilter != null && !Extractor.hasHistoricData(item) && !this.apiFilter.hasMethod(containingClass, methodName, parameters)) {
            if (this.isListIgnored()) {
                this.info("Skipping imported element because it is not part of the API file: " + containingClass + "#" + methodName + "(" + parameters + ")");
            }
            ++this.filteredCount;
            return;
        }
        String argNum = matcher.group(7);
        if (argNum != null) {
            argNum = argNum.trim();
            ParameterItem parameterItem = new ParameterItem(null, containingClass, type, methodName, parameters, constructor, argNum);
            Item existing = this.findItem(containingClass, parameterItem);
            if ("java.util.Calendar".equals(containingClass) && "set".equals(methodName) && Integer.parseInt(argNum) > 0) {
                return;
            }
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItemUnconditionally(containingClass, parameterItem);
                this.mergedCount += this.addAnnotations(item, (Item)parameterItem);
            }
        } else {
            MethodItem methodItem = new MethodItem(null, containingClass, type, methodName, parameters, constructor);
            Item existing = this.findItem(containingClass, methodItem);
            if (existing != null) {
                this.mergedCount += this.mergeAnnotations(item, existing);
            } else {
                this.addItemUnconditionally(containingClass, methodItem);
                this.mergedCount += this.addAnnotations(item, (Item)methodItem);
            }
        }
    }

    private static String fixParameterString(String parameters) {
        return parameters.replace("  ", " ").replace(", ", ",").replace("?super", "? super ").replace("?extends", "? extends ");
    }

    private boolean hasRelevantAnnotations(Element item) {
        for (Element annotationElement : Extractor.getChildren(item)) {
            if (!this.isRelevantAnnotation(annotationElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelevantAnnotation(Element annotationElement) {
        AnnotationData annotation = this.createAnnotation(annotationElement);
        if (annotation == null) {
            return false;
        }
        if (Extractor.isNullable(annotation.name) || Extractor.isNonNull(annotation.name) || annotation.name.startsWith(ANDROID_ANNOTATIONS_PREFIX) || SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(annotation.name)) {
            return true;
        }
        if (annotation.name.equals(IDEA_CONTRACT)) {
            return true;
        }
        if (annotation.name.equals(IDEA_NON_NLS)) {
            return false;
        }
        if (!this.ignoredAnnotations.contains(annotation.name)) {
            this.ignoredAnnotations.add(annotation.name);
            if (this.isListIgnored()) {
                this.info("(Ignoring merge annotation " + annotation.name + ")");
            }
        }
        return false;
    }

    private static List<Element> getChildren(Element element) {
        NodeList itemList = element.getChildNodes();
        int length = itemList.getLength();
        ArrayList<Element> result = new ArrayList<Element>(Math.max(5, length / 2 + 1));
        for (int i = 0; i < length; ++i) {
            Node node = itemList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    private int addAnnotations(Element itemElement, Item item) {
        int count = 0;
        for (Element annotationElement : Extractor.getChildren(itemElement)) {
            AnnotationData annotation;
            if (!this.isRelevantAnnotation(annotationElement) || (annotation = this.createAnnotation(annotationElement)) == null || !this.includeClassRetentionAnnotations && !this.hasSourceRetention(annotation.name, null)) continue;
            item.annotations.add(annotation);
            ++count;
        }
        return count;
    }

    private int mergeAnnotations(Element itemElement, Item item) {
        int count = 0;
        block0: for (Element annotationElement : Extractor.getChildren(itemElement)) {
            AnnotationData annotation;
            if (!this.isRelevantAnnotation(annotationElement) || (annotation = this.createAnnotation(annotationElement)) == null || !this.includeClassRetentionAnnotations && !this.hasSourceRetention(annotation.name, null)) continue;
            boolean haveNullable = false;
            boolean haveNotNull = false;
            for (AnnotationData existing : item.annotations) {
                if (Extractor.isNonNull(existing.name)) {
                    haveNotNull = true;
                }
                if (Extractor.isNullable(existing.name)) {
                    haveNullable = true;
                }
                if (!existing.equals(annotation)) continue;
                continue block0;
            }
            if (Extractor.isNonNull(annotation.name) && haveNullable || Extractor.isNullable(annotation.name) && haveNotNull) {
                Extractor.warning("Found both @Nullable and @NonNull after import for " + item);
                continue;
            }
            item.annotations.add(annotation);
            ++count;
        }
        return count;
    }

    private static boolean isNonNull(String name) {
        return name.equals(IDEA_NOTNULL) || name.equals(ANDROID_NOTNULL) || name.equals(ANDROIDX_NOTNULL) || name.equals(SUPPORT_NOTNULL);
    }

    private static boolean isNullable(String name) {
        return name.equals(IDEA_NULLABLE) || name.equals(ANDROID_NULLABLE) || name.equals(ANDROIDX_NULLABLE) || name.equals(SUPPORT_NULLABLE);
    }

    private AnnotationData createAnnotation(Element annotationElement) {
        AnnotationData annotation;
        String tagName = annotationElement.getTagName();
        assert (tagName.equals("annotation")) : tagName;
        String name = annotationElement.getAttribute("name");
        assert (name != null && !name.isEmpty());
        if (IDEA_MAGIC.equals(name)) {
            boolean flag;
            List<Element> children = Extractor.getChildren(annotationElement);
            assert (children.size() == 1) : children.size();
            Element valueElement = children.get(0);
            String valName = valueElement.getAttribute("name");
            String value = valueElement.getAttribute(ATTR_VAL);
            boolean flagsFromClass = valName.equals("flagsFromClass");
            boolean bl = flag = valName.equals("flags") || flagsFromClass;
            if (valName.equals("valuesFromClass") || flagsFromClass) {
                boolean found = false;
                if (value.endsWith(".class")) {
                    String clsName = value.substring(0, value.length() - ".class".length());
                    StringBuilder sb = new StringBuilder();
                    sb.append('{');
                    Field[] reflectionFields = null;
                    try {
                        Class<?> cls = Class.forName(clsName);
                        reflectionFields = cls.getDeclaredFields();
                    }
                    catch (Exception cls) {
                        // empty catch block
                    }
                    if (this.apiFilter != null) {
                        ImmutableSet fields = this.apiFilter.getDeclaredIntFields(clsName);
                        if ("java.util.zip.ZipEntry".equals(clsName)) {
                            fields = ImmutableSet.of((Object)"STORED", (Object)"DEFLATED");
                        }
                        if (fields != null) {
                            ArrayList sorted = new ArrayList(fields);
                            Collections.sort(sorted);
                            if (reflectionFields != null) {
                                int i;
                                HashMap<Object, Integer> rank = new HashMap<Object, Integer>();
                                int n = sorted.size();
                                for (i = 0; i < n; ++i) {
                                    rank.put(sorted.get(i), reflectionFields.length + i);
                                }
                                n = reflectionFields.length;
                                for (i = 0; i < n; ++i) {
                                    rank.put(reflectionFields[i].getName(), i);
                                }
                                sorted.sort((o1, o2) -> {
                                    int rank2;
                                    int rank1 = (Integer)rank.get(o1);
                                    int delta = rank1 - (rank2 = ((Integer)rank.get(o2)).intValue());
                                    if (delta != 0) {
                                        return delta;
                                    }
                                    return o1.compareTo((String)o2);
                                });
                            }
                            boolean first = true;
                            for (String field : sorted) {
                                if (first) {
                                    first = false;
                                } else {
                                    sb.append(',').append(' ');
                                }
                                sb.append(clsName).append('.').append(field);
                            }
                            found = true;
                        }
                    }
                    if (!found && reflectionFields != null && (this.apiFilter == null || this.apiFilter.hasClass(clsName))) {
                        boolean first = true;
                        for (Field field : reflectionFields) {
                            if (field.getType() != Integer.TYPE && field.getType() != Integer.TYPE) continue;
                            if (first) {
                                first = false;
                            } else {
                                sb.append(',').append(' ');
                            }
                            sb.append(clsName).append('.').append(field.getName());
                        }
                    }
                    sb.append('}');
                    value = sb.toString();
                    if (sb.length() > 2) {
                        found = true;
                    }
                }
                if (!found) {
                    return null;
                }
            }
            if (this.apiFilter != null) {
                value = this.removeFiltered(value);
                while (value.contains(", ,")) {
                    value = value.replace(", ,", ",");
                }
                if (value.startsWith(", ")) {
                    value = value.substring(2);
                }
            }
            annotation = new AnnotationData(valName.equals("stringValues") ? SdkConstants.STRING_DEF_ANNOTATION.defaultName() : SdkConstants.INT_DEF_ANNOTATION.defaultName(), new String[]{"value", value, flag ? "flag" : null, flag ? "true" : null});
        } else if (SdkConstants.STRING_DEF_ANNOTATION.isEquals(name) || ANDROID_STRING_DEF.equals(name) || SdkConstants.INT_DEF_ANNOTATION.isEquals(name) || ANDROID_INT_DEF.equals(name) || SdkConstants.LONG_DEF_ANNOTATION.isEquals(name) || ANDROID_LONG_DEF.equals(name)) {
            boolean longDef;
            List<Element> children = Extractor.getChildren(annotationElement);
            Element valueElement = children.get(0);
            String valName = valueElement.getAttribute("name");
            assert ("value".equals(valName));
            String value = valueElement.getAttribute(ATTR_VAL);
            boolean flag = false;
            if (children.size() == 2) {
                valueElement = children.get(1);
                assert ("flag".equals(valueElement.getAttribute("name")));
                flag = "true".equals(valueElement.getAttribute(ATTR_VAL));
            }
            boolean intDef = SdkConstants.INT_DEF_ANNOTATION.isEquals(name) || ANDROID_INT_DEF.equals(name);
            boolean bl = longDef = SdkConstants.LONG_DEF_ANNOTATION.isEquals(name) || ANDROID_LONG_DEF.equals(name);
            String annotationName = intDef ? (name.startsWith("androidx.") ? SdkConstants.INT_DEF_ANNOTATION.oldName() : SdkConstants.INT_DEF_ANNOTATION.oldName()) : (longDef ? (name.startsWith("androidx.") ? SdkConstants.LONG_DEF_ANNOTATION.oldName() : SdkConstants.LONG_DEF_ANNOTATION.oldName()) : (name.startsWith("androidx.") ? SdkConstants.STRING_DEF_ANNOTATION.newName() : SdkConstants.STRING_DEF_ANNOTATION.oldName()));
            annotation = new AnnotationData(annotationName, new String[]{"value", value, flag ? "flag" : null, flag ? "true" : null});
        } else if (IDEA_CONTRACT.equals(name)) {
            List<Element> children = Extractor.getChildren(annotationElement);
            Element valueElement = children.get(0);
            String value = valueElement.getAttribute(ATTR_VAL);
            String pure = valueElement.getAttribute(ATTR_PURE);
            annotation = pure != null && !pure.isEmpty() ? new AnnotationData(name, new String[]{"value", value, ATTR_PURE, pure}) : new AnnotationData(name, new String[]{"value", value});
        } else if (Extractor.isNonNull(name)) {
            annotation = new AnnotationData(SUPPORT_NOTNULL);
        } else if (Extractor.isNullable(name)) {
            if (IDEA_NULLABLE.equals(name)) {
                return null;
            }
            annotation = new AnnotationData(SUPPORT_NULLABLE);
        } else {
            List<Element> children = Extractor.getChildren(annotationElement);
            if (children.isEmpty()) {
                return new AnnotationData(name);
            }
            ArrayList<String> attributeStrings = new ArrayList<String>();
            for (Element valueElement : children) {
                attributeStrings.add(valueElement.getAttribute("name"));
                attributeStrings.add(valueElement.getAttribute(ATTR_VAL));
            }
            annotation = new AnnotationData(name, attributeStrings.toArray(new String[0]));
        }
        return annotation;
    }

    private String removeFiltered(String value) {
        assert (this.apiFilter != null);
        if (value.startsWith("{")) {
            value = value.substring(1);
        }
        if (value.endsWith("}")) {
            value = value.substring(0, value.length() - 1);
        }
        value = value.trim();
        StringBuilder sb = new StringBuilder(value.length());
        sb.append('{');
        for (String fqn : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value)) {
            String field;
            if ((fqn = Extractor.unescapeXml(fqn)).startsWith("\"")) continue;
            int index = fqn.lastIndexOf(46);
            String cls = fqn.substring(0, index);
            if (this.apiFilter.hasField(cls, field = fqn.substring(index + 1))) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(fqn);
                continue;
            }
            if (!this.isListIgnored()) continue;
            this.info("Skipping constant from typedef because it is not part of the SDK: " + fqn);
        }
        sb.append('}');
        return Extractor.escapeXml(sb.toString());
    }

    private static String getPackage(String fqn) {
        int index = 0;
        int last = 0;
        while ((index = fqn.indexOf(46, index)) != -1) {
            char next;
            last = index;
            if (index < fqn.length() - 1 && Character.isUpperCase(next = fqn.charAt(index + 1))) break;
            ++index;
        }
        return fqn.substring(0, last);
    }

    public void setListIgnored(boolean listIgnored) {
        this.listIgnored = listIgnored;
    }

    public boolean isListIgnored() {
        return this.listIgnored;
    }

    public AnnotationData createData(String name, UAnnotation annotation) {
        List pairs = annotation.getAttributeValues();
        if (pairs.isEmpty()) {
            return new AnnotationData(name);
        }
        return new AnnotationData(name, pairs);
    }

    private static boolean appendLiteralValue(StringBuilder sb, Object literalValue) {
        if (literalValue instanceof Number || literalValue instanceof Boolean) {
            sb.append(literalValue.toString());
            return true;
        }
        if (literalValue instanceof String || literalValue instanceof Character) {
            sb.append('\"');
            XmlUtils.appendXmlAttributeValue((StringBuilder)sb, (String)literalValue.toString());
            sb.append('\"');
            return true;
        }
        return false;
    }

    private static String getReturnType(PsiMethod method) {
        if (method.isConstructor()) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                return containingClass.getName();
            }
        } else {
            PsiType returnType = method.getReturnType();
            if (returnType != null) {
                return returnType.getCanonicalText();
            }
        }
        return null;
    }

    private static String getVariableType(PsiVariable variable) {
        PsiType type = variable.getType();
        return type.getCanonicalText();
    }

    private static String getMethodName(PsiMethod method) {
        if (method.isConstructor()) {
            return method.getName();
        }
        return method.getName();
    }

    private static String getParameterList(PsiMethod method) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        PsiParameterList parameterList = method.getParameterList();
        for (PsiParameter parameter : parameterList.getParameters()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            PsiType type = parameter.getType();
            sb.append(type.getCanonicalText());
        }
        return sb.toString();
    }

    private static boolean javadocContainsHide(PsiDocComment docComment) {
        String text;
        return docComment != null && (text = docComment.getText()).contains("@hide");
    }

    private static boolean javadocContainsHide(UElement element) {
        List comments = element.getComments();
        for (UComment comment : comments) {
            String text = comment.getText();
            if (!text.contains("@hide")) continue;
            return true;
        }
        return false;
    }

    public static boolean isHiddenTypeDef(UClass declaration) {
        return declaration.getVisibility() != UastVisibility.PUBLIC;
    }

    private class AnnotationVisitor
    extends AbstractUastVisitor {
        private List<String> privateTypedefs = new ArrayList<String>();
        private final boolean requireHide;
        private final boolean requireSourceRetention;

        public AnnotationVisitor(boolean requireHide, boolean requireSourceRetention) {
            this.requireHide = requireHide;
            this.requireSourceRetention = requireSourceRetention;
        }

        public List<String> getPrivateTypedefClasses() {
            return this.privateTypedefs;
        }

        public boolean visitMethod(UMethod method) {
            String fqn;
            MethodItem item;
            PsiClass containingClass = method.getContainingClass();
            if (Extractor.this.hasRelevantAnnotations((UAnnotated)method) && (item = MethodItem.create(containingClass, fqn = Extractor.this.getFqn(containingClass), (PsiMethod)method)) != null) {
                Extractor.this.addItem(fqn, item);
                boolean skipReturnAnnotations = false;
                if ("findViewById".equals(item.getName())) {
                    skipReturnAnnotations = true;
                    if (item.annotations.isEmpty()) {
                        Extractor.this.removeItem(fqn, item);
                    }
                }
                if (!skipReturnAnnotations) {
                    Extractor.this.addAnnotations((UAnnotated)method, item);
                }
            }
            List parameters = method.getUastParameters();
            int index = 0;
            for (UParameter parameter : parameters) {
                String fqn2;
                ParameterItem item2;
                if (Extractor.this.hasRelevantAnnotations((UAnnotated)parameter) && (item2 = ParameterItem.create(containingClass, fqn2 = Extractor.this.getFqn(containingClass), (PsiMethod)method, (PsiParameter)parameter, index)) != null) {
                    Extractor.this.addItem(fqn2, item2);
                    Extractor.this.addAnnotations((UAnnotated)parameter, item2);
                }
                ++index;
            }
            return true;
        }

        public boolean visitField(UField field) {
            String fqn;
            FieldItem item;
            PsiClass containingClass;
            if (Extractor.this.hasRelevantAnnotations((UAnnotated)field) && (containingClass = field.getContainingClass()) != null && (item = FieldItem.create(containingClass, fqn = Extractor.this.getFqn(containingClass), (PsiField)field)) != null) {
                Extractor.this.addItem(fqn, item);
                Extractor.this.addAnnotations((UAnnotated)field, item);
            }
            return true;
        }

        public boolean visitInitializer(UClassInitializer initializer) {
            return true;
        }

        public boolean visitFile(UFile node) {
            if (Extractor.this.hasRelevantAnnotations((UAnnotated)node)) {
                String fqn = node.getPackageName();
                PackageItem item = PackageItem.create(fqn);
                Extractor.this.addPackage(fqn, item);
                Extractor.this.addAnnotations((UAnnotated)node, item);
            }
            return super.visitFile(node);
        }

        public boolean visitClass(UClass aClass) {
            String fqn;
            super.visitClass(aClass);
            if (aClass instanceof UAnonymousClass) {
                return true;
            }
            if (aClass.isAnnotationType()) {
                for (UAnnotation annotation : aClass.getAnnotations()) {
                    String fqn2 = annotation.getQualifiedName();
                    if (!Extractor.isNestedAnnotation(fqn2)) continue;
                    if (this.requireHide && !Extractor.javadocContainsHide((UElement)aClass)) {
                        Extractor.warning(aClass.getQualifiedName() + ": This typedef annotation should specify @hide in a doc comment");
                    }
                    if (this.requireSourceRetention && !Extractor.hasSourceRetention((PsiClass)aClass)) {
                        String message = aClass.getQualifiedName() + ": The typedef annotation should have @Retention(RetentionPolicy.SOURCE)";
                        if ("true".equals(System.getProperty("android.typedef.enforce-retention"))) {
                            throw new ReflectiveLintRunner.ExtractErrorException(message);
                        }
                        Extractor.warning(message);
                    }
                    if (!Extractor.isHiddenTypeDef(aClass)) break;
                    String cls = Lint.getInternalName((PsiClass)aClass);
                    this.privateTypedefs.add(cls);
                    break;
                }
            }
            if (aClass.isAnnotationType() && Extractor.isHiddenTypeDef(aClass)) {
                return false;
            }
            if (Extractor.this.hasRelevantAnnotations((UAnnotated)aClass) && (fqn = Extractor.this.getFqn((PsiClass)aClass)) != null) {
                ClassItem item = ClassItem.create((PsiClass)aClass, fqn);
                Extractor.this.addItem(fqn, item);
                Extractor.this.addAnnotations((UAnnotated)aClass, item);
            }
            return false;
        }
    }

    private static class ParameterItem
    extends MethodItem {
        public final String argIndex;

        private ParameterItem(PsiClass psiClass, String containingClass, String returnType, String methodName, String parameterList, boolean isConstructor, String argIndex) {
            super(psiClass, containingClass, returnType, methodName, parameterList, isConstructor);
            this.argIndex = argIndex;
        }

        static ParameterItem create(PsiClass psiClass, String classFqn, PsiMethod method, PsiParameter parameter, int index) {
            if (classFqn == null) {
                return null;
            }
            String methodName = Extractor.getMethodName(method);
            String returnType = Extractor.getReturnType(method);
            if (methodName == null || returnType == null) {
                return null;
            }
            String parameterList = Extractor.getParameterList(method);
            String argNum = Integer.toString(index);
            return new ParameterItem(psiClass, classFqn, returnType, methodName, parameterList, method.isConstructor(), argNum);
        }

        @Override
        String getSignature() {
            return super.getSignature() + ' ' + this.argIndex;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ParameterItem that = (ParameterItem)o;
            return this.argIndex.equals(that.argIndex);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.argIndex.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "Parameter #" + this.argIndex + " in " + super.toString();
        }

        @Override
        public String getKeepRule() {
            return "";
        }
    }

    private static class MethodItem
    extends Item {
        public final String methodName;
        public final String parameterList;
        public final String returnType;
        public final boolean isConstructor;

        private MethodItem(PsiClass psiClass, String containingClass, String returnType, String methodName, String parameterList, boolean isConstructor) {
            super(psiClass, containingClass);
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterList = parameterList;
            this.isConstructor = isConstructor;
        }

        public String getName() {
            return this.methodName;
        }

        static MethodItem create(PsiClass psiClass, String classFqn, PsiMethod declaration) {
            if (classFqn == null) {
                return null;
            }
            String returnType = Extractor.getReturnType(declaration);
            String methodName = Extractor.getMethodName(declaration);
            if (returnType == null) {
                return null;
            }
            String parameterList = Extractor.getParameterList(declaration);
            return new MethodItem(psiClass, classFqn, returnType, methodName, parameterList, declaration.isConstructor());
        }

        @Override
        String getSignature() {
            StringBuilder sb = new StringBuilder(100);
            sb.append(Extractor.escapeXml(this.containingClass));
            sb.append(' ');
            if (this.isConstructor) {
                sb.append(Extractor.escapeXml(this.methodName));
            } else {
                assert (this.returnType != null);
                sb.append(Extractor.escapeXml(this.returnType));
                sb.append(' ');
                sb.append(Extractor.escapeXml(this.methodName));
            }
            sb.append('(');
            int balance = 0;
            int n = this.parameterList.length();
            for (int i = 0; i < n; ++i) {
                char c = this.parameterList.charAt(i);
                if (c == '<') {
                    ++balance;
                    sb.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    --balance;
                    sb.append("&gt;");
                    continue;
                }
                if (c == ',') {
                    sb.append(',');
                    if (balance != 0) continue;
                    sb.append(' ');
                    continue;
                }
                sb.append(c);
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasMethod(this.containingClass, this.methodName, this.parameterList);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodItem that = (MethodItem)o;
            return this.isConstructor == that.isConstructor && this.containingClass.equals(that.containingClass) && this.methodName.equals(that.methodName) && this.parameterList.equals(that.parameterList);
        }

        public int hashCode() {
            int result = this.methodName.hashCode();
            result = 31 * result + this.containingClass.hashCode();
            result = 31 * result + this.parameterList.hashCode();
            result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
            result = 31 * result + (this.isConstructor ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Method " + this.containingClass + "#" + this.methodName;
        }

        @Override
        public String getKeepRule() {
            StringBuilder sb = new StringBuilder();
            sb.append("-keep ");
            sb.append(ClassKind.forClass(this.psiClass).getKeepType());
            sb.append(" ");
            sb.append(this.containingClass);
            sb.append(" {\n");
            sb.append("    ");
            if (this.isConstructor) {
                sb.append("<init>");
            } else {
                sb.append(this.returnType);
                sb.append(" ");
                sb.append(this.methodName);
            }
            sb.append("(");
            sb.append(this.parameterList);
            sb.append(")\n");
            sb.append("}\n");
            return sb.toString();
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }
    }

    private static class FieldItem
    extends Item {
        public final String fieldName;
        public final String fieldType;

        private FieldItem(PsiClass psiClass, String containingClass, String fieldName, String fieldType) {
            super(psiClass, containingClass);
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        static FieldItem create(PsiClass psiClass, String classFqn, PsiField field) {
            if (classFqn == null) {
                return null;
            }
            String name = field.getName();
            String type = Extractor.getVariableType((PsiVariable)field);
            if (name != null && type != null) {
                return new FieldItem(psiClass, classFqn, name, type);
            }
            return null;
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasField(this.containingClass, this.fieldName);
        }

        @Override
        String getSignature() {
            return Extractor.escapeXml(this.containingClass) + ' ' + this.fieldName;
        }

        @Override
        public String getKeepRule() {
            if (this.fieldType == null) {
                return "";
            }
            return "-keep " + ClassKind.forClass(this.psiClass).getKeepType() + " " + this.containingClass + " {\n    " + this.fieldType + " " + this.fieldName + "\n}\n";
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }

        public String toString() {
            return "Field " + this.containingClass + "#" + this.fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldItem that = (FieldItem)o;
            return this.containingClass.equals(that.containingClass) && this.fieldName.equals(that.fieldName);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + this.containingClass.hashCode();
            return result;
        }
    }

    private static class PackageItem
    extends Item {
        private PackageItem(String containingClass) {
            super(null, containingClass);
        }

        static PackageItem create(String fqn) {
            return new PackageItem(fqn);
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasPackage(this.containingClass);
        }

        @Override
        String getSignature() {
            return Extractor.escapeXml(this.containingClass);
        }

        @Override
        public String getKeepRule() {
            return "";
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }

        public String toString() {
            return "Package " + this.containingClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackageItem that = (PackageItem)o;
            return this.containingClass.equals(that.containingClass);
        }

        public int hashCode() {
            return this.containingClass.hashCode();
        }
    }

    private static class ClassItem
    extends Item {
        private ClassItem(PsiClass psiClass, String containingClass) {
            super(psiClass, containingClass);
        }

        static ClassItem create(PsiClass psiClass, String classFqn) {
            return new ClassItem(psiClass, classFqn);
        }

        @Override
        boolean isFiltered(ApiDatabase database) {
            return !database.hasClass(this.containingClass);
        }

        @Override
        String getSignature() {
            return Extractor.escapeXml(this.containingClass);
        }

        @Override
        public String getKeepRule() {
            return "-keep " + ClassKind.forClass(this.psiClass).getKeepType() + " " + this.containingClass + "\n";
        }

        @Override
        public String getQualifiedClassName() {
            return this.containingClass;
        }

        public String toString() {
            return "Class " + this.containingClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassItem that = (ClassItem)o;
            return this.containingClass.equals(that.containingClass);
        }

        public int hashCode() {
            return this.containingClass.hashCode();
        }
    }

    private static abstract class Item
    implements Comparable<Item> {
        public final String containingClass;
        public final PsiClass psiClass;
        public final List<AnnotationData> annotations = new ArrayList<AnnotationData>();

        public Item(PsiClass psiClass, String containingClass) {
            this.psiClass = psiClass;
            this.containingClass = containingClass;
        }

        void write(StringPrintWriter writer) {
            if (this.annotations.isEmpty()) {
                return;
            }
            writer.print("  <item name=\"");
            writer.print(this.getSignature());
            writer.println("\">");
            for (AnnotationData annotation : this.annotations) {
                annotation.write(writer);
            }
            writer.print("  </item>");
            writer.println();
        }

        abstract boolean isFiltered(ApiDatabase var1);

        abstract String getSignature();

        @Override
        public int compareTo(Item item) {
            String signature1 = this.getSignature();
            String signature2 = item.getSignature();
            signature1 = signature1.replace('&', '.');
            signature2 = signature2.replace('&', '.');
            return signature1.compareTo(signature2);
        }

        public abstract String getKeepRule();

        public abstract String getQualifiedClassName();
    }

    public static enum ClassKind {
        CLASS,
        INTERFACE,
        ENUM,
        ANNOTATION;


        public static ClassKind forClass(PsiClass declaration) {
            if (declaration == null) {
                return CLASS;
            }
            if (declaration.isEnum()) {
                return ENUM;
            }
            if (declaration.isAnnotationType()) {
                return ANNOTATION;
            }
            if (declaration.isInterface()) {
                return INTERFACE;
            }
            return CLASS;
        }

        public String getKeepType() {
            switch (this) {
                case INTERFACE: {
                    return "interface";
                }
                case ENUM: {
                    return "enum";
                }
            }
            return "class";
        }

        public String toString() {
            return this.getKeepType();
        }
    }

    private class AnnotationData {
        public final String name;
        public String[] attributeStrings;
        public List<UNamedExpression> attributes;

        private AnnotationData(String name) {
            this.name = name;
        }

        private AnnotationData(String name, List<UNamedExpression> pairs) {
            this(name);
            this.attributes = pairs;
            assert (this.attributes == null || !this.attributes.isEmpty());
        }

        private AnnotationData(String name, String[] attributeStrings) {
            this(name);
            this.attributeStrings = attributeStrings;
            assert (attributeStrings != null && attributeStrings.length > 0);
        }

        void write(StringPrintWriter writer) {
            writer.mark();
            writer.print("    <annotation name=\"");
            writer.print(this.name);
            if (this.attributes != null) {
                List attributes;
                writer.print("\">");
                writer.println();
                if (this.attributes.size() > 1 && Extractor.this.sortAnnotations) {
                    this.attributes = new ArrayList<UNamedExpression>(this.attributes);
                    this.attributes.sort(new Comparator<UNamedExpression>(){

                        private String getName(UNamedExpression pair) {
                            String name = pair.getName();
                            if (name == null) {
                                return "value";
                            }
                            return name;
                        }

                        private int rank(UNamedExpression pair) {
                            return "value".equals(this.getName(pair)) ? -1 : 0;
                        }

                        @Override
                        public int compare(UNamedExpression o1, UNamedExpression o2) {
                            int r2;
                            int r1 = this.rank(o1);
                            int delta = r1 - (r2 = this.rank(o2));
                            if (delta != 0) {
                                return delta;
                            }
                            return this.getName(o1).compareTo(this.getName(o2));
                        }
                    });
                }
                if ((attributes = this.attributes).size() == 1 && REQUIRES_PERMISSION.isPrefix(this.name, true)) {
                    PsiAnnotationMemberValue memberValue;
                    JavaUAnnotation annotation;
                    UExpression expression = attributes.get(0).getExpression();
                    if (expression instanceof UAnnotation) {
                        UAnnotation annotation2 = (UAnnotation)expression;
                        attributes = annotation2.getAttributeValues();
                    } else if (expression instanceof JavaUAnnotationCallExpression) {
                        JavaUAnnotationCallExpression callExpression = (JavaUAnnotationCallExpression)expression;
                        annotation = callExpression.getUAnnotation();
                        attributes = annotation.getAttributeValues();
                    } else if (expression instanceof UastEmptyExpression && ((UNamedExpression)attributes.get(0)).getPsi() instanceof PsiNameValuePair && (memberValue = ((PsiNameValuePair)((UNamedExpression)attributes.get(0)).getPsi()).getValue()) instanceof PsiAnnotation) {
                        annotation = JavaUAnnotation.wrap((PsiAnnotation)((PsiAnnotation)memberValue));
                        attributes = annotation.getAttributeValues();
                    }
                }
                boolean empty = true;
                for (UNamedExpression pair : attributes) {
                    UExpression expression = pair.getExpression();
                    String value = this.attributeString(expression);
                    if (value == null) continue;
                    empty = false;
                    String name = pair.getName();
                    if (name == null) {
                        name = "value";
                    }
                    if (!(!"prefix".equals(name) && !"suffix".equals(name) || !SdkConstants.INT_DEF_ANNOTATION.isEquals(this.name) && !SdkConstants.LONG_DEF_ANNOTATION.isEquals(this.name) && !SdkConstants.STRING_DEF_ANNOTATION.isEquals(this.name) && !Extractor.ANDROID_INT_DEF.equals(this.name) && !Extractor.ANDROID_LONG_DEF.equals(this.name) && !Extractor.ANDROID_STRING_DEF.equals(this.name))) continue;
                    writer.print("      <val name=\"");
                    writer.print(name);
                    writer.print("\" val=\"");
                    writer.print(Extractor.escapeXml(value));
                    writer.println("\" />");
                }
                if (empty) {
                    writer.reset();
                    return;
                }
                writer.println("    </annotation>");
            } else if (this.attributeStrings != null) {
                writer.print("\">");
                writer.println();
                for (int i = 0; i < this.attributeStrings.length; i += 2) {
                    String name = this.attributeStrings[i];
                    String value = this.attributeStrings[i + 1];
                    if (name == null) continue;
                    writer.print("      <val name=\"");
                    writer.print(name);
                    writer.print("\" val=\"");
                    writer.print(Extractor.escapeXml(value));
                    writer.println("\" />");
                }
                writer.println("    </annotation>");
            } else {
                writer.println("\" />");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData that = (AnnotationData)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        private String attributeString(UExpression value) {
            StringBuilder sb = new StringBuilder();
            if (value != null && this.appendExpression(sb, value)) {
                return sb.toString();
            }
            return null;
        }

        private boolean appendExpression(StringBuilder sb, UExpression expression) {
            Object literalValue;
            if (UastExpressionUtils.isArrayInitializer((UElement)expression)) {
                UCallExpression call = (UCallExpression)expression;
                List initializers = call.getValueArguments();
                sb.append('{');
                boolean first = true;
                int initialLength = sb.length();
                for (UExpression e : initializers) {
                    boolean appended;
                    int length = sb.length();
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    if (appended = this.appendExpression(sb, e)) continue;
                    sb.setLength(length);
                    if (length != initialLength) continue;
                    first = true;
                }
                sb.append('}');
                return sb.length() != 2;
            }
            if (expression instanceof UReferenceExpression) {
                UReferenceExpression referenceExpression = (UReferenceExpression)expression;
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiField) {
                    Object value;
                    PsiField field = (PsiField)resolved;
                    if (!this.isInlinedConstant() && Extractor.appendLiteralValue(sb, value = field.computeConstantValue())) {
                        return true;
                    }
                    PsiClass declaringClass = field.getContainingClass();
                    if (declaringClass == null) {
                        Extractor.error("No containing class found for " + field.getName());
                        return false;
                    }
                    String qualifiedName = declaringClass.getQualifiedName();
                    String fieldName = field.getName();
                    if (qualifiedName != null && fieldName != null) {
                        if (Extractor.this.apiFilter != null && !Extractor.this.apiFilter.hasField(qualifiedName, fieldName)) {
                            if (Extractor.this.isListIgnored()) {
                                Extractor.this.info("Filtering out typedef constant " + qualifiedName + "." + fieldName + "");
                            }
                            return false;
                        }
                        sb.append(qualifiedName);
                        sb.append('.');
                        sb.append(fieldName);
                        return true;
                    }
                    return false;
                }
                Extractor.warning("Unexpected reference to " + resolved);
                return false;
            }
            if (expression instanceof ULiteralExpression) {
                ULiteralExpression literal = (ULiteralExpression)expression;
                Object literalValue2 = literal.getValue();
                if (Extractor.appendLiteralValue(sb, literalValue2)) {
                    return true;
                }
            } else if (expression instanceof UBinaryExpressionWithType) {
                if (UastExpressionUtils.isTypeCast((UElement)expression)) {
                    UBinaryExpressionWithType cast = (UBinaryExpressionWithType)expression;
                    UExpression operand = cast.getOperand();
                    return this.appendExpression(sb, operand);
                }
                return false;
            }
            if ((literalValue = ConstantEvaluator.evaluate(null, (UElement)expression)) != null && Extractor.appendLiteralValue(sb, literalValue)) {
                return true;
            }
            Extractor.warning("Unexpected annotation expression of type " + expression.getClass() + " and is " + expression);
            return false;
        }

        private boolean isInlinedConstant() {
            return SdkConstants.INT_DEF_ANNOTATION.isEquals(this.name) || SdkConstants.LONG_DEF_ANNOTATION.isEquals(this.name) || SdkConstants.STRING_DEF_ANNOTATION.isEquals(this.name) || SYSTEM_SERVICE.isEquals(this.name);
        }
    }

    private static class StringPrintWriter
    extends PrintWriter {
        private final StringWriter stringWriter;
        private int mark;

        private StringPrintWriter(StringWriter stringWriter) {
            super(stringWriter);
            this.stringWriter = stringWriter;
        }

        public void mark() {
            this.flush();
            this.mark = this.stringWriter.getBuffer().length();
        }

        public void reset() {
            this.stringWriter.getBuffer().setLength(this.mark);
        }

        public String getContents() {
            return this.stringWriter.toString();
        }

        public String toString() {
            return this.getContents();
        }

        public static StringPrintWriter create() {
            return new StringPrintWriter(new StringWriter(1000));
        }
    }
}

