/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.SarifReporterKt;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.gradle.SyncOptionsKt$WhenMappings;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.tools.lint.model.LintModelSeverity;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a4\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001aD\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\t\u001a\u000e\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001\u001a\"\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0002\u00a8\u0006!"}, d2={"createOutputPath", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "variantName", "", "extension", "reportsDir", "fatalOnly", "", "getSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "modelSeverity", "Lcom/android/tools/lint/model/LintModelSeverity;", "isStdErr", "output", "isStdOut", "syncTo", "", "options", "Lcom/android/tools/lint/model/LintModelLintOptions;", "client", "Lcom/android/tools/lint/LintCliClient;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "report", "validateOutputFile", "outputFile", "warnSarifCompat", "used", "file", "lint-gradle"})
public final class SyncOptionsKt {
    public static final void syncTo(@NotNull LintModelLintOptions options, @NotNull LintCliClient client2, @NotNull LintCliFlags flags, @Nullable String variantName, @Nullable Project project, @Nullable File reportsDir, boolean report) {
        Writer id;
        Reporter reporter;
        block59: {
            block56: {
                Set check;
                Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                Intrinsics.checkParameterIsNotNull((Object)client2, (String)"client");
                Intrinsics.checkParameterIsNotNull((Object)flags, (String)"flags");
                Set disabled = options.getDisable();
                Collection collection = disabled;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    for (String id2 : disabled) {
                        Category category3 = Category.Companion.getCategory(id2);
                        if (category3 != null) {
                            flags.addDisabledCategory(category3);
                            continue;
                        }
                        flags.getSuppressedIds().add(id2);
                    }
                }
                Set enabled = options.getEnable();
                Collection collection2 = enabled;
                boolean category3 = false;
                if (!collection2.isEmpty()) {
                    for (String id3 : enabled) {
                        Category category2 = Category.Companion.getCategory(id3);
                        if (category2 != null) {
                            flags.addEnabledCategory(category2);
                            continue;
                        }
                        flags.getEnabledIds().add(id3);
                    }
                }
                if ((check = options.getCheck()) != null) {
                    Collection category3 = check;
                    boolean category2 = false;
                    if (!category3.isEmpty()) {
                        for (String id4 : check) {
                            Category category4 = Category.Companion.getCategory(id4);
                            if (category4 != null) {
                                flags.addExactCategory(category4);
                                continue;
                            }
                            flags.addExactId(id4);
                        }
                    }
                }
                flags.setSetExitCode(options.getAbortOnError());
                flags.setFullPath(options.getAbsolutePaths());
                flags.setShowSourceLines(!options.getNoLines());
                flags.setQuiet(options.getQuiet());
                flags.setCheckAllWarnings(options.getCheckAllWarnings());
                flags.setIgnoreWarnings(options.getIgnoreWarnings());
                flags.setWarningsAsErrors(options.getWarningsAsErrors());
                flags.setCheckTestSources(options.getCheckTestSources());
                flags.setIgnoreTestSources(options.getIgnoreTestSources());
                flags.setCheckGeneratedSources(options.getCheckGeneratedSources());
                flags.setCheckDependencies(options.getCheckDependencies());
                flags.setShowEverything(options.getShowAll());
                flags.setLintConfig(options.getLintConfig());
                flags.setExplainIssues(options.getExplainIssues());
                flags.setBaselineFile(options.getBaselineFile());
                Map severityOverrides = options.getSeverityOverrides();
                if (severityOverrides == null) break block56;
                boolean category4 = false;
                Map map = new LinkedHashMap();
                BuiltinIssueRegistry registry = new BuiltinIssueRegistry();
                Object object = severityOverrides;
                boolean bl2 = false;
                Iterator iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    Issue issue;
                    block58: {
                        block57: {
                            Reporter reporter2 = reporter = iterator.next();
                            boolean bl3 = false;
                            object = (String)reporter2.getKey();
                            reporter2 = reporter;
                            bl3 = false;
                            LintModelSeverity severityInt = (LintModelSeverity)reporter2.getValue();
                            Issue issue2 = registry.getIssue((String)((Object)id));
                            issue = issue2;
                            if (issue == null) break block57;
                            Issue issue3 = issue;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Issue it = issue3;
                            boolean bl6 = false;
                            issue = SyncOptionsKt.getSeverity(it, severityInt);
                            if (issue != null) break block58;
                        }
                        issue = Severity.WARNING;
                    }
                    Issue severity = issue;
                    Category category5 = Category.Companion.getCategory((String)((Object)id));
                    if (category5 != null) {
                        for (Issue current : registry.getIssues()) {
                            Category currentCategory = current.getCategory();
                            if (currentCategory != category5 && currentCategory.getParent() != category5) continue;
                            map.put(current.getId(), severity);
                        }
                        continue;
                    }
                    map.put(id, severity);
                }
                flags.setSeverityOverrides(map);
                break block59;
            }
            flags.setSeverityOverrides(MapsKt.emptyMap());
        }
        if (report || flags.isFatalOnly() && options.getAbortOnError()) {
            Reporter reporter3;
            if (options.getTextReport() || flags.isFatalOnly()) {
                Reporter reporter4;
                File output = options.getTextOutput();
                if (output == null) {
                    output = new File(flags.isFatalOnly() ? "stderr" : "stdout");
                } else if (!(output.isAbsolute() || SyncOptionsKt.isStdOut(output) || SyncOptionsKt.isStdErr(output) || project == null)) {
                    output = project.file((Object)output.getPath());
                }
                File file = output;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                output = SyncOptionsKt.validateOutputFile(file);
                Writer writer = null;
                File file2 = null;
                boolean closeWriter = false;
                if (SyncOptionsKt.isStdOut(output)) {
                    writer = new PrintWriter(System.out, true);
                    closeWriter = false;
                } else if (SyncOptionsKt.isStdErr(output)) {
                    writer = new PrintWriter(System.err, true);
                    closeWriter = false;
                } else {
                    file2 = output;
                    try {
                        id = new BufferedWriter(new FileWriter(output));
                    }
                    catch (IOException e) {
                        throw (Throwable)new GradleException("Text invalid argument.", (Throwable)e);
                    }
                    writer = id;
                    closeWriter = true;
                }
                if (SarifReporterKt.isSarifFile((File)output)) {
                    Reporter e = Reporter.Companion.createSarifReporter(client2, output);
                    boolean issue2 = false;
                    boolean bl = false;
                    Reporter it = e;
                    boolean bl7 = false;
                    SyncOptionsKt.warnSarifCompat(client2, "textOutput", options.getTextOutput());
                    reporter4 = e;
                } else {
                    reporter4 = (Reporter)Reporter.Companion.createTextReporter(client2, flags, file2, writer, closeWriter);
                }
                Reporter reporter5 = reporter4;
                flags.getReporters().add(reporter5);
            }
            if (options.getHtmlReport()) {
                File output = options.getHtmlOutput();
                if (output == null || flags.isFatalOnly()) {
                    output = SyncOptionsKt.createOutputPath(project, variantName, ".html", reportsDir, flags.isFatalOnly());
                } else if (!output.isAbsolute() && project != null) {
                    output = project.file((Object)output.getPath());
                }
                File file = output;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                output = SyncOptionsKt.validateOutputFile(file);
                try {
                    Reporter reporter6;
                    if (SarifReporterKt.isSarifFile((File)output)) {
                        reporter = Reporter.Companion.createSarifReporter(client2, output);
                        boolean bl = false;
                        boolean bl8 = false;
                        Reporter it = reporter;
                        boolean bl9 = false;
                        SyncOptionsKt.warnSarifCompat(client2, "htmlOutput", options.getHtmlOutput());
                        reporter6 = reporter;
                    } else {
                        reporter6 = Reporter.Companion.createHtmlReporter(client2, output, flags);
                    }
                    reporter3 = reporter6;
                    flags.getReporters().add(reporter3);
                }
                catch (IOException e) {
                    throw (Throwable)new GradleException("HTML invalid argument.", (Throwable)e);
                }
            }
            if (options.getXmlReport()) {
                File output = options.getXmlOutput();
                if (output == null || flags.isFatalOnly()) {
                    output = SyncOptionsKt.createOutputPath(project, variantName, ".xml", reportsDir, flags.isFatalOnly());
                } else if (!output.isAbsolute() && project != null) {
                    output = project.file((Object)output.getPath());
                }
                File file = output;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                output = SyncOptionsKt.validateOutputFile(file);
                try {
                    Reporter reporter7;
                    if (SarifReporterKt.isSarifFile((File)output)) {
                        reporter = Reporter.Companion.createSarifReporter(client2, output);
                        boolean bl = false;
                        boolean bl10 = false;
                        Reporter it = reporter;
                        boolean bl11 = false;
                        SyncOptionsKt.warnSarifCompat(client2, "xmlOutput", options.getXmlOutput());
                        reporter7 = reporter;
                    } else {
                        reporter7 = (Reporter)Reporter.Companion.createXmlReporter(client2, output, false, flags.isIncludeXmlFixes());
                    }
                    reporter3 = reporter7;
                    flags.getReporters().add(reporter3);
                }
                catch (IOException e) {
                    throw (Throwable)new GradleException("XML invalid argument.", (Throwable)e);
                }
            }
            if (options.getSarifReport()) {
                File output = options.getSarifOutput();
                if (output == null || flags.isFatalOnly()) {
                    output = SyncOptionsKt.createOutputPath(project, variantName, ".sarif", reportsDir, flags.isFatalOnly());
                } else if (!output.isAbsolute() && project != null) {
                    output = project.file((Object)output.getPath());
                }
                File file = output;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                output = SyncOptionsKt.validateOutputFile(file);
                try {
                    reporter3 = Reporter.Companion.createSarifReporter(client2, output);
                    flags.getReporters().add(reporter3);
                }
                catch (IOException e) {
                    throw (Throwable)new GradleException("SARIF invalid argument.", (Throwable)e);
                }
            }
        }
    }

    private static final void warnSarifCompat(LintCliClient client2, String used, File file) {
        StringBuilder stringBuilder = new StringBuilder().append(used).append('(');
        Object object = file;
        if (object == null || (object = ((File)object).getName()) == null) {
            object = "";
        }
        client2.log(Severity.WARNING, null, stringBuilder.append((String)object).append("): Use sarifOutput() instead").toString(), new Object[0]);
    }

    private static final Severity getSeverity(Issue issue, LintModelSeverity modelSeverity) {
        Severity severity;
        switch (SyncOptionsKt$WhenMappings.$EnumSwitchMapping$0[modelSeverity.ordinal()]) {
            case 1: {
                severity = Severity.FATAL;
                break;
            }
            case 2: {
                severity = Severity.ERROR;
                break;
            }
            case 3: {
                severity = Severity.WARNING;
                break;
            }
            case 4: {
                severity = Severity.INFORMATIONAL;
                break;
            }
            case 5: {
                severity = Severity.IGNORE;
                break;
            }
            case 6: {
                severity = issue.getDefaultSeverity();
                break;
            }
            default: {
                severity = Severity.WARNING;
            }
        }
        return severity;
    }

    private static final boolean isStdOut(File output) {
        return Intrinsics.areEqual((Object)"stdout", (Object)output.getPath());
    }

    private static final boolean isStdErr(File output) {
        return Intrinsics.areEqual((Object)"stderr", (Object)output.getPath());
    }

    @NotNull
    public static final File validateOutputFile(@NotNull File outputFile) {
        boolean delete;
        boolean ok;
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        File output = outputFile;
        if (SyncOptionsKt.isStdOut(output) || SyncOptionsKt.isStdErr(output)) {
            return output;
        }
        File parent = output.getParentFile();
        if (!parent.exists() && !(ok = parent.mkdirs())) {
            throw (Throwable)new GradleException("Could not create directory " + parent);
        }
        File file = output.getAbsoluteFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"output.absoluteFile");
        output = file;
        if (output.exists() && !(delete = output.delete())) {
            throw (Throwable)new GradleException("Could not delete old " + output);
        }
        if (output.getParentFile() != null && !output.getParentFile().canWrite()) {
            throw (Throwable)new GradleException("Cannot write output file " + output);
        }
        return output;
    }

    @NotNull
    public static final File createOutputPath(@Nullable Project project, @Nullable String variantName, @NotNull String extension, @Nullable File reportsDir, boolean fatalOnly) {
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        StringBuilder base = new StringBuilder();
        base.append("lint-results");
        CharSequence charSequence = variantName;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            base.append("-");
            base.append(variantName);
        }
        if (fatalOnly) {
            base.append("-fatal");
        }
        base.append(extension);
        return reportsDir != null ? new File(reportsDir, base.toString()) : (project == null ? new File(base.toString()) : new File(project.getBuildDir(), "reports" + File.separator + base));
    }
}

