/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.kotlin;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.kotlin.KotlinUastBindingContextProviderService;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"computeKotlinArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "lint-kotlin"})
@JvmName(name="LintKotlinUtils")
public final class LintKotlinUtils {
    @Nullable
    public static final Map<UExpression, PsiParameter> computeKotlinArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) {
        Object parameter2;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiElement psiElement = call.getPsi();
        if (!(psiElement instanceof KtElement)) {
            psiElement = null;
        }
        KtElement ktElement = (KtElement)psiElement;
        if (ktElement == null) {
            return null;
        }
        KtElement receiver = ktElement;
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        if (psiParameterList.getParametersCount() < 2) {
            return null;
        }
        KotlinUastBindingContextProviderService kotlinUastBindingContextProviderService = (KotlinUastBindingContextProviderService)ServiceManager.getService((Project)receiver.getProject(), KotlinUastBindingContextProviderService.class);
        if (kotlinUastBindingContextProviderService == null) {
            return null;
        }
        KotlinUastBindingContextProviderService service = kotlinUastBindingContextProviderService;
        BindingContext bindingContext = service.getBindingContext(receiver);
        PsiParameterList psiParameterList2 = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList2, (String)"method.parameterList");
        PsiParameter[] parameters = psiParameterList2.getParameters();
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)receiver, (BindingContext)bindingContext);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        Map valueArguments = resolvedCall2.getValueArguments();
        Map elementMap = new LinkedHashMap();
        for (Object parameter2 : call.getValueArguments()) {
            PsiElement psiElement2 = parameter2.getPsi();
            if (psiElement2 == null) {
                continue;
            }
            elementMap.put(psiElement2, parameter2);
        }
        Map map = valueArguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"valueArguments");
        parameter2 = map;
        if (!parameter2.isEmpty()) {
            int firstParameterIndex = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"parameters");
            Object[] objectArray = parameters;
            Object object = objectArray;
            if (!(((Object[])object).length == 0)) {
                PsiParameter psiParameter = parameters[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameters[0]");
                if (Intrinsics.areEqual((Object)"$receiver", (Object)psiParameter.getName())) {
                    ++firstParameterIndex;
                }
            }
            Map mapping = new LinkedHashMap();
            Map map2 = valueArguments;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                ResolvedValueArgument valueArgument;
                Object object2 = object = iterator.next();
                ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)object2.getKey();
                object2 = object;
                ResolvedValueArgument resolvedValueArgument = valueArgument = (ResolvedValueArgument)object2.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"valueArgument");
                for (ValueArgument argument : resolvedValueArgument.getArguments()) {
                    UExpression arg;
                    KtExpression expression;
                    if (argument.getArgumentExpression() == null) {
                        continue;
                    }
                    if ((UExpression)elementMap.get(expression) == null) {
                        continue;
                    }
                    int index = firstParameterIndex + parameterDescriptor.getIndex();
                    if (index >= ((Object[])parameters).length) continue;
                    PsiParameter psiParameter = parameters[index];
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameters[index]");
                    mapping.put(arg, psiParameter);
                }
            }
            object = mapping;
            if (!object.isEmpty()) {
                return mapping;
            }
        }
        return null;
    }
}

