/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.manager;

import com.android.repository.api.Channel;
import com.android.repository.api.Downloader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.Repository;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.manager.RemoteRepoLoader;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.repository.util.InstallerUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.w3c.dom.ls.LSResourceResolver;

public class RemoteRepoLoaderImpl
implements RemoteRepoLoader {
    private final LSResourceResolver mResourceResolver;
    private FallbackRemoteRepoLoader mFallback;
    private final Collection<RepositorySourceProvider> mSourceProviders;

    public RemoteRepoLoaderImpl(Collection<RepositorySourceProvider> sources, LSResourceResolver resourceResolver, FallbackRemoteRepoLoader fallback) {
        this.mResourceResolver = resourceResolver;
        this.mSourceProviders = sources;
        this.mFallback = fallback;
    }

    @Override
    public Map<String, RemotePackage> fetchPackages(ProgressIndicator progress, Downloader downloader, SettingsController settings) {
        HashMap result = Maps.newHashMap();
        for (RepositorySourceProvider provider : this.mSourceProviders) {
            for (RepositorySource source : provider.getSources(downloader, progress, false)) {
                if (!source.isEnabled()) continue;
                try {
                    InputStream repoStream = downloader.downloadAndStream(new URL(source.getUrl()), progress);
                    final ArrayList errors = Lists.newArrayList();
                    ProgressIndicatorAdapter unmarshalProgress = new ProgressIndicatorAdapter(){

                        @Override
                        public void logWarning(String s, Throwable e) {
                            errors.add(s);
                            if (e != null) {
                                errors.add(e.toString());
                            }
                        }

                        @Override
                        public void logError(String s, Throwable e) {
                            errors.add(s);
                            if (e != null) {
                                errors.add(e.toString());
                            }
                        }
                    };
                    Repository repo = null;
                    try {
                        repo = (Repository)SchemaModuleUtil.unmarshal(repoStream, source.getPermittedModules(), this.mResourceResolver, true, unmarshalProgress);
                    }
                    catch (JAXBException e) {
                        errors.add(e.toString());
                    }
                    Collection<RemotePackage> parsedPackages = null;
                    boolean legacy = false;
                    if (repo != null) {
                        parsedPackages = repo.getRemotePackage();
                    } else if (this.mFallback != null) {
                        parsedPackages = this.mFallback.parseLegacyXml(source, downloader, settings, progress);
                        legacy = true;
                    }
                    if (parsedPackages != null && !parsedPackages.isEmpty()) {
                        for (RemotePackage remotePackage : parsedPackages) {
                            Channel settingsChannel;
                            String existingProtocol;
                            URL existingUrl;
                            int compare;
                            RemotePackage existing = (RemotePackage)result.get(remotePackage.getPath());
                            if (existing != null && ((compare = existing.getVersion().compareTo(remotePackage.getVersion())) > 0 || compare == 0 && (legacy || (existingUrl = InstallerUtil.resolveCompleteArchiveUrl(existing, progress)) != null && (existingProtocol = existingUrl.getProtocol()).equals("file")))) continue;
                            Channel channel = settingsChannel = settings == null || settings.getChannel() == null ? Channel.DEFAULT : settings.getChannel();
                            if (remotePackage.getArchive() == null || remotePackage.getChannel().compareTo(settingsChannel) > 0) continue;
                            remotePackage.setSource(source);
                            result.put(remotePackage.getPath(), remotePackage);
                        }
                        source.setFetchError(null);
                        continue;
                    }
                    progress.logWarning("Errors during XML parse:");
                    for (String string : errors) {
                        progress.logWarning(string);
                    }
                    if (this.mFallback != null) {
                        progress.logWarning("Additionally, the fallback loader failed to parse the XML.");
                    }
                    source.setFetchError(errors.isEmpty() ? "unknown error" : (String)errors.get(0));
                }
                catch (MalformedURLException e) {
                    source.setFetchError("Malformed URL");
                    progress.logWarning(e.toString());
                }
                catch (IOException e) {
                    source.setFetchError(e.getMessage());
                    progress.logWarning(e.toString());
                }
            }
        }
        return result;
    }
}

