/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.testframework;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.repository.testframework.MockFileOp;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;

public class FakeDownloader
implements Downloader {
    private final MockFileOp mFileOp;
    private final Map<URL, byte[]> mRegisteredFiles = Maps.newHashMap();

    public FakeDownloader(MockFileOp fop) {
        this.mFileOp = fop;
    }

    public void registerUrl(URL url, byte[] data) {
        this.mRegisteredFiles.put(url, data);
    }

    public void registerUrl(URL url, InputStream content) throws IOException {
        byte[] data = ByteStreams.toByteArray((InputStream)content);
        this.mRegisteredFiles.put(url, data);
    }

    public String getFileName(URL url) {
        return "/tmp" + url.getFile();
    }

    @Override
    public InputStream downloadAndStream(URL url, ProgressIndicator indicator) throws IOException {
        byte[] content = this.mRegisteredFiles.get(url);
        if (content == null) {
            throw new IOException("no content at " + url);
        }
        ByteArrayInputStream toWrap = new ByteArrayInputStream(content);
        return new ReopeningInputStream(toWrap);
    }

    @Override
    public Path downloadFully(URL url, ProgressIndicator indicator) throws IOException {
        File file = new File(FileOpUtils.getNewTempDir("FakeDownloader", this.mFileOp), url.getFile());
        this.mFileOp.recordExistingFile(file.getPath(), this.mRegisteredFiles.get(url));
        return this.mFileOp.toPath(file);
    }

    @Override
    public void downloadFully(URL url, File target, String checksum, ProgressIndicator indicator) throws IOException {
        this.mFileOp.recordExistingFile(this.mFileOp.getAgnosticAbsPath(target), this.mRegisteredFiles.get(url));
    }

    static class ReopeningInputStream
    extends InputStream {
        private InputStream mWrapped;

        public ReopeningInputStream(InputStream toWrap) {
            toWrap.mark(Integer.MAX_VALUE);
            this.mWrapped = toWrap;
        }

        @Override
        public int read() throws IOException {
            return this.mWrapped.read();
        }

        @Override
        public void close() throws IOException {
            this.mWrapped.reset();
        }

        public void reallyClose() throws IOException {
            this.mWrapped.close();
        }
    }
}

