/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.manager;

import com.android.annotations.concurrency.Slow;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.Downloader;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SchemaModule;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.manager.LocalRepoLoader;
import com.android.repository.impl.manager.LocalRepoLoaderImpl;
import com.android.repository.impl.manager.RemoteRepoLoader;
import com.android.repository.impl.manager.RemoteRepoLoaderImpl;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.ls.LSResourceResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 c2\u00020\u0001:\u0007]^_`abcB'\b\u0001\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\nJ\u0012\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u00103\u001a\u0002012\b\u00104\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u00105\u001a\u0002012\u0006\u00106\u001a\u00020\u0017H\u0016J(\u00107\u001a\b\u0012\u0004\u0012\u000209082\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u0014\u0010@\u001a\u0002012\n\u0010A\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\b\u0010B\u001a\u000201H\u0016J\b\u0010C\u001a\u000201H\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010<\u001a\u00020=H\u0016J\\\u0010F\u001a\u0002012\u0006\u0010G\u001a\u00020\u001e2\u000e\u0010H\u001a\n\u0012\u0004\u0012\u00020(\u0018\u0001082\u000e\u0010I\u001a\n\u0012\u0004\u0012\u00020(\u0018\u0001082\u000e\u0010J\u001a\n\u0012\u0004\u0012\u00020K\u0018\u0001082\u0006\u0010L\u001a\u00020M2\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016J\\\u0010P\u001a\u0002012\u0006\u0010G\u001a\u00020\u001e2\u000e\u0010H\u001a\n\u0012\u0004\u0012\u00020(\u0018\u0001082\u000e\u0010I\u001a\n\u0012\u0004\u0012\u00020(\u0018\u0001082\u000e\u0010J\u001a\n\u0012\u0004\u0012\u00020K\u0018\u0001082\u0006\u0010L\u001a\u00020M2\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016Jd\u0010P\u001a\u0002012\u0006\u0010G\u001a\u00020\u001e2\u000e\u0010H\u001a\n\u0012\u0004\u0012\u00020(\u0018\u0001082\u000e\u0010I\u001a\n\u0012\u0004\u0012\u00020(\u0018\u0001082\u000e\u0010J\u001a\n\u0012\u0004\u0012\u00020K\u0018\u0001082\u0006\u0010L\u001a\u00020M2\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010Q\u001a\u00020?H\u0002J\u0010\u0010R\u001a\u00020?2\u0006\u0010<\u001a\u00020=H\u0017J\u0010\u0010S\u001a\u0002012\u0006\u0010T\u001a\u00020(H\u0016J\u0010\u0010U\u001a\u0002012\u0006\u0010T\u001a\u00020(H\u0016J\u0010\u0010V\u001a\u0002012\u0006\u0010T\u001a\u00020(H\u0016J\u0010\u0010W\u001a\u0002012\u0006\u0010T\u001a\u00020(H\u0016J\u0018\u0010X\u001a\u0002012\u0006\u0010Y\u001a\u00020,2\u0006\u0010Z\u001a\u00020-H\u0016J\u0010\u0010[\u001a\u0002012\u0006\u0010Y\u001a\u00020,H\u0016J\u0012\u0010\\\u001a\u0004\u0018\u00010-2\u0006\u0010Y\u001a\u00020,H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0018\u00010!R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/android/repository/impl/manager/RepoManagerImpl;", "Lcom/android/repository/api/RepoManager;", "localPath", "Ljava/nio/file/Path;", "localFactory", "Lcom/android/repository/impl/manager/RepoManagerImpl$LocalRepoLoaderFactory;", "remoteFactory", "Lcom/android/repository/impl/manager/RepoManagerImpl$RemoteRepoLoaderFactory;", "<init>", "(Ljava/nio/file/Path;Lcom/android/repository/impl/manager/RepoManagerImpl$LocalRepoLoaderFactory;Lcom/android/repository/impl/manager/RepoManagerImpl$RemoteRepoLoaderFactory;)V", "(Ljava/nio/file/Path;)V", "getLocalPath", "()Ljava/nio/file/Path;", "schemaModules", "", "Lcom/android/repository/api/SchemaModule;", "getSchemaModules", "()Ljava/util/List;", "fallbackLocalRepoLoader", "Lcom/android/repository/api/FallbackLocalRepoLoader;", "fallbackRemoteRepoLoader", "Lcom/android/repository/api/FallbackRemoteRepoLoader;", "sourceProviders", "Lcom/android/repository/api/RepositorySourceProvider;", "getSourceProviders", "packages", "Lcom/android/repository/impl/meta/RepositoryPackages;", "getPackages", "()Lcom/android/repository/impl/meta/RepositoryPackages;", "lastRemoteRefreshMs", "", "lastLocalRefreshMs", "task", "Lcom/android/repository/impl/manager/RepoManagerImpl$LoadTask;", "taskCreateTime", "Ljava/time/Instant;", "taskLock", "", "localListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/android/repository/api/RepoManager$RepoLoadedListener;", "remoteListeners", "inProgressInstalls", "", "Lcom/android/repository/api/RepoPackage;", "Lcom/android/repository/api/PackageOperation;", "localRepoLoaderFactory", "remoteRepoLoaderFactory", "setFallbackLocalRepoLoader", "", "fallback", "setFallbackRemoteRepoLoader", "remote", "registerSourceProvider", "provider", "getSources", "", "Lcom/android/repository/api/RepositorySource;", "downloader", "Lcom/android/repository/api/Downloader;", "progress", "Lcom/android/repository/api/ProgressIndicator;", "forceRefresh", "", "registerSchemaModule", "module", "markInvalid", "markLocalCacheInvalid", "getResourceResolver", "Lorg/w3c/dom/ls/LSResourceResolver;", "loadSynchronously", "cacheExpirationMs", "onLocalComplete", "onSuccess", "onError", "Ljava/lang/Runnable;", "runner", "Lcom/android/repository/api/ProgressRunner;", "settings", "Lcom/android/repository/api/SettingsController;", "load", "sync", "reloadLocalIfNeeded", "addLocalChangeListener", "listener", "removeLocalChangeListener", "addRemoteChangeListener", "removeRemoteChangeListener", "installBeginning", "remotePackage", "installer", "installEnded", "getInProgressInstallOperation", "LoadTask", "LocalRepoLoaderFactory", "RemoteRepoLoaderFactory", "LocalRepoLoaderFactoryImpl", "RemoteRepoLoaderFactoryImpl", "CallbackRunnable", "Companion", "repository"})
@SourceDebugExtension(value={"SMAP\nRepoManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepoManagerImpl.kt\ncom/android/repository/impl/manager/RepoManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,556:1\n1374#2:557\n1460#2,5:558\n1#3:563\n*S KotlinDebug\n*F\n+ 1 RepoManagerImpl.kt\ncom/android/repository/impl/manager/RepoManagerImpl\n*L\n160#1:557\n160#1:558,5\n*E\n"})
public final class RepoManagerImpl
extends RepoManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path localPath;
    @NotNull
    private final List<SchemaModule<?>> schemaModules;
    @Nullable
    private FallbackLocalRepoLoader fallbackLocalRepoLoader;
    @Nullable
    private FallbackRemoteRepoLoader fallbackRemoteRepoLoader;
    @NotNull
    private final List<RepositorySourceProvider> sourceProviders;
    @NotNull
    private final RepositoryPackages packages;
    private long lastRemoteRefreshMs;
    private long lastLocalRefreshMs;
    @Nullable
    private LoadTask task;
    @NotNull
    private Instant taskCreateTime;
    @NotNull
    private final Object taskLock;
    @NotNull
    private final CopyOnWriteArrayList<RepoManager.RepoLoadedListener> localListeners;
    @NotNull
    private final CopyOnWriteArrayList<RepoManager.RepoLoadedListener> remoteListeners;
    @NotNull
    private final Map<RepoPackage, PackageOperation> inProgressInstalls;
    @NotNull
    private final LocalRepoLoaderFactory localRepoLoaderFactory;
    @NotNull
    private final RemoteRepoLoaderFactory remoteRepoLoaderFactory;
    private static final Duration TASK_TIMEOUT = Duration.ofMinutes(3L);

    @VisibleForTesting
    public RepoManagerImpl(@Nullable Path localPath, @Nullable LocalRepoLoaderFactory localFactory, @Nullable RemoteRepoLoaderFactory remoteFactory) {
        RemoteRepoLoaderFactory remoteRepoLoaderFactory;
        this.localPath = localPath;
        this.schemaModules = new ArrayList();
        this.sourceProviders = new ArrayList();
        this.packages = new RepositoryPackages();
        Instant instant = Instant.EPOCH;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"EPOCH");
        this.taskCreateTime = instant;
        this.taskLock = new Object();
        this.localListeners = new CopyOnWriteArrayList();
        this.remoteListeners = new CopyOnWriteArrayList();
        this.inProgressInstalls = new LinkedHashMap();
        this.registerSchemaModule(RepoManager.Companion.getCommonModule());
        this.registerSchemaModule(RepoManager.Companion.getGenericModule());
        LocalRepoLoaderFactory localRepoLoaderFactory = localFactory;
        if (localRepoLoaderFactory == null) {
            localRepoLoaderFactory = this.localRepoLoaderFactory = (LocalRepoLoaderFactory)new LocalRepoLoaderFactoryImpl();
        }
        if ((remoteRepoLoaderFactory = remoteFactory) == null) {
            remoteRepoLoaderFactory = new RemoteRepoLoaderFactoryImpl();
        }
        this.remoteRepoLoaderFactory = remoteRepoLoaderFactory;
    }

    @Override
    @Nullable
    public Path getLocalPath() {
        return this.localPath;
    }

    @Override
    @NotNull
    public List<SchemaModule<?>> getSchemaModules() {
        return this.schemaModules;
    }

    @Override
    @NotNull
    public List<RepositorySourceProvider> getSourceProviders() {
        return this.sourceProviders;
    }

    @Override
    @NotNull
    public RepositoryPackages getPackages() {
        return this.packages;
    }

    public RepoManagerImpl(@Nullable Path localPath) {
        this(localPath, null, null);
    }

    @Override
    public void setFallbackLocalRepoLoader(@Nullable FallbackLocalRepoLoader fallback) {
        this.fallbackLocalRepoLoader = fallback;
        this.markInvalid();
    }

    @Override
    public void setFallbackRemoteRepoLoader(@Nullable FallbackRemoteRepoLoader remote) {
        this.fallbackRemoteRepoLoader = remote;
        this.markInvalid();
    }

    @Override
    public void registerSourceProvider(@NotNull RepositorySourceProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.getSourceProviders().add(provider);
        this.markInvalid();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<RepositorySource> getSources(@Nullable Downloader downloader, @NotNull ProgressIndicator progress, boolean forceRefresh) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Iterable $this$flatMap$iv = this.getSourceProviders();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RepositorySourceProvider it = (RepositorySourceProvider)element$iv$iv;
            boolean bl = false;
            List<RepositorySource> list = it.getSources(downloader, progress, forceRefresh);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSources(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void registerSchemaModule(@NotNull SchemaModule<?> module) {
        Intrinsics.checkNotNullParameter(module, (String)"module");
        this.getSchemaModules().add(module);
        this.markInvalid();
    }

    @Override
    public void markInvalid() {
        this.lastRemoteRefreshMs = 0L;
        this.lastLocalRefreshMs = 0L;
    }

    @Override
    public void markLocalCacheInvalid() {
        this.lastLocalRefreshMs = 0L;
    }

    @Override
    @Nullable
    public LSResourceResolver getResourceResolver(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Set allModules = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.getSchemaModules(), RepoManager.Companion.getCommonModule()), RepoManager.Companion.getGenericModule()));
        return SchemaModuleUtil.createResourceResolver(allModules, progress);
    }

    @Override
    public void loadSynchronously(long cacheExpirationMs, @Nullable List<? extends RepoManager.RepoLoadedListener> onLocalComplete, @Nullable List<? extends RepoManager.RepoLoadedListener> onSuccess, @Nullable List<? extends Runnable> onError, @NotNull ProgressRunner runner, @Nullable Downloader downloader, @Nullable SettingsController settings) {
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        this.load(cacheExpirationMs, onLocalComplete, onSuccess, onError, runner, downloader, settings, true);
    }

    @Override
    public void load(long cacheExpirationMs, @Nullable List<? extends RepoManager.RepoLoadedListener> onLocalComplete, @Nullable List<? extends RepoManager.RepoLoadedListener> onSuccess, @Nullable List<? extends Runnable> onError, @NotNull ProgressRunner runner, @Nullable Downloader downloader, @Nullable SettingsController settings) {
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        this.load(cacheExpirationMs, onLocalComplete, onSuccess, onError, runner, downloader, settings, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load(long cacheExpirationMs, List<? extends RepoManager.RepoLoadedListener> onLocalComplete, List<? extends RepoManager.RepoLoadedListener> onSuccess, List<? extends Runnable> onError, ProgressRunner runner, Downloader downloader, SettingsController settings, boolean sync) {
        List list;
        List onSuccess2;
        List list2;
        List onLocalComplete2;
        List list3 = onLocalComplete;
        if (list3 == null) {
            list3 = onLocalComplete2 = CollectionsKt.emptyList();
        }
        if ((list2 = onSuccess) == null) {
            list2 = onSuccess2 = CollectionsKt.emptyList();
        }
        if ((list = onError) == null) {
            list = CollectionsKt.emptyList();
        }
        List onError2 = list;
        CountDownLatch completed = new CountDownLatch(1);
        boolean createNewTask = false;
        LoadTask task = null;
        Object object = this.taskLock;
        synchronized (object) {
            LoadTask loadTask;
            boolean bl = false;
            LoadTask loadTask2 = this.task;
            if (loadTask2 != null) {
                LoadTask loadTask3;
                LoadTask it = loadTask3 = loadTask2;
                boolean bl2 = false;
                loadTask = Clock.systemUTC().instant().compareTo(this.taskCreateTime.plus(TASK_TIMEOUT)) < 0 ? loadTask3 : null;
            } else {
                loadTask = null;
            }
            LoadTask currentTask = loadTask;
            boolean bl3 = createNewTask = currentTask == null;
            if (createNewTask) {
                task = new LoadTask(cacheExpirationMs, downloader, settings);
                task.addCallbacks(onLocalComplete2, onSuccess2, onError2, null);
                this.task = task;
                this.taskCreateTime = Clock.systemUTC().instant();
            } else {
                task = currentTask;
                task.addCallbacks(onLocalComplete2, onSuccess2, onError2, runner);
                if (sync) {
                    task.addCallbacks(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new RepoManager.RepoLoadedListener(completed){
                        final /* synthetic */ CountDownLatch $completed;
                        {
                            this.$completed = $completed;
                        }

                        public final void loaded(RepositoryPackages it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$completed.countDown();
                        }
                    }), CollectionsKt.listOf((Object)new Runnable(completed){
                        final /* synthetic */ CountDownLatch $completed;
                        {
                            this.$completed = $completed;
                        }

                        public final void run() {
                            this.$completed.countDown();
                        }
                    }), new RepoManager.DirectProgressRunner(new ConsoleProgressIndicator(null, null, false, 7, null)));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        if (createNewTask) {
            if (sync) {
                runner.runSyncWithProgress(task);
            } else {
                runner.runAsyncWithProgress(task);
            }
        } else if (sync) {
            runner.runSyncWithProgress(new ProgressRunner.ProgressRunnable(completed){
                final /* synthetic */ CountDownLatch $completed;
                {
                    this.$completed = $completed;
                }

                public final void run(ProgressIndicator progressIndicator, ProgressRunner progressRunner) {
                    Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"<unused var>");
                    Intrinsics.checkNotNullParameter((Object)progressRunner, (String)"<unused var>");
                    try {
                        this.$completed.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    @Slow
    public boolean reloadLocalIfNeeded(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        LocalRepoLoader local = this.localRepoLoaderFactory.createLocalRepoLoader();
        if (local == null) {
            return false;
        }
        if (local.needsUpdate(this.lastLocalRefreshMs, true)) {
            this.lastLocalRefreshMs = 0L;
        }
        return this.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progress, null, null);
    }

    @Override
    public void addLocalChangeListener(@NotNull RepoManager.RepoLoadedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.localListeners.add(listener);
    }

    @Override
    public void removeLocalChangeListener(@NotNull RepoManager.RepoLoadedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.localListeners.remove(listener);
    }

    @Override
    public void addRemoteChangeListener(@NotNull RepoManager.RepoLoadedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.remoteListeners.add(listener);
    }

    @Override
    public void removeRemoteChangeListener(@NotNull RepoManager.RepoLoadedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.remoteListeners.remove(listener);
    }

    @Override
    public void installBeginning(@NotNull RepoPackage remotePackage, @NotNull PackageOperation installer) {
        Intrinsics.checkNotNullParameter((Object)remotePackage, (String)"remotePackage");
        Intrinsics.checkNotNullParameter((Object)installer, (String)"installer");
        this.inProgressInstalls.put(remotePackage, installer);
    }

    @Override
    public void installEnded(@NotNull RepoPackage remotePackage) {
        Intrinsics.checkNotNullParameter((Object)remotePackage, (String)"remotePackage");
        this.inProgressInstalls.remove(remotePackage);
    }

    @Override
    @Nullable
    public PackageOperation getInProgressInstallOperation(@NotNull RepoPackage remotePackage) {
        Intrinsics.checkNotNullParameter((Object)remotePackage, (String)"remotePackage");
        return this.inProgressInstalls.get(remotePackage);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/android/repository/impl/manager/RepoManagerImpl$CallbackRunnable;", "Ljava/lang/Runnable;", "callback", "Lcom/android/repository/api/RepoManager$RepoLoadedListener;", "packages", "Lcom/android/repository/impl/meta/RepositoryPackages;", "<init>", "(Lcom/android/repository/api/RepoManager$RepoLoadedListener;Lcom/android/repository/impl/meta/RepositoryPackages;)V", "getCallback", "()Lcom/android/repository/api/RepoManager$RepoLoadedListener;", "setCallback", "(Lcom/android/repository/api/RepoManager$RepoLoadedListener;)V", "getPackages", "()Lcom/android/repository/impl/meta/RepositoryPackages;", "setPackages", "(Lcom/android/repository/impl/meta/RepositoryPackages;)V", "run", "", "repository"})
    private static final class CallbackRunnable
    implements Runnable {
        @NotNull
        private RepoManager.RepoLoadedListener callback;
        @NotNull
        private RepositoryPackages packages;

        public CallbackRunnable(@NotNull RepoManager.RepoLoadedListener callback, @NotNull RepositoryPackages packages) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            Intrinsics.checkNotNullParameter((Object)packages, (String)"packages");
            this.callback = callback;
            this.packages = packages;
        }

        @NotNull
        public final RepoManager.RepoLoadedListener getCallback() {
            return this.callback;
        }

        public final void setCallback(@NotNull RepoManager.RepoLoadedListener repoLoadedListener) {
            Intrinsics.checkNotNullParameter((Object)repoLoadedListener, (String)"<set-?>");
            this.callback = repoLoadedListener;
        }

        @NotNull
        public final RepositoryPackages getPackages() {
            return this.packages;
        }

        public final void setPackages(@NotNull RepositoryPackages repositoryPackages) {
            Intrinsics.checkNotNullParameter((Object)repositoryPackages, (String)"<set-?>");
            this.packages = repositoryPackages;
        }

        @Override
        public void run() {
            this.callback.loaded(this.packages);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/repository/impl/manager/RepoManagerImpl$Companion;", "", "<init>", "()V", "TASK_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "Ljava/time/Duration;", "repository"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\u001eB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ:\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n0\fR\u00060\u0000R\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n0\fR\u00060\u0000R\u00020\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/repository/impl/manager/RepoManagerImpl$LoadTask;", "Lcom/android/repository/api/ProgressRunner$ProgressRunnable;", "cacheExpirationMs", "", "downloader", "Lcom/android/repository/api/Downloader;", "settings", "Lcom/android/repository/api/SettingsController;", "<init>", "(Lcom/android/repository/impl/manager/RepoManagerImpl;JLcom/android/repository/api/Downloader;Lcom/android/repository/api/SettingsController;)V", "onSuccesses", "", "Lcom/android/repository/impl/manager/RepoManagerImpl$LoadTask$Callback;", "Lcom/android/repository/impl/manager/RepoManagerImpl;", "onErrors", "Ljava/lang/Runnable;", "onLocalCompletes", "Ljava/util/Queue;", "addCallbacks", "", "onLocalComplete", "", "Lcom/android/repository/api/RepoManager$RepoLoadedListener;", "onSuccess", "onError", "runner", "Lcom/android/repository/api/ProgressRunner;", "run", "indicator", "Lcom/android/repository/api/ProgressIndicator;", "Callback", "repository"})
    private final class LoadTask
    implements ProgressRunner.ProgressRunnable {
        private final long cacheExpirationMs;
        @Nullable
        private final Downloader downloader;
        @Nullable
        private final SettingsController settings;
        @NotNull
        private final List<Callback> onSuccesses;
        @NotNull
        private final List<Runnable> onErrors;
        @NotNull
        private final Queue<Callback> onLocalCompletes;

        public LoadTask(@Nullable long cacheExpirationMs, @Nullable Downloader downloader, SettingsController settings) {
            this.cacheExpirationMs = cacheExpirationMs;
            this.downloader = downloader;
            this.settings = settings;
            this.onSuccesses = new ArrayList();
            this.onErrors = new ArrayList();
            this.onLocalCompletes = new ConcurrentLinkedQueue();
        }

        public final void addCallbacks(@NotNull List<? extends RepoManager.RepoLoadedListener> onLocalComplete, @NotNull List<? extends RepoManager.RepoLoadedListener> onSuccess, @NotNull List<? extends Runnable> onError, @Nullable ProgressRunner runner) {
            Intrinsics.checkNotNullParameter(onLocalComplete, (String)"onLocalComplete");
            Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
            Intrinsics.checkNotNullParameter(onError, (String)"onError");
            for (RepoManager.RepoLoadedListener repoLoadedListener : onLocalComplete) {
                this.onLocalCompletes.add(new Callback(repoLoadedListener, runner));
            }
            for (RepoManager.RepoLoadedListener repoLoadedListener : onSuccess) {
                this.onSuccesses.add(new Callback(repoLoadedListener, runner));
            }
            this.onErrors.addAll((Collection<Runnable>)onError);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(@NotNull ProgressIndicator indicator, @NotNull ProgressRunner runner) {
            List<Runnable> onErrors;
            List<Callback> onSuccesses;
            Object onErrors2;
            Iterator<Object> iterator2;
            boolean wasIndeterminate;
            boolean localSuccess;
            boolean success;
            block40: {
                Object callback;
                block39: {
                    block38: {
                        Object listener;
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
                        success = false;
                        localSuccess = false;
                        wasIndeterminate = indicator.isIndeterminate();
                        indicator.setIndeterminate(false);
                        LocalRepoLoader local = RepoManagerImpl.this.localRepoLoaderFactory.createLocalRepoLoader();
                        if (local != null && (RepoManagerImpl.this.lastLocalRefreshMs + this.cacheExpirationMs <= System.currentTimeMillis() || local.needsUpdate(RepoManagerImpl.this.lastLocalRefreshMs, false))) {
                            FallbackLocalRepoLoader fallbackLocalRepoLoader = RepoManagerImpl.this.fallbackLocalRepoLoader;
                            if (fallbackLocalRepoLoader != null) {
                                fallbackLocalRepoLoader.refresh();
                            }
                            indicator.setText("Loading local repository...");
                            Map<String, LocalPackage> map = local.getPackages(indicator);
                            Intrinsics.checkNotNullExpressionValue(map, (String)"getPackages(...)");
                            Map<String, LocalPackage> newLocals = map;
                            boolean fireListeners = !Intrinsics.areEqual(newLocals, RepoManagerImpl.this.getPackages().getLocalPackages());
                            RepoManagerImpl.this.getPackages().setLocalPkgInfos(newLocals.values());
                            RepoManagerImpl.this.lastLocalRefreshMs = System.currentTimeMillis();
                            if (fireListeners) {
                                Iterator iterator = RepoManagerImpl.this.localListeners.iterator();
                                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                                iterator2 = iterator;
                                while (iterator2.hasNext()) {
                                    listener = (RepoManager.RepoLoadedListener)iterator2.next();
                                    listener.loaded(RepoManagerImpl.this.getPackages());
                                }
                            }
                        }
                        indicator.setFraction(0.25);
                        if (!indicator.isCanceled()) break block38;
                        indicator.setIndeterminate(wasIndeterminate);
                        List<Callback> onSuccesses2 = null;
                        List<Runnable> onErrors3 = null;
                        iterator2 = RepoManagerImpl.this.taskLock;
                        listener = RepoManagerImpl.this;
                        Iterator iterator4 = iterator2;
                        synchronized (iterator4) {
                            boolean $i$a$-synchronized-RepoManagerImpl$LoadTask$run$232 = false;
                            ((RepoManagerImpl)listener).task = null;
                            onSuccesses2 = this.onSuccesses;
                            onErrors3 = this.onErrors;
                            Unit $i$a$-synchronized-RepoManagerImpl$LoadTask$run$232 = Unit.INSTANCE;
                        }
                        for (Runnable onError2 : onErrors3) {
                            onError2.run();
                        }
                        return;
                    }
                    localSuccess = true;
                    Callback onLocalComplete = this.onLocalCompletes.poll();
                    while (onLocalComplete != null) {
                        onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.getCallback(), RepoManagerImpl.this.getPackages()));
                        onLocalComplete = this.onLocalCompletes.poll();
                    }
                    indicator.setText("Fetch remote repository...");
                    indicator.setSecondaryText("");
                    if (!RepoManagerImpl.this.getSourceProviders().isEmpty() && this.downloader != null && RepoManagerImpl.this.lastRemoteRefreshMs + this.cacheExpirationMs <= System.currentTimeMillis()) {
                        RemoteRepoLoader remoteLoader = RepoManagerImpl.this.remoteRepoLoaderFactory.createRemoteRepoLoader(indicator);
                        Map<String, RemotePackage> map = remoteLoader.fetchPackages(indicator.createSubProgress(0.75), this.downloader, this.settings);
                        Intrinsics.checkNotNullExpressionValue(map, (String)"fetchPackages(...)");
                        Map<String, RemotePackage> remotes = map;
                        indicator.setText("Computing updates...");
                        indicator.setFraction(0.75);
                        boolean fireListeners = !Intrinsics.areEqual(remotes, RepoManagerImpl.this.getPackages().getRemotePackages());
                        RepoManagerImpl.this.getPackages().setRemotePkgInfos(remotes.values());
                        RepoManagerImpl.this.lastRemoteRefreshMs = System.currentTimeMillis();
                        if (fireListeners) {
                            Iterator iterator = RepoManagerImpl.this.remoteListeners.iterator();
                            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                            Iterator iterator3 = iterator;
                            while (iterator3.hasNext()) {
                                callback = (RepoManager.RepoLoadedListener)iterator3.next();
                                callback.loaded(RepoManagerImpl.this.getPackages());
                            }
                        }
                    }
                    if (!indicator.isCanceled()) break block39;
                    indicator.setIndeterminate(wasIndeterminate);
                    List<Callback> onSuccesses3 = null;
                    List<Runnable> onErrors22 = null;
                    Iterator<Object> fireListeners = RepoManagerImpl.this.taskLock;
                    RepoManagerImpl repoManagerImpl = RepoManagerImpl.this;
                    callback = fireListeners;
                    synchronized (callback) {
                        boolean $i$a$-synchronized-RepoManagerImpl$LoadTask$run$332 = false;
                        repoManagerImpl.task = null;
                        onSuccesses3 = this.onSuccesses;
                        onErrors22 = this.onErrors;
                        Unit $i$a$-synchronized-RepoManagerImpl$LoadTask$run$332 = Unit.INSTANCE;
                    }
                    for (Callback callback2 : this.onLocalCompletes) {
                        callback2.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(callback2.getCallback(), RepoManagerImpl.this.getPackages()));
                    }
                    for (Runnable runnable : onErrors22) {
                        runnable.run();
                    }
                    return;
                }
                indicator.setSecondaryText("");
                indicator.setFraction(1.0);
                if (!indicator.isCanceled()) break block40;
                indicator.setIndeterminate(wasIndeterminate);
                List<Callback> onSuccesses4 = null;
                onErrors2 = null;
                Iterator fireListeners = RepoManagerImpl.this.taskLock;
                RepoManagerImpl repoManagerImpl = RepoManagerImpl.this;
                callback = fireListeners;
                synchronized (callback) {
                    boolean bl = false;
                    repoManagerImpl.task = null;
                    onSuccesses4 = this.onSuccesses;
                    onErrors2 = this.onErrors;
                    Unit unit = Unit.INSTANCE;
                }
                for (Callback callback3 : this.onLocalCompletes) {
                    callback3.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(callback3.getCallback(), RepoManagerImpl.this.getPackages()));
                }
                fireListeners = onErrors2.iterator();
                while (fireListeners.hasNext()) {
                    Runnable runnable = (Runnable)fireListeners.next();
                    runnable.run();
                }
                return;
            }
            try {
                success = true;
                indicator.setIndeterminate(wasIndeterminate);
                onSuccesses = null;
                onErrors = null;
            }
            catch (Throwable throwable) {
                indicator.setIndeterminate(wasIndeterminate);
                List<Callback> onSuccesses2 = null;
                List<Runnable> onErrors4 = null;
                iterator2 = RepoManagerImpl.this.taskLock;
                RepoManagerImpl fireListeners = RepoManagerImpl.this;
                Iterator iterator = iterator2;
                synchronized (iterator) {
                    boolean bl = false;
                    fireListeners.task = null;
                    onSuccesses2 = this.onSuccesses;
                    onErrors4 = this.onErrors;
                    Unit unit = Unit.INSTANCE;
                }
                if (localSuccess) {
                    for (Callback onLocalComplete : this.onLocalCompletes) {
                        onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.getCallback(), RepoManagerImpl.this.getPackages()));
                    }
                }
                for (Runnable onError : onErrors4) {
                    onError.run();
                }
                throw throwable;
            }
            Iterator<Object> onSuccesses4 = RepoManagerImpl.this.taskLock;
            onErrors2 = RepoManagerImpl.this;
            Iterator fireListeners = onSuccesses4;
            synchronized (fireListeners) {
                boolean bl = false;
                ((RepoManagerImpl)onErrors2).task = null;
                onSuccesses = this.onSuccesses;
                onErrors = this.onErrors;
                Unit unit = Unit.INSTANCE;
            }
            for (Callback onLocalComplete : this.onLocalCompletes) {
                onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.getCallback(), RepoManagerImpl.this.getPackages()));
            }
            for (Callback onSuccess : onSuccesses) {
                onSuccess.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onSuccess.getCallback(), RepoManagerImpl.this.getPackages()));
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/repository/impl/manager/RepoManagerImpl$LoadTask$Callback;", "", "callback", "Lcom/android/repository/api/RepoManager$RepoLoadedListener;", "runner", "Lcom/android/repository/api/ProgressRunner;", "<init>", "(Lcom/android/repository/impl/manager/RepoManagerImpl$LoadTask;Lcom/android/repository/api/RepoManager$RepoLoadedListener;Lcom/android/repository/api/ProgressRunner;)V", "getCallback", "()Lcom/android/repository/api/RepoManager$RepoLoadedListener;", "getRunner", "defaultRunner", "repository"})
        private final class Callback {
            @NotNull
            private final RepoManager.RepoLoadedListener callback;
            @Nullable
            private final ProgressRunner runner;

            public Callback(@Nullable RepoManager.RepoLoadedListener callback, ProgressRunner runner) {
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                this.callback = callback;
                this.runner = runner;
            }

            @NotNull
            public final RepoManager.RepoLoadedListener getCallback() {
                return this.callback;
            }

            @NotNull
            public final ProgressRunner getRunner(@NotNull ProgressRunner defaultRunner) {
                Intrinsics.checkNotNullParameter((Object)defaultRunner, (String)"defaultRunner");
                ProgressRunner progressRunner = this.runner;
                if (progressRunner == null) {
                    progressRunner = defaultRunner;
                }
                return progressRunner;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lcom/android/repository/impl/manager/RepoManagerImpl$LocalRepoLoaderFactory;", "", "createLocalRepoLoader", "Lcom/android/repository/impl/manager/LocalRepoLoader;", "repository"})
    public static interface LocalRepoLoaderFactory {
        @Nullable
        public LocalRepoLoader createLocalRepoLoader();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/repository/impl/manager/RepoManagerImpl$LocalRepoLoaderFactoryImpl;", "Lcom/android/repository/impl/manager/RepoManagerImpl$LocalRepoLoaderFactory;", "<init>", "(Lcom/android/repository/impl/manager/RepoManagerImpl;)V", "createLocalRepoLoader", "Lcom/android/repository/impl/manager/LocalRepoLoader;", "repository"})
    @SourceDebugExtension(value={"SMAP\nRepoManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepoManagerImpl.kt\ncom/android/repository/impl/manager/RepoManagerImpl$LocalRepoLoaderFactoryImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,556:1\n1#2:557\n*E\n"})
    private final class LocalRepoLoaderFactoryImpl
    implements LocalRepoLoaderFactory {
        @Override
        @Nullable
        public LocalRepoLoader createLocalRepoLoader() {
            LocalRepoLoaderImpl localRepoLoaderImpl;
            Path path = RepoManagerImpl.this.getLocalPath();
            if (path != null) {
                Path path2 = path;
                RepoManagerImpl repoManagerImpl = RepoManagerImpl.this;
                Path it = path2;
                boolean bl = false;
                localRepoLoaderImpl = new LocalRepoLoaderImpl(it, repoManagerImpl, repoManagerImpl.fallbackLocalRepoLoader);
            } else {
                localRepoLoaderImpl = null;
            }
            return localRepoLoaderImpl;
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/repository/impl/manager/RepoManagerImpl$RemoteRepoLoaderFactory;", "", "createRemoteRepoLoader", "Lcom/android/repository/impl/manager/RemoteRepoLoader;", "progress", "Lcom/android/repository/api/ProgressIndicator;", "repository"})
    public static interface RemoteRepoLoaderFactory {
        @NotNull
        public RemoteRepoLoader createRemoteRepoLoader(@NotNull ProgressIndicator var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/repository/impl/manager/RepoManagerImpl$RemoteRepoLoaderFactoryImpl;", "Lcom/android/repository/impl/manager/RepoManagerImpl$RemoteRepoLoaderFactory;", "<init>", "(Lcom/android/repository/impl/manager/RepoManagerImpl;)V", "createRemoteRepoLoader", "Lcom/android/repository/impl/manager/RemoteRepoLoader;", "progress", "Lcom/android/repository/api/ProgressIndicator;", "repository"})
    private final class RemoteRepoLoaderFactoryImpl
    implements RemoteRepoLoaderFactory {
        @Override
        @NotNull
        public RemoteRepoLoader createRemoteRepoLoader(@NotNull ProgressIndicator progress) {
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            return new RemoteRepoLoaderImpl((Collection<RepositorySourceProvider>)RepoManagerImpl.this.getSourceProviders(), RepoManagerImpl.this.fallbackRemoteRepoLoader);
        }
    }
}

