/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.sampledata;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class SampleDataManager {
    public static final String SUBARRAY_SEPARATOR = ":";
    private static final Splitter NEW_LINE_SPLITTER = Splitter.on((Pattern)Pattern.compile("\r?\n"));
    private final Map<String, AtomicInteger> mSampleDataPosition = new HashMap<String, AtomicInteger>();

    private String getSampleDataLineFromCursor(String resourceName, List<String> content) {
        if (content.isEmpty()) {
            return "";
        }
        AtomicInteger position = this.mSampleDataPosition.get(resourceName);
        if (position == null) {
            position = new AtomicInteger(0);
            this.mSampleDataPosition.put(resourceName, position);
        }
        int contentSize = content.size();
        int cursorPosition = position.getAndIncrement() % contentSize;
        return content.get(cursorPosition);
    }

    public String getSampleDataLine(String resourcePath, String content) {
        int closeBracket;
        int openBracket;
        if (content.isEmpty()) {
            return "";
        }
        List<String> contentList = NEW_LINE_SPLITTER.splitToList((CharSequence)content);
        if (((String)contentList.get(contentList.size() - 1)).isEmpty()) {
            contentList = contentList.subList(0, contentList.size() - 1);
        }
        if ((openBracket = resourcePath.indexOf(91)) != -1 && (closeBracket = resourcePath.indexOf(93)) != -1 && closeBracket > openBracket + 1) {
            String indexValue = resourcePath.substring(openBracket + 1, closeBracket);
            if (!indexValue.contains(SUBARRAY_SEPARATOR)) {
                try {
                    return contentList.get(Integer.parseUnsignedInt(indexValue) % contentList.size());
                }
                catch (Throwable e) {
                    return contentList.stream().filter(line -> line.endsWith(indexValue)).findFirst().orElse("");
                }
            }
            contentList = SampleDataManager.getContentSubArray(contentList, indexValue);
            resourcePath = resourcePath.substring(0, openBracket);
        }
        return this.getSampleDataLineFromCursor(resourcePath, contentList);
    }

    private static List<String> getContentSubArray(List<String> content, String value) {
        if (SUBARRAY_SEPARATOR.equals(value)) {
            return content;
        }
        List subArrayIndexes = Splitter.on((String)SUBARRAY_SEPARATOR).limit(2).splitToList((CharSequence)value);
        assert (subArrayIndexes.size() == 2);
        String bottom = (String)subArrayIndexes.get(0);
        String top = (String)subArrayIndexes.get(1);
        try {
            int bottomIndex = bottom.isEmpty() ? 0 : Integer.parseUnsignedInt(bottom);
            int topIndex = top.isEmpty() ? content.size() - 1 : Integer.parseUnsignedInt(top);
            return content.subList(bottomIndex, topIndex + 1);
        }
        catch (Throwable throwable) {
            return Collections.emptyList();
        }
    }

    public static String getResourceNameFromSampleReference(String sampleReference) {
        int openBracket = sampleReference.indexOf(91);
        if (openBracket != -1) {
            return sampleReference.substring(0, openBracket);
        }
        return sampleReference;
    }
}

