/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.lang.management.ManagementFactory;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public final class JvmWideVariable<T> {
    private final String group;
    private final String name;
    private static final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName objectName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JvmWideVariable(String group, String name, TypeToken<T> typeToken, Supplier<T> defaultValueSupplier) {
        Class<?> clazz2;
        Type type = typeToken.getType();
        for (Class<?> clazz2 : JvmWideVariable.collectComponentClasses(type)) {
            Preconditions.checkArgument((clazz2.getClassLoader() == null ? 1 : 0) != 0, (String)"Type %s used to define JVM-wide variable %s:%s must be loaded by the bootstrap class loader but is loaded by %s", clazz2, (Object)group, (Object)name, (Object)clazz2.getClassLoader());
        }
        this.group = group;
        this.name = name;
        try {
            this.objectName = new ObjectName(String.format("%1$s:type=%2$s,group=%3$s,name=%4$s", JvmWideVariable.class.getSimpleName(), ValueWrapper.class.getSimpleName(), group, name));
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        boolean variableExists = true;
        clazz2 = server;
        synchronized (clazz2) {
            if (!server.isRegistered(this.objectName)) {
                variableExists = false;
                ValueWrapper<T> objectWrapper = new ValueWrapper<T>(type, defaultValueSupplier.get());
                try {
                    server.registerMBean(objectWrapper, this.objectName);
                }
                catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (variableExists) {
            Type existingType;
            try {
                existingType = (Type)server.getAttribute(this.objectName, "Type");
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                throw new RuntimeException(e);
            }
            Preconditions.checkArgument((boolean)existingType.equals(type), (String)"Expected type %s but found type %s for JVM-wide variable %s:%s", (Object)existingType, (Object)type, (Object)group, (Object)name);
        }
    }

    public JvmWideVariable(String group, String name, Class<T> type, T defaultValue) {
        this(group, name, TypeToken.of(type), () -> defaultValue);
    }

    static Collection<Class<?>> collectComponentClasses(Type type) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        JvmWideVariable.doCollectComponentClasses(type, builder);
        return builder.build();
    }

    private static void doCollectComponentClasses(Type type, ImmutableSet.Builder<Class<?>> builder) {
        if (type instanceof Class) {
            builder.add((Object)((Class)type));
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            JvmWideVariable.doCollectComponentClasses(parameterizedType.getRawType(), builder);
            if (parameterizedType.getOwnerType() != null) {
                JvmWideVariable.doCollectComponentClasses(parameterizedType.getOwnerType(), builder);
            }
            for (Type componentType : parameterizedType.getActualTypeArguments()) {
                JvmWideVariable.doCollectComponentClasses(componentType, builder);
            }
        } else if (type instanceof GenericArrayType) {
            JvmWideVariable.doCollectComponentClasses(((GenericArrayType)type).getGenericComponentType(), builder);
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type componentType : wildcardType.getLowerBounds()) {
                JvmWideVariable.doCollectComponentClasses(componentType, builder);
            }
            for (Type componentType : wildcardType.getUpperBounds()) {
                JvmWideVariable.doCollectComponentClasses(componentType, builder);
            }
        } else {
            throw new IllegalArgumentException("Type " + type + " is not yet supported");
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public T get() {
        try {
            return (T)server.getAttribute(this.objectName, "Value");
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(T value) {
        try {
            server.setAttribute(this.objectName, new Attribute("Value", value));
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | InvalidAttributeValueException | MBeanException | ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public <V> V executeCallableSynchronously(Callable<V> action) throws ExecutionException {
        Object mBean;
        try {
            mBean = server.getAttribute(this.objectName, "ThisInstance");
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new RuntimeException(e);
        }
        Object object = mBean;
        synchronized (object) {
            try {
                return action.call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }

    public <V> V executeSupplierSynchronously(Supplier<V> action) {
        try {
            return (V)this.executeCallableSynchronously(action::get);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void executeRunnableSynchronously(Runnable action) {
        this.executeSupplierSynchronously(() -> {
            action.run();
            return null;
        });
    }

    public void unregister() {
        try {
            server.unregisterMBean(this.objectName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ValueWrapperMBean<T> {
        public static final String TYPE_PROPERTY = "Type";
        public static final String VALUE_PROPERTY = "Value";
        public static final String THIS_INSTANCE_PROPERTY = "ThisInstance";

        public Type getType();

        public T getValue();

        public void setValue(T var1);

        public ValueWrapperMBean<T> getThisInstance();
    }

    private static final class ValueWrapper<T>
    implements ValueWrapperMBean<T> {
        private final Type type;
        private T value;

        public ValueWrapper(Type type, T value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public void setValue(T value) {
            this.value = value;
        }

        @Override
        public ValueWrapperMBean<T> getThisInstance() {
            return this;
        }
    }
}

