/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.provision;

public class ProvisionException
extends Exception {
    private final ErrorType myErrorType;

    ProvisionException(ErrorType errorType) {
        super(ProvisionException.createMessageForError(errorType));
        this.myErrorType = errorType;
    }

    ProvisionException(ErrorType errorType, Throwable cause) {
        super(ProvisionException.createMessageForError(errorType), cause);
        this.myErrorType = errorType;
    }

    ProvisionException(ErrorType errorType, String message) {
        super(ProvisionException.createMessageForError(errorType) + " " + message);
        this.myErrorType = errorType;
    }

    ProvisionException(ErrorType errorType, String message, Throwable cause) {
        super(ProvisionException.createMessageForError(errorType) + " " + message, cause);
        this.myErrorType = errorType;
    }

    private static String createMessageForError(ErrorType errorType) {
        switch (errorType) {
            case ARCH_NOT_SUPPORTED: {
                return "The device architecture is not supported for Instant Apps.";
            }
            case DEVICE_NOT_SUPPORTED: {
                return "The device used is not whitelisted for Instant Apps deployment.";
            }
            case NO_GOOGLE_ACCOUNT: {
                return "Device is not logged in a Google account.";
            }
            case SHELL_TIMEOUT: {
                return "Shell adb command has timed out.";
            }
            case ADB_FAILURE: {
                return "ADB has failed.";
            }
            case INVALID_SDK: {
                return "The provided SDK file is not valid.";
            }
            case INSTALL_FAILED: {
                return "Installing APK failed.";
            }
            case UNINSTALL_FAILED: {
                return "Uninstalling APK failed.";
            }
            case CANCELLED: {
                return "Cancelled by the user.";
            }
            case UNKNOWN: {
                return "Error while provisioning device.";
            }
        }
        return null;
    }

    public ErrorType getErrorType() {
        return this.myErrorType;
    }

    static enum ErrorType {
        ARCH_NOT_SUPPORTED,
        DEVICE_NOT_SUPPORTED,
        NO_GOOGLE_ACCOUNT,
        SHELL_TIMEOUT,
        ADB_FAILURE,
        INVALID_SDK,
        INSTALL_FAILED,
        UNINSTALL_FAILED,
        CANCELLED,
        UNKNOWN;

    }
}

