/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.android.ide.common.util.JvmWideVariable;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecutorSingleton {
    private static final JvmWideVariable<ExecutorService> sExecutorService = new JvmWideVariable<Object>(ExecutorSingleton.class, "sExecutorService", ExecutorService.class, null);
    private static final JvmWideVariable<Integer> sThreadPoolSize = new JvmWideVariable<Integer>(ExecutorSingleton.class, "sThreadPoolSize", Integer.class, Runtime.getRuntime().availableProcessors());

    public static ExecutorService getExecutor() {
        return sExecutorService.executeSupplierSynchronously(() -> {
            if (sExecutorService.get() == null) {
                sExecutorService.set(Executors.newFixedThreadPool(sThreadPoolSize.get()));
            }
            return sExecutorService.get();
        });
    }

    public static void shutdown() {
        sExecutorService.executeRunnableSynchronously(() -> {
            if (sExecutorService.get() != null) {
                sExecutorService.get().shutdown();
                sExecutorService.set(null);
            }
        });
    }

    public static void setThreadPoolSize(int threadPoolSize) {
        sExecutorService.executeRunnableSynchronously(() -> sThreadPoolSize.set(threadPoolSize));
    }

    static int getThreadPoolSize() {
        return Objects.requireNonNull(sThreadPoolSize.get());
    }
}

