/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.ClassField;
import com.android.builder.model.InstantRun;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.TestOptions;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeBaseArtifactImpl;
import com.android.ide.common.gradle.model.IdeClassField;
import com.android.ide.common.gradle.model.IdeInstantRun;
import com.android.ide.common.gradle.model.IdeNativeLibrary;
import com.android.ide.common.gradle.model.IdeTestOptions;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class IdeAndroidArtifactImpl
extends IdeBaseArtifactImpl
implements IdeAndroidArtifact {
    private static final long serialVersionUID = 3L;
    private final Collection<AndroidArtifactOutput> myOutputs;
    private final String myApplicationId;
    private final String mySourceGenTaskName;
    private final Collection<File> myGeneratedResourceFolders;
    private final Collection<File> myAdditionalRuntimeApks;
    private final Map<String, ClassField> myBuildConfigFields;
    private final Map<String, ClassField> myResValues;
    private final IdeInstantRun myInstantRun;
    private final String mySigningConfigName;
    private final Set<String> myAbiFilters;
    private final Collection<NativeLibrary> myNativeLibraries;
    private final IdeTestOptions myTestOptions;
    private final String myInstrumentedTestTaskName;
    private final boolean mySigned;
    private final int myHashCode;

    public IdeAndroidArtifactImpl(AndroidArtifact artifact, ModelCache modelCache, IdeDependenciesFactory dependenciesFactory, GradleVersion gradleVersion) {
        super((BaseArtifact)artifact, modelCache, dependenciesFactory, gradleVersion);
        this.myOutputs = IdeAndroidArtifactImpl.copyOutputs(artifact, modelCache);
        this.myApplicationId = artifact.getApplicationId();
        this.mySourceGenTaskName = artifact.getSourceGenTaskName();
        this.myGeneratedResourceFolders = ImmutableList.copyOf((Collection)artifact.getGeneratedResourceFolders());
        this.myBuildConfigFields = IdeAndroidArtifactImpl.copy(artifact.getBuildConfigFields(), modelCache, (V classField) -> new IdeClassField((ClassField)classField, modelCache));
        this.myResValues = IdeAndroidArtifactImpl.copy(artifact.getResValues(), modelCache, (V classField) -> new IdeClassField((ClassField)classField, modelCache));
        this.myInstantRun = IdeAndroidArtifactImpl.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getInstantRun(), instantRun -> new IdeInstantRun((InstantRun)instantRun, modelCache), null);
        this.mySigningConfigName = artifact.getSigningConfigName();
        this.myAbiFilters = IdeAndroidArtifactImpl.copy(artifact.getAbiFilters());
        this.myNativeLibraries = IdeAndroidArtifactImpl.copy(modelCache, artifact.getNativeLibraries());
        this.mySigned = artifact.isSigned();
        this.myAdditionalRuntimeApks = IdeAndroidArtifactImpl.copyNewProperty(() -> ((AndroidArtifact)artifact).getAdditionalRuntimeApks(), Collections.emptySet());
        this.myTestOptions = IdeAndroidArtifactImpl.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getTestOptions(), testOptions -> new IdeTestOptions((TestOptions)testOptions, modelCache), null);
        this.myInstrumentedTestTaskName = IdeAndroidArtifactImpl.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getInstrumentedTestTaskName(), taskName -> taskName, null);
        this.myHashCode = this.calculateHashCode();
    }

    private static Collection<AndroidArtifactOutput> copyOutputs(AndroidArtifact artifact, ModelCache modelCache) {
        try {
            Collection outputs = artifact.getOutputs();
            return IdeAndroidArtifactImpl.copy(outputs, modelCache, (K output) -> new IdeAndroidArtifactOutput((AndroidArtifactOutput)output, modelCache));
        }
        catch (RuntimeException e) {
            return Collections.emptyList();
        }
    }

    private static Collection<NativeLibrary> copy(ModelCache modelCache, Collection<NativeLibrary> original) {
        return original != null ? IdeAndroidArtifactImpl.copy(original, modelCache, (K library) -> new IdeNativeLibrary((NativeLibrary)library, modelCache)) : null;
    }

    public Collection<AndroidArtifactOutput> getOutputs() {
        return this.myOutputs;
    }

    public String getApplicationId() {
        return this.myApplicationId;
    }

    public String getSourceGenTaskName() {
        return this.mySourceGenTaskName;
    }

    public Collection<File> getGeneratedResourceFolders() {
        return this.myGeneratedResourceFolders;
    }

    public Map<String, ClassField> getBuildConfigFields() {
        return this.myBuildConfigFields;
    }

    public Map<String, ClassField> getResValues() {
        return this.myResValues;
    }

    public InstantRun getInstantRun() {
        if (this.myInstantRun != null) {
            return this.myInstantRun;
        }
        throw new UnsupportedOperationException("Unsupported method: AndroidArtifact.getInstantRun()");
    }

    public Collection<File> getAdditionalRuntimeApks() {
        return this.myAdditionalRuntimeApks;
    }

    public TestOptions getTestOptions() {
        return this.myTestOptions;
    }

    public String getInstrumentedTestTaskName() {
        return this.myInstrumentedTestTaskName;
    }

    public String getSigningConfigName() {
        return this.mySigningConfigName;
    }

    public Set<String> getAbiFilters() {
        return this.myAbiFilters;
    }

    public Collection<NativeLibrary> getNativeLibraries() {
        return this.myNativeLibraries;
    }

    public boolean isSigned() {
        return this.mySigned;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidArtifactImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeAndroidArtifactImpl artifact = (IdeAndroidArtifactImpl)o;
        return artifact.canEquals(this) && this.mySigned == artifact.mySigned && Objects.equals(this.myOutputs, artifact.myOutputs) && Objects.equals(this.myApplicationId, artifact.myApplicationId) && Objects.equals(this.mySourceGenTaskName, artifact.mySourceGenTaskName) && Objects.equals(this.myGeneratedResourceFolders, artifact.myGeneratedResourceFolders) && Objects.equals(this.myBuildConfigFields, artifact.myBuildConfigFields) && Objects.equals(this.myResValues, artifact.myResValues) && Objects.equals(this.myInstantRun, artifact.myInstantRun) && Objects.equals(this.mySigningConfigName, artifact.mySigningConfigName) && Objects.equals(this.myAbiFilters, artifact.myAbiFilters) && Objects.equals(this.myAdditionalRuntimeApks, artifact.myAdditionalRuntimeApks) && Objects.equals(this.myNativeLibraries, artifact.myNativeLibraries) && Objects.equals(this.myTestOptions, artifact.myTestOptions) && Objects.equals(this.myInstrumentedTestTaskName, artifact.myInstrumentedTestTaskName);
    }

    @Override
    protected boolean canEquals(Object other) {
        return other instanceof IdeAndroidArtifactImpl;
    }

    @Override
    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myOutputs, this.myApplicationId, this.mySourceGenTaskName, this.myGeneratedResourceFolders, this.myBuildConfigFields, this.myResValues, this.myInstantRun, this.mySigningConfigName, this.myAbiFilters, this.myNativeLibraries, this.mySigned, this.myAdditionalRuntimeApks, this.myTestOptions, this.myInstrumentedTestTaskName);
    }

    @Override
    public String toString() {
        return "IdeAndroidArtifact{" + super.toString() + ", myOutputs=" + this.myOutputs + ", myApplicationId='" + this.myApplicationId + '\'' + ", mySourceGenTaskName='" + this.mySourceGenTaskName + '\'' + ", myGeneratedResourceFolders=" + this.myGeneratedResourceFolders + ", myBuildConfigFields=" + this.myBuildConfigFields + ", myResValues=" + this.myResValues + ", myInstantRun=" + this.myInstantRun + ", mySigningConfigName='" + this.mySigningConfigName + '\'' + ", myAbiFilters=" + this.myAbiFilters + ", myNativeLibraries=" + this.myNativeLibraries + ", mySigned=" + this.mySigned + ", myTestOptions=" + this.myTestOptions + ", myInstrumentedTestTaskName=" + this.myInstrumentedTestTaskName + "}";
    }
}

