/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.Library;
import com.android.ide.common.gradle.model.IdeLibraries;
import com.android.ide.common.gradle.model.IdeMavenCoordinates;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import java.util.Objects;

public abstract class IdeLibrary
extends IdeModel
implements Library {
    private static final long serialVersionUID = 2L;
    private final IdeMavenCoordinates myResolvedCoordinates;
    private final String myProject;
    private final String myName;
    private final Boolean myProvided;
    private final int myHashCode;

    protected IdeLibrary(Library library, ModelCache modelCache) {
        super(library, modelCache);
        this.myResolvedCoordinates = IdeLibraries.computeResolvedCoordinate(library, modelCache);
        this.myProject = IdeLibrary.copyNewProperty(() -> ((Library)library).getProject(), null);
        this.myName = IdeLibrary.copyNewProperty(() -> ((Library)library).getName(), null);
        this.myProvided = IdeLibrary.copyNewProperty(() -> ((Library)library).isProvided(), null);
        this.myHashCode = this.calculateHashCode();
    }

    public IdeMavenCoordinates getRequestedCoordinates() {
        throw new UnusedModelMethodException("getRequestedCoordinates");
    }

    public IdeMavenCoordinates getResolvedCoordinates() {
        return this.myResolvedCoordinates;
    }

    public String getProject() {
        return this.myProject;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isSkipped() {
        throw new UnusedModelMethodException("isSkipped");
    }

    public boolean isProvided() {
        if (this.myProvided != null) {
            return this.myProvided;
        }
        throw new UnsupportedOperationException("Unsupported method: AndroidLibrary.isProvided()");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeLibrary)) {
            return false;
        }
        IdeLibrary library = (IdeLibrary)o;
        return library.canEqual(this) && Objects.equals(this.myProvided, library.myProvided) && Objects.equals(this.myResolvedCoordinates, library.myResolvedCoordinates) && Objects.equals(this.myProject, library.myProject) && Objects.equals(this.myName, library.myName);
    }

    public boolean canEqual(Object other) {
        return other instanceof IdeLibrary;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myResolvedCoordinates, this.myProject, this.myName, this.myProvided);
    }

    public String toString() {
        return "myResolvedCoordinates=" + this.myResolvedCoordinates + ", myProject='" + this.myProject + '\'' + ", myName='" + this.myName + '\'' + ", myProvided=" + this.myProvided;
    }
}

