/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.NativeFolder;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class IdeNativeFolder
extends IdeModel
implements NativeFolder {
    private static final long serialVersionUID = 1L;
    private final File myFolderPath;
    private final Map<String, String> myPerLanguageSettings;
    private final File myWorkingDirectory;
    private final int myHashCode;

    public IdeNativeFolder(NativeFolder folder, ModelCache modelCache) {
        super(folder, modelCache);
        this.myFolderPath = folder.getFolderPath();
        Map settings = folder.getPerLanguageSettings();
        this.myPerLanguageSettings = settings != null ? ImmutableMap.copyOf((Map)settings) : Collections.emptyMap();
        this.myWorkingDirectory = folder.getWorkingDirectory();
        this.myHashCode = this.calculateHashCode();
    }

    public File getFolderPath() {
        return this.myFolderPath;
    }

    public Map<String, String> getPerLanguageSettings() {
        return this.myPerLanguageSettings;
    }

    public File getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeFolder)) {
            return false;
        }
        IdeNativeFolder folder = (IdeNativeFolder)o;
        return Objects.equals(this.myFolderPath, folder.myFolderPath) && Objects.equals(this.myPerLanguageSettings, folder.myPerLanguageSettings) && Objects.equals(this.myWorkingDirectory, folder.myWorkingDirectory);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myFolderPath, this.myPerLanguageSettings, this.myWorkingDirectory);
    }

    public String toString() {
        return "IdeNativeFolder{myFolderPath=" + this.myFolderPath + ", myPerLanguageSettings=" + this.myPerLanguageSettings + ", myWorkingDirectory=" + this.myWorkingDirectory + "}";
    }
}

