/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceValuesXmlParseException;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ResourceExtraXmlParser {
    public static SymbolTable parse(Document xmlDocument, IdProvider idProvider) {
        Element root = xmlDocument.getDocumentElement();
        if (root == null) {
            throw new ResourceValuesXmlParseException("XML document does not have a root element.");
        }
        SymbolTable.Builder builder = SymbolTable.builder();
        ResourceExtraXmlParser.parseChild(root, builder, idProvider);
        return builder.build();
    }

    private static void parseChild(Element element, SymbolTable.Builder builder, IdProvider idProvider) {
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            ResourceExtraXmlParser.checkForResources(((Attr)attr).getValue(), builder, idProvider);
        }
        for (Node current = element.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            ResourceExtraXmlParser.parseChild((Element)current, builder, idProvider);
        }
    }

    private static void checkForResources(String text, SymbolTable.Builder builder, IdProvider idProvider) {
        String name;
        Symbol.NormalSymbol newSymbol;
        if (text != null && text.startsWith("@+id/") && !builder.contains(newSymbol = Symbol.createAndValidateSymbol(ResourceType.ID, SymbolUtils.canonicalizeValueResourceName(name = text.substring("@+id/".length(), text.length())), idProvider))) {
            builder.add(newSymbol);
        }
    }
}

