/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.MergingException;
import com.android.resources.ResourceFolderType;
import com.android.utils.SdkUtils;
import java.io.File;
import java.util.List;
import javax.lang.model.SourceVersion;

public final class FileResourceNameValidator {
    private FileResourceNameValidator() {
    }

    public static void validate(File file, ResourceFolderType resourceType) throws MergingException {
        String error = FileResourceNameValidator.getErrorTextForFileResource(file.getName(), resourceType);
        if (error != null) {
            throw MergingException.withMessage(error, new Object[0]).withFile(file).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getErrorTextForFileResource(String fileNameWithExt, ResourceFolderType resourceFolderType) {
        String fileName;
        if (fileNameWithExt.trim().isEmpty()) {
            return "Resource must have a name";
        }
        if (resourceFolderType == ResourceFolderType.RAW) {
            fileName = FileResourceNameValidator.removeSingleExtension(fileNameWithExt);
            return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
        } else if (resourceFolderType == ResourceFolderType.DRAWABLE || resourceFolderType == ResourceFolderType.MIPMAP) {
            if (SdkUtils.endsWithIgnoreCase((String)fileNameWithExt, (String)".xml")) {
                fileName = fileNameWithExt.substring(0, fileNameWithExt.length() - ".xml".length());
                return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
            } else {
                if (!SdkUtils.hasImageExtension((String)fileNameWithExt)) return "The file name must end with .xml or .png";
                fileName = SdkUtils.endsWithIgnoreCase((String)fileNameWithExt, (String)".9.png") ? fileNameWithExt.substring(0, fileNameWithExt.length() - ".9.png".length()) : fileNameWithExt.substring(0, fileNameWithExt.lastIndexOf(46));
            }
            return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
        } else if (resourceFolderType == ResourceFolderType.XML) {
            if (!SdkUtils.endsWithIgnoreCase((String)fileNameWithExt, (String)".xml") && !SdkUtils.endsWithIgnoreCase((String)fileNameWithExt, (String)".xsd")) return "The file name must end with .xml";
            fileName = FileResourceNameValidator.removeSingleExtension(fileNameWithExt);
            return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
        } else if (resourceFolderType == ResourceFolderType.FONT) {
            if (!SdkUtils.endsWithIgnoreCase((String)fileNameWithExt, (String)".xml") && !SdkUtils.endsWithIgnoreCase((String)fileNameWithExt, (String)".ttf") && !SdkUtils.endsWithIgnoreCase((String)fileNameWithExt, (String)".otf") && !SdkUtils.endsWithIgnoreCase((String)fileNameWithExt, (String)".ttc")) return "The file name must end with .xml, .ttf, .ttc or .otf";
            fileName = FileResourceNameValidator.removeSingleExtension(fileNameWithExt);
            return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
        } else {
            if (!SdkUtils.endsWithIgnoreCase((String)fileNameWithExt, (String)".xml")) return "The file name must end with .xml";
            fileName = fileNameWithExt.substring(0, fileNameWithExt.length() - ".xml".length());
        }
        return FileResourceNameValidator.getErrorTextForNameWithoutExtension(fileName, resourceFolderType);
    }

    public static String getErrorTextForNameWithoutExtension(String fileNameWithoutExt, ResourceFolderType resourceFolderType) {
        if (resourceFolderType == ResourceFolderType.VALUES) {
            return null;
        }
        char first = fileNameWithoutExt.charAt(0);
        if (!Character.isJavaIdentifierStart(first)) {
            return "The resource name must start with a letter";
        }
        int n = fileNameWithoutExt.length();
        for (int i = 0; i < n; ++i) {
            char c = fileNameWithoutExt.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') continue;
            return String.format("'%1$c' is not a valid file-based resource name character: File-based resource names must contain only lowercase a-z, 0-9, or underscore", Character.valueOf(c));
        }
        if (SourceVersion.isKeyword(fileNameWithoutExt)) {
            return String.format("%1$s is not a valid resource name (reserved Java keyword)", fileNameWithoutExt);
        }
        return null;
    }

    private static String removeSingleExtension(String fileNameWithExt) {
        int lastDot = fileNameWithExt.lastIndexOf(46);
        if (lastDot != -1) {
            return fileNameWithExt.substring(0, lastDot);
        }
        return fileNameWithExt;
    }

    private static boolean oneOfStartsWithIgnoreCase(List<String> strings, String prefix) {
        boolean matches = false;
        for (String allowedString : strings) {
            if (!SdkUtils.startsWithIgnoreCase((String)allowedString, (String)prefix)) continue;
            matches = true;
            break;
        }
        return matches;
    }
}

