/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.NativeToolchain;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import java.io.File;
import java.util.Objects;

public final class IdeNativeToolchain
extends IdeModel
implements NativeToolchain {
    private static final long serialVersionUID = 1L;
    private final String myName;
    private final File myCCompilerExecutable;
    private final File myCppCompilerExecutable;
    private final int myHashCode;

    public IdeNativeToolchain(NativeToolchain toolchain, ModelCache modelCache) {
        super(toolchain, modelCache);
        this.myName = toolchain.getName();
        this.myCCompilerExecutable = toolchain.getCCompilerExecutable();
        this.myCppCompilerExecutable = toolchain.getCppCompilerExecutable();
        this.myHashCode = this.calculateHashCode();
    }

    public String getName() {
        return this.myName;
    }

    public File getCCompilerExecutable() {
        return this.myCCompilerExecutable;
    }

    public File getCppCompilerExecutable() {
        return this.myCppCompilerExecutable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeToolchain)) {
            return false;
        }
        IdeNativeToolchain toolchain = (IdeNativeToolchain)o;
        return Objects.equals(this.myName, toolchain.myName) && Objects.equals(this.myCCompilerExecutable, toolchain.myCCompilerExecutable) && Objects.equals(this.myCppCompilerExecutable, toolchain.myCppCompilerExecutable);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myCCompilerExecutable, this.myCppCompilerExecutable);
    }

    public String toString() {
        return "IdeNativeToolchain{myName='" + this.myName + '\'' + ", myCCompilerExecutable=" + this.myCCompilerExecutable + ", myCppCompilerExecutable=" + this.myCppCompilerExecutable + "}";
    }
}

