/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;

public class WaitableExecutor {
    private final ForkJoinPool forkJoinPool;
    private final boolean owned;
    private final Set<ForkJoinTask<?>> futureSet = Sets.newConcurrentHashSet();

    WaitableExecutor(ForkJoinPool forkJoinPool, boolean owned) {
        this.forkJoinPool = forkJoinPool;
        this.owned = owned;
    }

    public static WaitableExecutor useGlobalSharedThreadPool() {
        return new WaitableExecutor(ForkJoinPool.commonPool(), false);
    }

    public static WaitableExecutor useNewFixedSizeThreadPool(int nThreads) {
        Preconditions.checkArgument((nThreads > 0 ? 1 : 0) != 0, (Object)"Number of threads needs to be a positive number.");
        return new WaitableExecutor(new ForkJoinPool(nThreads), true);
    }

    public static WaitableExecutor useDirectExecutor() {
        return new WaitableExecutor(new ForkJoinPool(1), true);
    }

    public synchronized <T> ForkJoinTask<T> execute(Callable<T> callable) {
        Future submitted = this.forkJoinPool.submit((Callable)callable);
        boolean added = this.futureSet.add((ForkJoinTask<?>)submitted);
        Preconditions.checkState((boolean)added, (Object)"Failed to add task");
        return submitted;
    }

    int getUnprocessedTasksCount() {
        return this.futureSet.size();
    }

    public synchronized <T> List<T> waitForTasksWithQuickFail(boolean cancelRemaining) throws InterruptedException {
        ArrayList results = Lists.newArrayListWithCapacity((int)this.futureSet.size());
        try {
            for (ForkJoinTask<?> future : this.futureSet) {
                results.add(future.join());
            }
        }
        catch (Error | RuntimeException e) {
            if (cancelRemaining) {
                this.cancelAllTasks();
            }
            throw e;
        }
        finally {
            this.futureSet.clear();
            if (this.owned) {
                this.forkJoinPool.shutdownNow();
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> List<TaskResult<T>> waitForAllTasks() throws InterruptedException {
        ArrayList results = Lists.newArrayListWithCapacity((int)this.futureSet.size());
        try {
            for (ForkJoinTask<?> future : this.futureSet) {
                try {
                    results.add(new TaskResult(future.join()));
                }
                catch (RuntimeException e) {
                    results.add(new TaskResult(e.getCause() != null ? e.getCause() : e));
                }
                catch (Error e) {
                    results.add(new TaskResult(e));
                }
            }
        }
        finally {
            this.futureSet.clear();
            if (this.owned) {
                this.forkJoinPool.shutdownNow();
            }
        }
        return results;
    }

    public synchronized void cancelAllTasks() {
        for (Future future : this.futureSet) {
            future.cancel(true);
        }
        this.futureSet.clear();
    }

    public int getParallelism() {
        return this.forkJoinPool.getParallelism();
    }

    public static final class TaskResult<T> {
        private final T value;
        private final Throwable exception;

        TaskResult(T value) {
            this.value = value;
            this.exception = null;
        }

        TaskResult(Throwable exception) {
            this.value = null;
            this.exception = (Throwable)Preconditions.checkNotNull((Object)exception);
        }

        public T getValue() {
            return this.value;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.getValue()).add("exception", (Object)this.getException()).toString();
        }
    }
}

