/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.io.FileOp;
import java.io.File;
import java.util.function.Predicate;

public class MavenRepositories {
    private static final String MAVEN_METADATA_FILE_NAME = "maven-metadata.xml";

    private MavenRepositories() {
    }

    public static GradleCoordinate getHighestInstalledVersion(String groupId, String artifactId, File repository, Predicate<GradleVersion> filter2, boolean allowPreview, FileOp fileOp) {
        File versionDir = MavenRepositories.getArtifactIdDirectory(repository, groupId, artifactId);
        File[] versions = fileOp.listFiles(versionDir);
        GradleCoordinate maxVersion = null;
        for (File dir : versions) {
            GradleCoordinate gc;
            if (!fileOp.isDirectory(dir) || (gc = GradleCoordinate.parseCoordinateString(groupId + ":" + artifactId + ":" + dir.getName())) == null || !allowPreview && MavenRepositories.isPreview(gc) || maxVersion != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(gc, maxVersion) <= 0 || !MavenRepositories.applyVersionPredicate(gc.getRevision(), filter2)) continue;
            maxVersion = gc;
        }
        return maxVersion;
    }

    private static boolean applyVersionPredicate(String revision, Predicate<GradleVersion> predicate) {
        if (predicate == null) {
            return true;
        }
        GradleVersion version = GradleVersion.tryParse(revision);
        return version != null && predicate.test(version);
    }

    public static GradleVersion getHighestInstalledVersionNumber(String groupId, String artifactId, File repository, Predicate<GradleVersion> filter2, boolean allowPreview, FileOp fileOp) {
        File versionDir = MavenRepositories.getArtifactIdDirectory(repository, groupId, artifactId);
        return MavenRepositories.getHighestVersion(versionDir, filter2, allowPreview, fileOp);
    }

    public static GradleVersion getHighestVersion(File versionDir, Predicate<GradleVersion> filter2, boolean allowPreview, FileOp fileOp) {
        File[] versionDirs = fileOp.listFiles(versionDir);
        GradleVersion maxVersion = null;
        for (File dir : versionDirs) {
            GradleVersion version;
            String name;
            if (!fileOp.isDirectory(dir) || (name = dir.getName()).isEmpty() || !Character.isDigit(name.charAt(0)) || (version = GradleVersion.tryParse(name)) == null || !allowPreview && (version.isPreview() || filter2 != null && !filter2.test(version)) || maxVersion != null && version.compareTo(maxVersion) <= 0) continue;
            maxVersion = version;
        }
        return maxVersion;
    }

    public static boolean isPreview(GradleCoordinate coordinate) {
        if (coordinate.isPreview()) {
            return true;
        }
        return "com.google.android.gms".equals(coordinate.getGroupId()) && "play-services".equals(coordinate.getArtifactId()) && "5.2.08".equals(coordinate.getRevision());
    }

    public static File getArtifactIdDirectory(File repository, String groupId, String artifactId) {
        return new File(repository, groupId.replace('.', File.separatorChar) + File.separator + artifactId);
    }

    public static File getArtifactDirectory(File repository, GradleCoordinate coordinate) {
        File artifactIdDirectory = MavenRepositories.getArtifactIdDirectory(repository, coordinate.getGroupId(), coordinate.getArtifactId());
        return new File(artifactIdDirectory, coordinate.getRevision());
    }

    public static File getMavenMetadataFile(File repository, String groupId, String artifactId) {
        return new File(MavenRepositories.getArtifactIdDirectory(repository, groupId, artifactId), MAVEN_METADATA_FILE_NAME);
    }
}

