/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.internal.ResourceCompilationException;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.ide.common.resources.CopyToOutputDirectoryResourceCompilationService;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergeWriter;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.ResourceCompilationService;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourcePreprocessor;
import com.android.ide.common.resources.SingleFileProcessor;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergedResourceWriter
extends MergeWriter<ResourceItem, FileGenerationParameters> {
    private final ResourcePreprocessor mPreprocessor;
    private final File mPublicFile;
    private MergingLog mMergingLog;
    private DocumentBuilderFactory mFactory;
    private final ResourceCompilationService mResourceCompiler;
    private ListMultimap<String, ResourceItem> mValuesResMap;
    private Set<String> mQualifierWithDeletedValues;
    private final ConcurrentLinkedDeque<Future<File>> mCompiling;
    private final File mTemporaryDirectory;
    private final File mCompiledFileMapFile;
    private final SingleFileProcessor dataBindingExpressionRemover;
    private final File notCompiledOutputDirectory;
    private final boolean pseudoLocalesEnabled;
    private final boolean crunchPng;
    private final Properties mCompiledFileMap;
    private final ConcurrentLinkedQueue<CompileResourceRequest> mCompileResourceRequests = new ConcurrentLinkedQueue();

    public MergedResourceWriter(WorkerExecutorFacade<FileGenerationParameters> workerExecutor, File rootFolder, File publicFile, MergingLog blameLog, ResourcePreprocessor preprocessor, ResourceCompilationService resourceCompilationService, File temporaryDirectory, SingleFileProcessor dataBindingExpressionRemover, File notCompiledOutputDirectory, boolean pseudoLocalesEnabled, boolean crunchPng) {
        super(rootFolder, workerExecutor);
        this.mResourceCompiler = resourceCompilationService;
        this.mPublicFile = publicFile;
        this.mMergingLog = blameLog;
        this.mPreprocessor = preprocessor;
        this.mCompiling = new ConcurrentLinkedDeque();
        this.mTemporaryDirectory = temporaryDirectory;
        this.dataBindingExpressionRemover = dataBindingExpressionRemover;
        this.notCompiledOutputDirectory = notCompiledOutputDirectory;
        this.pseudoLocalesEnabled = pseudoLocalesEnabled;
        this.crunchPng = crunchPng;
        this.mCompiledFileMapFile = new File(temporaryDirectory, "compile-file-map.properties");
        this.mCompiledFileMap = new Properties();
        if (this.mCompiledFileMapFile.exists()) {
            try (FileReader fr = new FileReader(this.mCompiledFileMapFile);){
                this.mCompiledFileMap.load(fr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static MergedResourceWriter createWriterWithoutPngCruncher(File rootFolder, File publicFile, File blameLogFolder, ResourcePreprocessor preprocessor, File temporaryDirectory) {
        return new MergedResourceWriter(new WorkerExecutorFacade<FileGenerationParameters>(){

            @Override
            public void submit(FileGenerationParameters parameter) {
                new FileGenerationWorkAction(parameter).run();
            }

            @Override
            public void await() {
            }
        }, rootFolder, publicFile, blameLogFolder != null ? new MergingLog(blameLogFolder) : null, preprocessor, CopyToOutputDirectoryResourceCompilationService.INSTANCE, temporaryDirectory, null, null, false, false);
    }

    @Override
    public void start(DocumentBuilderFactory factory) throws MergeConsumer.ConsumerException {
        super.start(factory);
        this.mValuesResMap = ArrayListMultimap.create();
        this.mQualifierWithDeletedValues = Sets.newHashSet();
        this.mFactory = factory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void end() throws MergeConsumer.ConsumerException {
        File tmpDir;
        super.end();
        try {
            tmpDir = new File(this.mTemporaryDirectory, "stripped.dir");
            try {
                FileUtils.cleanOutputDir((File)tmpDir);
            }
            catch (IOException e) {
                throw new MergeConsumer.ConsumerException(e);
            }
        }
        catch (Exception e) {
            throw new MergeConsumer.ConsumerException(e);
        }
        while (!this.mCompileResourceRequests.isEmpty()) {
            CompileResourceRequest request = this.mCompileResourceRequests.poll();
            try {
                File fileToCompile = request.getInputFile();
                if (this.mMergingLog != null) {
                    this.mMergingLog.logCopy(request.getInputFile(), this.mResourceCompiler.compileOutputFor(request));
                }
                if (this.dataBindingExpressionRemover != null && request.getInputDirectoryName().startsWith("layout") && request.getInputFile().getName().endsWith(".xml")) {
                    File strippedLayoutFolder = new File(tmpDir, request.getInputDirectoryName());
                    File strippedLayout = new File(strippedLayoutFolder, request.getInputFile().getName());
                    boolean removedDataBinding = this.dataBindingExpressionRemover.processSingleFile(request.getInputFile(), strippedLayout);
                    if (removedDataBinding) {
                        if (this.mMergingLog != null) {
                            this.mMergingLog.logCopy(request.getInputFile(), strippedLayout);
                        }
                        fileToCompile = strippedLayout;
                    }
                }
                if (this.notCompiledOutputDirectory != null) {
                    File typeDir = new File(this.notCompiledOutputDirectory, request.getInputDirectoryName());
                    FileUtils.mkdirs((File)typeDir);
                    FileUtils.copyFileToDirectory((File)fileToCompile, (File)typeDir);
                }
                this.mResourceCompiler.submitCompile(new CompileResourceRequest(fileToCompile, request.getOutputDirectory(), request.getInputDirectoryName(), this.pseudoLocalesEnabled, this.crunchPng, (Map<SourcePosition, SourceFilePosition>)ImmutableMap.of(), request.getInputFile()));
                this.mCompiledFileMap.put(fileToCompile.getAbsolutePath(), this.mResourceCompiler.compileOutputFor(request).getAbsolutePath());
            }
            catch (ResourceCompilationException | IOException e) {
                throw MergingException.wrapException(e).withFile(request.getInputFile()).build();
            }
        }
        if (this.mMergingLog != null) {
            try {
                this.mMergingLog.write();
            }
            catch (IOException e) {
                throw new MergeConsumer.ConsumerException(e);
            }
            this.mMergingLog = null;
        }
        this.mValuesResMap = null;
        this.mQualifierWithDeletedValues = null;
        this.mFactory = null;
        try (FileWriter fw = new FileWriter(this.mCompiledFileMapFile);){
            this.mCompiledFileMap.store(fw, null);
            return;
        }
        catch (IOException e) {
            throw new MergeConsumer.ConsumerException(e);
        }
    }

    @Override
    public boolean ignoreItemInMerge(ResourceItem item) {
        return item.getIgnoredFromDiskMerge();
    }

    @Override
    public void addItem(ResourceItem item) throws MergeConsumer.ConsumerException {
        DataFile.FileType type = item.getSourceType();
        if (type == DataFile.FileType.XML_VALUES) {
            this.mValuesResMap.put((Object)item.getQualifiers(), (Object)item);
        } else {
            Preconditions.checkState((item.getSource() != null ? 1 : 0) != 0);
            if (item.isTouched()) {
                File file = item.getFile();
                String folderName = MergedResourceWriter.getFolderName(item);
                if (type == DataFile.FileType.GENERATED_FILES) {
                    try {
                        FileGenerationParameters workItem = new FileGenerationParameters(item, this.mPreprocessor);
                        if (workItem.resourceItem.getSource() != null) {
                            this.getExecutor().submit(workItem);
                        }
                    }
                    catch (Exception e) {
                        throw new MergeConsumer.ConsumerException((Throwable)e, ((ResourceFile)item.getSource()).getFile());
                    }
                }
                this.mCompileResourceRequests.add(new CompileResourceRequest(file, this.getRootFolder(), folderName));
            }
        }
    }

    @Override
    public void removeItem(ResourceItem removedItem, ResourceItem replacedBy) throws MergeConsumer.ConsumerException {
        DataFile.FileType removedType = removedItem.getSourceType();
        DataFile.FileType replacedType = replacedBy != null ? replacedBy.getSourceType() : null;
        switch (removedType) {
            case SINGLE_FILE: 
            case GENERATED_FILES: {
                File replacedFile;
                File removedFile;
                if ((replacedType == DataFile.FileType.SINGLE_FILE || replacedType == DataFile.FileType.GENERATED_FILES) && (removedFile = this.getResourceOutputFile(removedItem)).equals(replacedFile = this.getResourceOutputFile(replacedBy))) break;
                this.removeOutFile(removedItem);
                break;
            }
            case XML_VALUES: {
                this.mQualifierWithDeletedValues.add(removedItem.getQualifiers());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    protected void postWriteAction() throws MergeConsumer.ConsumerException {
        File tmpDir = new File(this.mTemporaryDirectory, "merged.dir");
        try {
            FileUtils.cleanOutputDir((File)tmpDir);
        }
        catch (IOException e) {
            throw new MergeConsumer.ConsumerException(e);
        }
        for (String key : this.mValuesResMap.keySet()) {
            boolean mustWriteFile = this.mQualifierWithDeletedValues.remove(key);
            List items = this.mValuesResMap.get((Object)key);
            if (!mustWriteFile) {
                for (ResourceItem item : items) {
                    if (!item.isTouched()) continue;
                    mustWriteFile = true;
                    break;
                }
            }
            if (!mustWriteFile) continue;
            try {
                boolean mkdirs;
                String folderName = key.isEmpty() ? ResourceFolderType.VALUES.getName() : ResourceFolderType.VALUES.getName() + "-" + key;
                File valuesFolder = new File(tmpDir, folderName);
                File outFile = new File(valuesFolder, folderName + ".xml");
                FileUtils.mkdirs((File)valuesFolder);
                DocumentBuilder builder = this.mFactory.newDocumentBuilder();
                Document document = builder.newDocument();
                String publicTag = ResourceType.PUBLIC.getName();
                ArrayList publicNodes = null;
                Element rootNode = document.createElement("resources");
                document.appendChild(rootNode);
                Collections.sort(items);
                for (ResourceItem item : items) {
                    Node nodeValue = item.getValue();
                    if (nodeValue != null && publicTag.equals(nodeValue.getNodeName())) {
                        if (publicNodes == null) {
                            publicNodes = Lists.newArrayList();
                        }
                        publicNodes.add(nodeValue);
                        continue;
                    }
                    rootNode.appendChild(document.createTextNode("\n    "));
                    ResourceFile source = (ResourceFile)item.getSource();
                    Node adoptedNode = NodeUtils.adoptNode(document, nodeValue);
                    if (source != null) {
                        XmlUtils.attachSourceFile((Node)adoptedNode, (SourceFile)new SourceFile(source.getFile()));
                    }
                    rootNode.appendChild(adoptedNode);
                }
                rootNode.appendChild(document.createTextNode("\n"));
                LinkedHashMap blame = this.mMergingLog == null ? null : Maps.newLinkedHashMap();
                String content = blame != null ? XmlUtils.toXml((Node)document, (Map)blame) : XmlUtils.toXml((Node)document);
                Files.write((CharSequence)content, (File)outFile, (Charset)Charsets.UTF_8);
                CompileResourceRequest request = new CompileResourceRequest(outFile, this.getRootFolder(), folderName, this.pseudoLocalesEnabled, this.crunchPng, blame != null ? blame : ImmutableMap.of());
                if (this.notCompiledOutputDirectory != null) {
                    File typeDir = new File(this.notCompiledOutputDirectory, folderName);
                    FileUtils.mkdirs((File)typeDir);
                    FileUtils.copyFileToDirectory((File)outFile, (File)typeDir);
                }
                if (blame != null) {
                    this.mMergingLog.logSource(new SourceFile(this.mResourceCompiler.compileOutputFor(request)), blame);
                    this.mMergingLog.logSource(new SourceFile(outFile), blame);
                }
                this.mResourceCompiler.submitCompile(request);
                if (publicNodes == null || this.mPublicFile == null) continue;
                int size = publicNodes.size();
                StringBuilder sb = new StringBuilder(size * 80);
                for (Node node : publicNodes) {
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String name = element.getAttribute("name");
                    String type = element.getAttribute("type");
                    if (name.isEmpty() || type.isEmpty()) continue;
                    String flattenedName = name.replace('.', '_');
                    sb.append(type).append(' ').append(flattenedName).append('\n');
                }
                File parentFile = this.mPublicFile.getParentFile();
                if (!parentFile.exists() && !(mkdirs = parentFile.mkdirs())) {
                    throw new IOException("Could not create " + parentFile);
                }
                String text = sb.toString();
                Files.write((CharSequence)text, (File)this.mPublicFile, (Charset)Charsets.UTF_8);
            }
            catch (Exception e) {
                throw new MergeConsumer.ConsumerException(e);
            }
        }
        for (String key : this.mQualifierWithDeletedValues) {
            String folderName;
            String string = folderName = key != null && !key.isEmpty() ? ResourceFolderType.VALUES.getName() + "-" + key : ResourceFolderType.VALUES.getName();
            if (this.notCompiledOutputDirectory != null) {
                this.removeOutFile(FileUtils.join((File)this.notCompiledOutputDirectory, (String[])new String[]{folderName, folderName + ".xml"}));
            }
            this.removeOutFile(this.mResourceCompiler.compileOutputFor(new CompileResourceRequest(FileUtils.join((File)this.getRootFolder(), (String[])new String[]{folderName, folderName + ".xml"}), this.getRootFolder(), folderName)));
        }
    }

    private File getResourceOutputFile(ResourceItem resourceItem) {
        File file = resourceItem.getFile();
        String compiledFilePath = this.mCompiledFileMap.getProperty(file.getAbsolutePath());
        if (compiledFilePath != null) {
            return new File(compiledFilePath);
        }
        return this.mResourceCompiler.compileOutputFor(new CompileResourceRequest(file, this.getRootFolder(), MergedResourceWriter.getFolderName(resourceItem)));
    }

    private void removeLayoutFileFromDataBindingOutputFolder(ResourceItem resourceItem) {
        File originalFile = resourceItem.getFile();
        if (!originalFile.getParentFile().getName().startsWith("layout") || !originalFile.getName().endsWith(".xml")) {
            return;
        }
        this.dataBindingExpressionRemover.processRemovedFile(originalFile);
    }

    private void removeFileFromNotCompiledOutputDir(ResourceItem resourceItem) {
        File originalFile = resourceItem.getFile();
        File resTypeDir = new File(this.notCompiledOutputDirectory, originalFile.getParentFile().getName());
        File toRemove = new File(resTypeDir, originalFile.getName());
        this.removeOutFile(toRemove);
    }

    private boolean removeOutFile(ResourceItem resourceItem) {
        File fileToRemove = this.getResourceOutputFile(resourceItem);
        if (this.dataBindingExpressionRemover != null) {
            this.removeLayoutFileFromDataBindingOutputFolder(resourceItem);
        }
        if (this.notCompiledOutputDirectory != null) {
            this.removeFileFromNotCompiledOutputDir(resourceItem);
        }
        return this.removeOutFile(fileToRemove);
    }

    private boolean removeOutFile(File fileToRemove) {
        if (this.mMergingLog != null) {
            this.mMergingLog.logRemove(new SourceFile(fileToRemove));
        }
        return fileToRemove.delete();
    }

    private static String getFolderName(ResourceItem resourceItem) {
        ResourceType itemType = resourceItem.getType();
        String folderName = itemType.getName();
        String qualifiers = resourceItem.getQualifiers();
        if (!qualifiers.isEmpty()) {
            folderName = folderName + "-" + qualifiers;
        }
        return folderName;
    }

    public static class FileGenerationWorkAction
    implements Runnable {
        private final FileGenerationParameters workItem;

        public FileGenerationWorkAction(FileGenerationParameters workItem) {
            this.workItem = workItem;
        }

        @Override
        public void run() {
            try {
                this.workItem.resourcePreprocessor.generateFile(this.workItem.resourceItem.getFile(), ((ResourceFile)this.workItem.resourceItem.getSource()).getFile());
            }
            catch (Exception e) {
                throw new RuntimeException("Error while processing " + ((ResourceFile)this.workItem.resourceItem.getSource()).getFile() + " : " + e.getMessage(), e);
            }
        }
    }

    public static class FileGenerationParameters
    implements Serializable {
        public final ResourceItem resourceItem;
        public final ResourcePreprocessor resourcePreprocessor;

        private FileGenerationParameters(ResourceItem resourceItem, ResourcePreprocessor resourcePreprocessor) {
            this.resourceItem = resourceItem;
            this.resourcePreprocessor = resourcePreprocessor;
        }
    }
}

