/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.deprecated;

import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.deprecated.IdResourceParser;
import com.android.ide.common.resources.deprecated.ResourceFile;
import com.android.ide.common.resources.deprecated.ResourceFolder;
import com.android.ide.common.resources.deprecated.ResourceItem;
import com.android.ide.common.resources.deprecated.ResourceRepository;
import com.android.ide.common.resources.deprecated.ScanningContext;
import com.android.ide.common.resources.deprecated.ValueResourceParser;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.resources.ResourceType;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

@Deprecated
public final class IdGeneratingResourceFile
extends ResourceFile
implements ValueResourceParser.IValueResourceRepository {
    private final ResourceValueMap mIdResources = ResourceValueMap.create();
    private final Collection<ResourceType> mResourceTypeList;
    private final String mFileName;
    private final ResourceType mFileType;
    private final ResourceValue mFileValue;

    public IdGeneratingResourceFile(IAbstractFile file, ResourceFolder folder, ResourceType type) {
        super(file, folder);
        this.mFileType = type;
        this.mResourceTypeList = EnumSet.of(this.mFileType, ResourceType.ID);
        this.mFileName = this.getFileName(type);
        this.mFileValue = this.getFileValue(file, folder);
    }

    @Override
    protected void load(ScanningContext context) {
        this.parseFileForIds(context);
        this.updateResourceItems(context);
    }

    @Override
    protected void update(ScanningContext context) {
        HashSet<String> oldIdNames = new HashSet<String>(this.mIdResources.keySet());
        this.mIdResources.clear();
        if (!this.parseFileForIds(context)) {
            context.requestFullAapt();
        }
        Set<String> keySet = this.mIdResources.keySet();
        assert (keySet != oldIdNames);
        if (!oldIdNames.equals(keySet)) {
            this.updateResourceItems(context);
        }
    }

    @Override
    protected void dispose(ScanningContext context) {
        ResourceRepository repository = this.getRepository();
        repository.removeFile(this.mResourceTypeList, (ResourceFile)this);
        context.requestFullAapt();
    }

    @Override
    public Collection<ResourceType> getResourceTypes() {
        return this.mResourceTypeList;
    }

    @Override
    public boolean hasResources(ResourceType type) {
        return type == this.mFileType || type == ResourceType.ID && !this.mIdResources.isEmpty();
    }

    @Override
    public ResourceValue getValue(ResourceType type, String name) {
        if (type != this.mFileType && type != ResourceType.ID) {
            return null;
        }
        if (type == this.mFileType && name.equals(this.mFileName)) {
            return this.mFileValue;
        }
        return (ResourceValue)this.mIdResources.get(name);
    }

    private boolean parseFileForIds(ScanningContext context) {
        IdResourceParser parser = new IdResourceParser(this, context, this.isFramework());
        try {
            IAbstractFile file = this.getFile();
            return parser.parse(this.mFileType, file.getOsLocation(), file.getContents());
        }
        catch (IOException iOException) {
        }
        catch (StreamException streamException) {
            // empty catch block
        }
        return false;
    }

    private void updateResourceItems(ScanningContext context) {
        ResourceRepository repository = this.getRepository();
        repository.removeFile(this.mResourceTypeList, (ResourceFile)this);
        ResourceItem item = repository.getResourceItem(this.mFileType, this.mFileName);
        item.add(this);
        for (String idName : this.mIdResources.keySet()) {
            item = repository.getResourceItem(ResourceType.ID, idName);
            item.add(this);
        }
        context.requestFullAapt();
    }

    private ResourceValue getFileValue(IAbstractFile file, ResourceFolder folder) {
        DensityQualifier qualifier = folder.getConfiguration().getDensityQualifier();
        Object value = !ResourceQualifier.isValid(qualifier) ? new ResourceValue(new ResourceReference(this.mFileType, this.mFileName, this.isFramework()), file.getOsLocation()) : new DensityBasedResourceValue(new ResourceReference(this.mFileType, this.mFileName, this.isFramework()), file.getOsLocation(), qualifier.getValue());
        return value;
    }

    private String getFileName(ResourceType type) {
        String name = this.getFile().getName();
        int pos = name.indexOf(46);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        return name;
    }

    @Override
    public void addResourceValue(ResourceValue value) {
        this.mIdResources.put(value.getName(), value);
    }
}

