/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.LintOptions;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class IdeLintOptions
extends IdeModel
implements LintOptions {
    private static final long serialVersionUID = 1L;
    private final File myBaselineFile;
    private final Map<String, Integer> mySeverityOverrides;
    private final boolean myCheckTestSources;
    private final int myHashCode;

    public IdeLintOptions(LintOptions options, ModelCache modelCache, GradleVersion modelVersion) {
        super(options, modelCache);
        this.myBaselineFile = modelVersion != null && modelVersion.isAtLeast(2, 3, 0, "beta", 2, true) ? options.getBaselineFile() : null;
        this.mySeverityOverrides = IdeLintOptions.copy(options.getSeverityOverrides());
        this.myCheckTestSources = modelVersion != null && modelVersion.isAtLeast(2, 4, 0) && options.isCheckTestSources();
        this.myHashCode = this.calculateHashCode();
    }

    private static Map<String, Integer> copy(Map<String, Integer> original) {
        return original != null ? ImmutableMap.copyOf(original) : null;
    }

    public Set<String> getDisable() {
        throw new UnusedModelMethodException("getDisable");
    }

    public Set<String> getEnable() {
        throw new UnusedModelMethodException("getEnable");
    }

    public Set<String> getCheck() {
        throw new UnusedModelMethodException("getCheck");
    }

    public File getLintConfig() {
        throw new UnusedModelMethodException("getLintConfig");
    }

    public File getTextOutput() {
        throw new UnusedModelMethodException("getTextOutput");
    }

    public File getHtmlOutput() {
        throw new UnusedModelMethodException("getHtmlOutput");
    }

    public File getXmlOutput() {
        throw new UnusedModelMethodException("getXmlOutput");
    }

    public File getBaselineFile() {
        return this.myBaselineFile;
    }

    public Map<String, Integer> getSeverityOverrides() {
        return this.mySeverityOverrides;
    }

    public boolean isAbortOnError() {
        throw new UnusedModelMethodException("isAbortOnError");
    }

    public boolean isAbsolutePaths() {
        throw new UnusedModelMethodException("isAbsolutePaths");
    }

    public boolean isNoLines() {
        throw new UnusedModelMethodException("isNoLines");
    }

    public boolean isQuiet() {
        throw new UnusedModelMethodException("isQuiet");
    }

    public boolean isCheckAllWarnings() {
        throw new UnusedModelMethodException("isCheckAllWarnings");
    }

    public boolean isIgnoreWarnings() {
        throw new UnusedModelMethodException("isIgnoreWarnings");
    }

    public boolean isWarningsAsErrors() {
        throw new UnusedModelMethodException("isWarningsAsErrors");
    }

    public boolean isCheckTestSources() {
        return this.myCheckTestSources;
    }

    public boolean isCheckGeneratedSources() {
        throw new UnusedModelMethodException("isCheckGeneratedSources");
    }

    public boolean isExplainIssues() {
        throw new UnusedModelMethodException("isExplainIssues");
    }

    public boolean isShowAll() {
        throw new UnusedModelMethodException("isShowAll");
    }

    public boolean getTextReport() {
        throw new UnusedModelMethodException("getTextReport");
    }

    public boolean getHtmlReport() {
        throw new UnusedModelMethodException("getHtmlReport");
    }

    public boolean getXmlReport() {
        throw new UnusedModelMethodException("getXmlReport");
    }

    public boolean isCheckReleaseBuilds() {
        throw new UnusedModelMethodException("isCheckReleaseBuilds");
    }

    public boolean isCheckDependencies() {
        throw new UnusedModelMethodException("isCheckDependencies");
    }

    public boolean getApplySuggestions() {
        throw new UnusedModelMethodException("isCheckDependencies");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeLintOptions)) {
            return false;
        }
        IdeLintOptions options = (IdeLintOptions)o;
        return this.myCheckTestSources == options.myCheckTestSources && Objects.equals(this.myBaselineFile, options.myBaselineFile) && Objects.equals(this.mySeverityOverrides, options.mySeverityOverrides);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myBaselineFile, this.mySeverityOverrides, this.myCheckTestSources);
    }

    public String toString() {
        return "IdeLintOptions{myBaselineFile=" + this.myBaselineFile + ", mySeverityOverrides=" + this.mySeverityOverrides + ", myCheckTestSources=" + this.myCheckTestSources + "}";
    }
}

