/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.ApiVersion;
import com.android.builder.model.ClassField;
import com.android.ide.common.gradle.model.GradleModelConverter;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.AndroidProject;
import com.android.projectmodel.DynamicResourceValue;
import com.android.projectmodel.ProjectType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\u000b\u001a\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"DIM_ARTIFACTS", "", "DIM_BUILD_TYPE", "DIM_UNNAMED_FLAVOR", "MAIN_ARTIFACT_NAME", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "Lcom/android/builder/model/ApiVersion;", "getAndroidVersion", "(Lcom/android/builder/model/ApiVersion;)Lcom/android/sdklib/AndroidVersion;", "classFieldsToDynamicResourceValues", "", "Lcom/android/projectmodel/DynamicResourceValue;", "classFields", "Lcom/android/builder/model/ClassField;", "filesToPathStrings", "", "Lcom/android/ide/common/util/PathString;", "files", "", "Ljava/io/File;", "getProjectType", "Lcom/android/projectmodel/ProjectType;", "typeId", "", "toProjectModel", "Lcom/android/projectmodel/AndroidProject;", "Lcom/android/ide/common/gradle/model/IdeAndroidProject;", "cache", "Lcom/android/ide/common/gradle/model/ModelCache;", "sdk-common"})
@JvmName(name="GradleModelConverterUtil")
public final class GradleModelConverterUtil {
    @NotNull
    public static final String DIM_UNNAMED_FLAVOR = "unnamedFlavorDimension";
    @NotNull
    public static final String DIM_BUILD_TYPE = "buildType";
    @NotNull
    public static final String DIM_ARTIFACTS = "artifact";
    @NotNull
    public static final String MAIN_ARTIFACT_NAME = "main";

    @NotNull
    public static final AndroidVersion getAndroidVersion(@NotNull ApiVersion $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new AndroidVersion($receiver.getApiLevel(), $receiver.getCodename());
    }

    @NotNull
    public static final ProjectType getProjectType(int typeId) {
        ProjectType projectType;
        switch (typeId) {
            case 0: {
                projectType = ProjectType.APP;
                break;
            }
            case 1: {
                projectType = ProjectType.LIBRARY;
                break;
            }
            case 2: {
                projectType = ProjectType.TEST;
                break;
            }
            case 4: {
                projectType = ProjectType.INSTANT_APP;
                break;
            }
            case 5: {
                projectType = ProjectType.FEATURE;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("The value " + typeId + " is not a valid project type ID");
            }
        }
        return projectType;
    }

    @NotNull
    public static final AndroidProject toProjectModel(@NotNull IdeAndroidProject $receiver, @NotNull ModelCache cache) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        return new GradleModelConverter($receiver, cache).convert();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AndroidProject toProjectModel$default(IdeAndroidProject ideAndroidProject, ModelCache modelCache, int n, Object object) {
        if ((n & 1) != 0) {
            modelCache = new ModelCache();
        }
        return GradleModelConverterUtil.toProjectModel(ideAndroidProject, modelCache);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PathString> filesToPathStrings(@NotNull Collection<? extends File> files) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Iterable iterable = $receiver$iv = (Iterable)files;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            PathString pathString = new PathString((File)it);
            collection.add(pathString);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final Map<String, DynamicResourceValue> classFieldsToDynamicResourceValues(@NotNull Map<String, ? extends ClassField> classFields) {
        Intrinsics.checkParameterIsNotNull(classFields, (String)"classFields");
        HashMap result = new HashMap();
        for (ClassField classField : classFields.values()) {
            String string;
            ResourceType resourceType = ResourceType.getEnum((String)classField.getType());
            if (resourceType == null) continue;
            Map map = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)classField.getName(), (String)"field.name");
            String string2 = classField.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"field.value");
            DynamicResourceValue dynamicResourceValue = new DynamicResourceValue(resourceType, string2);
            map.put(string, dynamicResourceValue);
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)result);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.copyOf(result)");
        return (Map)immutableMap;
    }
}

