/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.ide.common.gradle.model.IdeFilterData;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeOutputFile;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public abstract class IdeVariantOutput
extends IdeModel
implements VariantOutput {
    private static final long serialVersionUID = 1L;
    private final Collection<? extends OutputFile> myOutputs;
    private final Collection<String> myFilterTypes;
    private final Collection<FilterData> myFilters;
    private final OutputFile myMainOutputFile;
    private final String myOutputType;
    private final int myVersionCode;
    private final int myHashCode;

    public IdeVariantOutput(VariantOutput output, ModelCache modelCache) {
        super(output, modelCache);
        this.myOutputs = IdeVariantOutput.copy(output.getOutputs(), modelCache, (K outputFile) -> new IdeOutputFile((OutputFile)outputFile, modelCache));
        this.myFilterTypes = IdeVariantOutput.copyNewProperty(() -> ImmutableList.copyOf((Collection)output.getFilterTypes()), Collections.emptyList());
        this.myFilters = IdeVariantOutput.copyFilters(output, modelCache);
        this.myMainOutputFile = IdeVariantOutput.copyNewProperty(modelCache, () -> ((VariantOutput)output).getMainOutputFile(), file -> new IdeOutputFile((OutputFile)file, modelCache), null);
        this.myOutputType = IdeVariantOutput.copyNewProperty(() -> ((VariantOutput)output).getOutputType(), null);
        this.myVersionCode = output.getVersionCode();
        this.myHashCode = this.calculateHashCode();
    }

    private static Collection<FilterData> copyFilters(VariantOutput output, ModelCache modelCache) {
        try {
            return IdeVariantOutput.copy(output.getFilters(), modelCache, (K data) -> new IdeFilterData((FilterData)data, modelCache));
        }
        catch (UnsupportedOperationException ignored) {
            return null;
        }
    }

    public OutputFile getMainOutputFile() {
        if (this.myMainOutputFile != null) {
            return this.myMainOutputFile;
        }
        throw new UnsupportedOperationException("getMainOutputFile()");
    }

    public Collection<? extends OutputFile> getOutputs() {
        return this.myOutputs;
    }

    public String getOutputType() {
        if (this.myOutputType != null) {
            return this.myOutputType;
        }
        throw new UnsupportedOperationException("getOutputType");
    }

    public Collection<String> getFilterTypes() {
        return this.myFilterTypes;
    }

    public Collection<FilterData> getFilters() {
        if (this.myFilters != null) {
            return this.myFilters;
        }
        throw new UnsupportedOperationException("getFilters");
    }

    public int getVersionCode() {
        return this.myVersionCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeVariantOutput)) {
            return false;
        }
        IdeVariantOutput output = (IdeVariantOutput)o;
        return output.canEquals(this) && this.myVersionCode == output.myVersionCode && Objects.equals(this.myMainOutputFile, output.myMainOutputFile) && Objects.equals(this.myOutputs, output.myOutputs) && Objects.equals(this.myOutputType, output.myOutputType) && Objects.equals(this.myFilterTypes, output.myFilterTypes) && Objects.equals(this.myFilters, output.myFilters);
    }

    protected boolean canEquals(Object other) {
        return other instanceof IdeVariantOutput;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myMainOutputFile, this.myOutputs, this.myOutputType, this.myFilterTypes, this.myFilters, this.myVersionCode);
    }

    public String toString() {
        return "myMainOutputFile=" + this.myMainOutputFile + ", myOutputs=" + this.myOutputs + ", myOutputType='" + this.myOutputType + '\'' + ", myFilterTypes=" + this.myFilterTypes + ", myFilters=" + this.myFilters + ", myVersionCode=" + this.myVersionCode;
    }
}

