/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class SvgClipPathNode
extends SvgGroupNode {
    private final ArrayList<SvgNode> mAffectedNodes = new ArrayList();

    public SvgClipPathNode(SvgTree svgTree, Node docNode, String name) {
        super(svgTree, docNode, name);
    }

    @Override
    public SvgClipPathNode deepCopy() {
        SvgClipPathNode newInstance = new SvgClipPathNode(this.getTree(), this.getDocumentNode(), this.getName());
        newInstance.copyFrom(this);
        return newInstance;
    }

    protected void copyFrom(SvgClipPathNode from) {
        super.copyFrom(from);
        for (SvgNode node : from.mAffectedNodes) {
            this.addAffectedNode(node);
        }
    }

    @Override
    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    public void addAffectedNode(SvgNode child) {
        this.mAffectedNodes.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    @Override
    public void flatten(AffineTransform transform) {
        for (SvgNode n : this.mChildren) {
            this.mStackedTransform.setTransform(transform);
            this.mStackedTransform.concatenate(this.mLocalTransform);
            n.flatten(this.mStackedTransform);
        }
        this.mStackedTransform.setTransform(transform);
        this.mStackedTransform.concatenate(this.mLocalTransform);
        if (this.mVdAttributesMap.containsKey("stroke-width") && (this.mStackedTransform.getType() & 6) != 0) {
            this.getTree().logErrorLine("Scaling of the stroke width is ignored", this.getDocumentNode(), SvgTree.SvgLogLevel.WARNING);
        }
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        for (SvgNode p : this.mChildren) {
            p.transformIfNeeded(rootTransform);
        }
    }

    @Override
    public void writeXml(OutputStreamWriter writer, boolean inClipPath, String indent) throws IOException {
        writer.write(indent);
        writer.write("<group>");
        writer.write(System.lineSeparator());
        writer.write(indent);
        writer.write("  ");
        writer.write("<clip-path android:pathData=\"");
        for (SvgNode node : this.mChildren) {
            node.writeXml(writer, true, indent + "  ");
        }
        writer.write("\"/>");
        writer.write(System.lineSeparator());
        for (SvgNode node : this.mAffectedNodes) {
            node.writeXml(writer, false, indent + "  ");
        }
        writer.write(indent);
        writer.write("</group>");
        writer.write(System.lineSeparator());
    }

    public void setClipPathNodeAttributes() {
        for (SvgNode n : this.mAffectedNodes) {
            this.mLocalTransform.concatenate(n.mLocalTransform);
        }
    }
}

