/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

class SvgGroupNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    protected final ArrayList<SvgNode> mChildren = new ArrayList();

    SvgGroupNode(SvgTree svgTree, Node docNode, String name) {
        super(svgTree, docNode, name);
    }

    @Override
    public SvgGroupNode deepCopy() {
        SvgGroupNode newInstance = new SvgGroupNode(this.getTree(), this.getDocumentNode(), this.getName());
        newInstance.copyFrom(this);
        return newInstance;
    }

    @Override
    protected <T extends SvgGroupNode> void copyFrom(T from) {
        super.copyFrom(from);
        for (SvgNode child : from.mChildren) {
            this.addChild(child.deepCopy());
        }
    }

    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    public void replaceChild(SvgNode oldChild, SvgNode newChild) {
        int index = this.mChildren.indexOf(oldChild);
        if (index < 0) {
            throw new IllegalArgumentException("The child being replaced doesn't belong to this group");
        }
        this.mChildren.set(index, newChild);
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "current group is :" + this.getName());
        for (SvgNode node : this.mChildren) {
            node.dumpNode(indent + "  ");
        }
    }

    public SvgGroupNode findParent(SvgNode node) {
        for (SvgNode n : this.mChildren) {
            SvgGroupNode parent;
            if (n == node) {
                return this;
            }
            if (!n.isGroupNode() || (parent = ((SvgGroupNode)n).findParent(node)) == null) continue;
            return parent;
        }
        return null;
    }

    @Override
    public boolean isGroupNode() {
        return true;
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        for (SvgNode p : this.mChildren) {
            p.transformIfNeeded(rootTransform);
        }
    }

    @Override
    public void flatten(AffineTransform transform) {
        for (SvgNode n : this.mChildren) {
            this.mStackedTransform.setTransform(transform);
            this.mStackedTransform.concatenate(this.mLocalTransform);
            n.flatten(this.mStackedTransform);
        }
    }

    @Override
    public void writeXml(OutputStreamWriter writer, boolean inClipPath, String indent) throws IOException {
        for (SvgNode node : this.mChildren) {
            node.writeXml(writer, inClipPath, indent);
        }
    }

    @Override
    public void fillPresentationAttributes(String name, String value) {
        super.fillPresentationAttributes(name, value);
        for (SvgNode n : this.mChildren) {
            if (n.mVdAttributesMap.containsKey(name)) continue;
            n.fillPresentationAttributes(name, value);
        }
    }
}

