/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgColor;
import com.android.ide.common.vectordrawable.SvgTree;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class SvgNode {
    private static final Logger logger = Logger.getLogger(SvgNode.class.getSimpleName());
    protected static final String INDENT_UNIT = "  ";
    protected static final String CONTINUATION_INDENT = "    ";
    private static final String TRANSFORM_TAG = "transform";
    private static final String MATRIX_ATTRIBUTE = "matrix";
    private static final String TRANSLATE_ATTRIBUTE = "translate";
    private static final String ROTATE_ATTRIBUTE = "rotate";
    private static final String SCALE_ATTRIBUTE = "scale";
    private static final String SKEWX_ATTRIBUTE = "skewX";
    private static final String SKEWY_ATTRIBUTE = "skewY";
    protected final String mName;
    protected final SvgTree mSvgTree;
    protected final Element mDocumentElement;
    protected final Map<String, String> mVdAttributesMap = new HashMap<String, String>();
    protected AffineTransform mLocalTransform = new AffineTransform();
    protected AffineTransform mStackedTransform = new AffineTransform();

    SvgNode(SvgTree svgTree, Element element, String name) {
        this.mName = name;
        this.mSvgTree = svgTree;
        this.mDocumentElement = element;
        NamedNodeMap a = element.getAttributes();
        int len = a.getLength();
        for (int itemIndex = 0; itemIndex < len; ++itemIndex) {
            Node n = a.item(itemIndex);
            String nodeName = n.getNodeName();
            String nodeValue = n.getNodeValue();
            if (Svg2Vector.presentationMap.containsKey((Object)nodeName)) {
                this.fillPresentationAttributesInternal(nodeName, nodeValue);
            }
            if (!TRANSFORM_TAG.equals(nodeName)) continue;
            logger.log(Level.FINE, nodeName + " " + nodeValue);
            this.parseLocalTransform(nodeValue);
        }
    }

    protected void parseLocalTransform(String nodeValue) {
        nodeValue = nodeValue.replaceAll(",", " ");
        String[] matrices = nodeValue.split("[()]");
        for (int i = 0; i < matrices.length - 1; i += 2) {
            AffineTransform parsedTransform = SvgNode.parseOneTransform(matrices[i].trim(), matrices[i + 1].trim());
            if (parsedTransform == null) continue;
            this.mLocalTransform.concatenate(parsedTransform);
        }
    }

    private static AffineTransform parseOneTransform(String type, String data) {
        float[] numbers = SvgNode.getNumbers(data);
        if (numbers == null) {
            return null;
        }
        int numLength = numbers.length;
        AffineTransform parsedTransform = new AffineTransform();
        if (MATRIX_ATTRIBUTE.equalsIgnoreCase(type)) {
            if (numLength != 6) {
                return null;
            }
            parsedTransform.setTransform(numbers[0], numbers[1], numbers[2], numbers[3], numbers[4], numbers[5]);
        } else if (TRANSLATE_ATTRIBUTE.equalsIgnoreCase(type)) {
            if (numLength != 1 && numLength != 2) {
                return null;
            }
            parsedTransform.translate(numbers[0], numLength == 2 ? (double)numbers[1] : 0.0);
        } else if (SCALE_ATTRIBUTE.equalsIgnoreCase(type)) {
            if (numLength != 1 && numLength != 2) {
                return null;
            }
            parsedTransform.scale(numbers[0], numbers[numLength == 2 ? 1 : 0]);
        } else if (ROTATE_ATTRIBUTE.equalsIgnoreCase(type)) {
            if (numLength != 1 && numLength != 3) {
                return null;
            }
            parsedTransform.rotate(Math.toRadians(numbers[0]), numLength == 3 ? (double)numbers[1] : 0.0, numLength == 3 ? (double)numbers[2] : 0.0);
        } else if (SKEWX_ATTRIBUTE.equalsIgnoreCase(type)) {
            if (numLength != 1) {
                return null;
            }
            parsedTransform.shear(Math.tan(Math.toRadians(numbers[0])), 0.0);
        } else if (SKEWY_ATTRIBUTE.equalsIgnoreCase(type)) {
            if (numLength != 1) {
                return null;
            }
            parsedTransform.shear(0.0, Math.tan(Math.toRadians(numbers[0])));
        }
        return parsedTransform;
    }

    private static float[] getNumbers(String data) {
        String[] numbers = data.split("\\s+");
        int len = numbers.length;
        if (len == 0) {
            return null;
        }
        float[] results = new float[len];
        for (int i = 0; i < len; ++i) {
            results[i] = Float.parseFloat(numbers[i]);
        }
        return results;
    }

    protected SvgTree getTree() {
        return this.mSvgTree;
    }

    public String getName() {
        return this.mName;
    }

    public Element getDocumentElement() {
        return this.mDocumentElement;
    }

    public abstract void dumpNode(String var1);

    public abstract void writeXml(OutputStreamWriter var1, boolean var2, String var3) throws IOException;

    public abstract boolean isGroupNode();

    public abstract void transformIfNeeded(AffineTransform var1);

    private void fillPresentationAttributesInternal(String name, String value) {
        if (name.equals("fill-rule")) {
            if (value.equals("nonzero")) {
                value = "nonZero";
            } else if (value.equals("evenodd")) {
                value = "evenOdd";
            }
        }
        logger.log(Level.FINE, ">>>> PROP " + name + " = " + value);
        if (value.startsWith("url(") && !name.equals("fill") && !name.equals("stroke")) {
            this.logError("Unsupported URL value: " + value);
            return;
        }
        if (name.equals("stroke-width") && value.equals("0")) {
            this.mVdAttributesMap.remove("stroke");
        }
        this.mVdAttributesMap.put(name, value);
    }

    protected void fillPresentationAttributes(String name, String value) {
        this.fillPresentationAttributesInternal(name, value);
    }

    public void fillEmptyAttributes(Map<String, String> parentAttributesMap) {
        for (Map.Entry<String, String> entry : parentAttributesMap.entrySet()) {
            String key = entry.getKey();
            if (this.mVdAttributesMap.containsKey(key)) continue;
            this.mVdAttributesMap.put(key, entry.getValue());
        }
    }

    public abstract void flatten(AffineTransform var1);

    public void validate() {
    }

    public String getAttributeValue(String attribute) {
        return this.mDocumentElement.getAttribute(attribute);
    }

    public abstract SvgNode deepCopy();

    protected <T extends SvgNode> void copyFrom(T from) {
        this.fillEmptyAttributes(from.mVdAttributesMap);
        this.mLocalTransform = (AffineTransform)from.mLocalTransform.clone();
    }

    protected String colorSvg2Vd(String svgColor, String errorFallbackColor) {
        try {
            return SvgColor.colorSvg2Vd(svgColor);
        }
        catch (IllegalArgumentException e) {
            this.logError("Unsupported color format \"" + svgColor + "\"");
            return errorFallbackColor;
        }
    }

    protected void logError(String s) {
        this.mSvgTree.logError(s, this.mDocumentElement);
    }

    protected void logWarning(String s) {
        this.mSvgTree.logWarning(s, this.mDocumentElement);
    }
}

