/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.VectorDrawablesOptions;
import com.android.ide.common.gradle.model.IdeApiVersion;
import com.android.ide.common.gradle.model.IdeBaseConfig;
import com.android.ide.common.gradle.model.IdeSigningConfig;
import com.android.ide.common.gradle.model.IdeVectorDrawablesOptions;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public final class IdeProductFlavor
extends IdeBaseConfig
implements ProductFlavor {
    private static final long serialVersionUID = 3L;
    private final Map<String, String> myTestInstrumentationRunnerArguments;
    private final Collection<String> myResourceConfigurations;
    private final VectorDrawablesOptions myVectorDrawables;
    private final String myDimension;
    private final String myApplicationId;
    private final Integer myVersionCode;
    private final String myVersionName;
    private final ApiVersion myMinSdkVersion;
    private final ApiVersion myTargetSdkVersion;
    private final Integer myMaxSdkVersion;
    private final String myTestApplicationId;
    private final String myTestInstrumentationRunner;
    private final Boolean myTestFunctionalTest;
    private final Boolean myTestHandleProfiling;
    private final SigningConfig mySigningConfig;
    private final int myHashCode;

    public IdeProductFlavor(ProductFlavor flavor, ModelCache modelCache) {
        super((BaseConfig)flavor, modelCache);
        this.myTestInstrumentationRunnerArguments = ImmutableMap.copyOf((Map)flavor.getTestInstrumentationRunnerArguments());
        this.myResourceConfigurations = ImmutableList.copyOf((Collection)flavor.getResourceConfigurations());
        this.myVectorDrawables = IdeProductFlavor.copyVectorDrawables(flavor, modelCache);
        this.myDimension = flavor.getDimension();
        this.myApplicationId = flavor.getApplicationId();
        this.myVersionCode = flavor.getVersionCode();
        this.myVersionName = flavor.getVersionName();
        this.myMinSdkVersion = IdeProductFlavor.copy(modelCache, flavor.getMinSdkVersion());
        this.myTargetSdkVersion = IdeProductFlavor.copy(modelCache, flavor.getTargetSdkVersion());
        this.myMaxSdkVersion = flavor.getMaxSdkVersion();
        this.myTestApplicationId = flavor.getTestApplicationId();
        this.myTestInstrumentationRunner = flavor.getTestInstrumentationRunner();
        this.myTestFunctionalTest = flavor.getTestFunctionalTest();
        this.myTestHandleProfiling = flavor.getTestHandleProfiling();
        this.mySigningConfig = IdeProductFlavor.copy(modelCache, flavor.getSigningConfig());
        this.myHashCode = this.calculateHashCode();
    }

    private static VectorDrawablesOptions copyVectorDrawables(ProductFlavor flavor, ModelCache modelCache) {
        VectorDrawablesOptions vectorDrawables;
        try {
            vectorDrawables = flavor.getVectorDrawables();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        return modelCache.computeIfAbsent(vectorDrawables, options -> new IdeVectorDrawablesOptions((VectorDrawablesOptions)options, modelCache));
    }

    private static IdeApiVersion copy(ModelCache modelCache, ApiVersion apiVersion) {
        if (apiVersion != null) {
            return modelCache.computeIfAbsent(apiVersion, version -> new IdeApiVersion((ApiVersion)version, modelCache));
        }
        return null;
    }

    private static SigningConfig copy(ModelCache modelCache, SigningConfig signingConfig) {
        if (signingConfig != null) {
            return modelCache.computeIfAbsent(signingConfig, config -> new IdeSigningConfig((SigningConfig)config, modelCache));
        }
        return null;
    }

    public Map<String, String> getTestInstrumentationRunnerArguments() {
        return this.myTestInstrumentationRunnerArguments;
    }

    public Collection<String> getResourceConfigurations() {
        return this.myResourceConfigurations;
    }

    public VectorDrawablesOptions getVectorDrawables() {
        if (this.myVectorDrawables != null) {
            return this.myVectorDrawables;
        }
        throw new UnsupportedOperationException("Unsupported method: ProductFlavor.getVectorDrawables");
    }

    public String getDimension() {
        return this.myDimension;
    }

    public String getApplicationId() {
        return this.myApplicationId;
    }

    public Integer getVersionCode() {
        return this.myVersionCode;
    }

    public String getVersionName() {
        return this.myVersionName;
    }

    public ApiVersion getMinSdkVersion() {
        return this.myMinSdkVersion;
    }

    public ApiVersion getTargetSdkVersion() {
        return this.myTargetSdkVersion;
    }

    public Integer getMaxSdkVersion() {
        return this.myMaxSdkVersion;
    }

    public Integer getRenderscriptTargetApi() {
        throw new UnusedModelMethodException("getRenderscriptTargetApi");
    }

    public Boolean getRenderscriptSupportModeEnabled() {
        throw new UnusedModelMethodException("getRenderscriptSupportModeEnabled");
    }

    public Boolean getRenderscriptSupportModeBlasEnabled() {
        throw new UnusedModelMethodException("getRenderscriptSupportModeBlasEnabled");
    }

    public Boolean getRenderscriptNdkModeEnabled() {
        throw new UnusedModelMethodException("getRenderscriptNdkModeEnabled");
    }

    public String getTestApplicationId() {
        return this.myTestApplicationId;
    }

    public String getTestInstrumentationRunner() {
        return this.myTestInstrumentationRunner;
    }

    public Boolean getTestHandleProfiling() {
        return this.myTestHandleProfiling;
    }

    public Boolean getTestFunctionalTest() {
        return this.myTestFunctionalTest;
    }

    public SigningConfig getSigningConfig() {
        return this.mySigningConfig;
    }

    public Boolean getWearAppUnbundled() {
        throw new UnusedModelMethodException("getWearAppUnbundled");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeProductFlavor)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeProductFlavor flavor = (IdeProductFlavor)o;
        return flavor.canEqual(this) && Objects.equals(this.myTestInstrumentationRunnerArguments, flavor.myTestInstrumentationRunnerArguments) && Objects.equals(this.myResourceConfigurations, flavor.myResourceConfigurations) && Objects.equals(this.myVectorDrawables, flavor.myVectorDrawables) && Objects.equals(this.myDimension, flavor.myDimension) && Objects.equals(this.myApplicationId, flavor.myApplicationId) && Objects.equals(this.myVersionCode, flavor.myVersionCode) && Objects.equals(this.myVersionName, flavor.myVersionName) && Objects.equals(this.myMinSdkVersion, flavor.myMinSdkVersion) && Objects.equals(this.myTargetSdkVersion, flavor.myTargetSdkVersion) && Objects.equals(this.myMaxSdkVersion, flavor.myMaxSdkVersion) && Objects.equals(this.myTestApplicationId, flavor.myTestApplicationId) && Objects.equals(this.myTestInstrumentationRunner, flavor.myTestInstrumentationRunner) && Objects.equals(this.myTestFunctionalTest, flavor.myTestFunctionalTest) && Objects.equals(this.myTestHandleProfiling, flavor.myTestHandleProfiling) && Objects.equals(this.mySigningConfig, flavor.mySigningConfig);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof IdeProductFlavor;
    }

    @Override
    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myTestInstrumentationRunnerArguments, this.myResourceConfigurations, this.myVectorDrawables, this.myDimension, this.myApplicationId, this.myVersionCode, this.myVersionName, this.myMinSdkVersion, this.myTargetSdkVersion, this.myMaxSdkVersion, this.myTestApplicationId, this.myTestInstrumentationRunner, this.myTestFunctionalTest, this.myTestHandleProfiling, this.mySigningConfig);
    }

    @Override
    public String toString() {
        return "IdeProductFlavor{" + super.toString() + ", myTestInstrumentationRunnerArguments=" + this.myTestInstrumentationRunnerArguments + ", myResourceConfigurations=" + this.myResourceConfigurations + ", myVectorDrawables=" + this.myVectorDrawables + ", myDimension='" + this.myDimension + '\'' + ", myApplicationId='" + this.myApplicationId + '\'' + ", myVersionCode=" + this.myVersionCode + ", myVersionName='" + this.myVersionName + '\'' + ", myMinSdkVersion=" + this.myMinSdkVersion + ", myTargetSdkVersion=" + this.myTargetSdkVersion + ", myMaxSdkVersion=" + this.myMaxSdkVersion + ", myTestApplicationId='" + this.myTestApplicationId + '\'' + ", myTestInstrumentationRunner='" + this.myTestInstrumentationRunner + '\'' + ", myTestFunctionalTest=" + this.myTestFunctionalTest + ", myTestHandleProfiling=" + this.myTestHandleProfiling + ", mySigningConfig=" + this.mySigningConfig + "}";
    }
}

