/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AndroidBundle;
import com.android.builder.model.AndroidLibrary;
import com.android.ide.common.gradle.model.IdeAndroidBundle;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public final class IdeAndroidLibrary
extends IdeAndroidBundle
implements AndroidLibrary {
    private static final long serialVersionUID = 4L;
    private final Collection<File> myLocalJars;
    private final File myProguardRules;
    private final File myLintJar;
    private final File myPublicResources;
    private final File mySymbols;
    private final File myExternalAnnotations;
    private final int myHashCode;

    IdeAndroidLibrary() {
        this.myLocalJars = Collections.emptyList();
        this.myProguardRules = null;
        this.myLintJar = null;
        this.myPublicResources = null;
        this.mySymbols = null;
        this.myExternalAnnotations = null;
        this.myHashCode = 0;
    }

    public IdeAndroidLibrary(AndroidLibrary library, ModelCache modelCache) {
        super((AndroidBundle)library, modelCache);
        this.myLocalJars = ImmutableList.copyOf((Collection)library.getLocalJars());
        this.myProguardRules = library.getProguardRules();
        this.myLintJar = library.getLintJar();
        this.myPublicResources = library.getPublicResources();
        this.mySymbols = IdeModel.copyNewPropertyWithDefault(() -> library.getSymbolFile(), () -> new File(library.getPublicResources().getParentFile(), "R.txt"));
        this.myExternalAnnotations = library.getExternalAnnotations();
        this.myHashCode = this.calculateHashCode();
    }

    public Collection<File> getLocalJars() {
        return this.myLocalJars;
    }

    public File getJniFolder() {
        throw new UnusedModelMethodException("getJniFolder");
    }

    public File getAidlFolder() {
        throw new UnusedModelMethodException("getRenderscriptFolder");
    }

    public File getRenderscriptFolder() {
        throw new UnusedModelMethodException("getRenderscriptFolder");
    }

    public File getProguardRules() {
        return this.myProguardRules;
    }

    public File getLintJar() {
        return this.myLintJar;
    }

    public File getExternalAnnotations() {
        return this.myExternalAnnotations;
    }

    public File getPublicResources() {
        return this.myPublicResources;
    }

    public File getSymbolFile() {
        return this.mySymbols;
    }

    @Deprecated
    public boolean isOptional() {
        throw new UnusedModelMethodException("isOptional");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidLibrary)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeAndroidLibrary library = (IdeAndroidLibrary)o;
        return library.canEqual(this) && Objects.equals(this.myLocalJars, library.myLocalJars) && Objects.equals(this.myProguardRules, library.myProguardRules) && Objects.equals(this.myLintJar, library.myLintJar) && Objects.equals(this.myPublicResources, library.myPublicResources) && Objects.equals(this.mySymbols, library.mySymbols) && Objects.equals(this.myExternalAnnotations, library.myExternalAnnotations);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof IdeAndroidLibrary;
    }

    @Override
    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myLocalJars, this.myProguardRules, this.myLintJar, this.myPublicResources, this.mySymbols, this.myExternalAnnotations);
    }

    @Override
    public String toString() {
        return "IdeAndroidLibrary{" + super.toString() + ", myLocalJars=" + this.myLocalJars + ", myProguardRules=" + this.myProguardRules + ", myLintJar=" + this.myLintJar + ", myPublicResources=" + this.myPublicResources + ", mySymbols=" + this.mySymbols + ", myExternalAnnotations=" + this.myExternalAnnotations + "}";
    }
}

