/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceValuesXmlParseException;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.ResourceType;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"checkForResources", "", "text", "", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "parseChild", "element", "Lorg/w3c/dom/Element;", "parseResourceForInlineResources", "Lcom/android/ide/common/symbols/SymbolTable;", "xmlDocument", "Lorg/w3c/dom/Document;", "sdk-common"})
@JvmName(name="ResourceExtraXmlParser")
public final class ResourceExtraXmlParser {
    @NotNull
    public static final SymbolTable parseResourceForInlineResources(@NotNull Document xmlDocument, @NotNull IdProvider idProvider) {
        Intrinsics.checkParameterIsNotNull((Object)xmlDocument, (String)"xmlDocument");
        Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
        Element element = xmlDocument.getDocumentElement();
        if (element == null) {
            throw (Throwable)new ResourceValuesXmlParseException("XML document does not have a root element.");
        }
        Element root = element;
        SymbolTable.Builder builder = SymbolTable.Companion.builder();
        ResourceExtraXmlParser.parseChild(root, builder, idProvider);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final void parseChild(Element element, SymbolTable.Builder builder, IdProvider idProvider) {
        NamedNodeMap attrs = element.getAttributes();
        int n = 0;
        NamedNodeMap namedNodeMap = attrs;
        Intrinsics.checkExpressionValueIsNotNull((Object)namedNodeMap, (String)"attrs");
        int n2 = namedNodeMap.getLength();
        while (n < n2) {
            void i;
            Node attr;
            Node node = attr = attrs.item((int)i);
            if (node == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Attr");
            }
            ResourceExtraXmlParser.checkForResources(((Attr)node).getValue(), builder, idProvider);
            ++i;
        }
        for (Node current = element.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            ResourceExtraXmlParser.parseChild((Element)current, builder, idProvider);
        }
    }

    private static final void checkForResources(String text, SymbolTable.Builder builder, IdProvider idProvider) {
        if (text != null && StringsKt.startsWith$default((String)text, (String)"@+id/", (boolean)false, (int)2, null)) {
            String string = text;
            int n = "@+id/".length();
            int n2 = text.length();
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String name = string2;
            Symbol newSymbol = Symbol.Companion.createAndValidateSymbol$default(Symbol.Companion, ResourceType.ID, name, idProvider, false, 8, null);
            if (!builder.contains(newSymbol)) {
                builder.add(newSymbol);
            }
        }
    }
}

