/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceDirectoryParseException;
import com.android.ide.common.symbols.ResourceExtraXmlParser;
import com.android.ide.common.symbols.ResourceValuesXmlParseException;
import com.android.ide.common.symbols.ResourceValuesXmlParser;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import java.io.File;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a:\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001aB\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013\u001a6\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0007\u001a@\u0010\u001d\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u001e\u001a\u0012\u0012\b\u0012\u00060 j\u0002`!\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010\"\u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$\u00a8\u0006&"}, d2={"addIfNotExisting", "", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "symbol", "Lcom/android/ide/common/symbols/Symbol;", "getNameWithoutExtensions", "", "filename", "parseResourceDirectory", "resourceDirectory", "Ljava/io/File;", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "platformAttrSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "validation", "", "parseResourceFile", "maybeResourceFile", "folderResourceType", "Lcom/android/resources/ResourceFolderType;", "parseResourceSourceSetDirectory", "directory", "tablePackage", "shouldBeParsed", "directoryName", "parseAarZipEntry", "errorHandler", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "name", "content", "Lkotlin/Function0;", "Ljava/io/InputStream;", "sdk-common"})
@JvmName(name="ResourceDirectoryParser")
public final class ResourceDirectoryParser {
    @NotNull
    public static final SymbolTable parseResourceSourceSetDirectory(@NotNull File directory, @NotNull IdProvider idProvider, @Nullable SymbolTable platformAttrSymbols, @Nullable String tablePackage, boolean validation) {
        DocumentBuilder documentBuilder;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"!directory.isDirectory()", (Object[])new Object[0]);
        SymbolTable.Builder builder = SymbolTable.Companion.builder();
        Object[] objectArray = directory.listFiles();
        if (objectArray == null) {
            Intrinsics.throwNpe();
        }
        Object[] $this$sortedBy$iv = objectArray;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List resourceDirectories = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ResourceDirectoryParseException("Failed to instantiate DOM parser", e);
        }
        DocumentBuilder documentBuilder2 = documentBuilder;
        for (File resourceDirectory : resourceDirectories) {
            if (!resourceDirectory.isDirectory()) {
                throw new ResourceDirectoryParseException('\'' + resourceDirectory.getAbsolutePath() + "' is not a directory");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceDirectory, (String)"resourceDirectory");
            Intrinsics.checkExpressionValueIsNotNull((Object)documentBuilder2, (String)"documentBuilder");
            ResourceDirectoryParser.parseResourceDirectory(resourceDirectory, builder, idProvider, documentBuilder2, platformAttrSymbols, validation);
        }
        if (tablePackage != null) {
            builder.tablePackage(tablePackage);
        }
        return builder.build();
    }

    public static /* synthetic */ SymbolTable parseResourceSourceSetDirectory$default(File file, IdProvider idProvider, SymbolTable symbolTable, String string, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return ResourceDirectoryParser.parseResourceSourceSetDirectory(file, idProvider, symbolTable, string, bl);
    }

    private static final void parseResourceDirectory(File resourceDirectory, SymbolTable.Builder builder, IdProvider idProvider, DocumentBuilder documentBuilder, SymbolTable platformAttrSymbols, boolean validation) {
        boolean bl = resourceDirectory.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = resourceDirectory.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resourceDirectory.name");
        if (!ResourceDirectoryParser.shouldBeParsed(string)) {
            return;
        }
        String directoryName = resourceDirectory.getName();
        ResourceFolderType folderResourceType = ResourceFolderType.getFolderType((String)directoryName);
        Object[] objectArray = resourceDirectory.listFiles();
        if (objectArray == null) {
            Intrinsics.throwNpe();
        }
        Object[] $this$sortedBy$iv = objectArray;
        boolean $i$f$sortedBy = false;
        boolean bl5 = false;
        List resourceFiles = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        Iterable $this$forEach$iv = resourceFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl6 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            if (folderResourceType == null) {
                Intrinsics.throwNpe();
            }
            ResourceDirectoryParser.parseResourceFile(it, folderResourceType, builder, documentBuilder, platformAttrSymbols, idProvider, validation);
        }
    }

    public static final void parseResourceFile(@NotNull File maybeResourceFile, @NotNull ResourceFolderType folderResourceType, @NotNull SymbolTable.Builder builder, @NotNull DocumentBuilder documentBuilder, @Nullable SymbolTable platformAttrSymbols, @NotNull IdProvider idProvider, boolean validation) {
        Intrinsics.checkParameterIsNotNull((Object)maybeResourceFile, (String)"maybeResourceFile");
        Intrinsics.checkParameterIsNotNull((Object)folderResourceType, (String)"folderResourceType");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)documentBuilder, (String)"documentBuilder");
        Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
        if (maybeResourceFile.isDirectory()) {
            return;
        }
        if (!maybeResourceFile.isFile()) {
            throw new ResourceDirectoryParseException('\'' + maybeResourceFile.getAbsolutePath() + "' is not a file nor directory");
        }
        if (folderResourceType == ResourceFolderType.VALUES) {
            Document domTree = null;
            try {
                Document document = documentBuilder.parse(maybeResourceFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"documentBuilder.parse(maybeResourceFile)");
                domTree = document;
                SymbolTable parsedXml = ResourceValuesXmlParser.parseValuesResource(domTree, idProvider, platformAttrSymbols, validation);
                ImmutableCollection immutableCollection = parsedXml.getSymbols().values();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"parsedXml.symbols.values()");
                Iterable $this$forEach$iv = (Iterable)immutableCollection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Symbol s = (Symbol)element$iv;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)s, (String)"s");
                    ResourceDirectoryParser.addIfNotExisting(builder, s);
                }
            }
            catch (Exception e) {
                throw new ResourceDirectoryParseException("Failed to parse XML resource file '" + maybeResourceFile.getAbsolutePath() + '\'', e);
            }
        }
        if (validation) {
            try {
                FileResourceNameValidator.validate(maybeResourceFile, folderResourceType);
            }
            catch (MergingException e) {
                throw new ResourceDirectoryParseException(Intrinsics.stringPlus((String)"Failed file name validation for file ", (Object)maybeResourceFile.getAbsolutePath()), e);
            }
        }
        String fileName = maybeResourceFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileName, (String)"fileName");
        String symbolName = ResourceDirectoryParser.getNameWithoutExtensions(fileName);
        ResourceType resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderResourceType);
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceType, (String)"resourceType");
        ResourceDirectoryParser.addIfNotExisting(builder, Symbol.Companion.createSymbol$default(Symbol.Companion, resourceType, symbolName, idProvider, false, validation, 8, null));
        if (FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderResourceType) && SdkUtils.endsWithIgnoreCase((String)fileName, (String)".xml")) {
            try {
                Document domTree = documentBuilder.parse(maybeResourceFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)domTree, (String)"domTree");
                SymbolTable extraSymbols = ResourceExtraXmlParser.parseResourceForInlineResources(domTree, idProvider, validation);
                ImmutableCollection element$iv = extraSymbols.getSymbols().values();
                Intrinsics.checkExpressionValueIsNotNull((Object)element$iv, (String)"extraSymbols.symbols.values()");
                Iterable $this$forEach$iv = (Iterable)element$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Symbol s = (Symbol)element$iv2;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)s, (String)"s");
                    ResourceDirectoryParser.addIfNotExisting(builder, s);
                }
            }
            catch (Exception e) {
                throw new ResourceDirectoryParseException("Failed to parse XML file '" + maybeResourceFile.getAbsolutePath() + '\'', e);
            }
        }
    }

    public static /* synthetic */ void parseResourceFile$default(File file, ResourceFolderType resourceFolderType, SymbolTable.Builder builder, DocumentBuilder documentBuilder, SymbolTable symbolTable, IdProvider idProvider, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            idProvider = IdProvider.Companion.constant();
        }
        ResourceDirectoryParser.parseResourceFile(file, resourceFolderType, builder, documentBuilder, symbolTable, idProvider, bl);
    }

    public static final boolean shouldBeParsed(@NotNull String directoryName) {
        Intrinsics.checkParameterIsNotNull((Object)directoryName, (String)"directoryName");
        if (!StringsKt.contains$default((CharSequence)directoryName, (char)'-', (boolean)false, (int)2, null)) {
            return true;
        }
        char[] cArray = new char[]{'-'};
        List configs = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)directoryName, (char)'-', null, (int)2, null), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigFromQualifiers(configs.iterator());
        if (folderConfiguration == null) {
            return false;
        }
        FolderConfiguration folderConfiguration2 = folderConfiguration;
        FolderConfiguration config = folderConfiguration2;
        return config.getLocaleQualifier() == null;
    }

    public static final void parseAarZipEntry(@NotNull SymbolTable.Builder $this$parseAarZipEntry, @NotNull DocumentBuilder documentBuilder, @NotNull Function1<? super Exception, Unit> errorHandler, @NotNull String name, @NotNull Function0<? extends InputStream> content) {
        block16: {
            SymbolTable e4;
            Document element$iv2;
            ResourceFolderType folderResourceType;
            int lastSlashPosition;
            block15: {
                SymbolTable e22;
                Document document;
                Intrinsics.checkParameterIsNotNull((Object)$this$parseAarZipEntry, (String)"<this>");
                Intrinsics.checkParameterIsNotNull((Object)documentBuilder, (String)"documentBuilder");
                Intrinsics.checkParameterIsNotNull(errorHandler, (String)"errorHandler");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull(content, (String)"content");
                if (!StringsKt.startsWith$default((String)name, (String)"res/", (boolean)false, (int)2, null)) {
                    return;
                }
                int firstSlashPosition = StringsKt.indexOf$default((CharSequence)name, (char)'/', (int)0, (boolean)false, (int)6, null);
                lastSlashPosition = StringsKt.lastIndexOf$default((CharSequence)name, (char)'/', (int)0, (boolean)false, (int)6, null);
                if (lastSlashPosition == firstSlashPosition) {
                    errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + "': Invalid resource path."));
                    return;
                }
                String string = name;
                int n = firstSlashPosition + 1;
                boolean bl = false;
                String string2 = string.substring(n, lastSlashPosition);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String directoryName = string2;
                if (!ResourceDirectoryParser.shouldBeParsed(directoryName)) {
                    return;
                }
                ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)directoryName);
                if (resourceFolderType == null) {
                    SymbolTable.Builder builder = $this$parseAarZipEntry;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    SymbolTable.Builder $this$parseAarZipEntry_u24lambda_u2d5 = builder;
                    boolean bl4 = false;
                    errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + "': Invalid resource directory name '" + directoryName + '\''));
                    return;
                }
                folderResourceType = resourceFolderType;
                if (folderResourceType != ResourceFolderType.VALUES) break block15;
                try {
                    document = documentBuilder.parse((InputStream)content.invoke());
                    Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"{\n            documentBuilder.parse(content())\n        }");
                }
                catch (SAXParseException e22) {
                    errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + '\'', e22));
                    return;
                }
                Document domTree = document;
                try {
                    e22 = ResourceValuesXmlParser.parseValuesResource$default(domTree, IdProvider.Companion.constant(), null, false, 8, null);
                }
                catch (ResourceValuesXmlParseException e3) {
                    errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + '\'', e3));
                    return;
                }
                SymbolTable parsedXml = e22;
                e22 = parsedXml.getSymbols().values();
                Intrinsics.checkExpressionValueIsNotNull((Object)e22, (String)"parsedXml.symbols.values()");
                Iterable $this$forEach$iv = (Iterable)((Object)e22);
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Symbol s = (Symbol)element$iv2;
                    boolean bl5 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)s, (String)"s");
                    ResourceDirectoryParser.addIfNotExisting($this$parseAarZipEntry, s);
                }
                break block16;
            }
            String parsedXml = name;
            int $this$forEach$iv = lastSlashPosition + 1;
            boolean $i$f$forEach = false;
            String string = parsedXml.substring($this$forEach$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            String fileName = string;
            String error = FileResourceNameValidator.getErrorTextForFileResource(fileName, folderResourceType);
            if (error != null) {
                errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + "': " + error));
                return;
            }
            String symbolName = ResourceDirectoryParser.getNameWithoutExtensions(fileName);
            ResourceType resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderResourceType);
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceType, (String)"resourceType");
            ResourceDirectoryParser.addIfNotExisting($this$parseAarZipEntry, Symbol.Companion.createSymbol$default(Symbol.Companion, resourceType, symbolName, IdProvider.Companion.constant(), false, false, 24, null));
            if (!FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderResourceType) || !SdkUtils.endsWithIgnoreCase((String)fileName, (String)".xml")) break block16;
            try {
                element$iv2 = documentBuilder.parse((InputStream)content.invoke());
                Intrinsics.checkExpressionValueIsNotNull((Object)element$iv2, (String)"{\n                documentBuilder.parse(content())\n            }");
            }
            catch (SAXParseException e4) {
                errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + '\'', e4));
                return;
            }
            Document domTree = element$iv2;
            try {
                e4 = ResourceExtraXmlParser.parseResourceForInlineResources$default(domTree, IdProvider.Companion.constant(), false, 4, null);
            }
            catch (ResourceValuesXmlParseException e5) {
                errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + '\'', e5));
                return;
            }
            SymbolTable extraSymbols = e4;
            e4 = extraSymbols.getSymbols().values();
            Intrinsics.checkExpressionValueIsNotNull((Object)e4, (String)"extraSymbols.symbols.values()");
            Iterable $this$forEach$iv2 = (Iterable)((Object)e4);
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                Symbol s = (Symbol)element$iv3;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)s, (String)"s");
                ResourceDirectoryParser.addIfNotExisting($this$parseAarZipEntry, s);
            }
        }
    }

    private static final String getNameWithoutExtensions(String filename) {
        String string;
        int dotIndex = StringsKt.indexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex > 0) {
            String string2 = filename;
            int n = 0;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, dotIndex);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = filename;
        }
        return string;
    }

    private static final void addIfNotExisting(SymbolTable.Builder builder, Symbol symbol) {
        if (!builder.contains(symbol)) {
            builder.add(symbol);
        }
    }
}

