/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.xml;

import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.resources.ResourceFolderType;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlPrettyPrinter {
    private final XmlFormatStyle mStyle;
    private final XmlFormatPreferences mPrefs;
    private Node mStartNode;
    private Node mEndNode;
    private boolean mInRange;
    private StringBuilder mOut;
    private String mIndentString;
    private String mLineSeparator;
    private boolean mOpenTagOnly;
    private String[] mIndentationLevels;
    private boolean mEndWithNewline;

    public XmlPrettyPrinter(XmlFormatPreferences prefs, XmlFormatStyle style, String lineSeparator) {
        this.mPrefs = prefs;
        this.mStyle = style;
        if (lineSeparator == null) {
            lineSeparator = System.lineSeparator();
        }
        this.mLineSeparator = lineSeparator;
    }

    public XmlPrettyPrinter setEndWithNewline(boolean endWithNewline) {
        this.mEndWithNewline = endWithNewline;
        return this;
    }

    public void setIndentationLevels(String[] indentationLevels) {
        this.mIndentationLevels = indentationLevels;
    }

    private String getLineSeparator() {
        return this.mLineSeparator;
    }

    public static String prettyPrint(String xml, XmlFormatPreferences prefs, XmlFormatStyle style, String lineSeparator) {
        Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
        if (document != null) {
            XmlPrettyPrinter printer = new XmlPrettyPrinter(prefs, style, lineSeparator);
            printer.setEndWithNewline(xml.endsWith(printer.getLineSeparator()));
            StringBuilder sb = new StringBuilder(3 * xml.length() / 2);
            printer.prettyPrint(-1, document, null, null, sb, false);
            return sb.toString();
        }
        return xml;
    }

    @Deprecated
    public static String prettyPrint(Node node, XmlFormatPreferences prefs, XmlFormatStyle style, String lineSeparator) {
        return XmlPrettyPrinter.prettyPrint(node, prefs, style, lineSeparator, false);
    }

    public static String prettyPrint(Node node, XmlFormatPreferences prefs, XmlFormatStyle style, String lineSeparator, boolean endWithNewline) {
        XmlPrettyPrinter printer = new XmlPrettyPrinter(prefs, style, lineSeparator);
        printer.setEndWithNewline(endWithNewline);
        StringBuilder sb = new StringBuilder(1000);
        printer.prettyPrint(-1, node, null, null, sb, false);
        Object xml = sb.toString();
        if (node.getNodeType() == 9 && !((String)xml).startsWith("<?")) {
            xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + (String)xml;
        }
        return xml;
    }

    @Deprecated
    public static String prettyPrint(Node node) {
        return XmlPrettyPrinter.prettyPrint(node, false);
    }

    public static String prettyPrint(Node node, boolean endWithNewline) {
        return XmlPrettyPrinter.prettyPrint(node, XmlFormatPreferences.defaults(), XmlFormatStyle.get(node), System.lineSeparator(), endWithNewline);
    }

    public void prettyPrint(int rootDepth, Node root2, Node startNode, Node endNode, StringBuilder out, boolean openTagOnly) {
        if (startNode == null) {
            startNode = root2;
        }
        if (endNode == null) {
            endNode = root2;
        }
        assert (!openTagOnly || startNode == endNode);
        this.mStartNode = startNode;
        this.mOpenTagOnly = openTagOnly;
        this.mEndNode = endNode;
        this.mOut = out;
        this.mInRange = false;
        this.mIndentString = this.mPrefs.getOneIndentUnit();
        this.visitNode(rootDepth, root2);
        if (this.mEndWithNewline && !this.endsWithLineSeparator()) {
            this.mOut.append(this.mLineSeparator);
        }
    }

    private void visitNode(int depth, Node node) {
        if (node == this.mStartNode) {
            this.mInRange = true;
        }
        if (this.mInRange) {
            this.visitBeforeChildren(depth, node);
            if (this.mOpenTagOnly && this.mStartNode == node) {
                this.mInRange = false;
                return;
            }
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i2 = 0; i2 < n; ++i2) {
            Node child = children.item(i2);
            this.visitNode(depth + 1, child);
        }
        if (this.mInRange) {
            this.visitAfterChildren(depth, node);
        }
        if (node == this.mEndNode) {
            this.mInRange = false;
        }
    }

    private void visitBeforeChildren(int depth, Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 9: 
            case 11: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.printOpenElementTag(depth, node);
                break;
            }
            case 3: {
                this.printText(node);
                break;
            }
            case 4: {
                this.printCharacterData(node);
                break;
            }
            case 7: {
                this.printProcessingInstruction(node);
                break;
            }
            case 8: {
                this.printComment(depth, node);
                break;
            }
            case 10: {
                this.printDocType(node);
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                break;
            }
            default: {
                assert (false) : type;
                break;
            }
        }
    }

    private void visitAfterChildren(int depth, Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 2: {
                break;
            }
            case 1: {
                this.printCloseElementTag(depth, node);
            }
        }
    }

    private void printProcessingInstruction(Node node) {
        this.mOut.append("<?xml ");
        this.mOut.append(node.getNodeValue().trim());
        this.mOut.append('?').append('>').append(this.mLineSeparator);
    }

    protected String getSource(Node node) {
        return null;
    }

    private void printDocType(Node node) {
        String content = this.getSource(node);
        if (content != null) {
            this.mOut.append(content);
            this.mOut.append(this.mLineSeparator);
        }
    }

    private void printCharacterData(Node node) {
        boolean separateLine;
        String nodeValue = node.getNodeValue();
        boolean bl = separateLine = nodeValue.indexOf(10) != -1;
        if (separateLine && !this.endsWithLineSeparator()) {
            this.mOut.append(this.mLineSeparator);
        }
        this.mOut.append("<![CDATA[");
        this.mOut.append(nodeValue);
        this.mOut.append("]]>");
        if (separateLine) {
            this.mOut.append(this.mLineSeparator);
        }
    }

    private void printText(Node node) {
        String trimmed;
        boolean escape = true;
        Object text = node.getNodeValue();
        String source = this.getSource(node);
        if (source != null) {
            text = source;
            escape = false;
        }
        if (!(trimmed = ((String)text).trim()).isEmpty()) {
            char c;
            int lastPrefixNewline = -1;
            int n = ((String)text).length();
            for (int i2 = 0; i2 < n; ++i2) {
                c = ((String)text).charAt(i2);
                if (c == '\n') {
                    lastPrefixNewline = i2;
                    continue;
                }
                if (!Character.isWhitespace(c)) break;
            }
            int firstSuffixNewline = -1;
            for (int i3 = ((String)text).length() - 1; i3 >= 0; --i3) {
                c = ((String)text).charAt(i3);
                if (c == '\n') {
                    firstSuffixNewline = i3;
                    continue;
                }
                if (!Character.isWhitespace(c)) break;
            }
            if (lastPrefixNewline != -1 || firstSuffixNewline != -1) {
                boolean stripSuffix;
                if (firstSuffixNewline == -1) {
                    firstSuffixNewline = ((String)text).length();
                    stripSuffix = false;
                } else {
                    stripSuffix = true;
                }
                int stripFrom = lastPrefixNewline + 1;
                if (firstSuffixNewline >= stripFrom) {
                    Node right;
                    Node left;
                    text = ((String)text).substring(stripFrom, firstSuffixNewline);
                    if (lastPrefixNewline != -1 && this.isMarkupNode(left = node.getPreviousSibling())) {
                        text = " " + (String)text;
                    }
                    if (stripSuffix && this.isMarkupNode(right = node.getNextSibling())) {
                        text = (String)text + " ";
                    }
                }
            }
            if (escape) {
                XmlUtils.appendXmlTextValue((StringBuilder)this.mOut, (String)text);
            } else {
                this.mOut.append((String)text);
            }
            if (this.mStyle != XmlFormatStyle.RESOURCE) {
                this.mOut.append(this.mLineSeparator);
            }
        } else {
            Node left = node.getPreviousSibling();
            Node right = node.getNextSibling();
            if (this.isMarkupNode(left) && this.isMarkupNode(right)) {
                this.mOut.append(' ');
            }
        }
    }

    private boolean isMarkupNode(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() == 1) {
            return this.isMarkupElement((Element)node);
        }
        return node.getNodeType() == 4;
    }

    private void printComment(int depth, Node node) {
        char c;
        int i2;
        String comment = node.getNodeValue();
        boolean multiLine = comment.indexOf(10) != -1;
        String trimmed = comment.trim();
        boolean isSuffixComment = false;
        if (!multiLine) {
            Node previous = node.getPreviousSibling();
            isSuffixComment = true;
            if (previous == null && node.getParentNode().getNodeType() == 9) {
                isSuffixComment = false;
            }
            while (previous != null) {
                short type = previous.getNodeType();
                if (type == 8) {
                    isSuffixComment = false;
                    break;
                }
                if (type != 3) break;
                if (previous.getNodeValue().indexOf(10) != -1) {
                    isSuffixComment = false;
                    break;
                }
                previous = previous.getPreviousSibling();
            }
            if (isSuffixComment) {
                if (this.endsWithLineSeparator()) {
                    this.removeLastLineSeparator();
                }
                this.mOut.append(' ');
            }
        }
        if (!this.mPrefs.removeEmptyLines && !isSuffixComment) {
            Node curr = node.getPreviousSibling();
            if (curr == null) {
                if (this.mOut.length() > 0 && !this.endsWithLineSeparator()) {
                    this.mOut.append(this.mLineSeparator);
                }
            } else if (curr.getNodeType() == 3) {
                String text = curr.getNodeValue();
                int newLines = 0;
                for (i2 = text.length() - 1; i2 >= 0 && Character.isWhitespace(c = text.charAt(i2)) && (c != '\n' || ++newLines != 2); --i2) {
                }
                if (newLines >= 2) {
                    this.mOut.append(this.mLineSeparator);
                } else if (text.trim().isEmpty() && curr.getPreviousSibling() == null) {
                    this.mOut.append(this.mLineSeparator);
                }
            }
        }
        if (!multiLine) {
            if (!isSuffixComment) {
                this.indent(depth);
            }
            this.mOut.append("<!--").append(' ');
            this.mOut.append(trimmed);
            this.mOut.append(' ').append("-->");
            this.mOut.append(this.mLineSeparator);
        } else {
            int index;
            int end = comment.length();
            int recentNewline = -1;
            for (index = 0; index < end; ++index) {
                char c2 = comment.charAt(index);
                if (c2 == '\n') {
                    recentNewline = index;
                }
                if (!Character.isWhitespace(c2)) break;
            }
            int start = recentNewline + 1;
            recentNewline = -1;
            for (index = end - 1; index > start; --index) {
                c = comment.charAt(index);
                if (c == '\n') {
                    recentNewline = index;
                }
                if (!Character.isWhitespace(c)) break;
            }
            int n = end = recentNewline == -1 ? index + 1 : recentNewline;
            if (start >= end) {
                if (!isSuffixComment) {
                    this.indent(depth);
                }
                this.mOut.append("<!--").append(' ').append("-->");
                this.mOut.append(this.mLineSeparator);
                return;
            }
            trimmed = comment.substring(start, end);
            boolean bl = multiLine = trimmed.indexOf(10) != -1;
            if (multiLine) {
                Node previous;
                this.indent(depth);
                this.mOut.append("<!--");
                this.mOut.append(this.mLineSeparator);
                boolean startsWithNewline = false;
                for (int i3 = 0; i3 < start; ++i3) {
                    if (comment.charAt(i3) != '\n') continue;
                    startsWithNewline = true;
                    break;
                }
                if (!startsWithNewline && (previous = node.getPreviousSibling()) != null && previous.getNodeType() == 3) {
                    int i4;
                    char c3;
                    String prevText = previous.getNodeValue();
                    int indentation = "<!--".length();
                    for (int i5 = prevText.length() - 1; i5 >= 0 && (c3 = prevText.charAt(i5)) != '\n'; --i5) {
                        indentation += c3 == '\t' ? this.mPrefs.getTabWidth() : 1;
                    }
                    int minIndent = Integer.MAX_VALUE;
                    String[] lines = trimmed.split("\n");
                    block6: for (i4 = 1; i4 < lines.length; ++i4) {
                        int indent = 0;
                        String line = lines[i4];
                        for (int j = 0; j < line.length(); ++j) {
                            char c4 = line.charAt(j);
                            if (!Character.isWhitespace(c4)) {
                                if (indent >= minIndent) continue block6;
                                minIndent = indent;
                                continue block6;
                            }
                            indent += c4 == '\t' ? this.mPrefs.getTabWidth() : 1;
                        }
                    }
                    if (minIndent < indentation) {
                        char c5;
                        indentation = minIndent;
                        String line = lines[0];
                        for (int j = 0; j < line.length() && Character.isWhitespace(c5 = line.charAt(j)); ++j) {
                            indentation -= c5 == '\t' ? this.mPrefs.getTabWidth() : 1;
                        }
                    }
                    for (i4 = 0; i4 < indentation; ++i4) {
                        this.mOut.append(' ');
                    }
                    if (indentation < 0) {
                        boolean prefixIsSpace = true;
                        for (int i6 = 0; i6 < -indentation && i6 < trimmed.length(); ++i6) {
                            if (Character.isWhitespace(trimmed.charAt(i6))) continue;
                            prefixIsSpace = false;
                            break;
                        }
                        if (prefixIsSpace) {
                            trimmed = trimmed.substring(-indentation);
                        }
                    }
                }
                if (!this.mLineSeparator.equals("\n")) {
                    trimmed = trimmed.replace("\n", this.mLineSeparator);
                }
                this.mOut.append(trimmed);
                this.mOut.append(this.mLineSeparator);
                this.indent(depth);
                this.mOut.append("-->");
                this.mOut.append(this.mLineSeparator);
            } else {
                this.mOut.append("<!--").append(' ');
                this.mOut.append(trimmed);
                this.mOut.append(' ').append("-->");
                this.mOut.append(this.mLineSeparator);
            }
        }
        Node next = node.getNextSibling();
        if (!this.mPrefs.removeEmptyLines && next != null && next.getNodeType() == 3) {
            String text = next.getNodeValue();
            int newLinesBeforeText = 0;
            int n = text.length();
            for (i2 = 0; i2 < n; ++i2) {
                char c6 = text.charAt(i2);
                if (c6 == '\n') {
                    if (++newLinesBeforeText != 2) continue;
                    this.mOut.append(this.mLineSeparator);
                    break;
                }
                if (!Character.isWhitespace(c6)) break;
            }
        }
    }

    private boolean endsWithLineSeparator() {
        int separatorLength = this.mLineSeparator.length();
        if (this.mOut.length() >= separatorLength) {
            int i2 = 0;
            int j = this.mOut.length() - separatorLength;
            while (i2 < separatorLength) {
                if (this.mOut.charAt(j) != this.mLineSeparator.charAt(i2)) {
                    return false;
                }
                ++i2;
                ++j;
            }
        }
        return true;
    }

    private void removeLastLineSeparator() {
        int newLength = this.mOut.length() - this.mLineSeparator.length();
        if (newLength >= 0) {
            this.mOut.setLength(newLength);
        }
    }

    private void printOpenElementTag(int depth, Node node) {
        Element element = (Element)node;
        if (this.newlineBeforeElementOpen(element, depth)) {
            this.mOut.append(this.mLineSeparator);
        }
        if (this.indentBeforeElementOpen(element, depth)) {
            this.indent(depth);
        }
        this.mOut.append('<').append(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        int attributeCount = attributes.getLength();
        if (attributeCount > 0) {
            boolean indentNextAttribute;
            boolean singleLine;
            ArrayList<Attr> attributeList = new ArrayList<Attr>();
            for (int i2 = 0; i2 < attributeCount; ++i2) {
                attributeList.add((Attr)attributes.item(i2));
            }
            Comparator<Attr> comparator = this.mPrefs.getAttributeComparator();
            if (comparator != null) {
                Collections.sort(attributeList, comparator);
            }
            boolean bl = singleLine = this.mPrefs.oneAttributeOnFirstLine && attributeCount == 1 || this.mStyle == XmlFormatStyle.RESOURCE;
            if (singleLine || depth == 0 && "xmlns".equals(((Attr)attributeList.get(0)).getPrefix())) {
                this.mOut.append(' ');
                indentNextAttribute = false;
            } else {
                this.mOut.append(this.mLineSeparator);
                indentNextAttribute = true;
            }
            Attr last = (Attr)attributeList.get(attributeCount - 1);
            for (Attr attribute : attributeList) {
                if (indentNextAttribute) {
                    this.indent(depth + 1);
                }
                this.mOut.append(attribute.getName());
                this.mOut.append('=').append('\"');
                XmlUtils.appendXmlAttributeValue((StringBuilder)this.mOut, (String)attribute.getValue());
                this.mOut.append('\"');
                if (attribute == last) continue;
                this.mOut.append(singleLine ? " " : this.mLineSeparator);
                indentNextAttribute = !singleLine;
            }
        }
        boolean isClosed = this.isEmptyTag(element);
        if (this.mPrefs.spaceBeforeClose && (this.mStyle != XmlFormatStyle.RESOURCE || isClosed) && !"item".equals(element.getTagName()) && (isClosed || element.getAttributes().getLength() > 0)) {
            this.mOut.append(' ');
        }
        if (isClosed) {
            this.mOut.append('/');
        }
        this.mOut.append('>');
        if (this.newlineAfterElementOpen(element, depth, isClosed)) {
            this.mOut.append(this.mLineSeparator);
        }
    }

    private void printCloseElementTag(int depth, Node node) {
        Element element = (Element)node;
        if (this.isEmptyTag(element)) {
            return;
        }
        if (this.newlineBeforeElementClose(element, depth)) {
            this.mOut.append(this.mLineSeparator);
        }
        if (this.indentBeforeElementClose(element, depth)) {
            this.indent(depth);
        }
        this.mOut.append('<').append('/');
        this.mOut.append(node.getNodeName());
        this.mOut.append('>');
        if (this.newlineAfterElementClose(element, depth)) {
            this.mOut.append(this.mLineSeparator);
        }
    }

    private boolean newlineBeforeElementOpen(Element element, int depth) {
        if (this.hasBlankLineAbove()) {
            return false;
        }
        if (this.mPrefs.removeEmptyLines || depth <= 0) {
            return false;
        }
        if (this.isMarkupElement(element)) {
            return false;
        }
        if (this.mStyle == XmlFormatStyle.LAYOUT) {
            return true;
        }
        if (this.mStyle == XmlFormatStyle.MANIFEST || this.mStyle == XmlFormatStyle.RESOURCE || this.mStyle == XmlFormatStyle.FILE) {
            Node curr;
            if ("style".equals(element.getTagName()) && (curr == null || curr.getNodeType() == 1 || curr.getNodeType() == 3 && curr.getNodeValue().trim().isEmpty() && (curr.getPreviousSibling() == null || curr.getPreviousSibling().getNodeType() == 1))) {
                return true;
            }
            for (curr = element.getPreviousSibling(); curr != null; curr = curr.getPreviousSibling()) {
                String text;
                short nodeType = curr.getNodeType();
                if (nodeType == 1) {
                    Element sibling = (Element)curr;
                    if (element.getTagName().equals(sibling.getTagName())) break;
                    return true;
                }
                if (nodeType != 3 || !(text = curr.getNodeValue()).trim().isEmpty()) break;
            }
            return curr == null && depth <= 1;
        }
        return false;
    }

    private boolean indentBeforeElementOpen(Element element, int depth) {
        if (this.isMarkupElement(element)) {
            return false;
        }
        return element.getParentNode().getNodeType() != 1 || !this.keepElementAsSingleLine(depth - 1, (Element)element.getParentNode());
    }

    private boolean indentBeforeElementClose(Element element, int depth) {
        char lastDelimiterChar;
        if (this.isMarkupElement(element)) {
            return false;
        }
        char lastOutChar = this.mOut.charAt(this.mOut.length() - 1);
        return lastOutChar == (lastDelimiterChar = this.mLineSeparator.charAt(this.mLineSeparator.length() - 1));
    }

    private boolean newlineAfterElementOpen(Element element, int depth, boolean isClosed) {
        if (this.hasBlankLineAbove()) {
            return false;
        }
        if (this.isMarkupElement(element)) {
            return false;
        }
        return isClosed || !this.keepElementAsSingleLine(depth, element);
    }

    private boolean newlineBeforeElementClose(Element element, int depth) {
        if (this.hasBlankLineAbove()) {
            return false;
        }
        if (this.isMarkupElement(element)) {
            return false;
        }
        return depth == 0 && !this.mPrefs.removeEmptyLines;
    }

    private boolean hasBlankLineAbove() {
        if (this.mOut.length() < 2 * this.mLineSeparator.length()) {
            return false;
        }
        return SdkUtils.endsWith((CharSequence)this.mOut, (CharSequence)this.mLineSeparator) && SdkUtils.endsWith((CharSequence)this.mOut, (int)(this.mOut.length() - this.mLineSeparator.length()), (CharSequence)this.mLineSeparator);
    }

    private boolean newlineAfterElementClose(Element element, int depth) {
        if (this.hasBlankLineAbove()) {
            return false;
        }
        if (this.isMarkupElement(element)) {
            return false;
        }
        return element.getParentNode().getNodeType() == 1 && !this.keepElementAsSingleLine(depth - 1, (Element)element.getParentNode());
    }

    private boolean isMarkupElement(Element element) {
        if (this.mStyle != XmlFormatStyle.RESOURCE) {
            return false;
        }
        for (Node curr = element.getParentNode(); curr != null; curr = curr.getParentNode()) {
            if (!"string".equals(curr.getNodeName())) continue;
            return true;
        }
        return false;
    }

    private boolean isSingleLineTag(Element element) {
        String tag = element.getTagName();
        return tag.equals("item") && this.mStyle == XmlFormatStyle.RESOURCE || tag.equals("string") || tag.equals("dimen") || tag.equals("color");
    }

    private boolean keepElementAsSingleLine(int depth, Element element) {
        if (depth == 0) {
            return false;
        }
        return this.isSingleLineTag(element) || this.mStyle == XmlFormatStyle.RESOURCE && !XmlUtils.hasElementChildren((Node)element);
    }

    private void indent(int depth) {
        int i2 = 0;
        if (this.mIndentationLevels != null) {
            for (int j = Math.min(depth, this.mIndentationLevels.length - 1); j >= 0; --j) {
                String indent = this.mIndentationLevels[j];
                if (indent == null) continue;
                this.mOut.append(indent);
                i2 = j;
                break;
            }
        }
        while (i2 < depth) {
            this.mOut.append(this.mIndentString);
            ++i2;
        }
    }

    protected boolean isEmptyTag(Element element) {
        if (element.getFirstChild() != null) {
            return false;
        }
        String tag = element.getTagName();
        return !"string".equals(tag);
    }

    private static void printUsage() throws ExitWithErrorStatusException {
        System.out.println("Usage: " + XmlPrettyPrinter.class.getSimpleName() + " <options>... <files or directories...>");
        System.out.println("OPTIONS:");
        System.out.println("--stdout");
        System.out.println("--removeEmptyLines");
        System.out.println("--noAttributeOnFirstLine");
        System.out.println("--noSpaceBeforeClose");
        throw new ExitWithErrorStatusException();
    }

    public static void main(String[] args) {
        try {
            XmlPrettyPrinter.mainThrowOnFailure(args);
        }
        catch (ExitWithErrorStatusException e) {
            System.exit(1);
        }
        System.exit(0);
    }

    @VisibleForTesting
    static void mainThrowOnFailure(String[] args) throws ExitWithErrorStatusException {
        if (args.length == 0) {
            XmlPrettyPrinter.printUsage();
        }
        ArrayList files = Lists.newArrayList();
        XmlFormatPreferences prefs = XmlFormatPreferences.defaults();
        boolean stdout = false;
        for (String arg : args) {
            if (arg.startsWith("--")) {
                if ("--stdout".equals(arg)) {
                    stdout = true;
                    continue;
                }
                if ("--removeEmptyLines".equals(arg)) {
                    prefs.removeEmptyLines = true;
                    continue;
                }
                if ("--noAttributeOnFirstLine".equals(arg)) {
                    prefs.oneAttributeOnFirstLine = false;
                    continue;
                }
                if ("--noSpaceBeforeClose".equals(arg)) {
                    prefs.spaceBeforeClose = false;
                    continue;
                }
                System.err.println("Unknown flag " + arg);
                XmlPrettyPrinter.printUsage();
                continue;
            }
            File file = new File(arg).getAbsoluteFile();
            if (!file.exists()) {
                System.err.println("Can't find file " + file);
                throw new ExitWithErrorStatusException();
            }
            files.add(file);
        }
        for (File file : files) {
            XmlPrettyPrinter.formatFile(prefs, file, stdout);
        }
    }

    private static void formatFile(XmlFormatPreferences prefs, File file, boolean stdout) throws ExitWithErrorStatusException {
        block14: {
            block13: {
                if (!file.isDirectory()) break block13;
                File[] files = file.listFiles();
                if (files == null) break block14;
                for (File child : files) {
                    XmlPrettyPrinter.formatFile(prefs, child, stdout);
                }
                break block14;
            }
            if (file.isFile() && SdkUtils.endsWithIgnoreCase((String)file.getName(), (String)".xml")) {
                XmlFormatStyle style = null;
                if (file.getName().equals("AndroidManifest.xml")) {
                    style = XmlFormatStyle.MANIFEST;
                } else {
                    File parent = file.getParentFile();
                    if (parent != null) {
                        String parentName = parent.getName();
                        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentName);
                        if (folderType == ResourceFolderType.LAYOUT) {
                            style = XmlFormatStyle.LAYOUT;
                        } else if (folderType == ResourceFolderType.VALUES) {
                            style = XmlFormatStyle.RESOURCE;
                        }
                    }
                }
                try {
                    String xml = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
                    Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                    if (document == null) {
                        System.err.println("Could not parse " + file);
                        throw new ExitWithErrorStatusException();
                    }
                    if (style == null) {
                        style = XmlFormatStyle.get(document);
                    }
                    boolean endWithNewline = xml.endsWith("\n");
                    int firstNewLine = xml.indexOf(10);
                    String lineSeparator = firstNewLine > 0 && xml.charAt(firstNewLine - 1) == '\r' ? "\r\n" : "\n";
                    String formatted = XmlPrettyPrinter.prettyPrint(document, prefs, style, lineSeparator, endWithNewline);
                    if (stdout) {
                        System.out.println(formatted);
                    }
                    Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)formatted);
                }
                catch (IOException e) {
                    System.err.println("Could not read " + file);
                    throw new ExitWithErrorStatusException();
                }
            }
        }
    }

    @VisibleForTesting
    static final class ExitWithErrorStatusException
    extends Exception {
        ExitWithErrorStatusException() {
        }
    }
}

