/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.gradle.VersionRange;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.ide.common.repository.NetworkCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 /2\u00020\u0001:\u0003./0B1\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00142\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001aJ*\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00142\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\bJ:\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u001d2\b\b\u0002\u0010\u001c\u001a\u00020\bJ2\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\bJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010\u0010\u001a\u00020\fJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u001fJ\u0018\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rR\u00020\u00000\u000bH\u0002J*\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001d2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u001dH\u0002J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010&\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fJ\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\fH\u0014J(\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020(2\u0016\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rR\u00020\u00000\u000bH\u0002R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rR\u00020\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository;", "Lcom/android/ide/common/repository/NetworkCache;", "cacheDir", "Ljava/nio/file/Path;", "networkTimeoutMs", "", "cacheExpiryHours", "useNetwork", "", "(Ljava/nio/file/Path;IIZ)V", "packageMap", "", "", "Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "findArtifact", "Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "groupId", "artifactId", "findCompileDependencies", "", "Lcom/android/ide/common/gradle/Dependency;", "version", "Lcom/android/ide/common/gradle/Version;", "findVersion", "dependency", "filter", "Ljava/util/function/Predicate;", "predicate", "allowPreview", "Lkotlin/Function1;", "getAgpVersions", "", "Lcom/android/ide/common/repository/AgpVersion;", "getArtifacts", "getGroups", "getPackageMap", "getSnapshotVersionFilter", "getVersions", "hasGroupId", "readDefaultData", "Ljava/io/InputStream;", "relative", "readMasterIndex", "", "stream", "map", "ArtifactInfo", "Companion", "PackageInfo", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nGoogleMavenRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleMavenRepository.kt\ncom/android/ide/common/repository/GoogleMavenRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,356:1\n1#2:357\n*E\n"})
public abstract class GoogleMavenRepository
extends NetworkCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<String, PackageInfo> packageMap;
    @NotNull
    public static final String MAVEN_GOOGLE_CACHE_DIR_KEY = "maven.google";

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours, boolean useNetwork) {
        super(GoogleMavenRepositoryKt.GMAVEN_BASE_URL, MAVEN_GOOGLE_CACHE_DIR_KEY, cacheDir, networkTimeoutMs, cacheExpiryHours, useNetwork);
    }

    public /* synthetic */ GoogleMavenRepository(Path path, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            path = null;
        }
        if ((n3 & 2) != 0) {
            n = 3000;
        }
        if ((n3 & 4) != 0) {
            n2 = (int)TimeUnit.DAYS.toHours(1L);
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        this(path, n, n2, bl);
    }

    public final boolean hasGroupId(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.getPackageMap().get(groupId) != null;
    }

    @Nullable
    public final Version findVersion(@NotNull Dependency dependency, @Nullable Predicate<Version> filter2) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        return this.findVersion(dependency, filter2, dependency.getExplicitlyIncludesPreview());
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, Dependency dependency, Predicate predicate, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 2) != 0) {
            predicate = null;
        }
        return googleMavenRepository.findVersion(dependency, predicate);
    }

    @Nullable
    public final Version findVersion(@NotNull Dependency dependency, @Nullable Predicate<Version> predicate, boolean allowPreview) {
        Function1 filter2;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        String string = dependency.getGroup();
        if (string == null) {
            return null;
        }
        String group = string;
        Function1 function1 = filter2 = dependency.getHasExplicitDistinctUpperBound() ? (Function1)new Function1<Version, Boolean>(dependency, predicate){
            final /* synthetic */ Dependency $dependency;
            final /* synthetic */ Predicate<Version> $predicate;
            {
                this.$dependency = $dependency;
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Version v) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                if (GoogleMavenRepository.access$findVersion$predicate(this.$predicate, v)) {
                    RichVersion richVersion = this.$dependency.getVersion();
                    if (richVersion != null ? richVersion.contains(v) : true) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        } : (Function1)new Function1<Version, Boolean>(dependency, predicate){
            final /* synthetic */ Dependency $dependency;
            final /* synthetic */ Predicate<Version> $predicate;
            {
                this.$dependency = $dependency;
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Version v) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                if (GoogleMavenRepository.access$findVersion$predicate(this.$predicate, v)) {
                    RichVersion richVersion = this.$dependency.getVersion();
                    if (richVersion != null ? richVersion.accepts(v) : true) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        if (Intrinsics.areEqual((Object)group, (Object)"androidx.work")) {
            Range range = Range.closedOpen((Comparable)Version.Companion.parse("2.7"), (Comparable)Version.Companion.parse("2.7.0"));
            Intrinsics.checkNotNull((Object)range);
            VersionRange excludedRange = new VersionRange((Range<Version>)range);
            RichVersion richVersion = dependency.getVersion();
            boolean bl = richVersion != null ? richVersion.accepts(Version.Companion.prefixInfimum("2.7.0")) : false;
            if (bl) {
                ArtifactInfo artifactInfo = this.findArtifact(group, dependency.getName());
                if (artifactInfo == null) {
                    return null;
                }
                ArtifactInfo artifactInfo2 = artifactInfo;
                Function1<Version, Boolean> snapshotFilter = this.getSnapshotVersionFilter(null);
                Version version = (Version)SequencesKt.maxOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter(artifactInfo2.getVersions(), (Function1)((Function1)new Function1<Version, Boolean>(excludedRange, (Function1<? super Version, Boolean>)filter2){
                    final /* synthetic */ VersionRange $excludedRange;
                    final /* synthetic */ Function1<Version, Boolean> $filter;
                    {
                        this.$excludedRange = $excludedRange;
                        this.$filter = $filter;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Version v) {
                        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                        return !this.$excludedRange.contains(v) && (Boolean)this.$filter.invoke((Object)v) != false;
                    }
                })), (Function1)((Function1)new Function1<Version, Boolean>(allowPreview){
                    final /* synthetic */ boolean $allowPreview;
                    {
                        this.$allowPreview = $allowPreview;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Version it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$allowPreview || !it.isPreview();
                    }
                })), (Function1)((Function1)new Function1<Version, Boolean>(snapshotFilter){
                    final /* synthetic */ Function1<Version, Boolean> $snapshotFilter;
                    {
                        this.$snapshotFilter = $snapshotFilter;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Version it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return (Boolean)this.$snapshotFilter.invoke((Object)it);
                    }
                })));
                if (version != null) {
                    Version it = version;
                    boolean bl2 = false;
                    return it;
                }
            }
        }
        Function1<Version, Boolean> compositeFilter = this.getSnapshotVersionFilter((Function1<? super Version, Boolean>)filter2);
        return this.findVersion(group, dependency.getName(), compositeFilter, allowPreview);
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, Dependency dependency, Predicate predicate, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(dependency, predicate, bl);
    }

    private final Function1<Version, Boolean> getSnapshotVersionFilter(Function1<? super Version, Boolean> filter2) {
        return (Function1)new Function1<Version, Boolean>(filter2){
            final /* synthetic */ Function1<Version, Boolean> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Version candidate) {
                Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
                return !candidate.isSnapshot() && (this.$filter == null || (Boolean)this.$filter.invoke((Object)candidate) != false);
            }
        };
    }

    @Nullable
    public final Version findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<Version> filter2, boolean allowPreview) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        return this.findVersion(groupId, artifactId, (Function1<? super Version, Boolean>)((Function1)new Function1<Version, Boolean>(filter2){
            final /* synthetic */ Predicate<Version> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Version it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Predicate<Version> predicate = this.$filter;
                return !(predicate != null ? !predicate.test(it) : false);
            }
        }), allowPreview);
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, String string, String string2, Predicate predicate, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(string, string2, predicate, bl);
    }

    @Nullable
    public final Version findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Function1<? super Version, Boolean> filter2, boolean allowPreview) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        ArtifactInfo artifactInfo = this.findArtifact(groupId, artifactId);
        if (artifactInfo == null) {
            return null;
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return artifactInfo2.findVersion(filter2, allowPreview);
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, String string, String string2, Function1 function1, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(string, string2, (Function1<? super Version, Boolean>)function1, bl);
    }

    @NotNull
    public final Set<String> getGroups() {
        return CollectionsKt.toSet((Iterable)this.getPackageMap().keySet());
    }

    @NotNull
    public final Set<String> getArtifacts(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        Set set = packageInfo != null ? packageInfo.artifacts() : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<Version> getVersions(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        ArtifactInfo artifactInfo = this.findArtifact(groupId, artifactId);
        if (artifactInfo == null) {
            return SetsKt.emptySet();
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return SequencesKt.toSet(artifactInfo2.getVersions());
    }

    @NotNull
    public final Set<AgpVersion> getAgpVersions() {
        ArtifactInfo artifactInfo = this.findArtifact("com.android.tools.build", "gradle");
        if (artifactInfo == null) {
            return SetsKt.emptySet();
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return SequencesKt.toSet(artifactInfo2.getAgpVersions());
    }

    @NotNull
    public final List<Dependency> findCompileDependencies(@NotNull String groupId, @NotNull String artifactId, @NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        if (packageInfo == null) {
            return CollectionsKt.emptyList();
        }
        PackageInfo packageInfo2 = packageInfo;
        ArtifactInfo artifactInfo = packageInfo2.findArtifact(artifactId);
        Object object = artifactInfo;
        if (object == null || (object = ((ArtifactInfo)object).findCompileDependencies(version, packageInfo2)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final ArtifactInfo findArtifact(String groupId, String artifactId) {
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        if (packageInfo == null) {
            return null;
        }
        PackageInfo packageInfo2 = packageInfo;
        return packageInfo2.findArtifact(artifactId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, PackageInfo> getPackageMap() {
        if (this.packageMap == null) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)28);
            InputStream inputStream = NetworkCache.findData$default(this, "master-index.xml", false, 2, null);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)map);
                    this.readMasterIndex(it, map);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            this.packageMap = map;
        }
        Map<String, PackageInfo> map = this.packageMap;
        Intrinsics.checkNotNull(map);
        return map;
    }

    @Override
    @Nullable
    protected InputStream readDefaultData(@NotNull String relative) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        return GoogleMavenRepository.class.getResourceAsStream("/versions-offline/" + relative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readMasterIndex(InputStream stream, Map<String, PackageInfo> map) {
        try {
            Closeable closeable = stream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                KXmlParser parser = new KXmlParser();
                parser.setInput(it, "UTF-8");
                while (parser.next() != 1) {
                    int eventType = parser.getEventType();
                    if (eventType == 3 && parser.getDepth() > 1) {
                        String tag = parser.getName();
                        Intrinsics.checkNotNull((Object)tag);
                        PackageInfo packageInfo = new PackageInfo(tag);
                        map.put(tag, packageInfo);
                        continue;
                    }
                    if (eventType == 2) continue;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        catch (IOException e) {
            this.error(e, null);
        }
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours) {
        this(cacheDir, networkTimeoutMs, cacheExpiryHours, false, 8, null);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs) {
        this(cacheDir, networkTimeoutMs, 0, false, 12, null);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir) {
        this(cacheDir, 0, 0, false, 14, null);
    }

    @JvmOverloads
    public GoogleMavenRepository() {
        this(null, 0, 0, false, 15, null);
    }

    private static final boolean findVersion$predicate(Predicate<Version> $predicate, Version version) {
        Predicate<Version> predicate = $predicate;
        return predicate != null ? predicate.test(version) : true;
    }

    public static final /* synthetic */ boolean access$findVersion$predicate(Predicate $predicate, Version version) {
        return GoogleMavenRepository.findVersion$predicate($predicate, version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\b2\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001cJ(\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020\u0016J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\"J\t\u0010$\u001a\u00020%H\u00d6\u0001J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\b2\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001cH\u0002J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R-\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006("}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "", "id", "", "versions", "(Ljava/lang/String;Ljava/lang/String;)V", "dependencyInfo", "Ljava/util/HashMap;", "Lcom/android/ide/common/gradle/Version;", "", "Lcom/android/ide/common/gradle/Dependency;", "getDependencyInfo", "()Ljava/util/HashMap;", "dependencyInfo$delegate", "Lkotlin/Lazy;", "getId", "()Ljava/lang/String;", "getVersions", "component1", "component2", "copy", "equals", "", "other", "findCompileDependencies", "version", "packageInfo", "Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "findVersion", "filter", "Lkotlin/Function1;", "allowPreview", "getAgpVersions", "Lkotlin/sequences/Sequence;", "Lcom/android/ide/common/repository/AgpVersion;", "hashCode", "", "loadCompileDependencies", "toString", "sdk-common"})
    private static final class ArtifactInfo {
        @NotNull
        private final String id;
        @NotNull
        private final String versions;
        @NotNull
        private final Lazy dependencyInfo$delegate;

        public ArtifactInfo(@NotNull String id, @NotNull String versions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)versions, (String)"versions");
            this.id = id;
            this.versions = versions;
            this.dependencyInfo$delegate = LazyKt.lazy((Function0)dependencyInfo.2.INSTANCE);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getVersions() {
            return this.versions;
        }

        private final HashMap<Version, List<Dependency>> getDependencyInfo() {
            Lazy lazy = this.dependencyInfo$delegate;
            return (HashMap)lazy.getValue();
        }

        @NotNull
        public final Sequence<Version> getVersions() {
            String[] stringArray = new String[]{","};
            return SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)this.versions, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Function1)getVersions.1.INSTANCE);
        }

        @NotNull
        public final Sequence<AgpVersion> getAgpVersions() {
            String[] stringArray = new String[]{","};
            return SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)this.versions, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Function1)getAgpVersions.1.INSTANCE));
        }

        @Nullable
        public final Version findVersion(@Nullable Function1<? super Version, Boolean> filter2, boolean allowPreview) {
            return (Version)SequencesKt.maxOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter(this.getVersions(), (Function1)((Function1)new Function1<Version, Boolean>(filter2){
                final /* synthetic */ Function1<Version, Boolean> $filter;
                {
                    this.$filter = $filter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Version it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$filter == null || (Boolean)this.$filter.invoke((Object)it) != false;
                }
            })), (Function1)((Function1)new Function1<Version, Boolean>(allowPreview){
                final /* synthetic */ boolean $allowPreview;
                {
                    this.$allowPreview = $allowPreview;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Version it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$allowPreview || !it.isPreview();
                }
            })));
        }

        public static /* synthetic */ Version findVersion$default(ArtifactInfo artifactInfo, Function1 function1, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return artifactInfo.findVersion((Function1<? super Version, Boolean>)function1, bl);
        }

        @NotNull
        public final List<Dependency> findCompileDependencies(@NotNull Version version, @NotNull PackageInfo packageInfo) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)packageInfo, (String)"packageInfo");
            List<Dependency> list = this.getDependencyInfo().get(version);
            if (list == null) {
                list = this.loadCompileDependencies(version, packageInfo);
            }
            return list;
        }

        private final List<Dependency> loadCompileDependencies(Version version, PackageInfo packageInfo) {
            if (this.findVersion((Function1<? super Version, Boolean>)((Function1)new Function1<Version, Boolean>(version){
                final /* synthetic */ Version $version;
                {
                    this.$version = $version;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Version it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$version);
                }
            }), true) == null) {
                return CollectionsKt.emptyList();
            }
            List<Dependency> dependencies = packageInfo.loadCompileDependencies(this.id, version);
            ((Map)this.getDependencyInfo()).put(version, dependencies);
            return dependencies;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.versions;
        }

        @NotNull
        public final ArtifactInfo copy(@NotNull String id, @NotNull String versions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)versions, (String)"versions");
            return new ArtifactInfo(id, versions);
        }

        public static /* synthetic */ ArtifactInfo copy$default(ArtifactInfo artifactInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = artifactInfo.id;
            }
            if ((n & 2) != 0) {
                string2 = artifactInfo.versions;
            }
            return artifactInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ArtifactInfo(id=" + this.id + ", versions=" + this.versions + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.versions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArtifactInfo)) {
                return false;
            }
            ArtifactInfo artifactInfo = (ArtifactInfo)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)artifactInfo.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.versions, (Object)artifactInfo.versions);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$Companion;", "", "()V", "MAVEN_GOOGLE_CACHE_DIR_KEY", "", "sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0003J\u001c\u0010\u0015\u001a\u00020\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0017H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010$\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0017H\u0002R'\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "", "pkg", "", "(Lcom/android/ide/common/repository/GoogleMavenRepository;Ljava/lang/String;)V", "artifacts", "", "Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "getArtifacts", "()Ljava/util/Map;", "artifacts$delegate", "Lkotlin/Lazy;", "getPkg", "()Ljava/lang/String;", "", "check", "", "item", "name", "findArtifact", "id", "initializeIndex", "map", "", "loadCompileDependencies", "", "Lcom/android/ide/common/gradle/Dependency;", "version", "Lcom/android/ide/common/gradle/Version;", "readCompileDependenciesFromPomFile", "stream", "Ljava/io/InputStream;", "file", "readCompileDependency", "parser", "Lorg/kxml2/io/KXmlParser;", "readGroupData", "sdk-common"})
    @SourceDebugExtension(value={"SMAP\nGoogleMavenRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleMavenRepository.kt\ncom/android/ide/common/repository/GoogleMavenRepository$PackageInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,356:1\n1549#2:357\n1620#2,3:358\n1#3:361\n*S KotlinDebug\n*F\n+ 1 GoogleMavenRepository.kt\ncom/android/ide/common/repository/GoogleMavenRepository$PackageInfo\n*L\n253#1:357\n253#1:358,3\n*E\n"})
    private final class PackageInfo {
        @NotNull
        private final String pkg;
        @NotNull
        private final Lazy artifacts$delegate;

        public PackageInfo(String pkg) {
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            this.pkg = pkg;
            this.artifacts$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HashMap<String, ArtifactInfo>>(this){
                final /* synthetic */ PackageInfo this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final HashMap<String, ArtifactInfo> invoke() {
                    HashMap<String, ArtifactInfo> map = new HashMap<String, ArtifactInfo>();
                    PackageInfo.access$initializeIndex(this.this$0, map);
                    return map;
                }
            }));
        }

        @NotNull
        public final String getPkg() {
            return this.pkg;
        }

        private final Map<String, ArtifactInfo> getArtifacts() {
            Lazy lazy = this.artifacts$delegate;
            return (Map)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> artifacts() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getArtifacts().values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ArtifactInfo artifactInfo = (ArtifactInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        @Nullable
        public final ArtifactInfo findArtifact(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return this.getArtifacts().get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<Dependency> loadCompileDependencies(@NotNull String id, @NotNull Version version) {
            Object object;
            block9: {
                block8: {
                    List<Dependency> list;
                    Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                    Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                    String file = StringsKt.replace$default((String)this.pkg, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + id + "/" + version + "/" + id + "-" + version + ".pom";
                    InputStream stream = NetworkCache.findData$default(GoogleMavenRepository.this, file, false, 2, null);
                    object = stream;
                    if (object == null) break block8;
                    Closeable closeable = (Closeable)object;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl = false;
                        List<Dependency> list2 = this.readCompileDependenciesFromPomFile(stream, file);
                        list = list2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    object = list;
                    if (list != null) break block9;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void initializeIndex(Map<String, ArtifactInfo> map) {
            InputStream stream;
            InputStream inputStream = stream = NetworkCache.findData$default(GoogleMavenRepository.this, StringsKt.replace$default((String)this.pkg, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/group-index.xml", false, 2, null);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    this.readGroupData(stream, map);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }

        private final void readGroupData(InputStream stream, Map<String, ArtifactInfo> map) {
            try {
                KXmlParser parser = new KXmlParser();
                parser.setInput(stream, "UTF-8");
                while (parser.next() != 1) {
                    int eventType = parser.getEventType();
                    if (eventType != 2) continue;
                    String artifactId = parser.getName();
                    String versions = parser.getAttributeValue(null, "versions");
                    if (versions == null) continue;
                    Intrinsics.checkNotNull((Object)artifactId);
                    ArtifactInfo artifactInfo = new ArtifactInfo(artifactId, versions);
                    map.put(artifactId, artifactInfo);
                }
            }
            catch (XmlPullParserException parser) {
            }
            catch (Exception e) {
                GoogleMavenRepository.this.error(e, null);
            }
        }

        private final List<Dependency> readCompileDependenciesFromPomFile(InputStream stream, String file) {
            List list;
            try {
                List dependencies = new ArrayList();
                KXmlParser parser = new KXmlParser();
                parser.setInput(stream, "UTF-8");
                while (parser.next() != 1) {
                    Dependency dependency;
                    int eventType = parser.getEventType();
                    if (eventType != 2 || !Intrinsics.areEqual((Object)parser.getName(), (Object)"dependency") || (dependency = this.readCompileDependency(parser)) == null) continue;
                    dependencies.add(dependency);
                }
            }
            catch (XmlPullParserException e) {
                list = CollectionsKt.emptyList();
            }
            catch (Exception e) {
                GoogleMavenRepository.this.error(e, "Problem reading POM file: " + file);
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        private final Dependency readCompileDependency(KXmlParser parser) {
            String groupId = "";
            String artifactId = "";
            String version = "";
            String scope = "";
            block16: while (parser.next() != 1) {
                switch (parser.getEventType()) {
                    case 2: {
                        String string = parser.getName();
                        if (string == null) continue block16;
                        int n = -1;
                        switch (string.hashCode()) {
                            case 293428218: {
                                if (string.equals("groupId")) {
                                    n = 1;
                                }
                                break;
                            }
                            case 109264468: {
                                if (string.equals("scope")) {
                                    n = 2;
                                }
                                break;
                            }
                            case 240640653: {
                                if (string.equals("artifactId")) {
                                    n = 3;
                                }
                                break;
                            }
                            case 351608024: {
                                if (string.equals("version")) {
                                    n = 4;
                                }
                                break;
                            }
                        }
                        switch (n) {
                            case 1: {
                                Intrinsics.checkNotNullExpressionValue((Object)parser.nextText(), (String)"nextText(...)");
                                break;
                            }
                            case 3: {
                                Intrinsics.checkNotNullExpressionValue((Object)parser.nextText(), (String)"nextText(...)");
                                break;
                            }
                            case 4: {
                                Intrinsics.checkNotNullExpressionValue((Object)parser.nextText(), (String)"nextText(...)");
                                break;
                            }
                            case 2: {
                                Intrinsics.checkNotNullExpressionValue((Object)parser.nextText(), (String)"nextText(...)");
                            }
                        }
                        continue block16;
                    }
                    case 3: {
                        if (!Intrinsics.areEqual((Object)parser.getName(), (Object)"dependency")) continue block16;
                        this.check(groupId, "groupId");
                        this.check(artifactId, "artifactId");
                        this.check(version, "version");
                        return Intrinsics.areEqual((Object)scope, (Object)"compile") ? new Dependency(groupId, artifactId, RichVersion.Companion.parse(version), null, null, 24, null) : null;
                    }
                }
            }
            throw new RuntimeException("Unexpected end of file");
        }

        private final void check(String item, String name) {
            if (((CharSequence)item).length() == 0) {
                throw new RuntimeException("Missing " + name + " field");
            }
        }

        public static final /* synthetic */ void access$initializeIndex(PackageInfo $this, Map map) {
            $this.initializeIndex(map);
        }
    }
}

