/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.ide.common.resources.CopyToOutputDirectoryResourceCompilationService;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergeWriter;
import com.android.ide.common.resources.MergedResourceWriterRequest;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.RelativeResourceUtils;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourcePreprocessor;
import com.android.ide.common.workers.ExecutorServiceAdapter;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergedResourceWriter
extends MergeWriter<ResourceMergerItem, FileGenerationParameters> {
    private MergingLog mMergingLog;
    private DocumentBuilderFactory mFactory;
    private ListMultimap<String, ResourceMergerItem> mValuesResMap;
    private Set<String> mQualifierWithDeletedValues;
    private final ConcurrentLinkedDeque<Future<File>> mCompiling;
    private final File mCompiledFileMapFile;
    private final Properties mCompiledFileMap;
    private final MergedResourceWriterRequest mergeWriterRequest;
    private final ConcurrentLinkedQueue<CompileResourceRequest> mCompileResourceRequests = new ConcurrentLinkedQueue();

    public MergedResourceWriter(MergedResourceWriterRequest request) {
        super(request.getRootFolder(), request.getWorkerExecutor());
        this.mergeWriterRequest = request;
        this.mMergingLog = request.getBlameLog();
        this.mCompiling = new ConcurrentLinkedDeque();
        this.mCompiledFileMapFile = new File(this.mergeWriterRequest.getTemporaryDirectory(), "compile-file-map.properties");
        this.mCompiledFileMap = new Properties();
        if (this.mCompiledFileMapFile.exists()) {
            try (FileReader fr = new FileReader(this.mCompiledFileMapFile);){
                this.mCompiledFileMap.load(fr);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static MergedResourceWriter createWriterWithoutPngCruncher(File rootFolder, File publicFile, File blameLogFolder, ResourcePreprocessor preprocessor, File temporaryDirectory, Map<String, String> moduleSourceSet, String packageName) {
        return MergedResourceWriter.createWriterWithoutPngCruncher(null, rootFolder, publicFile, blameLogFolder, preprocessor, temporaryDirectory, moduleSourceSet);
    }

    public static MergedResourceWriter createWriterWithoutPngCruncher(ExecutorServiceAdapter executorServiceAdapter, File rootFolder, File publicFile, File blameLogFolder, ResourcePreprocessor preprocessor, File temporaryDirectory, Map<String, String> moduleSourceSet) {
        return new MergedResourceWriter(new MergedResourceWriterRequest(new ExecutorServiceAdapter((ExecutorService)MoreExecutors.newDirectExecutorService()), rootFolder, publicFile, blameLogFolder != null ? new MergingLog(blameLogFolder, moduleSourceSet) : null, preprocessor, CopyToOutputDirectoryResourceCompilationService.INSTANCE, temporaryDirectory, null, null, false, false, moduleSourceSet));
    }

    @Override
    public void start(DocumentBuilderFactory factory) throws MergeConsumer.ConsumerException {
        super.start(factory);
        this.mValuesResMap = ArrayListMultimap.create();
        this.mQualifierWithDeletedValues = Sets.newHashSet();
        this.mFactory = factory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void end() throws MergeConsumer.ConsumerException {
        File tmpDir;
        super.end();
        try {
            tmpDir = new File(this.mergeWriterRequest.getTemporaryDirectory(), "stripped.dir");
            try {
                FileUtils.cleanOutputDir((File)tmpDir);
            }
            catch (IOException e) {
                throw new MergeConsumer.ConsumerException(e);
            }
        }
        catch (Exception e) {
            throw new MergeConsumer.ConsumerException(e);
        }
        while (!this.mCompileResourceRequests.isEmpty()) {
            CompileResourceRequest request = this.mCompileResourceRequests.poll();
            try {
                File fileToCompile = request.getInputFile();
                if (this.mMergingLog != null) {
                    File destination = this.mergeWriterRequest.getResourceCompilationService().compileOutputFor(request);
                    this.mMergingLog.logCopy(fileToCompile, this.getSourceFilePath(fileToCompile), destination, this.getSourceFilePath(destination));
                }
                if (this.mergeWriterRequest.getDataBindingExpressionRemover() != null && request.getInputDirectoryName().startsWith("layout") && request.getInputFile().getName().endsWith(".xml")) {
                    File strippedLayoutFolder = new File(tmpDir, request.getInputDirectoryName());
                    File strippedLayout = new File(strippedLayoutFolder, request.getInputFile().getName());
                    boolean removedDataBinding = this.mergeWriterRequest.getDataBindingExpressionRemover().processSingleFile(request.getInputFile(), strippedLayout, request.getInputFileIsFromDependency());
                    if (removedDataBinding) {
                        if (this.mMergingLog != null) {
                            this.mMergingLog.logCopy(request.getInputFile(), this.getSourceFilePath(request.getInputFile()), strippedLayout, this.getSourcePath(strippedLayout));
                        }
                        fileToCompile = strippedLayout;
                    } else {
                        this.mergeWriterRequest.getDataBindingExpressionRemover().processFileWithNoDataBinding(request.getInputFile());
                    }
                }
                if (this.mergeWriterRequest.getNotCompiledOutputDirectory() != null) {
                    File typeDir = new File(this.mergeWriterRequest.getNotCompiledOutputDirectory(), request.getInputDirectoryName());
                    FileUtils.mkdirs((File)typeDir);
                    FileUtils.copyFileToDirectory((File)fileToCompile, (File)typeDir);
                }
                CompileResourceRequest compileResourceRequest = new CompileResourceRequest(fileToCompile, request.getOutputDirectory(), request.getInputDirectoryName(), request.getInputFileIsFromDependency(), this.mergeWriterRequest.getPseudoLocalesEnabled(), this.mergeWriterRequest.getCrunchPng(), (Map<SourcePosition, SourceFilePosition>)ImmutableMap.of(), request.getInputFile());
                if (!this.mergeWriterRequest.getModuleSourceSets().isEmpty()) {
                    compileResourceRequest.useRelativeSourcePath(this.mergeWriterRequest.getModuleSourceSets());
                }
                this.mergeWriterRequest.getResourceCompilationService().submitCompile(compileResourceRequest);
                this.mCompiledFileMap.put(compileResourceRequest.getSourcePath(), this.mergeWriterRequest.getResourceCompilationService().compileOutputFor(request).getPath());
            }
            catch (Exception e) {
                throw MergingException.wrapException(e).withFile(request.getInputFile()).build();
            }
        }
        if (this.mMergingLog != null) {
            try {
                this.mMergingLog.write();
            }
            catch (IOException e) {
                throw new MergeConsumer.ConsumerException(e);
            }
            this.mMergingLog = null;
        }
        this.mValuesResMap = null;
        this.mQualifierWithDeletedValues = null;
        this.mFactory = null;
        try (FileWriter fw = new FileWriter(this.mCompiledFileMapFile);){
            this.mCompiledFileMap.store(fw, null);
            return;
        }
        catch (IOException e) {
            throw new MergeConsumer.ConsumerException(e);
        }
    }

    private String getSourceFilePath(File inputFile) {
        return this.mergeWriterRequest.getModuleSourceSets().isEmpty() ? inputFile.getAbsolutePath() : RelativeResourceUtils.getRelativeSourceSetPath(inputFile, this.mergeWriterRequest.getModuleSourceSets());
    }

    @Override
    public boolean ignoreItemInMerge(ResourceMergerItem item) {
        return item.getIgnoredFromDiskMerge();
    }

    @Override
    public void addItem(ResourceMergerItem item) throws MergeConsumer.ConsumerException {
        DataFile.FileType type = item.getSourceType();
        if (type == DataFile.FileType.XML_VALUES) {
            this.mValuesResMap.put((Object)item.getQualifiers(), (Object)item);
        } else {
            Preconditions.checkState((item.getSourceFile() != null ? 1 : 0) != 0);
            if (item.isTouched()) {
                File file = item.getFile();
                String folderName = MergedResourceWriter.getFolderName(item);
                if (type == DataFile.FileType.GENERATED_FILES) {
                    try {
                        FileGenerationParameters workItem = new FileGenerationParameters(item, this.mergeWriterRequest.getPreprocessor());
                        if (workItem.resourceItem.getSourceFile() != null) {
                            this.getExecutor().submit(new FileGenerationWorkAction(workItem));
                        }
                    }
                    catch (Exception e) {
                        throw new MergeConsumer.ConsumerException((Throwable)e, ((ResourceFile)item.getSourceFile()).getFile());
                    }
                }
                CompileResourceRequest crunchRequest = new CompileResourceRequest(file, this.getRootFolder(), folderName, item.mIsFromDependency);
                if (!this.mergeWriterRequest.getModuleSourceSets().isEmpty()) {
                    crunchRequest.useRelativeSourcePath(this.mergeWriterRequest.getModuleSourceSets());
                }
                this.mCompileResourceRequests.add(crunchRequest);
            }
        }
    }

    @Override
    public void removeItem(ResourceMergerItem removedItem, ResourceMergerItem replacedBy) {
        DataFile.FileType removedType = removedItem.getSourceType();
        DataFile.FileType replacedType = replacedBy != null ? replacedBy.getSourceType() : null;
        switch (removedType) {
            case SINGLE_FILE: 
            case GENERATED_FILES: {
                File replacedFile;
                File removedFile;
                if ((replacedType == DataFile.FileType.SINGLE_FILE || replacedType == DataFile.FileType.GENERATED_FILES) && (removedFile = this.getResourceOutputFile(removedItem)).equals(replacedFile = this.getResourceOutputFile(replacedBy))) break;
                this.removeOutFile(removedItem);
                break;
            }
            case XML_VALUES: {
                this.mQualifierWithDeletedValues.add(removedItem.getQualifiers());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    protected void postWriteAction() throws MergeConsumer.ConsumerException {
        File tmpDir = new File(this.mergeWriterRequest.getTemporaryDirectory(), "merged.dir");
        try {
            FileUtils.cleanOutputDir((File)tmpDir);
        }
        catch (IOException e) {
            throw new MergeConsumer.ConsumerException(e);
        }
        for (String key : this.mValuesResMap.keySet()) {
            boolean mustWriteFile = this.mQualifierWithDeletedValues.remove(key);
            List items = this.mValuesResMap.get((Object)key);
            if (!mustWriteFile) {
                for (ResourceMergerItem item : items) {
                    if (!item.isTouched()) continue;
                    mustWriteFile = true;
                    break;
                }
            }
            if (!mustWriteFile) continue;
            try {
                boolean mkdirs;
                String folderName = key.isEmpty() ? ResourceFolderType.VALUES.getName() : ResourceFolderType.VALUES.getName() + "-" + key;
                File valuesFolder = new File(tmpDir, folderName);
                File outFile = new File(valuesFolder, folderName + ".xml");
                FileUtils.mkdirs((File)valuesFolder);
                DocumentBuilder builder = this.mFactory.newDocumentBuilder();
                Document document = builder.newDocument();
                String publicTag = ResourceType.PUBLIC.getName();
                ArrayList publicNodes = null;
                Element rootNode = document.createElement("resources");
                document.appendChild(rootNode);
                Collections.sort(items);
                for (ResourceMergerItem item : items) {
                    Node nodeValue = item.getValue();
                    if (nodeValue != null && publicTag.equals(nodeValue.getNodeName())) {
                        if (publicNodes == null) {
                            publicNodes = Lists.newArrayList();
                        }
                        publicNodes.add(nodeValue);
                        continue;
                    }
                    rootNode.appendChild(document.createTextNode("\n    "));
                    ResourceFile source = (ResourceFile)item.getSourceFile();
                    Node adoptedNode = NodeUtils.adoptNode(document, nodeValue);
                    if (source != null) {
                        if (adoptedNode.hasChildNodes()) {
                            for (int i2 = 0; i2 < adoptedNode.getChildNodes().getLength(); ++i2) {
                                Node child = adoptedNode.getChildNodes().item(i2);
                                if (!(child instanceof Comment)) continue;
                                adoptedNode.removeChild(child);
                            }
                            adoptedNode.normalize();
                        }
                        XmlUtils.attachSourceFile((Node)adoptedNode, (SourceFile)new SourceFile(source.getFile()));
                    }
                    rootNode.appendChild(adoptedNode);
                }
                rootNode.appendChild(document.createTextNode("\n"));
                LinkedHashMap blame = this.mMergingLog == null ? null : Maps.newLinkedHashMap();
                String content = blame != null ? XmlUtils.toXml((Node)document, (Map)blame) : XmlUtils.toXml((Node)document);
                Files.asCharSink((File)outFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content);
                CompileResourceRequest request = new CompileResourceRequest(outFile, this.getRootFolder(), folderName, null, this.mergeWriterRequest.getPseudoLocalesEnabled(), this.mergeWriterRequest.getCrunchPng(), blame != null ? blame : ImmutableMap.of(), outFile);
                if (!this.mergeWriterRequest.getModuleSourceSets().isEmpty()) {
                    request.useRelativeSourcePath(this.mergeWriterRequest.getModuleSourceSets());
                }
                if (this.mergeWriterRequest.getNotCompiledOutputDirectory() != null) {
                    File typeDir = new File(this.mergeWriterRequest.getNotCompiledOutputDirectory(), folderName);
                    FileUtils.mkdirs((File)typeDir);
                    FileUtils.copyFileToDirectory((File)outFile, (File)typeDir);
                }
                if (blame != null) {
                    File file = this.mergeWriterRequest.getResourceCompilationService().compileOutputFor(request);
                    String fileSourcePath = this.getSourceFilePath(file);
                    this.mMergingLog.logSource(new SourceFile(file), fileSourcePath, blame);
                    String outFileSourcePath = this.getSourceFilePath(outFile);
                    this.mMergingLog.logSource(new SourceFile(outFile), outFileSourcePath, blame);
                }
                this.mergeWriterRequest.getResourceCompilationService().submitCompile(request);
                if (publicNodes == null || this.mergeWriterRequest.getPublicFile() == null) continue;
                int size = publicNodes.size();
                StringBuilder sb = new StringBuilder(size * 80);
                for (Node node : publicNodes) {
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String name = element.getAttribute("name");
                    String type = element.getAttribute("type");
                    if (name.isEmpty() || type.isEmpty()) continue;
                    String flattenedName = name.replace('.', '_');
                    sb.append(type).append(' ').append(flattenedName).append('\n');
                }
                File parentFile = this.mergeWriterRequest.getPublicFile().getParentFile();
                if (!parentFile.exists() && !(mkdirs = parentFile.mkdirs())) {
                    throw new IOException("Could not create " + parentFile);
                }
                String text = sb.toString();
                Files.asCharSink((File)this.mergeWriterRequest.getPublicFile(), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)text);
            }
            catch (Exception e) {
                throw new MergeConsumer.ConsumerException(e);
            }
        }
        for (String key : this.mQualifierWithDeletedValues) {
            String folderName;
            String string = folderName = key != null && !key.isEmpty() ? ResourceFolderType.VALUES.getName() + "-" + key : ResourceFolderType.VALUES.getName();
            if (this.mergeWriterRequest.getNotCompiledOutputDirectory() != null) {
                this.removeOutFile(FileUtils.join((File)this.mergeWriterRequest.getNotCompiledOutputDirectory(), (String[])new String[]{folderName, folderName + ".xml"}));
            }
            CompileResourceRequest compileResourceRequest = new CompileResourceRequest(FileUtils.join((File)this.getRootFolder(), (String[])new String[]{folderName, folderName + ".xml"}), this.getRootFolder(), folderName);
            if (!this.mergeWriterRequest.getModuleSourceSets().isEmpty()) {
                compileResourceRequest.useRelativeSourcePath(this.mergeWriterRequest.getModuleSourceSets());
            }
            this.removeOutFile(this.mergeWriterRequest.getResourceCompilationService().compileOutputFor(compileResourceRequest));
        }
    }

    private String getSourcePath(File file) {
        return this.mergeWriterRequest.getModuleSourceSets().isEmpty() ? file.getAbsolutePath() : RelativeResourceUtils.getRelativeSourceSetPath(file, this.mergeWriterRequest.getModuleSourceSets());
    }

    private File getResourceOutputFile(ResourceMergerItem resourceItem) {
        File file = resourceItem.getFile();
        String compiledFilePath = this.mCompiledFileMap.getProperty(file.getAbsolutePath());
        if (compiledFilePath != null) {
            return new File(compiledFilePath);
        }
        return this.mergeWriterRequest.getResourceCompilationService().compileOutputFor(new CompileResourceRequest(file, this.getRootFolder(), MergedResourceWriter.getFolderName(resourceItem), resourceItem.mIsFromDependency));
    }

    private void removeLayoutFileFromDataBindingOutputFolder(ResourceMergerItem resourceItem) {
        File originalFile = resourceItem.getFile();
        if (!originalFile.getParentFile().getName().startsWith("layout") || !originalFile.getName().endsWith(".xml")) {
            return;
        }
        this.mergeWriterRequest.getDataBindingExpressionRemover().processRemovedFile(originalFile);
    }

    private void removeFileFromNotCompiledOutputDir(ResourceMergerItem resourceItem) {
        File originalFile = resourceItem.getFile();
        File resTypeDir = new File(this.mergeWriterRequest.getNotCompiledOutputDirectory(), originalFile.getParentFile().getName());
        File toRemove = new File(resTypeDir, originalFile.getName());
        this.removeOutFile(toRemove);
    }

    private boolean removeOutFile(ResourceMergerItem resourceItem) {
        File fileToRemove = this.getResourceOutputFile(resourceItem);
        if (this.mergeWriterRequest.getDataBindingExpressionRemover() != null) {
            this.removeLayoutFileFromDataBindingOutputFolder(resourceItem);
        }
        if (this.mergeWriterRequest.getNotCompiledOutputDirectory() != null) {
            this.removeFileFromNotCompiledOutputDir(resourceItem);
        }
        return this.removeOutFile(fileToRemove);
    }

    private boolean removeOutFile(File fileToRemove) {
        if (this.mMergingLog != null) {
            SourceFile removeSourceFile = new SourceFile(fileToRemove);
            String sourcePath2 = this.getSourceFilePath(fileToRemove);
            removeSourceFile.setOverrideSourcePath(sourcePath2);
            this.mMergingLog.logRemove(removeSourceFile);
        }
        return fileToRemove.delete();
    }

    private static String getFolderName(ResourceMergerItem resourceItem) {
        ResourceType itemType = resourceItem.getType();
        Object folderName = itemType.getName();
        String qualifiers = resourceItem.getQualifiers();
        if (!qualifiers.isEmpty()) {
            folderName = (String)folderName + "-" + qualifiers;
        }
        return folderName;
    }

    public static class FileGenerationParameters
    implements Serializable {
        public final ResourceMergerItem resourceItem;
        public final ResourcePreprocessor resourcePreprocessor;

        private FileGenerationParameters(ResourceMergerItem resourceItem, ResourcePreprocessor resourcePreprocessor) {
            this.resourceItem = resourceItem;
            this.resourcePreprocessor = resourcePreprocessor;
        }
    }

    public static class FileGenerationWorkAction
    implements WorkerExecutorFacade.WorkAction {
        private final FileGenerationParameters workItem;

        @Inject
        public FileGenerationWorkAction(FileGenerationParameters workItem) {
            this.workItem = workItem;
        }

        @Override
        public void run() {
            try {
                this.workItem.resourcePreprocessor.generateFile(this.workItem.resourceItem.getFile(), ((ResourceFile)this.workItem.resourceItem.getSourceFile()).getFile());
            }
            catch (Exception e) {
                throw new RuntimeException("Error while processing " + ((ResourceFile)this.workItem.resourceItem.getSourceFile()).getFile() + " : " + e.getMessage(), e);
            }
        }
    }
}

