/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

public class Storage {
    private long mNoBytes;

    public Storage(long amount, Unit unit) {
        this.mNoBytes = amount * unit.getNumberOfBytes();
    }

    public Storage(long amount) {
        this(amount, Unit.B);
    }

    public long getSize() {
        return this.getSizeAsUnit(Unit.B);
    }

    public Storage deepCopy() {
        return new Storage(this.mNoBytes);
    }

    public long getSizeAsUnit(Unit unit) {
        return this.mNoBytes / unit.getNumberOfBytes();
    }

    public double getPreciseSizeAsUnit(Unit unit) {
        return (double)this.mNoBytes / (double)unit.getNumberOfBytes();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Storage)) {
            return false;
        }
        return this.getSize() == ((Storage)other).getSize();
    }

    public boolean lessThan(Object other) {
        if (!(other instanceof Storage)) {
            return false;
        }
        return this.getSize() < ((Storage)other).getSize();
    }

    public int hashCode() {
        int result = 17;
        return 31 * result + (int)(this.mNoBytes ^ this.mNoBytes >>> 32);
    }

    public Unit getAppropriateUnits() {
        Unit optimalUnit = Unit.B;
        for (Unit unit : Unit.values()) {
            if (this.mNoBytes % unit.getNumberOfBytes() != 0L) break;
            optimalUnit = unit;
        }
        return optimalUnit;
    }

    public String toString() {
        Unit unit = this.getAppropriateUnits();
        return String.format("%d %s", this.getSizeAsUnit(unit), unit.getDisplayValue());
    }

    public static enum Unit {
        B("B", "B", 1L),
        KiB("KiB", "KB", 1024L),
        MiB("MiB", "MB", 0x100000L),
        GiB("GiB", "GB", 0x40000000L),
        TiB("TiB", "TB", 0x10000000000L);

        private String mValue;
        private String mDisplayValue;
        private long mNoBytes;

        private Unit(String val, String displayVal, long noBytes) {
            this.mValue = val;
            this.mDisplayValue = displayVal;
            this.mNoBytes = noBytes;
        }

        public static Unit getEnum(String val) {
            for (Unit unit : Unit.values()) {
                if (!unit.mValue.equals(val)) continue;
                return unit;
            }
            return null;
        }

        public long getNumberOfBytes() {
            return this.mNoBytes;
        }

        public String toString() {
            return this.mValue;
        }

        public String getDisplayValue() {
            return this.mDisplayValue;
        }
    }
}

