/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.targets;

import com.android.repository.Revision;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.base.Objects;
import java.io.File;
import java.util.Comparator;

public class SystemImage
implements ISystemImage {
    public static final IdDisplay DEFAULT_TAG = IdDisplay.create("default", "Default");
    public static final IdDisplay WEAR_TAG = IdDisplay.create("android-wear", "Wear OS");
    public static final IdDisplay TV_TAG = IdDisplay.create("android-tv", "Android TV");
    public static final IdDisplay AUTOMOTIVE_TAG = IdDisplay.create("android-automotive", "Android Automotive");
    public static final IdDisplay AUTOMOTIVE_PLAY_STORE_TAG = IdDisplay.create("android-automotive-playstore", "Android Automotive with Google Play");
    public static final IdDisplay CHROMEOS_TAG = IdDisplay.create("chromeos", "Chrome OS Device");
    public static final IdDisplay GOOGLE_APIS_TAG = IdDisplay.create("google_apis", "Google APIs");
    public static final IdDisplay PLAY_STORE_TAG = IdDisplay.create("google_apis_playstore", "Google Play");
    public static final IdDisplay GOOGLE_APIS_X86_TAG = IdDisplay.create("google_apis_x86", "Google APIs x86");
    private final File mLocation;
    private final IdDisplay mTag;
    private final IdDisplay mVendor;
    private final String mAbi;
    private final File[] mSkins;
    private final AndroidVersion mAndroidVersion;
    private final RepoPackage mPackage;

    public SystemImage(File location, IdDisplay tag, IdDisplay vendor, String abi, File[] skins, RepoPackage pkg) {
        this.mLocation = location;
        this.mTag = tag;
        this.mVendor = vendor;
        this.mAbi = abi;
        this.mSkins = skins;
        this.mPackage = pkg;
        TypeDetails details = pkg.getTypeDetails();
        assert (details instanceof DetailsTypes.ApiDetailsType);
        this.mAndroidVersion = ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
    }

    @Override
    public File getLocation() {
        return this.mLocation;
    }

    @Override
    public IdDisplay getTag() {
        return this.mTag;
    }

    @Override
    public IdDisplay getAddonVendor() {
        return this.mVendor;
    }

    @Override
    public String getAbiType() {
        return this.mAbi;
    }

    @Override
    public File[] getSkins() {
        return this.mSkins;
    }

    @Override
    public AndroidVersion getAndroidVersion() {
        return this.mAndroidVersion;
    }

    public RepoPackage getPackage() {
        return this.mPackage;
    }

    @Override
    public boolean obsolete() {
        return this.mPackage.obsolete();
    }

    @Override
    public boolean hasPlayStore() {
        if (PLAY_STORE_TAG.equals(this.getTag()) || AUTOMOTIVE_PLAY_STORE_TAG.equals(this.getTag())) {
            return true;
        }
        return WEAR_TAG.equals(this.getTag()) && this.mAndroidVersion.getApiLevel() >= 25 && !this.getLocation().getAbsolutePath().contains("android-wear-cn");
    }

    @Override
    public int compareTo(ISystemImage o) {
        int res = Comparator.comparing(ISystemImage::getTag).thenComparing(ISystemImage::getAbiType).thenComparing(ISystemImage::getAddonVendor, Comparator.nullsFirst(IdDisplay::compareTo)).thenComparing(ISystemImage::getLocation).compare(this, o);
        if (res != 0) {
            return res;
        }
        File[] skins = this.getSkins();
        File[] otherSkins = o.getSkins();
        for (int i = 0; i < skins.length && i < otherSkins.length; ++i) {
            res = skins[i].compareTo(otherSkins[i]);
            if (res == 0) continue;
            return res;
        }
        return skins.length - otherSkins.length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SystemImage)) {
            return false;
        }
        return this.compareTo((SystemImage)o) == 0;
    }

    public int hashCode() {
        int hashCode = Objects.hashCode((Object[])new Object[]{this.getTag(), this.getAbiType(), this.getAddonVendor(), this.getLocation()});
        for (File f : this.getSkins()) {
            hashCode *= 37;
            hashCode += f.hashCode();
        }
        return hashCode;
    }

    @Override
    public Revision getRevision() {
        return this.mPackage.getVersion();
    }
}

